(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10862,        407]
NotebookOptionsPosition[      7862,        303]
NotebookOutlinePosition[      9158,        340]
CellTagsIndexPosition[      9074,        335]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eeta" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Eeta"], "Xxi" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Xxi"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Eeta\"\>", 
       2->"\<\"Xxi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pphi", "ObjectName",
 CellID->3227],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Pphi"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Bispherical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Bispherical"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["OblateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Paraboloidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ProlateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Spherical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Toroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Toroidal"]], "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14458]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->479840659],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->29053573],

Cell[TextData[{
 Cell[BoxData["Pphi"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Bispherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34324042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "OblateSpheroidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->846987087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Paraboloidal", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5426238]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ProlateSpheroidal", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->34694730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->512622269]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->90434274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->19596078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Toroidal", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->603969996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->91988131]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25434],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eeta",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Eeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xxi",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Xxi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32071],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30106]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pphi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.7947888}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Pphi is one of the default coordinates for the Bispherical, \
OblateSpheroidal, Paraboloidal, ProlateSpheroidal, Spherical and Toroidal \
coordinate systems.", "synonyms" -> {}, "title" -> "Pphi", "type" -> "Symbol",
     "uri" -> "VectorAnalysis/ref/Pphi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3395, 112, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8939, 328}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1291, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1914, 60, 41, 1, 70, "ObjectName",
 CellID->3227],
Cell[1958, 63, 1400, 44, 70, "Usage",
 CellID->14458]
}, Open  ]],
Cell[CellGroupData[{
Cell[3395, 112, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3772, 126, 148, 5, 70, "ExampleSection",
 CellID->479840659],
Cell[3923, 133, 138, 4, 70, "Input",
 CellID->29053573],
Cell[4064, 139, 153, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[4242, 147, 117, 3, 28, "Input",
 CellID->406403560],
Cell[4362, 152, 217, 7, 36, "Output",
 CellID->34324042]
}, Open  ]],
Cell[CellGroupData[{
Cell[4616, 164, 122, 3, 28, "Input",
 CellID->566909803],
Cell[4741, 169, 222, 7, 36, "Output",
 CellID->846987087]
}, Open  ]],
Cell[CellGroupData[{
Cell[5000, 181, 116, 3, 28, "Input",
 CellID->6802135],
Cell[5119, 186, 216, 7, 36, "Output",
 CellID->5426238]
}, Open  ]],
Cell[CellGroupData[{
Cell[5372, 198, 122, 3, 70, "Input",
 CellID->34694730],
Cell[5497, 203, 222, 7, 36, "Output",
 CellID->512622269]
}, Open  ]],
Cell[CellGroupData[{
Cell[5756, 215, 114, 3, 70, "Input",
 CellID->90434274],
Cell[5873, 220, 222, 7, 36, "Output",
 CellID->19596078]
}, Open  ]],
Cell[CellGroupData[{
Cell[6132, 232, 114, 3, 70, "Input",
 CellID->603969996],
Cell[6249, 237, 217, 7, 36, "Output",
 CellID->91988131]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6527, 251, 311, 9, 70, "SeeAlsoSection",
 CellID->25434],
Cell[6841, 262, 462, 17, 70, "SeeAlso",
 CellID->1770]
}, Open  ]],
Cell[CellGroupData[{
Cell[7340, 284, 314, 9, 70, "TutorialsSection",
 CellID->32071],
Cell[7657, 295, 163, 3, 70, "Tutorials",
 CellID->30106]
}, Open  ]],
Cell[7835, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

