(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14609,        499]
NotebookOptionsPosition[     11749,        405]
NotebookOutlinePosition[     13125,        443]
CellTagsIndexPosition[     13040,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcLengthFactor" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ArcLengthFactor"], "JacobianMatrix" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianMatrix"], "JacobianDeterminant" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianDeterminant"], "Div" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], "Curl" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Biharmonic"], 
          "DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "CrossProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcLengthFactor\"\>", 
       2->"\<\"JacobianMatrix\"\>", 3->"\<\"JacobianDeterminant\"\>", 
       4->"\<\"Div\"\>", 5->"\<\"Curl\"\>", 6->"\<\"Grad\"\>", 
       7->"\<\"Laplacian\"\>", 8->"\<\"Biharmonic\"\>", 
       9->"\<\"DotProduct\"\>", 10->"\<\"CrossProduct\"\>", 
       11->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScaleFactors", "ObjectName",
 CellID->4928],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScaleFactors", "[", 
       StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the scale factors at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScaleFactors", "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the scale factors in the coordinate \
system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24572]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The scale factors are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox[
       OverscriptBox[
        StyleBox["r", "TI"], 
        StyleBox["\[Rule]", "TR"]], "TI"]}], 
     RowBox[{"\[PartialD]", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["i", "TI"]]}],
     MultilineFunction->None], "\[RightBracketingBar]"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["2", "TR"]], ",", 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " are the coordinates of the coordinate system ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->29284],

Cell[TextData[{
 "The coordinates of ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " should be given in the coordinate system ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->14726],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " is not given, the default coordinate variables for ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 " are used."
}], "Notes",
 CellID->28798]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19395158],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->308150205],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->258708384],

Cell["Scale factors for cylindrical coordinates:", "ExampleText",
 CellID->651441058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"h1", ",", " ", "h2", ",", " ", "h3"}], "}"}], " ", "=", " ", 
  RowBox[{"ScaleFactors", "[", "Cylindrical", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200931442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "Rr", ",", "1"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76795223]
}, Open  ]],

Cell["\<\
The Jacobian determinant is the product of the scale factors:\
\>", "ExampleText",
 CellID->133596026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobianDeterminant", "[", "Cylindrical", "]"}], " ", "\[Equal]", 
  " ", 
  RowBox[{"h1", " ", "h2", " ", "h3"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74910456],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37172976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1997],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcLengthFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianDeterminant",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20523],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->26201]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScaleFactors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 30.9980982}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ScaleFactors[pt] gives a list of the scale factors at the point pt in \
the default coordinate system. ScaleFactors[pt, coordsys] gives a list of the \
scale factors in the coordinate system coordsys.", "synonyms" -> {}, "title" -> 
    "ScaleFactors", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/ScaleFactors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6191, 195, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19395158]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12898, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2556, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3179, 82, 49, 1, 70, "ObjectName",
 CellID->4928],
Cell[3231, 85, 894, 27, 70, "Usage",
 CellID->24572]
}, Open  ]],
Cell[CellGroupData[{
Cell[4162, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4640, 134, 963, 34, 70, "Notes",
 CellID->29284],
Cell[5606, 170, 300, 9, 70, "Notes",
 CellID->14726],
Cell[5909, 181, 245, 9, 70, "Notes",
 CellID->28798]
}, Closed]],
Cell[CellGroupData[{
Cell[6191, 195, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19395158],
Cell[CellGroupData[{
Cell[6575, 209, 148, 5, 70, "ExampleSection",
 CellID->308150205],
Cell[6726, 216, 139, 4, 70, "Input",
 CellID->258708384],
Cell[6868, 222, 85, 1, 70, "ExampleText",
 CellID->651441058],
Cell[CellGroupData[{
Cell[6978, 227, 221, 6, 28, "Input",
 CellID->200931442],
Cell[7202, 235, 213, 7, 36, "Output",
 CellID->76795223]
}, Open  ]],
Cell[7430, 245, 112, 3, 70, "ExampleText",
 CellID->133596026],
Cell[CellGroupData[{
Cell[7567, 252, 203, 6, 70, "Input",
 CellID->74910456],
Cell[7773, 260, 160, 5, 36, "Output",
 CellID->37172976]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7994, 272, 310, 9, 70, "SeeAlsoSection",
 CellID->1997],
Cell[8307, 283, 2883, 98, 70, "SeeAlso",
 CellID->11652]
}, Open  ]],
Cell[CellGroupData[{
Cell[11227, 386, 314, 9, 70, "TutorialsSection",
 CellID->20523],
Cell[11544, 397, 163, 3, 70, "Tutorials",
 CellID->26201]
}, Open  ]],
Cell[11722, 403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

