(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10668,        390]
NotebookOptionsPosition[      7753,        293]
NotebookOutlinePosition[      9130,        331]
CellTagsIndexPosition[      9046,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cartesian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cartesian"], 
          "Cylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Cylindrical"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cartesian\"\>", 
       2->"\<\"Cylindrical\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Spherical", "ObjectName",
 CellID->13257],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Spherical"], "InlineFormula"],
     " \[LineSeparator]represents the spherical coordinate system with \
default variables ",
     Cell[BoxData[
      ButtonBox["Rr",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Rr"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Ttheta",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Ttheta"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Pphi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Pphi"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Spherical", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the spherical coordinate system with \
variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["r", "TI"], ",", 
       StyleBox["\[Theta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->88]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->112399967],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->228114568],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Spherical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Spherical", "[", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139379698]
}, Open  ]],

Cell["\<\
All evaluations now use spherical coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Rr", "<", "\[Infinity]"}], ",", 
   RowBox[{"0", "\[LessEqual]", "Ttheta", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Pphi", "\[LessEqual]", "\[Pi]"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->317874081]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["Rr", "2"], " ", 
  RowBox[{"Sin", "[", "Ttheta", "]"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->158258725]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->50738666]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27901],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cartesian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cartesian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6129],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->20297]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spherical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 31.4043586}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Spherical represents the spherical coordinate system with default \
variables Rr, Ttheta, and Pphi. Spherical[r, \\[Theta], \\[Phi]] represents \
the spherical coordinate system with variables r, \\[Theta] and \\[Phi].", 
    "synonyms" -> {}, "title" -> "Spherical", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Spherical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3439, 114, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8911, 319}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1353, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1976, 62, 47, 1, 70, "ObjectName",
 CellID->13257],
Cell[2026, 65, 1376, 44, 70, "Usage",
 CellID->88]
}, Open  ]],
Cell[CellGroupData[{
Cell[3439, 114, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3816, 128, 148, 5, 70, "ExampleSection",
 CellID->112399967],
Cell[3967, 135, 139, 4, 70, "Input",
 CellID->228114568],
Cell[4109, 141, 147, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[4281, 150, 118, 3, 28, "Input",
 CellID->443597938],
Cell[4402, 155, 236, 7, 36, "Output",
 CellID->139379698]
}, Open  ]],
Cell[4653, 165, 112, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[4790, 172, 107, 3, 28, "Input",
 CellID->709779145],
Cell[4900, 177, 414, 12, 36, "Output",
 CellID->317874081]
}, Open  ]],
Cell[CellGroupData[{
Cell[5351, 194, 109, 3, 70, "Input",
 CellID->33744766],
Cell[5463, 199, 241, 8, 36, "Output",
 CellID->158258725]
}, Open  ]],
Cell[5719, 210, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[5982, 222, 117, 3, 70, "Input",
 CellID->74704059],
Cell[6102, 227, 229, 7, 36, "Output",
 CellID->50738666]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6392, 241, 311, 9, 70, "SeeAlsoSection",
 CellID->27901],
Cell[6706, 252, 489, 17, 70, "SeeAlso",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[7232, 274, 313, 9, 70, "TutorialsSection",
 CellID->6129],
Cell[7548, 285, 163, 3, 70, "Tutorials",
 CellID->20297]
}, Open  ]],
Cell[7726, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

