(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11188,        417]
NotebookOptionsPosition[      8189,        313]
NotebookOutlinePosition[      9482,        350]
CellTagsIndexPosition[      9398,        345]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pphi" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Pphi"], "Uu" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Uu"], "Zz" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Zz"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Pphi\"\>", 2->"\<\"Uu\"\>", 
       3->"\<\"Zz\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Vv", "ObjectName",
 CellID->11221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Vv"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Bipolar",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Bipolar"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Bispherical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Bispherical"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ParabolicCylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Paraboloidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["EllipticCylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Toroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Toroidal"]], "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->36999431],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->934884162],

Cell[TextData[{
 Cell[BoxData["Vv"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166407581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Bispherical", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13288866]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ParabolicCylindrical", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->78429147]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Paraboloidal", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->34694730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->243350405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "EllipticCylindrical", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->90434274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->536087570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Toroidal", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->603969996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->30507277]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8352],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pphi",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Pphi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Uu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Uu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zz",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Zz"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23624],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->13584]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 32.1856286}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Vv is one of the default coordinates for the Bipolar, Bispherical, \
ParabolicCylindrical, Paraboloidal, EllipticCylindrical, and Toroidal \
coordinate systems.", "synonyms" -> {}, "title" -> "Vv", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/Vv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3491, 113, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9263, 338}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1382, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2005, 61, 40, 1, 70, "ObjectName",
 CellID->11221],
Cell[2048, 64, 1406, 44, 70, "Usage",
 CellID->3217]
}, Open  ]],
Cell[CellGroupData[{
Cell[3491, 113, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3868, 127, 147, 5, 70, "ExampleSection",
 CellID->36999431],
Cell[4018, 134, 139, 4, 70, "Input",
 CellID->934884162],
Cell[4160, 140, 151, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[4336, 148, 113, 3, 28, "Input",
 CellID->406403560],
Cell[4452, 153, 216, 7, 36, "Output",
 CellID->166407581]
}, Open  ]],
Cell[CellGroupData[{
Cell[4705, 165, 117, 3, 28, "Input",
 CellID->566909803],
Cell[4825, 170, 217, 7, 36, "Output",
 CellID->13288866]
}, Open  ]],
Cell[CellGroupData[{
Cell[5079, 182, 124, 3, 28, "Input",
 CellID->6802135],
Cell[5206, 187, 215, 7, 36, "Output",
 CellID->78429147]
}, Open  ]],
Cell[CellGroupData[{
Cell[5458, 199, 117, 3, 70, "Input",
 CellID->34694730],
Cell[5578, 204, 218, 7, 36, "Output",
 CellID->243350405]
}, Open  ]],
Cell[CellGroupData[{
Cell[5833, 216, 124, 3, 70, "Input",
 CellID->90434274],
Cell[5960, 221, 216, 7, 36, "Output",
 CellID->536087570]
}, Open  ]],
Cell[CellGroupData[{
Cell[6213, 233, 114, 3, 70, "Input",
 CellID->603969996],
Cell[6330, 238, 217, 7, 36, "Output",
 CellID->30507277]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6608, 252, 310, 9, 70, "SeeAlsoSection",
 CellID->8352],
Cell[6921, 263, 709, 26, 70, "SeeAlso",
 CellID->12019]
}, Open  ]],
Cell[CellGroupData[{
Cell[7667, 294, 314, 9, 70, "TutorialsSection",
 CellID->23624],
Cell[7984, 305, 163, 3, 70, "Tutorials",
 CellID->13584]
}, Open  ]],
Cell[8162, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

