(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8050,        292]
NotebookOptionsPosition[      5696,        213]
NotebookOutlinePosition[      6937,        249]
CellTagsIndexPosition[      6853,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eeta" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Eeta"], "Pphi" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Pphi"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Eeta\"\>", 
       2->"\<\"Pphi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Xxi", "ObjectName",
 CellID->29666],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Xxi"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["ProlateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["OblateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->507603996],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->316552776],

Cell[TextData[{
 Cell[BoxData["Xxi"], "InlineFormula"],
 " is used as a coordinate in the following systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ProlateSpheroidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373543396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "OblateSpheroidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->540514377]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23279],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eeta",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Eeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pphi",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Pphi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1991],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30959]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Xxi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 32.3731334}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Xxi is one of the default coordinates for the ProlateSpheroidal and \
OblateSpheroidal coordinate systems.", "synonyms" -> {}, "title" -> "Xxi", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/Xxi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2724, 90, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6719, 237}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1295, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1918, 60, 41, 1, 70, "ObjectName",
 CellID->29666],
Cell[1962, 63, 725, 22, 70, "Usage",
 CellID->16218]
}, Open  ]],
Cell[CellGroupData[{
Cell[2724, 90, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3101, 104, 148, 5, 70, "ExampleSection",
 CellID->507603996],
Cell[3252, 111, 139, 4, 70, "Input",
 CellID->316552776],
Cell[3394, 117, 147, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3566, 125, 123, 3, 28, "Input",
 CellID->406403560],
Cell[3692, 130, 222, 7, 36, "Output",
 CellID->373543396]
}, Open  ]],
Cell[CellGroupData[{
Cell[3951, 142, 122, 3, 28, "Input",
 CellID->566909803],
Cell[4076, 147, 222, 7, 36, "Output",
 CellID->540514377]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4359, 161, 311, 9, 70, "SeeAlsoSection",
 CellID->23279],
Cell[4673, 172, 465, 17, 70, "SeeAlso",
 CellID->30498]
}, Open  ]],
Cell[CellGroupData[{
Cell[5175, 194, 313, 9, 70, "TutorialsSection",
 CellID->1991],
Cell[5491, 205, 163, 3, 70, "Tutorials",
 CellID->30959]
}, Open  ]],
Cell[5669, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

