(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11524,        419]
NotebookOptionsPosition[      8686,        321]
NotebookOutlinePosition[      9965,        358]
CellTagsIndexPosition[      9881,        353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rr" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Rr"], "Ttheta" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Ttheta"], "Uu" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Uu"], "Vv" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Vv"], "Xx" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Xx"], "Yy" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Yy"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rr\"\>", 2->"\<\"Ttheta\"\>", 
       3->"\<\"Uu\"\>", 4->"\<\"Vv\"\>", 5->"\<\"Xx\"\>", 
       6->"\<\"Yy\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Zz", "ObjectName",
 CellID->3083],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Zz"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Bipolar",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Bipolar"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Cartesian",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Cylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["EllipticCylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ParabolicCylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29719]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->354835855],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->191234175],

Cell[TextData[{
 Cell[BoxData["Zz"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6653077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->95158107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Cylindrical", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->54753115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "EllipticCylindrical", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->87884283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->90235565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ParabolicCylindrical", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->46889050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->47727361]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5241],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rr",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Rr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ttheta",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Ttheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Uu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Uu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Vv",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Vv"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xx",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Xx"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Yy",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Yy"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->252638218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18296],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->24439]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Zz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 38.9358014}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Zz is one of the default coordinates for the Bipolar, Cartesian, \
Cylindrical, EllipticCylindrical and ParabolicCylindrical coordinate \
systems.", "synonyms" -> {}, "title" -> "Zz", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Zz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3612, 111, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9746, 346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1678, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2301, 65, 39, 1, 70, "ObjectName",
 CellID->3083],
Cell[2343, 68, 1232, 38, 70, "Usage",
 CellID->29719]
}, Open  ]],
Cell[CellGroupData[{
Cell[3612, 111, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3989, 125, 148, 5, 70, "ExampleSection",
 CellID->354835855],
Cell[4140, 132, 139, 4, 70, "Input",
 CellID->191234175],
Cell[4282, 138, 151, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[4458, 146, 113, 3, 28, "Input",
 CellID->406403560],
Cell[4574, 151, 214, 7, 36, "Output",
 CellID->6653077]
}, Open  ]],
Cell[CellGroupData[{
Cell[4825, 163, 115, 3, 28, "Input",
 CellID->566909803],
Cell[4943, 168, 215, 7, 36, "Output",
 CellID->95158107]
}, Open  ]],
Cell[CellGroupData[{
Cell[5195, 180, 115, 3, 28, "Input",
 CellID->6802135],
Cell[5313, 185, 220, 7, 36, "Output",
 CellID->54753115]
}, Open  ]],
Cell[CellGroupData[{
Cell[5570, 197, 124, 3, 70, "Input",
 CellID->87884283],
Cell[5697, 202, 215, 7, 36, "Output",
 CellID->90235565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5949, 214, 125, 3, 70, "Input",
 CellID->46889050],
Cell[6077, 219, 215, 7, 36, "Output",
 CellID->47727361]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6353, 233, 310, 9, 70, "SeeAlsoSection",
 CellID->5241],
Cell[6666, 244, 1461, 53, 70, "SeeAlso",
 CellID->252638218]
}, Open  ]],
Cell[CellGroupData[{
Cell[8164, 302, 314, 9, 70, "TutorialsSection",
 CellID->18296],
Cell[8481, 313, 163, 3, 70, "Tutorials",
 CellID->24439]
}, Open  ]],
Cell[8659, 319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

