(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7381,        248]
NotebookOptionsPosition[      4735,        176]
NotebookOutlinePosition[      6269,        211]
CellTagsIndexPosition[      6226,        208]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Vector Field Plotting Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorFieldPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a vector field from a vector-valued function"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorFieldPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot3D"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a vector field in 3D"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListVectorFieldPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a vector field from an array of vectors"
}], "GuideText",
 CellID->746418430],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListVectorFieldPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a vector field in 3D"
}], "GuideText",
 CellID->1602570883],

Cell["\t", "GuideDelimiter",
 CellID->668929907],

Cell[TextData[{
 Cell[TextData[ButtonBox["GradientFieldPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the gradient field for a function"
}], "GuideText",
 CellID->836646523],

Cell[TextData[{
 Cell[TextData[ButtonBox["HamiltonianFieldPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the Hamiltonian field for a function"
}], "GuideText",
 CellID->1701644387],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyaFieldPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/PolyaFieldPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the Polya field for a complex function"
}], "GuideText",
 CellID->628054904],

Cell[TextData[{
 Cell[TextData[ButtonBox["GradientFieldPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot3D"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the gradient field for a function in 3D"
}], "GuideText",
 CellID->199910676],

Cell["\t", "GuideDelimiter",
 CellID->1942675152],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorHeads",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaxArrowLength",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScaleFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScaleFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vector Field Plotting Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 39.5764428}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Guide", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "VectorFieldPlot -- plot a vector field from a vector-valued function, \
VectorFieldPlot3D -- plot a vector field in 3D, ListVectorFieldPlot -- plot a \
vector field from an array of vectors, ListVectorFieldPlot3D -- plot a vector \
field in 3D, GradientFieldPlot -- plot the gradient field for a function, \
HamiltonianFieldPlot -- plot the Hamiltonian field for a function, \
PolyaFieldPlot -- plot the Polya field for a complex function, \
GradientFieldPlot3D -- plot the gradient field for a function in 3D", 
    "synonyms" -> {}, "title" -> "Vector Field Plotting Package", "type" -> 
    "Guide", "uri" -> "VectorFieldPlots/guide/VectorFieldPlottingPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 71, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[693, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[752, 31, 307, 9, 70, "GuideText",
 CellID->203374175],
Cell[1062, 42, 288, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1353, 53, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1404, 56, 310, 9, 70, "GuideText",
 CellID->746418430],
Cell[1717, 67, 296, 9, 70, "GuideText",
 CellID->1602570883],
Cell[2016, 78, 48, 1, 70, "GuideDelimiter",
 CellID->668929907],
Cell[2067, 81, 300, 9, 70, "GuideText",
 CellID->836646523],
Cell[2370, 92, 310, 9, 70, "GuideText",
 CellID->1701644387],
Cell[2683, 103, 299, 9, 70, "GuideText",
 CellID->628054904],
Cell[2985, 114, 310, 9, 70, "GuideText",
 CellID->199910676],
Cell[3298, 125, 49, 1, 70, "GuideDelimiter",
 CellID->1942675152],
Cell[3350, 128, 925, 27, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[4312, 160, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4377, 163, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4541, 168, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[4708, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

