(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19194,        537]
NotebookOptionsPosition[     16526,        456]
NotebookOutlinePosition[     18093,        496]
CellTagsIndexPosition[     18008,        491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"GradientFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/GradientFieldPlot"], 
         "VectorFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot3D"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"GradientFieldPlot\"\>", 
      2->"\<\"VectorFieldPlot3D\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GradientFieldPlot3D", "ObjectName",
 CellID->25751],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GradientFieldPlot3D", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three-dimensional plot of the gradient \
vector field of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GradientFieldPlot3D", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dz", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["dz", "TI"]], "InlineFormula"],
     " in variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GradientFieldPlot3D"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->23545],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the scale of the vectors to the mesh; ",
     Cell[BoxData[
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"]], "InlineFormula"],
     " ensures that the largest vector fits in the mesh"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "function to rescale the length of vectors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "determines the largest vector to be drawn", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["the colors to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VectorHeads",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw vectors with heads", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "7", Cell[
    "number of evalution points in each direction", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->11952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156950644],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->35187521],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->37269697],

Cell[TextData[{
 "Gradient field of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"], "-", 
    SuperscriptBox["z", "2"]}], TraditionalForm]], "InlineMath"],
 " over the unit cube:"
}], "ExampleText",
 CellID->1476498279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GradientFieldPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"z", "^", "2"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436110501],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149362144]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2082],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GradientFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8173]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GradientFieldPlot3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 39.8264492}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "GradientFieldPlot3D[f, {x, x_min, x_max}, {y, y_min, y_max}, {z, z_min, \
z_max}] generates a three-dimensional plot of the gradient vector field of \
the scalar function f as a function of x, y and z. GradientFieldPlot3D[f, {x, \
x_min, x_max, dx}, {y, y_min, y_max, dy}, {z, z_min, z_max, dz}] uses steps \
dx, dy and dz in variables x, y and z respectively.", "synonyms" -> {}, 
    "title" -> "GradientFieldPlot3D", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/GradientFieldPlot3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7837, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->156950644]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17865, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 787, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1410, 46, 57, 1, 70, "ObjectName",
 CellID->25751],
Cell[1470, 49, 3300, 108, 70, "Usage",
 CellID->3943]
}, Open  ]],
Cell[CellGroupData[{
Cell[4807, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5285, 179, 300, 9, 70, "Notes",
 CellID->23545],
Cell[5588, 190, 2212, 57, 70, "3ColumnTableMod",
 CellID->11952]
}, Closed]],
Cell[CellGroupData[{
Cell[7837, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156950644],
Cell[CellGroupData[{
Cell[8222, 266, 147, 5, 70, "ExampleSection",
 CellID->35187521],
Cell[8372, 273, 140, 4, 70, "Input",
 CellID->37269697],
Cell[8515, 279, 278, 10, 70, "ExampleText",
 CellID->1476498279],
Cell[CellGroupData[{
Cell[8818, 293, 489, 14, 28, "Input",
 CellID->436110501],
Cell[9310, 309, 6280, 107, 210, "Output",
 Evaluatable->False,
 CellID->149362144]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15651, 423, 310, 9, 70, "SeeAlsoSection",
 CellID->2082],
Cell[15964, 434, 520, 17, 70, "SeeAlso",
 CellID->8173]
}, Open  ]],
Cell[16499, 454, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

