(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18934,        551]
NotebookOptionsPosition[     16178,        466]
NotebookOutlinePosition[     17687,        505]
CellTagsIndexPosition[     17602,        500]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ListVectorFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"], 
         "VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ListVectorFieldPlot3D\"\>", 
      2->"\<\"VectorFieldPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListVectorFieldPlot", "ObjectName",
 CellID->17453],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListVectorFieldPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["11", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["11", "TR"]]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["12", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["12", "TR"]]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the vector field corresponding to \
the array of vectors ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["11", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["11", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListVectorFieldPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["vec", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["vec", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of a list of vectors, each based at \
the corresponding point."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9212]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The array of vectors ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["11", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["12", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["12", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " must be rectangular, with dimensions at least ",
 Cell[BoxData[
  RowBox[{"2", "\[Times]", "2"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11562],

Cell[TextData[{
 "Vectors given in an array are regularly spaced with vector ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["11", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["11", "TR"]]}], "}"}]], "InlineFormula"],
 " placed at the upper-left corner."
}], "Notes",
 CellID->21376],

Cell[TextData[{
 Cell[BoxData["ListVectorFieldPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->10195],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a function to use for coloring the vectors by their magnitude\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "length of the largest vector to be drawn, applied after the ",
     Cell[BoxData[
      ButtonBox["ScaleFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
      "InlineFormula"],
     ", but before the ",
     Cell[BoxData[
      ButtonBox["ScaleFactor",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
      "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "linearly rescales the vectors so the longest vector is equal to this \
value; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " fits the vectors in the mesh, ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " eliminates the rescaling"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a function to use for rescaling the magnitude of vectors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->28571],

Cell[TextData[{
 Cell[BoxData["ListVectorFieldPlot"], "InlineFormula"],
 " treats the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScaleFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScaleFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17977]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265854284],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->278369691],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->307069094],

Cell["Field plot from an array of vectors:", "ExampleText",
 CellID->1912093873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListVectorFieldPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "i"}], ",", 
      RowBox[{"j", "^", "2"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "0", ",", " ", "1", ",", "0.1"}], "}"}], ",", " ",
     
    RowBox[{"{", 
     RowBox[{"j", ",", " ", "0", ",", " ", "1", ",", " ", "0.1"}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1616429803],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], ArrowBox[{{1., 1.}, {0., 1.}}], 
   ArrowBox[{{2., 1.}, {1., 1.01}}], ArrowBox[{{3., 1.}, {2., 1.04}}], 
   ArrowBox[{{4., 1.}, {3., 1.09}}], 
   ArrowBox[{{5., 1.}, {4., 1.1600000000000001`}}], 
   ArrowBox[{{6., 1.}, {5., 1.25}}], ArrowBox[{{7., 1.}, {6., 1.36}}], 
   ArrowBox[{{8., 1.}, {7., 1.4900000000000002`}}], 
   ArrowBox[{{9., 1.}, {8., 1.6400000000000001`}}], 
   ArrowBox[{{10., 1.}, {9., 1.81}}], ArrowBox[{{11., 1.}, {10., 2.}}], 
   ArrowBox[{{1., 2.}, {0.09999999999999998, 2.}}], 
   ArrowBox[{{2., 2.}, {1.1, 2.01}}], ArrowBox[{{3., 2.}, {2.1, 2.04}}], 
   ArrowBox[{{4., 2.}, {3.1, 2.09}}], ArrowBox[{{5., 2.}, {4.1, 2.16}}], 
   ArrowBox[{{6., 2.}, {5.1, 2.25}}], 
   ArrowBox[{{7., 2.}, {6.1, 2.3600000000000003`}}], 
   ArrowBox[{{8., 2.}, {7.1, 2.49}}], ArrowBox[{{9., 2.}, {8.1, 2.64}}], 
   ArrowBox[{{10., 2.}, {9.1, 2.81}}], ArrowBox[{{11., 2.}, {10.1, 3.}}], 
   ArrowBox[{{1., 3.}, {0.19999999999999996`, 3.}}], 
   ArrowBox[{{2., 3.}, {1.2, 3.01}}], ArrowBox[{{3., 3.}, {2.2, 3.04}}], 
   ArrowBox[{{4., 3.}, {3.2, 3.09}}], ArrowBox[{{5., 3.}, {4.2, 3.16}}], 
   ArrowBox[{{6., 3.}, {5.2, 3.25}}], 
   ArrowBox[{{7., 3.}, {6.2, 3.3600000000000003`}}], 
   ArrowBox[{{8., 3.}, {7.2, 3.49}}], ArrowBox[{{9., 3.}, {8.2, 3.64}}], 
   ArrowBox[{{10., 3.}, {9.2, 3.81}}], ArrowBox[{{11., 3.}, {10.2, 4.}}], 
   ArrowBox[{{1., 4.}, {0.29999999999999993`, 4.}}], 
   ArrowBox[{{2., 4.}, {1.2999999999999998`, 4.01}}], 
   ArrowBox[{{3., 4.}, {2.3, 4.04}}], ArrowBox[{{4., 4.}, {3.3, 4.09}}], 
   ArrowBox[{{5., 4.}, {4.3, 4.16}}], ArrowBox[{{6., 4.}, {5.3, 4.25}}], 
   ArrowBox[{{7., 4.}, {6.3, 4.36}}], ArrowBox[{{8., 4.}, {7.3, 4.49}}], 
   ArrowBox[{{9., 4.}, {8.3, 4.640000000000001}}], 
   ArrowBox[{{10., 4.}, {9.3, 4.8100000000000005`}}], 
   ArrowBox[{{11., 4.}, {10.3, 5.}}], 
   ArrowBox[{{1., 5.}, {0.3999999999999999, 5.}}], 
   ArrowBox[{{2., 5.}, {1.4, 5.01}}], ArrowBox[{{3., 5.}, {2.4, 5.04}}], 
   ArrowBox[{{4., 5.}, {3.4, 5.09}}], ArrowBox[{{5., 5.}, {4.4, 5.16}}], 
   ArrowBox[{{6., 5.}, {5.4, 5.25}}], ArrowBox[{{7., 5.}, {6.4, 5.36}}], 
   ArrowBox[{{8., 5.}, {7.4, 5.49}}], 
   ArrowBox[{{9., 5.}, {8.4, 5.640000000000001}}], 
   ArrowBox[{{10., 5.}, {9.4, 5.8100000000000005`}}], 
   ArrowBox[{{11., 5.}, {10.4, 6.}}], ArrowBox[{{1., 6.}, {0.5, 6.}}], 
   ArrowBox[{{2., 6.}, {1.5, 6.01}}], ArrowBox[{{3., 6.}, {2.5, 6.04}}], 
   ArrowBox[{{4., 6.}, {3.5, 6.09}}], ArrowBox[{{5., 6.}, {4.5, 6.16}}], 
   ArrowBox[{{6., 6.}, {5.5, 6.25}}], ArrowBox[{{7., 6.}, {6.5, 6.36}}], 
   ArrowBox[{{8., 6.}, {7.5, 6.49}}], 
   ArrowBox[{{9., 6.}, {8.5, 6.640000000000001}}], 
   ArrowBox[{{10., 6.}, {9.5, 6.8100000000000005`}}], 
   ArrowBox[{{11., 6.}, {10.5, 7.}}], ArrowBox[{{1., 7.}, {0.6, 7.}}], 
   ArrowBox[{{2., 7.}, {1.6, 7.01}}], ArrowBox[{{3., 7.}, {2.6, 7.04}}], 
   ArrowBox[{{4., 7.}, {3.6, 7.09}}], ArrowBox[{{5., 7.}, {4.6, 7.16}}], 
   ArrowBox[{{6., 7.}, {5.6, 7.25}}], ArrowBox[{{7., 7.}, {6.6, 7.36}}], 
   ArrowBox[{{8., 7.}, {7.6, 7.49}}], 
   ArrowBox[{{9., 7.}, {8.6, 7.640000000000001}}], 
   ArrowBox[{{10., 7.}, {9.6, 7.8100000000000005`}}], 
   ArrowBox[{{11., 7.}, {10.6, 8.}}], ArrowBox[{{1., 8.}, {0.7, 8.}}], 
   ArrowBox[{{2., 8.}, {1.7, 8.01}}], ArrowBox[{{3., 8.}, {2.7, 8.04}}], 
   ArrowBox[{{4., 8.}, {3.7, 8.09}}], ArrowBox[{{5., 8.}, {4.7, 8.16}}], 
   ArrowBox[{{6., 8.}, {5.7, 8.25}}], ArrowBox[{{7., 8.}, {6.7, 8.36}}], 
   ArrowBox[{{8., 8.}, {7.7, 8.49}}], ArrowBox[{{9., 8.}, {8.7, 8.64}}], 
   ArrowBox[{{10., 8.}, {9.7, 8.81}}], ArrowBox[{{11., 8.}, {10.7, 9.}}], 
   ArrowBox[{{1., 9.}, {0.8, 9.}}], ArrowBox[{{2., 9.}, {1.8, 9.01}}], 
   ArrowBox[{{3., 9.}, {2.8, 9.04}}], ArrowBox[{{4., 9.}, {3.8, 9.09}}], 
   ArrowBox[{{5., 9.}, {4.8, 9.16}}], ArrowBox[{{6., 9.}, {5.8, 9.25}}], 
   ArrowBox[{{7., 9.}, {6.8, 9.36}}], ArrowBox[{{8., 9.}, {7.8, 9.49}}], 
   ArrowBox[{{9., 9.}, {8.8, 9.64}}], ArrowBox[{{10., 9.}, {9.8, 9.81}}], 
   ArrowBox[{{11., 9.}, {10.8, 10.}}], ArrowBox[{{1., 10.}, {0.9, 10.}}], 
   ArrowBox[{{2., 10.}, {1.9, 10.01}}], ArrowBox[{{3., 10.}, {2.9, 10.04}}], 
   ArrowBox[{{4., 10.}, {3.9, 10.09}}], ArrowBox[{{5., 10.}, {4.9, 10.16}}], 
   ArrowBox[{{6., 10.}, {5.9, 10.25}}], ArrowBox[{{7., 10.}, {6.9, 10.36}}], 
   ArrowBox[{{8., 10.}, {7.9, 10.49}}], ArrowBox[{{9., 10.}, {8.9, 10.64}}], 
   ArrowBox[{{10., 10.}, {9.9, 10.81}}], ArrowBox[{{11., 10.}, {10.9, 11.}}], 
   PointBox[{1., 11.}], ArrowBox[{{2., 11.}, {2., 11.01}}], 
   ArrowBox[{{3., 11.}, {3., 11.04}}], ArrowBox[{{4., 11.}, {4., 11.09}}], 
   ArrowBox[{{5., 11.}, {5., 11.16}}], ArrowBox[{{6., 11.}, {6., 11.25}}], 
   ArrowBox[{{7., 11.}, {7., 11.36}}], ArrowBox[{{8., 11.}, {8., 11.49}}], 
   ArrowBox[{{9., 11.}, {9., 11.64}}], ArrowBox[{{10., 11.}, {10., 11.81}}], 
   ArrowBox[{{11., 11.}, {11., 12.}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1545742439]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22564],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListVectorFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5512]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListVectorFieldPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 46.9360062}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "ListVectorFieldPlot[{{{x_11, y_11}, {x_12, y_12}, ...}, ...}] generates \
a plot of the vector field corresponding to the array of vectors {{{x_11, \
y_11}, ...}, ...}. ListVectorFieldPlot[{{pt_1, vec_1}, {pt_2, vec_2}, ...}] \
generates a plot of a list of vectors, each based at the corresponding \
point.", "synonyms" -> {}, "title" -> "ListVectorFieldPlot", "type" -> 
    "Symbol", "uri" -> "VectorFieldPlots/ref/ListVectorFieldPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8970, 297, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->265854284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17459, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 793, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1416, 46, 57, 1, 70, "ObjectName",
 CellID->17453],
Cell[1476, 49, 2443, 75, 70, "Usage",
 CellID->9212]
}, Open  ]],
Cell[CellGroupData[{
Cell[3956, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4434, 146, 839, 30, 70, "Notes",
 CellID->11562],
Cell[5276, 178, 368, 13, 70, "Notes",
 CellID->21376],
Cell[5647, 193, 296, 9, 70, "Notes",
 CellID->10195],
Cell[5946, 204, 2337, 64, 70, "3ColumnTableMod",
 CellID->28571],
Cell[8286, 270, 647, 22, 70, "Notes",
 CellID->17977]
}, Closed]],
Cell[CellGroupData[{
Cell[8970, 297, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265854284],
Cell[CellGroupData[{
Cell[9355, 311, 148, 5, 70, "ExampleSection",
 CellID->278369691],
Cell[9506, 318, 141, 4, 70, "Input",
 CellID->307069094],
Cell[9650, 324, 80, 1, 70, "ExampleText",
 CellID->1912093873],
Cell[CellGroupData[{
Cell[9755, 329, 472, 15, 28, "Input",
 CellID->1616429803],
Cell[10230, 346, 5007, 80, 201, "Output",
 CellID->1545742439]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15298, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->22564],
Cell[15612, 444, 524, 17, 70, "SeeAlso",
 CellID->5512]
}, Open  ]],
Cell[16151, 464, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

