(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20778,        555]
NotebookOptionsPosition[     18210,        474]
NotebookOutlinePosition[     19626,        512]
CellTagsIndexPosition[     19541,        507]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ListVectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ListVectorFieldPlot"], 
         "VectorFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot3D"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ListVectorFieldPlot\"\>", 
      2->"\<\"VectorFieldPlot3D\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListVectorFieldPlot3D", "ObjectName",
 CellID->1616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListVectorFieldPlot3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["vec", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["vec", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three-dimensional plot of the list of \
vectors ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["vec", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["vec", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", with each vector based at a corresponding point ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Each point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a coordinate vector ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 " in a Cartesian coordinate system."
}], "Notes",
 CellID->9234],

Cell[TextData[{
 Cell[BoxData["ListVectorFieldPlot3D"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " with the following additions and changes:"
}], "Notes",
 CellID->32156],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], 
    RowBox[{Cell[TextData[{
      "the scale of the vectors to the mesh; ",
      Cell[BoxData[
       ButtonBox["Max",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Max"]], "InlineFormula"]
     }], "TableText"], 
     StyleBox["ensures", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["that", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["the", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["largest", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["vector", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["fits", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["in", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["the", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["mesh", "ExampleText"]}]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "function to rescale the lengths of vectors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "determines the largest vector to be drawn", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["colors to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VectorHeads",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw vectors with heads", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->29773]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96792768],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->6051682],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->516853758],

Cell["Plot of a three-dimensional vector field:", "ExampleText",
 CellID->291558609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListVectorFieldPlot3D", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"2", "j"}], ",", 
           RowBox[{"-", "k"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "0", ",", " ", "1", ",", " ", "0.1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "0", ",", " ", "1", ",", " ", "0.1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", " ", "0", ",", " ", "1", ",", " ", "0.1"}], "}"}]}],
       "]"}], ",", "2"}], "]"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1333034068],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520947677]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17964],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListVectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31401]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListVectorFieldPlot3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 40.9202272}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "ListVectorFieldPlot3D[{{pt_1, vec_1}, {pt_2, vec_2}, ...}] generates a \
three-dimensional plot of the list of vectors vec_1, vec_2, ..., with each \
vector based at a corresponding point pt_1, pt_2, ....", "synonyms" -> {}, 
    "title" -> "ListVectorFieldPlot3D", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/ListVectorFieldPlot3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7073, 230, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->96792768]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19399, 500}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 793, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1416, 46, 58, 1, 70, "ObjectName",
 CellID->1616],
Cell[1477, 49, 1618, 51, 70, "Usage",
 CellID->5401]
}, Open  ]],
Cell[CellGroupData[{
Cell[3132, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3610, 122, 526, 21, 70, "Notes",
 CellID->9234],
Cell[4139, 145, 301, 9, 70, "Notes",
 CellID->32156],
Cell[4443, 156, 2593, 69, 70, "3ColumnTableMod",
 CellID->29773]
}, Closed]],
Cell[CellGroupData[{
Cell[7073, 230, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96792768],
Cell[CellGroupData[{
Cell[7457, 244, 146, 5, 70, "ExampleSection",
 CellID->6051682],
Cell[7606, 251, 141, 4, 70, "Input",
 CellID->516853758],
Cell[7750, 257, 84, 1, 70, "ExampleText",
 CellID->291558609],
Cell[CellGroupData[{
Cell[7859, 262, 893, 26, 47, "Input",
 CellID->1333034068],
Cell[8755, 290, 8513, 144, 211, "Output",
 Evaluatable->False,
 CellID->520947677]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17329, 441, 311, 9, 70, "SeeAlsoSection",
 CellID->17964],
Cell[17643, 452, 525, 17, 70, "SeeAlso",
 CellID->31401]
}, Open  ]],
Cell[18183, 472, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

