(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22886,        601]
NotebookOptionsPosition[     20241,        519]
NotebookOutlinePosition[     21731,        558]
CellTagsIndexPosition[     21646,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], "GradientFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/GradientFieldPlot"], 
         "HamiltonianFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"VectorFieldPlot\"\>", 
      2->"\<\"GradientFieldPlot\"\>", 
      3->"\<\"HamiltonianFieldPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolyaFieldPlot", "ObjectName",
 CellID->6188],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolyaFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the complex-valued function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the complex plane using the Polya representation."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolyaFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " in real component ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and steps ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " in imaginary component ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6838]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PolyaFieldPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->7987],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a function to use for coloring the vectors by their magnitude\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "length of the largest vector to be drawn, applied after the ",
     Cell[BoxData[
      ButtonBox["ScaleFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
      "InlineFormula"],
     ", but before the ",
     Cell[BoxData[
      ButtonBox["ScaleFactor",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
      "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "15", Cell[
    "the number of evaluation points in each direction", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "linearly rescales the vectors so the longest vector is equal to this \
value; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " fits the vectors in the mesh, ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " eliminates the rescaling"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a function to use for rescaling the magnitude of vectors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->28571],

Cell[TextData[{
 "In the Polya representation the magnitude is scaled using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScaleFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Log",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Log"], "[", 
      RowBox[{"#", " ", "+", " ", "1"}], "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 " and the negative of the imaginary part is used. "
}], "Notes",
 CellID->7734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428678104],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->114825119],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->274275002],

Cell[TextData[{
 "Polya field plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", " ", "z"}], TraditionalForm]], "InlineMath"],
 StyleBox[":",
  Deletable->True]
}], "ExampleText",
 CellID->500940041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyaFieldPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", "*", "y"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235823026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1011786540]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21273],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GradientFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30666]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolyaFieldPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 47.5453968}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "PolyaFieldPlot[f, {x, x_min, x_max}, {y, y_min, y_max}] generates a plot \
of the complex-valued function f in the complex plane using the Polya \
representation. PolyaFieldPlot[f, {x, x_min, x_max, dx}, {y, y_min, y_max, \
dy}] uses steps dx in real component x and steps dy in imaginary component \
y.", "synonyms" -> {}, "title" -> "PolyaFieldPlot", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/PolyaFieldPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7884, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->428678104]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21503, 546}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 948, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1571, 49, 51, 1, 70, "ObjectName",
 CellID->6188],
Cell[1625, 52, 2316, 73, 70, "Usage",
 CellID->6838]
}, Open  ]],
Cell[CellGroupData[{
Cell[3978, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4456, 147, 290, 9, 70, "Notes",
 CellID->7987],
Cell[4749, 158, 2565, 69, 70, "3ColumnTableMod",
 CellID->28571],
Cell[7317, 229, 530, 17, 70, "Notes",
 CellID->7734]
}, Closed]],
Cell[CellGroupData[{
Cell[7884, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428678104],
Cell[CellGroupData[{
Cell[8269, 265, 148, 5, 70, "ExampleSection",
 CellID->114825119],
Cell[8420, 272, 141, 4, 70, "Input",
 CellID->274275002],
Cell[8564, 278, 203, 8, 70, "ExampleText",
 CellID->500940041],
Cell[CellGroupData[{
Cell[8792, 290, 415, 13, 28, "Input",
 CellID->235823026],
Cell[9210, 305, 9811, 165, 181, "Output",
 Evaluatable->False,
 CellID->1011786540]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19082, 477, 311, 9, 70, "SeeAlsoSection",
 CellID->21273],
Cell[19396, 488, 803, 26, 70, "SeeAlso",
 CellID->30666]
}, Open  ]],
Cell[20214, 517, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

