(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    561047,      10875]
NotebookOptionsPosition[    553691,      10642]
NotebookOutlinePosition[    555630,      10687]
CellTagsIndexPosition[    555587,      10684]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  WORLDPLOT PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Albers" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Albers"], 
         "Equirectangular" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Equirectangular"], 
         "Graphics" :> Documentation`HelpLookup["paclet:ref/Graphics"], 
         "LambertAzimuthal" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/LambertAzimuthal"], 
         "LambertCylindrical" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/LambertCylindrical"], 
         "Mercator" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Mercator"], 
         "Mollweide" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Mollweide"], 
         "Orthographic" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Orthographic"], 
         "RandomColors" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/RandomColors"], 
         "RandomGrays" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/RandomGrays"], "Show" :> 
         Documentation`HelpLookup["paclet:ref/Show"], "Sinusoidal" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/Sinusoidal"], 
         "ToMinutes" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/ToMinutes"], 
         "WorldGraphics" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/WorldGraphics"], 
         "WorldPlot" :> 
         Documentation`HelpLookup["paclet:WorldPlot/ref/WorldPlot"]}, #, 2]& ,
        Evaluator -> Automatic], {1->"\<\"Albers\"\>", 
      2->"\<\"Equirectangular\"\>", 3->"\<\"Graphics\"\>", 
      4->"\<\"LambertAzimuthal\"\>", 5->"\<\"LambertCylindrical\"\>", 
      6->"\<\"Mercator\"\>", 7->"\<\"Mollweide\"\>", 
      8->"\<\"Orthographic\"\>", 9->"\<\"RandomColors\"\>", 
      10->"\<\"RandomGrays\"\>", 11->"\<\"Show\"\>", 12->"\<\"Sinusoidal\"\>",
       13->"\<\"ToMinutes\"\>", 14->"\<\"WorldGraphics\"\>", 
      15->"\<\"WorldPlot\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 "Some of the functionality of the ",
 ButtonBox["World Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:WorldPlot/guide/WorldPlottingPackage"],
 " is now available in ",
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->429636518],

Cell[CellGroupData[{

Cell["World Plotting Package", "Title",
 CellID->7815],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WorldPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", 
     StyleBox["countrylist", "TI"], "]"}], Cell[TextData[{
     "generate a map of the countries named in ",
     StyleBox["countrylist", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WorldPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", "{", 
     StyleBox["countrylist", "TI"], ",", 
     ButtonBox["RandomColors",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/RandomColors"], "}", "]"}], Cell[
    "color the countries with randomly chosen colors ", "TableText"]},
   {
    RowBox[{
     ButtonBox["WorldPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", "{", 
     StyleBox["countrylist", "TI"], ",", 
     ButtonBox["RandomGrays",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/RandomGrays"], "}", "]"}], Cell[
    "use randomly chosen gray levels", "TableText"]}
  }]], "DefinitionBox",
 CellID->17118],

Cell["Displaying a map. ", "Caption",
 CellID->21122],

Cell[TextData[{
 "To make a map of an entire continent, you can give the name of the \
continent in place of the list of country names. Thus, for example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", "Oceania", "]"}]], 
  "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Indonesia\>\"", ",", "\"\<Papua New Guinea\>\"", ",", "\"\<Fiji\>\"",
      ",", "\"\<Australia\>\"", ",", "\"\<New Zealand\>\""}], "}"}], "]"}]], 
  "InlineFormula"],
 ". The names of the countries that can be mapped are listed at the end of \
this tutorial. Note that the names of countries are strings. This means they \
must be surrounded by quotes when you use them in a list of countries. \
However, the continent names represent lists and therefore are not strings \
but symbols. They should not be put in quotes. "
}], "Text",
 CellID->31246],

Cell["This loads the package. ", "MathCaption",
 CellID->23220],

Cell[BoxData[
 RowBox[{"<<", "WorldPlot`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25297],

Cell["\<\
This gives a map of Africa with all countries drawn as white with black \
outlines. \
\>", "MathCaption",
 CellID->31871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldPlot", "[", "Africa", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18646],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Thickness[0.001], 
     LineBox[{{0, -2400}, {0, -2352}, {0, -2304}, {0, -2256}, {0, -2208}, {
      0, -2160}, {0, -2112}, {0, -2064}, {0, -2016}, {0, -1968}, {0, -1920}, {
      0, -1872}, {0, -1824}, {0, -1776}, {0, -1728}, {0, -1680}, {0, -1632}, {
      0, -1584}, {0, -1536}, {0, -1488}, {0, -1440}, {0, -1392}, {0, -1344}, {
      0, -1296}, {0, -1248}, {0, -1200}, {0, -1152}, {0, -1104}, {0, -1056}, {
      0, -1008}, {0, -960}, {0, -912}, {0, -864}, {0, -816}, {0, -768}, {
      0, -720}, {0, -672}, {0, -624}, {0, -576}, {0, -528}, {0, -480}, {
      0, -432}, {0, -384}, {0, -336}, {0, -288}, {0, -240}, {0, -192}, {
      0, -144}, {0, -96}, {0, -48}, {0, 0}, {0, 48}, {0, 96}, {0, 144}, {0, 
      192}, {0, 240}, {0, 288}, {0, 336}, {0, 384}, {0, 432}, {0, 480}, {0, 
      528}, {0, 576}, {0, 624}, {0, 672}, {0, 720}, {0, 768}, {0, 816}, {0, 
      864}, {0, 912}, {0, 960}, {0, 1008}, {0, 1056}, {0, 1104}, {0, 1152}, {
      0, 1200}, {0, 1248}, {0, 1296}, {0, 1344}, {0, 1392}, {0, 1440}, {0, 
      1488}, {0, 1536}, {0, 1584}, {0, 1632}, {0, 1680}, {0, 1728}, {0, 
      1776}, {0, 1824}, {0, 1872}, {0, 1920}, {0, 1968}, {0, 2016}, {0, 
      2064}, {0, 2112}, {0, 2160}, {0, 2208}, {0, 2256}, {0, 2304}, {0, 
      2352}, {0, 2400}, {0, 2400}}], 
     LineBox[{{1800, -2400}, {1800, -2352}, {1800, -2304}, {1800, -2256}, {
      1800, -2208}, {1800, -2160}, {1800, -2112}, {1800, -2064}, {
      1800, -2016}, {1800, -1968}, {1800, -1920}, {1800, -1872}, {
      1800, -1824}, {1800, -1776}, {1800, -1728}, {1800, -1680}, {
      1800, -1632}, {1800, -1584}, {1800, -1536}, {1800, -1488}, {
      1800, -1440}, {1800, -1392}, {1800, -1344}, {1800, -1296}, {
      1800, -1248}, {1800, -1200}, {1800, -1152}, {1800, -1104}, {
      1800, -1056}, {1800, -1008}, {1800, -960}, {1800, -912}, {1800, -864}, {
      1800, -816}, {1800, -768}, {1800, -720}, {1800, -672}, {1800, -624}, {
      1800, -576}, {1800, -528}, {1800, -480}, {1800, -432}, {1800, -384}, {
      1800, -336}, {1800, -288}, {1800, -240}, {1800, -192}, {1800, -144}, {
      1800, -96}, {1800, -48}, {1800, 0}, {1800, 48}, {1800, 96}, {1800, 
      144}, {1800, 192}, {1800, 240}, {1800, 288}, {1800, 336}, {1800, 384}, {
      1800, 432}, {1800, 480}, {1800, 528}, {1800, 576}, {1800, 624}, {1800, 
      672}, {1800, 720}, {1800, 768}, {1800, 816}, {1800, 864}, {1800, 912}, {
      1800, 960}, {1800, 1008}, {1800, 1056}, {1800, 1104}, {1800, 1152}, {
      1800, 1200}, {1800, 1248}, {1800, 1296}, {1800, 1344}, {1800, 1392}, {
      1800, 1440}, {1800, 1488}, {1800, 1536}, {1800, 1584}, {1800, 1632}, {
      1800, 1680}, {1800, 1728}, {1800, 1776}, {1800, 1824}, {1800, 1872}, {
      1800, 1920}, {1800, 1968}, {1800, 2016}, {1800, 2064}, {1800, 2112}, {
      1800, 2160}, {1800, 2208}, {1800, 2256}, {1800, 2304}, {1800, 2352}, {
      1800, 2400}, {1800, 2400}}], 
     LineBox[{{3600, -2400}, {3600, -2352}, {3600, -2304}, {3600, -2256}, {
      3600, -2208}, {3600, -2160}, {3600, -2112}, {3600, -2064}, {
      3600, -2016}, {3600, -1968}, {3600, -1920}, {3600, -1872}, {
      3600, -1824}, {3600, -1776}, {3600, -1728}, {3600, -1680}, {
      3600, -1632}, {3600, -1584}, {3600, -1536}, {3600, -1488}, {
      3600, -1440}, {3600, -1392}, {3600, -1344}, {3600, -1296}, {
      3600, -1248}, {3600, -1200}, {3600, -1152}, {3600, -1104}, {
      3600, -1056}, {3600, -1008}, {3600, -960}, {3600, -912}, {3600, -864}, {
      3600, -816}, {3600, -768}, {3600, -720}, {3600, -672}, {3600, -624}, {
      3600, -576}, {3600, -528}, {3600, -480}, {3600, -432}, {3600, -384}, {
      3600, -336}, {3600, -288}, {3600, -240}, {3600, -192}, {3600, -144}, {
      3600, -96}, {3600, -48}, {3600, 0}, {3600, 48}, {3600, 96}, {3600, 
      144}, {3600, 192}, {3600, 240}, {3600, 288}, {3600, 336}, {3600, 384}, {
      3600, 432}, {3600, 480}, {3600, 528}, {3600, 576}, {3600, 624}, {3600, 
      672}, {3600, 720}, {3600, 768}, {3600, 816}, {3600, 864}, {3600, 912}, {
      3600, 960}, {3600, 1008}, {3600, 1056}, {3600, 1104}, {3600, 1152}, {
      3600, 1200}, {3600, 1248}, {3600, 1296}, {3600, 1344}, {3600, 1392}, {
      3600, 1440}, {3600, 1488}, {3600, 1536}, {3600, 1584}, {3600, 1632}, {
      3600, 1680}, {3600, 1728}, {3600, 1776}, {3600, 1824}, {3600, 1872}, {
      3600, 1920}, {3600, 1968}, {3600, 2016}, {3600, 2064}, {3600, 2112}, {
      3600, 2160}, {3600, 2208}, {3600, 2256}, {3600, 2304}, {3600, 2352}, {
      3600, 2400}, {3600, 2400}}], 
     LineBox[{{-1200, -1800}, {-1152, -1800}, {-1104, -1800}, {-1056, -1800}, \
{-1008, -1800}, {-960, -1800}, {-912, -1800}, {-864, -1800}, {-816, -1800}, \
{-768, -1800}, {-720, -1800}, {-672, -1800}, {-624, -1800}, {-576, -1800}, \
{-528, -1800}, {-480, -1800}, {-432, -1800}, {-384, -1800}, {-336, -1800}, \
{-288, -1800}, {-240, -1800}, {-192, -1800}, {-144, -1800}, {-96, -1800}, \
{-48, -1800}, {0, -1800}, {48, -1800}, {96, -1800}, {144, -1800}, {
      192, -1800}, {240, -1800}, {288, -1800}, {336, -1800}, {384, -1800}, {
      432, -1800}, {480, -1800}, {528, -1800}, {576, -1800}, {624, -1800}, {
      672, -1800}, {720, -1800}, {768, -1800}, {816, -1800}, {864, -1800}, {
      912, -1800}, {960, -1800}, {1008, -1800}, {1056, -1800}, {
      1104, -1800}, {1152, -1800}, {1200, -1800}, {1248, -1800}, {
      1296, -1800}, {1344, -1800}, {1392, -1800}, {1440, -1800}, {
      1488, -1800}, {1536, -1800}, {1584, -1800}, {1632, -1800}, {
      1680, -1800}, {1728, -1800}, {1776, -1800}, {1824, -1800}, {
      1872, -1800}, {1920, -1800}, {1968, -1800}, {2016, -1800}, {
      2064, -1800}, {2112, -1800}, {2160, -1800}, {2208, -1800}, {
      2256, -1800}, {2304, -1800}, {2352, -1800}, {2400, -1800}, {
      2448, -1800}, {2496, -1800}, {2544, -1800}, {2592, -1800}, {
      2640, -1800}, {2688, -1800}, {2736, -1800}, {2784, -1800}, {
      2832, -1800}, {2880, -1800}, {2928, -1800}, {2976, -1800}, {
      3024, -1800}, {3072, -1800}, {3120, -1800}, {3168, -1800}, {
      3216, -1800}, {3264, -1800}, {3312, -1800}, {3360, -1800}, {
      3408, -1800}, {3456, -1800}, {3504, -1800}, {3552, -1800}, {
      3600, -1800}, {3600, -1800}}], 
     LineBox[{{-1200, 0}, {-1152, 0}, {-1104, 0}, {-1056, 0}, {-1008, 
      0}, {-960, 0}, {-912, 0}, {-864, 0}, {-816, 0}, {-768, 0}, {-720, 
      0}, {-672, 0}, {-624, 0}, {-576, 0}, {-528, 0}, {-480, 0}, {-432, 
      0}, {-384, 0}, {-336, 0}, {-288, 0}, {-240, 0}, {-192, 0}, {-144, 
      0}, {-96, 0}, {-48, 0}, {0, 0}, {48, 0}, {96, 0}, {144, 0}, {192, 0}, {
      240, 0}, {288, 0}, {336, 0}, {384, 0}, {432, 0}, {480, 0}, {528, 0}, {
      576, 0}, {624, 0}, {672, 0}, {720, 0}, {768, 0}, {816, 0}, {864, 0}, {
      912, 0}, {960, 0}, {1008, 0}, {1056, 0}, {1104, 0}, {1152, 0}, {1200, 
      0}, {1248, 0}, {1296, 0}, {1344, 0}, {1392, 0}, {1440, 0}, {1488, 0}, {
      1536, 0}, {1584, 0}, {1632, 0}, {1680, 0}, {1728, 0}, {1776, 0}, {1824, 
      0}, {1872, 0}, {1920, 0}, {1968, 0}, {2016, 0}, {2064, 0}, {2112, 0}, {
      2160, 0}, {2208, 0}, {2256, 0}, {2304, 0}, {2352, 0}, {2400, 0}, {2448, 
      0}, {2496, 0}, {2544, 0}, {2592, 0}, {2640, 0}, {2688, 0}, {2736, 0}, {
      2784, 0}, {2832, 0}, {2880, 0}, {2928, 0}, {2976, 0}, {3024, 0}, {3072, 
      0}, {3120, 0}, {3168, 0}, {3216, 0}, {3264, 0}, {3312, 0}, {3360, 0}, {
      3408, 0}, {3456, 0}, {3504, 0}, {3552, 0}, {3600, 0}, {3600, 0}}], 
     LineBox[{{-1200, 1800}, {-1152, 1800}, {-1104, 1800}, {-1056, 
      1800}, {-1008, 1800}, {-960, 1800}, {-912, 1800}, {-864, 1800}, {-816, 
      1800}, {-768, 1800}, {-720, 1800}, {-672, 1800}, {-624, 1800}, {-576, 
      1800}, {-528, 1800}, {-480, 1800}, {-432, 1800}, {-384, 1800}, {-336, 
      1800}, {-288, 1800}, {-240, 1800}, {-192, 1800}, {-144, 1800}, {-96, 
      1800}, {-48, 1800}, {0, 1800}, {48, 1800}, {96, 1800}, {144, 1800}, {
      192, 1800}, {240, 1800}, {288, 1800}, {336, 1800}, {384, 1800}, {432, 
      1800}, {480, 1800}, {528, 1800}, {576, 1800}, {624, 1800}, {672, 
      1800}, {720, 1800}, {768, 1800}, {816, 1800}, {864, 1800}, {912, 
      1800}, {960, 1800}, {1008, 1800}, {1056, 1800}, {1104, 1800}, {1152, 
      1800}, {1200, 1800}, {1248, 1800}, {1296, 1800}, {1344, 1800}, {1392, 
      1800}, {1440, 1800}, {1488, 1800}, {1536, 1800}, {1584, 1800}, {1632, 
      1800}, {1680, 1800}, {1728, 1800}, {1776, 1800}, {1824, 1800}, {1872, 
      1800}, {1920, 1800}, {1968, 1800}, {2016, 1800}, {2064, 1800}, {2112, 
      1800}, {2160, 1800}, {2208, 1800}, {2256, 1800}, {2304, 1800}, {2352, 
      1800}, {2400, 1800}, {2448, 1800}, {2496, 1800}, {2544, 1800}, {2592, 
      1800}, {2640, 1800}, {2688, 1800}, {2736, 1800}, {2784, 1800}, {2832, 
      1800}, {2880, 1800}, {2928, 1800}, {2976, 1800}, {3024, 1800}, {3072, 
      1800}, {3120, 1800}, {3168, 1800}, {3216, 1800}, {3264, 1800}, {3312, 
      1800}, {3360, 1800}, {3408, 1800}, {3456, 1800}, {3504, 1800}, {3552, 
      1800}, {3600, 1800}, {3600, 1800}}]}, {
     {GrayLevel[1], 
      TooltipBox[
       PolygonBox[{{517, 2216}, {0, 2150}, {-133, 2105}, {-71, 1926}, {-229, 
        1902}, {-218, 1858}, {-520, 1723}, {-520, 1660}, {-520, 1637}, {-288, 
        1500}, {0, 1310}, {255, 1149}, {720, 1411}, {564, 1569}, {572, 
        1814}, {450, 2033}, {517, 2216}}],
       "\"Algeria\""], 
      TooltipBox[
       PolygonBox[{{791, -352}, {735, -366}, {828, -708}, {706, -1035}, {
        831, -1040}, {1409, -1058}, {1320, -970}, {1320, -780}, {
        1441, -780}, {1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {
        1019, -435}, {991, -353}, {791, -351}}],
       "\"Angola\""], 
      TooltipBox[
       PolygonBox[{{98, 373}, {164, 382}, {214, 705}, {144, 713}, {58, 660}, {
        98, 373}}],
       "\"Benin\""], 
      TooltipBox[
       PolygonBox[{{1516, -1068}, {1260, -1099}, {1200, -1320}, {
        1200, -1486}, {1239, -1610}, {1368, -1539}, {1531, -1540}, {
        1763, -1332}, {1516, -1068}}],
       "\"Botswana\""], 
      TooltipBox[
       PolygonBox[{{-161, 569}, {-331, 626}, {-238, 810}, {0, 900}, {14, 
        900}, {144, 714}, {58, 660}, {-10, 668}, {-170, 660}, {-161, 569}}],
       "\"Burkina Faso\""], 
      TooltipBox[
       PolygonBox[{{1741, -165}, {1765, -267}, {1834, -144}, {1741, -165}}],
       "\"Burundi\""], 
      TooltipBox[
       PolygonBox[{{589, 141}, {585, 248}, {516, 289}, {588, 408}, {713, 
        425}, {879, 694}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {
        865, 363}, {972, 133}, {798, 130}, {680, 130}, {589, 141}}],
       "\"Cameroon\""], 
      TooltipBox[
       PolygonBox[{{930, 452}, {1115, 482}, {1366, 657}, {1373, 655}, {1411, 
        523}, {1647, 301}, {1340, 248}, {1152, 298}, {1118, 209}, {995, 
        209}, {972, 133}, {865, 363}, {930, 452}}],
       "\"CAR\""], 
      TooltipBox[
       PolygonBox[{{1440, 1170}, {960, 1410}, {900, 1380}, {960, 1221}, {929, 
        1014}, {818, 823}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {
        1115, 482}, {1366, 657}, {1310, 768}, {1376, 933}, {1440, 942}, {1440,
         1170}}],
       "\"Chad\""], 
      TooltipBox[
       PolygonBox[{{670, -237}, {722, -301}, {785, -278}, {954, -235}, {1118, 
        209}, {995, 209}, {972, 133}, {798, 130}, {790, 74}, {870, 56}, {
        867, -114}, {695, -140}, {670, -237}}],
       "\"Congo\""], 
      TooltipBox[
       PolygonBox[{{791, -352}, {732, -347}, {786, -278}, {954, -235}, {1118, 
        209}, {1152, 298}, {1340, 248}, {1647, 301}, {1852, 209}, {1878, 
        127}, {1776, -83}, {1742, -164}, {1765, -267}, {1846, -491}, {
        1702, -556}, {1702, -693}, {1788, -729}, {1788, -807}, {1632, -694}, {
        1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {1019, -435}, {
        991, -353}, {791, -352}}],
       "\"Democratic Republic of the Congo\""], 
      TooltipBox[
       PolygonBox[{{2597, 691}, {2551, 692}, {2587, 763}, {2506, 691}, {2577, 
        660}, {2597, 691}}],
       "\"Djibouti\""], 
      TooltipBox[
       PolygonBox[{{2137, 1388}, {1940, 1776}, {2055, 1664}, {2098, 1773}, {
        2094, 1769}, {2056, 1873}, {2053, 1880}, {1509, 1899}, {1500, 1320}, {
        2036, 1305}, {2137, 1388}}],
       "\"Egypt\""], 
      TooltipBox[
       PolygonBox[{{588, 60}, {589, 141}, {680, 130}, {681, 60}, {588, 60}}],
       "\"Equatorial Guinea\""], 
      TooltipBox[
       PolygonBox[{{2188, 862}, {2220, 1024}, {2317, 1082}, {2383, 905}, {
        2587, 763}, {2560, 739}, {2330, 878}, {2188, 862}}],
       "\"Eritrea\""], 
      TooltipBox[
       PolygonBox[{{2188, 862}, {2330, 878}, {2560, 739}, {2506, 691}, {2577, 
        660}, {2641, 540}, {2879, 480}, {2697, 294}, {2514, 239}, {2371, 
        206}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 762}, {2188, 
        862}}],
       "\"Ethiopia\""], 
      TooltipBox[
       PolygonBox[{{588, 60}, {523, -38}, {670, -237}, {695, -140}, {
        867, -114}, {870, 56}, {790, 74}, {798, 130}, {680, 130}, {681, 60}, {
        588, 60}}],
       "\"Gabon\""], 
      TooltipBox[
       PolygonBox[{{-186, 305}, {0, 337}, {72, 366}, {0, 636}, {-5, 642}, {0, 
        666}, {-9, 668}, {-170, 660}, {-161, 569}, {-186, 305}}],
       "\"Ghana\""], 
      TooltipBox[
       PolygonBox[{{-798, 542}, {-901, 657}, {-823, 761}, {-681, 748}, {-682, 
        744}, {-539, 744}, {-479, 609}, {-478, 610}, {-508, 454}, {-616, 
        509}, {-673, 600}, {-798, 542}}],
       "\"Guinea\""], 
      TooltipBox[
       PolygonBox[{{-1003, 739}, {-900, 718}, {-930, 680}, {-901, 657}, {-823,
         761}, {-1003, 739}}],
       "\"Guinea-Bissau\""], 
      TooltipBox[
       PolygonBox[{{-452, 261}, {-186, 305}, {-186, 305}, {-161, 569}, {-161, 
        569}, {-331, 627}, {-331, 626}, {-478, 610}, {-478, 610}, {-508, 
        454}, {-508, 454}, {-451, 261}}],
       "\"Cote d'Ivoire\""], 
      TooltipBox[
       PolygonBox[{{2494, -100}, {2352, -280}, {2035, -60}, {2102, 115}, {
        2040, 253}, {2156, 277}, {2371, 206}, {2515, 239}, {2459, 170}, {
        2494, -100}}],
       "\"Kenya\""], 
      TooltipBox[
       PolygonBox[{{-690, 416}, {-452, 261}, {-508, 454}, {-616, 509}, {-690, 
        416}}],
       "\"Liberia\""], 
      TooltipBox[
       PolygonBox[{{692, 1990}, {955, 1879}, {1160, 1817}, {1303, 1977}, {
        1509, 1899}, {1500, 1320}, {1500, 1320}, {1500, 1200}, {1440, 1170}, {
        960, 1410}, {898, 1379}, {720, 1411}, {564, 1569}, {572, 1814}, {692, 
        1990}}],
       "\"Libya\""], 
      TooltipBox[
       PolygonBox[{{2599, -1312}, {2671, -1197}, {2668, -971}, {2880, -886}, {
        2957, -717}, {3030, -919}, {2978, -933}, {2828, -1499}, {
        2644, -1497}, {2599, -1312}}],
       "\"Madagascar\""], 
      TooltipBox[
       PolygonBox[{{1979, -569}, {2060, -584}, {2097, -694}, {2074, -801}, {
        2155, -893}, {2117, -1028}, {2072, -875}, {1993, -841}, {
        1979, -569}}],
       "\"Malawi\""], 
      TooltipBox[
       PolygonBox[{{255, 1149}, {0, 1310}, {-288, 1500}, {-395, 1500}, {-330, 
        930}, {-690, 939}, {-723, 884}, {-735, 886}, {-681, 748}, {-682, 
        744}, {-539, 744}, {-478, 610}, {-331, 626}, {-238, 810}, {0, 900}, {
        14, 900}, {233, 943}, {255, 1149}}],
       "\"Mali\""], 
      TooltipBox[
       PolygonBox[{{-1023, 1246}, {-972, 1213}, {-992, 963}, {-803, 
        962}, {-723, 883}, {-690, 939}, {-330, 930}, {-395, 1500}, {-288, 
        1500}, {-520, 1638}, {-520, 1560}, {-720, 1560}, {-786, 1374}, {-780, 
        1280}, {-1023, 1246}}],
       "\"Mauritania\""], 
      TooltipBox[
       PolygonBox[{{-132, 2106}, {-325, 2155}, {-374, 2101}, {-557, 
        1953}, {-614, 1759}, {-791, 1660}, {-520, 1660}, {-520, 1723}, {-218, 
        1858}, {-229, 1902}, {-71, 1926}, {-132, 2106}}],
       "\"Morocco\""], 
      TooltipBox[
       PolygonBox[{{2426, -629}, {2440, -917}, {2074, -1177}, {2130, -1446}, {
        1969, -1536}, {1974, -1611}, {1928, -1610}, {1918, -1557}, {
        1878, -1345}, {1982, -1202}, {1979, -1003}, {1825, -938}, {
        1993, -841}, {2072, -875}, {2117, -1028}, {2155, -893}, {
        2074, -801}, {2097, -694}, {2426, -629}}],
       "\"Mozambique\""], 
      TooltipBox[
       PolygonBox[{{706, -1035}, {872, -1361}, {867, -1388}, {989, -1715}, {
        1200, -1706}, {1200, -1486}, {1200, -1320}, {1260, -1099}, {
        1516, -1068}, {1409, -1058}, {831, -1040}, {706, -1035}}],
       "\"Namibia\""], 
      TooltipBox[
       PolygonBox[{{898, 1379}, {719, 1411}, {255, 1149}, {233, 943}, {14, 
        900}, {144, 714}, {214, 705}, {216, 702}, {293, 827}, {578, 768}, {
        818, 823}, {929, 1014}, {960, 1221}, {898, 1379}}],
       "\"Niger\""], 
      TooltipBox[
       PolygonBox[{{515, 288}, {366, 256}, {317, 354}, {163, 382}, {214, 
        705}, {216, 702}, {293, 827}, {578, 768}, {818, 823}, {845, 784}, {
        879, 694}, {713, 425}, {588, 408}, {515, 288}}],
       "\"Nigeria\""], 
      TooltipBox[
       PolygonBox[{{989, -1715}, {1099, -2050}, {1200, -2089}, {
        1674, -1982}, {1974, -1611}, {1928, -1610}, {1849, -1608}, {
        1918, -1558}, {1878, -1345}, {1762, -1331}, {1531, -1540}, {
        1368, -1539}, {1239, -1610}, {1200, -1486}, {1200, -1706}, {
        989, -1715}}],
       "\"South Africa\""], 
      TooltipBox[
       PolygonBox[{{1722, -1717}, {1621, -1778}, {1686, -1840}, {
        1767, -1761}, {1722, -1717}}],
       "\"Lesotho\""], 
      TooltipBox[
       PolygonBox[{{1776, -83}, {1741, -165}, {1834, -144}, {1829, -64}, {
        1776, -83}}],
       "\"Rwanda\""], 
      TooltipBox[
       PolygonBox[{{-992, 964}, {-1052, 885}, {-994, 815}, {-828, 
        803}, {-1005, 784}, {-923, 770}, {-1003, 739}, {-823, 761}, {-681, 
        748}, {-735, 886}, {-723, 883}, {-803, 962}, {-992, 963}}],
       "\"Senegal\""], 
      TooltipBox[
       PolygonBox[{{-798, 542}, {-689, 416}, {-615, 509}, {-673, 600}, {-798, 
        542}}],
       "\"Sierra Leone\""], 
      TooltipBox[
       PolygonBox[{{2493, -100}, {2877, 268}, {3085, 627}, {3047, 720}, {2695,
         625}, {2597, 691}, {2595, 689}, {2577, 660}, {2641, 540}, {2879, 
        480}, {2697, 294}, {2514, 239}, {2459, 170}, {2493, -100}}],
       "\"Somalia\""], 
      TooltipBox[
       PolygonBox[{{2317, 1082}, {2214, 1322}, {2137, 1388}, {2036, 1305}, {
        1500, 1320}, {1500, 1200}, {1440, 1170}, {1440, 942}, {1376, 933}, {
        1310, 768}, {1366, 657}, {1373, 655}, {1411, 523}, {1647, 301}, {1852,
         209}, {2040, 253}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 
        762}, {2220, 1024}, {2317, 1082}}],
       "\"Sudan\""], 
      TooltipBox[
       PolygonBox[{{1928, -1610}, {1918, -1557}, {1849, -1608}, {
        1928, -1610}}],
       "\"Swaziland\""], 
      TooltipBox[
       PolygonBox[{{2426, -629}, {2327, -363}, {2352, -280}, {2035, -60}, {
        1829, -64}, {1834, -144}, {1765, -267}, {1846, -491}, {1979, -565}, {
        2060, -584}, {2098, -694}, {2426, -629}}],
       "\"Tanzania\""], 
      TooltipBox[
       PolygonBox[{{-994, 815}, {-918, 807}, {-1005, 782}, {-1005, 
        784}, {-828, 803}, {-994, 815}}],
       "\"The Gambia\""], 
      TooltipBox[
       PolygonBox[{{72, 366}, {99, 373}, {55, 660}, {-10, 668}, {0, 666}, {-5,
         642}, {0, 636}, {72, 366}}],
       "\"Togo\""], 
      TooltipBox[
       PolygonBox[{{517, 2216}, {663, 2225}, {600, 2050}, {692, 1990}, {572, 
        1814}, {450, 2033}, {517, 2216}}],
       "\"Tunisia\""], 
      TooltipBox[
       PolygonBox[{{1852, 209}, {1878, 127}, {1776, -83}, {1829, -64}, {
        2035, -60}, {2102, 115}, {2040, 253}, {1852, 209}}],
       "\"Uganda\""], 
      TooltipBox[
       PolygonBox[{{-791, 1660}, {-1023, 1246}, {-780, 1280}, {-786, 
        1374}, {-720, 1560}, {-520, 1560}, {-520, 1638}, {-520, 1660}, {-791, 
        1660}}],
       "\"Western Sahara\""], 
      TooltipBox[
       PolygonBox[{{1846, -491}, {1702, -556}, {1702, -693}, {1788, -729}, {
        1788, -807}, {1632, -694}, {1439, -652}, {1441, -780}, {1320, -780}, {
        1320, -970}, {1409, -1058}, {1516, -1068}, {1629, -1068}, {
        1825, -938}, {1993, -841}, {1979, -569}, {1979, -565}, {1846, -492}}],
       
       "\"Zambia\""], 
      TooltipBox[
       PolygonBox[{{1878, -1345}, {1762, -1331}, {1516, -1068}, {
        1629, -1068}, {1825, -938}, {1979, -1003}, {1982, -1202}, {
        1878, -1345}}],
       "\"Zimbabwe\""]}, 
     {GrayLevel[0], Thickness[0.001], 
      LineBox[{{517, 2216}, {0, 2150}, {-133, 2105}, {-71, 1926}, {-229, 
       1902}, {-218, 1858}, {-520, 1723}, {-520, 1660}, {-520, 1637}, {-288, 
       1500}, {0, 1310}, {255, 1149}, {720, 1411}, {564, 1569}, {572, 1814}, {
       450, 2033}, {517, 2216}}], 
      LineBox[{{791, -352}, {735, -366}, {828, -708}, {706, -1035}, {
       831, -1040}, {1409, -1058}, {1320, -970}, {1320, -780}, {1441, -780}, {
       1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {1019, -435}, {
       991, -353}, {791, -351}}], 
      LineBox[{{98, 373}, {164, 382}, {214, 705}, {144, 713}, {58, 660}, {98, 
       373}}], LineBox[{{1516, -1068}, {1260, -1099}, {1200, -1320}, {
       1200, -1486}, {1239, -1610}, {1368, -1539}, {1531, -1540}, {
       1763, -1332}, {1516, -1068}}], 
      LineBox[{{-161, 569}, {-331, 626}, {-238, 810}, {0, 900}, {14, 900}, {
       144, 714}, {58, 660}, {-10, 668}, {-170, 660}, {-161, 569}}], 
      LineBox[{{1741, -165}, {1765, -267}, {1834, -144}, {1741, -165}}], 
      LineBox[{{589, 141}, {585, 248}, {516, 289}, {588, 408}, {713, 425}, {
       879, 694}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {865, 
       363}, {972, 133}, {798, 130}, {680, 130}, {589, 141}}], 
      LineBox[{{930, 452}, {1115, 482}, {1366, 657}, {1373, 655}, {1411, 
       523}, {1647, 301}, {1340, 248}, {1152, 298}, {1118, 209}, {995, 209}, {
       972, 133}, {865, 363}, {930, 452}}], 
      LineBox[{{1440, 1170}, {960, 1410}, {900, 1380}, {960, 1221}, {929, 
       1014}, {818, 823}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {
       1115, 482}, {1366, 657}, {1310, 768}, {1376, 933}, {1440, 942}, {1440, 
       1170}}], 
      LineBox[{{670, -237}, {722, -301}, {785, -278}, {954, -235}, {1118, 
       209}, {995, 209}, {972, 133}, {798, 130}, {790, 74}, {870, 56}, {
       867, -114}, {695, -140}, {670, -237}}], 
      LineBox[{{791, -352}, {732, -347}, {786, -278}, {954, -235}, {1118, 
       209}, {1152, 298}, {1340, 248}, {1647, 301}, {1852, 209}, {1878, 
       127}, {1776, -83}, {1742, -164}, {1765, -267}, {1846, -491}, {
       1702, -556}, {1702, -693}, {1788, -729}, {1788, -807}, {1632, -694}, {
       1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {1019, -435}, {
       991, -353}, {791, -352}}], 
      LineBox[{{2597, 691}, {2551, 692}, {2587, 763}, {2506, 691}, {2577, 
       660}, {2597, 691}}], 
      LineBox[{{2137, 1388}, {1940, 1776}, {2055, 1664}, {2098, 1773}, {2094, 
       1769}, {2056, 1873}, {2053, 1880}, {1509, 1899}, {1500, 1320}, {2036, 
       1305}, {2137, 1388}}], 
      LineBox[{{588, 60}, {589, 141}, {680, 130}, {681, 60}, {588, 60}}], 
      LineBox[{{2188, 862}, {2220, 1024}, {2317, 1082}, {2383, 905}, {2587, 
       763}, {2560, 739}, {2330, 878}, {2188, 862}}], 
      LineBox[{{2188, 862}, {2330, 878}, {2560, 739}, {2506, 691}, {2577, 
       660}, {2641, 540}, {2879, 480}, {2697, 294}, {2514, 239}, {2371, 
       206}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 762}, {2188, 
       862}}], LineBox[{{588, 60}, {523, -38}, {670, -237}, {695, -140}, {
       867, -114}, {870, 56}, {790, 74}, {798, 130}, {680, 130}, {681, 60}, {
       588, 60}}], 
      LineBox[{{-186, 305}, {0, 337}, {72, 366}, {0, 636}, {-5, 642}, {0, 
       666}, {-9, 668}, {-170, 660}, {-161, 569}, {-186, 305}}], 
      LineBox[{{-798, 542}, {-901, 657}, {-823, 761}, {-681, 748}, {-682, 
       744}, {-539, 744}, {-479, 609}, {-478, 610}, {-508, 454}, {-616, 
       509}, {-673, 600}, {-798, 542}}], 
      LineBox[{{-1003, 739}, {-900, 718}, {-930, 680}, {-901, 657}, {-823, 
       761}, {-1003, 739}}], 
      LineBox[{{-452, 261}, {-186, 305}, {-186, 305}, {-161, 569}, {-161, 
       569}, {-331, 627}, {-331, 626}, {-478, 610}, {-478, 610}, {-508, 
       454}, {-508, 454}, {-451, 261}}], 
      LineBox[{{2494, -100}, {2352, -280}, {2035, -60}, {2102, 115}, {2040, 
       253}, {2156, 277}, {2371, 206}, {2515, 239}, {2459, 170}, {
       2494, -100}}], 
      LineBox[{{-690, 416}, {-452, 261}, {-508, 454}, {-616, 509}, {-690, 
       416}}], LineBox[{{692, 1990}, {955, 1879}, {1160, 1817}, {1303, 
       1977}, {1509, 1899}, {1500, 1320}, {1500, 1320}, {1500, 1200}, {1440, 
       1170}, {960, 1410}, {898, 1379}, {720, 1411}, {564, 1569}, {572, 
       1814}, {692, 1990}}], 
      LineBox[{{2599, -1312}, {2671, -1197}, {2668, -971}, {2880, -886}, {
       2957, -717}, {3030, -919}, {2978, -933}, {2828, -1499}, {
       2644, -1497}, {2599, -1312}}], 
      LineBox[{{1979, -569}, {2060, -584}, {2097, -694}, {2074, -801}, {
       2155, -893}, {2117, -1028}, {2072, -875}, {1993, -841}, {1979, -569}}],
       LineBox[{{255, 1149}, {0, 1310}, {-288, 1500}, {-395, 1500}, {-330, 
       930}, {-690, 939}, {-723, 884}, {-735, 886}, {-681, 748}, {-682, 
       744}, {-539, 744}, {-478, 610}, {-331, 626}, {-238, 810}, {0, 900}, {
       14, 900}, {233, 943}, {255, 1149}}], 
      LineBox[{{-1023, 1246}, {-972, 1213}, {-992, 963}, {-803, 962}, {-723, 
       883}, {-690, 939}, {-330, 930}, {-395, 1500}, {-288, 1500}, {-520, 
       1638}, {-520, 1560}, {-720, 1560}, {-786, 1374}, {-780, 1280}, {-1023, 
       1246}}], 
      LineBox[{{-132, 2106}, {-325, 2155}, {-374, 2101}, {-557, 1953}, {-614, 
       1759}, {-791, 1660}, {-520, 1660}, {-520, 1723}, {-218, 1858}, {-229, 
       1902}, {-71, 1926}, {-132, 2106}}], 
      LineBox[{{2426, -629}, {2440, -917}, {2074, -1177}, {2130, -1446}, {
       1969, -1536}, {1974, -1611}, {1928, -1610}, {1918, -1557}, {
       1878, -1345}, {1982, -1202}, {1979, -1003}, {1825, -938}, {
       1993, -841}, {2072, -875}, {2117, -1028}, {2155, -893}, {2074, -801}, {
       2097, -694}, {2426, -629}}], 
      LineBox[{{706, -1035}, {872, -1361}, {867, -1388}, {989, -1715}, {
       1200, -1706}, {1200, -1486}, {1200, -1320}, {1260, -1099}, {
       1516, -1068}, {1409, -1058}, {831, -1040}, {706, -1035}}], 
      LineBox[{{898, 1379}, {719, 1411}, {255, 1149}, {233, 943}, {14, 900}, {
       144, 714}, {214, 705}, {216, 702}, {293, 827}, {578, 768}, {818, 
       823}, {929, 1014}, {960, 1221}, {898, 1379}}], 
      LineBox[{{515, 288}, {366, 256}, {317, 354}, {163, 382}, {214, 705}, {
       216, 702}, {293, 827}, {578, 768}, {818, 823}, {845, 784}, {879, 
       694}, {713, 425}, {588, 408}, {515, 288}}], 
      LineBox[{{989, -1715}, {1099, -2050}, {1200, -2089}, {1674, -1982}, {
       1974, -1611}, {1928, -1610}, {1849, -1608}, {1918, -1558}, {
       1878, -1345}, {1762, -1331}, {1531, -1540}, {1368, -1539}, {
       1239, -1610}, {1200, -1486}, {1200, -1706}, {989, -1715}}], 
      LineBox[{{1722, -1717}, {1621, -1778}, {1686, -1840}, {1767, -1761}, {
       1722, -1717}}], 
      LineBox[{{1776, -83}, {1741, -165}, {1834, -144}, {1829, -64}, {
       1776, -83}}], 
      LineBox[{{-992, 964}, {-1052, 885}, {-994, 815}, {-828, 803}, {-1005, 
       784}, {-923, 770}, {-1003, 739}, {-823, 761}, {-681, 748}, {-735, 
       886}, {-723, 883}, {-803, 962}, {-992, 963}}], 
      LineBox[{{-798, 542}, {-689, 416}, {-615, 509}, {-673, 600}, {-798, 
       542}}], LineBox[{{2493, -100}, {2877, 268}, {3085, 627}, {3047, 720}, {
       2695, 625}, {2597, 691}, {2595, 689}, {2577, 660}, {2641, 540}, {2879, 
       480}, {2697, 294}, {2514, 239}, {2459, 170}, {2493, -100}}], 
      LineBox[{{2317, 1082}, {2214, 1322}, {2137, 1388}, {2036, 1305}, {1500, 
       1320}, {1500, 1200}, {1440, 1170}, {1440, 942}, {1376, 933}, {1310, 
       768}, {1366, 657}, {1373, 655}, {1411, 523}, {1647, 301}, {1852, 
       209}, {2040, 253}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 
       762}, {2220, 1024}, {2317, 1082}}], 
      LineBox[{{1928, -1610}, {1918, -1557}, {1849, -1608}, {1928, -1610}}], 
      LineBox[{{2426, -629}, {2327, -363}, {2352, -280}, {2035, -60}, {
       1829, -64}, {1834, -144}, {1765, -267}, {1846, -491}, {1979, -565}, {
       2060, -584}, {2098, -694}, {2426, -629}}], 
      LineBox[{{-994, 815}, {-918, 807}, {-1005, 782}, {-1005, 784}, {-828, 
       803}, {-994, 815}}], 
      LineBox[{{72, 366}, {99, 373}, {55, 660}, {-10, 668}, {0, 666}, {-5, 
       642}, {0, 636}, {72, 366}}], 
      LineBox[{{517, 2216}, {663, 2225}, {600, 2050}, {692, 1990}, {572, 
       1814}, {450, 2033}, {517, 2216}}], 
      LineBox[{{1852, 209}, {1878, 127}, {1776, -83}, {1829, -64}, {
       2035, -60}, {2102, 115}, {2040, 253}, {1852, 209}}], 
      LineBox[{{-791, 1660}, {-1023, 1246}, {-780, 1280}, {-786, 1374}, {-720,
        1560}, {-520, 1560}, {-520, 1638}, {-520, 1660}, {-791, 1660}}], 
      LineBox[{{1846, -491}, {1702, -556}, {1702, -693}, {1788, -729}, {
       1788, -807}, {1632, -694}, {1439, -652}, {1441, -780}, {1320, -780}, {
       1320, -970}, {1409, -1058}, {1516, -1068}, {1629, -1068}, {
       1825, -938}, {1993, -841}, {1979, -569}, {1979, -565}, {1846, -492}}], 
      LineBox[{{1878, -1345}, {1762, -1331}, {1516, -1068}, {1629, -1068}, {
       1825, -938}, {1979, -1003}, {1982, -1202}, {1878, -1345}}]}}}, 
   {Thickness[0.001], 
    LineBox[{{3600, 2400}, {3600, 2400}, {3600, 2352}, {3600, 2304}, {3600, 
     2256}, {3600, 2208}, {3600, 2160}, {3600, 2112}, {3600, 2064}, {3600, 
     2016}, {3600, 1968}, {3600, 1920}, {3600, 1872}, {3600, 1824}, {3600, 
     1776}, {3600, 1728}, {3600, 1680}, {3600, 1632}, {3600, 1584}, {3600, 
     1536}, {3600, 1488}, {3600, 1440}, {3600, 1392}, {3600, 1344}, {3600, 
     1296}, {3600, 1248}, {3600, 1200}, {3600, 1152}, {3600, 1104}, {3600, 
     1056}, {3600, 1008}, {3600, 960}, {3600, 912}, {3600, 864}, {3600, 
     816}, {3600, 768}, {3600, 720}, {3600, 672}, {3600, 624}, {3600, 576}, {
     3600, 528}, {3600, 480}, {3600, 432}, {3600, 384}, {3600, 336}, {3600, 
     288}, {3600, 240}, {3600, 192}, {3600, 144}, {3600, 96}, {3600, 48}, {
     3600, 0}, {3600, -48}, {3600, -96}, {3600, -144}, {3600, -192}, {
     3600, -240}, {3600, -288}, {3600, -336}, {3600, -384}, {3600, -432}, {
     3600, -480}, {3600, -528}, {3600, -576}, {3600, -624}, {3600, -672}, {
     3600, -720}, {3600, -768}, {3600, -816}, {3600, -864}, {3600, -912}, {
     3600, -960}, {3600, -1008}, {3600, -1056}, {3600, -1104}, {
     3600, -1152}, {3600, -1200}, {3600, -1248}, {3600, -1296}, {
     3600, -1344}, {3600, -1392}, {3600, -1440}, {3600, -1488}, {
     3600, -1536}, {3600, -1584}, {3600, -1632}, {3600, -1680}, {
     3600, -1728}, {3600, -1776}, {3600, -1824}, {3600, -1872}, {
     3600, -1920}, {3600, -1968}, {3600, -2016}, {3600, -2064}, {
     3600, -2112}, {3600, -2160}, {3600, -2208}, {3600, -2256}, {
     3600, -2304}, {3600, -2352}, {3600, -2400}}], 
    LineBox[{{3600, -2400}, {3600, -2400}, {3552, -2400}, {3504, -2400}, {
     3456, -2400}, {3408, -2400}, {3360, -2400}, {3312, -2400}, {
     3264, -2400}, {3216, -2400}, {3168, -2400}, {3120, -2400}, {
     3072, -2400}, {3024, -2400}, {2976, -2400}, {2928, -2400}, {
     2880, -2400}, {2832, -2400}, {2784, -2400}, {2736, -2400}, {
     2688, -2400}, {2640, -2400}, {2592, -2400}, {2544, -2400}, {
     2496, -2400}, {2448, -2400}, {2400, -2400}, {2352, -2400}, {
     2304, -2400}, {2256, -2400}, {2208, -2400}, {2160, -2400}, {
     2112, -2400}, {2064, -2400}, {2016, -2400}, {1968, -2400}, {
     1920, -2400}, {1872, -2400}, {1824, -2400}, {1776, -2400}, {
     1728, -2400}, {1680, -2400}, {1632, -2400}, {1584, -2400}, {
     1536, -2400}, {1488, -2400}, {1440, -2400}, {1392, -2400}, {
     1344, -2400}, {1296, -2400}, {1248, -2400}, {1200, -2400}, {
     1152, -2400}, {1104, -2400}, {1056, -2400}, {1008, -2400}, {
     960, -2400}, {912, -2400}, {864, -2400}, {816, -2400}, {768, -2400}, {
     720, -2400}, {672, -2400}, {624, -2400}, {576, -2400}, {528, -2400}, {
     480, -2400}, {432, -2400}, {384, -2400}, {336, -2400}, {288, -2400}, {
     240, -2400}, {192, -2400}, {144, -2400}, {96, -2400}, {48, -2400}, {
     0, -2400}, {-48, -2400}, {-96, -2400}, {-144, -2400}, {-192, -2400}, \
{-240, -2400}, {-288, -2400}, {-336, -2400}, {-384, -2400}, {-432, -2400}, \
{-480, -2400}, {-528, -2400}, {-576, -2400}, {-624, -2400}, {-672, -2400}, \
{-720, -2400}, {-768, -2400}, {-816, -2400}, {-864, -2400}, {-912, -2400}, \
{-960, -2400}, {-1008, -2400}, {-1056, -2400}, {-1104, -2400}, {-1152, \
-2400}, {-1200, -2400}}], 
    LineBox[{{-1200, -2400}, {-1200, -2352}, {-1200, -2304}, {-1200, -2256}, \
{-1200, -2208}, {-1200, -2160}, {-1200, -2112}, {-1200, -2064}, {-1200, \
-2016}, {-1200, -1968}, {-1200, -1920}, {-1200, -1872}, {-1200, -1824}, \
{-1200, -1776}, {-1200, -1728}, {-1200, -1680}, {-1200, -1632}, {-1200, \
-1584}, {-1200, -1536}, {-1200, -1488}, {-1200, -1440}, {-1200, -1392}, \
{-1200, -1344}, {-1200, -1296}, {-1200, -1248}, {-1200, -1200}, {-1200, \
-1152}, {-1200, -1104}, {-1200, -1056}, {-1200, -1008}, {-1200, -960}, \
{-1200, -912}, {-1200, -864}, {-1200, -816}, {-1200, -768}, {-1200, -720}, \
{-1200, -672}, {-1200, -624}, {-1200, -576}, {-1200, -528}, {-1200, -480}, \
{-1200, -432}, {-1200, -384}, {-1200, -336}, {-1200, -288}, {-1200, -240}, \
{-1200, -192}, {-1200, -144}, {-1200, -96}, {-1200, -48}, {-1200, 0}, {-1200, 
     48}, {-1200, 96}, {-1200, 144}, {-1200, 192}, {-1200, 240}, {-1200, 
     288}, {-1200, 336}, {-1200, 384}, {-1200, 432}, {-1200, 480}, {-1200, 
     528}, {-1200, 576}, {-1200, 624}, {-1200, 672}, {-1200, 720}, {-1200, 
     768}, {-1200, 816}, {-1200, 864}, {-1200, 912}, {-1200, 960}, {-1200, 
     1008}, {-1200, 1056}, {-1200, 1104}, {-1200, 1152}, {-1200, 
     1200}, {-1200, 1248}, {-1200, 1296}, {-1200, 1344}, {-1200, 
     1392}, {-1200, 1440}, {-1200, 1488}, {-1200, 1536}, {-1200, 
     1584}, {-1200, 1632}, {-1200, 1680}, {-1200, 1728}, {-1200, 
     1776}, {-1200, 1824}, {-1200, 1872}, {-1200, 1920}, {-1200, 
     1968}, {-1200, 2016}, {-1200, 2064}, {-1200, 2112}, {-1200, 
     2160}, {-1200, 2208}, {-1200, 2256}, {-1200, 2304}, {-1200, 
     2352}, {-1200, 2400}, {-1200, 2400}}], 
    LineBox[{{-1200, 2400}, {-1152, 2400}, {-1104, 2400}, {-1056, 
     2400}, {-1008, 2400}, {-960, 2400}, {-912, 2400}, {-864, 2400}, {-816, 
     2400}, {-768, 2400}, {-720, 2400}, {-672, 2400}, {-624, 2400}, {-576, 
     2400}, {-528, 2400}, {-480, 2400}, {-432, 2400}, {-384, 2400}, {-336, 
     2400}, {-288, 2400}, {-240, 2400}, {-192, 2400}, {-144, 2400}, {-96, 
     2400}, {-48, 2400}, {0, 2400}, {48, 2400}, {96, 2400}, {144, 2400}, {192,
      2400}, {240, 2400}, {288, 2400}, {336, 2400}, {384, 2400}, {432, 
     2400}, {480, 2400}, {528, 2400}, {576, 2400}, {624, 2400}, {672, 2400}, {
     720, 2400}, {768, 2400}, {816, 2400}, {864, 2400}, {912, 2400}, {960, 
     2400}, {1008, 2400}, {1056, 2400}, {1104, 2400}, {1152, 2400}, {1200, 
     2400}, {1248, 2400}, {1296, 2400}, {1344, 2400}, {1392, 2400}, {1440, 
     2400}, {1488, 2400}, {1536, 2400}, {1584, 2400}, {1632, 2400}, {1680, 
     2400}, {1728, 2400}, {1776, 2400}, {1824, 2400}, {1872, 2400}, {1920, 
     2400}, {1968, 2400}, {2016, 2400}, {2064, 2400}, {2112, 2400}, {2160, 
     2400}, {2208, 2400}, {2256, 2400}, {2304, 2400}, {2352, 2400}, {2400, 
     2400}, {2448, 2400}, {2496, 2400}, {2544, 2400}, {2592, 2400}, {2640, 
     2400}, {2688, 2400}, {2736, 2400}, {2784, 2400}, {2832, 2400}, {2880, 
     2400}, {2928, 2400}, {2976, 2400}, {3024, 2400}, {3072, 2400}, {3120, 
     2400}, {3168, 2400}, {3216, 2400}, {3264, 2400}, {3312, 2400}, {3360, 
     2400}, {3408, 2400}, {3456, 2400}, {3504, 2400}, {3552, 2400}, {3600, 
     2400}, {3600, 2400}}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->727051308]
}, Open  ]],

Cell["\<\
Here is a map of the world with each country colored with a randomly chosen \
gray level. \
\>", "MathCaption",
 CellID->10328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldPlot", "[", 
  RowBox[{"{", 
   RowBox[{"World", ",", "RandomColors"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1746],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Thickness[0.001], 
     LineBox[{{-10800, -5400}, {-10800, -5184}, {-10800, -4968}, {-10800, \
-4752}, {-10800, -4536}, {-10800, -4320}, {-10800, -4104}, {-10800, -3888}, \
{-10800, -3672}, {-10800, -3456}, {-10800, -3240}, {-10800, -3024}, {-10800, \
-2808}, {-10800, -2592}, {-10800, -2376}, {-10800, -2160}, {-10800, -1944}, \
{-10800, -1728}, {-10800, -1512}, {-10800, -1296}, {-10800, -1080}, {-10800, \
-864}, {-10800, -648}, {-10800, -432}, {-10800, -216}, {-10800, 0}, {-10800, 
      216}, {-10800, 432}, {-10800, 648}, {-10800, 864}, {-10800, 
      1080}, {-10800, 1296}, {-10800, 1512}, {-10800, 1728}, {-10800, 
      1944}, {-10800, 2160}, {-10800, 2376}, {-10800, 2592}, {-10800, 
      2808}, {-10800, 3024}, {-10800, 3240}, {-10800, 3456}, {-10800, 
      3672}, {-10800, 3888}, {-10800, 4104}, {-10800, 4320}, {-10800, 
      4536}, {-10800, 4752}, {-10800, 4968}, {-10800, 5184}, {-10800, 
      5400}, {-10800, 5400}}], 
     LineBox[{{-9000, -5400}, {-9000, -5184}, {-9000, -4968}, {-9000, -4752}, \
{-9000, -4536}, {-9000, -4320}, {-9000, -4104}, {-9000, -3888}, {-9000, \
-3672}, {-9000, -3456}, {-9000, -3240}, {-9000, -3024}, {-9000, -2808}, \
{-9000, -2592}, {-9000, -2376}, {-9000, -2160}, {-9000, -1944}, {-9000, \
-1728}, {-9000, -1512}, {-9000, -1296}, {-9000, -1080}, {-9000, -864}, \
{-9000, -648}, {-9000, -432}, {-9000, -216}, {-9000, 0}, {-9000, 216}, {-9000,
       432}, {-9000, 648}, {-9000, 864}, {-9000, 1080}, {-9000, 1296}, {-9000,
       1512}, {-9000, 1728}, {-9000, 1944}, {-9000, 2160}, {-9000, 
      2376}, {-9000, 2592}, {-9000, 2808}, {-9000, 3024}, {-9000, 
      3240}, {-9000, 3456}, {-9000, 3672}, {-9000, 3888}, {-9000, 
      4104}, {-9000, 4320}, {-9000, 4536}, {-9000, 4752}, {-9000, 
      4968}, {-9000, 5184}, {-9000, 5400}, {-9000, 5400}}], 
     LineBox[{{-7200, -5400}, {-7200, -5184}, {-7200, -4968}, {-7200, -4752}, \
{-7200, -4536}, {-7200, -4320}, {-7200, -4104}, {-7200, -3888}, {-7200, \
-3672}, {-7200, -3456}, {-7200, -3240}, {-7200, -3024}, {-7200, -2808}, \
{-7200, -2592}, {-7200, -2376}, {-7200, -2160}, {-7200, -1944}, {-7200, \
-1728}, {-7200, -1512}, {-7200, -1296}, {-7200, -1080}, {-7200, -864}, \
{-7200, -648}, {-7200, -432}, {-7200, -216}, {-7200, 0}, {-7200, 216}, {-7200,
       432}, {-7200, 648}, {-7200, 864}, {-7200, 1080}, {-7200, 1296}, {-7200,
       1512}, {-7200, 1728}, {-7200, 1944}, {-7200, 2160}, {-7200, 
      2376}, {-7200, 2592}, {-7200, 2808}, {-7200, 3024}, {-7200, 
      3240}, {-7200, 3456}, {-7200, 3672}, {-7200, 3888}, {-7200, 
      4104}, {-7200, 4320}, {-7200, 4536}, {-7200, 4752}, {-7200, 
      4968}, {-7200, 5184}, {-7200, 5400}, {-7200, 5400}}], 
     LineBox[{{-5400, -5400}, {-5400, -5184}, {-5400, -4968}, {-5400, -4752}, \
{-5400, -4536}, {-5400, -4320}, {-5400, -4104}, {-5400, -3888}, {-5400, \
-3672}, {-5400, -3456}, {-5400, -3240}, {-5400, -3024}, {-5400, -2808}, \
{-5400, -2592}, {-5400, -2376}, {-5400, -2160}, {-5400, -1944}, {-5400, \
-1728}, {-5400, -1512}, {-5400, -1296}, {-5400, -1080}, {-5400, -864}, \
{-5400, -648}, {-5400, -432}, {-5400, -216}, {-5400, 0}, {-5400, 216}, {-5400,
       432}, {-5400, 648}, {-5400, 864}, {-5400, 1080}, {-5400, 1296}, {-5400,
       1512}, {-5400, 1728}, {-5400, 1944}, {-5400, 2160}, {-5400, 
      2376}, {-5400, 2592}, {-5400, 2808}, {-5400, 3024}, {-5400, 
      3240}, {-5400, 3456}, {-5400, 3672}, {-5400, 3888}, {-5400, 
      4104}, {-5400, 4320}, {-5400, 4536}, {-5400, 4752}, {-5400, 
      4968}, {-5400, 5184}, {-5400, 5400}, {-5400, 5400}}], 
     LineBox[{{-3600, -5400}, {-3600, -5184}, {-3600, -4968}, {-3600, -4752}, \
{-3600, -4536}, {-3600, -4320}, {-3600, -4104}, {-3600, -3888}, {-3600, \
-3672}, {-3600, -3456}, {-3600, -3240}, {-3600, -3024}, {-3600, -2808}, \
{-3600, -2592}, {-3600, -2376}, {-3600, -2160}, {-3600, -1944}, {-3600, \
-1728}, {-3600, -1512}, {-3600, -1296}, {-3600, -1080}, {-3600, -864}, \
{-3600, -648}, {-3600, -432}, {-3600, -216}, {-3600, 0}, {-3600, 216}, {-3600,
       432}, {-3600, 648}, {-3600, 864}, {-3600, 1080}, {-3600, 1296}, {-3600,
       1512}, {-3600, 1728}, {-3600, 1944}, {-3600, 2160}, {-3600, 
      2376}, {-3600, 2592}, {-3600, 2808}, {-3600, 3024}, {-3600, 
      3240}, {-3600, 3456}, {-3600, 3672}, {-3600, 3888}, {-3600, 
      4104}, {-3600, 4320}, {-3600, 4536}, {-3600, 4752}, {-3600, 
      4968}, {-3600, 5184}, {-3600, 5400}, {-3600, 5400}}], 
     LineBox[{{-1800, -5400}, {-1800, -5184}, {-1800, -4968}, {-1800, -4752}, \
{-1800, -4536}, {-1800, -4320}, {-1800, -4104}, {-1800, -3888}, {-1800, \
-3672}, {-1800, -3456}, {-1800, -3240}, {-1800, -3024}, {-1800, -2808}, \
{-1800, -2592}, {-1800, -2376}, {-1800, -2160}, {-1800, -1944}, {-1800, \
-1728}, {-1800, -1512}, {-1800, -1296}, {-1800, -1080}, {-1800, -864}, \
{-1800, -648}, {-1800, -432}, {-1800, -216}, {-1800, 0}, {-1800, 216}, {-1800,
       432}, {-1800, 648}, {-1800, 864}, {-1800, 1080}, {-1800, 1296}, {-1800,
       1512}, {-1800, 1728}, {-1800, 1944}, {-1800, 2160}, {-1800, 
      2376}, {-1800, 2592}, {-1800, 2808}, {-1800, 3024}, {-1800, 
      3240}, {-1800, 3456}, {-1800, 3672}, {-1800, 3888}, {-1800, 
      4104}, {-1800, 4320}, {-1800, 4536}, {-1800, 4752}, {-1800, 
      4968}, {-1800, 5184}, {-1800, 5400}, {-1800, 5400}}], 
     LineBox[{{0, -5400}, {0, -5184}, {0, -4968}, {0, -4752}, {0, -4536}, {
      0, -4320}, {0, -4104}, {0, -3888}, {0, -3672}, {0, -3456}, {0, -3240}, {
      0, -3024}, {0, -2808}, {0, -2592}, {0, -2376}, {0, -2160}, {0, -1944}, {
      0, -1728}, {0, -1512}, {0, -1296}, {0, -1080}, {0, -864}, {0, -648}, {
      0, -432}, {0, -216}, {0, 0}, {0, 216}, {0, 432}, {0, 648}, {0, 864}, {0,
       1080}, {0, 1296}, {0, 1512}, {0, 1728}, {0, 1944}, {0, 2160}, {0, 
      2376}, {0, 2592}, {0, 2808}, {0, 3024}, {0, 3240}, {0, 3456}, {0, 
      3672}, {0, 3888}, {0, 4104}, {0, 4320}, {0, 4536}, {0, 4752}, {0, 
      4968}, {0, 5184}, {0, 5400}, {0, 5400}}], 
     LineBox[{{1800, -5400}, {1800, -5184}, {1800, -4968}, {1800, -4752}, {
      1800, -4536}, {1800, -4320}, {1800, -4104}, {1800, -3888}, {
      1800, -3672}, {1800, -3456}, {1800, -3240}, {1800, -3024}, {
      1800, -2808}, {1800, -2592}, {1800, -2376}, {1800, -2160}, {
      1800, -1944}, {1800, -1728}, {1800, -1512}, {1800, -1296}, {
      1800, -1080}, {1800, -864}, {1800, -648}, {1800, -432}, {1800, -216}, {
      1800, 0}, {1800, 216}, {1800, 432}, {1800, 648}, {1800, 864}, {1800, 
      1080}, {1800, 1296}, {1800, 1512}, {1800, 1728}, {1800, 1944}, {1800, 
      2160}, {1800, 2376}, {1800, 2592}, {1800, 2808}, {1800, 3024}, {1800, 
      3240}, {1800, 3456}, {1800, 3672}, {1800, 3888}, {1800, 4104}, {1800, 
      4320}, {1800, 4536}, {1800, 4752}, {1800, 4968}, {1800, 5184}, {1800, 
      5400}, {1800, 5400}}], 
     LineBox[{{3600, -5400}, {3600, -5184}, {3600, -4968}, {3600, -4752}, {
      3600, -4536}, {3600, -4320}, {3600, -4104}, {3600, -3888}, {
      3600, -3672}, {3600, -3456}, {3600, -3240}, {3600, -3024}, {
      3600, -2808}, {3600, -2592}, {3600, -2376}, {3600, -2160}, {
      3600, -1944}, {3600, -1728}, {3600, -1512}, {3600, -1296}, {
      3600, -1080}, {3600, -864}, {3600, -648}, {3600, -432}, {3600, -216}, {
      3600, 0}, {3600, 216}, {3600, 432}, {3600, 648}, {3600, 864}, {3600, 
      1080}, {3600, 1296}, {3600, 1512}, {3600, 1728}, {3600, 1944}, {3600, 
      2160}, {3600, 2376}, {3600, 2592}, {3600, 2808}, {3600, 3024}, {3600, 
      3240}, {3600, 3456}, {3600, 3672}, {3600, 3888}, {3600, 4104}, {3600, 
      4320}, {3600, 4536}, {3600, 4752}, {3600, 4968}, {3600, 5184}, {3600, 
      5400}, {3600, 5400}}], 
     LineBox[{{5400, -5400}, {5400, -5184}, {5400, -4968}, {5400, -4752}, {
      5400, -4536}, {5400, -4320}, {5400, -4104}, {5400, -3888}, {
      5400, -3672}, {5400, -3456}, {5400, -3240}, {5400, -3024}, {
      5400, -2808}, {5400, -2592}, {5400, -2376}, {5400, -2160}, {
      5400, -1944}, {5400, -1728}, {5400, -1512}, {5400, -1296}, {
      5400, -1080}, {5400, -864}, {5400, -648}, {5400, -432}, {5400, -216}, {
      5400, 0}, {5400, 216}, {5400, 432}, {5400, 648}, {5400, 864}, {5400, 
      1080}, {5400, 1296}, {5400, 1512}, {5400, 1728}, {5400, 1944}, {5400, 
      2160}, {5400, 2376}, {5400, 2592}, {5400, 2808}, {5400, 3024}, {5400, 
      3240}, {5400, 3456}, {5400, 3672}, {5400, 3888}, {5400, 4104}, {5400, 
      4320}, {5400, 4536}, {5400, 4752}, {5400, 4968}, {5400, 5184}, {5400, 
      5400}, {5400, 5400}}], 
     LineBox[{{7200, -5400}, {7200, -5184}, {7200, -4968}, {7200, -4752}, {
      7200, -4536}, {7200, -4320}, {7200, -4104}, {7200, -3888}, {
      7200, -3672}, {7200, -3456}, {7200, -3240}, {7200, -3024}, {
      7200, -2808}, {7200, -2592}, {7200, -2376}, {7200, -2160}, {
      7200, -1944}, {7200, -1728}, {7200, -1512}, {7200, -1296}, {
      7200, -1080}, {7200, -864}, {7200, -648}, {7200, -432}, {7200, -216}, {
      7200, 0}, {7200, 216}, {7200, 432}, {7200, 648}, {7200, 864}, {7200, 
      1080}, {7200, 1296}, {7200, 1512}, {7200, 1728}, {7200, 1944}, {7200, 
      2160}, {7200, 2376}, {7200, 2592}, {7200, 2808}, {7200, 3024}, {7200, 
      3240}, {7200, 3456}, {7200, 3672}, {7200, 3888}, {7200, 4104}, {7200, 
      4320}, {7200, 4536}, {7200, 4752}, {7200, 4968}, {7200, 5184}, {7200, 
      5400}, {7200, 5400}}], 
     LineBox[{{9000, -5400}, {9000, -5184}, {9000, -4968}, {9000, -4752}, {
      9000, -4536}, {9000, -4320}, {9000, -4104}, {9000, -3888}, {
      9000, -3672}, {9000, -3456}, {9000, -3240}, {9000, -3024}, {
      9000, -2808}, {9000, -2592}, {9000, -2376}, {9000, -2160}, {
      9000, -1944}, {9000, -1728}, {9000, -1512}, {9000, -1296}, {
      9000, -1080}, {9000, -864}, {9000, -648}, {9000, -432}, {9000, -216}, {
      9000, 0}, {9000, 216}, {9000, 432}, {9000, 648}, {9000, 864}, {9000, 
      1080}, {9000, 1296}, {9000, 1512}, {9000, 1728}, {9000, 1944}, {9000, 
      2160}, {9000, 2376}, {9000, 2592}, {9000, 2808}, {9000, 3024}, {9000, 
      3240}, {9000, 3456}, {9000, 3672}, {9000, 3888}, {9000, 4104}, {9000, 
      4320}, {9000, 4536}, {9000, 4752}, {9000, 4968}, {9000, 5184}, {9000, 
      5400}, {9000, 5400}}], 
     LineBox[{{10800, -5400}, {10800, -5184}, {10800, -4968}, {
      10800, -4752}, {10800, -4536}, {10800, -4320}, {10800, -4104}, {
      10800, -3888}, {10800, -3672}, {10800, -3456}, {10800, -3240}, {
      10800, -3024}, {10800, -2808}, {10800, -2592}, {10800, -2376}, {
      10800, -2160}, {10800, -1944}, {10800, -1728}, {10800, -1512}, {
      10800, -1296}, {10800, -1080}, {10800, -864}, {10800, -648}, {
      10800, -432}, {10800, -216}, {10800, 0}, {10800, 216}, {10800, 432}, {
      10800, 648}, {10800, 864}, {10800, 1080}, {10800, 1296}, {10800, 
      1512}, {10800, 1728}, {10800, 1944}, {10800, 2160}, {10800, 2376}, {
      10800, 2592}, {10800, 2808}, {10800, 3024}, {10800, 3240}, {10800, 
      3456}, {10800, 3672}, {10800, 3888}, {10800, 4104}, {10800, 4320}, {
      10800, 4536}, {10800, 4752}, {10800, 4968}, {10800, 5184}, {10800, 
      5400}, {10800, 5400}}], 
     LineBox[{{-10800, -5400}, {-10584, -5400}, {-10368, -5400}, {-10152, \
-5400}, {-9936, -5400}, {-9720, -5400}, {-9504, -5400}, {-9288, -5400}, \
{-9072, -5400}, {-8856, -5400}, {-8640, -5400}, {-8424, -5400}, {-8208, \
-5400}, {-7992, -5400}, {-7776, -5400}, {-7560, -5400}, {-7344, -5400}, \
{-7128, -5400}, {-6912, -5400}, {-6696, -5400}, {-6480, -5400}, {-6264, \
-5400}, {-6048, -5400}, {-5832, -5400}, {-5616, -5400}, {-5400, -5400}, \
{-5184, -5400}, {-4968, -5400}, {-4752, -5400}, {-4536, -5400}, {-4320, \
-5400}, {-4104, -5400}, {-3888, -5400}, {-3672, -5400}, {-3456, -5400}, \
{-3240, -5400}, {-3024, -5400}, {-2808, -5400}, {-2592, -5400}, {-2376, \
-5400}, {-2160, -5400}, {-1944, -5400}, {-1728, -5400}, {-1512, -5400}, \
{-1296, -5400}, {-1080, -5400}, {-864, -5400}, {-648, -5400}, {-432, -5400}, \
{-216, -5400}, {0, -5400}, {216, -5400}, {432, -5400}, {648, -5400}, {
      864, -5400}, {1080, -5400}, {1296, -5400}, {1512, -5400}, {
      1728, -5400}, {1944, -5400}, {2160, -5400}, {2376, -5400}, {
      2592, -5400}, {2808, -5400}, {3024, -5400}, {3240, -5400}, {
      3456, -5400}, {3672, -5400}, {3888, -5400}, {4104, -5400}, {
      4320, -5400}, {4536, -5400}, {4752, -5400}, {4968, -5400}, {
      5184, -5400}, {5400, -5400}, {5616, -5400}, {5832, -5400}, {
      6048, -5400}, {6264, -5400}, {6480, -5400}, {6696, -5400}, {
      6912, -5400}, {7128, -5400}, {7344, -5400}, {7560, -5400}, {
      7776, -5400}, {7992, -5400}, {8208, -5400}, {8424, -5400}, {
      8640, -5400}, {8856, -5400}, {9072, -5400}, {9288, -5400}, {
      9504, -5400}, {9720, -5400}, {9936, -5400}, {10152, -5400}, {
      10368, -5400}, {10584, -5400}, {10800, -5400}, {10800, -5400}}], 
     LineBox[{{-10800, -3600}, {-10584, -3600}, {-10368, -3600}, {-10152, \
-3600}, {-9936, -3600}, {-9720, -3600}, {-9504, -3600}, {-9288, -3600}, \
{-9072, -3600}, {-8856, -3600}, {-8640, -3600}, {-8424, -3600}, {-8208, \
-3600}, {-7992, -3600}, {-7776, -3600}, {-7560, -3600}, {-7344, -3600}, \
{-7128, -3600}, {-6912, -3600}, {-6696, -3600}, {-6480, -3600}, {-6264, \
-3600}, {-6048, -3600}, {-5832, -3600}, {-5616, -3600}, {-5400, -3600}, \
{-5184, -3600}, {-4968, -3600}, {-4752, -3600}, {-4536, -3600}, {-4320, \
-3600}, {-4104, -3600}, {-3888, -3600}, {-3672, -3600}, {-3456, -3600}, \
{-3240, -3600}, {-3024, -3600}, {-2808, -3600}, {-2592, -3600}, {-2376, \
-3600}, {-2160, -3600}, {-1944, -3600}, {-1728, -3600}, {-1512, -3600}, \
{-1296, -3600}, {-1080, -3600}, {-864, -3600}, {-648, -3600}, {-432, -3600}, \
{-216, -3600}, {0, -3600}, {216, -3600}, {432, -3600}, {648, -3600}, {
      864, -3600}, {1080, -3600}, {1296, -3600}, {1512, -3600}, {
      1728, -3600}, {1944, -3600}, {2160, -3600}, {2376, -3600}, {
      2592, -3600}, {2808, -3600}, {3024, -3600}, {3240, -3600}, {
      3456, -3600}, {3672, -3600}, {3888, -3600}, {4104, -3600}, {
      4320, -3600}, {4536, -3600}, {4752, -3600}, {4968, -3600}, {
      5184, -3600}, {5400, -3600}, {5616, -3600}, {5832, -3600}, {
      6048, -3600}, {6264, -3600}, {6480, -3600}, {6696, -3600}, {
      6912, -3600}, {7128, -3600}, {7344, -3600}, {7560, -3600}, {
      7776, -3600}, {7992, -3600}, {8208, -3600}, {8424, -3600}, {
      8640, -3600}, {8856, -3600}, {9072, -3600}, {9288, -3600}, {
      9504, -3600}, {9720, -3600}, {9936, -3600}, {10152, -3600}, {
      10368, -3600}, {10584, -3600}, {10800, -3600}, {10800, -3600}}], 
     LineBox[{{-10800, -1800}, {-10584, -1800}, {-10368, -1800}, {-10152, \
-1800}, {-9936, -1800}, {-9720, -1800}, {-9504, -1800}, {-9288, -1800}, \
{-9072, -1800}, {-8856, -1800}, {-8640, -1800}, {-8424, -1800}, {-8208, \
-1800}, {-7992, -1800}, {-7776, -1800}, {-7560, -1800}, {-7344, -1800}, \
{-7128, -1800}, {-6912, -1800}, {-6696, -1800}, {-6480, -1800}, {-6264, \
-1800}, {-6048, -1800}, {-5832, -1800}, {-5616, -1800}, {-5400, -1800}, \
{-5184, -1800}, {-4968, -1800}, {-4752, -1800}, {-4536, -1800}, {-4320, \
-1800}, {-4104, -1800}, {-3888, -1800}, {-3672, -1800}, {-3456, -1800}, \
{-3240, -1800}, {-3024, -1800}, {-2808, -1800}, {-2592, -1800}, {-2376, \
-1800}, {-2160, -1800}, {-1944, -1800}, {-1728, -1800}, {-1512, -1800}, \
{-1296, -1800}, {-1080, -1800}, {-864, -1800}, {-648, -1800}, {-432, -1800}, \
{-216, -1800}, {0, -1800}, {216, -1800}, {432, -1800}, {648, -1800}, {
      864, -1800}, {1080, -1800}, {1296, -1800}, {1512, -1800}, {
      1728, -1800}, {1944, -1800}, {2160, -1800}, {2376, -1800}, {
      2592, -1800}, {2808, -1800}, {3024, -1800}, {3240, -1800}, {
      3456, -1800}, {3672, -1800}, {3888, -1800}, {4104, -1800}, {
      4320, -1800}, {4536, -1800}, {4752, -1800}, {4968, -1800}, {
      5184, -1800}, {5400, -1800}, {5616, -1800}, {5832, -1800}, {
      6048, -1800}, {6264, -1800}, {6480, -1800}, {6696, -1800}, {
      6912, -1800}, {7128, -1800}, {7344, -1800}, {7560, -1800}, {
      7776, -1800}, {7992, -1800}, {8208, -1800}, {8424, -1800}, {
      8640, -1800}, {8856, -1800}, {9072, -1800}, {9288, -1800}, {
      9504, -1800}, {9720, -1800}, {9936, -1800}, {10152, -1800}, {
      10368, -1800}, {10584, -1800}, {10800, -1800}, {10800, -1800}}], 
     LineBox[{{-10800, 0}, {-10584, 0}, {-10368, 0}, {-10152, 0}, {-9936, 
      0}, {-9720, 0}, {-9504, 0}, {-9288, 0}, {-9072, 0}, {-8856, 0}, {-8640, 
      0}, {-8424, 0}, {-8208, 0}, {-7992, 0}, {-7776, 0}, {-7560, 0}, {-7344, 
      0}, {-7128, 0}, {-6912, 0}, {-6696, 0}, {-6480, 0}, {-6264, 0}, {-6048, 
      0}, {-5832, 0}, {-5616, 0}, {-5400, 0}, {-5184, 0}, {-4968, 0}, {-4752, 
      0}, {-4536, 0}, {-4320, 0}, {-4104, 0}, {-3888, 0}, {-3672, 0}, {-3456, 
      0}, {-3240, 0}, {-3024, 0}, {-2808, 0}, {-2592, 0}, {-2376, 0}, {-2160, 
      0}, {-1944, 0}, {-1728, 0}, {-1512, 0}, {-1296, 0}, {-1080, 0}, {-864, 
      0}, {-648, 0}, {-432, 0}, {-216, 0}, {0, 0}, {216, 0}, {432, 0}, {648, 
      0}, {864, 0}, {1080, 0}, {1296, 0}, {1512, 0}, {1728, 0}, {1944, 0}, {
      2160, 0}, {2376, 0}, {2592, 0}, {2808, 0}, {3024, 0}, {3240, 0}, {3456, 
      0}, {3672, 0}, {3888, 0}, {4104, 0}, {4320, 0}, {4536, 0}, {4752, 0}, {
      4968, 0}, {5184, 0}, {5400, 0}, {5616, 0}, {5832, 0}, {6048, 0}, {6264, 
      0}, {6480, 0}, {6696, 0}, {6912, 0}, {7128, 0}, {7344, 0}, {7560, 0}, {
      7776, 0}, {7992, 0}, {8208, 0}, {8424, 0}, {8640, 0}, {8856, 0}, {9072, 
      0}, {9288, 0}, {9504, 0}, {9720, 0}, {9936, 0}, {10152, 0}, {10368, 
      0}, {10584, 0}, {10800, 0}, {10800, 0}}], 
     LineBox[{{-10800, 1800}, {-10584, 1800}, {-10368, 1800}, {-10152, 
      1800}, {-9936, 1800}, {-9720, 1800}, {-9504, 1800}, {-9288, 
      1800}, {-9072, 1800}, {-8856, 1800}, {-8640, 1800}, {-8424, 
      1800}, {-8208, 1800}, {-7992, 1800}, {-7776, 1800}, {-7560, 
      1800}, {-7344, 1800}, {-7128, 1800}, {-6912, 1800}, {-6696, 
      1800}, {-6480, 1800}, {-6264, 1800}, {-6048, 1800}, {-5832, 
      1800}, {-5616, 1800}, {-5400, 1800}, {-5184, 1800}, {-4968, 
      1800}, {-4752, 1800}, {-4536, 1800}, {-4320, 1800}, {-4104, 
      1800}, {-3888, 1800}, {-3672, 1800}, {-3456, 1800}, {-3240, 
      1800}, {-3024, 1800}, {-2808, 1800}, {-2592, 1800}, {-2376, 
      1800}, {-2160, 1800}, {-1944, 1800}, {-1728, 1800}, {-1512, 
      1800}, {-1296, 1800}, {-1080, 1800}, {-864, 1800}, {-648, 1800}, {-432, 
      1800}, {-216, 1800}, {0, 1800}, {216, 1800}, {432, 1800}, {648, 1800}, {
      864, 1800}, {1080, 1800}, {1296, 1800}, {1512, 1800}, {1728, 1800}, {
      1944, 1800}, {2160, 1800}, {2376, 1800}, {2592, 1800}, {2808, 1800}, {
      3024, 1800}, {3240, 1800}, {3456, 1800}, {3672, 1800}, {3888, 1800}, {
      4104, 1800}, {4320, 1800}, {4536, 1800}, {4752, 1800}, {4968, 1800}, {
      5184, 1800}, {5400, 1800}, {5616, 1800}, {5832, 1800}, {6048, 1800}, {
      6264, 1800}, {6480, 1800}, {6696, 1800}, {6912, 1800}, {7128, 1800}, {
      7344, 1800}, {7560, 1800}, {7776, 1800}, {7992, 1800}, {8208, 1800}, {
      8424, 1800}, {8640, 1800}, {8856, 1800}, {9072, 1800}, {9288, 1800}, {
      9504, 1800}, {9720, 1800}, {9936, 1800}, {10152, 1800}, {10368, 1800}, {
      10584, 1800}, {10800, 1800}, {10800, 1800}}], 
     LineBox[{{-10800, 3600}, {-10584, 3600}, {-10368, 3600}, {-10152, 
      3600}, {-9936, 3600}, {-9720, 3600}, {-9504, 3600}, {-9288, 
      3600}, {-9072, 3600}, {-8856, 3600}, {-8640, 3600}, {-8424, 
      3600}, {-8208, 3600}, {-7992, 3600}, {-7776, 3600}, {-7560, 
      3600}, {-7344, 3600}, {-7128, 3600}, {-6912, 3600}, {-6696, 
      3600}, {-6480, 3600}, {-6264, 3600}, {-6048, 3600}, {-5832, 
      3600}, {-5616, 3600}, {-5400, 3600}, {-5184, 3600}, {-4968, 
      3600}, {-4752, 3600}, {-4536, 3600}, {-4320, 3600}, {-4104, 
      3600}, {-3888, 3600}, {-3672, 3600}, {-3456, 3600}, {-3240, 
      3600}, {-3024, 3600}, {-2808, 3600}, {-2592, 3600}, {-2376, 
      3600}, {-2160, 3600}, {-1944, 3600}, {-1728, 3600}, {-1512, 
      3600}, {-1296, 3600}, {-1080, 3600}, {-864, 3600}, {-648, 3600}, {-432, 
      3600}, {-216, 3600}, {0, 3600}, {216, 3600}, {432, 3600}, {648, 3600}, {
      864, 3600}, {1080, 3600}, {1296, 3600}, {1512, 3600}, {1728, 3600}, {
      1944, 3600}, {2160, 3600}, {2376, 3600}, {2592, 3600}, {2808, 3600}, {
      3024, 3600}, {3240, 3600}, {3456, 3600}, {3672, 3600}, {3888, 3600}, {
      4104, 3600}, {4320, 3600}, {4536, 3600}, {4752, 3600}, {4968, 3600}, {
      5184, 3600}, {5400, 3600}, {5616, 3600}, {5832, 3600}, {6048, 3600}, {
      6264, 3600}, {6480, 3600}, {6696, 3600}, {6912, 3600}, {7128, 3600}, {
      7344, 3600}, {7560, 3600}, {7776, 3600}, {7992, 3600}, {8208, 3600}, {
      8424, 3600}, {8640, 3600}, {8856, 3600}, {9072, 3600}, {9288, 3600}, {
      9504, 3600}, {9720, 3600}, {9936, 3600}, {10152, 3600}, {10368, 3600}, {
      10584, 3600}, {10800, 3600}, {10800, 3600}}], 
     LineBox[{{-10800, 5400}, {-10584, 5400}, {-10368, 5400}, {-10152, 
      5400}, {-9936, 5400}, {-9720, 5400}, {-9504, 5400}, {-9288, 
      5400}, {-9072, 5400}, {-8856, 5400}, {-8640, 5400}, {-8424, 
      5400}, {-8208, 5400}, {-7992, 5400}, {-7776, 5400}, {-7560, 
      5400}, {-7344, 5400}, {-7128, 5400}, {-6912, 5400}, {-6696, 
      5400}, {-6480, 5400}, {-6264, 5400}, {-6048, 5400}, {-5832, 
      5400}, {-5616, 5400}, {-5400, 5400}, {-5184, 5400}, {-4968, 
      5400}, {-4752, 5400}, {-4536, 5400}, {-4320, 5400}, {-4104, 
      5400}, {-3888, 5400}, {-3672, 5400}, {-3456, 5400}, {-3240, 
      5400}, {-3024, 5400}, {-2808, 5400}, {-2592, 5400}, {-2376, 
      5400}, {-2160, 5400}, {-1944, 5400}, {-1728, 5400}, {-1512, 
      5400}, {-1296, 5400}, {-1080, 5400}, {-864, 5400}, {-648, 5400}, {-432, 
      5400}, {-216, 5400}, {0, 5400}, {216, 5400}, {432, 5400}, {648, 5400}, {
      864, 5400}, {1080, 5400}, {1296, 5400}, {1512, 5400}, {1728, 5400}, {
      1944, 5400}, {2160, 5400}, {2376, 5400}, {2592, 5400}, {2808, 5400}, {
      3024, 5400}, {3240, 5400}, {3456, 5400}, {3672, 5400}, {3888, 5400}, {
      4104, 5400}, {4320, 5400}, {4536, 5400}, {4752, 5400}, {4968, 5400}, {
      5184, 5400}, {5400, 5400}, {5616, 5400}, {5832, 5400}, {6048, 5400}, {
      6264, 5400}, {6480, 5400}, {6696, 5400}, {6912, 5400}, {7128, 5400}, {
      7344, 5400}, {7560, 5400}, {7776, 5400}, {7992, 5400}, {8208, 5400}, {
      8424, 5400}, {8640, 5400}, {8856, 5400}, {9072, 5400}, {9288, 5400}, {
      9504, 5400}, {9720, 5400}, {9936, 5400}, {10152, 5400}, {10368, 5400}, {
      10584, 5400}, {10800, 5400}, {10800, 5400}}]}, {
     TooltipBox[
      {RGBColor[0.938363167793372, 0.777733594731559, 0.368202323503165], 
       PolygonBox[{{3677, 2136}, {3844, 2160}, {3947, 2254}, {4066, 2233}, {
        4257, 2308}, {4301, 2201}, {4495, 2234}, {4474, 2222}, {4298, 2188}, {
        4194, 2041}, {4160, 1916}, {4003, 1873}, {3975, 1791}, {3652, 1792}, {
        3711, 1861}, {3635, 1984}, {3677, 2136}}]},
      "\"Afghanistan\""], 
     TooltipBox[
      {RGBColor[0.116444233025586, 0.575914327726347, 0.067791799996276], 
       PolygonBox[{{1201, 2381}, {1162, 2511}, {1210, 2551}, {1259, 2451}, {
        1201, 2381}}]},
      "\"Albania\""], 
     TooltipBox[
      {RGBColor[0.241140167734548, 0.585636508224024, 0.659960978562483], 
       PolygonBox[{{517, 2216}, {0, 2150}, {-133, 2105}, {-71, 1926}, {-229, 
        1902}, {-218, 1858}, {-520, 1723}, {-520, 1660}, {-520, 1637}, {-288, 
        1500}, {0, 1310}, {255, 1149}, {720, 1411}, {564, 1569}, {572, 
        1814}, {450, 2033}, {517, 2216}}]},
      "\"Algeria\""], 
     TooltipBox[
      {RGBColor[0.339457795366303, 0.504392726532148, 0.878400074969181], 
       PolygonBox[{{105, 2550}, {90, 2556}, {89, 2556}, {105, 2550}}]},
      "\"Andorra\""], 
     TooltipBox[
      {RGBColor[0.217110824209578, 0.430934806732234, 0.636504642696827], 
       PolygonBox[{{791, -352}, {735, -366}, {828, -708}, {706, -1035}, {
        831, -1040}, {1409, -1058}, {1320, -970}, {1320, -780}, {
        1441, -780}, {1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {
        1019, -435}, {991, -353}, {791, -351}}]},
      "\"Angola\""], 
     TooltipBox[
      {RGBColor[0.723343204513212, 0.314670185078876, 0.283395654511258], 
       PolygonBox[
        NCache[{{-9929, -5101}, {-8322, -5098}, {-9119, -5056}, {-9403, \
-4868}, {-8635, -4842}, {-9366, -4741}, {-9461, -4626}, {-8970, -4666}, \
{-8732, -4608}, {-8900, -4567}, {-8129, -4469}, {-6842, -4430}, {-6758, \
-4491}, {-6037, -4522}, {-6191, -4418}, {-5951, -4417}, {-6195, -4365}, \
{-5364, -4356}, {-4812, -4381}, {-4436, -4423}, {-4055, -4370}, {-4051, \
-4280}, {-4049, -4023}, {-3659, -3842}, {-3403, -3813}, {-3654, -3974}, \
{-3931, -4044}, {-3913, -4117}, {-3682, -4234}, {-3644, -4462}, {-4672, \
-4549}, {-5094, -4611}, {-4637, -4705}, {-4901, -4749}, {-4569, -4763}, \
{-4806, -4798}, {-4421, -4855}, {-3495, -4982}, {-1826, -4827}, {-2113, \
-4671}, {-823, -4437}, {-1014, -4427}, {-711, -4277}, {-355, -4242}, {-361, \
-4285}, {0, -4290}, {521, -4204}, {1404, -4232}, {2038, -4110}, {
          2309, -4200}, {2466, -4111}, {3050, -4029}, {3118, -3959}, {
          3407, -4023}, {4021, -4067}, {4179, -4066}, {4080, -4213}, {
          4284, -4277}, {4672, -4144}, {4737, -4088}, {5294, -3962}, {
          5376, -4010}, {6002, -3939}, {6532, -4015}, {6804, -3943}, {
          7066, -4019}, {7762, -4022}, {8124, -3961}, {8722, -4021}, {
          8882, -4104}, {9541, -4158}, {10248, -4300}, {9735, -4490}, {
          10037, -4717}, {9600, -4736}, {9552, -4794}, {
          10800, Rational[-810894, 163]}, {10800, Rational[-846102, 163]}, {
          10800, -5400}, {10800, -5400}, {10800, -5400}, {10584, -5400}, {
          10368, -5400}, {10152, -5400}, {9936, -5400}, {9720, -5400}, {
          9504, -5400}, {9288, -5400}, {9072, -5400}, {8856, -5400}, {
          8640, -5400}, {8424, -5400}, {8208, -5400}, {7992, -5400}, {
          7776, -5400}, {7560, -5400}, {7344, -5400}, {7128, -5400}, {
          6912, -5400}, {6696, -5400}, {6480, -5400}, {6264, -5400}, {
          6048, -5400}, {5832, -5400}, {5616, -5400}, {5400, -5400}, {
          5184, -5400}, {4968, -5400}, {4752, -5400}, {4536, -5400}, {
          4320, -5400}, {4104, -5400}, {3888, -5400}, {3672, -5400}, {
          3456, -5400}, {3240, -5400}, {3024, -5400}, {2808, -5400}, {
          2592, -5400}, {2376, -5400}, {2160, -5400}, {1944, -5400}, {
          1728, -5400}, {1512, -5400}, {1296, -5400}, {1080, -5400}, {
          864, -5400}, {648, -5400}, {432, -5400}, {216, -5400}, {
          0, -5400}, {-216, -5400}, {-432, -5400}, {-648, -5400}, {-864, \
-5400}, {-1080, -5400}, {-1296, -5400}, {-1512, -5400}, {-1728, -5400}, \
{-1944, -5400}, {-2160, -5400}, {-2376, -5400}, {-2592, -5400}, {-2808, \
-5400}, {-3024, -5400}, {-3240, -5400}, {-3456, -5400}, {-3672, -5400}, \
{-3888, -5400}, {-4104, -5400}, {-4320, -5400}, {-4536, -5400}, {-4752, \
-5400}, {-4968, -5400}, {-5184, -5400}, {-5400, -5400}, {-5616, -5400}, \
{-5832, -5400}, {-6048, -5400}, {-6264, -5400}, {-6480, -5400}, {-6696, \
-5400}, {-6912, -5400}, {-7128, -5400}, {-7344, -5400}, {-7560, -5400}, \
{-7776, -5400}, {-7992, -5400}, {-8208, -5400}, {-8424, -5400}, {-8640, \
-5400}, {-8856, -5400}, {-9072, -5400}, {-9288, -5400}, {-9504, -5400}, \
{-9720, -5400}, {-9936, -5400}, {-10152, -5400}, {-10368, -5400}, {-10584, \
-5400}, {-10800, -5400}, {-10800, -5400}, {-10800, 
           Rational[-846102, 163]}, {-10800, 
           Rational[-810894, 
            163]}, {-9930, -5101}, {-9929, -5101}}, {{-9929, -5101}, {-8322, \
-5098}, {-9119, -5056}, {-9403, -4868}, {-8635, -4842}, {-9366, -4741}, \
{-9461, -4626}, {-8970, -4666}, {-8732, -4608}, {-8900, -4567}, {-8129, \
-4469}, {-6842, -4430}, {-6758, -4491}, {-6037, -4522}, {-6191, -4418}, \
{-5951, -4417}, {-6195, -4365}, {-5364, -4356}, {-4812, -4381}, {-4436, \
-4423}, {-4055, -4370}, {-4051, -4280}, {-4049, -4023}, {-3659, -3842}, \
{-3403, -3813}, {-3654, -3974}, {-3931, -4044}, {-3913, -4117}, {-3682, \
-4234}, {-3644, -4462}, {-4672, -4549}, {-5094, -4611}, {-4637, -4705}, \
{-4901, -4749}, {-4569, -4763}, {-4806, -4798}, {-4421, -4855}, {-3495, \
-4982}, {-1826, -4827}, {-2113, -4671}, {-823, -4437}, {-1014, -4427}, {-711, \
-4277}, {-355, -4242}, {-361, -4285}, {0, -4290}, {521, -4204}, {
          1404, -4232}, {2038, -4110}, {2309, -4200}, {2466, -4111}, {
          3050, -4029}, {3118, -3959}, {3407, -4023}, {4021, -4067}, {
          4179, -4066}, {4080, -4213}, {4284, -4277}, {4672, -4144}, {
          4737, -4088}, {5294, -3962}, {5376, -4010}, {6002, -3939}, {
          6532, -4015}, {6804, -3943}, {7066, -4019}, {7762, -4022}, {
          8124, -3961}, {8722, -4021}, {8882, -4104}, {9541, -4158}, {
          10248, -4300}, {9735, -4490}, {10037, -4717}, {9600, -4736}, {
          9552, -4794}, {10800, -4974.80981595092}, {
          10800, -5190.80981595092}, {10800, -5400}, {10800, -5400}, {
          10800, -5400}, {10584, -5400}, {10368, -5400}, {10152, -5400}, {
          9936, -5400}, {9720, -5400}, {9504, -5400}, {9288, -5400}, {
          9072, -5400}, {8856, -5400}, {8640, -5400}, {8424, -5400}, {
          8208, -5400}, {7992, -5400}, {7776, -5400}, {7560, -5400}, {
          7344, -5400}, {7128, -5400}, {6912, -5400}, {6696, -5400}, {
          6480, -5400}, {6264, -5400}, {6048, -5400}, {5832, -5400}, {
          5616, -5400}, {5400, -5400}, {5184, -5400}, {4968, -5400}, {
          4752, -5400}, {4536, -5400}, {4320, -5400}, {4104, -5400}, {
          3888, -5400}, {3672, -5400}, {3456, -5400}, {3240, -5400}, {
          3024, -5400}, {2808, -5400}, {2592, -5400}, {2376, -5400}, {
          2160, -5400}, {1944, -5400}, {1728, -5400}, {1512, -5400}, {
          1296, -5400}, {1080, -5400}, {864, -5400}, {648, -5400}, {
          432, -5400}, {216, -5400}, {
          0, -5400}, {-216, -5400}, {-432, -5400}, {-648, -5400}, {-864, \
-5400}, {-1080, -5400}, {-1296, -5400}, {-1512, -5400}, {-1728, -5400}, \
{-1944, -5400}, {-2160, -5400}, {-2376, -5400}, {-2592, -5400}, {-2808, \
-5400}, {-3024, -5400}, {-3240, -5400}, {-3456, -5400}, {-3672, -5400}, \
{-3888, -5400}, {-4104, -5400}, {-4320, -5400}, {-4536, -5400}, {-4752, \
-5400}, {-4968, -5400}, {-5184, -5400}, {-5400, -5400}, {-5616, -5400}, \
{-5832, -5400}, {-6048, -5400}, {-6264, -5400}, {-6480, -5400}, {-6696, \
-5400}, {-6912, -5400}, {-7128, -5400}, {-7344, -5400}, {-7560, -5400}, \
{-7776, -5400}, {-7992, -5400}, {-8208, -5400}, {-8424, -5400}, {-8640, \
-5400}, {-8856, -5400}, {-9072, -5400}, {-9288, -5400}, {-9504, -5400}, \
{-9720, -5400}, {-9936, -5400}, {-10152, -5400}, {-10368, -5400}, {-10584, \
-5400}, {-10800, -5400}, {-10800, -5400}, {-10800, -5190.80981595092}, \
{-10800, -4974.80981595092}, {-9930, -5101}, {-9929, -5101}}]], 
       PolygonBox[{{-5761, -4352}, {-6138, -4329}, {-5930, -4296}, {-5761, \
-4352}}], 
       PolygonBox[{{-4325, -4358}, {-4305, -4296}, {-4540, -4287}, {-4236, \
-4257}, {-4324, -4144}, {-4085, -4298}, {-4325, -4358}}], 
       PolygonBox[{{-4372, -4644}, {-4482, -4684}, {-4851, -4637}, {-4372, \
-4644}}], 
       PolygonBox[{{-3578, -4795}, {-3612, -4862}, {-3967, -4820}, {-3578, \
-4795}}]},
      "\"Antarctica\""], 
     TooltipBox[
      {RGBColor[0.408889767327844, 0.809229568136251, 0.0816762538456288], 
       PolygonBox[{{-3492, -1947}, {-3511, -2067}, {-3400, -2214}, {-3499, \
-2309}, {-3743, -2328}, {-3738, -2449}, {-3908, -2451}, {-3815, -2557}, \
{-3898, -2560}, {-3936, -2701}, {-4055, -2760}, {-3944, -2843}, {-4141, \
-3001}, {-4106, -3143}, {-4316, -3119}, {-4415, -2972}, {-4266, -2672}, \
{-4328, -2537}, {-4189, -2054}, {-4234, -1879}, {-4099, -1623}, {-4031, \
-1369}, {-3974, -1307}, {-3859, -1372}, {-3836, -1320}, {-3758, -1334}, \
{-3465, -1511}, {-3516, -1639}, {-3335, -1637}, {-3276, -1534}, {-3228, \
-1628}, {-3458, -1815}, {-3492, -1947}}], 
       PolygonBox[{{-4117, -3159}, {-3908, -3279}, {-4118, -3287}, {-4118, \
-3293}, {-4117, -3159}}]},
      "\"Argentina\""], 
     TooltipBox[
      {RGBColor[0.324169743138784, 0.232887444039028, 0.747807302891151], 
       PolygonBox[{{2590, 2435}, {2701, 2472}, {2781, 2419}, {2849, 2361}, {
        2806, 2344}, {2770, 2374}, {2689, 2378}, {2590, 2435}}]},
      "\"Armenia\""], 
     TooltipBox[
      {RGBColor[0.143313086052257, 0.546436148407226, 0.864685120535863], 
       PolygonBox[{{8678, -2300}, {8613, -2332}, {8422, -2277}, {
        8369, -2155}, {8285, -2049}, {8210, -2118}, {8266, -1951}, {
        8157, -2099}, {8027, -1933}, {7872, -1889}, {7559, -1939}, {
        7201, -2036}, {7077, -2109}, {6907, -2063}, {6944, -1914}, {
        6789, -1569}, {6854, -1568}, {6804, -1450}, {6842, -1309}, {
        7009, -1230}, {7262, -1172}, {7376, -982}, {7426, -1073}, {
        7417, -968}, {7515, -935}, {7561, -834}, {7645, -837}, {7670, -936}, {
        7709, -886}, {7812, -923}, {7782, -833}, {7860, -730}, {7961, -731}, {
        7919, -672}, {8143, -738}, {8219, -744}, {8127, -899}, {
        8406, -1063}, {8503, -914}, {8528, -662}, {8586, -732}, {
        8627, -863}, {8722, -898}, {8777, -1133}, {8927, -1215}, {
        8978, -1353}, {9048, -1352}, {9175, -1518}, {9217, -1727}, {
        9013, -2144}, {8977, -2263}, {8782, -2349}, {8678, -2300}}], 
       PolygonBox[{{9182, -1546}, {9196, -1482}, {9182, -1546}}], 
       PolygonBox[{{8746, -2590}, {8682, -2441}, {8901, -2458}, {
        8879, -2591}, {8746, -2589}}], 
       PolygonBox[{{7856, -716}, {7823, -672}, {7886, -678}, {7856, -716}}]},
      "\"Australia\""], 
     TooltipBox[
      {RGBColor[0.631363069865566, 0.56739875832591, 0.47864434841095], 
       PolygonBox[{{584, 2852}, {783, 2850}, {830, 2926}, {1030, 2881}, {967, 
        2812}, {823, 2792}, {628, 2812}, {576, 2824}, {572, 2836}, {584, 
        2852}}]},
      "\"Austria\""], 
     TooltipBox[
      {RGBColor[0.623544952801315, 0.0457265616415414, 0.907437779763427], 
       PolygonBox[{{2689, 2378}, {2770, 2374}, {2806, 2344}, {2770, 2330}, {
        2689, 2378}}], 
       PolygonBox[{{2849, 2361}, {2781, 2419}, {2701, 2472}, {2823, 2445}, {
        2778, 2509}, {2871, 2473}, {2915, 2510}, {3024, 2414}, {2933, 2307}, {
        2888, 2376}, {2849, 2361}}]},
      "\"Azerbaijan\""], 
     TooltipBox[
      {RGBColor[0.139186553044646, 0.119152226269167, 0.16732648667236], 
       PolygonBox[{{3030, 1574}}]},
      "\"Bahrain\""], 
     TooltipBox[
      {RGBColor[0.690326955553849, 0.708251746312413, 0.48264758357234], 
       PolygonBox[{{5532, 1269}, {5489, 1375}, {5355, 1437}, {5437, 1342}, {
        5342, 1315}, {5341, 1517}, {5305, 1598}, {5391, 1517}, {5544, 1502}, {
        5470, 1418}, {5497, 1377}, {5537, 1418}, {5556, 1319}, {5532, 
        1269}}]},
      "\"Bangladesh\""], 
     TooltipBox[
      {RGBColor[0.443983282159148, 0.375656770474973, 0.424856091801154], 
       PolygonBox[{{1410, 3237}, {1519, 3249}, {1580, 3332}, {1686, 3361}, {
        1799, 3350}, {1903, 3222}, {1898, 3124}, {1640, 3095}, {1416, 3092}, {
        1410, 3237}}]},
      "\"Belarus\""], 
     TooltipBox[
      {RGBColor[0.0737578162444958, 0.634753714022897, 0.293980516629344], 
       PolygonBox[{{153, 3065}, {203, 3083}, {361, 3046}, {368, 3008}, {349, 
        2972}, {153, 3065}}]},
      "\"Belgium\""], 
     TooltipBox[
      {RGBColor[0.10068634866237, 0.840870372205468, 0.886946411131746], 
       PolygonBox[{{-5297, 1109}, {-5335, 954}, {-5348, 1069}, {-5297, 
        1109}}]},
      "\"Belize\""], 
     TooltipBox[
      {RGBColor[0.150667430577087, 0.554250200255144, 0.976185251669604], 
       PolygonBox[{{98, 373}, {164, 382}, {214, 705}, {144, 713}, {58, 660}, {
        98, 373}}]},
      "\"Benin\""], 
     TooltipBox[
      {RGBColor[0.25558334126618, 0.583268672251177, 0.0756058518441945], 
       PolygonBox[{{-3885, 1939}}]},
      "\"Bermuda\""], 
     TooltipBox[
      {RGBColor[0.35264029886829, 0.209856779624639, 0.675830892487751], 
       PolygonBox[{{5335, 1639}, {5400, 1699}, {5499, 1666}, {5335, 1639}}]},
      "\"Bhutan\""], 
     TooltipBox[
      {RGBColor[0.936419298799548, 0.233488072599123, 0.0425302929522787], 
       PolygonBox[{{-4174, -657}, {-4120, -750}, {-4170, -1050}, {-4031, \
-1369}, {-3974, -1307}, {-3859, -1372}, {-3836, -1320}, {-3758, -1334}, \
{-3705, -1179}, {-3490, -1210}, {-3447, -1092}, {-3500, -977}, {-3610, -976}, \
{-3628, -828}, {-3864, -748}, {-3919, -655}, {-3926, -581}, {-4174, -657}}]},
      "\"Bolivia\""], 
     TooltipBox[
      {RGBColor[0.985503936933902, 0.228167552487136, 0.750840489026783], 
       PolygonBox[{{1118, 2550}, {982, 2651}, {966, 2674}, {957, 2710}, {1108,
         2703}, {1128, 2693}, {1118, 2550}}]},
      "\"Bosnia and Herzegovina\""], 
     TooltipBox[
      {RGBColor[0.598547010793131, 0.609847166458929, 0.803311460685982], 
       PolygonBox[{{1516, -1068}, {1260, -1099}, {1200, -1320}, {
        1200, -1486}, {1239, -1610}, {1368, -1539}, {1531, -1540}, {
        1763, -1332}, {1516, -1068}}]},
      "\"Botswana\""], 
     TooltipBox[
      {RGBColor[0.677082672782287, 0.963793296770233, 0.315866649829584], 
       PolygonBox[{{-3202, -2024}, {-3077, -1801}, {-3034, -1827}, {-3124, \
-1930}, {-2925, -1712}, {-2925, -1521}, {-2458, -1319}, {-2348, -1061}, \
{-2339, -823}, {-2335, -764}, {-2289, -764}, {-2096, -501}, {-2125, -313}, \
{-2400, -171}, {-2687, -198}, {-2676, -105}, {-2809, -43}, {-2936, -107}, \
{-2981, -161}, {-2965, -107}, {-3043, -107}, {-3051, -55}, {-3163, -96}, \
{-2993, 70}, {-3101, 242}, {-3164, 140}, {-3277, 140}, {-3388, 117}, {-3555, 
        83}, {-3580, 263}, {-3644, 312}, {-3691, 256}, {-3773, 214}, {-3888, 
        257}, {-3804, 129}, {-4012, 73}, {-4191, 103}, {-4147, 39}, {-4203, 
        35}, {-4197, -253}, {-4374, -308}, {-4441, -452}, {-4392, -564}, \
{-4231, -566}, {-4238, -661}, {-4174, -657}, {-3926, -581}, {-3919, -655}, \
{-3864, -748}, {-3628, -828}, {-3610, -976}, {-3500, -977}, {-3447, -1092}, \
{-3490, -1210}, {-3479, -1325}, {-3351, -1337}, {-3324, -1438}, {-3255, \
-1443}, {-3276, -1534}, {-3228, -1628}, {-3458, -1815}, {-3225, -1923}, \
{-3202, -2024}}], 
       PolygonBox[{{-2904, -16}, {-3023, -110}, {-3035, -12}, {-2904, -16}}]},
      
      "\"Brazil\""], 
     TooltipBox[
      {RGBColor[0.702625112023612, 0.836212300576819, 0.0768468856384871], 
       PolygonBox[{{6845, 275}, {6901, 292}, {6901, 293}, {6845, 275}}], 
       PolygonBox[{{6909, 294}, {6902, 289}, {6909, 294}}]},
      "\"Brunei\""], 
     TooltipBox[
      {RGBColor[0.165199219252497, 0.148374911768468, 0.860027048907215], 
       PolygonBox[{{1715, 2625}, {1681, 2519}, {1581, 2503}, {1376, 2481}, {
        1361, 2654}, {1715, 2625}}]},
      "\"Bulgaria\""], 
     TooltipBox[
      {RGBColor[0.821263544372307, 0.58193054700132, 0.0727690599242733], 
       PolygonBox[{{-161, 569}, {-331, 626}, {-238, 810}, {0, 900}, {14, 
        900}, {144, 714}, {58, 660}, {-10, 668}, {-170, 660}, {-161, 569}}]},
      "\"Burkina Faso\""], 
     TooltipBox[
      {RGBColor[0.507386750038925, 0.611406764747668, 0.906099654513569], 
       PolygonBox[{{5925, 621}, {5864, 994}, {5813, 1047}, {5740, 957}, {5655,
         958}, {5645, 1163}, {5532, 1268}, {5556, 1319}, {5708, 1597}, {5828, 
        1625}, {5841, 1693}, {5889, 1688}, {5923, 1552}, {5852, 1436}, {5934, 
        1446}, {6069, 1294}, {6005, 1221}, {6069, 1294}, {6005, 1221}, {5841, 
        1113}, {5936, 983}, {5891, 906}, {5980, 710}, {5925, 621}}]},
      "\"Burma\""], 
     TooltipBox[
      {RGBColor[0.136349761124725, 0.273898677439802, 0.568876471795389], 
       PolygonBox[{{1741, -165}, {1765, -267}, {1834, -144}, {1741, -165}}]},
      "\"Burundi\""], 
     TooltipBox[
      {RGBColor[0.920595717579667, 0.908182208637589, 0.52305818841302], 
       PolygonBox[{{930, 452}, {1115, 482}, {1366, 657}, {1373, 655}, {1411, 
        523}, {1647, 301}, {1340, 248}, {1152, 298}, {1118, 209}, {995, 
        209}, {972, 133}, {865, 363}, {930, 452}}]},
      "\"CAR\""], 
     TooltipBox[
      {RGBColor[0.970329461002259, 0.310748551120738, 0.104870747951607], 
       PolygonBox[{{722, -301}, {732, -347}, {785, -278}, {722, -301}}]},
      "\"Cabinda\""], 
     TooltipBox[
      {RGBColor[0.845975515630733, 0.00653616423202557, 0.994881901291154], 
       PolygonBox[{{6267, 625}, {6175, 698}, {6140, 813}, {6313, 861}, {6453, 
        882}, {6453, 741}, {6351, 700}, {6267, 625}}]},
      "\"Cambodia\""], 
     TooltipBox[
      {RGBColor[0.402245635927996, 0.00976321505391393, 0.929689278593538], 
       PolygonBox[{{589, 141}, {585, 248}, {516, 289}, {588, 408}, {713, 
        425}, {879, 694}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {
        865, 363}, {972, 133}, {798, 130}, {680, 130}, {589, 141}}]},
      "\"Cameroon\""], 
     TooltipBox[
      {RGBColor[0.829682682038657, 0.253870724159528, 0.149736166146699], 
       PolygonBox[{{-7364, 2940}, {-7022, 2940}, {-6962, 2940}, {-6240, 
        2940}, {-5832, 2940}, {-5375, 2880}, {-5048, 2792}, {-4945, 
        2581}, {-4959, 2553}, {-4962, 2501}, {-4735, 2575}, {-4744, 
        2586}, {-4744, 2596}, {-4548, 2669}, {-4401, 2701}, {-4290, 
        2701}, {-4265, 2718}, {-4154, 2848}, {-4032, 2711}, {-3943, 
        2716}, {-3885, 2765}, {-3896, 2721}, {-3802, 2722}, {-3971, 
        2665}, {-3928, 2608}, {-3658, 2716}, {-3715, 2753}, {-3825, 
        2750}, {-3881, 2864}, {-4011, 2880}, {-3853, 2910}, {-3927, 
        2956}, {-4278, 2805}, {-4184, 2887}, {-4264, 2906}, {-4181, 
        2888}, {-3868, 3019}, {-3608, 3012}, {-3337, 3133}, {-3346, 
        3191}, {-3482, 3254}, {-3625, 3196}, {-3502, 3254}, {-3441, 
        3275}, {-3641, 3300}, {-3732, 3403}, {-3890, 3622}, {-3964, 
        3499}, {-4080, 3515}, {-4162, 3466}, {-4092, 3513}, {-4262, 
        3604}, {-4162, 3654}, {-4325, 3704}, {-4686, 3740}, {-4714, 
        3517}, {-4595, 3434}, {-4628, 3339}, {-4786, 3279}, {-4760, 
        3043}, {-4913, 3131}, {-4938, 3309}, {-5125, 3299}, {-5330, 
        3410}, {-5573, 3414}, {-5658, 3509}, {-5688, 3630}, {-5438, 
        3784}, {-5627, 3851}, {-5279, 3851}, {-5222, 3914}, {-5490, 
        3957}, {-5244, 3919}, {-5022, 3971}, {-5113, 4015}, {-4890, 
        4020}, {-4880, 4151}, {-5134, 4192}, {-5223, 4035}, {-5337, 
        4154}, {-5415, 4094}, {-5575, 4180}, {-5674, 4320}, {-5792, 
        4208}, {-5602, 4118}, {-5728, 4058}, {-5749, 3995}, {-5771, 
        4064}, {-5871, 4113}, {-5832, 4057}, {-6134, 4061}, {-6373, 
        4136}, {-6507, 4091}, {-6339, 4118}, {-6435, 3981}, {-6605, 
        4080}, {-6906, 4068}, {-6899, 4132}, {-7460, 4161}, {-7473, 
        4209}, {-7526, 4159}, {-7680, 4235}, {-7848, 4161}, {-8008, 
        4133}, {-7780, 4216}, {-7983, 4168}, {-8110, 4119}, {-8461, 
        4179}, {-8460, 3618}, {-8128, 3588}, {-7801, 3355}, {-7803, 
        3233}, {-7738, 3213}, {-7700, 3142}, {-7604, 3142}, {-7673, 
        3100}, {-7667, 3070}, {-7489, 3055}, {-7365, 2939}}], 
       PolygonBox[{{-7900, 3247}, {-7962, 3195}, {-7984, 3250}, {-7900, 
        3247}}], PolygonBox[{{-7648, 3042}, {-7413, 2898}, {-7649, 3042}}], 
       PolygonBox[{{-7184, 4442}, {-6919, 4409}, {-7368, 4265}, {-7560, 
        4318}, {-7487, 4460}, {-7185, 4442}}], 
       PolygonBox[{{-6876, 4356}, {-6516, 4351}, {-6471, 4296}, {-6485, 
        4401}, {-6312, 4343}, {-6058, 4209}, {-6174, 4128}, {-6395, 
        4170}, {-6799, 4108}, {-7046, 4200}, {-6689, 4220}, {-7054, 
        4236}, {-6904, 4292}, {-7146, 4301}, {-7041, 4375}, {-6876, 4356}}], 
       PolygonBox[{{-4981, 3895}, {-4858, 3807}, {-5114, 3787}, {-5231, 
        3815}, {-5137, 3955}, {-4981, 3895}}], 
       PolygonBox[{{-6269, 4412}, {-6317, 4371}, {-6422, 4409}, {-6269, 
        4412}}], 
       PolygonBox[{{-5872, 4193}, {-5732, 4120}, {-5966, 4133}, {-5872, 
        4193}}], 
       PolygonBox[{{-3337, 3097}, {-3411, 2973}, {-3323, 2942}, {-3209, 
        2957}, {-3220, 2851}, {-3170, 2886}, {-3185, 2799}, {-3255, 
        2874}, {-3323, 2812}, {-3346, 2877}, {-3558, 2857}, {-3564, 
        2875}, {-3470, 2990}, {-3337, 3096}}], 
       PolygonBox[{{-3619, 2811}, {-3669, 2742}, {-3588, 2756}, {-3691, 
        2756}, {-3619, 2811}}], 
       PolygonBox[{{-4034, 4097}, {-3676, 3998}, {-3813, 3893}, {-3861, 
        3981}, {-4112, 3978}, {-4043, 3932}, {-3878, 3774}, {-4140, 
        3825}, {-3964, 3712}, {-4284, 3783}, {-4512, 3867}, {-4680, 
        3865}, {-4646, 3928}, {-4523, 3883}, {-4409, 3927}, {-4275, 
        3957}, {-4153, 3994}, {-4379, 4005}, {-4599, 4122}, {-4741, 
        4241}, {-4857, 4183}, {-5275, 4214}, {-5374, 4265}, {-5401, 
        4313}, {-5169, 4432}, {-5208, 4259}, {-5141, 4374}, {-4918, 
        4424}, {-4858, 4313}, {-4624, 4365}, {-4505, 4271}, {-4403, 
        4259}, {-4315, 4294}, {-4357, 4238}, {-4292, 4201}, {-4192, 
        4253}, {-4140, 4200}, {-4202, 4172}, {-4006, 4160}, {-4164, 
        4132}, {-4034, 4097}}], 
       PolygonBox[{{-5705, 4441}, {-5412, 4434}, {-5644, 4319}, {-5705, 
        4441}}], 
       PolygonBox[{{-7119, 4642}, {-6954, 4601}, {-7220, 4548}, {-7382, 
        4565}, {-7119, 4642}}], 
       PolygonBox[{{-6222, 4761}, {-5951, 4670}, {-6289, 4701}, {-6222, 
        4761}}], 
       PolygonBox[{{-6023, 4598}, {-5857, 4507}, {-6167, 4533}, {-6112, 
        4587}, {-6023, 4598}}]},
      "\"Canada\""], 
     TooltipBox[
      {RGBColor[0.108425734221232, 0.247752135037337, 0.181101664235254], 
       PolygonBox[{{1440, 1170}, {960, 1410}, {900, 1380}, {960, 1221}, {929, 
        1014}, {818, 823}, {844, 785}, {941, 599}, {837, 578}, {930, 452}, {
        1115, 482}, {1366, 657}, {1310, 768}, {1376, 933}, {1440, 942}, {1440,
         1170}}]},
      "\"Chad\""], 
     TooltipBox[
      {RGBColor[0.642349416107774, 0.497018969473564, 0.341652480523768], 
       PolygonBox[{{-4224, -1101}, {-4287, -1959}, {-4421, -2240}, {-4338, \
-2483}, {-4356, -2670}, {-4424, -2792}, {-4450, -2748}, {-4542, -2798}, \
{-4471, -2808}, {-4393, -2880}, {-4479, -2881}, {-4482, -3012}, {-4413, \
-3123}, {-4348, -3107}, {-4407, -3180}, {-4288, -3158}, {-4393, -3194}, \
{-4267, -3171}, {-4328, -3203}, {-4106, -3143}, {-4316, -3119}, {-4415, \
-2972}, {-4266, -2672}, {-4328, -2537}, {-4189, -2054}, {-4234, -1879}, \
{-4099, -1623}, {-4031, -1369}, {-4170, -1050}, {-4224, -1101}}], 
       PolygonBox[{{-4023, -3306}, {-4102, -3297}, {-4023, -3306}}], 
       PolygonBox[{{-4104, -3298}, {-4085, -3343}, {-4202, -3310}, {-4103, \
-3298}}], 
       PolygonBox[{{-4118, -3293}, {-4321, -3271}, {-4140, -3268}, {-4225, \
-3166}, {-4117, -3159}, {-4118, -3293}}], 
       PolygonBox[{{-4434, -2603}, {-4410, -2511}, {-4434, -2603}}]},
      "\"Chile\""], 
     TooltipBox[
      {RGBColor[0.0447519031105295, 0.368450738667972, 0.928142497678174], 
       PolygonBox[{{7462, 2406}, {7271, 2323}, {7313, 2400}, {7312, 2459}, {
        7192, 2399}, {7067, 2297}, {7136, 2241}, {7362, 2244}, {7157, 2104}, {
        7314, 1904}, {7177, 1941}, {7313, 1858}, {7209, 1812}, {7328, 1793}, {
        7226, 1633}, {7146, 1569}, {7031, 1417}, {6857, 1336}, {6804, 1386}, {
        6813, 1331}, {6698, 1291}, {6621, 1286}, {6595, 1214}, {6591, 1243}, {
        6597, 1289}, {6479, 1293}, {6487, 1287}, {6331, 1391}, {6128, 1344}, {
        6069, 1294}, {5934, 1446}, {5852, 1436}, {5923, 1552}, {5889, 1688}, {
        5841, 1693}, {5765, 1768}, {5499, 1666}, {5400, 1699}, {5335, 1639}, {
        5289, 1672}, {4861, 1812}, {4704, 1952}, {4770, 1959}, {4734, 2038}, {
        4812, 2106}, {4669, 2130}, {4474, 2222}, {4494, 2234}, {4440, 2403}, {
        4816, 2523}, {4792, 2694}, {4954, 2708}, {4982, 2833}, {5141, 2832}, {
        5240, 2946}, {5270, 2950}, {5454, 2817}, {5442, 2719}, {5724, 2656}, {
        5783, 2564}, {5783, 2565}, {6314, 2504}, {6608, 2559}, {6718, 2622}, {
        6720, 2706}, {7194, 2800}, {7106, 2880}, {6935, 2873}, {7003, 2990}, {
        7154, 3001}, {7202, 3166}, {7322, 3205}, {7537, 3183}, {7652, 2988}, {
        7840, 2932}, {7859, 2862}, {8084, 2896}, {7987, 2707}, {7857, 2690}, {
        7836, 2545}, {7462, 2406}}], 
       PolygonBox[{{6574, 1199}, {6657, 1198}, {6632, 1127}, {6521, 1110}, {
        6575, 1199}}]},
      "\"China\""], 
     TooltipBox[
      {RGBColor[0.4210567629441, 0.13656969447294, 0.845392550254952], 
       PolygonBox[{{-4279, 711}, {-4492, 668}, {-4605, 475}, {-4642, 
        520}, {-4673, 434}, {-4622, 235}, {-4729, 
        86}, {-4517, -6}, {-4376, -146}, {-4206, -158}, {-4243, -227}, \
{-4197, -253}, {-4203, 35}, {-4147, 39}, {-4191, 103}, {-4012, 73}, {-4071, 
        167}, {-4047, 372}, {-4320, 421}, {-4403, 551}, {-4279, 711}}]},
      "\"Colombia\""], 
     TooltipBox[
      {RGBColor[0.957813036675916, 0.110308211823362, 0.0316989465213331], 
       PolygonBox[{{670, -237}, {722, -301}, {785, -278}, {954, -235}, {1118, 
        209}, {995, 209}, {972, 133}, {798, 130}, {790, 74}, {870, 56}, {
        867, -114}, {695, -140}, {670, -237}}]},
      "\"Congo\""], 
     TooltipBox[
      {RGBColor[0.999417034624219, 0.95127687244389, 0.115426310532208], 
       PolygonBox[{{-5019, 655}, {-4954, 574}, {-4974, 482}, {-5140, 
        594}, {-5141, 664}, {-5019, 655}}]},
      "\"Costa Rica\""], 
     TooltipBox[
      {RGBColor[0.629453310593338, 0.989653819570305, 0.0215875938503515], 
       PolygonBox[{{-452, 261}, {-186, 305}, {-186, 305}, {-161, 569}, {-161, 
        569}, {-331, 627}, {-331, 626}, {-478, 610}, {-478, 610}, {-508, 
        454}, {-508, 454}, {-451, 261}}]},
      "\"Cote d'Ivoire\""], 
     TooltipBox[
      {RGBColor[0.285743628493552, 0.37558258643381, 0.839917653423606], 
       PolygonBox[{{1119, 2542}, {874, 2718}, {839, 2730}, {943, 2748}, {992, 
        2796}, {1072, 2746}, {1131, 2755}, {1128, 2693}, {1108, 2703}, {957, 
        2710}, {966, 2674}, {982, 2651}, {1118, 2550}, {1119, 2542}}]},
      "\"Croatia\""], 
     TooltipBox[
      {RGBColor[0.91316185962912, 0.0379914934562148, 0.194480922198555], 
       PolygonBox[{{-5095, 1315}, {-4868, 1393}, {-4638, 1305}, {-4448, 
        1211}, {-4648, 1209}, {-4913, 1361}, {-5095, 1315}}]},
      "\"Cuba\""], 
     TooltipBox[
      {RGBColor[0.197568237315831, 0.416142890155556, 0.696339012932447], 
       PolygonBox[{{2075, 2140}, {1982, 2074}, {1936, 2104}, {2075, 2140}}]},
      "\"Cyprus\""], 
     TooltipBox[
      {RGBColor[0.149729019088026, 0.82911749864786, 0.488000392477382], 
       PolygonBox[{{991, 2890}, {1066, 2965}, {1147, 2993}, {890, 3052}, {726,
         3019}, {830, 2926}, {991, 2890}}]},
      "\"Czech Republic\""], 
     TooltipBox[
      {RGBColor[0.275282249988347, 0.0131593246150855, 0.983724948392908], 
       PolygonBox[{{520, 3294}, {488, 3395}, {597, 3423}, {495, 3409}, {633, 
        3464}, {567, 3289}, {520, 3295}}]},
      "\"Denmark\""], 
     TooltipBox[
      {RGBColor[0.530187355801466, 0.164974038164984, 0.981460378093752], 
       PolygonBox[{{791, -352}, {732, -347}, {786, -278}, {954, -235}, {1118, 
        209}, {1152, 298}, {1340, 248}, {1647, 301}, {1852, 209}, {1878, 
        127}, {1776, -83}, {1742, -164}, {1765, -267}, {1846, -491}, {
        1702, -556}, {1702, -693}, {1788, -729}, {1788, -807}, {1632, -694}, {
        1439, -652}, {1330, -652}, {1307, -437}, {1080, -486}, {1019, -435}, {
        991, -353}, {791, -352}}]},
      "\"Democratic Republic of the Congo\""], 
     TooltipBox[
      {RGBColor[0.984307913768689, 0.578910483357577, 0.0495477276327763], 
       PolygonBox[{{2597, 691}, {2551, 692}, {2587, 763}, {2506, 691}, {2577, 
        660}, {2597, 691}}]},
      "\"Djibouti\""], 
     TooltipBox[
      {RGBColor[0.352007067500415, 0.994654094198384, 0.557322889507225], 
       PolygonBox[{{-4306, 1182}, {-4099, 1116}, {-4307, 1083}, {-4306, 
        1182}}]},
      "\"Dominican Republic\""], 
     TooltipBox[
      {RGBColor[0.763804099139225, 0.976424481066605, 0.154736440774779], 
       PolygonBox[{{-4820, -202}, {-4786, -121}, {-4855, -139}, {-4855, -62}, \
{-4729, 86}, {-4517, -6}, {-4742, -300}, {-4829, -266}, {-4820, -202}}]},
      "\"Ecuador\""], 
     TooltipBox[
      {RGBColor[0.644161029878105, 0.72581260568301, 0.78194355886805], 
       PolygonBox[{{2137, 1388}, {1940, 1776}, {2055, 1664}, {2098, 1773}, {
        2094, 1769}, {2056, 1873}, {2053, 1880}, {1509, 1899}, {1500, 1320}, {
        2036, 1305}, {2137, 1388}}]},
      "\"Egypt\""], 
     TooltipBox[
      {RGBColor[0.957168203458947, 0.228018139722549, 0.0294735927505629], 
       PolygonBox[{{-5270, 806}, {-5406, 825}, {-5361, 866}, {-5270, 806}}]},
      "\"El Salvador\""], 
     TooltipBox[
      {RGBColor[0.632214539780024, 0.128050704811087, 0.740017747245167], 
       PolygonBox[{{588, 60}, {589, 141}, {680, 130}, {681, 60}, {588, 60}}]},
      
      "\"Equatorial Guinea\""], 
     TooltipBox[
      {RGBColor[0.754191342762216, 0.619055215164938, 0.14432575641818], 
       PolygonBox[{{2188, 862}, {2220, 1024}, {2317, 1082}, {2383, 905}, {
        2587, 763}, {2560, 739}, {2330, 878}, {2188, 862}}]},
      "\"Eritrea\""], 
     TooltipBox[
      {RGBColor[0.2098303914437, 0.589217304597232, 0.637594837071186], 
       PolygonBox[{{1682, 3569}, {1656, 3469}, {1446, 3472}, {1408, 3553}, {
        1682, 3569}}]},
      "\"Estonia\""], 
     TooltipBox[
      {RGBColor[0.16001784264949, 0.630919908086124, 0.539669576964456], 
       PolygonBox[{{2188, 862}, {2330, 878}, {2560, 739}, {2506, 691}, {2577, 
        660}, {2641, 540}, {2879, 480}, {2697, 294}, {2514, 239}, {2371, 
        206}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 762}, {2188, 
        862}}]},
      "\"Ethiopia\""], 
     TooltipBox[
      {RGBColor[0.285587769570771, 0.165363748451106, 0.0735970185788986], 
       PolygonBox[{{-3662, -3121}, {-3553, -3084}, {-3662, -3121}}], 
       PolygonBox[{{-3583, -3127}, {-3464, -3102}, {-3583, -3127}}]},
      "\"Falkland Islands\""], 
     TooltipBox[
      {RGBColor[0.775865477825231, 0.309163288504166, 0.0106273076763275], 
       PolygonBox[{{10670, -1042}, {10722, -1080}, {10680, -1096}}]},
      "\"Fiji\""], 
     TooltipBox[
      {RGBColor[0.429435988700794, 0.0500528721422209, 0.527219729636116], 
       PolygonBox[{{1450, 3949}, {1527, 3897}, {1266, 3766}, {1285, 3635}, {
        1373, 3588}, {1672, 3634}, {1895, 3775}, {1741, 4142}, {1738, 4143}, {
        1674, 4205}, {1545, 4139}, {1236, 4143}, {1450, 3949}}]},
      "\"Finland\""], 
     TooltipBox[
      {RGBColor[0.0534591042173802, 0.201417848978245, 0.020579279391658], 
       PolygonBox[{{452, 2627}, {446, 2625}, {444, 2624}, {233, 2613}, {193, 
        2546}, {105, 2550}, {90, 2556}, {-106, 2604}, {-67, 2779}, {-287, 
        2911}, {-81, 2918}, {-116, 2984}, {0, 2960}, {153, 3065}, {349, 
        2972}, {382, 2968}, {494, 2938}, {455, 2855}, {358, 2773}, {422, 
        2756}, {452, 2627}}]},
      "\"France\""], 
     TooltipBox[
      {RGBColor[0.895005189856093, 0.925408399406293, 0.461400101733078], 
       PolygonBox[{{-3250, 321}, {-3176, 327}, {-3101, 242}, {-3164, 
        140}, {-3277, 140}, {-3250, 321}}]},
      "\"French Guiana\""], 
     TooltipBox[
      {RGBColor[0.266387936629442, 0.275949974691155, 0.781082642988113], 
       PolygonBox[{{588, 60}, {523, -38}, {670, -237}, {695, -140}, {
        867, -114}, {870, 56}, {790, 74}, {798, 130}, {680, 130}, {681, 60}, {
        588, 60}}]},
      "\"Gabon\""], 
     TooltipBox[
      {RGBColor[0.251569710289378, 0.67717063203221, 0.638355137619969], 
       PolygonBox[{{-994, 815}, {-918, 807}, {-1005, 782}, {-1005, 
        784}, {-828, 803}, {-994, 815}}]},
      "\"The Gambia\""], 
     TooltipBox[
      {RGBColor[0.621064800338623, 0.620649802203254, 0.137501055067754], 
       PolygonBox[{{2400, 2603}, {2637, 2563}, {2778, 2509}, {2823, 2445}, {
        2701, 2472}, {2590, 2435}, {2492, 2491}, {2400, 2603}}]},
      "\"Georgia\""], 
     TooltipBox[
      {RGBColor[0.352767368049198, 0.455701051887516, 0.547052783624356], 
       PolygonBox[{{432, 3194}, {590, 3212}, {520, 3295}, {567, 3289}, {567, 
        3290}, {654, 3237}, {856, 3224}, {854, 3236}, {890, 3052}, {726, 
        3019}, {830, 2926}, {783, 2850}, {584, 2852}, {574, 2852}, {455, 
        2855}, {494, 2938}, {382, 2968}, {368, 3008}, {361, 3045}, {432, 
        3194}}]},
      "\"Germany\""], 
     TooltipBox[
      {RGBColor[0.361635577242523, 0.0436040795450319, 0.445073744211189], 
       PolygonBox[{{-186, 305}, {0, 337}, {72, 366}, {0, 636}, {-5, 642}, {0, 
        666}, {-9, 668}, {-170, 660}, {-161, 569}, {-186, 305}}]},
      "\"Ghana\""], 
     TooltipBox[
      {RGBColor[0.117616794923562, 0.311582705100302, 0.516384349908916], 
       PolygonBox[{{-322, 2170}, {-323, 2169}, {-322, 2169}}]},
      "\"Gibraltar\""], 
     TooltipBox[
      {RGBColor[0.391614639993809, 0.916198945945317, 0.291003425708644], 
       PolygonBox[{{1562, 2444}, {1422, 2443}, {1355, 2428}, {1351, 2331}, {
        1444, 2292}, {1363, 2254}, {1392, 2186}, {1266, 2271}, {1333, 2291}, {
        1394, 2289}, {1223, 2357}, {1201, 2381}, {1259, 2451}, {1376, 2481}, {
        1582, 2503}, {1562, 2444}}]},
      "\"Greece\""], 
     TooltipBox[
      {RGBColor[0.621379160052823, 0.466206240587516, 0.454798844212239], 
       PolygonBox[{{-2149, 3968}, {-1949, 4117}, {-1633, 4112}, {-1338, 
        4200}, {-1752, 4224}, {-1525, 4276}, {-1716, 4328}, {-1294, 
        4228}, {-1533, 4344}, {-1647, 4407}, {-1230, 4407}, {-1327, 
        4475}, {-1139, 4469}, {-1346, 4510}, {-1160, 4524}, {-1348, 
        4610}, {-1087, 4617}, {-1322, 4661}, {-967, 4830}, {-1275, 
        4834}, {-729, 4896}, {-1468, 4832}, {-1338, 4925}, {-1514, 
        4920}, {-1959, 4901}, {-1279, 4956}, {-2129, 4965}, {-1540, 
        4997}, {-1981, 5017}, {-2801, 4981}, {-2394, 4960}, {-2745, 
        4966}, {-2678, 4905}, {-2992, 4897}, {-3515, 4926}, {-3387, 
        4880}, {-3608, 4916}, {-3948, 4748}, {-4358, 4710}, {-3964, 
        4650}, {-4282, 4623}, {-4110, 4565}, {-3605, 4561}, {-3354, 
        4301}, {-3214, 4341}, {-3029, 4231}, {-3278, 4239}, {-3013, 
        4201}, {-3203, 4100}, {-3009, 4076}, {-3224, 4052}, {-3058, 
        4074}, {-3232, 4034}, {-3022, 4030}, {-3238, 4024}, {-3209, 
        3966}, {-3000, 4019}, {-3208, 3959}, {-3033, 3943}, {-3154, 
        3919}, {-3120, 3852}, {-3000, 3892}, {-3028, 3803}, {-2894, 
        3649}, {-2713, 3672}, {-2707, 3604}, {-2586, 3606}, {-2548, 
        3704}, {-2589, 3765}, {-2467, 3907}, {-2149, 3968}}], 
       PolygonBox[{{-3258, 4219}, {-3110, 4178}, {-3214, 4154}, {-3258, 
        4219}}]},
      "\"Greenland\""], 
     TooltipBox[
      {RGBColor[0.0246154890792026, 0.345429185361668, 0.685123597599403], 
       PolygonBox[{{-5335, 954}, {-5293, 943}, {-5361, 866}, {-5406, 
        825}, {-5535, 873}, {-5504, 964}, {-5426, 966}, {-5459, 1069}, {-5348,
         1069}, {-5335, 954}}]},
      "\"Guatemala\""], 
     TooltipBox[
      {RGBColor[0.203229133922861, 0.347444857046993, 0.7070740477417], 
       PolygonBox[{{-798, 542}, {-901, 657}, {-823, 761}, {-681, 748}, {-682, 
        744}, {-539, 744}, {-479, 609}, {-478, 610}, {-508, 454}, {-616, 
        509}, {-673, 600}, {-798, 542}}]},
      "\"Guinea\""], 
     TooltipBox[
      {RGBColor[0.0640587972607802, 0.582579331719607, 0.209943801979239], 
       PolygonBox[{{-1003, 739}, {-900, 718}, {-930, 680}, {-901, 657}, {-823,
         761}, {-1003, 739}}]},
      "\"Guinea-Bissau\""], 
     TooltipBox[
      {RGBColor[0.354306679692502, 0.608357745373264, 0.035526548095251], 
       PolygonBox[{{-3435, 329}, {-3521, 383}, {-3509, 442}, {-3599, 
        512}, {-3683, 357}, {-3644, 312}, {-3580, 263}, {-3555, 83}, {-3388, 
        117}, {-3483, 240}, {-3435, 329}}]},
      "\"Guyana\""], 
     TooltipBox[
      {RGBColor[0.848308224736715, 0.31070260014747, 0.163284001162075], 
       PolygonBox[{{-4306, 1082}, {-4469, 1106}, {-4341, 1112}, {-4407, 
        1185}, {-4305, 1182}, {-4306, 1082}}]},
      "\"Haiti\""], 
     TooltipBox[
      {RGBColor[0.917909753171689, 0.536725519636413, 0.794318250238554], 
       PolygonBox[{{-5293, 943}, {-4988, 900}, {-5238, 779}, {-5270, 
        806}, {-5361, 866}, {-5293, 943}}]},
      "\"Honduras\""], 
     TooltipBox[
      {RGBColor[0.771669361168266, 0.00171080722637129, 0.245722093927769], 
       PolygonBox[{{1374, 2877}, {1329, 2905}, {1030, 2881}, {967, 2812}, {
        1072, 2746}, {1216, 2767}, {1374, 2877}}]},
      "\"Hungary\""], 
     TooltipBox[
      {RGBColor[0.172939090185731, 0.30546312058075, 0.546911963014132], 
       PolygonBox[{{-1282, 3831}, {-1443, 3892}, {-1302, 3927}, {-1472, 
        3930}, {-1387, 3986}, {-1265, 3910}, {-970, 3992}, {-818, 
        3928}, {-1090, 3808}, {-1282, 3831}}]},
      "\"Iceland\""], 
     TooltipBox[
      {RGBColor[0.221106604848566, 0.827509904824063, 0.620339522981347], 
       PolygonBox[{{5342, 1315}, {5274, 1345}, {5185, 1199}, {4817, 942}, {
        4791, 670}, {4767, 549}, {4618, 504}, {4398, 991}, {4375, 1336}, {
        4327, 1272}, {4244, 1243}, {4137, 1338}, {4230, 1386}, {4092, 1426}, {
        4266, 1465}, {4171, 1620}, {4314, 1678}, {4481, 1864}, {4523, 1937}, {
        4437, 2079}, {4669, 2130}, {4812, 2106}, {4734, 2038}, {4770, 1959}, {
        4704, 1952}, {4862, 1812}, {4804, 1730}, {4966, 1650}, {5240, 1581}, {
        5289, 1672}, {5335, 1639}, {5499, 1666}, {5765, 1768}, {5841, 1693}, {
        5828, 1625}, {5708, 1597}, {5556, 1319}, {5537, 1418}, {5497, 1377}, {
        5470, 1418}, {5544, 1502}, {5391, 1517}, {5305, 1598}, {5341, 1517}, {
        5342, 1315}}]},
      "\"India\""], 
     TooltipBox[
      {RGBColor[0.343682829091271, 0.873661747801573, 0.120435857082363], 
       PolygonBox[{{5714, 334}, {5851, 315}, {6176, 42}, {6146, 15}, {6224, 
        17}, {6263, -62}, {6272, -166}, {6365, -194}, {6347, -350}, {
        6280, -356}, {6096, -193}, {5714, 334}}], 
       PolygonBox[{{5952, -106}, {5933, -55}, {5952, -106}}], 
       PolygonBox[{{6353, -89}, {6391, -186}, {6308, -124}, {6354, -90}}], 
       PolygonBox[{{6579, 124}, {6547, -30}, {6614, -179}, {6712, -214}, {
        6878, -251}, {6960, -213}, {6973, -107}, {7074, 67}, {7141, 59}, {
        7022, 216}, {7055, 250}, {6952, 262}, {6893, 124}, {6634, 51}, {6579, 
        124}}], PolygonBox[{{6594, -470}, {6874, -527}, {6866, -468}, {
        6661, -386}, {6422, -355}, {6313, -406}, {6594, -470}}], 
       PolygonBox[{{6776, -414}, {6848, -417}, {6777, -414}}], 
       PolygonBox[{{6869, -486}, {6943, -504}, {6869, -485}}], 
       PolygonBox[{{6980, -493}, {6961, -535}, {6981, -493}}], 
       PolygonBox[{{7033, -503}, {7140, -503}, {7023, -547}, {7033, -503}}], 
       PolygonBox[{{7142, -566}, {7249, -599}, {7142, -566}}], 
       PolygonBox[{{7216, -496}, {7380, -495}, {7261, -537}, {7194, -532}, {
        7217, -496}}], PolygonBox[{{7468, -488}, {7508, -500}, {7468, -488}}],
        PolygonBox[{{7506, -568}, {7638, -504}, {7509, -518}, {7408, -622}, {
        7506, -568}}], PolygonBox[{{7899, -427}, {7868, -481}, {7899, -427}}],
        PolygonBox[{{7175, -337}, {7126, -186}, {7202, 43}, {7515, 90}, {7455,
         22}, {7215, 21}, {7240, -84}, {7407, -46}, {7278, -108}, {
        7374, -264}, {7292, -264}, {7246, -157}, {7221, -263}, {7204, -335}}],
        PolygonBox[{{7413, -78}, {7368, -87}, {7413, -79}}], 
       PolygonBox[{{7465, -99}, {7519, -113}, {7465, -99}}], 
       PolygonBox[{{7525, -107}, {7581, -109}, {7525, -107}}], 
       PolygonBox[{{7363, -277}, {7337, -323}, {7363, -277}}], 
       PolygonBox[{{7385, -264}, {7369, -341}, {7384, -264}}], 
       PolygonBox[{{7568, -187}, {7635, -202}, {7568, -187}}], 
       PolygonBox[{{7691, -172}, {7835, -188}, {7850, -232}, {7675, -214}, {
        7691, -172}}], PolygonBox[{{8071, -326}, {8060, -374}, {8071, -326}}],
        PolygonBox[{{7734, 12}, {7675, 12}, {7706, -55}, {7654, 25}, {7683, 
        132}, {7658, 55}, {7734, 12}}], 
       PolygonBox[{{8313, -443}, {8334, -485}, {8259, -506}, {8314, -443}}], 
       PolygonBox[{{8460, -548}, {8409, -473}, {8335, -498}, {8284, -324}, {
        8038, -231}, {8032, -176}, {7974, -245}, {7917, -167}, {8036, -126}, {
        7857, -86}, {7946, -21}, {8054, -86}, {8107, -202}, {8271, -88}, {
        8460, -156}, {8460, -156}, {8460, -548}}]},
      "\"Indonesia\""], 
     TooltipBox[
      {RGBColor[0.556280725720567, 0.761103497371664, 0.663717945822335], 
       PolygonBox[{{3697, 1512}, {3467, 1538}, {3223, 1602}, {3008, 1797}, {
        2912, 1798}, {2724, 2038}, {2781, 2148}, {2688, 2230}, {2688, 2379}, {
        2770, 2330}, {2888, 2376}, {2933, 2307}, {3066, 2204}, {3234, 2241}, {
        3432, 2297}, {3574, 2233}, {3677, 2136}, {3635, 1984}, {3711, 1861}, {
        3652, 1792}, {3800, 1628}, {3697, 1512}}]},
      "\"Iran\""], 
     TooltipBox[
      {RGBColor[0.766129177389861, 0.947922980347303, 0.725576949276413], 
       PolygonBox[{{2877, 1801}, {2912, 1798}, {2724, 2038}, {2781, 2148}, {
        2688, 2230}, {2541, 2226}, {2460, 2065}, {2328, 2002}, {2358, 1934}, {
        2683, 1752}, {2793, 1746}, {2877, 1801}}]},
      "\"Iraq\""], 
     TooltipBox[
      {RGBColor[0.815409721085619, 0.455426577242391, 0.784638979185228], 
       PolygonBox[{{-376, 3245}, {-382, 3131}, {-586, 3087}, {-628, 
        3131}, {-524, 3160}, {-607, 3246}, {-435, 3303}, {-489, 3266}, {-376, 
        3245}}]},
      "\"Ireland\""], 
     TooltipBox[
      {RGBColor[0.807667196104724, 0.278684201449206, 0.661108327003837], 
       PolygonBox[{{2053, 1880}, {2106, 1986}, {2132, 1994}, {2137, 1995}, {
        2140, 1995}, {2139, 1961}, {2129, 1890}, {2098, 1773}, {2094, 1769}, {
        2056, 1873}, {2053, 1880}}]},
      "\"Israel\""], 
     TooltipBox[
      {RGBColor[0.0129696180169625, 0.805956388878353, 0.0329621075214374], 
       PolygonBox[{{823, 2736}, {736, 2727}, {743, 2653}, {1111, 2408}, {997, 
        2406}, {964, 2275}, {940, 2402}, {666, 2544}, {606, 2641}, {452, 
        2627}, {422, 2756}, {628, 2813}, {823, 2792}, {823, 2736}}], 
       PolygonBox[{{937, 2295}, {905, 2199}, {745, 2268}, {937, 2295}}], 
       PolygonBox[{{555, 2475}, {531, 2333}, {488, 2444}, {555, 2475}}]},
      "\"Italy\""], 
     TooltipBox[
      {RGBColor[0.488169236818106, 0.707506497436213, 0.259044425864221], 
       PolygonBox[{{-4702, 1096}}]},
      "\"Jamaica\""], 
     TooltipBox[
      {RGBColor[0.811855502672871, 0.660659331994043, 0.0871669744548655], 
       PolygonBox[{{7899, 1947}, {7861, 2037}, {7775, 2001}, {7840, 1860}, {
        7899, 1947}}], 
       PolygonBox[{{8076, 2045}, {7981, 1962}, {7921, 2000}, {8076, 2044}}], 
       PolygonBox[{{8468, 2486}, {8524, 2373}, {8420, 2108}, {8331, 2076}, {
        8211, 2105}, {8146, 2006}, {8120, 2083}, {7853, 2036}, {7985, 2135}, {
        8206, 2241}, {8313, 2242}, {8468, 2486}}], 
       PolygonBox[{{8517, 2731}, {8626, 2646}, {8749, 2602}, {8594, 2515}, {
        8428, 2554}, {8472, 2508}, {8402, 2487}, {8484, 2597}, {8518, 2730}}],
        PolygonBox[{{7697, 1612}, {7659, 1565}, {7697, 1611}}]},
      "\"Japan\""], 
     TooltipBox[
      {RGBColor[0.91536159677295, 0.938193754871298, 0.54022347491168], 
       PolygonBox[{{2098, 1762}, {2099, 1773}, {2129, 1890}, {2139, 1961}, {
        2328, 2003}, {2358, 1934}, {2220, 1890}, {2250, 1800}, {2098, 
        1762}}]},
      "\"Jordan\""], 
     TooltipBox[
      {RGBColor[0.530886248734299, 0.154258099401286, 0.274475809048963], 
       PolygonBox[{{2953, 2782}, {3072, 2827}, {3190, 2777}, {3195, 2720}, {
        3094, 2671}, {3013, 2674}, {3170, 2502}, {3360, 2490}, {3360, 2700}, {
        3520, 2730}, {3730, 2610}, {4075, 2477}, {4170, 2480}, {4261, 2538}, {
        4461, 2592}, {4695, 2568}, {4816, 2523}, {4792, 2694}, {4954, 2708}, {
        4982, 2833}, {5141, 2832}, {5240, 2946}, {5269, 2948}, {5012, 3027}, {
        4768, 3086}, {4638, 3262}, {4471, 3227}, {4238, 3308}, {3695, 3246}, {
        3653, 3047}, {3247, 3067}, {3064, 3097}, {2811, 2965}, {2953, 
        2782}}]},
      "\"Kazakhstan\""], 
     TooltipBox[
      {RGBColor[0.774094297521818, 0.582963268386995, 0.428681150124873], 
       PolygonBox[{{2494, -100}, {2352, -280}, {2035, -60}, {2102, 115}, {
        2040, 253}, {2156, 277}, {2371, 206}, {2515, 239}, {2459, 170}, {
        2494, -100}}]},
      "\"Kenya\""], 
     TooltipBox[
      {RGBColor[0.459066087963344, 0.318667720279427, 0.798324289201767], 
       PolygonBox[{{2905, 1713}, {2877, 1801}, {2793, 1746}, {2905, 1713}}]},
      "\"Kuwait\""], 
     TooltipBox[
      {RGBColor[0.621013954020149, 0.180381886514138, 0.65755939327559], 
       PolygonBox[{{4450, 2372}, {4291, 2354}, {4174, 2396}, {4380, 2456}, {
        4274, 2467}, {4261, 2538}, {4461, 2592}, {4695, 2568}, {4816, 2523}, {
        4440, 2403}, {4450, 2372}}]},
      "\"Kyrgyzstan\""], 
     TooltipBox[
      {RGBColor[0.785354671184805, 0.815057565141797, 0.1474197789927], 
       PolygonBox[{{6005, 1221}, {6069, 1294}, {6128, 1344}, {6190, 1251}, {
        6279, 1240}, {6233, 1158}, {6448, 965}, {6453, 882}, {6313, 861}, {
        6283, 1050}, {6204, 1106}, {6055, 1054}, {6077, 1174}, {6005, 
        1221}}]},
      "\"Laos\""], 
     TooltipBox[
      {RGBColor[0.169390156457485, 0.077848173748592, 0.556013139277576], 
       PolygonBox[{{1446, 3472}, {1656, 3469}, {1686, 3361}, {1580, 3332}, {
        1479, 3383}, {1280, 3363}, {1285, 3432}, {1464, 3434}, {1446, 
        3472}}]},
      "\"Latvia\""], 
     TooltipBox[
      {RGBColor[0.335564276319829, 0.508730824463442, 0.990681199293727], 
       PolygonBox[{{2158, 2079}, {2106, 1986}, {2132, 1994}, {2137, 1995}, {
        2158, 2079}}]},
      "\"Lebanon\""], 
     TooltipBox[
      {RGBColor[0.640651542504626, 0.397370521448531, 0.968507349551762], 
       PolygonBox[{{-690, 416}, {-452, 261}, {-508, 454}, {-616, 509}, {-690, 
        416}}]},
      "\"Liberia\""], 
     TooltipBox[
      {RGBColor[0.459794950559428, 0.486393443103339, 0.122894712399568], 
       PolygonBox[{{692, 1990}, {955, 1879}, {1160, 1817}, {1303, 1977}, {
        1509, 1899}, {1500, 1320}, {1500, 1320}, {1500, 1200}, {1440, 1170}, {
        960, 1410}, {898, 1379}, {720, 1411}, {564, 1569}, {572, 1814}, {692, 
        1990}}]},
      "\"Libya\""], 
     TooltipBox[
      {RGBColor[0.194413052029944, 0.876831682172433, 0.057712292978466], 
       PolygonBox[{{576, 2824}, {572, 2837}, {572, 2836}, {576, 2824}}]},
      "\"Liechtenstein\""], 
     TooltipBox[
      {RGBColor[0.663828624436224, 0.875745331750517, 0.0785073929706655], 
       PolygonBox[{{1280, 3363}, {1479, 3383}, {1580, 3332}, {1519, 3249}, {
        1410, 3237}, {1369, 3242}, {1373, 3286}, {1277, 3320}, {1280, 
        3363}}]},
      "\"Lithuania\""], 
     TooltipBox[
      {RGBColor[0.436698338958317, 0.483446737922086, 0.218185938474927], 
       PolygonBox[{{368, 3008}, {382, 2968}, {349, 2973}, {368, 3008}}]},
      "\"Luxembourg\""], 
     TooltipBox[
      {RGBColor[0.293152721785861, 0.62164077381652, 0.336026958929386], 
       PolygonBox[{{1232, 2506}, {1274, 2533}, {1371, 2534}, {1376, 2480}, {
        1259, 2451}, {1232, 2506}}]},
      "\"Macedonia\""], 
     TooltipBox[
      {RGBColor[0.0487957820174421, 0.215304548037269, 0.0656276345389445], 
       PolygonBox[{{2599, -1312}, {2671, -1197}, {2668, -971}, {2880, -886}, {
        2957, -717}, {3030, -919}, {2978, -933}, {2828, -1499}, {
        2644, -1497}, {2599, -1312}}]},
      "\"Madagascar\""], 
     TooltipBox[
      {RGBColor[0.000462682609556669, 0.540064957554, 0.224623348743543], 
       PolygonBox[{{1979, -569}, {2060, -584}, {2097, -694}, {2074, -801}, {
        2155, -893}, {2117, -1028}, {2072, -875}, {1993, -841}, {
        1979, -569}}]},
      "\"Malawi\""], 
     TooltipBox[
      {RGBColor[0.424976092034319, 0.603092161161025, 0.571557608002238], 
       PolygonBox[{{6579, 124}, {6634, 51}, {6893, 124}, {6952, 262}, {7056, 
        250}, {7157, 321}, {7048, 352}, {7029, 420}, {6909, 294}, {6902, 
        289}, {6901, 292}, {6845, 275}, {6687, 161}, {6683, 81}, {6579, 
        124}}], PolygonBox[{{6008, 385}, {6077, 170}, {6211, 76}, {6258, 
        87}, {6207, 288}, {6126, 374}, {6069, 338}, {6008, 385}}]},
      "\"Malaysia\""], 
     TooltipBox[
      {RGBColor[0.764828398184115, 0.938582648930979, 0.480197448761458], 
       PolygonBox[{{255, 1149}, {0, 1310}, {-288, 1500}, {-395, 1500}, {-330, 
        930}, {-690, 939}, {-723, 884}, {-735, 886}, {-681, 748}, {-682, 
        744}, {-539, 744}, {-478, 610}, {-331, 626}, {-238, 810}, {0, 900}, {
        14, 900}, {233, 943}, {255, 1149}}]},
      "\"Mali\""], 
     TooltipBox[
      {RGBColor[0.377144555972294, 0.887996716011682, 0.880870355952513], 
       PolygonBox[{{-1023, 1246}, {-972, 1213}, {-992, 963}, {-803, 
        962}, {-723, 883}, {-690, 939}, {-330, 930}, {-395, 1500}, {-288, 
        1500}, {-520, 1638}, {-520, 1560}, {-720, 1560}, {-786, 1374}, {-780, 
        1280}, {-1023, 1246}}]},
      "\"Mauritania\""], 
     TooltipBox[
      {RGBColor[0.816368824325234, 0.501399224221778, 0.809489323041017], 
       PolygonBox[{{-5828, 1558}, {-5873, 1356}, {-5752, 1123}, {-5471, 
        1120}, {-5482, 1132}, {-5420, 1262}, {-5227, 1297}, {-5298, 
        1109}, {-5348, 1069}, {-5459, 1069}, {-5426, 966}, {-5504, 
        964}, {-5535, 873}, {-5567, 905}, {-5535, 873}, {-5692, 986}, {-5867, 
        958}, {-6209, 1100}, {-6327, 1195}, {-6343, 1352}, {-6564, 
        1538}, {-6730, 1738}, {-6785, 1874}, {-6902, 1917}, {-6772, 
        1697}, {-6571, 1388}, {-6726, 1484}, {-6901, 1664}, {-6844, 
        1711}, {-7027, 1952}, {-6883, 1963}, {-6543, 1880}, {-6391, 
        1907}, {-6243, 1760}, {-6050, 1757}, {-5945, 1584}, {-5828, 1558}}]},
      "\"Mexico\""], 
     TooltipBox[
      {RGBColor[0.444172016994197, 0.332922086403147, 0.283213285746851], 
       PolygonBox[{{1600, 2895}, {1697, 2889}, {1778, 2811}, {1690, 2728}, {
        1600, 2895}}]},
      "\"Moldova\""], 
     TooltipBox[
      {RGBColor[0.516336601255155, 0.822531243177677, 0.996895127473762], 
       PolygonBox[{{447, 2625}, {443, 2623}, {443, 2624}, {446, 2625}}]},
      "\"Monaco\""], 
     TooltipBox[
      {RGBColor[0.234417503729409, 0.301032053217886, 0.756903608638732], 
       PolygonBox[{{5271, 2950}, {5454, 2817}, {5442, 2719}, {5724, 2656}, {
        5783, 2564}, {6315, 2504}, {6608, 2559}, {6718, 2622}, {6720, 2706}, {
        7194, 2800}, {7106, 2880}, {6935, 2873}, {7003, 2990}, {6513, 2960}, {
        6199, 3012}, {5936, 3129}, {5840, 2984}, {5543, 3052}, {5271, 
        2950}}]},
      "\"Mongolia\""], 
     TooltipBox[
      {RGBColor[0.996432444864205, 0.694352546175409, 0.0764087044743439], 
       PolygonBox[{{-132, 2106}, {-325, 2155}, {-374, 2101}, {-557, 
        1953}, {-614, 1759}, {-791, 1660}, {-520, 1660}, {-520, 1723}, {-218, 
        1858}, {-229, 1902}, {-71, 1926}, {-132, 2106}}]},
      "\"Morocco\""], 
     TooltipBox[
      {RGBColor[0.331927516604413, 0.39334028370318, 0.122794938173171], 
       PolygonBox[{{2426, -629}, {2440, -917}, {2074, -1177}, {2130, -1446}, {
        1969, -1536}, {1974, -1611}, {1928, -1610}, {1918, -1557}, {
        1878, -1345}, {1982, -1202}, {1979, -1003}, {1825, -938}, {
        1993, -841}, {2072, -875}, {2117, -1028}, {2155, -893}, {
        2074, -801}, {2097, -694}, {2426, -629}}]},
      "\"Mozambique\""], 
     TooltipBox[
      {RGBColor[0.311580306290229, 0.393344867673434, 0.913142834941722], 
       PolygonBox[{{706, -1035}, {872, -1361}, {867, -1388}, {989, -1715}, {
        1200, -1706}, {1200, -1486}, {1200, -1320}, {1260, -1099}, {
        1516, -1068}, {1409, -1058}, {831, -1040}, {706, -1035}}]},
      "\"Namibia\""], 
     TooltipBox[
      {RGBColor[0.745650382200876, 0.423583590278547, 0.51247451172092], 
       PolygonBox[{{4861, 1812}, {5289, 1672}, {5240, 1581}, {4966, 1650}, {
        4804, 1730}, {4861, 1812}}]},
      "\"Nepal\""], 
     TooltipBox[
      {RGBColor[0.0967740106164884, 0.244251157979099, 0.614094267237531], 
       PolygonBox[{{202, 3082}, {284, 3178}, {433, 3195}, {361, 3045}, {202, 
        3082}}]},
      "\"Netherlands\""], 
     TooltipBox[
      {RGBColor[0.0683024947267236, 0.763851924213341, 0.961037872232248], 
       PolygonBox[{{10441, -2501}, {10363, -2430}, {10288, -2505}, {
        10004, -2773}, {10247, -2753}, {10229, -2685}, {10332, -2634}, {
        10257, -2598}, {10365, -2596}, {10441, -2501}}], 
       PolygonBox[{{10616, -2381}, {10514, -2497}, {10521, -2412}, {
        10428, -2365}, {10497, -2224}, {10362, -2065}, {10560, -2258}, {
        10713, -2262}, {10616, -2381}}]},
      "\"New Zealand\""], 
     TooltipBox[
      {RGBColor[0.0977576659823755, 0.245771251549047, 0.766956796739579], 
       PolygonBox[{{-4988, 900}, {-5019, 655}, {-5141, 664}, {-5240, 
        778}, {-4988, 900}}]},
      "\"Nicaragua\""], 
     TooltipBox[
      {RGBColor[0.726620368502839, 0.796725612764489, 0.488867642910315], 
       PolygonBox[{{898, 1379}, {719, 1411}, {255, 1149}, {233, 943}, {14, 
        900}, {144, 714}, {214, 705}, {216, 702}, {293, 827}, {578, 768}, {
        818, 823}, {929, 1014}, {960, 1221}, {898, 1379}}]},
      "\"Niger\""], 
     TooltipBox[
      {RGBColor[0.770524351875374, 0.0322678223274302, 0.720316908290145], 
       PolygonBox[{{515, 288}, {366, 256}, {317, 354}, {163, 382}, {214, 
        705}, {216, 702}, {293, 827}, {578, 768}, {818, 823}, {845, 784}, {
        879, 694}, {713, 425}, {588, 408}, {515, 288}}]},
      "\"Nigeria\""], 
     TooltipBox[
      {RGBColor[0.156940126305902, 0.377184068172195, 0.90947288415426], 
       PolygonBox[{{7702, 2317}, {7650, 2383}, {7841, 2538}, {7836, 2545}, {
        7462, 2406}, {7539, 2318}, {7480, 2287}, {7602, 2270}, {7702, 
        2317}}]},
      "\"North Korea\""], 
     TooltipBox[
      {RGBColor[0.408736601999916, 0.763595258632468, 0.464041233230473], 
       PolygonBox[{{1847, 4187}, {1864, 4217}, {1746, 4252}, {1659, 4267}, {
        1522, 4258}, {1086, 4159}, {791, 4000}, {573, 3826}, {687, 3827}, {
        413, 3775}, {305, 3731}, {409, 3712}, {312, 3666}, {462, 3674}, {311, 
        3639}, {426, 3630}, {311, 3570}, {396, 3484}, {634, 3593}, {686, 
        3539}, {728, 3815}, {1235, 4143}, {1545, 4139}, {1674, 4205}, {1738, 
        4143}, {1741, 4142}, {1851, 4188}}], 
       PolygonBox[{{1491, 4821}, {1435, 4751}, {1067, 4808}, {1491, 4821}}], 
       PolygonBox[{{641, 4772}, {780, 4692}, {1038, 4705}, {815, 4683}, {981, 
        4594}, {1293, 4726}, {978, 4804}, {987, 4734}, {641, 4772}}]},
      "\"Norway\""], 
     TooltipBox[
      {RGBColor[0.163822501953383, 0.985153011721368, 0.251120746911548], 
       PolygonBox[{{3186, 998}, {3468, 1138}, {3588, 1333}, {3396, 1470}, {
        3350, 1390}, {3400, 1320}, {3119, 1140}, {3186, 998}}]},
      "\"Oman\""], 
     TooltipBox[
      {RGBColor[0.367267222613984, 0.919571343974285, 0.371058744483838], 
       PolygonBox[{{3697, 1512}, {4002, 1507}, {4092, 1426}, {4266, 1465}, {
        4171, 1620}, {4314, 1678}, {4481, 1864}, {4523, 1937}, {4437, 2079}, {
        4669, 2130}, {4474, 2222}, {4298, 2188}, {4194, 2041}, {4160, 1916}, {
        4003, 1873}, {3975, 1791}, {3652, 1792}, {3800, 1628}, {3697, 
        1512}}]},
      "\"Pakistan\""], 
     TooltipBox[
      {RGBColor[0.182818252184824, 0.603415298400643, 0.958533471742037], 
       PolygonBox[{{-4954, 574}, {-4802, 556}, {-4790, 562}, {-4642, 
        521}, {-4673, 434}, {-4687, 513}, {-4772, 536}, {-4776, 533}, {-4826, 
        435}, {-4974, 482}, {-4954, 574}}]},
      "\"Panama\""], 
     TooltipBox[
      {RGBColor[0.273301078501462, 0.937047000635777, 0.836458501661064], 
       PolygonBox[{{8460, -156}, {8849, -359}, {8831, -448}, {9053, -614}, {
        8863, -606}, {8671, -450}, {8528, -494}, {8600, -542}, {8460, -548}, {
        8460, -156}}], 
       PolygonBox[{{9131, -249}, {9062, -363}, {8902, -329}, {9056, -329}, {
        9131, -249}}]},
      "\"Papua New Guinea\""], 
     TooltipBox[
      {RGBColor[0.231913103239198, 0.476575465736973, 0.448179357725462], 
       PolygonBox[{{-3276, -1534}, {-3335, -1637}, {-3516, -1639}, {-3465, \
-1511}, {-3759, -1334}, {-3705, -1179}, {-3490, -1210}, {-3479, -1325}, \
{-3351, -1337}, {-3324, -1438}, {-3255, -1443}, {-3276, -1534}}]},
      "\"Paraguay\""], 
     TooltipBox[
      {RGBColor[0.06593414978569, 0.199645280911768, 0.756258557446828], 
       PolygonBox[{{-4224, -1101}, {-4577, -850}, {-4726, -515}, {-4871, \
-360}, {-4820, -202}, {-4829, -266}, {-4742, -300}, {-4517, -6}, {-4376, \
-146}, {-4206, -158}, {-4243, -227}, {-4197, -253}, {-4374, -308}, {-4441, \
-452}, {-4392, -564}, {-4231, -566}, {-4238, -661}, {-4174, -657}, {-4120, \
-750}, {-4170, -1050}, {-4224, -1101}}]},
      "\"Peru\""], 
     TooltipBox[
      {RGBColor[0.29123923141956, 0.688750081613495, 0.290172396757508], 
       PolygonBox[{{7337, 1104}, {7283, 917}, {7317, 839}, {7436, 827}, {7445,
         753}, {7352, 838}, {7356, 790}, {7238, 828}, {7187, 979}, {7236, 
        1112}, {7338, 1104}}], 
       PolygonBox[{{7396, 755}, {7444, 704}, {7396, 755}}], 
       PolygonBox[{{7222, 811}, {7293, 787}, {7267, 734}, {7223, 811}}], 
       PolygonBox[{{7527, 588}, {7597, 436}, {7572, 376}, {7540, 435}, {7524, 
        335}, {7421, 469}, {7313, 426}, {7404, 523}, {7421, 478}, {7531, 
        540}, {7527, 589}}], 
       PolygonBox[{{7466, 606}, {7428, 585}, {7467, 606}}], 
       PolygonBox[{{7412, 653}, {7393, 546}, {7344, 590}, {7412, 653}}], 
       PolygonBox[{{7322, 714}, {7390, 688}, {7316, 626}, {7322, 714}}], 
       PolygonBox[{{7171, 685}, {7183, 630}, {7031, 500}, {7171, 684}}]},
      "\"Philippines\""], 
     TooltipBox[
      {RGBColor[0.347521955446912, 0.527643972787092, 0.224708848383023], 
       PolygonBox[{{854, 3236}, {1177, 3268}, {1410, 3237}, {1416, 3091}, {
        1353, 2945}, {890, 3052}, {854, 3236}}]},
      "\"Poland\""], 
     TooltipBox[
      {RGBColor[0.126349894804125, 0.362368943725544, 0.276523225875544], 
       PolygonBox[{{-445, 2231}, {-535, 2231}, {-570, 2323}, {-525, 
        2518}, {-371, 2495}, {-445, 2231}}]},
      "\"Portugal\""], 
     TooltipBox[
      {RGBColor[0.857441625769038, 0.20677855082984, 0.991310199241706], 
       PolygonBox[{{-4036, 1103}}]},
      "\"Puerto Rico\""], 
     TooltipBox[
      {RGBColor[0.0937049736907203, 0.254026327368395, 0.248245079087803], 
       PolygonBox[{{3073, 1477}, {3075, 1569}, {3050, 1485}, {3073, 1477}}]},
      "\"Qatar\""], 
     TooltipBox[
      {RGBColor[0.718009120740244, 0.156657973054943, 0.417567825707331], 
       PolygonBox[{{1780, 2713}, {1715, 2625}, {1361, 2653}, {1216, 2767}, {
        1374, 2877}, {1600, 2895}, {1690, 2728}, {1780, 2713}}]},
      "\"Romania\""], 
     TooltipBox[
      {RGBColor[
       0.0163319758486054, 0.241433655003271, 0.708478615329481], {
        PolygonBox[
         NCache[{{10800, Rational[2323143, 566]}, {10567, 4193}, {10233, 
           4188}, {10237, 4125}, {9746, 4180}, {9663, 4112}, {9555, 4249}, {
           9152, 4247}, {8896, 4339}, {8693, 4300}, {8816, 4339}, {8811, 
           4341}, {8439, 4374}, {8402, 4288}, {7861, 4244}, {7118, 4414}, {
           6809, 4410}, {6817, 4357}, {6678, 4432}, {6304, 4367}, {6823, 
           4524}, {6666, 4605}, {6244, 4664}, {6135, 4583}, {5929, 4590}, {
           6011, 4510}, {5928, 4576}, {5152, 4483}, {5207, 4379}, {5207, 
           4434}, {4831, 4414}, {4990, 4205}, {4996, 4303}, {4711, 4344}, {
           4575, 4295}, {4707, 4253}, {4530, 4294}, {4500, 4373}, {4450, 
           4225}, {4428, 4148}, {4658, 4134}, {4743, 4054}, {4593, 4139}, {
           4320, 3973}, {4138, 4008}, {4389, 4063}, {4370, 4362}, {4139, 
           4360}, {3997, 4263}, {4119, 4099}, {3903, 4156}, {3579, 4100}, {
           3193, 4132}, {2854, 4012}, {2695, 4041}, {2760, 4108}, {2648, 
           4077}, {2651, 3952}, {2391, 3937}, {2430, 3872}, {2211, 3911}, {
           2252, 3829}, {2120, 3860}, {2085, 3873}, {2050, 3972}, {1913, 
           4030}, {2278, 3965}, {2482, 4032}, {1847, 4187}, {1851, 4188}, {
           1741, 4142}, {1895, 3775}, {1671, 3634}, {1815, 3598}, {1682, 
           3569}, {1656, 3469}, {1686, 3361}, {1799, 3350}, {1903, 3222}, {
           1898, 3124}, {2033, 3101}, {2374, 2971}, {2396, 2867}, {2296, 
           2827}, {2363, 2827}, {2264, 2800}, {2314, 2762}, {2195, 2711}, {
           2400, 2603}, {2637, 2563}, {2778, 2509}, {2871, 2473}, {2915, 
           2510}, {2801, 2671}, {2953, 2782}, {2811, 2965}, {3064, 3097}, {
           3247, 3067}, {3653, 3047}, {3695, 3246}, {4238, 3308}, {4471, 
           3227}, {4638, 3262}, {4768, 3086}, {5012, 3027}, {5240, 2946}, {
           5271, 2950}, {5543, 3052}, {5840, 2984}, {5936, 3129}, {6199, 
           3012}, {6513, 2960}, {7003, 2990}, {7154, 3001}, {7202, 3166}, {
           7322, 3205}, {7537, 3183}, {7652, 2988}, {7840, 2932}, {7859, 
           2862}, {8084, 2896}, {7987, 2707}, {7857, 2690}, {7836, 2545}, {
           7842, 2537}, {7842, 2537}, {7842, 2537}, {7909, 2600}, {8108, 
           2610}, {8411, 2907}, {8485, 3197}, {8385, 3259}, {8239, 3212}, {
           8264, 3259}, {8113, 3296}, {8555, 3554}, {8977, 3586}, {9174, 
           3534}, {9311, 3550}, {9254, 3593}, {9449, 3708}, {9622, 3706}, {
           9608, 3635}, {9686, 3668}, {9796, 3753}, {9939, 3747}, {9357, 
           3400}, {9399, 3053}, {9727, 3286}, {9801, 3372}, {9716, 3484}, {
           9818, 3602}, {10153, 3637}, {10215, 3595}, {10619, 3772}, {10746, 
           3737}, {10691, 3867}, {10466, 3881}, {10769, 3889}, {
           10800, Rational[105995, 27]}, {10800, Rational[105995, 27]}, {
           10800, Rational[105995, 27]}, {10800, Rational[2323143, 566]}}, {{
           10800, 4104.49293286219}, {10567, 4193}, {10233, 4188}, {10237, 
           4125}, {9746, 4180}, {9663, 4112}, {9555, 4249}, {9152, 4247}, {
           8896, 4339}, {8693, 4300}, {8816, 4339}, {8811, 4341}, {8439, 
           4374}, {8402, 4288}, {7861, 4244}, {7118, 4414}, {6809, 4410}, {
           6817, 4357}, {6678, 4432}, {6304, 4367}, {6823, 4524}, {6666, 
           4605}, {6244, 4664}, {6135, 4583}, {5929, 4590}, {6011, 4510}, {
           5928, 4576}, {5152, 4483}, {5207, 4379}, {5207, 4434}, {4831, 
           4414}, {4990, 4205}, {4996, 4303}, {4711, 4344}, {4575, 4295}, {
           4707, 4253}, {4530, 4294}, {4500, 4373}, {4450, 4225}, {4428, 
           4148}, {4658, 4134}, {4743, 4054}, {4593, 4139}, {4320, 3973}, {
           4138, 4008}, {4389, 4063}, {4370, 4362}, {4139, 4360}, {3997, 
           4263}, {4119, 4099}, {3903, 4156}, {3579, 4100}, {3193, 4132}, {
           2854, 4012}, {2695, 4041}, {2760, 4108}, {2648, 4077}, {2651, 
           3952}, {2391, 3937}, {2430, 3872}, {2211, 3911}, {2252, 3829}, {
           2120, 3860}, {2085, 3873}, {2050, 3972}, {1913, 4030}, {2278, 
           3965}, {2482, 4032}, {1847, 4187}, {1851, 4188}, {1741, 4142}, {
           1895, 3775}, {1671, 3634}, {1815, 3598}, {1682, 3569}, {1656, 
           3469}, {1686, 3361}, {1799, 3350}, {1903, 3222}, {1898, 3124}, {
           2033, 3101}, {2374, 2971}, {2396, 2867}, {2296, 2827}, {2363, 
           2827}, {2264, 2800}, {2314, 2762}, {2195, 2711}, {2400, 2603}, {
           2637, 2563}, {2778, 2509}, {2871, 2473}, {2915, 2510}, {2801, 
           2671}, {2953, 2782}, {2811, 2965}, {3064, 3097}, {3247, 3067}, {
           3653, 3047}, {3695, 3246}, {4238, 3308}, {4471, 3227}, {4638, 
           3262}, {4768, 3086}, {5012, 3027}, {5240, 2946}, {5271, 2950}, {
           5543, 3052}, {5840, 2984}, {5936, 3129}, {6199, 3012}, {6513, 
           2960}, {7003, 2990}, {7154, 3001}, {7202, 3166}, {7322, 3205}, {
           7537, 3183}, {7652, 2988}, {7840, 2932}, {7859, 2862}, {8084, 
           2896}, {7987, 2707}, {7857, 2690}, {7836, 2545}, {7842, 2537}, {
           7842, 2537}, {7842, 2537}, {7909, 2600}, {8108, 2610}, {8411, 
           2907}, {8485, 3197}, {8385, 3259}, {8239, 3212}, {8264, 3259}, {
           8113, 3296}, {8555, 3554}, {8977, 3586}, {9174, 3534}, {9311, 
           3550}, {9254, 3593}, {9449, 3708}, {9622, 3706}, {9608, 3635}, {
           9686, 3668}, {9796, 3753}, {9939, 3747}, {9357, 3400}, {9399, 
           3053}, {9727, 3286}, {9801, 3372}, {9716, 3484}, {9818, 3602}, {
           10153, 3637}, {10215, 3595}, {10619, 3772}, {10746, 3737}, {10691, 
           3867}, {10466, 3881}, {10769, 3889}, {10800, 3925.74074074074}, {
           10800, 3925.74074074074}, {10800, 3925.74074074074}, {
           10800, 4104.49293286219}}]], 
        PolygonBox[
         NCache[{{-10800, Rational[105995, 27]}, {-10751, 3985}, {-10391, 
           3855}, {-10371, 3942}, {-10183, 3968}, {-10421, 4028}, {-10468, 
           3978}, {-10800, Rational[2323143, 566]}, {-10800, Rational[
            2323143, 566]}, {-10800, Rational[105995, 27]}, {-10800, Rational[
            105995, 27]}}, {{-10800, 3925.74074074074}, {-10751, 
           3985}, {-10391, 3855}, {-10371, 3942}, {-10183, 3968}, {-10421, 
           4028}, {-10468, 
           3978}, {-10800, 4104.49293286219}, {-10800, 
            4104.49293286219}, {-10800, 3925.74074074074}, {-10800, 
            3925.74074074074}}]]}, 
       PolygonBox[{{1277, 3320}, {1373, 3286}, {1369, 3242}, {1178, 3268}, {
        1275, 3297}, {1277, 3320}}], 
       PolygonBox[{{8510, 3189}, {8525, 2753}, {8617, 2782}, {8595, 2963}, {
        8685, 2918}, {8581, 3248}, {8510, 3189}}], 
       PolygonBox[{{9314, 3003}, {9364, 3047}, {9314, 3003}}], 
       PolygonBox[{{8469, 4433}, {8609, 4399}, {8470, 4433}}], 
       PolygonBox[{{8790, 4535}, {9057, 4508}, {8790, 4535}}], 
       PolygonBox[{{8390, 4488}, {8622, 4496}, {8724, 4531}, {8324, 4573}, {
        8215, 4516}, {8404, 4489}}], 
       PolygonBox[{{5968, 4677}, {6322, 4710}, {6142, 4766}, {5967, 4677}}], 
       PolygonBox[{{5968, 4755}, {5852, 4810}, {5571, 4773}, {5967, 4755}}], 
       PolygonBox[{{3084, 4307}, {3226, 4398}, {3394, 4390}, {3458, 4244}, {
        3084, 4308}}], 
       PolygonBox[{{3419, 4481}, {3243, 4402}, {4110, 4617}, {3418, 4481}}]},
      "\"Russia\""], 
     TooltipBox[
      {RGBColor[0.351633675921641, 0.816686694936837, 0.485175097556443], 
       PolygonBox[{{1776, -83}, {1741, -165}, {1834, -144}, {1829, -64}, {
        1776, -83}}]},
      "\"Rwanda\""], 
     TooltipBox[
      {RGBColor[0.417239383909921, 0.662883594308145, 0.526514298179329], 
       PolygonBox[{{744, 2635}, {744, 2635}}]},
      "\"San Marino\""], 
     TooltipBox[
      {RGBColor[0.137653142109531, 0.889595411122829, 0.438174745925123], 
       PolygonBox[{{2098, 1762}, {2074, 1685}, {2351, 1266}, {2567, 983}, {
        2670, 1044}, {2735, 906}, {3119, 1140}, {3400, 1320}, {3350, 1390}, {
        3290, 1360}, {3070, 1430}, {3073, 1477}, {3050, 1485}, {2905, 1713}, {
        2793, 1746}, {2683, 1752}, {2358, 1934}, {2220, 1890}, {2250, 1800}, {
        2098, 1762}}]},
      "\"Saudi Arabia\""], 
     TooltipBox[
      {RGBColor[0.400164403375204, 0.775284198383988, 0.613072185247285], 
       PolygonBox[{{-992, 964}, {-1052, 885}, {-994, 815}, {-828, 
        803}, {-1005, 784}, {-923, 770}, {-1003, 739}, {-823, 761}, {-681, 
        748}, {-735, 886}, {-723, 883}, {-803, 962}, {-992, 963}}]},
      "\"Senegal\""], 
     TooltipBox[
      {RGBColor[0.580733120156084, 0.193385852545364, 0.783973999142282], 
       PolygonBox[{{1119, 2542}, {1118, 2550}, {1128, 2693}, {1131, 2755}, {
        1216, 2767}, {1361, 2653}, {1371, 2534}, {1274, 2533}, {1232, 2506}, {
        1210, 2551}, {1162, 2511}, {1119, 2542}}]},
      "\"Serbia and Montenegro\""], 
     TooltipBox[
      {RGBColor[0.519367211556564, 0.326706792787689, 0.94514077345756], 
       PolygonBox[{{-798, 542}, {-689, 416}, {-615, 509}, {-673, 600}, {-798, 
        542}}]},
      "\"Sierra Leone\""], 
     TooltipBox[
      {RGBColor[0.0659648784020378, 0.362709238501621, 0.909138967080359], 
       PolygonBox[{{6239, 83}, {6239, 83}}]},
      "\"Singapore\""], 
     TooltipBox[
      {RGBColor[0.928808797608955, 0.824531223398767, 0.65423062317214], 
       PolygonBox[{{1353, 2945}, {1147, 2993}, {1066, 2965}, {991, 2890}, {
        1030, 2881}, {1329, 2905}, {1353, 2945}}]},
      "\"Slovakia\""], 
     TooltipBox[
      {RGBColor[0.557505291158718, 0.112122102672118, 0.339356125842324], 
       PolygonBox[{{839, 2730}, {823, 2736}, {823, 2792}, {967, 2812}, {992, 
        2796}, {943, 2748}, {839, 2730}}]},
      "\"Slovenia\""], 
     TooltipBox[
      {RGBColor[0.236991239262219, 0.894621696850573, 0.585607804492788], 
       PolygonBox[{{2493, -100}, {2877, 268}, {3085, 627}, {3047, 720}, {2695,
         625}, {2597, 691}, {2595, 689}, {2577, 660}, {2641, 540}, {2879, 
        480}, {2697, 294}, {2514, 239}, {2459, 170}, {2493, -100}}]},
      "\"Somalia\""], 
     TooltipBox[
      {RGBColor[0.201702983732793, 0.34739582813939, 0.45644695092545], 
       PolygonBox[{{989, -1715}, {1099, -2050}, {1200, -2089}, {
        1674, -1982}, {1974, -1611}, {1928, -1610}, {1849, -1608}, {
        1918, -1558}, {1878, -1345}, {1762, -1331}, {1531, -1540}, {
        1368, -1539}, {1239, -1610}, {1200, -1486}, {1200, -1706}, {
        989, -1715}}]},
      "\"South Africa\""], 
     TooltipBox[
      {RGBColor[0.185443401117584, 0.426418785348805, 0.734323642892105], 
       PolygonBox[{{1722, -1717}, {1621, -1778}, {1686, -1840}, {
        1767, -1761}, {1722, -1717}}]},
      "\"Lesotho\""], 
     TooltipBox[
      {RGBColor[0.875713830769366, 0.99205754857222, 0.642444786206523], 
       PolygonBox[{{7602, 2270}, {7591, 2057}, {7766, 2129}, {7702, 2317}, {
        7602, 2270}}]},
      "\"South Korea\""], 
     TooltipBox[
      {RGBColor[0.214956431335541, 0.549007037981676, 0.0469167751146601], 
       PolygonBox[{{193, 2546}, {0, 2397}, {-7, 2336}, {0, 2317}, {-128, 
        2204}, {-322, 2169}, {-445, 2231}, {-371, 2495}, {-525, 2518}, {-557, 
        2584}, {-474, 2627}, {-106, 2604}, {89, 2556}, {105, 2550}, {193, 
        2546}}]},
      "\"Spain\""], 
     TooltipBox[
      {RGBColor[0.576479907804486, 0.85224719283392, 0.639868070901318], 
       PolygonBox[{{4788, 456}, {4828, 356}, {4913, 437}, {4795, 586}, {4837, 
        567}, {4788, 456}}]},
      "\"Sri Lanka\""], 
     TooltipBox[
      {RGBColor[0.118107977505705, 0.751948684405719, 0.19801656966178], 
       PolygonBox[{{2317, 1082}, {2214, 1322}, {2137, 1388}, {2036, 1305}, {
        1500, 1320}, {1500, 1200}, {1440, 1170}, {1440, 942}, {1376, 933}, {
        1310, 768}, {1366, 657}, {1373, 655}, {1411, 523}, {1647, 301}, {1852,
         209}, {2040, 253}, {2156, 277}, {1979, 476}, {2057, 633}, {2169, 
        762}, {2220, 1024}, {2317, 1082}}]},
      "\"Sudan\""], 
     TooltipBox[
      {RGBColor[0.0823627797425996, 0.00598587483358746, 0.412592558563395], 
       PolygonBox[{{-3250, 321}, {-3435, 329}, {-3483, 240}, {-3388, 
        117}, {-3276, 140}, {-3250, 321}}]},
      "\"Suriname\""], 
     TooltipBox[
      {RGBColor[0.961025330399562, 0.187741082892027, 0.420378070340799], 
       PolygonBox[{{1928, -1610}, {1918, -1557}, {1849, -1608}, {
        1928, -1610}}]},
      "\"Swaziland\""], 
     TooltipBox[
      {RGBColor[0.210889574830602, 0.613629502260172, 0.731294131966577], 
       PolygonBox[{{686, 3539}, {798, 3320}, {951, 3365}, {971, 3518}, {1105, 
        3548}, {961, 3570}, {1145, 3584}, {1040, 3749}, {1450, 3949}, {1236, 
        4143}, {728, 3815}, {686, 3539}}]},
      "\"Sweden\""], 
     TooltipBox[
      {RGBColor[0.234934669223215, 0.784470789481797, 0.879305859368067], 
       PolygonBox[{{422, 2756}, {628, 2813}, {576, 2824}, {572, 2837}, {574, 
        2852}, {455, 2855}, {358, 2773}, {422, 2756}}]},
      "\"Switzerland\""], 
     TooltipBox[
      {RGBColor[0.855580301197212, 0.242877120650994, 0.142026003275273], 
       PolygonBox[{{2155, 2156}, {2158, 2079}, {2140, 1995}, {2139, 1961}, {
        2328, 2003}, {2460, 2065}, {2541, 2227}, {2200, 2210}, {2155, 
        2156}}]},
      "\"Syria\""], 
     TooltipBox[
      {RGBColor[0.664349428032526, 0.306573263215535, 0.195960345536334], 
       PolygonBox[{{7277, 1507}, {7320, 1500}, {7243, 1316}, {7207, 1417}, {
        7277, 1507}}]},
      "\"Taiwan\""], 
     TooltipBox[
      {RGBColor[0.565546095470788, 0.812102235198607, 0.666705192314218], 
       PolygonBox[{{4066, 2232}, {4093, 2282}, {4055, 2369}, {4175, 2438}, {
        4174, 2396}, {4291, 2354}, {4450, 2372}, {4494, 2234}, {4301, 2201}, {
        4257, 2308}, {4066, 2232}}]},
      "\"Tajikistan\""], 
     TooltipBox[
      {RGBColor[0.0778523680306292, 0.813597411065069, 0.614085665536827], 
       PolygonBox[{{2426, -629}, {2327, -363}, {2352, -280}, {2035, -60}, {
        1829, -64}, {1834, -144}, {1765, -267}, {1846, -491}, {1979, -565}, {
        2060, -584}, {2098, -694}, {2426, -629}}]},
      "\"Tanzania\""], 
     TooltipBox[
      {RGBColor[0.584342412571618, 0.0718664931970417, 0.401004852501674], 
       PolygonBox[{{6175, 698}, {6052, 759}, {6016, 811}, {5949, 622}, {6025, 
        430}, {6126, 374}, {6069, 338}, {6008, 385}, {5897, 493}, {5925, 
        621}, {5980, 710}, {5891, 906}, {5936, 983}, {5841, 1113}, {6005, 
        1221}, {6077, 1174}, {6055, 1054}, {6204, 1106}, {6283, 1050}, {6313, 
        861}, {6140, 813}, {6175, 698}}]},
      "\"Thailand\""], 
     TooltipBox[
      {RGBColor[0.653060335137265, 0.396601329679591, 0.651488422856243], 
       PolygonBox[{{72, 366}, {99, 373}, {55, 660}, {-10, 668}, {0, 666}, {-5,
         642}, {0, 636}, {72, 366}}]},
      "\"Togo\""], 
     TooltipBox[
      {RGBColor[0.190115277671072, 0.0394308328770931, 0.665307197713014], 
       PolygonBox[{{517, 2216}, {663, 2225}, {600, 2050}, {692, 1990}, {572, 
        1814}, {450, 2033}, {517, 2216}}]},
      "\"Tunisia\""], 
     TooltipBox[
      {RGBColor[0.416553753633028, 0.405644488189275, 0.160124973509026], 
       PolygonBox[{{2155, 2156}, {2161, 2216}, {1968, 2161}, {1781, 2167}, {
        1642, 2201}, {1700, 2222}, {1574, 2296}, {1630, 2307}, {1569, 2397}, {
        1777, 2471}, {2097, 2526}, {2492, 2491}, {2689, 2378}, {2688, 2230}, {
        2541, 2226}, {2200, 2210}, {2155, 2156}}], 
       PolygonBox[{{1562, 2444}, {1571, 2403}, {1739, 2460}, {1681, 2519}, {
        1581, 2503}, {1562, 2444}}]},
      "\"Turkey\""], 
     TooltipBox[
      {RGBColor[0.809726896515802, 0.173676632982034, 0.263618484914002], 
       PolygonBox[{{3170, 2502}, {3286, 2462}, {3163, 2427}, {3234, 2241}, {
        3432, 2297}, {3574, 2233}, {3677, 2136}, {3844, 2160}, {3947, 2254}, {
        3814, 2346}, {3622, 2484}, {3520, 2570}, {3360, 2490}, {3170, 
        2502}}]},
      "\"Turkmenistan\""], 
     TooltipBox[
      {RGBColor[0.4957755454765, 0.503153633300267, 0.977716287445699], 
       PolygonBox[{{3073, 1477}, {3247, 1448}, {3382, 1583}, {3396, 1470}, {
        3350, 1390}, {3290, 1360}, {3070, 1430}, {3073, 1477}}]},
      "\"UAE\""], 
     TooltipBox[
      {RGBColor[0.698072389443214, 0.683673310277893, 0.836448440986049], 
       PolygonBox[{{-300, 3518}, {-181, 3518}, {-255, 3450}, {-109, 
        3456}, {-221, 3361}, {0, 3226}, {8, 3215}, {0, 3212}, {106, 3149}, {
        23, 3087}, {14, 3044}, {-295, 3035}, {-143, 3105}, {-258, 
        3100}, {-283, 3171}, {-164, 3200}, {-181, 3299}, {-308, 3291}, {-296, 
        3376}, {-349, 3318}, {-300, 3518}}], 
       PolygonBox[{{-435, 3304}, {-375, 3245}, {-376, 3246}, {-489, 
        3266}, {-435, 3304}}]},
      "\"United Kingdom\""], 
     TooltipBox[
      {RGBColor[0.89986391941507, 0.884474978378145, 0.0695876447410663], 
       PolygonBox[{{-7027, 1952}, {-7037, 1980}, {-7237, 2074}, {-7349, 
        2251}, {-7285, 2281}, {-7422, 2336}, {-7451, 2520}, {-7444, 
        2777}, {-7483, 2904}, {-7365, 2890}, {-7384, 2827}, {-7365, 
        2939}, {-7364, 2940}, {-7022, 2940}, {-6962, 2940}, {-6240, 
        2940}, {-5832, 2940}, {-5375, 2880}, {-5048, 2792}, {-4945, 
        2581}, {-4959, 2553}, {-4962, 2501}, {-4735, 2575}, {-4744, 
        2586}, {-4744, 2596}, {-4548, 2669}, {-4401, 2701}, {-4290, 
        2701}, {-4265, 2718}, {-4154, 2848}, {-4032, 2711}, {-4245, 
        2584}, {-4249, 2572}, {-4267, 2491}, {-4268, 2490}, {-4267, 
        2491}, {-4311, 2479}, {-4419, 2460}, {-4455, 2431}, {-4491, 
        2337}, {-4502, 2400}, {-4526, 2388}, {-4502, 2307}, {-4522, 
        2281}, {-4557, 2228}, {-4539, 2278}, {-4574, 2311}, {-4550, 
        2375}, {-4579, 2283}, {-4621, 2328}, {-4624, 2334}, {-4628, 
        2290}, {-4576, 2225}, {-4637, 2239}, {-4551, 2193}, {-4531, 
        2147}, {-4556, 2203}, {-4604, 2157}, {-4545, 2137}, {-4623, 
        2132}, {-4580, 2093}, {-4712, 2031}, {-4853, 1921}, {-4890, 
        1843}, {-4802, 1607}, {-4825, 1515}, {-4865, 1507}, {-4970, 
        1675}, {-4960, 1720}, {-5021, 1795}, {-5040, 1806}, {-5119, 
        1780}, {-5200, 1824}, {-5251, 1817}, {-5304, 1823}, {-5371, 
        1811}, {-5362, 1803}, {-5352, 1755}, {-5452, 1746}, {-5630, 
        1782}, {-5851, 1672}, {-5828, 1558}, {-5945, 1584}, {-6050, 
        1757}, {-6243, 1760}, {-6391, 1907}, {-6543, 1880}, {-6883, 
        1963}, {-7027, 1952}}], 
       PolygonBox[{{-7800, 3355}, {-7841, 3286}, {-7861, 3366}, {-7936, 
        3345}, {-8120, 3568}, {-8109, 3492}, {-8370, 3603}, {-8863, 
        3677}, {-8979, 3591}, {-9119, 3557}, {-8955, 3690}, {-9207, 
        3523}, {-9506, 3360}, {-9800, 3288}, {-9444, 3450}, {-9407, 
        3549}, {-9609, 3533}, {-9730, 3519}, {-9713, 3642}, {-9820, 
        3588}, {-9813, 3654}, {-9901, 3687}, {-9972, 3695}, {-9865, 
        3793}, {-9669, 3811}, {-9659, 3896}, {-10088, 3939}, {-9857, 
        3996}, {-9708, 3959}, {-9749, 4017}, {-9614, 3984}, {-10010, 
        4101}, {-9704, 4212}, {-9388, 4284}, {-8461, 4179}, {-8460, 
        3618}, {-8128, 3588}, {-7801, 3355}}], 
       PolygonBox[{{-9349, 1216}, {-9288, 1172}, {-9340, 1135}, {-9349, 
        1216}}], 
       PolygonBox[{{-9196, 3480}, {-9140, 3446}, {-9288, 3441}, {-9196, 
        3480}}]},
      "\"USA\""], 
     TooltipBox[
      {RGBColor[0.252106028414431, 0.827997426218029, 0.483470125876471], 
       PolygonBox[{{1852, 209}, {1878, 127}, {1776, -83}, {1829, -64}, {
        2035, -60}, {2102, 115}, {2040, 253}, {1852, 209}}]},
      "\"Uganda\""], 
     TooltipBox[
      {RGBColor[0.416527309603801, 0.85550469873484, 0.176509003361786], 
       PolygonBox[{{1416, 3092}, {1640, 3095}, {1898, 3124}, {2033, 3101}, {
        2374, 2971}, {2396, 2867}, {2296, 2827}, {2222, 2812}, {2089, 2771}, {
        2182, 2702}, {2018, 2666}, {1949, 2724}, {2026, 2756}, {1908, 2777}, {
        1905, 2835}, {1780, 2713}, {1690, 2728}, {1778, 2811}, {1697, 2889}, {
        1600, 2895}, {1374, 2877}, {1329, 2905}, {1353, 2945}, {1416, 
        3092}}]},
      "\"Ukraine\""], 
     TooltipBox[
      {RGBColor[0.293354848205398, 0.377096476726708, 0.190197501021826], 
       PolygonBox[{{-3202, -2025}, {-3470, -2070}, {-3492, -1947}, {-3458, \
-1814}, {-3225, -1923}, {-3202, -2025}}]},
      "\"Uruguay\""], 
     TooltipBox[
      {RGBColor[0.759955249728758, 0.887710360016123, 0.216971503217682], 
       PolygonBox[{{3360, 2490}, {3360, 2700}, {3520, 2730}, {3730, 2610}, {
        4075, 2477}, {4170, 2480}, {4261, 2538}, {4274, 2467}, {4380, 2456}, {
        4174, 2396}, {4175, 2438}, {4055, 2369}, {4093, 2282}, {4066, 2232}, {
        3947, 2254}, {3814, 2346}, {3622, 2484}, {3520, 2570}, {3360, 
        2490}}]},
      "\"Uzbekistan\""], 
     TooltipBox[
      {RGBColor[0.380470604506024, 0.586278616746724, 0.624091875102121], 
       PolygonBox[{{-3599, 512}, {-3697, 514}, {-3651, 566}, {-3781, 
        606}, {-3711, 645}, {-3905, 602}, {-4098, 641}, {-4201, 732}, {-4188, 
        686}, {-4295, 648}, {-4298, 543}, {-4279, 711}, {-4403, 551}, {-4320, 
        421}, {-4047, 372}, {-4071, 167}, {-4012, 73}, {-3804, 129}, {-3888, 
        257}, {-3773, 214}, {-3691, 256}, {-3644, 312}, {-3683, 357}, {-3599, 
        512}}]},
      "\"Venezuela\""], 
     TooltipBox[
      {RGBColor[0.721195957741183, 0.877316971205757, 0.608562329301025], 
       PolygonBox[{{6267, 622}, {6291, 514}, {6349, 600}, {6393, 575}, {6555, 
        703}, {6537, 915}, {6395, 1054}, {6347, 1176}, {6479, 1293}, {6487, 
        1287}, {6331, 1391}, {6128, 1344}, {6190, 1251}, {6279, 1240}, {6233, 
        1158}, {6448, 965}, {6453, 882}, {6453, 741}, {6351, 700}, {6267, 
        622}}]},
      "\"Vietnam\""], 
     TooltipBox[
      {RGBColor[0.926019485658907, 0.0375226474632896, 0.0408685302197077], 
       PolygonBox[{{-791, 1660}, {-1023, 1246}, {-780, 1280}, {-786, 
        1374}, {-720, 1560}, {-520, 1560}, {-520, 1638}, {-520, 1660}, {-791, 
        1660}}]},
      "\"Western Sahara\""], 
     TooltipBox[
      {RGBColor[0.708698409885954, 0.0415445072807619, 0.967935002722223], 
       PolygonBox[{{2670, 1044}, {2567, 984}, {2613, 762}, {2922, 842}, {3185,
         998}, {3119, 1140}, {2735, 906}, {2670, 1044}}]},
      "\"Yemen\""], 
     TooltipBox[
      {RGBColor[0.788762501805277, 0.880700983667926, 0.558074381404291], 
       PolygonBox[{{1846, -491}, {1702, -556}, {1702, -693}, {1788, -729}, {
        1788, -807}, {1632, -694}, {1439, -652}, {1441, -780}, {1320, -780}, {
        1320, -970}, {1409, -1058}, {1516, -1068}, {1629, -1068}, {
        1825, -938}, {1993, -841}, {1979, -569}, {1979, -565}, {
        1846, -492}}]},
      "\"Zambia\""], 
     TooltipBox[
      {RGBColor[0.551407693118422, 0.933257803070437, 0.70419198030614], 
       PolygonBox[{{1878, -1345}, {1762, -1331}, {1516, -1068}, {
        1629, -1068}, {1825, -938}, {1979, -1003}, {1982, -1202}, {
        1878, -1345}}]},
      "\"Zimbabwe\""]}}, 
   {Thickness[0.001], 
    LineBox[{{10800, 5400}, {10800, 5400}, {10800, 5184}, {10800, 4968}, {
     10800, 4752}, {10800, 4536}, {10800, 4320}, {10800, 4104}, {10800, 
     3888}, {10800, 3672}, {10800, 3456}, {10800, 3240}, {10800, 3024}, {
     10800, 2808}, {10800, 2592}, {10800, 2376}, {10800, 2160}, {10800, 
     1944}, {10800, 1728}, {10800, 1512}, {10800, 1296}, {10800, 1080}, {
     10800, 864}, {10800, 648}, {10800, 432}, {10800, 216}, {10800, 0}, {
     10800, -216}, {10800, -432}, {10800, -648}, {10800, -864}, {
     10800, -1080}, {10800, -1296}, {10800, -1512}, {10800, -1728}, {
     10800, -1944}, {10800, -2160}, {10800, -2376}, {10800, -2592}, {
     10800, -2808}, {10800, -3024}, {10800, -3240}, {10800, -3456}, {
     10800, -3672}, {10800, -3888}, {10800, -4104}, {10800, -4320}, {
     10800, -4536}, {10800, -4752}, {10800, -4968}, {10800, -5184}, {
     10800, -5400}}], 
    LineBox[{{10800, -5400}, {10800, -5400}, {10584, -5400}, {10368, -5400}, {
     10152, -5400}, {9936, -5400}, {9720, -5400}, {9504, -5400}, {
     9288, -5400}, {9072, -5400}, {8856, -5400}, {8640, -5400}, {
     8424, -5400}, {8208, -5400}, {7992, -5400}, {7776, -5400}, {
     7560, -5400}, {7344, -5400}, {7128, -5400}, {6912, -5400}, {
     6696, -5400}, {6480, -5400}, {6264, -5400}, {6048, -5400}, {
     5832, -5400}, {5616, -5400}, {5400, -5400}, {5184, -5400}, {
     4968, -5400}, {4752, -5400}, {4536, -5400}, {4320, -5400}, {
     4104, -5400}, {3888, -5400}, {3672, -5400}, {3456, -5400}, {
     3240, -5400}, {3024, -5400}, {2808, -5400}, {2592, -5400}, {
     2376, -5400}, {2160, -5400}, {1944, -5400}, {1728, -5400}, {
     1512, -5400}, {1296, -5400}, {1080, -5400}, {864, -5400}, {648, -5400}, {
     432, -5400}, {216, -5400}, {
     0, -5400}, {-216, -5400}, {-432, -5400}, {-648, -5400}, {-864, -5400}, \
{-1080, -5400}, {-1296, -5400}, {-1512, -5400}, {-1728, -5400}, {-1944, \
-5400}, {-2160, -5400}, {-2376, -5400}, {-2592, -5400}, {-2808, -5400}, \
{-3024, -5400}, {-3240, -5400}, {-3456, -5400}, {-3672, -5400}, {-3888, \
-5400}, {-4104, -5400}, {-4320, -5400}, {-4536, -5400}, {-4752, -5400}, \
{-4968, -5400}, {-5184, -5400}, {-5400, -5400}, {-5616, -5400}, {-5832, \
-5400}, {-6048, -5400}, {-6264, -5400}, {-6480, -5400}, {-6696, -5400}, \
{-6912, -5400}, {-7128, -5400}, {-7344, -5400}, {-7560, -5400}, {-7776, \
-5400}, {-7992, -5400}, {-8208, -5400}, {-8424, -5400}, {-8640, -5400}, \
{-8856, -5400}, {-9072, -5400}, {-9288, -5400}, {-9504, -5400}, {-9720, \
-5400}, {-9936, -5400}, {-10152, -5400}, {-10368, -5400}, {-10584, -5400}, \
{-10800, -5400}}], 
    LineBox[{{-10800, -5400}, {-10800, -5184}, {-10800, -4968}, {-10800, \
-4752}, {-10800, -4536}, {-10800, -4320}, {-10800, -4104}, {-10800, -3888}, \
{-10800, -3672}, {-10800, -3456}, {-10800, -3240}, {-10800, -3024}, {-10800, \
-2808}, {-10800, -2592}, {-10800, -2376}, {-10800, -2160}, {-10800, -1944}, \
{-10800, -1728}, {-10800, -1512}, {-10800, -1296}, {-10800, -1080}, {-10800, \
-864}, {-10800, -648}, {-10800, -432}, {-10800, -216}, {-10800, 0}, {-10800, 
     216}, {-10800, 432}, {-10800, 648}, {-10800, 864}, {-10800, 
     1080}, {-10800, 1296}, {-10800, 1512}, {-10800, 1728}, {-10800, 
     1944}, {-10800, 2160}, {-10800, 2376}, {-10800, 2592}, {-10800, 
     2808}, {-10800, 3024}, {-10800, 3240}, {-10800, 3456}, {-10800, 
     3672}, {-10800, 3888}, {-10800, 4104}, {-10800, 4320}, {-10800, 
     4536}, {-10800, 4752}, {-10800, 4968}, {-10800, 5184}, {-10800, 
     5400}, {-10800, 5400}}], 
    LineBox[{{-10800, 5400}, {-10584, 5400}, {-10368, 5400}, {-10152, 
     5400}, {-9936, 5400}, {-9720, 5400}, {-9504, 5400}, {-9288, 
     5400}, {-9072, 5400}, {-8856, 5400}, {-8640, 5400}, {-8424, 
     5400}, {-8208, 5400}, {-7992, 5400}, {-7776, 5400}, {-7560, 
     5400}, {-7344, 5400}, {-7128, 5400}, {-6912, 5400}, {-6696, 
     5400}, {-6480, 5400}, {-6264, 5400}, {-6048, 5400}, {-5832, 
     5400}, {-5616, 5400}, {-5400, 5400}, {-5184, 5400}, {-4968, 
     5400}, {-4752, 5400}, {-4536, 5400}, {-4320, 5400}, {-4104, 
     5400}, {-3888, 5400}, {-3672, 5400}, {-3456, 5400}, {-3240, 
     5400}, {-3024, 5400}, {-2808, 5400}, {-2592, 5400}, {-2376, 
     5400}, {-2160, 5400}, {-1944, 5400}, {-1728, 5400}, {-1512, 
     5400}, {-1296, 5400}, {-1080, 5400}, {-864, 5400}, {-648, 5400}, {-432, 
     5400}, {-216, 5400}, {0, 5400}, {216, 5400}, {432, 5400}, {648, 5400}, {
     864, 5400}, {1080, 5400}, {1296, 5400}, {1512, 5400}, {1728, 5400}, {
     1944, 5400}, {2160, 5400}, {2376, 5400}, {2592, 5400}, {2808, 5400}, {
     3024, 5400}, {3240, 5400}, {3456, 5400}, {3672, 5400}, {3888, 5400}, {
     4104, 5400}, {4320, 5400}, {4536, 5400}, {4752, 5400}, {4968, 5400}, {
     5184, 5400}, {5400, 5400}, {5616, 5400}, {5832, 5400}, {6048, 5400}, {
     6264, 5400}, {6480, 5400}, {6696, 5400}, {6912, 5400}, {7128, 5400}, {
     7344, 5400}, {7560, 5400}, {7776, 5400}, {7992, 5400}, {8208, 5400}, {
     8424, 5400}, {8640, 5400}, {8856, 5400}, {9072, 5400}, {9288, 5400}, {
     9504, 5400}, {9720, 5400}, {9936, 5400}, {10152, 5400}, {10368, 5400}, {
     10584, 5400}, {10800, 5400}, {10800, 5400}}]}},
  AspectRatio->Automatic]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119348936]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WorldPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", "{", 
     StyleBox["countrylist", "TI"], ",", 
     StyleBox["colorfunc", "TI"], "}", "]"}], Cell[TextData[{
     "color the countries as specified by ",
     Cell[BoxData[
      StyleBox["colorfunc", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WorldPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldPlot"], "[", "{", 
     StyleBox["countrylist", "TI"], ",", 
     StyleBox["colorlist", "TI"], "}", "]"}], Cell[
    "color the countries using the list of color directives ", "TableText"]}
  }]], "DefinitionBox",
 CellID->15924],

Cell["Specifying the color gray level of maps. ", "Caption",
 CellID->19040],

Cell[TextData[{
 "When you make a map, you can specify the color of each country in several \
ways. The first is to give an explicit list of graphics directives such as ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
 " element in this list specifies the color of the map of the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
 " element in your list of country names. You can also specify the colors by \
defining your own color function. This color function must take names of \
countries as arguments and return a color directive. Perhaps the simplest way \
to create maps with colors is to specify the color function as ",
 Cell[BoxData[
  ButtonBox["RandomColors",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/RandomColors"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RandomGrays",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/RandomGrays"]], "InlineFormula"],
 ". These two functions use random numbers to assign a color or gray level to \
each country on your list. "
}], "Text",
 CellID->24388],

Cell["Here is a simple color function. ", "MathCaption",
 CellID->25938],

Cell[BoxData[
 RowBox[{
  RowBox[{"shadefunc", "[", "country_", "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{"country", ",", "\[IndentingNewLine]", "\"\<Canada\>\"", ",", 
    RowBox[{"GrayLevel", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
    "\"\<Mexico\>\"", ",", 
    RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "\[IndentingNewLine]", "_", 
    ",", 
    RowBox[{"GrayLevel", "[", ".6", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29228],

Cell["\<\
The color function causes Canada to be drawn black, Mexico dark gray, and \
other countries a lighter gray. \
\>", "MathCaption",
 CellID->26372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldPlot", "[", 
  RowBox[{"{", 
   RowBox[{"NorthAmerica", ",", "shadefunc"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3321],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Thickness[0.001], 
     LineBox[{{-9000, 0}, {-9000, 96}, {-9000, 192}, {-9000, 288}, {-9000, 
      384}, {-9000, 480}, {-9000, 576}, {-9000, 672}, {-9000, 768}, {-9000, 
      864}, {-9000, 960}, {-9000, 1056}, {-9000, 1152}, {-9000, 1248}, {-9000,
       1344}, {-9000, 1440}, {-9000, 1536}, {-9000, 1632}, {-9000, 
      1728}, {-9000, 1824}, {-9000, 1920}, {-9000, 2016}, {-9000, 
      2112}, {-9000, 2208}, {-9000, 2304}, {-9000, 2400}, {-9000, 
      2496}, {-9000, 2592}, {-9000, 2688}, {-9000, 2784}, {-9000, 
      2880}, {-9000, 2976}, {-9000, 3072}, {-9000, 3168}, {-9000, 
      3264}, {-9000, 3360}, {-9000, 3456}, {-9000, 3552}, {-9000, 
      3648}, {-9000, 3744}, {-9000, 3840}, {-9000, 3936}, {-9000, 
      4032}, {-9000, 4128}, {-9000, 4224}, {-9000, 4320}, {-9000, 
      4416}, {-9000, 4512}, {-9000, 4608}, {-9000, 4704}, {-9000, 
      4800}, {-9000, 4896}, {-9000, 4992}, {-9000, 5088}, {-9000, 
      5184}, {-9000, 5280}, {-9000, 5376}, {-9000, 5400}}], 
     LineBox[{{-7200, 0}, {-7200, 96}, {-7200, 192}, {-7200, 288}, {-7200, 
      384}, {-7200, 480}, {-7200, 576}, {-7200, 672}, {-7200, 768}, {-7200, 
      864}, {-7200, 960}, {-7200, 1056}, {-7200, 1152}, {-7200, 1248}, {-7200,
       1344}, {-7200, 1440}, {-7200, 1536}, {-7200, 1632}, {-7200, 
      1728}, {-7200, 1824}, {-7200, 1920}, {-7200, 2016}, {-7200, 
      2112}, {-7200, 2208}, {-7200, 2304}, {-7200, 2400}, {-7200, 
      2496}, {-7200, 2592}, {-7200, 2688}, {-7200, 2784}, {-7200, 
      2880}, {-7200, 2976}, {-7200, 3072}, {-7200, 3168}, {-7200, 
      3264}, {-7200, 3360}, {-7200, 3456}, {-7200, 3552}, {-7200, 
      3648}, {-7200, 3744}, {-7200, 3840}, {-7200, 3936}, {-7200, 
      4032}, {-7200, 4128}, {-7200, 4224}, {-7200, 4320}, {-7200, 
      4416}, {-7200, 4512}, {-7200, 4608}, {-7200, 4704}, {-7200, 
      4800}, {-7200, 4896}, {-7200, 4992}, {-7200, 5088}, {-7200, 
      5184}, {-7200, 5280}, {-7200, 5376}, {-7200, 5400}}], 
     LineBox[{{-5400, 0}, {-5400, 96}, {-5400, 192}, {-5400, 288}, {-5400, 
      384}, {-5400, 480}, {-5400, 576}, {-5400, 672}, {-5400, 768}, {-5400, 
      864}, {-5400, 960}, {-5400, 1056}, {-5400, 1152}, {-5400, 1248}, {-5400,
       1344}, {-5400, 1440}, {-5400, 1536}, {-5400, 1632}, {-5400, 
      1728}, {-5400, 1824}, {-5400, 1920}, {-5400, 2016}, {-5400, 
      2112}, {-5400, 2208}, {-5400, 2304}, {-5400, 2400}, {-5400, 
      2496}, {-5400, 2592}, {-5400, 2688}, {-5400, 2784}, {-5400, 
      2880}, {-5400, 2976}, {-5400, 3072}, {-5400, 3168}, {-5400, 
      3264}, {-5400, 3360}, {-5400, 3456}, {-5400, 3552}, {-5400, 
      3648}, {-5400, 3744}, {-5400, 3840}, {-5400, 3936}, {-5400, 
      4032}, {-5400, 4128}, {-5400, 4224}, {-5400, 4320}, {-5400, 
      4416}, {-5400, 4512}, {-5400, 4608}, {-5400, 4704}, {-5400, 
      4800}, {-5400, 4896}, {-5400, 4992}, {-5400, 5088}, {-5400, 
      5184}, {-5400, 5280}, {-5400, 5376}, {-5400, 5400}}], 
     LineBox[{{-3600, 0}, {-3600, 96}, {-3600, 192}, {-3600, 288}, {-3600, 
      384}, {-3600, 480}, {-3600, 576}, {-3600, 672}, {-3600, 768}, {-3600, 
      864}, {-3600, 960}, {-3600, 1056}, {-3600, 1152}, {-3600, 1248}, {-3600,
       1344}, {-3600, 1440}, {-3600, 1536}, {-3600, 1632}, {-3600, 
      1728}, {-3600, 1824}, {-3600, 1920}, {-3600, 2016}, {-3600, 
      2112}, {-3600, 2208}, {-3600, 2304}, {-3600, 2400}, {-3600, 
      2496}, {-3600, 2592}, {-3600, 2688}, {-3600, 2784}, {-3600, 
      2880}, {-3600, 2976}, {-3600, 3072}, {-3600, 3168}, {-3600, 
      3264}, {-3600, 3360}, {-3600, 3456}, {-3600, 3552}, {-3600, 
      3648}, {-3600, 3744}, {-3600, 3840}, {-3600, 3936}, {-3600, 
      4032}, {-3600, 4128}, {-3600, 4224}, {-3600, 4320}, {-3600, 
      4416}, {-3600, 4512}, {-3600, 4608}, {-3600, 4704}, {-3600, 
      4800}, {-3600, 4896}, {-3600, 4992}, {-3600, 5088}, {-3600, 
      5184}, {-3600, 5280}, {-3600, 5376}, {-3600, 5400}}], 
     LineBox[{{-1800, 0}, {-1800, 96}, {-1800, 192}, {-1800, 288}, {-1800, 
      384}, {-1800, 480}, {-1800, 576}, {-1800, 672}, {-1800, 768}, {-1800, 
      864}, {-1800, 960}, {-1800, 1056}, {-1800, 1152}, {-1800, 1248}, {-1800,
       1344}, {-1800, 1440}, {-1800, 1536}, {-1800, 1632}, {-1800, 
      1728}, {-1800, 1824}, {-1800, 1920}, {-1800, 2016}, {-1800, 
      2112}, {-1800, 2208}, {-1800, 2304}, {-1800, 2400}, {-1800, 
      2496}, {-1800, 2592}, {-1800, 2688}, {-1800, 2784}, {-1800, 
      2880}, {-1800, 2976}, {-1800, 3072}, {-1800, 3168}, {-1800, 
      3264}, {-1800, 3360}, {-1800, 3456}, {-1800, 3552}, {-1800, 
      3648}, {-1800, 3744}, {-1800, 3840}, {-1800, 3936}, {-1800, 
      4032}, {-1800, 4128}, {-1800, 4224}, {-1800, 4320}, {-1800, 
      4416}, {-1800, 4512}, {-1800, 4608}, {-1800, 4704}, {-1800, 
      4800}, {-1800, 4896}, {-1800, 4992}, {-1800, 5088}, {-1800, 
      5184}, {-1800, 5280}, {-1800, 5376}, {-1800, 5400}}], 
     LineBox[{{-10200, 0}, {-10104, 0}, {-10008, 0}, {-9912, 0}, {-9816, 
      0}, {-9720, 0}, {-9624, 0}, {-9528, 0}, {-9432, 0}, {-9336, 0}, {-9240, 
      0}, {-9144, 0}, {-9048, 0}, {-8952, 0}, {-8856, 0}, {-8760, 0}, {-8664, 
      0}, {-8568, 0}, {-8472, 0}, {-8376, 0}, {-8280, 0}, {-8184, 0}, {-8088, 
      0}, {-7992, 0}, {-7896, 0}, {-7800, 0}, {-7704, 0}, {-7608, 0}, {-7512, 
      0}, {-7416, 0}, {-7320, 0}, {-7224, 0}, {-7128, 0}, {-7032, 0}, {-6936, 
      0}, {-6840, 0}, {-6744, 0}, {-6648, 0}, {-6552, 0}, {-6456, 0}, {-6360, 
      0}, {-6264, 0}, {-6168, 0}, {-6072, 0}, {-5976, 0}, {-5880, 0}, {-5784, 
      0}, {-5688, 0}, {-5592, 0}, {-5496, 0}, {-5400, 0}, {-5304, 0}, {-5208, 
      0}, {-5112, 0}, {-5016, 0}, {-4920, 0}, {-4824, 0}, {-4728, 0}, {-4632, 
      0}, {-4536, 0}, {-4440, 0}, {-4344, 0}, {-4248, 0}, {-4152, 0}, {-4056, 
      0}, {-3960, 0}, {-3864, 0}, {-3768, 0}, {-3672, 0}, {-3576, 0}, {-3480, 
      0}, {-3384, 0}, {-3288, 0}, {-3192, 0}, {-3096, 0}, {-3000, 0}, {-2904, 
      0}, {-2808, 0}, {-2712, 0}, {-2616, 0}, {-2520, 0}, {-2424, 0}, {-2328, 
      0}, {-2232, 0}, {-2136, 0}, {-2040, 0}, {-1944, 0}, {-1848, 0}, {-1752, 
      0}, {-1656, 0}, {-1560, 0}, {-1464, 0}, {-1368, 0}, {-1272, 0}, {-1176, 
      0}, {-1080, 0}, {-984, 0}, {-888, 0}, {-792, 0}, {-696, 0}, {-600, 
      0}, {-600, 0}}], 
     LineBox[{{-10200, 1800}, {-10104, 1800}, {-10008, 1800}, {-9912, 
      1800}, {-9816, 1800}, {-9720, 1800}, {-9624, 1800}, {-9528, 
      1800}, {-9432, 1800}, {-9336, 1800}, {-9240, 1800}, {-9144, 
      1800}, {-9048, 1800}, {-8952, 1800}, {-8856, 1800}, {-8760, 
      1800}, {-8664, 1800}, {-8568, 1800}, {-8472, 1800}, {-8376, 
      1800}, {-8280, 1800}, {-8184, 1800}, {-8088, 1800}, {-7992, 
      1800}, {-7896, 1800}, {-7800, 1800}, {-7704, 1800}, {-7608, 
      1800}, {-7512, 1800}, {-7416, 1800}, {-7320, 1800}, {-7224, 
      1800}, {-7128, 1800}, {-7032, 1800}, {-6936, 1800}, {-6840, 
      1800}, {-6744, 1800}, {-6648, 1800}, {-6552, 1800}, {-6456, 
      1800}, {-6360, 1800}, {-6264, 1800}, {-6168, 1800}, {-6072, 
      1800}, {-5976, 1800}, {-5880, 1800}, {-5784, 1800}, {-5688, 
      1800}, {-5592, 1800}, {-5496, 1800}, {-5400, 1800}, {-5304, 
      1800}, {-5208, 1800}, {-5112, 1800}, {-5016, 1800}, {-4920, 
      1800}, {-4824, 1800}, {-4728, 1800}, {-4632, 1800}, {-4536, 
      1800}, {-4440, 1800}, {-4344, 1800}, {-4248, 1800}, {-4152, 
      1800}, {-4056, 1800}, {-3960, 1800}, {-3864, 1800}, {-3768, 
      1800}, {-3672, 1800}, {-3576, 1800}, {-3480, 1800}, {-3384, 
      1800}, {-3288, 1800}, {-3192, 1800}, {-3096, 1800}, {-3000, 
      1800}, {-2904, 1800}, {-2808, 1800}, {-2712, 1800}, {-2616, 
      1800}, {-2520, 1800}, {-2424, 1800}, {-2328, 1800}, {-2232, 
      1800}, {-2136, 1800}, {-2040, 1800}, {-1944, 1800}, {-1848, 
      1800}, {-1752, 1800}, {-1656, 1800}, {-1560, 1800}, {-1464, 
      1800}, {-1368, 1800}, {-1272, 1800}, {-1176, 1800}, {-1080, 
      1800}, {-984, 1800}, {-888, 1800}, {-792, 1800}, {-696, 1800}, {-600, 
      1800}, {-600, 1800}}], 
     LineBox[{{-10200, 3600}, {-10104, 3600}, {-10008, 3600}, {-9912, 
      3600}, {-9816, 3600}, {-9720, 3600}, {-9624, 3600}, {-9528, 
      3600}, {-9432, 3600}, {-9336, 3600}, {-9240, 3600}, {-9144, 
      3600}, {-9048, 3600}, {-8952, 3600}, {-8856, 3600}, {-8760, 
      3600}, {-8664, 3600}, {-8568, 3600}, {-8472, 3600}, {-8376, 
      3600}, {-8280, 3600}, {-8184, 3600}, {-8088, 3600}, {-7992, 
      3600}, {-7896, 3600}, {-7800, 3600}, {-7704, 3600}, {-7608, 
      3600}, {-7512, 3600}, {-7416, 3600}, {-7320, 3600}, {-7224, 
      3600}, {-7128, 3600}, {-7032, 3600}, {-6936, 3600}, {-6840, 
      3600}, {-6744, 3600}, {-6648, 3600}, {-6552, 3600}, {-6456, 
      3600}, {-6360, 3600}, {-6264, 3600}, {-6168, 3600}, {-6072, 
      3600}, {-5976, 3600}, {-5880, 3600}, {-5784, 3600}, {-5688, 
      3600}, {-5592, 3600}, {-5496, 3600}, {-5400, 3600}, {-5304, 
      3600}, {-5208, 3600}, {-5112, 3600}, {-5016, 3600}, {-4920, 
      3600}, {-4824, 3600}, {-4728, 3600}, {-4632, 3600}, {-4536, 
      3600}, {-4440, 3600}, {-4344, 3600}, {-4248, 3600}, {-4152, 
      3600}, {-4056, 3600}, {-3960, 3600}, {-3864, 3600}, {-3768, 
      3600}, {-3672, 3600}, {-3576, 3600}, {-3480, 3600}, {-3384, 
      3600}, {-3288, 3600}, {-3192, 3600}, {-3096, 3600}, {-3000, 
      3600}, {-2904, 3600}, {-2808, 3600}, {-2712, 3600}, {-2616, 
      3600}, {-2520, 3600}, {-2424, 3600}, {-2328, 3600}, {-2232, 
      3600}, {-2136, 3600}, {-2040, 3600}, {-1944, 3600}, {-1848, 
      3600}, {-1752, 3600}, {-1656, 3600}, {-1560, 3600}, {-1464, 
      3600}, {-1368, 3600}, {-1272, 3600}, {-1176, 3600}, {-1080, 
      3600}, {-984, 3600}, {-888, 3600}, {-792, 3600}, {-696, 3600}, {-600, 
      3600}, {-600, 3600}}], 
     LineBox[{{-10200, 5400}, {-10104, 5400}, {-10008, 5400}, {-9912, 
      5400}, {-9816, 5400}, {-9720, 5400}, {-9624, 5400}, {-9528, 
      5400}, {-9432, 5400}, {-9336, 5400}, {-9240, 5400}, {-9144, 
      5400}, {-9048, 5400}, {-8952, 5400}, {-8856, 5400}, {-8760, 
      5400}, {-8664, 5400}, {-8568, 5400}, {-8472, 5400}, {-8376, 
      5400}, {-8280, 5400}, {-8184, 5400}, {-8088, 5400}, {-7992, 
      5400}, {-7896, 5400}, {-7800, 5400}, {-7704, 5400}, {-7608, 
      5400}, {-7512, 5400}, {-7416, 5400}, {-7320, 5400}, {-7224, 
      5400}, {-7128, 5400}, {-7032, 5400}, {-6936, 5400}, {-6840, 
      5400}, {-6744, 5400}, {-6648, 5400}, {-6552, 5400}, {-6456, 
      5400}, {-6360, 5400}, {-6264, 5400}, {-6168, 5400}, {-6072, 
      5400}, {-5976, 5400}, {-5880, 5400}, {-5784, 5400}, {-5688, 
      5400}, {-5592, 5400}, {-5496, 5400}, {-5400, 5400}, {-5304, 
      5400}, {-5208, 5400}, {-5112, 5400}, {-5016, 5400}, {-4920, 
      5400}, {-4824, 5400}, {-4728, 5400}, {-4632, 5400}, {-4536, 
      5400}, {-4440, 5400}, {-4344, 5400}, {-4248, 5400}, {-4152, 
      5400}, {-4056, 5400}, {-3960, 5400}, {-3864, 5400}, {-3768, 
      5400}, {-3672, 5400}, {-3576, 5400}, {-3480, 5400}, {-3384, 
      5400}, {-3288, 5400}, {-3192, 5400}, {-3096, 5400}, {-3000, 
      5400}, {-2904, 5400}, {-2808, 5400}, {-2712, 5400}, {-2616, 
      5400}, {-2520, 5400}, {-2424, 5400}, {-2328, 5400}, {-2232, 
      5400}, {-2136, 5400}, {-2040, 5400}, {-1944, 5400}, {-1848, 
      5400}, {-1752, 5400}, {-1656, 5400}, {-1560, 5400}, {-1464, 
      5400}, {-1368, 5400}, {-1272, 5400}, {-1176, 5400}, {-1080, 
      5400}, {-984, 5400}, {-888, 5400}, {-792, 5400}, {-696, 5400}, {-600, 
      5400}, {-600, 5400}}]}, {
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-7027, 1952}, {-7037, 1980}, {-7237, 2074}, {-7349, 
        2251}, {-7285, 2281}, {-7422, 2336}, {-7451, 2520}, {-7444, 
        2777}, {-7483, 2904}, {-7365, 2890}, {-7384, 2827}, {-7365, 
        2939}, {-7364, 2940}, {-7022, 2940}, {-6962, 2940}, {-6240, 
        2940}, {-5832, 2940}, {-5375, 2880}, {-5048, 2792}, {-4945, 
        2581}, {-4959, 2553}, {-4962, 2501}, {-4735, 2575}, {-4744, 
        2586}, {-4744, 2596}, {-4548, 2669}, {-4401, 2701}, {-4290, 
        2701}, {-4265, 2718}, {-4154, 2848}, {-4032, 2711}, {-4245, 
        2584}, {-4249, 2572}, {-4267, 2491}, {-4268, 2490}, {-4267, 
        2491}, {-4311, 2479}, {-4419, 2460}, {-4455, 2431}, {-4491, 
        2337}, {-4502, 2400}, {-4526, 2388}, {-4502, 2307}, {-4522, 
        2281}, {-4557, 2228}, {-4539, 2278}, {-4574, 2311}, {-4550, 
        2375}, {-4579, 2283}, {-4621, 2328}, {-4624, 2334}, {-4628, 
        2290}, {-4576, 2225}, {-4637, 2239}, {-4551, 2193}, {-4531, 
        2147}, {-4556, 2203}, {-4604, 2157}, {-4545, 2137}, {-4623, 
        2132}, {-4580, 2093}, {-4712, 2031}, {-4853, 1921}, {-4890, 
        1843}, {-4802, 1607}, {-4825, 1515}, {-4865, 1507}, {-4970, 
        1675}, {-4960, 1720}, {-5021, 1795}, {-5040, 1806}, {-5119, 
        1780}, {-5200, 1824}, {-5251, 1817}, {-5304, 1823}, {-5371, 
        1811}, {-5362, 1803}, {-5352, 1755}, {-5452, 1746}, {-5630, 
        1782}, {-5851, 1672}, {-5828, 1558}, {-5945, 1584}, {-6050, 
        1757}, {-6243, 1760}, {-6391, 1907}, {-6543, 1880}, {-6883, 
        1963}, {-7027, 1952}}], 
       PolygonBox[{{-7800, 3355}, {-7841, 3286}, {-7861, 3366}, {-7936, 
        3345}, {-8120, 3568}, {-8109, 3492}, {-8370, 3603}, {-8863, 
        3677}, {-8979, 3591}, {-9119, 3557}, {-8955, 3690}, {-9207, 
        3523}, {-9506, 3360}, {-9800, 3288}, {-9444, 3450}, {-9407, 
        3549}, {-9609, 3533}, {-9730, 3519}, {-9713, 3642}, {-9820, 
        3588}, {-9813, 3654}, {-9901, 3687}, {-9972, 3695}, {-9865, 
        3793}, {-9669, 3811}, {-9659, 3896}, {-10088, 3939}, {-9857, 
        3996}, {-9708, 3959}, {-9749, 4017}, {-9614, 3984}, {-10010, 
        4101}, {-9704, 4212}, {-9388, 4284}, {-8461, 4179}, {-8460, 
        3618}, {-8128, 3588}, {-7801, 3355}}], 
       PolygonBox[{{-9349, 1216}, {-9288, 1172}, {-9340, 1135}, {-9349, 
        1216}}], 
       PolygonBox[{{-9196, 3480}, {-9140, 3446}, {-9288, 3441}, {-9196, 
        3480}}]},
      "\"USA\""], 
     TooltipBox[
      {GrayLevel[0], 
       PolygonBox[{{-7364, 2940}, {-7022, 2940}, {-6962, 2940}, {-6240, 
        2940}, {-5832, 2940}, {-5375, 2880}, {-5048, 2792}, {-4945, 
        2581}, {-4959, 2553}, {-4962, 2501}, {-4735, 2575}, {-4744, 
        2586}, {-4744, 2596}, {-4548, 2669}, {-4401, 2701}, {-4290, 
        2701}, {-4265, 2718}, {-4154, 2848}, {-4032, 2711}, {-3943, 
        2716}, {-3885, 2765}, {-3896, 2721}, {-3802, 2722}, {-3971, 
        2665}, {-3928, 2608}, {-3658, 2716}, {-3715, 2753}, {-3825, 
        2750}, {-3881, 2864}, {-4011, 2880}, {-3853, 2910}, {-3927, 
        2956}, {-4278, 2805}, {-4184, 2887}, {-4264, 2906}, {-4181, 
        2888}, {-3868, 3019}, {-3608, 3012}, {-3337, 3133}, {-3346, 
        3191}, {-3482, 3254}, {-3625, 3196}, {-3502, 3254}, {-3441, 
        3275}, {-3641, 3300}, {-3732, 3403}, {-3890, 3622}, {-3964, 
        3499}, {-4080, 3515}, {-4162, 3466}, {-4092, 3513}, {-4262, 
        3604}, {-4162, 3654}, {-4325, 3704}, {-4686, 3740}, {-4714, 
        3517}, {-4595, 3434}, {-4628, 3339}, {-4786, 3279}, {-4760, 
        3043}, {-4913, 3131}, {-4938, 3309}, {-5125, 3299}, {-5330, 
        3410}, {-5573, 3414}, {-5658, 3509}, {-5688, 3630}, {-5438, 
        3784}, {-5627, 3851}, {-5279, 3851}, {-5222, 3914}, {-5490, 
        3957}, {-5244, 3919}, {-5022, 3971}, {-5113, 4015}, {-4890, 
        4020}, {-4880, 4151}, {-5134, 4192}, {-5223, 4035}, {-5337, 
        4154}, {-5415, 4094}, {-5575, 4180}, {-5674, 4320}, {-5792, 
        4208}, {-5602, 4118}, {-5728, 4058}, {-5749, 3995}, {-5771, 
        4064}, {-5871, 4113}, {-5832, 4057}, {-6134, 4061}, {-6373, 
        4136}, {-6507, 4091}, {-6339, 4118}, {-6435, 3981}, {-6605, 
        4080}, {-6906, 4068}, {-6899, 4132}, {-7460, 4161}, {-7473, 
        4209}, {-7526, 4159}, {-7680, 4235}, {-7848, 4161}, {-8008, 
        4133}, {-7780, 4216}, {-7983, 4168}, {-8110, 4119}, {-8461, 
        4179}, {-8460, 3618}, {-8128, 3588}, {-7801, 3355}, {-7803, 
        3233}, {-7738, 3213}, {-7700, 3142}, {-7604, 3142}, {-7673, 
        3100}, {-7667, 3070}, {-7489, 3055}, {-7365, 2939}}], 
       PolygonBox[{{-7900, 3247}, {-7962, 3195}, {-7984, 3250}, {-7900, 
        3247}}], PolygonBox[{{-7648, 3042}, {-7413, 2898}, {-7649, 3042}}], 
       PolygonBox[{{-7184, 4442}, {-6919, 4409}, {-7368, 4265}, {-7560, 
        4318}, {-7487, 4460}, {-7185, 4442}}], 
       PolygonBox[{{-6876, 4356}, {-6516, 4351}, {-6471, 4296}, {-6485, 
        4401}, {-6312, 4343}, {-6058, 4209}, {-6174, 4128}, {-6395, 
        4170}, {-6799, 4108}, {-7046, 4200}, {-6689, 4220}, {-7054, 
        4236}, {-6904, 4292}, {-7146, 4301}, {-7041, 4375}, {-6876, 4356}}], 
       PolygonBox[{{-4981, 3895}, {-4858, 3807}, {-5114, 3787}, {-5231, 
        3815}, {-5137, 3955}, {-4981, 3895}}], 
       PolygonBox[{{-6269, 4412}, {-6317, 4371}, {-6422, 4409}, {-6269, 
        4412}}], 
       PolygonBox[{{-5872, 4193}, {-5732, 4120}, {-5966, 4133}, {-5872, 
        4193}}], 
       PolygonBox[{{-3337, 3097}, {-3411, 2973}, {-3323, 2942}, {-3209, 
        2957}, {-3220, 2851}, {-3170, 2886}, {-3185, 2799}, {-3255, 
        2874}, {-3323, 2812}, {-3346, 2877}, {-3558, 2857}, {-3564, 
        2875}, {-3470, 2990}, {-3337, 3096}}], 
       PolygonBox[{{-3619, 2811}, {-3669, 2742}, {-3588, 2756}, {-3691, 
        2756}, {-3619, 2811}}], 
       PolygonBox[{{-4034, 4097}, {-3676, 3998}, {-3813, 3893}, {-3861, 
        3981}, {-4112, 3978}, {-4043, 3932}, {-3878, 3774}, {-4140, 
        3825}, {-3964, 3712}, {-4284, 3783}, {-4512, 3867}, {-4680, 
        3865}, {-4646, 3928}, {-4523, 3883}, {-4409, 3927}, {-4275, 
        3957}, {-4153, 3994}, {-4379, 4005}, {-4599, 4122}, {-4741, 
        4241}, {-4857, 4183}, {-5275, 4214}, {-5374, 4265}, {-5401, 
        4313}, {-5169, 4432}, {-5208, 4259}, {-5141, 4374}, {-4918, 
        4424}, {-4858, 4313}, {-4624, 4365}, {-4505, 4271}, {-4403, 
        4259}, {-4315, 4294}, {-4357, 4238}, {-4292, 4201}, {-4192, 
        4253}, {-4140, 4200}, {-4202, 4172}, {-4006, 4160}, {-4164, 
        4132}, {-4034, 4097}}], 
       PolygonBox[{{-5705, 4441}, {-5412, 4434}, {-5644, 4319}, {-5705, 
        4441}}], 
       PolygonBox[{{-7119, 4642}, {-6954, 4601}, {-7220, 4548}, {-7382, 
        4565}, {-7119, 4642}}], 
       PolygonBox[{{-6222, 4761}, {-5951, 4670}, {-6289, 4701}, {-6222, 
        4761}}], 
       PolygonBox[{{-6023, 4598}, {-5857, 4507}, {-6167, 4533}, {-6112, 
        4587}, {-6023, 4598}}]},
      "\"Canada\""], 
     TooltipBox[
      {GrayLevel[0.3], 
       PolygonBox[{{-5828, 1558}, {-5873, 1356}, {-5752, 1123}, {-5471, 
        1120}, {-5482, 1132}, {-5420, 1262}, {-5227, 1297}, {-5298, 
        1109}, {-5348, 1069}, {-5459, 1069}, {-5426, 966}, {-5504, 
        964}, {-5535, 873}, {-5567, 905}, {-5535, 873}, {-5692, 986}, {-5867, 
        958}, {-6209, 1100}, {-6327, 1195}, {-6343, 1352}, {-6564, 
        1538}, {-6730, 1738}, {-6785, 1874}, {-6902, 1917}, {-6772, 
        1697}, {-6571, 1388}, {-6726, 1484}, {-6901, 1664}, {-6844, 
        1711}, {-7027, 1952}, {-6883, 1963}, {-6543, 1880}, {-6391, 
        1907}, {-6243, 1760}, {-6050, 1757}, {-5945, 1584}, {-5828, 1558}}]},
      "\"Mexico\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-2149, 3968}, {-1949, 4117}, {-1633, 4112}, {-1338, 
        4200}, {-1752, 4224}, {-1525, 4276}, {-1716, 4328}, {-1294, 
        4228}, {-1533, 4344}, {-1647, 4407}, {-1230, 4407}, {-1327, 
        4475}, {-1139, 4469}, {-1346, 4510}, {-1160, 4524}, {-1348, 
        4610}, {-1087, 4617}, {-1322, 4661}, {-967, 4830}, {-1275, 
        4834}, {-729, 4896}, {-1468, 4832}, {-1338, 4925}, {-1514, 
        4920}, {-1959, 4901}, {-1279, 4956}, {-2129, 4965}, {-1540, 
        4997}, {-1981, 5017}, {-2801, 4981}, {-2394, 4960}, {-2745, 
        4966}, {-2678, 4905}, {-2992, 4897}, {-3515, 4926}, {-3387, 
        4880}, {-3608, 4916}, {-3948, 4748}, {-4358, 4710}, {-3964, 
        4650}, {-4282, 4623}, {-4110, 4565}, {-3605, 4561}, {-3354, 
        4301}, {-3214, 4341}, {-3029, 4231}, {-3278, 4239}, {-3013, 
        4201}, {-3203, 4100}, {-3009, 4076}, {-3224, 4052}, {-3058, 
        4074}, {-3232, 4034}, {-3022, 4030}, {-3238, 4024}, {-3209, 
        3966}, {-3000, 4019}, {-3208, 3959}, {-3033, 3943}, {-3154, 
        3919}, {-3120, 3852}, {-3000, 3892}, {-3028, 3803}, {-2894, 
        3649}, {-2713, 3672}, {-2707, 3604}, {-2586, 3606}, {-2548, 
        3704}, {-2589, 3765}, {-2467, 3907}, {-2149, 3968}}], 
       PolygonBox[{{-3258, 4219}, {-3110, 4178}, {-3214, 4154}, {-3258, 
        4219}}]},
      "\"Greenland\""], 
     TooltipBox[
      {GrayLevel[0.6], PolygonBox[{{-3885, 1939}}]},
      "\"Bermuda\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5095, 1315}, {-4868, 1393}, {-4638, 1305}, {-4448, 
        1211}, {-4648, 1209}, {-4913, 1361}, {-5095, 1315}}]},
      "\"Cuba\""], 
     TooltipBox[
      {GrayLevel[0.6], PolygonBox[{{-4702, 1096}}]},
      "\"Jamaica\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-4306, 1082}, {-4469, 1106}, {-4341, 1112}, {-4407, 
        1185}, {-4305, 1182}, {-4306, 1082}}]},
      "\"Haiti\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5297, 1109}, {-5335, 954}, {-5348, 1069}, {-5297, 
        1109}}]},
      "\"Belize\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-4306, 1182}, {-4099, 1116}, {-4307, 1083}, {-4306, 
        1182}}]},
      "\"Dominican Republic\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5270, 806}, {-5406, 825}, {-5361, 866}, {-5270, 806}}]},
      "\"El Salvador\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5335, 954}, {-5293, 943}, {-5361, 866}, {-5406, 
        825}, {-5535, 873}, {-5504, 964}, {-5426, 966}, {-5459, 1069}, {-5348,
         1069}, {-5335, 954}}]},
      "\"Guatemala\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5293, 943}, {-4988, 900}, {-5238, 779}, {-5270, 
        806}, {-5361, 866}, {-5293, 943}}]},
      "\"Honduras\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-4988, 900}, {-5019, 655}, {-5141, 664}, {-5240, 
        778}, {-4988, 900}}]},
      "\"Nicaragua\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-5019, 655}, {-4954, 574}, {-4974, 482}, {-5140, 
        594}, {-5141, 664}, {-5019, 655}}]},
      "\"Costa Rica\""], 
     TooltipBox[
      {GrayLevel[0.6], 
       PolygonBox[{{-4954, 574}, {-4802, 556}, {-4790, 562}, {-4642, 
        521}, {-4673, 434}, {-4687, 513}, {-4772, 536}, {-4776, 533}, {-4826, 
        435}, {-4974, 482}, {-4954, 574}}]},
      "\"Panama\""], 
     TooltipBox[
      {GrayLevel[0.6], PolygonBox[{{-4036, 1103}}]},
      "\"Puerto Rico\""]}}, 
   {Thickness[0.001], 
    LineBox[{{-600, 5400}, {-600, 5376}, {-600, 5280}, {-600, 5184}, {-600, 
     5088}, {-600, 4992}, {-600, 4896}, {-600, 4800}, {-600, 4704}, {-600, 
     4608}, {-600, 4512}, {-600, 4416}, {-600, 4320}, {-600, 4224}, {-600, 
     4128}, {-600, 4032}, {-600, 3936}, {-600, 3840}, {-600, 3744}, {-600, 
     3648}, {-600, 3552}, {-600, 3456}, {-600, 3360}, {-600, 3264}, {-600, 
     3168}, {-600, 3072}, {-600, 2976}, {-600, 2880}, {-600, 2784}, {-600, 
     2688}, {-600, 2592}, {-600, 2496}, {-600, 2400}, {-600, 2304}, {-600, 
     2208}, {-600, 2112}, {-600, 2016}, {-600, 1920}, {-600, 1824}, {-600, 
     1728}, {-600, 1632}, {-600, 1536}, {-600, 1440}, {-600, 1344}, {-600, 
     1248}, {-600, 1152}, {-600, 1056}, {-600, 960}, {-600, 864}, {-600, 
     768}, {-600, 672}, {-600, 576}, {-600, 480}, {-600, 384}, {-600, 
     288}, {-600, 192}, {-600, 96}, {-600, 0}}], 
    LineBox[{{-600, 0}, {-600, 0}, {-696, 0}, {-792, 0}, {-888, 0}, {-984, 
     0}, {-1080, 0}, {-1176, 0}, {-1272, 0}, {-1368, 0}, {-1464, 0}, {-1560, 
     0}, {-1656, 0}, {-1752, 0}, {-1848, 0}, {-1944, 0}, {-2040, 0}, {-2136, 
     0}, {-2232, 0}, {-2328, 0}, {-2424, 0}, {-2520, 0}, {-2616, 0}, {-2712, 
     0}, {-2808, 0}, {-2904, 0}, {-3000, 0}, {-3096, 0}, {-3192, 0}, {-3288, 
     0}, {-3384, 0}, {-3480, 0}, {-3576, 0}, {-3672, 0}, {-3768, 0}, {-3864, 
     0}, {-3960, 0}, {-4056, 0}, {-4152, 0}, {-4248, 0}, {-4344, 0}, {-4440, 
     0}, {-4536, 0}, {-4632, 0}, {-4728, 0}, {-4824, 0}, {-4920, 0}, {-5016, 
     0}, {-5112, 0}, {-5208, 0}, {-5304, 0}, {-5400, 0}, {-5496, 0}, {-5592, 
     0}, {-5688, 0}, {-5784, 0}, {-5880, 0}, {-5976, 0}, {-6072, 0}, {-6168, 
     0}, {-6264, 0}, {-6360, 0}, {-6456, 0}, {-6552, 0}, {-6648, 0}, {-6744, 
     0}, {-6840, 0}, {-6936, 0}, {-7032, 0}, {-7128, 0}, {-7224, 0}, {-7320, 
     0}, {-7416, 0}, {-7512, 0}, {-7608, 0}, {-7704, 0}, {-7800, 0}, {-7896, 
     0}, {-7992, 0}, {-8088, 0}, {-8184, 0}, {-8280, 0}, {-8376, 0}, {-8472, 
     0}, {-8568, 0}, {-8664, 0}, {-8760, 0}, {-8856, 0}, {-8952, 0}, {-9048, 
     0}, {-9144, 0}, {-9240, 0}, {-9336, 0}, {-9432, 0}, {-9528, 0}, {-9624, 
     0}, {-9720, 0}, {-9816, 0}, {-9912, 0}, {-10008, 0}, {-10104, 
     0}, {-10200, 0}}], 
    LineBox[{{-10200, 0}, {-10200, 96}, {-10200, 192}, {-10200, 288}, {-10200,
      384}, {-10200, 480}, {-10200, 576}, {-10200, 672}, {-10200, 
     768}, {-10200, 864}, {-10200, 960}, {-10200, 1056}, {-10200, 
     1152}, {-10200, 1248}, {-10200, 1344}, {-10200, 1440}, {-10200, 
     1536}, {-10200, 1632}, {-10200, 1728}, {-10200, 1824}, {-10200, 
     1920}, {-10200, 2016}, {-10200, 2112}, {-10200, 2208}, {-10200, 
     2304}, {-10200, 2400}, {-10200, 2496}, {-10200, 2592}, {-10200, 
     2688}, {-10200, 2784}, {-10200, 2880}, {-10200, 2976}, {-10200, 
     3072}, {-10200, 3168}, {-10200, 3264}, {-10200, 3360}, {-10200, 
     3456}, {-10200, 3552}, {-10200, 3648}, {-10200, 3744}, {-10200, 
     3840}, {-10200, 3936}, {-10200, 4032}, {-10200, 4128}, {-10200, 
     4224}, {-10200, 4320}, {-10200, 4416}, {-10200, 4512}, {-10200, 
     4608}, {-10200, 4704}, {-10200, 4800}, {-10200, 4896}, {-10200, 
     4992}, {-10200, 5088}, {-10200, 5184}, {-10200, 5280}, {-10200, 
     5376}, {-10200, 5400}}], 
    LineBox[{{-10200, 5400}, {-10104, 5400}, {-10008, 5400}, {-9912, 
     5400}, {-9816, 5400}, {-9720, 5400}, {-9624, 5400}, {-9528, 
     5400}, {-9432, 5400}, {-9336, 5400}, {-9240, 5400}, {-9144, 
     5400}, {-9048, 5400}, {-8952, 5400}, {-8856, 5400}, {-8760, 
     5400}, {-8664, 5400}, {-8568, 5400}, {-8472, 5400}, {-8376, 
     5400}, {-8280, 5400}, {-8184, 5400}, {-8088, 5400}, {-7992, 
     5400}, {-7896, 5400}, {-7800, 5400}, {-7704, 5400}, {-7608, 
     5400}, {-7512, 5400}, {-7416, 5400}, {-7320, 5400}, {-7224, 
     5400}, {-7128, 5400}, {-7032, 5400}, {-6936, 5400}, {-6840, 
     5400}, {-6744, 5400}, {-6648, 5400}, {-6552, 5400}, {-6456, 
     5400}, {-6360, 5400}, {-6264, 5400}, {-6168, 5400}, {-6072, 
     5400}, {-5976, 5400}, {-5880, 5400}, {-5784, 5400}, {-5688, 
     5400}, {-5592, 5400}, {-5496, 5400}, {-5400, 5400}, {-5304, 
     5400}, {-5208, 5400}, {-5112, 5400}, {-5016, 5400}, {-4920, 
     5400}, {-4824, 5400}, {-4728, 5400}, {-4632, 5400}, {-4536, 
     5400}, {-4440, 5400}, {-4344, 5400}, {-4248, 5400}, {-4152, 
     5400}, {-4056, 5400}, {-3960, 5400}, {-3864, 5400}, {-3768, 
     5400}, {-3672, 5400}, {-3576, 5400}, {-3480, 5400}, {-3384, 
     5400}, {-3288, 5400}, {-3192, 5400}, {-3096, 5400}, {-3000, 
     5400}, {-2904, 5400}, {-2808, 5400}, {-2712, 5400}, {-2616, 
     5400}, {-2520, 5400}, {-2424, 5400}, {-2328, 5400}, {-2232, 
     5400}, {-2136, 5400}, {-2040, 5400}, {-1944, 5400}, {-1848, 
     5400}, {-1752, 5400}, {-1656, 5400}, {-1560, 5400}, {-1464, 
     5400}, {-1368, 5400}, {-1272, 5400}, {-1176, 5400}, {-1080, 5400}, {-984,
      5400}, {-888, 5400}, {-792, 5400}, {-696, 5400}, {-600, 5400}, {-600, 
     5400}}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{364, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->823499]
}, Open  ]],

Cell[TextData[{
 "A map is simply the representation of a portion of the Earth\
\[CloseCurlyQuote]s surface on a flat page. Since the Earth is nearly \
spherical, this representation requires that we adopt some scheme for taking \
the surface of a spherical object and representing it as a flat \
two\[Hyphen]dimensional image. These schemes are called ",
 StyleBox["projections",
  FontSlant->"Italic"],
 ". By their very nature, all projections give rise to certain distortions. \
Various projections have been developed that preserve certain properties of \
the surface of the Earth while distorting others. An ",
 StyleBox["equal\[Hyphen]area",
  FontSlant->"Italic"],
 " projection has the property that two regions that have the same area on \
the map have the same area on the globe. A projection is called ",
 StyleBox["conformal",
  FontSlant->"Italic"],
 " if it preserves angular relationships and therefore directions. An ",
 StyleBox["azimuthal",
  FontSlant->"Italic"],
 " projection preserves true directions from a central point. "
}], "Text",
 CellID->19559],

Cell[TextData[{
 "The projection for a map is specified by the option ",
 Cell[BoxData[
  ButtonBox["WorldProjection",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldProjection"]], "InlineFormula"],
 ". You can define your own projection by giving a pure function of two \
arguments. For example, the default setting for ",
 Cell[BoxData[
  ButtonBox["WorldProjection",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldProjection"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Equirectangular",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Equirectangular"]], "InlineFormula"],
 ", which as a pure function is given as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldProjection",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldProjection"], " ", "->", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#2", ",", " ", "#1"}], "}"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 ". The parentheses around the pure function ensure that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes it as a single expression. If you define your own projections, \
it is important to remember that the coordinates in the database are given in \
minutes. This means that you must convert them to radians before using a \
built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " trigonometric function. Also, the coordinates of the boundaries of \
countries are given as pairs with the latitude first. "
}], "Text",
 CellID->18372],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Albers",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Albers"], 
    ButtonBox["Equirectangular",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Equirectangular"]},
   {
    ButtonBox["LambertAzimuthal",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/LambertAzimuthal"], 
    ButtonBox["LambertCylindrical",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/LambertCylindrical"]},
   {
    ButtonBox["Mercator",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Mercator"], 
    ButtonBox["Mollweide",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Mollweide"]},
   {
    ButtonBox["Orthographic",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Orthographic"], 
    ButtonBox["Sinusoidal",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Sinusoidal"]}
  }]], "DefinitionBox",
 CellID->25738],

Cell["Projections.", "Caption",
 CellID->15570],

Cell[TextData[{
 "You can also give the name of a projection as a value for the option ",
 Cell[BoxData[
  ButtonBox["WorldProjection",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldProjection"]], "InlineFormula"],
 ". Many of the standard projections are included in this package. These are \
described below. "
}], "Text",
 CellID->22176],

Cell[TextData[{
 "The simplest projection is the ",
 StyleBox["equirectangular projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Equirectangular",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Equirectangular"]], "InlineFormula"],
 ". This projection simply takes the latitude as the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " coordinate and the longitude as the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " coordinate. This projection does not preserve angles or area. ",
 Cell[BoxData[
  ButtonBox["Equirectangular",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Equirectangular"]], "InlineFormula"],
 " is the default setting for ",
 Cell[BoxData[
  ButtonBox["WorldProjection",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldProjection"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22005],

Cell[TextData[{
 "The ",
 StyleBox["Lambert cylindrical projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["LambertCylindrical",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/LambertCylindrical"]], "InlineFormula"],
 " is just an equirectangular projection with the spacing between parallels \
adjusted so the projection is equal area. This projection is sometimes called \
the ",
 StyleBox["cylindrical equal\[Hyphen]area projection",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->5032],

Cell[TextData[{
 "In the ",
 StyleBox["Lambert azimuthal projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["LambertAzimuthal",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/LambertAzimuthal"]], "InlineFormula"],
 " the globe is projected onto a plane that is tangential to the globe at one \
point, and then the spacing of parallel circles around the projection point \
is adjusted to make it equal area. This projection gives true directions from \
the center point and is sometimes called the ",
 StyleBox["azimuthal equal\[Hyphen]area projection",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->429],

Cell[TextData[{
 "Another azimuthal projection is the orthographic projection. ",
 Cell[BoxData[
  ButtonBox["Orthographic",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Orthographic"]], "InlineFormula"],
 " specifies a projection of the sphere with the projection point at \
infinity. The result looks like a view of the planet as seen from very far \
away. The projection preserves neither area nor angles. "
}], "Text",
 CellID->29619],

Cell[TextData[{
 "The ",
 StyleBox["sinusoidal projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Sinusoidal",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Sinusoidal"]], "InlineFormula"],
 " belongs to the class of pseudo\[Hyphen]cylindrical projections, that is, \
parallels are straight lines, meridians are curved, and their spacing is \
adjusted to make it equal area. "
}], "Text",
 CellID->5389],

Cell[TextData[{
 "The most popular equal\[Hyphen]area projection for world maps is the ",
 StyleBox["Mollweide projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Mollweide",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Mollweide"]], "InlineFormula"],
 ". The adjustment used to achieve equal areas is fairly sophisticated and \
involves the solution of a trigonometric equation. This projection is \
sometimes also called ",
 StyleBox["elliptical",
  FontSlant->"Italic"],
 " or ",
 StyleBox["homolographic",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->1968],

Cell[TextData[{
 "The ",
 StyleBox["Mercator projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Mercator",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Mercator"]], "InlineFormula"],
 " is a cylindrical projection that preserves angles but is not equal area. \
It is produced by adjusting a cylindrical projection that is projected from \
the center of the Earth. This projection is particularly useful for \
navigation, as a straight line on the map corresponds to a fixed directional \
bearing. "
}], "Text",
 CellID->13542],

Cell[TextData[{
 "A conic projection is produced by projecting the surface of the Earth onto \
a cone that is tangential to the Earth along a circle. The ",
 StyleBox["Albers conic projection", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Albers",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Albers"]], "InlineFormula"],
 " is a conic projection that is adjusted to make it equal area. Unlike the \
other projections, ",
 Cell[BoxData[
  ButtonBox["Albers",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Albers"]], "InlineFormula"],
 " requires you to specify additional information. This takes the form of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Albers",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/Albers"], "[", Cell[BoxData[
    FormBox[
     SubscriptBox[
      StyleBox["par", "TI"], "1"], TraditionalForm]], "InlineFormula"], 
   StyleBox[",", "TI"], " ", Cell[BoxData[
    FormBox[
     SubscriptBox[
      StyleBox["par", "TI"], "2"], TraditionalForm]], "InlineFormula"], 
   "]"}]], "InlineFormula"],
 ". The two parallels you specify are the parallels along which the scale is \
correct. A good projection for the United States is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Albers",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/Albers"], "[", 
   RowBox[{"20", ",", " ", "60"}], "]"}]], "InlineFormula"],
 ". The Albers conic projection is sometimes called the ",
 StyleBox["Albers equal\[Hyphen]area projection",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->16983],

Cell["\<\
The sinusoidal projection gives little distortion near the equator and the \
prime meridian, and is therefore very good for showing Africa. \
\>", "MathCaption",
 CellID->11637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Africa", ",", "RandomColors"}], "}"}], ",", 
   RowBox[{"WorldProjection", "\[Rule]", "Sinusoidal"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31161],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Thickness[0.001], 
     LineBox[{{0, -2400}, {0, -2352}, {0, -2304}, {0, -2256}, {0, -2208}, {
      0, -2160}, {0, -2112}, {0, -2064}, {0, -2016}, {0, -1968}, {0, -1920}, {
      0, -1872}, {0, -1824}, {0, -1776}, {0, -1728}, {0, -1680}, {0, -1632}, {
      0, -1584}, {0, -1536}, {0, -1488}, {0, -1440}, {0, -1392}, {0, -1344}, {
      0, -1296}, {0, -1248}, {0, -1200}, {0, -1152}, {0, -1104}, {0, -1056}, {
      0, -1008}, {0, -960}, {0, -912}, {0, -864}, {0, -816}, {0, -768}, {
      0, -720}, {0, -672}, {0, -624}, {0, -576}, {0, -528}, {0, -480}, {
      0, -432}, {0, -384}, {0, -336}, {0, -288}, {0, -240}, {0, -192}, {
      0, -144}, {0, -96}, {0, -48}, {0, 0}, {0, 48}, {0, 96}, {0, 144}, {0, 
      192}, {0, 240}, {0, 288}, {0, 336}, {0, 384}, {0, 432}, {0, 480}, {0, 
      528}, {0, 576}, {0, 624}, {0, 672}, {0, 720}, {0, 768}, {0, 816}, {0, 
      864}, {0, 912}, {0, 960}, {0, 1008}, {0, 1056}, {0, 1104}, {0, 1152}, {
      0, 1200}, {0, 1248}, {0, 1296}, {0, 1344}, {0, 1392}, {0, 1440}, {0, 
      1488}, {0, 1536}, {0, 1584}, {0, 1632}, {0, 1680}, {0, 1728}, {0, 
      1776}, {0, 1824}, {0, 1872}, {0, 1920}, {0, 1968}, {0, 2016}, {0, 
      2064}, {0, 2112}, {0, 2160}, {0, 2208}, {0, 2256}, {0, 2304}, {0, 
      2352}, {0, 2400}, {0, 2400}}], 
     LineBox[{{1378.87999761416, -2400}, {1394.90007966752, -2352}, {
       1410.64822318651, -2304}, {1426.12135803934, -2256}, {
       1441.31646770772, -2208}, {1456.23058987491, -2160}, {
       1470.86081700323, -2112}, {1485.20429690093, -2064}, {
       1499.25823327818, -2016}, {1513.01988629223, -1968}, {
       1526.48657308157, -1920}, {1539.65566828891, -1872}, {
       1552.52460457306, -1824}, {1565.09087310939, -1776}, {
       1577.35202407895, -1728}, {1589.30566714607, -1680}, {
       1600.94947192434, -1632}, {1612.28116843094, -1584}, {
       1623.2985475292, -1536}, {1633.99946135924, -1488}, {
       1644.38182375668, -1440}, {1654.44361065942, -1392}, {
       1664.18286050216, -1344}, {1673.59767459885, -1296}, {
       1682.68621751283, -1248}, {1691.44671741464, -1200}, {
       1699.87746642747, -1152}, {1707.97682096009, -1104}, {
       1715.7432020273, -1056}, {1723.17509555772, -1008}, {
       1730.27105268897, -960}, {1737.02969005016, -912}, {
       1743.44969003154, -864}, {1749.52980104138, -816}, {
       1755.26883775001, -768}, {1760.66568132085, -720}, {
       1765.71927962854, -672}, {1770.42864746409, -624}, {
       1774.79286672691, -576}, {1778.8110866038, -528}, {
       1782.48252373483, -480}, {1785.80646236606, -432}, {
       1788.78225448907, -384}, {1791.4093199673, -336}, {
       1793.68714664911, -288}, {1795.61529046768, -240}, {
       1797.19337552757, -192}, {1798.42109417795, -144}, {
       1799.29820707264, -96}, {1799.82454321675, -48}, {1800, 0}, {
       1799.82454321675, 48}, {1799.29820707264, 96}, {
       1798.42109417795, 144}, {1797.19337552757, 192}, {
       1795.61529046768, 240}, {1793.68714664911, 288}, {
       1791.4093199673, 336}, {1788.78225448907, 384}, {
       1785.80646236606, 432}, {1782.48252373483, 480}, {
       1778.8110866038, 528}, {1774.79286672691, 576}, {
       1770.42864746409, 624}, {1765.71927962854, 672}, {
       1760.66568132085, 720}, {1755.26883775001, 768}, {
       1749.52980104138, 816}, {1743.44969003154, 864}, {
       1737.02969005016, 912}, {1730.27105268897, 960}, {
       1723.17509555772, 1008}, {1715.7432020273, 1056}, {
       1707.97682096009, 1104}, {1699.87746642747, 1152}, {
       1691.44671741464, 1200}, {1682.68621751283, 1248}, {
       1673.59767459885, 1296}, {1664.18286050216, 1344}, {
       1654.44361065942, 1392}, {1644.38182375668, 1440}, {
       1633.99946135924, 1488}, {1623.2985475292, 1536}, {
       1612.28116843094, 1584}, {1600.94947192434, 1632}, {
       1589.30566714607, 1680}, {1577.35202407895, 1728}, {
       1565.09087310939, 1776}, {1552.52460457306, 1824}, {
       1539.65566828891, 1872}, {1526.48657308157, 1920}, {
       1513.01988629223, 1968}, {1499.25823327818, 2016}, {
       1485.20429690093, 2064}, {1470.86081700323, 2112}, {
       1456.23058987491, 2160}, {1441.31646770772, 2208}, {
       1426.12135803934, 2256}, {1410.64822318651, 2304}, {
       1394.90007966752, 2352}, {1378.87999761416, 2400}, {
       1378.87999761416, 2400}}], 
     LineBox[{{2757.75999522832, -2400}, {2789.80015933505, -2352}, {
       2821.29644637302, -2304}, {2852.24271607869, -2256}, {
       2882.63293541544, -2208}, {2912.46117974981, -2160}, {
       2941.72163400646, -2112}, {2970.40859380186, -2064}, {
       2998.51646655636, -2016}, {3026.03977258446, -1968}, {
       3052.97314616313, -1920}, {3079.31133657782, -1872}, {
       3105.04920914613, -1824}, {3130.18174621879, -1776}, {
       3154.70404815791, -1728}, {3178.61133429214, -1680}, {
       3201.89894384867, -1632}, {3224.56233686189, -1584}, {
       3246.59709505841, -1536}, {3267.99892271847, -1488}, {
       3288.76364751336, -1440}, {3308.88722131884, -1392}, {
       3328.36572100433, -1344}, {3347.1953491977, -1296}, {
       3365.37243502565, -1248}, {3382.89343482927, -1200}, {
       3399.75493285493, -1152}, {3415.95364192019, -1104}, {
       3431.48640405461, -1056}, {3446.35019111544, -1008}, {
       3460.54210537795, -960}, {3474.05938010032, -912}, {
       3486.89938006307, -864}, {3499.05960208277, -816}, {
       3510.53767550003, -768}, {3521.3313626417, -720}, {
       3531.43855925709, -672}, {3540.85729492819, -624}, {
       3549.58573345382, -576}, {3557.62217320759, -528}, {
       3564.96504746965, -480}, {3571.61292473212, -432}, {
       3577.56450897815, -384}, {3582.81863993459, -336}, {
       3587.37429329822, -288}, {3591.23058093537, -240}, {
       3594.38675105513, -192}, {3596.84218835589, -144}, {
       3598.59641414528, -96}, {3599.6490864335, -48}, {3600, 0}, {
       3599.6490864335, 48}, {3598.59641414528, 96}, {
       3596.84218835589, 144}, {3594.38675105513, 192}, {
       3591.23058093537, 240}, {3587.37429329822, 288}, {
       3582.81863993459, 336}, {3577.56450897815, 384}, {
       3571.61292473212, 432}, {3564.96504746965, 480}, {
       3557.62217320759, 528}, {3549.58573345382, 576}, {
       3540.85729492819, 624}, {3531.43855925709, 672}, {
       3521.3313626417, 720}, {3510.53767550003, 768}, {
       3499.05960208277, 816}, {3486.89938006307, 864}, {
       3474.05938010032, 912}, {3460.54210537795, 960}, {
       3446.35019111544, 1008}, {3431.48640405461, 1056}, {
       3415.95364192019, 1104}, {3399.75493285493, 1152}, {
       3382.89343482927, 1200}, {3365.37243502565, 1248}, {
       3347.1953491977, 1296}, {3328.36572100433, 1344}, {
       3308.88722131884, 1392}, {3288.76364751336, 1440}, {
       3267.99892271847, 1488}, {3246.59709505841, 1536}, {
       3224.56233686189, 1584}, {3201.89894384867, 1632}, {
       3178.61133429214, 1680}, {3154.70404815791, 1728}, {
       3130.18174621879, 1776}, {3105.04920914613, 1824}, {
       3079.31133657782, 1872}, {3052.97314616313, 1920}, {
       3026.03977258446, 1968}, {2998.51646655636, 2016}, {
       2970.40859380186, 2064}, {2941.72163400646, 2112}, {
       2912.46117974981, 2160}, {2882.63293541544, 2208}, {
       2852.24271607869, 2256}, {2821.29644637302, 2304}, {
       2789.80015933505, 2352}, {2757.75999522832, 2400}, {
       2757.75999522832, 2400}}], 
     LineBox[{{-1039.23048454133, -1800}, {-997.661265159673, -1800}, \
{-956.09204577802, -1800}, {-914.522826396367, -1800}, {-872.953607014714, \
-1800}, {-831.384387633061, -1800}, {-789.815168251408, -1800}, \
{-748.245948869755, -1800}, {-706.676729488102, -1800}, {-665.107510106449, \
-1800}, {-623.538290724796, -1800}, {-581.969071343143, -1800}, \
{-540.39985196149, -1800}, {-498.830632579837, -1800}, {-457.261413198184, \
-1800}, {-415.692193816531, -1800}, {-374.122974434878, -1800}, \
{-332.553755053224, -1800}, {-290.984535671571, -1800}, {-249.415316289918, \
-1800}, {-207.846096908265, -1800}, {-166.276877526612, -1800}, \
{-124.707658144959, -1800}, {-83.1384387633061, -1800}, {-41.5692193816531, \
-1800}, {0, -1800}, {41.5692193816531, -1800}, {83.1384387633061, -1800}, {
       124.707658144959, -1800}, {166.276877526612, -1800}, {
       207.846096908265, -1800}, {249.415316289918, -1800}, {
       290.984535671571, -1800}, {332.553755053224, -1800}, {
       374.122974434878, -1800}, {415.692193816531, -1800}, {
       457.261413198184, -1800}, {498.830632579837, -1800}, {
       540.39985196149, -1800}, {581.969071343143, -1800}, {
       623.538290724796, -1800}, {665.107510106449, -1800}, {
       706.676729488102, -1800}, {748.245948869755, -1800}, {
       789.815168251408, -1800}, {831.384387633061, -1800}, {
       872.953607014714, -1800}, {914.522826396367, -1800}, {
       956.09204577802, -1800}, {997.661265159673, -1800}, {
       1039.23048454133, -1800}, {1080.79970392298, -1800}, {
       1122.36892330463, -1800}, {1163.93814268629, -1800}, {
       1205.50736206794, -1800}, {1247.07658144959, -1800}, {
       1288.64580083124, -1800}, {1330.2150202129, -1800}, {
       1371.78423959455, -1800}, {1413.3534589762, -1800}, {
       1454.92267835786, -1800}, {1496.49189773951, -1800}, {
       1538.06111712116, -1800}, {1579.63033650282, -1800}, {
       1621.19955588447, -1800}, {1662.76877526612, -1800}, {
       1704.33799464778, -1800}, {1745.90721402943, -1800}, {
       1787.47643341108, -1800}, {1829.04565279273, -1800}, {
       1870.61487217439, -1800}, {1912.18409155604, -1800}, {
       1953.75331093769, -1800}, {1995.32253031935, -1800}, {
       2036.891749701, -1800}, {2078.46096908265, -1800}, {
       2120.03018846431, -1800}, {2161.59940784596, -1800}, {
       2203.16862722761, -1800}, {2244.73784660927, -1800}, {
       2286.30706599092, -1800}, {2327.87628537257, -1800}, {
       2369.44550475422, -1800}, {2411.01472413588, -1800}, {
       2452.58394351753, -1800}, {2494.15316289918, -1800}, {
       2535.72238228084, -1800}, {2577.29160166249, -1800}, {
       2618.86082104414, -1800}, {2660.4300404258, -1800}, {
       2701.99925980745, -1800}, {2743.5684791891, -1800}, {
       2785.13769857075, -1800}, {2826.70691795241, -1800}, {
       2868.27613733406, -1800}, {2909.84535671571, -1800}, {
       2951.41457609737, -1800}, {2992.98379547902, -1800}, {
       3034.55301486067, -1800}, {3076.12223424233, -1800}, {
       3117.69145362398, -1800}, {3117.69145362398, -1800}}], 
     LineBox[{{-1200, 0}, {-1152, 0}, {-1104, 0}, {-1056, 0}, {-1008, 
      0}, {-960, 0}, {-912, 0}, {-864, 0}, {-816, 0}, {-768, 0}, {-720, 
      0}, {-672, 0}, {-624, 0}, {-576, 0}, {-528, 0}, {-480, 0}, {-432, 
      0}, {-384, 0}, {-336, 0}, {-288, 0}, {-240, 0}, {-192, 0}, {-144, 
      0}, {-96, 0}, {-48, 0}, {0, 0}, {48, 0}, {96, 0}, {144, 0}, {192, 0}, {
      240, 0}, {288, 0}, {336, 0}, {384, 0}, {432, 0}, {480, 0}, {528, 0}, {
      576, 0}, {624, 0}, {672, 0}, {720, 0}, {768, 0}, {816, 0}, {864, 0}, {
      912, 0}, {960, 0}, {1008, 0}, {1056, 0}, {1104, 0}, {1152, 0}, {1200, 
      0}, {1248, 0}, {1296, 0}, {1344, 0}, {1392, 0}, {1440, 0}, {1488, 0}, {
      1536, 0}, {1584, 0}, {1632, 0}, {1680, 0}, {1728, 0}, {1776, 0}, {1824, 
      0}, {1872, 0}, {1920, 0}, {1968, 0}, {2016, 0}, {2064, 0}, {2112, 0}, {
      2160, 0}, {2208, 0}, {2256, 0}, {2304, 0}, {2352, 0}, {2400, 0}, {2448, 
      0}, {2496, 0}, {2544, 0}, {2592, 0}, {2640, 0}, {2688, 0}, {2736, 0}, {
      2784, 0}, {2832, 0}, {2880, 0}, {2928, 0}, {2976, 0}, {3024, 0}, {3072, 
      0}, {3120, 0}, {3168, 0}, {3216, 0}, {3264, 0}, {3312, 0}, {3360, 0}, {
      3408, 0}, {3456, 0}, {3504, 0}, {3552, 0}, {3600, 0}, {3600, 0}}], 
     LineBox[{{-1039.23048454133, 1800}, {-997.661265159673, 
        1800}, {-956.09204577802, 1800}, {-914.522826396367, 
        1800}, {-872.953607014714, 1800}, {-831.384387633061, 
        1800}, {-789.815168251408, 1800}, {-748.245948869755, 
        1800}, {-706.676729488102, 1800}, {-665.107510106449, 
        1800}, {-623.538290724796, 1800}, {-581.969071343143, 
        1800}, {-540.39985196149, 1800}, {-498.830632579837, 
        1800}, {-457.261413198184, 1800}, {-415.692193816531, 
        1800}, {-374.122974434878, 1800}, {-332.553755053224, 
        1800}, {-290.984535671571, 1800}, {-249.415316289918, 
        1800}, {-207.846096908265, 1800}, {-166.276877526612, 
        1800}, {-124.707658144959, 1800}, {-83.1384387633061, 
        1800}, {-41.5692193816531, 1800}, {0, 1800}, {
       41.5692193816531, 1800}, {83.1384387633061, 1800}, {
       124.707658144959, 1800}, {166.276877526612, 1800}, {
       207.846096908265, 1800}, {249.415316289918, 1800}, {
       290.984535671571, 1800}, {332.553755053224, 1800}, {
       374.122974434878, 1800}, {415.692193816531, 1800}, {
       457.261413198184, 1800}, {498.830632579837, 1800}, {
       540.39985196149, 1800}, {581.969071343143, 1800}, {
       623.538290724796, 1800}, {665.107510106449, 1800}, {
       706.676729488102, 1800}, {748.245948869755, 1800}, {
       789.815168251408, 1800}, {831.384387633061, 1800}, {
       872.953607014714, 1800}, {914.522826396367, 1800}, {
       956.09204577802, 1800}, {997.661265159673, 1800}, {
       1039.23048454133, 1800}, {1080.79970392298, 1800}, {
       1122.36892330463, 1800}, {1163.93814268629, 1800}, {
       1205.50736206794, 1800}, {1247.07658144959, 1800}, {
       1288.64580083124, 1800}, {1330.2150202129, 1800}, {
       1371.78423959455, 1800}, {1413.3534589762, 1800}, {
       1454.92267835786, 1800}, {1496.49189773951, 1800}, {
       1538.06111712116, 1800}, {1579.63033650282, 1800}, {
       1621.19955588447, 1800}, {1662.76877526612, 1800}, {
       1704.33799464778, 1800}, {1745.90721402943, 1800}, {
       1787.47643341108, 1800}, {1829.04565279273, 1800}, {
       1870.61487217439, 1800}, {1912.18409155604, 1800}, {
       1953.75331093769, 1800}, {1995.32253031935, 1800}, {
       2036.891749701, 1800}, {2078.46096908265, 1800}, {
       2120.03018846431, 1800}, {2161.59940784596, 1800}, {
       2203.16862722761, 1800}, {2244.73784660927, 1800}, {
       2286.30706599092, 1800}, {2327.87628537257, 1800}, {
       2369.44550475422, 1800}, {2411.01472413588, 1800}, {
       2452.58394351753, 1800}, {2494.15316289918, 1800}, {
       2535.72238228084, 1800}, {2577.29160166249, 1800}, {
       2618.86082104414, 1800}, {2660.4300404258, 1800}, {
       2701.99925980745, 1800}, {2743.5684791891, 1800}, {
       2785.13769857075, 1800}, {2826.70691795241, 1800}, {
       2868.27613733406, 1800}, {2909.84535671571, 1800}, {
       2951.41457609737, 1800}, {2992.98379547902, 1800}, {
       3034.55301486067, 1800}, {3076.12223424233, 1800}, {
       3117.69145362398, 1800}, {3117.69145362398, 1800}}]}, {
     TooltipBox[
      {RGBColor[0.264719533198893, 0.174311216391714, 0.743060302048611], 
       PolygonBox[{{413.256305041931, 2216}, {0, 
         2150}, {-108.836153692468, 2105}, {-60.1456564181317, 
          1926}, {-194.835744058108, 1902}, {-186.927760793596, 
          1858}, {-456.043346327062, 1723}, {-460.545233221999, 
          1660}, {-462.150317618486, 1637}, {-261.016642666555, 1500}, {0, 
         1310}, {240.889065229115, 1149}, {660.199711813516, 1411}, {
         506.270829386284, 1569}, {494.197710043153, 1814}, {
         373.578521153663, 2033}, {413.256305041931, 2216}}]},
      "\"Algeria\""], 
     TooltipBox[
      {RGBColor[0.944236730577382, 0.37700917318277, 0.957339713174032], 
       PolygonBox[{{786.857098782242, -352}, {730.838388937905, -366}, {
         810.502197894675, -708}, {674.244080786774, -1035}, {
         793.262322397865, -1040}, {1342.79756410259, -1058}, {
         1267.80170035412, -970}, {1286.16848551651, -780}, {
         1404.06726335552, -780}, {1413.19665464666, -652}, {
         1306.15118184854, -652}, {1296.45429042264, -437}, {
         1069.22555033388, -486}, {1010.85304372363, -435}, {
         985.780082084253, -353}, {786.880584133526, -351}}]},
      "\"Angola\""], 
     TooltipBox[
      {RGBColor[0.362589697542587, 0.357958113830658, 0.752917298080649], 
       PolygonBox[{{97.4237116049664, 373}, {162.98854656002, 382}, {
         209.515731111701, 705}, {140.913925353836, 713}, {
         56.9343766399645, 660}, {97.4237116049664, 373}}]},
      "\"Benin\""], 
     TooltipBox[
      {RGBColor[0.236143755432849, 0.48527272633683, 0.749395784529634], 
       PolygonBox[{{1443.42815939708, -1068}, {1196.16096697256, -1099}, {
         1112.62062548015, -1320}, {1089.62562266881, -1486}, {
         1105.5886399334, -1610}, {1233.19060020955, -1539}, {
         1379.934946173, -1540}, {1632.30984102002, -1332}, {
         1443.42815939708, -1068}}]},
      "\"Botswana\""], 
     TooltipBox[
      {RGBColor[0.826897812421742, 0.19862110796956, 0.444404196117123], 
       PolygonBox[{{-158.799704804007, 569}, {-325.527339535987, 
          626}, {-231.424041054647, 810}, {0, 900}, {13.522961568047, 900}, {
         140.905293854656, 714}, {
         56.9343766399645, 660}, {-9.81180493192603, 668}, {-166.876621186103,
           660}, {-158.799704804007, 569}}]},
      "\"Burkina Faso\""], 
     TooltipBox[
      {RGBColor[0.0406973746436792, 0.78535330514098, 0.230686105247336], 
       PolygonBox[{{1738.9950408703, -165}, {1759.6792708959, -267}, {
         1832.39127040131, -144}, {1738.9950408703, -165}}]},
      "\"Burundi\""], 
     TooltipBox[
      {RGBColor[0.655641694311846, 0.159996390975753, 0.227278923736689], 
       PolygonBox[{{588.504646911263, 141}, {583.478425885378, 248}, {
         514.177733715227, 289}, {583.863718766644, 408}, {
         707.558277130986, 425}, {861.149326198535, 694}, {
         822.091326686802, 785}, {926.751588363951, 599}, {
         825.197335851341, 578}, {921.972943576177, 452}, {
         860.182208117474, 363}, {971.272659760925, 133}, {
         797.429494178547, 130}, {679.513854688486, 130}, {
         588.504646911263, 141}}]},
      "\"Cameroon\""], 
     TooltipBox[
      {RGBColor[0.679278412128914, 0.722383891241409, 0.455804410669613], 
       PolygonBox[{{921.972943576177, 452}, {1104.05843088944, 482}, {
         1341.12967773072, 657}, {1348.15373275602, 655}, {
         1394.70273129371, 523}, {1640.69084264584, 301}, {
         1336.51468493403, 248}, {1147.67451032456, 298}, {
         1115.93451120302, 209}, {993.161751920397, 209}, {
         971.272659760925, 133}, {860.182208117474, 363}, {
         921.972943576177, 452}}]},
      "\"CAR\""], 
     TooltipBox[
      {RGBColor[0.962559390537796, 0.5049671957372, 0.979323589192798], 
       PolygonBox[{{1357.40374717274, 1170}, {880.377671409719, 1410}, {
         828.454368107196, 1380}, {900.082386295765, 1221}, {
         888.879819589517, 1014}, {794.670791714697, 823}, {
         822.091326686802, 785}, {926.751588363951, 599}, {
         825.197335851341, 578}, {921.972943576177, 452}, {
         1104.05843088944, 482}, {1341.12967773072, 657}, {
         1277.44565414029, 768}, {1325.63410252834, 933}, {
         1386.27611485413, 942}, {1357.40374717274, 1170}}]},
      "\"Chad\""], 
     TooltipBox[
      {RGBColor[0.511567680092231, 0.585550217355026, 0.547627482563168], 
       PolygonBox[{{668.408444758022, -237}, {719.234237031147, -301}, {
         782.434660764446, -278}, {951.771886997948, -235}, {
         1115.93451120302, 209}, {993.161751920397, 209}, {
         971.272659760925, 133}, {797.429494178547, 130}, {
         789.816981075047, 74}, {869.884572858199, 56}, {
         866.523337221504, -114}, {694.423760411356, -140}, {
         668.408444758022, -237}}]},
      "\"Congo\""], 
     TooltipBox[
      {RGBColor[0.616733891650211, 0.153609566261572, 0.832632919274377], 
       PolygonBox[{{786.857098782242, -352}, {728.274165985885, -347}, {
         783.431392816375, -278}, {951.771886997948, -235}, {
         1115.93451120302, 209}, {1147.67451032456, 298}, {
         1336.51468493403, 248}, {1640.69084264584, 301}, {
         1848.57845684078, 209}, {1876.7186260952, 127}, {
         1775.48239282446, -83}, {1740.01812746641, -164}, {
         1759.6792708959, -267}, {1827.20343378516, -491}, {
         1679.78816249976, -556}, {1667.53509599163, -693}, {
         1747.94868872345, -729}, {1738.96100610195, -807}, {
         1598.85745205462, -694}, {1413.19665464666, -652}, {
         1306.15118184854, -652}, {1296.45429042264, -437}, {
         1069.22555033388, -486}, {1010.85304372363, -435}, {
         985.780082084253, -353}, {786.857098782242, -352}}]},
      "\"Democratic Republic of the Congo\""], 
     TooltipBox[
      {RGBColor[0.311483727130319, 0.131461165313381, 0.404213781731939], 
       PolygonBox[{{2544.7137403843, 691}, {2499.49161418835, 692}, {
         2523.54231803772, 763}, {2455.54587347056, 691}, {
         2529.65325174463, 660}, {2544.7137403843, 691}}]},
      "\"Djibouti\""], 
     TooltipBox[
      {RGBColor[0.00573510685263527, 0.112862619160759, 0.687056969196259], 
       PolygonBox[{{1965.17043159774, 1388}, {1686.82016324012, 1776}, {
         1818.92785088429, 1664}, {1825.10400103997, 1773}, {
         1822.82469518068, 1769}, {1758.31903006762, 1873}, {
         1753.58317456482, 1880}, {1284.56544299761, 1899}, {
         1390.77578185018, 1320}, {1891.05624964724, 1305}, {
         1965.17043159774, 1388}}]},
      "\"Egypt\""], 
     TooltipBox[
      {RGBColor[0.363516407088259, 0.220381801711655, 0.882176513913423], 
       PolygonBox[{{587.910444751958, 60}, {588.504646911263, 141}, {
         679.513854688486, 130}, {680.896280401503, 60}, {
         587.910444751958, 60}}]},
      "\"Equatorial Guinea\""], 
     TooltipBox[
      {RGBColor[0.0314152748844128, 0.203520016112506, 0.993102877974966], 
       PolygonBox[{{2119.57616190775, 862}, {2122.23989965826, 1024}, {
         2203.18102788099, 1082}, {2300.90176027875, 905}, {
         2523.54231803772, 763}, {2501.07792658397, 739}, {
         2254.42029580555, 878}, {2119.57616190775, 862}}]},
      "\"Eritrea\""], 
     TooltipBox[
      {RGBColor[0.202898101784509, 0.309031383643004, 0.747715605442893], 
       PolygonBox[{{2119.57616190775, 862}, {2254.42029580555, 878}, {
         2501.07792658397, 739}, {2455.54587347056, 691}, {
         2529.65325174463, 660}, {2608.48490751176, 540}, {
         2850.98176990698, 480}, {2687.14326382687, 294}, {
         2507.92692866725, 239}, {2366.74442473884, 206}, {
         2149.00487387559, 277}, {1960.05965123685, 476}, {
         2022.22744903693, 633}, {2115.93442581856, 762}, {
         2119.57616190775, 862}}]},
      "\"Ethiopia\""], 
     TooltipBox[
      {RGBColor[0.03054348743717, 0.697930906047309, 0.329707794450206], 
       PolygonBox[{{587.910444751958, 60}, {522.968048834939, -38}, {
         668.408444758022, -237}, {694.423760411356, -140}, {
         866.523337221504, -114}, {869.884572858199, 56}, {
         789.816981075047, 74}, {797.429494178547, 130}, {
         679.513854688486, 130}, {680.896280401503, 60}, {
         587.910444751958, 60}}]},
      "\"Gabon\""], 
     TooltipBox[
      {RGBColor[0.236147925350663, 0.444993270082144, 0.15030342348414], 
       PolygonBox[{{-185.268439972522, 305}, {0, 337}, {
         71.5923319775907, 366}, {0, 636}, {-4.91306398271808, 642}, {0, 
         666}, {-8.83062443873343, 668}, {-166.876621186103, 
          660}, {-158.799704804007, 569}, {-185.268439972522, 305}}]},
      "\"Ghana\""], 
     TooltipBox[
      {RGBColor[0.712973902799994, 0.0825383590890904, 0.612360350807767], 
       PolygonBox[{{-788.102536528288, 542}, {-884.595783042005, 
          657}, {-802.917527099339, 761}, {-664.943219483145, 
          748}, {-666.090493823903, 744}, {-526.426358022116, 
          744}, {-471.503539247739, 609}, {-470.494666333062, 
          610}, {-503.576496604611, 454}, {-609.260231600254, 
          509}, {-662.775617777216, 600}, {-788.102536528288, 542}}]},
      "\"Guinea\""], 
     TooltipBox[
      {RGBColor[0.838819696353821, 0.581512737486613, 0.678324577357152], 
       PolygonBox[{{-979.914515767079, 739}, {-880.441553980634, 
          718}, {-911.865461053061, 680}, {-884.595783042005, 
          657}, {-802.917527099339, 761}, {-979.914515767079, 739}}]},
      "\"Guinea-Bissau\""], 
     TooltipBox[
      {RGBColor[0.606625243955131, 0.725957077193062, 0.894455768290354], 
       PolygonBox[{{-450.697933793001, 261}, {-185.268439972522, 
          305}, {-185.268439972522, 305}, {-158.799704804007, 
          569}, {-158.799704804007, 569}, {-325.50988956642, 
          627}, {-325.527339535987, 626}, {-470.494666333062, 
          610}, {-470.494666333062, 610}, {-503.576496604611, 
          454}, {-503.576496604611, 454}, {-449.700814470451, 261}}]},
      "\"Cote d'Ivoire\""], 
     TooltipBox[
      {RGBColor[0.314808170268892, 0.386243442243476, 0.843780563279639], 
       PolygonBox[{{2492.94491350501, -100}, {2344.20285668068, -280}, {
         2034.69005964326, -60}, {2100.82399239254, 115}, {
         2034.47798704097, 253}, {2149.00487387559, 277}, {
         2366.74442473884, 206}, {2508.92451296664, 239}, {
         2455.99399217737, 170}, {2492.94491350501, -100}}]},
      "\"Kenya\""], 
     TooltipBox[
      {RGBColor[0.863040493405942, 0.111288154156386, 0.39314056426851], 
       PolygonBox[{{-684.954223991772, 416}, {-450.697933793001, 
          261}, {-503.576496604611, 454}, {-609.260231600254, 
          509}, {-684.954223991772, 416}}]},
      "\"Liberia\""], 
     TooltipBox[
      {RGBColor[0.64088246149513, 0.554009109762938, 0.363572548713493], 
       PolygonBox[{{579.261249993311, 1990}, {815.863826760663, 1879}, {
         1001.70903924696, 1817}, {1093.40663309897, 1977}, {
         1284.56544299761, 1899}, {1390.77578185018, 1320}, {
         1390.77578185018, 1320}, {1409.53893117886, 1200}, {
         1357.40374717274, 1170}, {880.377671409719, 1410}, {
         826.715389278591, 1379}, {660.199711813516, 1411}, {
         506.270829386284, 1569}, {494.197710043153, 1814}, {
         579.261249993311, 1990}}]},
      "\"Libya\""], 
     TooltipBox[
      {RGBColor[0.36259707683134, 0.942951555447822, 0.224301315312732], 
       PolygonBox[{{2412.00998705156, -1312}, {2510.71524469143, -1197}, {
         2562.27996712246, -971}, {2784.8788914142, -886}, {
         2892.91786369931, -717}, {2922.37627887752, -919}, {
         2868.99589922194, -933}, {2563.38597254201, -1499}, {
         2397.25199416161, -1497}, {2412.00998705156, -1312}}]},
      "\"Madagascar\""], 
     TooltipBox[
      {RGBColor[0.12742462336283, 0.917603806749196, 0.792648131963681], 
       PolygonBox[{{1951.95413544801, -569}, {2030.34687501669, -584}, {
         2054.41426284224, -694}, {2017.95584515356, -801}, {
         2082.70155014143, -893}, {2023.05132377836, -1028}, {
         2005.24524374151, -875}, {1933.6590488068, -841}, {
         1951.95413544801, -569}}]},
      "\"Malawi\""], 
     TooltipBox[
      {RGBColor[0.511327412512738, 0.0448862642737397, 0.30524345594143], 
       PolygonBox[{{240.889065229115, 1149}, {0, 
         1310}, {-261.016642666555, 1500}, {-357.991575879477, 
          1500}, {-317.998049558846, 930}, {-664.41999105469, 
          939}, {-699.227730142833, 884}, {-710.724300412998, 
          886}, {-664.943219483145, 748}, {-666.090493823903, 
          744}, {-526.426358022116, 744}, {-470.494666333062, 
          610}, {-325.527339535987, 626}, {-231.424041054647, 810}, {0, 
         900}, {13.522961568047, 900}, {224.28882695404, 943}, {
         240.889065229115, 1149}}]},
      "\"Mali\""], 
     TooltipBox[
      {RGBColor[0.95382843560986, 0.929814675026125, 0.366561686916588], 
       PolygonBox[{{-956.537849592282, 1246}, {-912.117548764012, 
          1213}, {-953.332624649705, 963}, {-771.764242688175, 
          962}, {-699.281187285067, 883}, {-664.41999105469, 
          939}, {-317.998049558846, 930}, {-357.991575879477, 
          1500}, {-261.016642666555, 1500}, {-462.080960980573, 
          1638}, {-467.372904075567, 1560}, {-647.1317133354, 
          1560}, {-724.051728774657, 1374}, {-726.554196362391, 
          1280}, {-956.537849592282, 1246}}]},
      "\"Mauritania\""], 
     TooltipBox[
      {RGBColor[0.698618211986298, 0.227871358416798, 0.0353589067357706], 
       PolygonBox[{{-107.995762700103, 2106}, {-263.208087146068, 
          2155}, {-306.300450966704, 2101}, {-469.507689000644, 
          1953}, {-535.363104291696, 1759}, {-700.560152843464, 
          1660}, {-460.545233221999, 1660}, {-456.043346327062, 
          1723}, {-186.927760793596, 1858}, {-194.835744058108, 
          1902}, {-60.1456564181317, 1926}, {-107.995762700103, 2106}}]},
      "\"Morocco\""], 
     TooltipBox[
      {RGBColor[0.0517535166476956, 0.312374769742822, 0.384090795137158], 
       PolygonBox[{{2385.50490748956, -629}, {2353.70728990524, -917}, {
         1953.62469576974, -1177}, {1944.33679750638, -1446}, {
         1775.70824449167, -1536}, {1761.18703514286, -1611}, {
         1720.39943324584, -1610}, {1724.62005710552, -1557}, {
         1736.08920347258, -1345}, {1862.07608234975, -1202}, {
         1895.36521291695, -1003}, {1757.48586349294, -938}, {
         1933.6590488068, -841}, {2005.24524374151, -875}, {
         2023.05132377836, -1028}, {2082.70155014143, -893}, {
         2017.95584515356, -801}, {2054.41426284224, -694}, {
         2385.50490748956, -629}}]},
      "\"Mozambique\""], 
     TooltipBox[
      {RGBColor[0.172318413329829, 0.94046536249131, 0.919234205474312], 
       PolygonBox[{{674.244080786774, -1035}, {804.551066780822, -1361}, {
         797.287208327205, -1388}, {868.462840072323, -1715}, {
         1055.24606048314, -1706}, {1089.62562266881, -1486}, {
         1112.62062548015, -1320}, {1196.16096697256, -1099}, {
         1443.42815939708, -1068}, {1342.79756410259, -1058}, {
         793.262322397865, -1040}, {674.244080786774, -1035}}]},
      "\"Namibia\""], 
     TooltipBox[
      {RGBColor[0.743208333642028, 0.618309303566891, 0.576892813777817], 
       PolygonBox[{{826.715389278591, 1379}, {659.28276776933, 1411}, {
         240.889065229115, 1149}, {224.28882695404, 943}, {
         13.522961568047, 900}, {140.905293854656, 714}, {
         209.515731111701, 705}, {211.512127094301, 702}, {
         284.56266223989, 827}, {563.636326788616, 768}, {
         794.670791714697, 823}, {888.879819589517, 1014}, {
         900.082386295765, 1221}, {826.715389278591, 1379}}]},
      "\"Niger\""], 
     TooltipBox[
      {RGBColor[0.556637128642972, 0.800256778194207, 0.394007988254159], 
       PolygonBox[{{513.193822513495, 288}, {364.985662337723, 256}, {
         315.320793026144, 354}, {161.994713959044, 382}, {
         209.515731111701, 705}, {211.512127094301, 702}, {
         284.56266223989, 827}, {563.636326788616, 768}, {
         794.670791714697, 823}, {823.120975090876, 784}, {
         861.149326198535, 694}, {707.558277130986, 425}, {
         583.863718766644, 408}, {513.193822513495, 288}}]},
      "\"Nigeria\""], 
     TooltipBox[
      {RGBColor[0.449468190414986, 0.639033321893776, 0.00760864623052578], 
       PolygonBox[{{868.462840072323, -1715}, {909.32077781452, -2050}, {
         985.179792657024, -2089}, {1403.40387264277, -1982}, {
         1761.18703514286, -1611}, {1720.39943324584, -1610}, {
         1650.39117831798, -1608}, {1724.37584424042, -1558}, {
         1736.08920347258, -1345}, {1631.57756182695, -1331}, {
         1379.934946173, -1540}, {1233.19060020955, -1539}, {
         1105.5886399334, -1610}, {1089.62562266881, -1486}, {
         1055.24606048314, -1706}, {868.462840072323, -1715}}]},
      "\"South Africa\""], 
     TooltipBox[
      {RGBColor[0.882680575741421, 0.404581926141247, 0.333789865952346], 
       PolygonBox[{{1511.64683842852, -1717}, {1408.98522562459, -1778}, {
         1450.21146335159, -1840}, {1540.19119077976, -1761}, {
         1511.64683842852, -1717}}]},
      "\"Lesotho\""], 
     TooltipBox[
      {RGBColor[0.0537802106206661, 0.952865900715296, 0.0380202392246587], 
       PolygonBox[{{1775.48239282446, -83}, {1738.9950408703, -165}, {
         1832.39127040131, -144}, {1828.68305540587, -64}, {
         1775.48239282446, -83}}]},
      "\"Rwanda\""], 
     TooltipBox[
      {RGBColor[0.635171653966048, 0.825908852203869, 0.917506993979525], 
       PolygonBox[{{-953.252804066052, 964}, {-1017.33232773747, 
          885}, {-966.197183366799, 815}, {-805.514210821796, 
          803}, {-978.978201143586, 784}, {-899.943734680416, 
          770}, {-979.914515767079, 739}, {-802.917527099339, 
          761}, {-664.943219483145, 748}, {-710.724300412998, 
          886}, {-699.281187285067, 883}, {-771.764242688175, 
          962}, {-953.332624649705, 963}}]},
      "\"Senegal\""], 
     TooltipBox[
      {RGBColor[0.986266722576963, 0.322796884223226, 0.44181805706671], 
       PolygonBox[{{-788.102536528288, 542}, {-683.961536710624, 
          416}, {-608.271172782721, 509}, {-662.775617777216, 
          600}, {-788.102536528288, 542}}]},
      "\"Sierra Leone\""], 
     TooltipBox[
      {RGBColor[0.745188580649696, 0.0458013600856537, 0.403562678748913], 
       PolygonBox[{{2491.94533655493, -100}, {2868.26200630324, 268}, {
         3033.83084384413, 627}, {2980.41573943591, 720}, {
         2650.58348484658, 625}, {2544.7137403843, 691}, {
         2543.05499476628, 689}, {2529.65325174463, 660}, {
         2608.48490751176, 540}, {2850.98176990698, 480}, {
         2687.14326382687, 294}, {2507.92692866725, 239}, {
         2455.99399217737, 170}, {2491.94533655493, -100}}]},
      "\"Somalia\""], 
     TooltipBox[
      {RGBColor[0.698609723424682, 0.126879277082805, 0.468908546307837], 
       PolygonBox[{{2203.18102788099, 1082}, {2052.30219349942, 1322}, {
         1965.17043159774, 1388}, {1891.05624964724, 1305}, {
         1390.77578185018, 1320}, {1409.53893117886, 1200}, {
         1357.40374717274, 1170}, {1386.27611485413, 942}, {
         1325.63410252834, 933}, {1277.44565414029, 768}, {
         1341.12967773072, 657}, {1348.15373275602, 655}, {
         1394.70273129371, 523}, {1640.69084264584, 301}, {
         1848.57845684078, 209}, {2034.47798704097, 253}, {
         2149.00487387559, 277}, {1960.05965123685, 476}, {
         2022.22744903693, 633}, {2115.93442581856, 762}, {
         2122.23989965826, 1024}, {2203.18102788099, 1082}}]},
      "\"Sudan\""], 
     TooltipBox[
      {RGBColor[0.846925550105941, 0.898352945230475, 0.732871288828646], 
       PolygonBox[{{1720.39943324584, -1610}, {1724.62005710552, -1557}, {
         1650.39117831798, -1608}, {1720.39943324584, -1610}}]},
      "\"Swaziland\""], 
     TooltipBox[
      {RGBColor[0.0194403558928507, 0.207892228212165, 0.890744298999949], 
       PolygonBox[{{2385.50490748956, -629}, {2314.03930438077, -363}, {
         2344.20285668068, -280}, {2034.69005964326, -60}, {
         1828.68305540587, -64}, {1832.39127040131, -144}, {
         1759.6792708959, -267}, {1827.20343378516, -491}, {
         1952.33220372667, -565}, {2030.34687501669, -584}, {
         2055.39395490845, -694}, {2385.50490748956, -629}}]},
      "\"Tanzania\""], 
     TooltipBox[
      {RGBColor[0.850190713087225, 0.614858429751604, 0.874102362259819], 
       PolygonBox[{{-966.197183366799, 815}, {-892.822261522142, 
          807}, {-979.110223823052, 782}, {-978.978201143586, 
          784}, {-805.514210821796, 803}, {-966.197183366799, 815}}]},
      "\"The Gambia\""], 
     TooltipBox[
      {RGBColor[0.836964088379283, 0.89732481237193, 0.576838190526945], 
       PolygonBox[{{71.5923319775907, 366}, {98.4178311111395, 373}, {
         53.9894950896215, 660}, {-9.81180493192603, 668}, {0, 
         666}, {-4.91306398271808, 642}, {0, 636}, {71.5923319775907, 366}}]},
      
      "\"Togo\""], 
     TooltipBox[
      {RGBColor[0.238930708293771, 0.0110552361754144, 0.979817818392404], 
       PolygonBox[{{413.256305041931, 2216}, {528.914456455446, 2225}, {
         496.444464684906, 2050}, {579.261249993311, 1990}, {
         494.197710043153, 1814}, {373.578521153663, 2033}, {
         413.256305041931, 2216}}]},
      "\"Tunisia\""], 
     TooltipBox[
      {RGBColor[0.590571467949982, 0.916133824070545, 0.569237179108704], 
       PolygonBox[{{1848.57845684078, 209}, {1876.7186260952, 127}, {
         1775.48239282446, -83}, {1828.68305540587, -64}, {
         2034.69005964326, -60}, {2100.82399239254, 115}, {
         2034.47798704097, 253}, {1848.57845684078, 209}}]},
      "\"Uganda\""], 
     TooltipBox[
      {RGBColor[0.234629237742708, 0.544770107864328, 0.512571145321632], 
       PolygonBox[{{-700.560152843464, 1660}, {-956.537849592282, 
          1246}, {-726.554196362391, 1280}, {-724.051728774657, 
          1374}, {-647.1317133354, 1560}, {-467.372904075567, 
          1560}, {-462.080960980573, 1638}, {-460.545233221999, 
          1660}, {-700.560152843464, 1660}}]},
      "\"Western Sahara\""], 
     TooltipBox[
      {RGBColor[0.870627455684023, 0.107749960659903, 0.0758615615564913], 
       PolygonBox[{{1827.20343378516, -491}, {1679.78816249976, -556}, {
         1667.53509599163, -693}, {1747.94868872345, -729}, {
         1738.96100610195, -807}, {1598.85745205462, -694}, {
         1413.19665464666, -652}, {1404.06726335552, -780}, {
         1286.16848551651, -780}, {1267.80170035412, -970}, {
         1342.79756410259, -1058}, {1443.42815939708, -1068}, {
         1551.01878077694, -1068}, {1757.48586349294, -938}, {
         1933.6590488068, -841}, {1951.95413544801, -569}, {
         1952.33220372667, -565}, {1827.12692225578, -492}}]},
      "\"Zambia\""], 
     TooltipBox[
      {RGBColor[0.66564559521569, 0.972274510453548, 0.374878671831257], 
       PolygonBox[{{1736.08920347258, -1345}, {1631.57756182695, -1331}, {
         1443.42815939708, -1068}, {1551.01878077694, -1068}, {
         1757.48586349294, -938}, {1895.36521291695, -1003}, {
         1862.07608234975, -1202}, {1736.08920347258, -1345}}]},
      "\"Zimbabwe\""]}}, 
   {Thickness[0.001], 
    LineBox[{{2757.75999522832, 2400}, {2757.75999522832, 2400}, {
      2789.80015933505, 2352}, {2821.29644637302, 2304}, {
      2852.24271607869, 2256}, {2882.63293541544, 2208}, {
      2912.46117974981, 2160}, {2941.72163400646, 2112}, {
      2970.40859380186, 2064}, {2998.51646655636, 2016}, {
      3026.03977258446, 1968}, {3052.97314616313, 1920}, {
      3079.31133657782, 1872}, {3105.04920914613, 1824}, {
      3130.18174621879, 1776}, {3154.70404815791, 1728}, {
      3178.61133429214, 1680}, {3201.89894384867, 1632}, {
      3224.56233686189, 1584}, {3246.59709505841, 1536}, {
      3267.99892271847, 1488}, {3288.76364751336, 1440}, {
      3308.88722131884, 1392}, {3328.36572100433, 1344}, {
      3347.1953491977, 1296}, {3365.37243502565, 1248}, {
      3382.89343482927, 1200}, {3399.75493285493, 1152}, {
      3415.95364192019, 1104}, {3431.48640405461, 1056}, {
      3446.35019111544, 1008}, {3460.54210537795, 960}, {
      3474.05938010032, 912}, {3486.89938006307, 864}, {
      3499.05960208277, 816}, {3510.53767550003, 768}, {
      3521.3313626417, 720}, {3531.43855925709, 672}, {
      3540.85729492819, 624}, {3549.58573345382, 576}, {
      3557.62217320759, 528}, {3564.96504746965, 480}, {
      3571.61292473212, 432}, {3577.56450897815, 384}, {
      3582.81863993459, 336}, {3587.37429329822, 288}, {
      3591.23058093537, 240}, {3594.38675105513, 192}, {
      3596.84218835589, 144}, {3598.59641414528, 96}, {3599.6490864335, 48}, {
      3600, 0}, {3599.6490864335, -48}, {3598.59641414528, -96}, {
      3596.84218835589, -144}, {3594.38675105513, -192}, {
      3591.23058093537, -240}, {3587.37429329822, -288}, {
      3582.81863993459, -336}, {3577.56450897815, -384}, {
      3571.61292473212, -432}, {3564.96504746965, -480}, {
      3557.62217320759, -528}, {3549.58573345382, -576}, {
      3540.85729492819, -624}, {3531.43855925709, -672}, {
      3521.3313626417, -720}, {3510.53767550003, -768}, {
      3499.05960208277, -816}, {3486.89938006307, -864}, {
      3474.05938010032, -912}, {3460.54210537795, -960}, {
      3446.35019111544, -1008}, {3431.48640405461, -1056}, {
      3415.95364192019, -1104}, {3399.75493285493, -1152}, {
      3382.89343482927, -1200}, {3365.37243502565, -1248}, {
      3347.1953491977, -1296}, {3328.36572100433, -1344}, {
      3308.88722131884, -1392}, {3288.76364751336, -1440}, {
      3267.99892271847, -1488}, {3246.59709505841, -1536}, {
      3224.56233686189, -1584}, {3201.89894384867, -1632}, {
      3178.61133429214, -1680}, {3154.70404815791, -1728}, {
      3130.18174621879, -1776}, {3105.04920914613, -1824}, {
      3079.31133657782, -1872}, {3052.97314616313, -1920}, {
      3026.03977258446, -1968}, {2998.51646655636, -2016}, {
      2970.40859380186, -2064}, {2941.72163400646, -2112}, {
      2912.46117974981, -2160}, {2882.63293541544, -2208}, {
      2852.24271607869, -2256}, {2821.29644637302, -2304}, {
      2789.80015933505, -2352}, {2757.75999522832, -2400}}], 
    LineBox[{{2757.75999522832, -2400}, {2757.75999522832, -2400}, {
      2720.98986195861, -2400}, {2684.2197286889, -2400}, {
      2647.44959541919, -2400}, {2610.67946214948, -2400}, {
      2573.90932887977, -2400}, {2537.13919561006, -2400}, {
      2500.36906234034, -2400}, {2463.59892907063, -2400}, {
      2426.82879580092, -2400}, {2390.05866253121, -2400}, {
      2353.2885292615, -2400}, {2316.51839599179, -2400}, {
      2279.74826272208, -2400}, {2242.97812945237, -2400}, {
      2206.20799618266, -2400}, {2169.43786291295, -2400}, {
      2132.66772964323, -2400}, {2095.89759637352, -2400}, {
      2059.12746310381, -2400}, {2022.3573298341, -2400}, {
      1985.58719656439, -2400}, {1948.81706329468, -2400}, {
      1912.04693002497, -2400}, {1875.27679675526, -2400}, {
      1838.50666348555, -2400}, {1801.73653021584, -2400}, {
      1764.96639694613, -2400}, {1728.19626367641, -2400}, {
      1691.4261304067, -2400}, {1654.65599713699, -2400}, {
      1617.88586386728, -2400}, {1581.11573059757, -2400}, {
      1544.34559732786, -2400}, {1507.57546405815, -2400}, {
      1470.80533078844, -2400}, {1434.03519751873, -2400}, {
      1397.26506424902, -2400}, {1360.4949309793, -2400}, {
      1323.72479770959, -2400}, {1286.95466443988, -2400}, {
      1250.18453117017, -2400}, {1213.41439790046, -2400}, {
      1176.64426463075, -2400}, {1139.87413136104, -2400}, {
      1103.10399809133, -2400}, {1066.33386482162, -2400}, {
      1029.56373155191, -2400}, {992.793598282195, -2400}, {
      956.023465012485, -2400}, {919.253331742774, -2400}, {
      882.483198473063, -2400}, {845.713065203352, -2400}, {
      808.942931933641, -2400}, {772.17279866393, -2400}, {
      735.402665394219, -2400}, {698.632532124508, -2400}, {
      661.862398854797, -2400}, {625.092265585086, -2400}, {
      588.322132315375, -2400}, {551.551999045664, -2400}, {
      514.781865775953, -2400}, {478.011732506242, -2400}, {
      441.241599236531, -2400}, {404.47146596682, -2400}, {
      367.701332697109, -2400}, {330.931199427399, -2400}, {
      294.161066157688, -2400}, {257.390932887977, -2400}, {
      220.620799618266, -2400}, {183.850666348555, -2400}, {
      147.080533078844, -2400}, {110.310399809133, -2400}, {
      73.5402665394219, -2400}, {36.7701332697109, -2400}, {
      0, -2400}, {-36.7701332697109, -2400}, {-73.5402665394219, -2400}, \
{-110.310399809133, -2400}, {-147.080533078844, -2400}, {-183.850666348555, \
-2400}, {-220.620799618266, -2400}, {-257.390932887977, -2400}, \
{-294.161066157688, -2400}, {-330.931199427399, -2400}, {-367.701332697109, \
-2400}, {-404.47146596682, -2400}, {-441.241599236531, -2400}, \
{-478.011732506242, -2400}, {-514.781865775953, -2400}, {-551.551999045664, \
-2400}, {-588.322132315375, -2400}, {-625.092265585086, -2400}, \
{-661.862398854797, -2400}, {-698.632532124508, -2400}, {-735.402665394219, \
-2400}, {-772.17279866393, -2400}, {-808.942931933641, -2400}, \
{-845.713065203352, -2400}, {-882.483198473063, -2400}, {-919.253331742774, \
-2400}}], 
    LineBox[{{-919.253331742774, -2400}, {-929.933386445015, -2352}, \
{-940.432148791008, -2304}, {-950.747572026229, -2256}, {-960.87764513848, \
-2208}, {-970.820393249937, -2160}, {-980.573878002154, -2112}, \
{-990.136197933954, -2064}, {-999.505488852119, -2016}, {-1008.67992419482, \
-1968}, {-1017.65771538771, -1920}, {-1026.43711219261, -1872}, \
{-1035.01640304871, -1824}, {-1043.39391540626, -1776}, {-1051.56801605264, \
-1728}, {-1059.53711143071, -1680}, {-1067.29964794956, -1632}, \
{-1074.8541122873, -1584}, {-1082.19903168614, -1536}, {-1089.33297423949, \
-1488}, {-1096.25454917112, -1440}, {-1102.96240710628, -1392}, \
{-1109.45524033478, -1344}, {-1115.7317830659, -1296}, {-1121.79081167522, \
-1248}, {-1127.63114494309, -1200}, {-1133.25164428498, -1152}, \
{-1138.6512139734, -1104}, {-1143.82880135154, -1056}, {-1148.78339703848, \
-1008}, {-1153.51403512598, -960}, {-1158.01979336677, -912}, \
{-1162.29979335436, -864}, {-1166.35320069426, -816}, {-1170.17922516668, \
-768}, {-1173.77712088057, -720}, {-1177.14618641903, -672}, \
{-1180.28576497606, -624}, {-1183.19524448461, -576}, {-1185.87405773586, \
-528}, {-1188.32168248988, -480}, {-1190.53764157737, -432}, \
{-1192.52150299272, -384}, {-1194.2728799782, -336}, {-1195.79143109941, \
-288}, {-1197.07686031179, -240}, {-1198.12891701838, -192}, \
{-1198.94739611863, -144}, {-1199.53213804843, -96}, {-1199.88302881117, \
-48}, {-1200, 
      0}, {-1199.88302881117, 48}, {-1199.53213804843, 
       96}, {-1198.94739611863, 144}, {-1198.12891701838, 
       192}, {-1197.07686031179, 240}, {-1195.79143109941, 
       288}, {-1194.2728799782, 336}, {-1192.52150299272, 
       384}, {-1190.53764157737, 432}, {-1188.32168248988, 
       480}, {-1185.87405773586, 528}, {-1183.19524448461, 
       576}, {-1180.28576497606, 624}, {-1177.14618641903, 
       672}, {-1173.77712088057, 720}, {-1170.17922516668, 
       768}, {-1166.35320069426, 816}, {-1162.29979335436, 
       864}, {-1158.01979336677, 912}, {-1153.51403512598, 
       960}, {-1148.78339703848, 1008}, {-1143.82880135154, 
       1056}, {-1138.6512139734, 1104}, {-1133.25164428498, 
       1152}, {-1127.63114494309, 1200}, {-1121.79081167522, 
       1248}, {-1115.7317830659, 1296}, {-1109.45524033478, 
       1344}, {-1102.96240710628, 1392}, {-1096.25454917112, 
       1440}, {-1089.33297423949, 1488}, {-1082.19903168614, 
       1536}, {-1074.8541122873, 1584}, {-1067.29964794956, 
       1632}, {-1059.53711143071, 1680}, {-1051.56801605264, 
       1728}, {-1043.39391540626, 1776}, {-1035.01640304871, 
       1824}, {-1026.43711219261, 1872}, {-1017.65771538771, 
       1920}, {-1008.67992419482, 1968}, {-999.505488852119, 
       2016}, {-990.136197933954, 2064}, {-980.573878002154, 
       2112}, {-970.820393249937, 2160}, {-960.87764513848, 
       2208}, {-950.747572026229, 2256}, {-940.432148791008, 
       2304}, {-929.933386445015, 2352}, {-919.253331742774, 
       2400}, {-919.253331742774, 2400}}], 
    LineBox[{{-919.253331742774, 2400}, {-882.483198473063, 
       2400}, {-845.713065203352, 2400}, {-808.942931933641, 
       2400}, {-772.17279866393, 2400}, {-735.402665394219, 
       2400}, {-698.632532124508, 2400}, {-661.862398854797, 
       2400}, {-625.092265585086, 2400}, {-588.322132315375, 
       2400}, {-551.551999045664, 2400}, {-514.781865775953, 
       2400}, {-478.011732506242, 2400}, {-441.241599236531, 
       2400}, {-404.47146596682, 2400}, {-367.701332697109, 
       2400}, {-330.931199427399, 2400}, {-294.161066157688, 
       2400}, {-257.390932887977, 2400}, {-220.620799618266, 
       2400}, {-183.850666348555, 2400}, {-147.080533078844, 
       2400}, {-110.310399809133, 2400}, {-73.5402665394219, 
       2400}, {-36.7701332697109, 2400}, {0, 2400}, {
      36.7701332697109, 2400}, {73.5402665394219, 2400}, {
      110.310399809133, 2400}, {147.080533078844, 2400}, {
      183.850666348555, 2400}, {220.620799618266, 2400}, {
      257.390932887977, 2400}, {294.161066157688, 2400}, {
      330.931199427399, 2400}, {367.701332697109, 2400}, {
      404.47146596682, 2400}, {441.241599236531, 2400}, {
      478.011732506242, 2400}, {514.781865775953, 2400}, {
      551.551999045664, 2400}, {588.322132315375, 2400}, {
      625.092265585086, 2400}, {661.862398854797, 2400}, {
      698.632532124508, 2400}, {735.402665394219, 2400}, {
      772.17279866393, 2400}, {808.942931933641, 2400}, {
      845.713065203352, 2400}, {882.483198473063, 2400}, {
      919.253331742774, 2400}, {956.023465012485, 2400}, {
      992.793598282195, 2400}, {1029.56373155191, 2400}, {
      1066.33386482162, 2400}, {1103.10399809133, 2400}, {
      1139.87413136104, 2400}, {1176.64426463075, 2400}, {
      1213.41439790046, 2400}, {1250.18453117017, 2400}, {
      1286.95466443988, 2400}, {1323.72479770959, 2400}, {
      1360.4949309793, 2400}, {1397.26506424902, 2400}, {
      1434.03519751873, 2400}, {1470.80533078844, 2400}, {
      1507.57546405815, 2400}, {1544.34559732786, 2400}, {
      1581.11573059757, 2400}, {1617.88586386728, 2400}, {
      1654.65599713699, 2400}, {1691.4261304067, 2400}, {
      1728.19626367641, 2400}, {1764.96639694613, 2400}, {
      1801.73653021584, 2400}, {1838.50666348555, 2400}, {
      1875.27679675526, 2400}, {1912.04693002497, 2400}, {
      1948.81706329468, 2400}, {1985.58719656439, 2400}, {
      2022.3573298341, 2400}, {2059.12746310381, 2400}, {
      2095.89759637352, 2400}, {2132.66772964323, 2400}, {
      2169.43786291295, 2400}, {2206.20799618266, 2400}, {
      2242.97812945237, 2400}, {2279.74826272208, 2400}, {
      2316.51839599179, 2400}, {2353.2885292615, 2400}, {
      2390.05866253121, 2400}, {2426.82879580092, 2400}, {
      2463.59892907063, 2400}, {2500.36906234034, 2400}, {
      2537.13919561006, 2400}, {2573.90932887977, 2400}, {
      2610.67946214948, 2400}, {2647.44959541919, 2400}, {
      2684.2197286889, 2400}, {2720.98986195861, 2400}, {
      2757.75999522832, 2400}, {2757.75999522832, 2400}}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->525880775]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorldBorders",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldBorders"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "style to display borders of countries; with ",
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"],
     ", no borders are drawn "
    }], "TableText"]},
   {
    ButtonBox["WorldCountries",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldCountries"], "World", Cell[
    "name of the list of allowable country names ", "TableText"]},
   {
    ButtonBox["WorldDatabase",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldDatabase"], "WorldData", Cell[
    "name of the database containing polygon data for countries ", 
     "TableText"]},
   {
    ButtonBox["WorldToGraphics",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldToGraphics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to return a standard ",
     ButtonBox["Graphics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Graphics"],
     " object"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->11887],

Cell[TextData[{
 "Some options for ",
 Cell[BoxData[
  ButtonBox["WorldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldPlot"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->10061],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorldBackground",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldBackground"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "style to use for the background polygon ", "TableText"]},
   {
    ButtonBox["WorldClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldClipping"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell["\<\
specify what happens to lines or polygons that are partially outside the plot \
range\
\>", "TableText"]},
   {
    ButtonBox["WorldFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldFrame"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "style to use for the frame around the map; with ",
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"],
     ", no boundary is drawn "
    }], "TableText"]},
   {
    ButtonBox["WorldFrameParts",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldFrameParts"], 
    RowBox[{"{", "1", ",", "1", ",", "1", ",", "1", "}"}], Cell[
    "what parts of the frame to draw", "TableText"]},
   {
    ButtonBox["WorldGrid",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldGrid"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "locations of parallels and meridians to be drawn", "TableText"]},
   {
    ButtonBox["WorldGridBehind",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldGridBehind"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether the grid is drawn behind (",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     ") or in front (",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     ") of the countries"
    }], "TableText"]},
   {
    ButtonBox["WorldGridStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldGridStyle"], 
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", ".001", "]"}], Cell[
    "style for the grid", "TableText"]},
   {
    ButtonBox["WorldPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldPoints"], "100", Cell["\<\
number of divisions used in plotting grid lines and clipping polygons \
\>", "TableText"]},
   {
    ButtonBox["WorldProjection",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldProjection"], 
    ButtonBox["Equirectangular",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/Equirectangular"], Cell[
    "function to use for the projection ", "TableText"]},
   {
    ButtonBox["WorldRange",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "portion of the surface of the Earth to be drawn; specifications must be \
of form ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["minlat", "TI"], ",", 
       StyleBox["maxlat", "TI"], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["minlong", "TI"], ",", 
       StyleBox["maxlong", "TI"], "}"}]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["WorldRotatedRange",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldRotatedRange"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "coordinate system to which the range specification is applied; with ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     ", it is applied to the system resulting from ",
     ButtonBox["WorldRotation",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldRotation"]
    }], "TableText"]},
   {
    ButtonBox["WorldRotation",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/WorldRotation"], 
    RowBox[{"{", "0", ",", "0", ",", "0", "}"}], Cell[
    "rotation to be applied to coordinates before projection ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->9543],

Cell[TextData[{
 "More options for ",
 Cell[BoxData[
  ButtonBox["WorldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldPlot"]], "InlineFormula"],
 ". These options can also be used in ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->19469],

Cell[TextData[{
 "To specify how the borders of countries are to be drawn, you set the ",
 Cell[BoxData[
  ButtonBox["WorldBorders",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldBorders"]], "InlineFormula"],
 " option. The settings for this option can be ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", or a style list. With the setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " the borders are drawn with the style ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], ",", " ", 
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", ".001", "]"}]}], "}"}]], 
  "InlineFormula"],
 " unless a style list for the shading of the countries is given. If this is \
the case, no borders are drawn. "
}], "Text",
 CellID->9804],

Cell[TextData[{
 "The style of the frame around the map is controlled by the ",
 Cell[BoxData[
  ButtonBox["WorldFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldFrame"]], "InlineFormula"],
 " option. To determine which portion of the frame is to be drawn, specify ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldFrameParts",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldFrameParts"], " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["3", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["4", "TR"]]}], "}"}]}]], "InlineFormula"],
 ". Each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 " is either ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 " and specifies whether a portion of the frame is drawn (",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ") or not (",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 "). The sides are ordered clockwise, with the eastern side given first. "
}], "Text",
 CellID->22984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorldGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGrid"]], "InlineFormula"],
 " controls the drawing of parallels and meridians. A setting for this option \
of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldGrid"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["deg", "TI"], 
      StyleBox["1", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["deg", "TI"], 
      StyleBox["2", "TR"]]}], "}"}]}]], "InlineFormula"],
 " specifies the spacing of the latitude and longitude lines that are drawn \
beginning with the equator or a prime meridian. A setting of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldGrid"], "->", 
   StyleBox["deg", "TI"]}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldGrid"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["deg", "TI"], ",", " ", 
     StyleBox["deg", "TI"]}], "}"}]}]], "InlineFormula"],
 ". You can explicitly specify which latitude and longitude lines you want \
drawn with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldGrid"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["lat", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["lat", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["lon", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["lon", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 ". The default setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorldGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:WorldPlot/ref/WorldGrid"], "->", "30"}]], 
  "InlineFormula"],
 ". Note that all settings are given in degrees. "
}], "Text",
 CellID->11997],

Cell[TextData[{
 "One of the most time\[Hyphen]intensive parts of the plot is clipping \
polygons or lines that are partially outside the plot range. The way this \
clipping is done is determined by the option ",
 Cell[BoxData[
  ButtonBox["WorldClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldClipping"]], "InlineFormula"],
 ". The default setting ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 " causes these objects to be properly clipped at the edge of the plot range. \
To save rendering time you can reset this option at ",
 Cell[BoxData[
  ButtonBox["Simple",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/Simple"]], "InlineFormula"],
 ", which causes objects outside the plot range to not be rendered, or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", which causes the entire object to be rendered. "
}], "Text",
 CellID->32371],

Cell["\<\
In this map of Africa the background is light gray, there are no grid lines, \
and the frame around the map is somewhat thicker than usual. \
\>", "MathCaption",
 CellID->2784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"afmap", "=", 
  RowBox[{"WorldPlot", "[", 
   RowBox[{"Africa", ",", 
    RowBox[{"WorldBackground", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
    RowBox[{"WorldGrid", "\[Rule]", "None"}], ",", 
    RowBox[{"WorldFrame", "\[Rule]", 
     RowBox[{"Thickness", "[", ".012", "]"}]}], ",", 
    RowBox[{"WorldProjection", "\[Rule]", "LambertCylindrical"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->32001],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.7], 
    PolygonBox[{{3600, 3471.05309230731}, {3600, 3471.05309230731}, {
      3600, 3412.95823439019}, {3600, 3354.19801350288}, {
      3600, 3294.78388506685}, {3600, 3234.72743198416}, {
      3600, 3174.04036237936}, {3600, 3112.73450731688}, {
      3600, 3050.82181849466}, {3600, 2988.31436591406}, {
      3600, 2925.22433552679}, {3600, 2861.56402685931}, {
      3600, 2797.3458506149}, {3600, 2732.58232625428}, {
      3600, 2667.28607955485}, {3600, 2601.46984014926}, {
      3600, 2535.14643904381}, {3600, 2468.32880611695}, {
      3600, 2401.02996759861}, {3600, 2333.2630435307}, {
      3600, 2265.04124520936}, {3600, 2196.37787260932}, {
      3600, 2127.28631179114}, {3600, 2057.78003229148}, {
      3600, 1987.87258449726}, {3600, 1917.57759700394}, {
      3600, 1846.90877395861}, {3600, 1775.87989238835}, {
      3600, 1704.50479951435}, {3600, 1632.7974100524}, {
      3600, 1560.77170350015}, {3600, 1488.4417214118}, {
      3600, 1415.82156466067}, {3600, 1342.92539069022}, {
      3600, 1269.76741075399}, {3600, 1196.36188714512}, {
      3600, 1122.7231304159}, {3600, 1048.86549658785}, {
      3600, 974.803384353024}, {3600, 900.551232266952}, {
      3600, 826.123515933806}, {3600, 751.534745184353}, {
      3600, 676.799461247243}, {3600, 601.932233914158}, {
      3600, 526.947658699407}, {3600, 451.860353994504}, {
      3600, 376.684958218277}, {3600, 301.436126963085}, {
      3600, 226.128530137678}, {3600, 150.776849107272}, {
      3600, 75.3957738313845}, {3600, 0}, {3600, -75.3957738313845}, {
      3600, -150.776849107272}, {3600, -226.128530137678}, {
      3600, -301.436126963085}, {3600, -376.684958218277}, {
      3600, -451.860353994504}, {3600, -526.947658699407}, {
      3600, -601.932233914158}, {3600, -676.799461247243}, {
      3600, -751.534745184353}, {3600, -826.123515933806}, {
      3600, -900.551232266952}, {3600, -974.803384353024}, {
      3600, -1048.86549658785}, {3600, -1122.7231304159}, {
      3600, -1196.36188714512}, {3600, -1269.76741075399}, {
      3600, -1342.92539069022}, {3600, -1415.82156466067}, {
      3600, -1488.4417214118}, {3600, -1560.77170350015}, {
      3600, -1632.7974100524}, {3600, -1704.50479951435}, {
      3600, -1775.87989238835}, {3600, -1846.90877395861}, {
      3600, -1917.57759700394}, {3600, -1987.87258449726}, {
      3600, -2057.78003229148}, {3600, -2127.28631179114}, {
      3600, -2196.37787260932}, {3600, -2265.04124520936}, {
      3600, -2333.2630435307}, {3600, -2401.02996759861}, {
      3600, -2468.32880611695}, {3600, -2535.14643904381}, {
      3600, -2601.46984014926}, {3600, -2667.28607955485}, {
      3600, -2732.58232625428}, {3600, -2797.3458506149}, {
      3600, -2861.56402685931}, {3600, -2925.22433552679}, {
      3600, -2988.31436591406}, {3600, -3050.82181849466}, {
      3600, -3112.73450731688}, {3600, -3174.04036237936}, {
      3600, -3234.72743198416}, {3600, -3294.78388506685}, {
      3600, -3354.19801350288}, {3600, -3412.95823439019}, {
      3600, -3471.05309230731}, {3600, -3471.05309230731}, {
      3600, -3471.05309230731}, {3552, -3471.05309230731}, {
      3504, -3471.05309230731}, {3456, -3471.05309230731}, {
      3408, -3471.05309230731}, {3360, -3471.05309230731}, {
      3312, -3471.05309230731}, {3264, -3471.05309230731}, {
      3216, -3471.05309230731}, {3168, -3471.05309230731}, {
      3120, -3471.05309230731}, {3072, -3471.05309230731}, {
      3024, -3471.05309230731}, {2976, -3471.05309230731}, {
      2928, -3471.05309230731}, {2880, -3471.05309230731}, {
      2832, -3471.05309230731}, {2784, -3471.05309230731}, {
      2736, -3471.05309230731}, {2688, -3471.05309230731}, {
      2640, -3471.05309230731}, {2592, -3471.05309230731}, {
      2544, -3471.05309230731}, {2496, -3471.05309230731}, {
      2448, -3471.05309230731}, {2400, -3471.05309230731}, {
      2352, -3471.05309230731}, {2304, -3471.05309230731}, {
      2256, -3471.05309230731}, {2208, -3471.05309230731}, {
      2160, -3471.05309230731}, {2112, -3471.05309230731}, {
      2064, -3471.05309230731}, {2016, -3471.05309230731}, {
      1968, -3471.05309230731}, {1920, -3471.05309230731}, {
      1872, -3471.05309230731}, {1824, -3471.05309230731}, {
      1776, -3471.05309230731}, {1728, -3471.05309230731}, {
      1680, -3471.05309230731}, {1632, -3471.05309230731}, {
      1584, -3471.05309230731}, {1536, -3471.05309230731}, {
      1488, -3471.05309230731}, {1440, -3471.05309230731}, {
      1392, -3471.05309230731}, {1344, -3471.05309230731}, {
      1296, -3471.05309230731}, {1248, -3471.05309230731}, {
      1200, -3471.05309230731}, {1152, -3471.05309230731}, {
      1104, -3471.05309230731}, {1056, -3471.05309230731}, {
      1008, -3471.05309230731}, {960, -3471.05309230731}, {
      912, -3471.05309230731}, {864, -3471.05309230731}, {
      816, -3471.05309230731}, {768, -3471.05309230731}, {
      720, -3471.05309230731}, {672, -3471.05309230731}, {
      624, -3471.05309230731}, {576, -3471.05309230731}, {
      528, -3471.05309230731}, {480, -3471.05309230731}, {
      432, -3471.05309230731}, {384, -3471.05309230731}, {
      336, -3471.05309230731}, {288, -3471.05309230731}, {
      240, -3471.05309230731}, {192, -3471.05309230731}, {
      144, -3471.05309230731}, {96, -3471.05309230731}, {
      48, -3471.05309230731}, {
      0, -3471.05309230731}, {-48, -3471.05309230731}, {-96, \
-3471.05309230731}, {-144, -3471.05309230731}, {-192, -3471.05309230731}, \
{-240, -3471.05309230731}, {-288, -3471.05309230731}, {-336, \
-3471.05309230731}, {-384, -3471.05309230731}, {-432, -3471.05309230731}, \
{-480, -3471.05309230731}, {-528, -3471.05309230731}, {-576, \
-3471.05309230731}, {-624, -3471.05309230731}, {-672, -3471.05309230731}, \
{-720, -3471.05309230731}, {-768, -3471.05309230731}, {-816, \
-3471.05309230731}, {-864, -3471.05309230731}, {-912, -3471.05309230731}, \
{-960, -3471.05309230731}, {-1008, -3471.05309230731}, {-1056, \
-3471.05309230731}, {-1104, -3471.05309230731}, {-1152, -3471.05309230731}, \
{-1200, -3471.05309230731}, {-1200, -3471.05309230731}, {-1200, \
-3412.95823439019}, {-1200, -3354.19801350288}, {-1200, -3294.78388506685}, \
{-1200, -3234.72743198416}, {-1200, -3174.04036237936}, {-1200, \
-3112.73450731688}, {-1200, -3050.82181849466}, {-1200, -2988.31436591406}, \
{-1200, -2925.22433552679}, {-1200, -2861.56402685931}, {-1200, \
-2797.3458506149}, {-1200, -2732.58232625428}, {-1200, -2667.28607955485}, \
{-1200, -2601.46984014926}, {-1200, -2535.14643904381}, {-1200, \
-2468.32880611695}, {-1200, -2401.02996759861}, {-1200, -2333.2630435307}, \
{-1200, -2265.04124520936}, {-1200, -2196.37787260932}, {-1200, \
-2127.28631179114}, {-1200, -2057.78003229148}, {-1200, -1987.87258449726}, \
{-1200, -1917.57759700394}, {-1200, -1846.90877395861}, {-1200, \
-1775.87989238835}, {-1200, -1704.50479951435}, {-1200, -1632.7974100524}, \
{-1200, -1560.77170350015}, {-1200, -1488.4417214118}, {-1200, \
-1415.82156466067}, {-1200, -1342.92539069022}, {-1200, -1269.76741075399}, \
{-1200, -1196.36188714512}, {-1200, -1122.7231304159}, {-1200, \
-1048.86549658785}, {-1200, -974.803384353024}, {-1200, -900.551232266952}, \
{-1200, -826.123515933806}, {-1200, -751.534745184353}, {-1200, \
-676.799461247243}, {-1200, -601.932233914158}, {-1200, -526.947658699407}, \
{-1200, -451.860353994504}, {-1200, -376.684958218277}, {-1200, \
-301.436126963085}, {-1200, -226.128530137678}, {-1200, -150.776849107272}, \
{-1200, -75.3957738313845}, {-1200, 
      0}, {-1200, 75.3957738313845}, {-1200, 150.776849107272}, {-1200, 
       226.128530137678}, {-1200, 301.436126963085}, {-1200, 
       376.684958218277}, {-1200, 451.860353994504}, {-1200, 
       526.947658699407}, {-1200, 601.932233914158}, {-1200, 
       676.799461247243}, {-1200, 751.534745184353}, {-1200, 
       826.123515933806}, {-1200, 900.551232266952}, {-1200, 
       974.803384353024}, {-1200, 1048.86549658785}, {-1200, 
       1122.7231304159}, {-1200, 1196.36188714512}, {-1200, 
       1269.76741075399}, {-1200, 1342.92539069022}, {-1200, 
       1415.82156466067}, {-1200, 1488.4417214118}, {-1200, 
       1560.77170350015}, {-1200, 1632.7974100524}, {-1200, 
       1704.50479951435}, {-1200, 1775.87989238835}, {-1200, 
       1846.90877395861}, {-1200, 1917.57759700394}, {-1200, 
       1987.87258449726}, {-1200, 2057.78003229148}, {-1200, 
       2127.28631179114}, {-1200, 2196.37787260932}, {-1200, 
       2265.04124520936}, {-1200, 2333.2630435307}, {-1200, 
       2401.02996759861}, {-1200, 2468.32880611695}, {-1200, 
       2535.14643904381}, {-1200, 2601.46984014926}, {-1200, 
       2667.28607955485}, {-1200, 2732.58232625428}, {-1200, 
       2797.3458506149}, {-1200, 2861.56402685931}, {-1200, 
       2925.22433552679}, {-1200, 2988.31436591406}, {-1200, 
       3050.82181849466}, {-1200, 3112.73450731688}, {-1200, 
       3174.04036237936}, {-1200, 3234.72743198416}, {-1200, 
       3294.78388506685}, {-1200, 3354.19801350288}, {-1200, 
       3412.95823439019}, {-1200, 3471.05309230731}, {-1200, 
       3471.05309230731}, {-1200, 3471.05309230731}, {-1152, 
       3471.05309230731}, {-1104, 3471.05309230731}, {-1056, 
       3471.05309230731}, {-1008, 3471.05309230731}, {-960, 
       3471.05309230731}, {-912, 3471.05309230731}, {-864, 
       3471.05309230731}, {-816, 3471.05309230731}, {-768, 
       3471.05309230731}, {-720, 3471.05309230731}, {-672, 
       3471.05309230731}, {-624, 3471.05309230731}, {-576, 
       3471.05309230731}, {-528, 3471.05309230731}, {-480, 
       3471.05309230731}, {-432, 3471.05309230731}, {-384, 
       3471.05309230731}, {-336, 3471.05309230731}, {-288, 
       3471.05309230731}, {-240, 3471.05309230731}, {-192, 
       3471.05309230731}, {-144, 3471.05309230731}, {-96, 
       3471.05309230731}, {-48, 3471.05309230731}, {0, 3471.05309230731}, {
      48, 3471.05309230731}, {96, 3471.05309230731}, {
      144, 3471.05309230731}, {192, 3471.05309230731}, {
      240, 3471.05309230731}, {288, 3471.05309230731}, {
      336, 3471.05309230731}, {384, 3471.05309230731}, {
      432, 3471.05309230731}, {480, 3471.05309230731}, {
      528, 3471.05309230731}, {576, 3471.05309230731}, {
      624, 3471.05309230731}, {672, 3471.05309230731}, {
      720, 3471.05309230731}, {768, 3471.05309230731}, {
      816, 3471.05309230731}, {864, 3471.05309230731}, {
      912, 3471.05309230731}, {960, 3471.05309230731}, {
      1008, 3471.05309230731}, {1056, 3471.05309230731}, {
      1104, 3471.05309230731}, {1152, 3471.05309230731}, {
      1200, 3471.05309230731}, {1248, 3471.05309230731}, {
      1296, 3471.05309230731}, {1344, 3471.05309230731}, {
      1392, 3471.05309230731}, {1440, 3471.05309230731}, {
      1488, 3471.05309230731}, {1536, 3471.05309230731}, {
      1584, 3471.05309230731}, {1632, 3471.05309230731}, {
      1680, 3471.05309230731}, {1728, 3471.05309230731}, {
      1776, 3471.05309230731}, {1824, 3471.05309230731}, {
      1872, 3471.05309230731}, {1920, 3471.05309230731}, {
      1968, 3471.05309230731}, {2016, 3471.05309230731}, {
      2064, 3471.05309230731}, {2112, 3471.05309230731}, {
      2160, 3471.05309230731}, {2208, 3471.05309230731}, {
      2256, 3471.05309230731}, {2304, 3471.05309230731}, {
      2352, 3471.05309230731}, {2400, 3471.05309230731}, {
      2448, 3471.05309230731}, {2496, 3471.05309230731}, {
      2544, 3471.05309230731}, {2592, 3471.05309230731}, {
      2640, 3471.05309230731}, {2688, 3471.05309230731}, {
      2736, 3471.05309230731}, {2784, 3471.05309230731}, {
      2832, 3471.05309230731}, {2880, 3471.05309230731}, {
      2928, 3471.05309230731}, {2976, 3471.05309230731}, {
      3024, 3471.05309230731}, {3072, 3471.05309230731}, {
      3120, 3471.05309230731}, {3168, 3471.05309230731}, {
      3216, 3471.05309230731}, {3264, 3471.05309230731}, {
      3312, 3471.05309230731}, {3360, 3471.05309230731}, {
      3408, 3471.05309230731}, {3456, 3471.05309230731}, {
      3504, 3471.05309230731}, {3552, 3471.05309230731}, {
      3600, 3471.05309230731}, {3600, 3471.05309230731}}]}, {
    {GrayLevel[1], 
     TooltipBox[
      PolygonBox[{{517, 3244.78095137098}, {
        0, 3161.31894235768}, {-133, 3103.74308311347}, {-71, 
         2869.55232939765}, {-229, 2837.54691579025}, {-218, 
         2778.51226350272}, {-520, 2594.58459443247}, {-520, 
         2507.36507616271}, {-520, 2475.31165276552}, {-288, 
         2282.13861339978}, {0, 2008.30289668409}, {255, 1771.42894794786}, {
        720, 2154.68539567287}, {564, 2379.90246734831}, {
        572, 2719.0224513327}, {450, 3010.51968083594}, {
        517, 3244.78095137098}}],
      "\"Algeria\""], 
     TooltipBox[
      PolygonBox[{{791, -551.954653827464}, {735, -573.825985215659}, {
        828, -1104.27867994567}, {706, -1601.32450486808}, {
        831, -1608.8235176078}, {1409, -1635.79167036149}, {
        1320, -1503.53486623716}, {1320, -1214.73569345687}, {
        1441, -1214.73569345687}, {1439, -1018.03030523621}, {
        1330, -1018.03030523621}, {1307, -684.590793292707}, {
        1080, -760.866652462946}, {1019, -681.474433333481}, {
        991, -553.51719965749}, {791, -550.39206129327}}],
      "\"Angola\""], 
     TooltipBox[
      PolygonBox[{{98, 584.758104799124}, {164, 598.810118229931}, {
        214, 1099.66545615696}, {144, 1111.9655157339}, {
        58, 1030.36857503334}, {98, 584.758104799124}}],
      "\"Benin\""], 
     TooltipBox[
      PolygonBox[{{1516, -1650.75464680077}, {1260, -1697.05054452012}, {
        1200, -2022.87560444592}, {1200, -2262.18899499536}, {
        1239, -2437.54244857924}, {1368, -2337.51194021024}, {
        1531, -2338.9278436816}, {1763, -2040.34024881972}, {
        1516, -1650.75464680077}}],
      "\"Botswana\""], 
     TooltipBox[
      PolygonBox[{{-161, 889.707780162161}, {-331, 977.89320011788}, {-238, 
         1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
        144, 1113.5026011418}, {
        58, 1030.36857503334}, {-10, 1042.70126495359}, {-170, 
         1030.36857503334}, {-161, 889.707780162161}}],
      "\"Burkina Faso\""], 
     TooltipBox[
      PolygonBox[{{1741, -259.081894015257}, {1765, -418.981093943756}, {
        1834, -226.128530137678}, {1741, -259.081894015257}}],
      "\"Burundi\""], 
     TooltipBox[
      PolygonBox[{{589, 221.420189217303}, {585, 389.219686517686}, {
        516, 453.425622178119}, {588, 639.381428855105}, {
        713, 665.889194819279}, {879, 1082.74316419852}, {
        844, 1222.38709052735}, {941, 936.153187350014}, {
        837, 903.648677596752}, {930, 707.956034423855}, {
        865, 569.140060142951}, {972, 208.863798798875}, {
        798, 204.154857131711}, {680, 204.154857131711}, {
        589, 221.420189217303}}],
      "\"Cameroon\""], 
     TooltipBox[
      PolygonBox[{{930, 707.956034423855}, {1115, 754.645636715053}, {
        1366, 1025.7423741631}, {1373, 1022.6578060613}, {
        1411, 818.361117322034}, {1647, 472.205809875953}, {
        1340, 389.219686517686}, {1152, 467.511293421359}, {
        1118, 328.094233087995}, {995, 328.094233087995}, {
        972, 208.863798798875}, {865, 569.140060142951}, {
        930, 707.956034423855}}],
      "\"CAR\""], 
     TooltipBox[
      PolygonBox[{{1440, 1802.55703986236}, {960, 2153.24497219633}, {
        900, 2109.94809384208}, {960, 1877.87150205711}, {
        929, 1569.79184543056}, {818, 1280.45204041304}, {
        844, 1222.38709052735}, {941, 936.153187350014}, {
        837, 903.648677596752}, {930, 707.956034423855}, {
        1115, 754.645636715053}, {1366, 1025.7423741631}, {
        1310, 1196.36188714512}, {1376, 1447.62768228824}, {
        1440, 1461.24240826966}, {1440, 1802.55703986236}}],
      "\"Chad\""], 
     TooltipBox[
      PolygonBox[{{670, -371.983905546271}, {722, -472.205809875953}, {
        785, -436.205591111035}, {954, -368.849712831753}, {
        1118, 328.094233087995}, {995, 328.094233087995}, {
        972, 208.863798798875}, {798, 204.154857131711}, {
        790, 116.229951705076}, {870, 87.9607040355678}, {
        867, -179.037963298042}, {695, -219.850704595417}, {
        670, -371.983905546271}}],
      "\"Congo\""], 
     TooltipBox[
      PolygonBox[{{791, -551.954653827464}, {732, -544.141226759291}, {
        786, -436.205591111035}, {954, -368.849712831753}, {
        1118, 328.094233087995}, {1152, 467.511293421359}, {
        1340, 389.219686517686}, {1647, 472.205809875953}, {
        1852, 328.094233087995}, {1878, 199.445759991742}, {
        1776, -130.363429036583}, {1742, -257.512895699638}, {
        1765, -418.981093943756}, {1846, -768.641472578387}, {
        1702, -869.56018778221}, {1702, -1081.20422171256}, {
        1788, -1136.54750303505}, {1788, -1256.02230010298}, {
        1632, -1082.74316419852}, {1439, -1018.03030523621}, {
        1330, -1018.03030523621}, {1307, -684.590793292707}, {
        1080, -760.866652462946}, {1019, -681.474433333481}, {
        991, -553.51719965749}, {791, -551.954653827464}}],
      "\"Democratic Republic of the Congo\""], 
     TooltipBox[
      PolygonBox[{{2597, 1078.1260624095}, {2551, 1079.66518773948}, {
        2587, 1188.70181933527}, {2506, 1078.1260624095}, {
        2577, 1030.36857503334}, {2597, 1078.1260624095}}],
      "\"Djibouti\""], 
     TooltipBox[
      PolygonBox[{{2137, 2121.50977541667}, {1940, 2667.28607955485}, {
        2055, 2512.9281680693}, {2098, 2663.18766612341}, {
        2094, 2657.71996054722}, {2056, 2798.68933528385}, {
        2053, 2808.08709081776}, {1509, 2833.53648294498}, {
        1500, 2022.87560444592}, {2036, 2001.01016255312}, {
        2137, 2121.50977541667}}],
      "\"Egypt\""], 
     TooltipBox[
      PolygonBox[{{588, 94.242994761331}, {589, 221.420189217303}, {
        680, 204.154857131711}, {681, 94.242994761331}, {
        588, 94.242994761331}}],
      "\"Equatorial Guinea\""], 
     TooltipBox[
      PolygonBox[{{2188, 1339.88226985267}, {2220, 1584.81477540078}, {
        2317, 1671.67931922504}, {2383, 1405.20772631382}, {
        2587, 1188.70181933527}, {2560, 1151.89877679309}, {
        2330, 1364.21445200797}, {2188, 1339.88226985267}}],
      "\"Eritrea\""], 
     TooltipBox[
      PolygonBox[{{2188, 1339.88226985267}, {2330, 1364.21445200797}, {
        2560, 1151.89877679309}, {2506, 1078.1260624095}, {
        2577, 1030.36857503334}, {2641, 844.746111217247}, {
        2879, 751.534745184353}, {2697, 461.251384941784}, {
        2514, 375.117972357707}, {2371, 323.39042584595}, {
        2156, 434.639909632171}, {1979, 745.31220007407}, {
        2057, 988.704941954054}, {2169, 1187.16950350532}, {
        2188, 1339.88226985267}}],
      "\"Ethiopia\""], 
     TooltipBox[
      PolygonBox[{{588, 94.242994761331}, {523, -59.6890448789258}, {
        670, -371.983905546271}, {695, -219.850704595417}, {
        867, -179.037963298042}, {870, 87.9607040355678}, {
        790, 116.229951705076}, {798, 204.154857131711}, {
        680, 204.154857131711}, {681, 94.242994761331}, {
        588, 94.242994761331}}],
      "\"Gabon\""], 
     TooltipBox[
      PolygonBox[{{-186, 478.464605144901}, {0, 528.510935927489}, {
        72, 573.825985215659}, {
        0, 993.337293308689}, {-5, 1002.59972308212}, {
        0, 1039.6186192399}, {-9, 1042.70126495359}, {-170, 
         1030.36857503334}, {-161, 889.707780162161}, {-186, 
         478.464605144901}}],
      "\"Ghana\""], 
     TooltipBox[
      PolygonBox[{{-798, 847.848882519074}, {-901, 1025.7423741631}, {-823, 
         1185.6370872219}, {-681, 1165.70659328125}, {-682, 
         1159.57076670214}, {-539, 1159.57076670214}, {-479, 
         951.619321660995}, {-478, 953.165494379191}, {-508, 
         711.070391241948}, {-616, 796.617243867505}, {-673, 
         937.700159401424}, {-798, 847.848882519074}}],
      "\"Guinea\""], 
     TooltipBox[
      PolygonBox[{{-1003, 1151.89877679309}, {-900, 1119.64999927209}, {-930, 
         1061.18969147728}, {-901, 1025.7423741631}, {-823, 
         1185.6370872219}, {-1003, 1151.89877679309}}],
      "\"Guinea-Bissau\""], 
     TooltipBox[
      PolygonBox[{{-452, 409.584094331548}, {-186, 478.464605144901}, {-186, 
         478.464605144901}, {-161, 889.707780162161}, {-161, 
         889.707780162161}, {-331, 979.437983947626}, {-331, 
         977.89320011788}, {-478, 953.165494379191}, {-478, 
         953.165494379191}, {-508, 711.070391241948}, {-508, 
         711.070391241948}, {-451, 409.584094331548}}],
      "\"Cote d'Ivoire\""], 
     TooltipBox[
      PolygonBox[{{2494, -157.057481212802}, {2352, -439.336843206435}, {
        2035, -94.242994761331}, {2102, 180.607888429184}, {
        2040, 397.052825652379}, {2156, 434.639909632171}, {
        2371, 323.39042584595}, {2515, 375.117972357707}, {
        2459, 266.926554101265}, {2494, -157.057481212802}}],
      "\"Kenya\""], 
     TooltipBox[
      PolygonBox[{{-690, 651.857658916043}, {-452, 409.584094331548}, {-508, 
         711.070391241948}, {-616, 796.617243867505}, {-690, 
         651.857658916043}}],
      "\"Liberia\""], 
     TooltipBox[
      PolygonBox[{{692, 2954.21213399624}, {955, 2806.74526623126}, {
        1160, 2723.09283479484}, {1303, 2937.09752777115}, {
        1509, 2833.53648294498}, {1500, 2022.87560444592}, {
        1500, 2022.87560444592}, {1500, 1846.90877395861}, {
        1440, 1802.55703986236}, {960, 2153.24497219633}, {
        898, 2108.50207895224}, {720, 2154.68539567287}, {
        564, 2379.90246734831}, {572, 2719.0224513327}, {
        692, 2954.21213399624}}],
      "\"Libya\""], 
     TooltipBox[
      PolygonBox[{{2599, -2011.2188016591}, {2671, -1842.47987411883}, {
        2668, -1505.04348309984}, {2880, -1376.36949432997}, {
        2957, -1118.11329152481}, {3030, -1426.4295327563}, {
        2978, -1447.62768228824}, {2828, -2280.71489192437}, {
        2644, -2277.86687013947}, {2599, -2011.2188016591}}],
      "\"Madagascar\""], 
     TooltipBox[
      PolygonBox[{{1979, -889.707780162161}, {2060, -912.93917427904}, {
        2097, -1082.74316419852}, {2074, -1246.85410460893}, {
        2155, -1386.99904431572}, {2117, -1590.82019968929}, {
        2072, -1359.65440293531}, {1993, -1307.90231790923}, {
        1979, -889.707780162161}}],
      "\"Malawi\""], 
     TooltipBox[
      PolygonBox[{{255, 1771.42894794786}, {
        0, 2008.30289668409}, {-288, 2282.13861339978}, {-395, 
         2282.13861339978}, {-330, 1443.08723082259}, {-690, 
         1456.70527446827}, {-723, 1373.33142995544}, {-735, 
         1376.36949432997}, {-681, 1165.70659328125}, {-682, 
         1159.57076670214}, {-539, 1159.57076670214}, {-478, 
         953.165494379191}, {-331, 977.89320011788}, {-238, 
         1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
        233, 1462.75453908525}, {255, 1771.42894794786}}],
      "\"Mali\""], 
     TooltipBox[
      PolygonBox[{{-1023, 1914.64043117697}, {-972, 1866.08437707629}, {-992, 
         1492.9709931035}, {-803, 1491.46136203177}, {-723, 
         1371.81222339529}, {-690, 1456.70527446827}, {-330, 
         1443.08723082259}, {-395, 2282.13861339978}, {-288, 
         2282.13861339978}, {-520, 2476.7075942153}, {-520, 
         2367.20419266102}, {-720, 2367.20419266102}, {-786, 
         2101.26933075711}, {-780, 1964.48330674702}, {-1023, 
         1914.64043117697}}],
      "\"Mauritania\""], 
     TooltipBox[
      PolygonBox[{{-132, 3105.0283610337}, {-325, 3167.68300282426}, {-374, 
         3098.59934625873}, {-557, 2905.39116834584}, {-614, 
         2644.03497082848}, {-791, 2507.36507616271}, {-520, 
         2507.36507616271}, {-520, 2594.58459443247}, {-218, 
         2778.51226350272}, {-229, 2837.54691579025}, {-71, 
         2869.55232939765}, {-132, 3105.0283610337}}],
      "\"Morocco\""], 
     TooltipBox[
      PolygonBox[{{2426, -982.527302848187}, {2440, -1423.39928629924}, {
        2074, -1812.91818037868}, {2130, -2204.98448605948}, {
        1969, -2333.2630435307}, {1974, -2438.94400368425}, {
        1928, -2437.54244857924}, {1918, -2362.9678246747}, {
        1878, -2059.23221872404}, {1982, -1849.8605926703}, {
        1979, -1553.25128557259}, {1825, -1455.19264984283}, {
        1993, -1307.90231790923}, {2072, -1359.65440293531}, {
        2117, -1590.82019968929}, {2155, -1386.99904431572}, {
        2074, -1246.85410460893}, {2097, -1082.74316419852}, {
        2426, -982.527302848187}}],
      "\"Mozambique\""], 
     TooltipBox[
      PolygonBox[{{706, -1601.32450486808}, {872, -2082.44342096423}, {
        867, -2121.50977541667}, {989, -2583.55679110253}, {
        1200, -2571.13379166761}, {1200, -2262.18899499536}, {
        1200, -2022.87560444592}, {1260, -1697.05054452012}, {
        1516, -1650.75464680077}, {1409, -1635.79167036149}, {
        831, -1608.8235176078}, {706, -1601.32450486808}}],
      "\"Namibia\""], 
     TooltipBox[
      PolygonBox[{{898, 2108.50207895224}, {719, 2154.68539567287}, {
        255, 1771.42894794786}, {233, 1462.75453908525}, {
        14, 1397.62284355361}, {144, 1113.5026011418}, {
        214, 1099.66545615696}, {216, 1095.05139492517}, {
        293, 1286.55516229006}, {578, 1196.36188714512}, {
        818, 1280.45204041304}, {929, 1569.79184543056}, {
        960, 1877.87150205711}, {898, 2108.50207895224}}],
      "\"Niger\""], 
     TooltipBox[
      PolygonBox[{{515, 451.860353994504}, {366, 401.752307029661}, {
        317, 555.079698651133}, {163, 598.810118229931}, {
        214, 1099.66545615696}, {216, 1095.05139492517}, {
        293, 1286.55516229006}, {578, 1196.36188714512}, {
        818, 1280.45204041304}, {845, 1220.85701746224}, {
        879, 1082.74316419852}, {713, 665.889194819279}, {
        588, 639.381428855105}, {515, 451.860353994504}}],
      "\"Nigeria\""], 
     TooltipBox[
      PolygonBox[{{989, -2583.55679110253}, {1099, -3032.65137663086}, {
        1200, -3083.14299325223}, {1674, -2943.68505250796}, {
        1974, -2438.94400368425}, {1928, -2437.54244857924}, {
        1849, -2434.73871972293}, {1918, -2364.38014744091}, {
        1878, -2059.23221872404}, {1762, -2038.88580840386}, {
        1531, -2338.9278436816}, {1368, -2337.51194021024}, {
        1239, -2437.54244857924}, {1200, -2262.18899499536}, {
        1200, -2571.13379166761}, {989, -2583.55679110253}}],
      "\"South Africa\""], 
     TooltipBox[
      PolygonBox[{{1722, -2586.31505592921}, {1621, -2670.01722689374}, {
        1686, -2754.22998473465}, {1767, -2646.77376229944}, {
        1722, -2586.31505592921}}],
      "\"Lesotho\""], 
     TooltipBox[
      PolygonBox[{{1776, -130.363429036583}, {1741, -259.081894015257}, {
        1834, -226.128530137678}, {1829, -100.52515789574}, {
        1776, -130.363429036583}}],
      "\"Rwanda\""], 
     TooltipBox[
      PolygonBox[{{-992, 1494.48049784607}, {-1052, 1374.85052030985}, {-994, 
         1268.24060428473}, {-828, 1249.91059316788}, {-1005, 
         1220.85701746224}, {-923, 1199.42520655736}, {-1003, 
         1151.89877679309}, {-823, 1185.6370872219}, {-681, 
         1165.70659328125}, {-735, 1376.36949432997}, {-723, 
         1371.81222339529}, {-803, 1491.46136203177}, {-992, 
         1492.9709931035}}],
      "\"Senegal\""], 
     TooltipBox[
      PolygonBox[{{-798, 847.848882519074}, {-689, 651.857658916043}, {-615, 
         796.617243867505}, {-673, 937.700159401424}, {-798, 
         847.848882519074}}],
      "\"Sierra Leone\""], 
     TooltipBox[
      PolygonBox[{{2493, -157.057481212802}, {2877, 420.547137235123}, {
        3085, 979.437983947626}, {3047, 1122.7231304159}, {
        2695, 976.348333542772}, {2597, 1078.1260624095}, {
        2595, 1075.04753819981}, {2577, 1030.36857503334}, {
        2641, 844.746111217247}, {2879, 751.534745184353}, {
        2697, 461.251384941784}, {2514, 375.117972357707}, {
        2459, 266.926554101265}, {2493, -157.057481212802}}],
      "\"Somalia\""], 
     TooltipBox[
      PolygonBox[{{2317, 1671.67931922504}, {2214, 2025.78809593257}, {
        2137, 2121.50977541667}, {2036, 2001.01016255312}, {
        1500, 2022.87560444592}, {1500, 1846.90877395861}, {
        1440, 1802.55703986236}, {1440, 1461.24240826966}, {
        1376, 1447.62768228824}, {1310, 1196.36188714512}, {
        1366, 1025.7423741631}, {1373, 1022.6578060613}, {
        1411, 818.361117322034}, {1647, 472.205809875953}, {
        1852, 328.094233087995}, {2040, 397.052825652379}, {
        2156, 434.639909632171}, {1979, 745.31220007407}, {
        2057, 988.704941954054}, {2169, 1187.16950350532}, {
        2220, 1584.81477540078}, {2317, 1671.67931922504}}],
      "\"Sudan\""], 
     TooltipBox[
      PolygonBox[{{1928, -2437.54244857924}, {1918, -2362.9678246747}, {
        1849, -2434.73871972293}, {1928, -2437.54244857924}}],
      "\"Swaziland\""], 
     TooltipBox[
      PolygonBox[{{2426, -982.527302848187}, {2327, -569.140060142951}, {
        2352, -439.336843206435}, {2035, -94.242994761331}, {
        1829, -100.52515789574}, {1834, -226.128530137678}, {
        1765, -418.981093943756}, {1846, -768.641472578387}, {
        1979, -883.509862696526}, {2060, -912.93917427904}, {
        2098, -1082.74316419852}, {2426, -982.527302848187}}],
      "\"Tanzania\""], 
     TooltipBox[
      PolygonBox[{{-994, 1268.24060428473}, {-918, 1256.02230010298}, {-1005, 
         1217.79656154958}, {-1005, 1220.85701746224}, {-828, 
         1249.91059316788}, {-994, 1268.24060428473}}],
      "\"The Gambia\""], 
     TooltipBox[
      PolygonBox[{{72, 573.825985215659}, {99, 584.758104799124}, {
        55, 1030.36857503334}, {-10, 1042.70126495359}, {
        0, 1039.6186192399}, {-5, 1002.59972308212}, {0, 993.337293308689}, {
        72, 573.825985215659}}],
      "\"Togo\""], 
     TooltipBox[
      PolygonBox[{{517, 3244.78095137098}, {663, 3256.07015412574}, {
        600, 3032.65137663086}, {692, 2954.21213399624}, {
        572, 2719.0224513327}, {450, 3010.51968083594}, {
        517, 3244.78095137098}}],
      "\"Tunisia\""], 
     TooltipBox[
      PolygonBox[{{1852, 328.094233087995}, {1878, 199.445759991742}, {
        1776, -130.363429036583}, {1829, -100.52515789574}, {
        2035, -94.242994761331}, {2102, 180.607888429184}, {
        2040, 397.052825652379}, {1852, 328.094233087995}}],
      "\"Uganda\""], 
     TooltipBox[
      PolygonBox[{{-791, 2507.36507616271}, {-1023, 1914.64043117697}, {-780, 
         1964.48330674702}, {-786, 2101.26933075711}, {-720, 
         2367.20419266102}, {-520, 2367.20419266102}, {-520, 
         2476.7075942153}, {-520, 2507.36507616271}, {-791, 
         2507.36507616271}}],
      "\"Western Sahara\""], 
     TooltipBox[
      PolygonBox[{{1846, -768.641472578387}, {1702, -869.56018778221}, {
        1702, -1081.20422171256}, {1788, -1136.54750303505}, {
        1788, -1256.02230010298}, {1632, -1082.74316419852}, {
        1439, -1018.03030523621}, {1441, -1214.73569345687}, {
        1320, -1214.73569345687}, {1320, -1503.53486623716}, {
        1409, -1635.79167036149}, {1516, -1650.75464680077}, {
        1629, -1650.75464680077}, {1825, -1455.19264984283}, {
        1993, -1307.90231790923}, {1979, -889.707780162161}, {
        1979, -883.509862696526}, {1846, -770.196242009763}}],
      "\"Zambia\""], 
     TooltipBox[
      PolygonBox[{{1878, -2059.23221872404}, {1762, -2038.88580840386}, {
        1516, -1650.75464680077}, {1629, -1650.75464680077}, {
        1825, -1455.19264984283}, {1979, -1553.25128557259}, {
        1982, -1849.8605926703}, {1878, -2059.23221872404}}],
      "\"Zimbabwe\""]}, 
    {GrayLevel[0], Thickness[0.001], 
     LineBox[{{517, 3244.78095137098}, {
       0, 3161.31894235768}, {-133, 3103.74308311347}, {-71, 
        2869.55232939765}, {-229, 2837.54691579025}, {-218, 
        2778.51226350272}, {-520, 2594.58459443247}, {-520, 
        2507.36507616271}, {-520, 2475.31165276552}, {-288, 
        2282.13861339978}, {0, 2008.30289668409}, {255, 1771.42894794786}, {
       720, 2154.68539567287}, {564, 2379.90246734831}, {
       572, 2719.0224513327}, {450, 3010.51968083594}, {
       517, 3244.78095137098}}], 
     LineBox[{{791, -551.954653827464}, {735, -573.825985215659}, {
       828, -1104.27867994567}, {706, -1601.32450486808}, {
       831, -1608.8235176078}, {1409, -1635.79167036149}, {
       1320, -1503.53486623716}, {1320, -1214.73569345687}, {
       1441, -1214.73569345687}, {1439, -1018.03030523621}, {
       1330, -1018.03030523621}, {1307, -684.590793292707}, {
       1080, -760.866652462946}, {1019, -681.474433333481}, {
       991, -553.51719965749}, {791, -550.39206129327}}], 
     LineBox[{{98, 584.758104799124}, {164, 598.810118229931}, {
       214, 1099.66545615696}, {144, 1111.9655157339}, {
       58, 1030.36857503334}, {98, 584.758104799124}}], 
     LineBox[{{1516, -1650.75464680077}, {1260, -1697.05054452012}, {
       1200, -2022.87560444592}, {1200, -2262.18899499536}, {
       1239, -2437.54244857924}, {1368, -2337.51194021024}, {
       1531, -2338.9278436816}, {1763, -2040.34024881972}, {
       1516, -1650.75464680077}}], 
     LineBox[{{-161, 889.707780162161}, {-331, 977.89320011788}, {-238, 
        1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
       144, 1113.5026011418}, {
       58, 1030.36857503334}, {-10, 1042.70126495359}, {-170, 
        1030.36857503334}, {-161, 889.707780162161}}], 
     LineBox[{{1741, -259.081894015257}, {1765, -418.981093943756}, {
       1834, -226.128530137678}, {1741, -259.081894015257}}], 
     LineBox[{{589, 221.420189217303}, {585, 389.219686517686}, {
       516, 453.425622178119}, {588, 639.381428855105}, {
       713, 665.889194819279}, {879, 1082.74316419852}, {
       844, 1222.38709052735}, {941, 936.153187350014}, {
       837, 903.648677596752}, {930, 707.956034423855}, {
       865, 569.140060142951}, {972, 208.863798798875}, {
       798, 204.154857131711}, {680, 204.154857131711}, {
       589, 221.420189217303}}], 
     LineBox[{{930, 707.956034423855}, {1115, 754.645636715053}, {
       1366, 1025.7423741631}, {1373, 1022.6578060613}, {
       1411, 818.361117322034}, {1647, 472.205809875953}, {
       1340, 389.219686517686}, {1152, 467.511293421359}, {
       1118, 328.094233087995}, {995, 328.094233087995}, {
       972, 208.863798798875}, {865, 569.140060142951}, {
       930, 707.956034423855}}], 
     LineBox[{{1440, 1802.55703986236}, {960, 2153.24497219633}, {
       900, 2109.94809384208}, {960, 1877.87150205711}, {
       929, 1569.79184543056}, {818, 1280.45204041304}, {
       844, 1222.38709052735}, {941, 936.153187350014}, {
       837, 903.648677596752}, {930, 707.956034423855}, {
       1115, 754.645636715053}, {1366, 1025.7423741631}, {
       1310, 1196.36188714512}, {1376, 1447.62768228824}, {
       1440, 1461.24240826966}, {1440, 1802.55703986236}}], 
     LineBox[{{670, -371.983905546271}, {722, -472.205809875953}, {
       785, -436.205591111035}, {954, -368.849712831753}, {
       1118, 328.094233087995}, {995, 328.094233087995}, {
       972, 208.863798798875}, {798, 204.154857131711}, {
       790, 116.229951705076}, {870, 87.9607040355678}, {
       867, -179.037963298042}, {695, -219.850704595417}, {
       670, -371.983905546271}}], 
     LineBox[{{791, -551.954653827464}, {732, -544.141226759291}, {
       786, -436.205591111035}, {954, -368.849712831753}, {
       1118, 328.094233087995}, {1152, 467.511293421359}, {
       1340, 389.219686517686}, {1647, 472.205809875953}, {
       1852, 328.094233087995}, {1878, 199.445759991742}, {
       1776, -130.363429036583}, {1742, -257.512895699638}, {
       1765, -418.981093943756}, {1846, -768.641472578387}, {
       1702, -869.56018778221}, {1702, -1081.20422171256}, {
       1788, -1136.54750303505}, {1788, -1256.02230010298}, {
       1632, -1082.74316419852}, {1439, -1018.03030523621}, {
       1330, -1018.03030523621}, {1307, -684.590793292707}, {
       1080, -760.866652462946}, {1019, -681.474433333481}, {
       991, -553.51719965749}, {791, -551.954653827464}}], 
     LineBox[{{2597, 1078.1260624095}, {2551, 1079.66518773948}, {
       2587, 1188.70181933527}, {2506, 1078.1260624095}, {
       2577, 1030.36857503334}, {2597, 1078.1260624095}}], 
     LineBox[{{2137, 2121.50977541667}, {1940, 2667.28607955485}, {
       2055, 2512.9281680693}, {2098, 2663.18766612341}, {
       2094, 2657.71996054722}, {2056, 2798.68933528385}, {
       2053, 2808.08709081776}, {1509, 2833.53648294498}, {
       1500, 2022.87560444592}, {2036, 2001.01016255312}, {
       2137, 2121.50977541667}}], 
     LineBox[{{588, 94.242994761331}, {589, 221.420189217303}, {
       680, 204.154857131711}, {681, 94.242994761331}, {
       588, 94.242994761331}}], 
     LineBox[{{2188, 1339.88226985267}, {2220, 1584.81477540078}, {
       2317, 1671.67931922504}, {2383, 1405.20772631382}, {
       2587, 1188.70181933527}, {2560, 1151.89877679309}, {
       2330, 1364.21445200797}, {2188, 1339.88226985267}}], 
     LineBox[{{2188, 1339.88226985267}, {2330, 1364.21445200797}, {
       2560, 1151.89877679309}, {2506, 1078.1260624095}, {
       2577, 1030.36857503334}, {2641, 844.746111217247}, {
       2879, 751.534745184353}, {2697, 461.251384941784}, {
       2514, 375.117972357707}, {2371, 323.39042584595}, {
       2156, 434.639909632171}, {1979, 745.31220007407}, {
       2057, 988.704941954054}, {2169, 1187.16950350532}, {
       2188, 1339.88226985267}}], 
     LineBox[{{588, 94.242994761331}, {523, -59.6890448789258}, {
       670, -371.983905546271}, {695, -219.850704595417}, {
       867, -179.037963298042}, {870, 87.9607040355678}, {
       790, 116.229951705076}, {798, 204.154857131711}, {
       680, 204.154857131711}, {681, 94.242994761331}, {
       588, 94.242994761331}}], 
     LineBox[{{-186, 478.464605144901}, {0, 528.510935927489}, {
       72, 573.825985215659}, {0, 993.337293308689}, {-5, 1002.59972308212}, {
       0, 1039.6186192399}, {-9, 1042.70126495359}, {-170, 
        1030.36857503334}, {-161, 889.707780162161}, {-186, 
        478.464605144901}}], 
     LineBox[{{-798, 847.848882519074}, {-901, 1025.7423741631}, {-823, 
        1185.6370872219}, {-681, 1165.70659328125}, {-682, 
        1159.57076670214}, {-539, 1159.57076670214}, {-479, 
        951.619321660995}, {-478, 953.165494379191}, {-508, 
        711.070391241948}, {-616, 796.617243867505}, {-673, 
        937.700159401424}, {-798, 847.848882519074}}], 
     LineBox[{{-1003, 1151.89877679309}, {-900, 1119.64999927209}, {-930, 
        1061.18969147728}, {-901, 1025.7423741631}, {-823, 
        1185.6370872219}, {-1003, 1151.89877679309}}], 
     LineBox[{{-452, 409.584094331548}, {-186, 478.464605144901}, {-186, 
        478.464605144901}, {-161, 889.707780162161}, {-161, 
        889.707780162161}, {-331, 979.437983947626}, {-331, 
        977.89320011788}, {-478, 953.165494379191}, {-478, 
        953.165494379191}, {-508, 711.070391241948}, {-508, 
        711.070391241948}, {-451, 409.584094331548}}], 
     LineBox[{{2494, -157.057481212802}, {2352, -439.336843206435}, {
       2035, -94.242994761331}, {2102, 180.607888429184}, {
       2040, 397.052825652379}, {2156, 434.639909632171}, {
       2371, 323.39042584595}, {2515, 375.117972357707}, {
       2459, 266.926554101265}, {2494, -157.057481212802}}], 
     LineBox[{{-690, 651.857658916043}, {-452, 409.584094331548}, {-508, 
        711.070391241948}, {-616, 796.617243867505}, {-690, 
        651.857658916043}}], 
     LineBox[{{692, 2954.21213399624}, {955, 2806.74526623126}, {
       1160, 2723.09283479484}, {1303, 2937.09752777115}, {
       1509, 2833.53648294498}, {1500, 2022.87560444592}, {
       1500, 2022.87560444592}, {1500, 1846.90877395861}, {
       1440, 1802.55703986236}, {960, 2153.24497219633}, {
       898, 2108.50207895224}, {720, 2154.68539567287}, {
       564, 2379.90246734831}, {572, 2719.0224513327}, {
       692, 2954.21213399624}}], 
     LineBox[{{2599, -2011.2188016591}, {2671, -1842.47987411883}, {
       2668, -1505.04348309984}, {2880, -1376.36949432997}, {
       2957, -1118.11329152481}, {3030, -1426.4295327563}, {
       2978, -1447.62768228824}, {2828, -2280.71489192437}, {
       2644, -2277.86687013947}, {2599, -2011.2188016591}}], 
     LineBox[{{1979, -889.707780162161}, {2060, -912.93917427904}, {
       2097, -1082.74316419852}, {2074, -1246.85410460893}, {
       2155, -1386.99904431572}, {2117, -1590.82019968929}, {
       2072, -1359.65440293531}, {1993, -1307.90231790923}, {
       1979, -889.707780162161}}], 
     LineBox[{{255, 1771.42894794786}, {
       0, 2008.30289668409}, {-288, 2282.13861339978}, {-395, 
        2282.13861339978}, {-330, 1443.08723082259}, {-690, 
        1456.70527446827}, {-723, 1373.33142995544}, {-735, 
        1376.36949432997}, {-681, 1165.70659328125}, {-682, 
        1159.57076670214}, {-539, 1159.57076670214}, {-478, 
        953.165494379191}, {-331, 977.89320011788}, {-238, 
        1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
       233, 1462.75453908525}, {255, 1771.42894794786}}], 
     LineBox[{{-1023, 1914.64043117697}, {-972, 1866.08437707629}, {-992, 
        1492.9709931035}, {-803, 1491.46136203177}, {-723, 
        1371.81222339529}, {-690, 1456.70527446827}, {-330, 
        1443.08723082259}, {-395, 2282.13861339978}, {-288, 
        2282.13861339978}, {-520, 2476.7075942153}, {-520, 
        2367.20419266102}, {-720, 2367.20419266102}, {-786, 
        2101.26933075711}, {-780, 1964.48330674702}, {-1023, 
        1914.64043117697}}], 
     LineBox[{{-132, 3105.0283610337}, {-325, 3167.68300282426}, {-374, 
        3098.59934625873}, {-557, 2905.39116834584}, {-614, 
        2644.03497082848}, {-791, 2507.36507616271}, {-520, 
        2507.36507616271}, {-520, 2594.58459443247}, {-218, 
        2778.51226350272}, {-229, 2837.54691579025}, {-71, 
        2869.55232939765}, {-132, 3105.0283610337}}], 
     LineBox[{{2426, -982.527302848187}, {2440, -1423.39928629924}, {
       2074, -1812.91818037868}, {2130, -2204.98448605948}, {
       1969, -2333.2630435307}, {1974, -2438.94400368425}, {
       1928, -2437.54244857924}, {1918, -2362.9678246747}, {
       1878, -2059.23221872404}, {1982, -1849.8605926703}, {
       1979, -1553.25128557259}, {1825, -1455.19264984283}, {
       1993, -1307.90231790923}, {2072, -1359.65440293531}, {
       2117, -1590.82019968929}, {2155, -1386.99904431572}, {
       2074, -1246.85410460893}, {2097, -1082.74316419852}, {
       2426, -982.527302848187}}], 
     LineBox[{{706, -1601.32450486808}, {872, -2082.44342096423}, {
       867, -2121.50977541667}, {989, -2583.55679110253}, {
       1200, -2571.13379166761}, {1200, -2262.18899499536}, {
       1200, -2022.87560444592}, {1260, -1697.05054452012}, {
       1516, -1650.75464680077}, {1409, -1635.79167036149}, {
       831, -1608.8235176078}, {706, -1601.32450486808}}], 
     LineBox[{{898, 2108.50207895224}, {719, 2154.68539567287}, {
       255, 1771.42894794786}, {233, 1462.75453908525}, {
       14, 1397.62284355361}, {144, 1113.5026011418}, {
       214, 1099.66545615696}, {216, 1095.05139492517}, {
       293, 1286.55516229006}, {578, 1196.36188714512}, {
       818, 1280.45204041304}, {929, 1569.79184543056}, {
       960, 1877.87150205711}, {898, 2108.50207895224}}], 
     LineBox[{{515, 451.860353994504}, {366, 401.752307029661}, {
       317, 555.079698651133}, {163, 598.810118229931}, {
       214, 1099.66545615696}, {216, 1095.05139492517}, {
       293, 1286.55516229006}, {578, 1196.36188714512}, {
       818, 1280.45204041304}, {845, 1220.85701746224}, {
       879, 1082.74316419852}, {713, 665.889194819279}, {
       588, 639.381428855105}, {515, 451.860353994504}}], 
     LineBox[{{989, -2583.55679110253}, {1099, -3032.65137663086}, {
       1200, -3083.14299325223}, {1674, -2943.68505250796}, {
       1974, -2438.94400368425}, {1928, -2437.54244857924}, {
       1849, -2434.73871972293}, {1918, -2364.38014744091}, {
       1878, -2059.23221872404}, {1762, -2038.88580840386}, {
       1531, -2338.9278436816}, {1368, -2337.51194021024}, {
       1239, -2437.54244857924}, {1200, -2262.18899499536}, {
       1200, -2571.13379166761}, {989, -2583.55679110253}}], 
     LineBox[{{1722, -2586.31505592921}, {1621, -2670.01722689374}, {
       1686, -2754.22998473465}, {1767, -2646.77376229944}, {
       1722, -2586.31505592921}}], 
     LineBox[{{1776, -130.363429036583}, {1741, -259.081894015257}, {
       1834, -226.128530137678}, {1829, -100.52515789574}, {
       1776, -130.363429036583}}], 
     LineBox[{{-992, 1494.48049784607}, {-1052, 1374.85052030985}, {-994, 
        1268.24060428473}, {-828, 1249.91059316788}, {-1005, 
        1220.85701746224}, {-923, 1199.42520655736}, {-1003, 
        1151.89877679309}, {-823, 1185.6370872219}, {-681, 
        1165.70659328125}, {-735, 1376.36949432997}, {-723, 
        1371.81222339529}, {-803, 1491.46136203177}, {-992, 
        1492.9709931035}}], 
     LineBox[{{-798, 847.848882519074}, {-689, 651.857658916043}, {-615, 
        796.617243867505}, {-673, 937.700159401424}, {-798, 
        847.848882519074}}], 
     LineBox[{{2493, -157.057481212802}, {2877, 420.547137235123}, {
       3085, 979.437983947626}, {3047, 1122.7231304159}, {
       2695, 976.348333542772}, {2597, 1078.1260624095}, {
       2595, 1075.04753819981}, {2577, 1030.36857503334}, {
       2641, 844.746111217247}, {2879, 751.534745184353}, {
       2697, 461.251384941784}, {2514, 375.117972357707}, {
       2459, 266.926554101265}, {2493, -157.057481212802}}], 
     LineBox[{{2317, 1671.67931922504}, {2214, 2025.78809593257}, {
       2137, 2121.50977541667}, {2036, 2001.01016255312}, {
       1500, 2022.87560444592}, {1500, 1846.90877395861}, {
       1440, 1802.55703986236}, {1440, 1461.24240826966}, {
       1376, 1447.62768228824}, {1310, 1196.36188714512}, {
       1366, 1025.7423741631}, {1373, 1022.6578060613}, {
       1411, 818.361117322034}, {1647, 472.205809875953}, {
       1852, 328.094233087995}, {2040, 397.052825652379}, {
       2156, 434.639909632171}, {1979, 745.31220007407}, {
       2057, 988.704941954054}, {2169, 1187.16950350532}, {
       2220, 1584.81477540078}, {2317, 1671.67931922504}}], 
     LineBox[{{1928, -2437.54244857924}, {1918, -2362.9678246747}, {
       1849, -2434.73871972293}, {1928, -2437.54244857924}}], 
     LineBox[{{2426, -982.527302848187}, {2327, -569.140060142951}, {
       2352, -439.336843206435}, {2035, -94.242994761331}, {
       1829, -100.52515789574}, {1834, -226.128530137678}, {
       1765, -418.981093943756}, {1846, -768.641472578387}, {
       1979, -883.509862696526}, {2060, -912.93917427904}, {
       2098, -1082.74316419852}, {2426, -982.527302848187}}], 
     LineBox[{{-994, 1268.24060428473}, {-918, 1256.02230010298}, {-1005, 
        1217.79656154958}, {-1005, 1220.85701746224}, {-828, 
        1249.91059316788}, {-994, 1268.24060428473}}], 
     LineBox[{{72, 573.825985215659}, {99, 584.758104799124}, {
       55, 1030.36857503334}, {-10, 1042.70126495359}, {
       0, 1039.6186192399}, {-5, 1002.59972308212}, {0, 993.337293308689}, {
       72, 573.825985215659}}], 
     LineBox[{{517, 3244.78095137098}, {663, 3256.07015412574}, {
       600, 3032.65137663086}, {692, 2954.21213399624}, {
       572, 2719.0224513327}, {450, 3010.51968083594}, {
       517, 3244.78095137098}}], 
     LineBox[{{1852, 328.094233087995}, {1878, 199.445759991742}, {
       1776, -130.363429036583}, {1829, -100.52515789574}, {
       2035, -94.242994761331}, {2102, 180.607888429184}, {
       2040, 397.052825652379}, {1852, 328.094233087995}}], 
     LineBox[{{-791, 2507.36507616271}, {-1023, 1914.64043117697}, {-780, 
        1964.48330674702}, {-786, 2101.26933075711}, {-720, 
        2367.20419266102}, {-520, 2367.20419266102}, {-520, 
        2476.7075942153}, {-520, 2507.36507616271}, {-791, 
        2507.36507616271}}], 
     LineBox[{{1846, -768.641472578387}, {1702, -869.56018778221}, {
       1702, -1081.20422171256}, {1788, -1136.54750303505}, {
       1788, -1256.02230010298}, {1632, -1082.74316419852}, {
       1439, -1018.03030523621}, {1441, -1214.73569345687}, {
       1320, -1214.73569345687}, {1320, -1503.53486623716}, {
       1409, -1635.79167036149}, {1516, -1650.75464680077}, {
       1629, -1650.75464680077}, {1825, -1455.19264984283}, {
       1993, -1307.90231790923}, {1979, -889.707780162161}, {
       1979, -883.509862696526}, {1846, -770.196242009763}}], 
     LineBox[{{1878, -2059.23221872404}, {1762, -2038.88580840386}, {
       1516, -1650.75464680077}, {1629, -1650.75464680077}, {
       1825, -1455.19264984283}, {1979, -1553.25128557259}, {
       1982, -1849.8605926703}, {1878, -2059.23221872404}}]}}, 
   {Thickness[0.012], 
    LineBox[{{3600, 3471.05309230731}, {3600, 3471.05309230731}, {
      3600, 3412.95823439019}, {3600, 3354.19801350288}, {
      3600, 3294.78388506685}, {3600, 3234.72743198416}, {
      3600, 3174.04036237936}, {3600, 3112.73450731688}, {
      3600, 3050.82181849466}, {3600, 2988.31436591406}, {
      3600, 2925.22433552679}, {3600, 2861.56402685931}, {
      3600, 2797.3458506149}, {3600, 2732.58232625428}, {
      3600, 2667.28607955485}, {3600, 2601.46984014926}, {
      3600, 2535.14643904381}, {3600, 2468.32880611695}, {
      3600, 2401.02996759861}, {3600, 2333.2630435307}, {
      3600, 2265.04124520936}, {3600, 2196.37787260932}, {
      3600, 2127.28631179114}, {3600, 2057.78003229148}, {
      3600, 1987.87258449726}, {3600, 1917.57759700394}, {
      3600, 1846.90877395861}, {3600, 1775.87989238835}, {
      3600, 1704.50479951435}, {3600, 1632.7974100524}, {
      3600, 1560.77170350015}, {3600, 1488.4417214118}, {
      3600, 1415.82156466067}, {3600, 1342.92539069022}, {
      3600, 1269.76741075399}, {3600, 1196.36188714512}, {
      3600, 1122.7231304159}, {3600, 1048.86549658785}, {
      3600, 974.803384353024}, {3600, 900.551232266952}, {
      3600, 826.123515933806}, {3600, 751.534745184353}, {
      3600, 676.799461247243}, {3600, 601.932233914158}, {
      3600, 526.947658699407}, {3600, 451.860353994504}, {
      3600, 376.684958218277}, {3600, 301.436126963085}, {
      3600, 226.128530137678}, {3600, 150.776849107272}, {
      3600, 75.3957738313845}, {3600, 0}, {3600, -75.3957738313845}, {
      3600, -150.776849107272}, {3600, -226.128530137678}, {
      3600, -301.436126963085}, {3600, -376.684958218277}, {
      3600, -451.860353994504}, {3600, -526.947658699407}, {
      3600, -601.932233914158}, {3600, -676.799461247243}, {
      3600, -751.534745184353}, {3600, -826.123515933806}, {
      3600, -900.551232266952}, {3600, -974.803384353024}, {
      3600, -1048.86549658785}, {3600, -1122.7231304159}, {
      3600, -1196.36188714512}, {3600, -1269.76741075399}, {
      3600, -1342.92539069022}, {3600, -1415.82156466067}, {
      3600, -1488.4417214118}, {3600, -1560.77170350015}, {
      3600, -1632.7974100524}, {3600, -1704.50479951435}, {
      3600, -1775.87989238835}, {3600, -1846.90877395861}, {
      3600, -1917.57759700394}, {3600, -1987.87258449726}, {
      3600, -2057.78003229148}, {3600, -2127.28631179114}, {
      3600, -2196.37787260932}, {3600, -2265.04124520936}, {
      3600, -2333.2630435307}, {3600, -2401.02996759861}, {
      3600, -2468.32880611695}, {3600, -2535.14643904381}, {
      3600, -2601.46984014926}, {3600, -2667.28607955485}, {
      3600, -2732.58232625428}, {3600, -2797.3458506149}, {
      3600, -2861.56402685931}, {3600, -2925.22433552679}, {
      3600, -2988.31436591406}, {3600, -3050.82181849466}, {
      3600, -3112.73450731688}, {3600, -3174.04036237936}, {
      3600, -3234.72743198416}, {3600, -3294.78388506685}, {
      3600, -3354.19801350288}, {3600, -3412.95823439019}, {
      3600, -3471.05309230731}}], 
    LineBox[{{3600, -3471.05309230731}, {3600, -3471.05309230731}, {
      3552, -3471.05309230731}, {3504, -3471.05309230731}, {
      3456, -3471.05309230731}, {3408, -3471.05309230731}, {
      3360, -3471.05309230731}, {3312, -3471.05309230731}, {
      3264, -3471.05309230731}, {3216, -3471.05309230731}, {
      3168, -3471.05309230731}, {3120, -3471.05309230731}, {
      3072, -3471.05309230731}, {3024, -3471.05309230731}, {
      2976, -3471.05309230731}, {2928, -3471.05309230731}, {
      2880, -3471.05309230731}, {2832, -3471.05309230731}, {
      2784, -3471.05309230731}, {2736, -3471.05309230731}, {
      2688, -3471.05309230731}, {2640, -3471.05309230731}, {
      2592, -3471.05309230731}, {2544, -3471.05309230731}, {
      2496, -3471.05309230731}, {2448, -3471.05309230731}, {
      2400, -3471.05309230731}, {2352, -3471.05309230731}, {
      2304, -3471.05309230731}, {2256, -3471.05309230731}, {
      2208, -3471.05309230731}, {2160, -3471.05309230731}, {
      2112, -3471.05309230731}, {2064, -3471.05309230731}, {
      2016, -3471.05309230731}, {1968, -3471.05309230731}, {
      1920, -3471.05309230731}, {1872, -3471.05309230731}, {
      1824, -3471.05309230731}, {1776, -3471.05309230731}, {
      1728, -3471.05309230731}, {1680, -3471.05309230731}, {
      1632, -3471.05309230731}, {1584, -3471.05309230731}, {
      1536, -3471.05309230731}, {1488, -3471.05309230731}, {
      1440, -3471.05309230731}, {1392, -3471.05309230731}, {
      1344, -3471.05309230731}, {1296, -3471.05309230731}, {
      1248, -3471.05309230731}, {1200, -3471.05309230731}, {
      1152, -3471.05309230731}, {1104, -3471.05309230731}, {
      1056, -3471.05309230731}, {1008, -3471.05309230731}, {
      960, -3471.05309230731}, {912, -3471.05309230731}, {
      864, -3471.05309230731}, {816, -3471.05309230731}, {
      768, -3471.05309230731}, {720, -3471.05309230731}, {
      672, -3471.05309230731}, {624, -3471.05309230731}, {
      576, -3471.05309230731}, {528, -3471.05309230731}, {
      480, -3471.05309230731}, {432, -3471.05309230731}, {
      384, -3471.05309230731}, {336, -3471.05309230731}, {
      288, -3471.05309230731}, {240, -3471.05309230731}, {
      192, -3471.05309230731}, {144, -3471.05309230731}, {
      96, -3471.05309230731}, {48, -3471.05309230731}, {
      0, -3471.05309230731}, {-48, -3471.05309230731}, {-96, \
-3471.05309230731}, {-144, -3471.05309230731}, {-192, -3471.05309230731}, \
{-240, -3471.05309230731}, {-288, -3471.05309230731}, {-336, \
-3471.05309230731}, {-384, -3471.05309230731}, {-432, -3471.05309230731}, \
{-480, -3471.05309230731}, {-528, -3471.05309230731}, {-576, \
-3471.05309230731}, {-624, -3471.05309230731}, {-672, -3471.05309230731}, \
{-720, -3471.05309230731}, {-768, -3471.05309230731}, {-816, \
-3471.05309230731}, {-864, -3471.05309230731}, {-912, -3471.05309230731}, \
{-960, -3471.05309230731}, {-1008, -3471.05309230731}, {-1056, \
-3471.05309230731}, {-1104, -3471.05309230731}, {-1152, -3471.05309230731}, \
{-1200, -3471.05309230731}}], 
    LineBox[{{-1200, -3471.05309230731}, {-1200, -3412.95823439019}, {-1200, \
-3354.19801350288}, {-1200, -3294.78388506685}, {-1200, -3234.72743198416}, \
{-1200, -3174.04036237936}, {-1200, -3112.73450731688}, {-1200, \
-3050.82181849466}, {-1200, -2988.31436591406}, {-1200, -2925.22433552679}, \
{-1200, -2861.56402685931}, {-1200, -2797.3458506149}, {-1200, \
-2732.58232625428}, {-1200, -2667.28607955485}, {-1200, -2601.46984014926}, \
{-1200, -2535.14643904381}, {-1200, -2468.32880611695}, {-1200, \
-2401.02996759861}, {-1200, -2333.2630435307}, {-1200, -2265.04124520936}, \
{-1200, -2196.37787260932}, {-1200, -2127.28631179114}, {-1200, \
-2057.78003229148}, {-1200, -1987.87258449726}, {-1200, -1917.57759700394}, \
{-1200, -1846.90877395861}, {-1200, -1775.87989238835}, {-1200, \
-1704.50479951435}, {-1200, -1632.7974100524}, {-1200, -1560.77170350015}, \
{-1200, -1488.4417214118}, {-1200, -1415.82156466067}, {-1200, \
-1342.92539069022}, {-1200, -1269.76741075399}, {-1200, -1196.36188714512}, \
{-1200, -1122.7231304159}, {-1200, -1048.86549658785}, {-1200, \
-974.803384353024}, {-1200, -900.551232266952}, {-1200, -826.123515933806}, \
{-1200, -751.534745184353}, {-1200, -676.799461247243}, {-1200, \
-601.932233914158}, {-1200, -526.947658699407}, {-1200, -451.860353994504}, \
{-1200, -376.684958218277}, {-1200, -301.436126963085}, {-1200, \
-226.128530137678}, {-1200, -150.776849107272}, {-1200, -75.3957738313845}, \
{-1200, 0}, {-1200, 75.3957738313845}, {-1200, 150.776849107272}, {-1200, 
       226.128530137678}, {-1200, 301.436126963085}, {-1200, 
       376.684958218277}, {-1200, 451.860353994504}, {-1200, 
       526.947658699407}, {-1200, 601.932233914158}, {-1200, 
       676.799461247243}, {-1200, 751.534745184353}, {-1200, 
       826.123515933806}, {-1200, 900.551232266952}, {-1200, 
       974.803384353024}, {-1200, 1048.86549658785}, {-1200, 
       1122.7231304159}, {-1200, 1196.36188714512}, {-1200, 
       1269.76741075399}, {-1200, 1342.92539069022}, {-1200, 
       1415.82156466067}, {-1200, 1488.4417214118}, {-1200, 
       1560.77170350015}, {-1200, 1632.7974100524}, {-1200, 
       1704.50479951435}, {-1200, 1775.87989238835}, {-1200, 
       1846.90877395861}, {-1200, 1917.57759700394}, {-1200, 
       1987.87258449726}, {-1200, 2057.78003229148}, {-1200, 
       2127.28631179114}, {-1200, 2196.37787260932}, {-1200, 
       2265.04124520936}, {-1200, 2333.2630435307}, {-1200, 
       2401.02996759861}, {-1200, 2468.32880611695}, {-1200, 
       2535.14643904381}, {-1200, 2601.46984014926}, {-1200, 
       2667.28607955485}, {-1200, 2732.58232625428}, {-1200, 
       2797.3458506149}, {-1200, 2861.56402685931}, {-1200, 
       2925.22433552679}, {-1200, 2988.31436591406}, {-1200, 
       3050.82181849466}, {-1200, 3112.73450731688}, {-1200, 
       3174.04036237936}, {-1200, 3234.72743198416}, {-1200, 
       3294.78388506685}, {-1200, 3354.19801350288}, {-1200, 
       3412.95823439019}, {-1200, 3471.05309230731}, {-1200, 
       3471.05309230731}}], 
    LineBox[{{-1200, 3471.05309230731}, {-1152, 3471.05309230731}, {-1104, 
       3471.05309230731}, {-1056, 3471.05309230731}, {-1008, 
       3471.05309230731}, {-960, 3471.05309230731}, {-912, 
       3471.05309230731}, {-864, 3471.05309230731}, {-816, 
       3471.05309230731}, {-768, 3471.05309230731}, {-720, 
       3471.05309230731}, {-672, 3471.05309230731}, {-624, 
       3471.05309230731}, {-576, 3471.05309230731}, {-528, 
       3471.05309230731}, {-480, 3471.05309230731}, {-432, 
       3471.05309230731}, {-384, 3471.05309230731}, {-336, 
       3471.05309230731}, {-288, 3471.05309230731}, {-240, 
       3471.05309230731}, {-192, 3471.05309230731}, {-144, 
       3471.05309230731}, {-96, 3471.05309230731}, {-48, 3471.05309230731}, {
      0, 3471.05309230731}, {48, 3471.05309230731}, {96, 3471.05309230731}, {
      144, 3471.05309230731}, {192, 3471.05309230731}, {
      240, 3471.05309230731}, {288, 3471.05309230731}, {
      336, 3471.05309230731}, {384, 3471.05309230731}, {
      432, 3471.05309230731}, {480, 3471.05309230731}, {
      528, 3471.05309230731}, {576, 3471.05309230731}, {
      624, 3471.05309230731}, {672, 3471.05309230731}, {
      720, 3471.05309230731}, {768, 3471.05309230731}, {
      816, 3471.05309230731}, {864, 3471.05309230731}, {
      912, 3471.05309230731}, {960, 3471.05309230731}, {
      1008, 3471.05309230731}, {1056, 3471.05309230731}, {
      1104, 3471.05309230731}, {1152, 3471.05309230731}, {
      1200, 3471.05309230731}, {1248, 3471.05309230731}, {
      1296, 3471.05309230731}, {1344, 3471.05309230731}, {
      1392, 3471.05309230731}, {1440, 3471.05309230731}, {
      1488, 3471.05309230731}, {1536, 3471.05309230731}, {
      1584, 3471.05309230731}, {1632, 3471.05309230731}, {
      1680, 3471.05309230731}, {1728, 3471.05309230731}, {
      1776, 3471.05309230731}, {1824, 3471.05309230731}, {
      1872, 3471.05309230731}, {1920, 3471.05309230731}, {
      1968, 3471.05309230731}, {2016, 3471.05309230731}, {
      2064, 3471.05309230731}, {2112, 3471.05309230731}, {
      2160, 3471.05309230731}, {2208, 3471.05309230731}, {
      2256, 3471.05309230731}, {2304, 3471.05309230731}, {
      2352, 3471.05309230731}, {2400, 3471.05309230731}, {
      2448, 3471.05309230731}, {2496, 3471.05309230731}, {
      2544, 3471.05309230731}, {2592, 3471.05309230731}, {
      2640, 3471.05309230731}, {2688, 3471.05309230731}, {
      2736, 3471.05309230731}, {2784, 3471.05309230731}, {
      2832, 3471.05309230731}, {2880, 3471.05309230731}, {
      2928, 3471.05309230731}, {2976, 3471.05309230731}, {
      3024, 3471.05309230731}, {3072, 3471.05309230731}, {
      3120, 3471.05309230731}, {3168, 3471.05309230731}, {
      3216, 3471.05309230731}, {3264, 3471.05309230731}, {
      3312, 3471.05309230731}, {3360, 3471.05309230731}, {
      3408, 3471.05309230731}, {3456, 3471.05309230731}, {
      3504, 3471.05309230731}, {3552, 3471.05309230731}, {
      3600, 3471.05309230731}, {3600, 3471.05309230731}}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{307, 432},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->101371584]
}, Open  ]],

Cell[TextData[{
 "As noted previously, a projection is a scheme for transforming latitudes \
and longitudes on the Earth into ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " coordinates on a flat page. Each projection involves certain fixed \
geometric choices. For example, the Lambert azimuthal projection projects the \
surface of the Earth onto a plane that is tangent at one point. When you \
specify ",
 Cell[BoxData[
  ButtonBox["LambertAzimuthal",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/LambertAzimuthal"]], "InlineFormula"],
 " as the projection, this point is fixed at zero degrees latitude and \
longitude. You can change the choice of this point by setting the ",
 Cell[BoxData[
  ButtonBox["WorldRotation",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldRotation"]], "InlineFormula"],
 " option. "
}], "Text",
 CellID->1587],

Cell[TextData[{
 "A value for ",
 Cell[BoxData[
  ButtonBox["WorldRotation",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldRotation"]], "InlineFormula"],
 " must be a list of three numbers ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg", "TI"], "3"], TraditionalForm]], "InlineFormula"],
 StyleBox["}", "MR"],
 " with the first two between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["180", TraditionalForm]], "InlineFormula"],
 " and the last between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "180"}], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["180", TraditionalForm]], "InlineFormula"],
 ". To understand the effect of these numbers, you can imagine the globe in a \
standard ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
 " coordinate system with the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " axis coming out of the North Pole and the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " axis through the equator at the Prime Meridian. The three numbers give the \
amount of rotation (in degrees) of three sequential rotations. The first is \
about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " axis, the second is about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " axis, and the third is about the North Pole in the position where it is ",
 StyleBox["after",
  FontSlant->"Italic"],
 " the first two rotations. "
}], "Text",
 CellID->2348],

Cell[TextData[{
 "This setting for ",
 Cell[BoxData[
  ButtonBox["WorldRotation",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldRotation"]], "InlineFormula"],
 " causes the Earth to be rotated by ",
 Cell[BoxData[
  FormBox["90", TraditionalForm]], "InlineFormula"],
 " degrees before the projection is applied. The result is a view of the \
Northern Hemisphere centered at the North Pole. "
}], "MathCaption",
 CellID->7654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"World", ",", "RandomColors"}], "}"}], ",", 
   RowBox[{"WorldRotation", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"90", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"WorldRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "90"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "180"}], ",", "180"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"WorldProjection", "\[Rule]", "LambertAzimuthal"}]}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31287],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Thickness[0.001], 
     LineBox[{{-8.65956056235493*^-17, 
      1.4142135623731}, {-1.67665684428231*^-16, 
      1.36909421185738}, {-1.61974691821355*^-16, 
      1.3226237306473}, {-1.56123849749094*^-16, 
      1.27484797949738}, {-1.50118932286191*^-16, 
      1.22581410730595}, {-1.43965865561199*^-16, 
      1.17557050458495}, {-1.37670721908109*^-16, 
      1.12416675570426}, {-1.31239713873683*^-16, 
      1.07165358995799}, {-1.24679188086426*^-16, 
      1.01808283150074}, {-1.17995618993229*^-16, 
      0.963507348203431}, {-1.11195602469869*^-16, 
      0.907980999479094}, {-1.04285849311679*^-16, 
      0.851558583130145}, {-9.72731786108014*^-17, 
      0.794295781269561}, {-9.01645110265684*^-17, 
      0.736249105369356}, {-8.29668619556455*^-17, 
      0.677475840490583}, {-7.5687334608683*^-17, 
      0.618033988749895}, {-6.83331130003044*^-17, 
      0.557982212078458}, {-6.09114548593512*^-17, 
      0.49737977432971}, {-5.34296844663809*^-17, 
      0.436286482793085}, {-4.58951854254862*^-17, 
      0.374762629171449}, {-3.83153933775695*^-17, 
      0.312868930080462}, {-3.06977886622626*^-17, 
      0.250666467128609}, {-2.30498889357349*^-17, 
      0.188216626637029}, {-1.53792417516746*^-17, 
      0.125581039058627}, {-7.69341711276369*^-18, 
      0.0628215181562565}, {-7.49879891330929*^-33, 
      6.12323399573677*^-17}, {-7.49879891330929*^-33, 
      6.12323399573677*^-17}}], 
     LineBox[{{-0.707106781186547, 1.22474487139159}, {-0.684547105928689, 
      1.18567036764272}, {-0.661311865323652, 
      1.14542575038871}, {-0.63742398974869, 
      1.10405073620799}, {-0.612907053652976, 
      1.0615861572443}, {-0.587785252292473, 
      1.01807392091025}, {-0.56208337785213, 
      0.973556968529825}, {-0.535826794978997, 
      0.928079232960415}, {-0.509041415750371, 
      0.881685595236435}, {-0.481753674101715, 
      0.83442184027715}, {-0.453990499739547, 
      0.78633461170248}, {-0.425779291565073, 
      0.737471365801389}, {-0.397147890634781, 
      0.687880324698248}, {-0.368124552684678, 
      0.637610428763428}, {-0.338737920245291, 
      0.586711288315059}, {-0.309016994374947, 
      0.535233134659635}, {-0.278991106039229, 
      0.483226770519781}, {-0.248689887164855, 
      0.4307435198981}, {-0.218143241396543, 
      0.377835177426574}, {-0.187381314585725, 
      0.324553957251522}, {-0.156434465040231, 
      0.270952441504537}, {-0.125333233564304, 
      0.217083528410272}, {-0.0941083133185142, 
      0.163000380082278}, {-0.0627905195293134, 
      0.108756370058417}, {-0.0314107590781283, 
      0.0544050306276235}, {-3.06161699786838*^-17, 
      5.30287619362454*^-17}, {-3.06161699786838*^-17, 
      5.30287619362454*^-17}}], 
     LineBox[{{-1.22474487139159, 0.707106781186547}, {-1.18567036764272, 
      0.684547105928688}, {-1.14542575038871, 
      0.661311865323652}, {-1.10405073620799, 
      0.63742398974869}, {-1.0615861572443, 
      0.612907053652976}, {-1.01807392091025, 
      0.587785252292473}, {-0.973556968529825, 
      0.56208337785213}, {-0.928079232960414, 
      0.535826794978996}, {-0.881685595236435, 
      0.509041415750371}, {-0.83442184027715, 
      0.481753674101715}, {-0.78633461170248, 
      0.453990499739547}, {-0.737471365801389, 
      0.425779291565072}, {-0.687880324698248, 
      0.39714789063478}, {-0.637610428763428, 
      0.368124552684678}, {-0.586711288315059, 
      0.338737920245291}, {-0.535233134659635, 
      0.309016994374947}, {-0.483226770519781, 
      0.278991106039229}, {-0.4307435198981, 
      0.248689887164855}, {-0.377835177426574, 
      0.218143241396543}, {-0.324553957251522, 
      0.187381314585724}, {-0.270952441504537, 
      0.156434465040231}, {-0.217083528410272, 
      0.125333233564304}, {-0.163000380082278, 
      0.0941083133185143}, {-0.108756370058417, 
      0.0627905195293134}, {-0.0544050306276235, 
      0.0314107590781282}, {-5.30287619362454*^-17, 
      3.06161699786838*^-17}, {-5.30287619362454*^-17, 
      3.06161699786838*^-17}}], 
     LineBox[{{-1.4142135623731, -8.65956056235493*^-17}, {-1.36909421185738, \
-8.38328422141153*^-17}, {-1.3226237306473, -8.09873459106776*^-17}, \
{-1.27484797949738, -7.80619248745468*^-17}, {-1.22581410730595, \
-7.50594661430953*^-17}, {-1.17557050458495, -7.19829327805997*^-17}, \
{-1.12416675570426, -6.88353609540544*^-17}, {-1.07165358995799, \
-6.56198569368413*^-17}, {-1.01808283150074, -6.23395940432129*^-17}, \
{-0.963507348203431, -5.89978094966143*^-17}, {-0.907980999479094, \
-5.55978012349343*^-17}, {-0.851558583130145, -5.21429246558394*^-17}, \
{-0.794295781269561, -4.86365893054007*^-17}, {-0.736249105369356, \
-4.50822555132842*^-17}, {-0.677475840490583, -4.14834309778228*^-17}, \
{-0.618033988749895, -3.78436673043415*^-17}, {-0.557982212078459, \
-3.41665565001522*^-17}, {-0.497379774329709, -3.04557274296756*^-17}, \
{-0.436286482793085, -2.67148422331904*^-17}, {-0.374762629171449, \
-2.29475927127431*^-17}, {-0.312868930080462, -1.91576966887847*^-17}, \
{-0.250666467128609, -1.53488943311313*^-17}, {-0.188216626637029, \
-1.15249444678675*^-17}, {-0.125581039058627, -7.6896208758373*^-18}, \
{-0.0628215181562565, -3.84670855638184*^-18}, {-6.12323399573677*^-17, \
-3.74939945665464*^-33}, {-6.12323399573677*^-17, -3.74939945665464*^-33}}], 
     LineBox[{{-1.22474487139159, -0.707106781186548}, {-1.18567036764272, \
-0.684547105928689}, {-1.14542575038871, -0.661311865323652}, \
{-1.10405073620799, -0.63742398974869}, {-1.0615861572443, \
-0.612907053652977}, {-1.01807392091025, -0.587785252292473}, \
{-0.973556968529825, -0.562083377852131}, {-0.928079232960414, \
-0.535826794978997}, {-0.881685595236435, -0.509041415750371}, \
{-0.83442184027715, -0.481753674101715}, {-0.78633461170248, \
-0.453990499739547}, {-0.737471365801389, -0.425779291565073}, \
{-0.687880324698248, -0.397147890634781}, {-0.637610428763428, \
-0.368124552684678}, {-0.586711288315059, -0.338737920245291}, \
{-0.535233134659635, -0.309016994374948}, {-0.483226770519781, \
-0.278991106039229}, {-0.4307435198981, -0.248689887164855}, \
{-0.377835177426574, -0.218143241396543}, {-0.324553957251522, \
-0.187381314585725}, {-0.270952441504537, -0.156434465040231}, \
{-0.217083528410272, -0.125333233564304}, {-0.163000380082278, \
-0.0941083133185143}, {-0.108756370058417, -0.0627905195293134}, \
{-0.0544050306276235, -0.0314107590781283}, {-5.30287619362453*^-17, \
-3.06161699786838*^-17}, {-5.30287619362453*^-17, -3.06161699786838*^-17}}], 
     LineBox[{{-0.707106781186547, -1.22474487139159}, {-0.684547105928689, \
-1.18567036764272}, {-0.661311865323652, -1.14542575038871}, \
{-0.63742398974869, -1.10405073620799}, {-0.612907053652976, \
-1.0615861572443}, {-0.587785252292473, -1.01807392091025}, \
{-0.56208337785213, -0.973556968529825}, {-0.535826794978997, \
-0.928079232960415}, {-0.509041415750371, -0.881685595236435}, \
{-0.481753674101715, -0.83442184027715}, {-0.453990499739547, \
-0.78633461170248}, {-0.425779291565073, -0.737471365801389}, \
{-0.397147890634781, -0.687880324698248}, {-0.368124552684678, \
-0.637610428763428}, {-0.338737920245291, -0.586711288315059}, \
{-0.309016994374947, -0.535233134659635}, {-0.278991106039229, \
-0.483226770519781}, {-0.248689887164855, -0.4307435198981}, \
{-0.218143241396543, -0.377835177426574}, {-0.187381314585725, \
-0.324553957251522}, {-0.156434465040231, -0.270952441504537}, \
{-0.125333233564304, -0.217083528410272}, {-0.0941083133185142, \
-0.163000380082278}, {-0.0627905195293134, -0.108756370058417}, \
{-0.0314107590781283, -0.0544050306276235}, {-3.06161699786838*^-17, \
-5.30287619362454*^-17}, {-3.06161699786838*^-17, -5.30287619362454*^-17}}], 
     LineBox[{{0., -1.4142135623731}, {0., -1.36909421185738}, {
      0., -1.3226237306473}, {0., -1.27484797949738}, {
      0., -1.22581410730595}, {0., -1.17557050458495}, {
      0., -1.12416675570426}, {0., -1.07165358995799}, {
      0., -1.01808283150074}, {0., -0.963507348203431}, {
      0., -0.907980999479094}, {0., -0.851558583130145}, {
      0., -0.794295781269561}, {0., -0.736249105369356}, {
      0., -0.677475840490583}, {0., -0.618033988749895}, {
      0., -0.557982212078458}, {0., -0.49737977432971}, {
      0., -0.436286482793085}, {0., -0.374762629171449}, {
      0., -0.312868930080462}, {0., -0.250666467128609}, {
      0., -0.188216626637029}, {0., -0.125581039058627}, {
      0., -0.0628215181562565}, {0., -6.12323399573677*^-17}, {
      0., -6.12323399573677*^-17}}], 
     LineBox[{{0.707106781186547, -1.22474487139159}, {
      0.684547105928689, -1.18567036764272}, {
      0.661311865323652, -1.14542575038871}, {
      0.63742398974869, -1.10405073620799}, {
      0.612907053652976, -1.0615861572443}, {
      0.587785252292473, -1.01807392091025}, {
      0.56208337785213, -0.973556968529825}, {
      0.535826794978997, -0.928079232960415}, {
      0.509041415750371, -0.881685595236435}, {
      0.481753674101715, -0.83442184027715}, {
      0.453990499739547, -0.78633461170248}, {
      0.425779291565073, -0.737471365801389}, {
      0.397147890634781, -0.687880324698248}, {
      0.368124552684678, -0.637610428763428}, {
      0.338737920245291, -0.586711288315059}, {
      0.309016994374947, -0.535233134659635}, {
      0.278991106039229, -0.483226770519781}, {
      0.248689887164855, -0.4307435198981}, {
      0.218143241396543, -0.377835177426574}, {
      0.187381314585725, -0.324553957251522}, {
      0.156434465040231, -0.270952441504537}, {
      0.125333233564304, -0.217083528410272}, {
      0.0941083133185142, -0.163000380082278}, {
      0.0627905195293134, -0.108756370058417}, {
      0.0314107590781283, -0.0544050306276235}, {
      3.06161699786838*^-17, -5.30287619362454*^-17}, {
      3.06161699786838*^-17, -5.30287619362454*^-17}}], 
     LineBox[{{1.22474487139159, -0.707106781186548}, {
      1.18567036764272, -0.684547105928689}, {
      1.14542575038871, -0.661311865323652}, {
      1.10405073620799, -0.63742398974869}, {
      1.0615861572443, -0.612907053652977}, {
      1.01807392091025, -0.587785252292473}, {
      0.973556968529825, -0.562083377852131}, {
      0.928079232960414, -0.535826794978997}, {
      0.881685595236435, -0.509041415750371}, {
      0.83442184027715, -0.481753674101715}, {
      0.78633461170248, -0.453990499739547}, {
      0.737471365801389, -0.425779291565073}, {
      0.687880324698248, -0.397147890634781}, {
      0.637610428763428, -0.368124552684678}, {
      0.586711288315059, -0.338737920245291}, {
      0.535233134659635, -0.309016994374948}, {
      0.483226770519781, -0.278991106039229}, {
      0.4307435198981, -0.248689887164855}, {
      0.377835177426574, -0.218143241396543}, {
      0.324553957251522, -0.187381314585725}, {
      0.270952441504537, -0.156434465040231}, {
      0.217083528410272, -0.125333233564304}, {
      0.163000380082278, -0.0941083133185143}, {
      0.108756370058417, -0.0627905195293134}, {
      0.0544050306276235, -0.0314107590781283}, {
      5.30287619362453*^-17, -3.06161699786838*^-17}, {
      5.30287619362453*^-17, -3.06161699786838*^-17}}], 
     LineBox[{{1.4142135623731, -8.65956056235493*^-17}, {
      1.36909421185738, -8.38328422141153*^-17}, {
      1.3226237306473, -8.09873459106776*^-17}, {
      1.27484797949738, -7.80619248745468*^-17}, {
      1.22581410730595, -7.50594661430953*^-17}, {
      1.17557050458495, -7.19829327805997*^-17}, {
      1.12416675570426, -6.88353609540544*^-17}, {
      1.07165358995799, -6.56198569368413*^-17}, {
      1.01808283150074, -6.23395940432129*^-17}, {
      0.963507348203431, -5.89978094966143*^-17}, {
      0.907980999479094, -5.55978012349343*^-17}, {
      0.851558583130145, -5.21429246558394*^-17}, {
      0.794295781269561, -4.86365893054007*^-17}, {
      0.736249105369356, -4.50822555132842*^-17}, {
      0.677475840490583, -4.14834309778228*^-17}, {
      0.618033988749895, -3.78436673043415*^-17}, {
      0.557982212078459, -3.41665565001522*^-17}, {
      0.497379774329709, -3.04557274296756*^-17}, {
      0.436286482793085, -2.67148422331904*^-17}, {
      0.374762629171449, -2.29475927127431*^-17}, {
      0.312868930080462, -1.91576966887847*^-17}, {
      0.250666467128609, -1.53488943311313*^-17}, {
      0.188216626637029, -1.15249444678675*^-17}, {
      0.125581039058627, -7.6896208758373*^-18}, {
      0.0628215181562565, -3.84670855638184*^-18}, {
      6.12323399573677*^-17, -3.74939945665464*^-33}, {
      6.12323399573677*^-17, -3.74939945665464*^-33}}], 
     LineBox[{{1.22474487139159, 0.707106781186547}, {1.18567036764272, 
      0.684547105928688}, {1.14542575038871, 0.661311865323652}, {
      1.10405073620799, 0.63742398974869}, {1.0615861572443, 
      0.612907053652976}, {1.01807392091025, 0.587785252292473}, {
      0.973556968529825, 0.56208337785213}, {0.928079232960414, 
      0.535826794978996}, {0.881685595236435, 0.509041415750371}, {
      0.83442184027715, 0.481753674101715}, {0.78633461170248, 
      0.453990499739547}, {0.737471365801389, 0.425779291565072}, {
      0.687880324698248, 0.39714789063478}, {0.637610428763428, 
      0.368124552684678}, {0.586711288315059, 0.338737920245291}, {
      0.535233134659635, 0.309016994374947}, {0.483226770519781, 
      0.278991106039229}, {0.4307435198981, 0.248689887164855}, {
      0.377835177426574, 0.218143241396543}, {0.324553957251522, 
      0.187381314585724}, {0.270952441504537, 0.156434465040231}, {
      0.217083528410272, 0.125333233564304}, {0.163000380082278, 
      0.0941083133185143}, {0.108756370058417, 0.0627905195293134}, {
      0.0544050306276235, 0.0314107590781282}, {5.30287619362454*^-17, 
      3.06161699786838*^-17}, {5.30287619362454*^-17, 
      3.06161699786838*^-17}}], 
     LineBox[{{0.707106781186547, 1.22474487139159}, {0.684547105928689, 
      1.18567036764272}, {0.661311865323652, 1.14542575038871}, {
      0.63742398974869, 1.10405073620799}, {0.612907053652976, 
      1.0615861572443}, {0.587785252292473, 1.01807392091025}, {
      0.56208337785213, 0.973556968529825}, {0.535826794978997, 
      0.928079232960415}, {0.509041415750371, 0.881685595236435}, {
      0.481753674101715, 0.83442184027715}, {0.453990499739547, 
      0.78633461170248}, {0.425779291565073, 0.737471365801389}, {
      0.397147890634781, 0.687880324698248}, {0.368124552684678, 
      0.637610428763428}, {0.338737920245291, 0.586711288315059}, {
      0.309016994374947, 0.535233134659635}, {0.278991106039229, 
      0.483226770519781}, {0.248689887164855, 0.4307435198981}, {
      0.218143241396543, 0.377835177426574}, {0.187381314585725, 
      0.324553957251522}, {0.156434465040231, 0.270952441504537}, {
      0.125333233564304, 0.217083528410272}, {0.0941083133185142, 
      0.163000380082278}, {0.0627905195293134, 0.108756370058417}, {
      0.0314107590781283, 0.0544050306276235}, {3.06161699786838*^-17, 
      5.30287619362454*^-17}, {3.06161699786838*^-17, 
      5.30287619362454*^-17}}], 
     LineBox[{{8.65956056235493*^-17, 1.4142135623731}, {
      1.67665684428231*^-16, 1.36909421185738}, {1.61974691821355*^-16, 
      1.3226237306473}, {1.56123849749094*^-16, 1.27484797949738}, {
      1.50118932286191*^-16, 1.22581410730595}, {1.43965865561199*^-16, 
      1.17557050458495}, {1.37670721908109*^-16, 1.12416675570426}, {
      1.31239713873683*^-16, 1.07165358995799}, {1.24679188086426*^-16, 
      1.01808283150074}, {1.17995618993229*^-16, 0.963507348203431}, {
      1.11195602469869*^-16, 0.907980999479094}, {1.04285849311679*^-16, 
      0.851558583130145}, {9.72731786108014*^-17, 0.794295781269561}, {
      9.01645110265684*^-17, 0.736249105369356}, {8.29668619556455*^-17, 
      0.677475840490583}, {7.5687334608683*^-17, 0.618033988749895}, {
      6.83331130003044*^-17, 0.557982212078458}, {6.09114548593512*^-17, 
      0.49737977432971}, {5.34296844663809*^-17, 0.436286482793085}, {
      4.58951854254862*^-17, 0.374762629171449}, {3.83153933775695*^-17, 
      0.312868930080462}, {3.06977886622626*^-17, 0.250666467128609}, {
      2.30498889357349*^-17, 0.188216626637029}, {1.53792417516746*^-17, 
      0.125581039058627}, {7.69341711276369*^-18, 0.0628215181562565}, {
      7.49879891330929*^-33, 6.12323399573677*^-17}, {7.49879891330929*^-33, 
      6.12323399573677*^-17}}], LineBox[CompressedData["
1:eJx1lEtI1FEYxaeEHk6gPTY9XLiqjdIiKRrlEJaCC6FcuAmiaOqfRQODm6I0
oiAQwk2ZWcPYuLBNtcgRevjRpt1gC2miIIIKQiIabYYYSivuOXdxoYHhz/9x
7/2+8zvfaTyWOpRcGYvFor//f9fi9ZqZbPnWs0Ji8EQmW0F4f20kOjv0NG/H
W7fv3nmjgisjyxN1j17acuZiSyldQUe2tpAvv7Lq5EK1Zm8FD7vnOtsvv7bh
/Mb4vfky3p5vqdvw851NF1KjW6+WEc/l+mcnP1jUMbynuLaMk7t6N73Y/9Fy
yd70wXM/0N/cuT5R+GyJTFPXtrlFNDTU73uAL3bq5oX777cs4tLsgSfjo/N2
59e66Z7uBRyu/9Qz9earNQ+VNnelSli6/Tw+Uf1mq9tnduQGvmONu9pv9xxN
7js74tbhrtvHBty+iNw51ujORZurwyJXF1in9bm6wT6s1vUF9mlF1zeogz12
uoA6WZvTDUtORxt3uoI6W9LpDnIwcdH7NLmQg42Ri/ZPkIvOnyIX1Scuql9c
gv5M/Z8mlz7qIy7Sb5BcAn1tFfVfMea46KrnR/md1pGD3zfgb2dYh+oK/GOB
vyzwnwX+9DpJt8DfFvjfYvyJC997blwPref+njvP975gfd43rN/7iv1537F/
70vqA+kjH0s/6ut9T/0h/XmFuPA7iB/3gfiSv59L1gH5Q3Ms/2jOxUU5IC7K
CflTOSIuyhn5Wzkk/4e5pfeaH84XNF/aX/On8zWfqk/zq/o130F/4gDlA/MD
yg/pJy6BvsonKJ+YX1B+Md+gfGP+QfkX8Fd+QvkZ+AeBvxD4D4E/le9et8Df
CPwvDq0Bl//e/wEtenVm
      "]], LineBox[CompressedData["
1:eJx1lT9oU2EUxV9ssBhRLG1qxSqKxEXQwcGlcAY7ONVEU9Sk/kENFRQ71YCD
2KUIFUVErZQKdZAEHBxU/FO5mSpOASWItUijjbEmNg4FQSTR9t7z4D0wEB7J
e9/33Xt+55639eTAgdQKx3HO/PsuXVf2te3e/mBiMuAsfX7C/7v/5uzGUOsj
cbrnpFCrYTo5cbQSyknww+V4v9QwfLEp1fnntdRXRR6Wztdwu7nzd0shL8XN
6zbdry8gNr9rT23qnQR6u1vXDiwgnM3sS1x/L+VEbfxF7gdGhyJvfuGjXAvP
zBxarOJIVvrWFD7J4dxQz+NQFbEdHV2XIkW5svN042WwghOJweC2/GfJLN4Z
S3+Zx/PAk/pUak6qZ5OnVme+oW1LS2++XJKOZ2+bnh4sY71exf5HRZ+TV7oO
Wd1Hjum+GNZzJK7nIql1yH6tCyNap9zTuvFV+5B27QuO9ik92jdmVQe5q7qg
oTpJWnWD6Sgl1RWNvcs6yznVHcZBmpe53Jjk/UHjwvVF48L9LxgXnj9uXFhf
1Liw/g3G5aq3P2H/UeNCfcjFOMhx4+LTV9pN/7Bx8fFxn/tu64yDkIuPv8St
joTVNeb1j9tHyfqKev0nt7z+dHUKhFS3otffkvb6Xxz7kIvdB+/beper7Q/u
b+eD51t9YH1WP1i/9Qf2Z/2D/Zs+oD70MfWjz6kv54D6Gx+Qj/EDuXDOyNf4
u3Np/gD9Yf4B/WP+ArmY/0Au5k/Qn+ZfkAtzxvW3+h/0P3PKNx/g/HC9O1+2
P+eP53M+WR/nl/Vzvke8/TEfwHygPswP4wBy8enLfGJuwceH+Qbmm+UfyMXH
n/kJ5ueo1z/MXzB/Y17/Mb/pT+Y7mO/TXn/z/UD/8/3R5Xuf/Pf3XymjTaM=

      "]], LineBox[CompressedData["
1:eJx1lV1Ik3EYxYcXLkmjCElKEUGK6qqCdSMcmHrTTRSUQREUZUbSBIPMGFTQ
cESkkwgJpNYnZtFFlpT0mBQEZrE+t9ZqFxWGFxYkFV309T9n8L7QYLy8X///
85zfec5bsz2yfmdRIBBo+fP/e8y8aQt3NSZGEsW996LdefjPX6XmP151/owh
nTtX3ZVHYmbdnfHT123Xqa93yyJ5JKc2Tw49H7ZQ33TztsY8BuemPjZ0jlpT
/cqbDbPzKMkk5sUP3LeFM2MP3h9+h/b+FcmqHQ/t82RtcM/EW7QOXBgsCz2y
3Teysac/clg659Cy6NQTw9iS0i/BHI6V9rRtHE3ZrVTdt9vfs0h07i3/1fHM
ytu3rAlPvMbR2t61P6te2KZQ4ORQLIODRRXjZ6++tMt1y8e2Lk5jwB2tw11H
k3vOYu49LHDrWLdbF8NuHzvu9kW9q8MqXV1ocXVaxNWNadeHsS9Uuj6t2PUN
6mDUBaudTpZwuqHZ6Wj9TldQZ8s63UEOlv7H5ciI7n8gF3KwPnLR+ifIRftf
I5dFrG8Wuaj+feTi68/UfzW5SJ84uUg/cfHpaxepf5RcxOcSr8f53Aa+18N1
Kriuj7/VsI4w64p4/WP7vf6yoNd/dsXrT+v1+rego3T95PW/BfgTF94vcOP7
0PtcH1qf+xd8wfqg+lg/VL98pv7YP9Q/9YH0oX6QftQX0pf6Q/qTD8SH/CB+
5FuYO/KH+NMfkD/oH4gL/QX5i/6D/KeckD/pX8i/yhlxUQ7J/8op33xA88P5
guZL62v+tL/mk/MLza/q13z7+lM+QPkgfZQf0k/54tNX+QTlk/gov5hvUL6R
A5R/Pv7KTyg/W73+KfSh/C3x+q+gg3RJev2r/Je/9X2Q//X9qPN9T/57/hsn
w3yz
      "]], LineBox[CompressedData["
1:eJx1VUtIVGEUnmrRJBSiWRERCGG1aJEGEh2EIYTsQSgmRFlN5BOkIodyUzSN
YZMzegWDFlaLMGgpFJmnB0RQkDm4KIKa0QqiTVPRw0VDD873/XAvNDD83Md/
/nO+1y0/fLShZX4oFGr/+/+31jUne5+f3Doe3r+0qmLUk+D1tkL4RsVEvfYt
S01vGfGkuiR1c+NYVEcfvR3rjXvypDZSlu/u1Ktr72dWN3kyde77q1Pp41oZ
jYQ3rfBkbmZl471MTHP1tz4seDoo/YeGYj9/9Wh+TdOxbPugFE91/M4vOa0v
rxSSdZ8HpKcwuap23lk90lo07H1Ky4EdDYvff4zrl+WNBy9PpiS3vWhd24OE
xp+Vv0mk+yX1blHJtzPndffCZNelyovS8TU/8nh9n+b2PhzeMHFBZm1V3Be8
pwO2TxJWR7NWV/J2jkbtXGmzPvSE9SUvrE8ts74FcyjmklmbU3/Y3AIcNGO4
yDXDSe8YbnLdcNSI4SrAWXca7gIe1HipGufzPeAFPGgNeGH92+CF50+DF/Cg
5IX9e+AFPGgpeOH83eAFPGgzeCF+5CWAr74G/l3ghWsW9/neLuxjHdYN8K8x
9NGCvkr9+tEhv77Ig5s7oE+9C5yIW41f37rPr38N4Ude8Nzxhv3C/ajveMf5
ThfUCftD/05XmE84H+YXzg98hPgAP6dr6pz4An8h/uBHyAt9RF5Qx/mOPiT/
0IdQH/QxeaHPqS/mAPXHnKA+gZNQv8wZ8sIcov79ueX8IfQP/CX0F+vTfzyf
/oR/hbywf/ob/hf6n/MzH5AfwvwgfsyXAL7MJ+aWW5lfyDe3j/wy/wL8Mz+F
+Vns14+bg3PN+fUnAX0y34X5Xu3XN78P1D+/H5sD35P/Xv8BXghDWw==
      "]]}, {
     TooltipBox[
      {RGBColor[0.0564212056636406, 0.457753367003525, 0.0815302114535985], 
       PolygonBox[{{0.801755647134655, -0.439251570256854}, {
        0.816550495991501, -0.397082841370774}, {
        0.805783447307032, -0.362415211551477}, {
        0.822912460223003, -0.336382969141174}, {
        0.82180021969981, -0.283770932642398}, {
        0.8518739465741, -0.28200530122868}, {
        0.858130355570408, -0.23127356780885}, {
        0.859714592597777, -0.23734304730448}, {
        0.854833405823567, -0.283812977130089}, {
        0.881514886873234, -0.322588639127329}, {
        0.908175798255022, -0.342567373692293}, {
        0.901617683622944, -0.387987044780766}, {
        0.917385933569797, -0.403659471662747}, {
        0.87524891619651, -0.487824460253796}, {
        0.868131727299253, -0.464513205520058}, {
        0.830387439775723, -0.468217569727995}, {
        0.801755647134655, -0.439251570256854}}]},
      "\"Afghanistan\""], 
     TooltipBox[
      {RGBColor[0.524687958744031, 0.441562775912037, 0.583651004743706], 
       PolygonBox[{{0.29103240476326, -0.798881829125424}, {
        0.270550644051058, -0.76969917188104}, {
        0.277603778103357, -0.755861663107469}, {
        0.297853115728985, -0.776609042975929}, {
        0.29103240476326, -0.798881829125424}}]},
      "\"Albania\""], 
     TooltipBox[
      {RGBColor[0.244566123074315, 0.627363146372101, 0.864724585385091], 
       PolygonBox[{{0.133857337987503, -0.883352415707857}, {
        0., -0.910571871111841}, {-0.0356695614255099, -0.921516797003995}, \
{-0.0199926511941404, -0.967885910044187}, {-0.0648464858042504, \
-0.972034789055569}, {-0.062442967546942, -0.983372899612254}, \
{-0.153599139233404, -1.0076954139171}, {-0.155968539642498, \
-1.02323999273371}, {-0.1568303062557, -1.02889365894775}, \
{-0.08992014489952, -1.07083044599033}, {0., -1.12079619571947}, {
        0.0859120138159599, -1.15608577983895}, {
        0.227942564615513, -1.07238545272188}, {
        0.172736385479343, -1.04341592035697}, {
        0.165036913872897, -0.982709247292334}, {
        0.122791276890418, -0.932692346447169}, {
        0.133857337987503, -0.883352415707857}}]},
      "\"Algeria\""], 
     TooltipBox[
      {RGBColor[0.344720296449936, 0.233510886898901, 0.647545327979697], 
       PolygonBox[{{0.0245985702169268, -0.805117690224207}, {
        0.0210435323439752, -0.80362007838354}, {
        0.0208097678519139, -0.803626165699343}, {
        0.0245985702169268, -0.805117690224207}}]},
      "\"Andorra\""], 
     TooltipBox[
      {RGBColor[0.274153117435109, 0.42858647237939, 0.664273707790197]},
      "\"Angola\""], 
     TooltipBox[
      {RGBColor[
       0.412916090236989, 0.729383009570781, 
        0.916015327057759], {}, {}, {}, {}, {}},
      "\"Antarctica\""], 
     TooltipBox[
      {RGBColor[
       0.793646252106174, 0.305166129577086, 0.65352144801429], {}, {}},
      "\"Argentina\""], 
     TooltipBox[
      {RGBColor[0.250369731842069, 0.821371741652627, 0.930287457745829], 
       PolygonBox[{{0.571925653190084, -0.609749451735716}, {
        0.584387804709516, -0.584047920524875}, {
        0.607960876323356, -0.579965831860588}, {
        0.630576006225631, -0.578153986133053}, {
        0.626549900751537, -0.589055847447783}, {
        0.614657815554437, -0.590122477832027}, {
        0.599841992234032, -0.603693041025872}, {
        0.571925653190084, -0.609749451735716}}]},
      "\"Armenia\""], 
     TooltipBox[
      {RGBColor[
       0.597100242350649, 0.792616364838543, 
        0.739841530199028], {}, {}, {}, {}},
      "\"Australia\""], 
     TooltipBox[
      {RGBColor[0.405599499001798, 0.155537466438612, 0.208965360094837], 
       PolygonBox[{{0.122457911989656, -0.713907242473257}, {
        0.163677936412025, -0.706154982643083}, {
        0.168379750971715, -0.683801956915674}, {
        0.211466051253498, -0.684546007725533}, {
        0.2040780750404, -0.706273925804402}, {
        0.175605575804403, -0.719453437243973}, {
        0.133553005866235, -0.722934515435146}, {
        0.122061337647125, -0.72166996256481}, {
        0.12068334640877, -0.718606751223058}, {
        0.122457911989656, -0.713907242473257}}]},
      "\"Austria\""], 
     TooltipBox[
      {RGBColor[0.495275407124713, 0.778236352629697, 0.290812881053521], 
       PolygonBox[{{0.599841992234032, -0.603693041025872}, {
        0.614657815554437, -0.590122477832027}, {
        0.626549900751537, -0.589055847447783}, {
        0.622998036237836, -0.598129781360598}, {
        0.599841992234032, -0.603693041025872}}], 
       PolygonBox[{{0.630576006225631, -0.578153986133053}, {
        0.607960876323356, -0.579965831860588}, {
        0.584387804709516, -0.584047920524875}, {
        0.60997298120953, -0.567814632841487}, {
        0.590227037398288, -0.564033208130715}, {
        0.612346994215002, -0.554269390215854}, {
        0.612030989838061, -0.539894389591493}, {
        0.648420714934552, -0.536420266652771}, {
        0.655189998394486, -0.571894374457563}, {
        0.634155633835839, -0.56832970411275}, {
        0.630576006225631, -0.578153986133053}}]},
      "\"Azerbaijan\""], 
     TooltipBox[
      {RGBColor[0.864245063644902, 0.261764520225811, 0.13069102465], 
       PolygonBox[{{0.815130870840152, -0.671942036036639}}]},
      "\"Bahrain\""], 
     TooltipBox[
      {RGBColor[0.0166597636184116, 0.435658591265511, 0.597490812435615], 
       PolygonBox[{{1.12982056015834, 0.0434033278471938}, {1.10471619885728, 
        0.0286064449139271}, {1.08991646066503, -0.0142677880326708}, {
        1.11301016285489, 0.0119796392768091}, {
        1.11943195641502, -0.0188883064856827}, {
        1.07026763949695, -0.0183701696187272}, {
        1.05004720926057, -0.0290247921366278}, {
        1.07042161321802, -0.00280236363264346}, {1.07316633033069, 
        0.0449789958641194}, {1.09441267003194, 0.0222877022593407}, {
        1.10416188226881, 0.0311634749061271}, {1.0937704763128, 
        0.0436116858755877}, {1.11747540398819, 0.0507442611612365}, {
        1.12982056015834, 0.0434033278471938}}]},
      "\"Bangladesh\""], 
     TooltipBox[
      {RGBColor[0.717774934413011, 0.287276754047631, 0.519643264207752], 
       PolygonBox[{{0.246771397245447, -0.567535358826019}, {
        0.263219266449905, -0.556425683324424}, {
        0.262840863501576, -0.531040053688251}, {
        0.275290065362652, -0.51557247765271}, {
        0.293614264272829, -0.508896631480799}, {
        0.327529102257965, -0.529969926200591}, {
        0.340931766981947, -0.553454949309448}, {
        0.302135197121091, -0.584541566911228}, {
        0.263762759385702, -0.603729102588004}, {
        0.246771397245447, -0.567535358826019}}]},
      "\"Belarus\""], 
     TooltipBox[
      {RGBColor[0.803844560329441, 0.412608804835925, 0.633755306033341], 
       PolygonBox[{{0.0296419325776646, -0.665582796296258}, {
        0.0390274732854088, -0.660150691927167}, {
        0.0703800040769976, -0.667752453648531}, {
        0.0728509099042845, -0.677950101746538}, {
        0.07009962607559, -0.688126951600439}, {
        0.0296419325776646, -0.665582796296258}}]},
      "\"Belgium\""], 
     TooltipBox[
      {RGBColor[0.269273532365684, 0.982472818676814, 0.482321347090095], 
       PolygonBox[{{-1.16821085406103, -0.0350118097742397}, \
{-1.20480807676899, -0.0227829051561389}, {-1.1780228879459, \
-0.0178203534461417}, {-1.16821085406103, -0.0350118097742397}}]},
      "\"Belize\""], 
     TooltipBox[
      {RGBColor[0.0366550636826919, 0.47665716752714, 0.242631288477786], 
       PolygonBox[{{0.0380645361595259, -1.3349059949058}, {
        0.063591311461674, -1.33198146377352}, {
        0.0785106560735092, -1.25958428642253}, {
        0.052772643866033, -1.25911713837829}, {
        0.0214621896429679, -1.2719753864217}, {
        0.0380645361595259, -1.3349059949058}}]},
      "\"Benin\""], 
     TooltipBox[
      {RGBColor[0.0767218480882971, 0.881117597244079, 0.267691807432303], 
       PolygonBox[{{-0.872601709238134, -0.411545684068806}}]},
      "\"Bermuda\""], 
     TooltipBox[
      {RGBColor[0.747355881353074, 0.2984854954586, 0.590304716190558], 
       PolygonBox[{{1.04009476301506, -0.019668178522439}, {
        1.025334765366, -6.27836469229987*^-17}, {1.03313622118858, 
        0.0297604147573577}, {1.04009476301506, -0.019668178522439}}]},
      "\"Bhutan\""], 
     TooltipBox[
      {RGBColor[0.403446743787401, 0.485591361127262, 0.167794470808601]},
      "\"Bolivia\""], 
     TooltipBox[
      {RGBColor[0.573644952572147, 0.96778815252189, 0.888100548691647], 
       PolygonBox[{{0.257363708973687, -0.763271580809863}, {
        0.219372768663829, -0.74696889046995}, {
        0.214183629409859, -0.742056591125846}, {
        0.209582852679191, -0.733316898782488}, {
        0.242176765653712, -0.725191875508916}, {
        0.247257609384978, -0.726314455576295}, {
        0.257363708973687, -0.763271580809863}}]},
      "\"Bosnia and Herzegovina\""], 
     TooltipBox[
      {RGBColor[0.45001953639559, 0.286368198524516, 0.448144888314138]},
      "\"Botswana\""], 
     TooltipBox[
      {RGBColor[0.0842559883622066, 0.0374107315596656, 0.652612892491175], 
       PolygonBox[{{-1.10026268223452, -0.888494248761409}, \
{-1.07043051753609, -0.901918495226494}, {-1.06985256147654, \
-0.845424067797287}, {-1.10231907599518, -0.838729078910433}, \
{-1.12928799198328, -0.802048903917455}, {-1.15860837509067, \
-0.767835875799911}, {-1.2006240525616, -0.71429625010602}, \
{-1.17303833948772, -0.686384051460851}, {-1.17646054887011, \
-0.659299185921453}, {-1.1958978318817, -0.648869189397158}, \
{-1.21898115284825, -0.624231678111468}, {-1.23090494982336, \
-0.579219902954232}, {-1.24057849081831, -0.621235431825163}, \
{-1.28662001120587, -0.549674867493522}, {-1.30761770760785, \
-0.479814469086006}, {-1.3137952186015, -0.501251763078299}, \
{-1.32256334439727, -0.480067054920722}, {-1.3292452641191, \
-0.48281158624968}, {-1.3292452641191, -0.48281158624968}, \
{-1.31490251631876, -0.5206067350492}, {-1.27961868919952, \
-0.602142848708934}, {-1.23928479171617, -0.681302579637714}, \
{-1.19406000333529, -0.757773520542205}, {-1.14412280563537, \
-0.831253875554907}, {-1.10026268223452, -0.888494248761409}}], {}},
      "\"Brazil\""], 
     TooltipBox[
      {RGBColor[0.178871355948454, 0.101783169685393, 0.55508938446957], 
       PolygonBox[{{1.23845085391035, 0.553553559300022}, {1.22597310556355, 
        0.572114872555289}, {1.22577895475611, 0.572024269781091}, {
        1.23845085391035, 0.553553559300022}}], 
       PolygonBox[{{1.22425051064187, 0.574784168987272}, {1.22638884995827, 
        0.572743374537426}, {1.22425051064187, 0.574784168987272}}]},
      "\"Brunei\""], 
     TooltipBox[
      {RGBColor[0.615957828808483, 0.702214188421314, 0.859151881207606], 
       PolygonBox[{{0.37580075200788, -0.689744650740963}, {
        0.382236311865634, -0.718377748765084}, {
        0.363066880764948, -0.732998915818694}, {
        0.321011097249632, -0.758708006441833}, {
        0.299915022217388, -0.717556162527841}, {
        0.37580075200788, -0.689744650740963}}]},
      "\"Bulgaria\""], 
     TooltipBox[
      {RGBColor[0.478367536381273, 0.734840231564404, 0.434522380989011], 
       PolygonBox[{{-0.0605081230339437, -1.29105281339953}, \
{-0.12303129803041, -1.27384482296496}, {-0.085653013277207, \
-1.23522177506905}, {0., -1.21752285801744}, {
        0.00495826889921382, -1.21751276188978}, {
        0.0527631845984336, -1.25889144709056}, {
        0.0214621896429679, -1.2719753864217}, {-0.00369532202636874, \
-1.27035455322859}, {-0.0628837657324476, -1.27060129122169}, \
{-0.0605081230339437, -1.29105281339953}}]},
      "\"Burkina Faso\""], 
     TooltipBox[
      {RGBColor[0.111795999854533, 0.179882040922673, 0.144535515373845], 
       PolygonBox[{{1.26598210920913, 0.194853283205657}, {1.18484175223469, 
        0.160898859324082}, {1.17479383952951, 0.141818949638269}, {
        1.19844154817185, 0.118916238735961}, {1.20078358534511, 
        0.0892336345392273}, {1.1530183000615, 0.0823122636850297}, {
        1.13006031540535, 0.0434125383147281}, {1.11747540398819, 
        0.0507442611612365}, {1.04648164863976, 0.0940096985907508}, {
        1.03567791668488, 0.129612429108544}, {1.01839559137746, 
        0.13136288727222}, {1.01769744894275, 0.145746005912642}, {
        1.04954722292916, 0.160915757129255}, {1.08084347782635, 
        0.142935500436647}, {1.07471647381052, 0.168296108563218}, {
        1.10341934921143, 0.217482420020624}, {1.12450223610479, 
        0.199966890435575}, {1.10341934921143, 0.217482420020624}, {
        1.12450223610479, 0.199966890435575}, {1.15819545996301, 
        0.149395677803879}, {1.18374460056792, 0.186075084496761}, {
        1.20375462595122, 0.173106277227985}, {1.24299696614628, 
        0.211725161049326}, {1.26598210920913, 0.194853283205657}}]},
      "\"Burma\""], 
     TooltipBox[
      {RGBColor[0.03107563720161, 0.626204638727271, 0.0120875701140719]},
      "\"Burundi\""], 
     TooltipBox[
      {RGBColor[0.570890562801699, 0.0632874846797197, 0.738104090035624], 
       PolygonBox[{{0.352288104115663, -1.27030986496331}, {
        0.418010565044137, -1.24328950109898}, {
        0.492558618138231, -1.17366154604911}, {
        0.495121904249889, -1.17306954164657}, {
        0.519778910007117, -1.19445936498172}, {
        0.622760677208135, -1.19886533782092}, {
        0.517663984051511, -1.26010656698746}, {
        0.444499214451534, -1.27642787397298}, {
        0.437914209350024, -1.29873583250181}, {
        0.391176060374575, -1.31356952886577}, {
        0.38684740542229, -1.33153750318943}, {
        0.333027576378098, -1.29549219160286}, {
        0.352288104115663, -1.27030986496331}}]},
      "\"CAR\""], 
     TooltipBox[
      {RGBColor[0.562068033718482, 0.284522364277182, 0.615142596365582]},
      "\"Cabinda\""], 
     TooltipBox[
      {RGBColor[0.653848101673417, 0.524657302158816, 0.631909471786007], 
       PolygonBox[{{1.23950421542058, 0.319403829109625}, {1.23163364604286, 
        0.282458846925879}, {1.20894272852582, 0.264329006658566}, {
        1.18350254514252, 0.321920233923219}, {1.16480890371932, 
        0.368380684410277}, {1.19552436773345, 0.378094710135335}, {
        1.21513150729917, 0.344993152547656}, {1.23950421542058, 
        0.319403829109625}}]},
      "\"Cambodia\""], 
     TooltipBox[
      {RGBColor[0.436271240417127, 0.552064931988024, 0.969567917689246], 
       PolygonBox[{{0.236122838022201, -1.36463860705919}, {
        0.230703789259932, -1.34261696777976}, {
        0.202401740248266, -1.33831913978802}, {
        0.226013096277478, -1.3084762679155}, {
        0.272668448228013, -1.29577246830996}, {
        0.319811810433679, -1.22339871635005}, {
        0.302328529405543, -1.20659085892978}, {
        0.347577438766791, -1.23792831833596}, {
        0.311100365744815, -1.25241042275575}, {
        0.352288104115663, -1.27030986496331}, {
        0.333027576378098, -1.29549219160286}, {
        0.38684740542229, -1.33153750318943}, {
        0.31913023999016, -1.35001591837839}, {
        0.272612320834712, -1.36017264068953}, {
        0.236122838022201, -1.36463860705919}}]},
      "\"Cameroon\""], 
     TooltipBox[
      {RGBColor[0.0159516429775239, 0.734057051995813, 0.692913050780418], 
       PolygonBox[CompressedData["
1:eJwVlHk41PkDx6noptw2HbJlt3QIaRMfR7nTipRKukm1KkSHsrIhFYYRiWId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        "]], 
       PolygonBox[{{-0.460239988153812, 
        0.409578812136219}, {-0.463341577829552, 
        0.427559302170237}, {-0.449489125756784, 
        0.4201342541212}, {-0.460239988153812, 0.409578812136219}}], 
       PolygonBox[{{-0.533805576812985, 
        0.409110237845919}, {-0.59325455669419, 
        0.393411573788567}, {-0.533686548886197, 0.409265498283118}}], 
       PolygonBox[{{-0.241199734396438, 
        0.137763939382261}, {-0.259682890877221, 
        0.122843970173892}, {-0.27626114971663, 
        0.178038161831891}, {-0.253581143048253, 
        0.184237484724767}, {-0.223877285909179, 
        0.155502205576206}, {-0.241159650286785, 0.137834095711428}}], 
       PolygonBox[{{-0.275063599305699, 
        0.125933948180941}, {-0.288082990674349, 
        0.0969506376827681}, {-0.304369737536465, 
        0.0980155068496336}, {-0.275272605100683, 
        0.0898843365467261}, {-0.295545115231223, 
        0.0802978306149745}, {-0.338422609493055, 
        0.0655783891462732}, {-0.358617276392687, 
        0.082134320729322}, {-0.341084194205385, 
        0.101573588921865}, {-0.343106587453941, 
        0.147883373343743}, {-0.308242012464534, 
        0.160005062982386}, {-0.317834956753178, 
        0.125091731037486}, {-0.298722559394026, 
        0.155947159685199}, {-0.290686052270111, 
        0.135961129977849}, {-0.278144905508695, 
        0.154813468392822}, {-0.263851158378103, 
        0.136475462177837}, {-0.275063599305699, 0.125933948180941}}], 
       PolygonBox[{{-0.43107725661741, -0.0528023504550079}, \
{-0.453554167065934, -0.0721064342557357}, {-0.463302577080283, \
-0.038633178488023}, {-0.45643284777424, -0.0224563809036663}, \
{-0.416025496371164, -0.0318896866462104}, {-0.43107725661741, \
-0.0528023504550079}}], 
       PolygonBox[{{-0.277307506593934, 
        0.0716305433125733}, {-0.28766142879034, 
        0.0786053292299946}, {-0.274671739631715, 
        0.0841503432561156}, {-0.277307506593934, 0.0716305433125733}}], 
       PolygonBox[{{-0.346014271697867, 
        0.0478082854472513}, {-0.368464861031782, 
        0.0356954945692746}, {-0.361517159417656, 
        0.060064884822045}, {-0.346014271697867, 0.0478082854472513}}], 
       PolygonBox[{{-0.542585973000071, -0.371284586859871}, \
{-0.578881832045948, -0.378088576760464}, {-0.575972656680687, \
-0.397584248245181}, {-0.559187667897751, -0.414028887028194}, \
{-0.583729963004822, -0.429315357995187}, {-0.569854935847518, \
-0.432021133311685}, {-0.590584121420137, -0.443691799702892}, \
{-0.583006368874156, -0.419704529283327}, {-0.605021347415155, \
-0.417636071424998}, {-0.593237362913509, -0.403668427423057}, \
{-0.62165421586765, -0.369111262230775}, {-0.618093295341751, \
-0.365539355876178}, {-0.581355445318752, -0.365626890923535}, \
{-0.542812689115289, -0.371439725774922}}], 
       PolygonBox[{{-0.638930288171592, -0.364193118027733}, \
{-0.660475224357638, -0.363850258488649}, {-0.648458372374925, \
-0.377411785148211}, {-0.65947346263177, -0.357816528903235}, \
{-0.638930288171592, -0.364193118027733}}], 
       PolygonBox[{{-0.34740842542632, -0.145799284754283}, \
{-0.355135269531346, -0.194699504533998}, {-0.389346560743774, \
-0.193696988766468}, {-0.3694580332469, -0.177411220568985}, \
{-0.382210366995413, -0.150299862548538}, {-0.391196909875396, \
-0.162973085106119}, {-0.423408628666482, -0.20074741330467}, \
{-0.423987908982042, -0.162753709548075}, {-0.444305517484257, \
-0.197198430126487}, {-0.441700008984615, -0.14864847603568}, \
{-0.427573751894484, -0.112969858211426}, {-0.433136797392757, \
-0.0920660683865695}, {-0.41474417112949, -0.0924529946554231}, \
{-0.423539785692442, -0.110455422640417}, {-0.407662770114361, \
-0.120884214187954}, {-0.394563945754929, -0.133936411780449}, \
{-0.37971602189224, -0.144114206464665}, {-0.385366704838326, \
-0.117941012816805}, {-0.359630192366158, -0.0853444173193691}, \
{-0.329398725608527, -0.0639291931607941}, {-0.347781314181729, \
-0.0553943017378759}, {-0.343058164892099, -0.0124794471596281}, \
{-0.328651230591082, -0.00248566735519136}, {-0.31487990250449, 
        0.0000915948533677818}, {-0.28001711444111, -0.018844169564653}, \
{-0.3298669634658, -0.0184424264400625}, {-0.296501383930766, \
-0.0223807893176334}, {-0.28017771100241, -0.0395426433116821}, \
{-0.310974511735109, -0.0494389971779874}, {-0.292324542130537, \
-0.067130270026261}, {-0.315921468104515, -0.0841586147692382}, \
{-0.316585162151088, -0.094478419678327}, {-0.30451396608553, \
-0.0994324727693079}, {-0.321040739935581, -0.100505520486996}, \
{-0.329141682810559, -0.109916383341916}, {-0.311809879198741, \
-0.1143119527041}, {-0.32422907953351, -0.124459882745552}, \
{-0.333957136578561, -0.121330477180611}, {-0.329656765672888, \
-0.141518144303223}, {-0.343308204805612, -0.12904107065616}, \
{-0.34740842542632, -0.145799284754283}}], 
       PolygonBox[{{-0.276964506071593, 
        0.024637218326415}, {-0.280072733232753, 
        0.000977642238755549}, {-0.312367771921329, 
        0.0222081459490474}, {-0.276964506071593, 0.024637218326415}}], 
       PolygonBox[{{-0.193105415491127, 
        0.105503204290495}, {-0.208604664330706, 
        0.101292982588989}, {-0.213361334443697, 
        0.124844868433298}, {-0.203128896700287, 
        0.132081525259831}, {-0.193105415491127, 0.105503204290495}}], 
       PolygonBox[{{-0.180329320574542, 
        0.0439595498437079}, {-0.209233035597296, 
        0.0338258999933143}, {-0.196231467072849, 
        0.0519076608418945}, {-0.180329320574542, 0.0439595498437079}}], 
       PolygonBox[{{-0.228951909413852, 
        0.0419516995071974}, {-0.256748006868322, 
        0.0343335157571257}, {-0.24529768822861, 
        0.0556552350664557}, {-0.230899033908021, 
        0.0485177783657614}, {-0.228951909413852, 0.0419516995071974}}]},
      "\"Canada\""], 
     TooltipBox[
      {RGBColor[0.491200381307972, 0.28111141141312, 0.299534671006801], 
       PolygonBox[{{0.469492194326178, -1.05449673351758}, {
        0.302260191994464, -1.05410655935962}, {
        0.285703606990462, -1.06626037719409}, {
        0.31481744587998, -1.09789890793495}, {
        0.317959889492549, -1.14782277442007}, {
        0.291149715330406, -1.20041257358199}, {
        0.302328529405543, -1.20659085892978}, {
        0.347577438766791, -1.23792831833596}, {
        0.311100365744815, -1.25241042275575}, {
        0.352288104115663, -1.27030986496331}, {
        0.418010565044137, -1.24328950109898}, {
        0.492558618138231, -1.17366154604911}, {
        0.464051556019837, -1.15825694822722}, {
        0.471446759302288, -1.11426188676445}, {
        0.491259593455522, -1.10338711243434}, {
        0.469492194326178, -1.05449673351758}}]},
      "\"Chad\""], 
     TooltipBox[
      {RGBColor[
       0.581117050925885, 0.3113183403853, 
        0.136575896039275], {}, {}, {}, {}, {}},
      "\"Chile\""], 
     TooltipBox[
      {RGBColor[0.268459033805191, 0.954912412198614, 0.299230770271228], 
       PolygonBox[CompressedData["
1:eJxdlGk41AkAh60nWyraxyAkDcqdZNkO1S8UMZGjSWotZtUgR7tFuXJudmvb
kCtXqMmKtZH7+kvGsXKHSWN2JnYO53+obbW1bft1P/ye99P7PO+nnzYj1O2M
rIyMjOvH/Uc7kUhl4IgQ0o73qhmRPFj/ZVVTVClCLKu1U7uCi3eP2BVX3gjR
ExjMS0/jgmW/EED9UYispZBUzzVcdOhvdggOFyHljnLW2aUJ3KxY+WJdlRgH
o6VRbLkJmIczb/WPiRGnSVU3CH+BxjHjkXauCPRdxnEJd3moWVXmYkBIEJNd
5pPM52LMS1vUeWEGFJMUjw2X+FBrUiu3H5lB3G3O8u1YHt5lvjXQ75zB8ezD
WaklfPj0pBLOmbNI1Ms8vflTPpzUU+Ndt83i6ESk3+J6AexDh2Q9WudAfcD1
573kYy9r5yGvtHnkxt09mRfGR4/DTlqB0SJa6uhvkj7hw5NWHLvDmoR2o6j0
Jn0SLkS1KtWMxFb39AVHOS66FEcU/L1IDHrKRw0lc6Fie8ziWTOJv5/um7x8
YwJOu5eMQ4Qklkv6DzxWeo431JUyjoUU1a9JxflFDlopgzYymlLUvfK9P1nN
wdGeKLu2BRKFFLp7WwYHjlub8r/VkkJJcUpPd+8Ykipo/BaqFDKSile2gWM4
mxs/rPOWhFuQRWDuxDDsExma3kwpIoTWyi8X+rCww2h9bokU2uz6jvCxXrgP
1QnlzaXgnTJUabzGRnXraLIOTYoUebGghtaOqQDf1Uu/kXD+oGs5ld2B4+JO
rZgjH/uDwzT7S9qBmtcmnjQSjqu8O2IH23CL4X6oQZ7E/az+FYpnE/xVWZyG
ZBKiHL/CxIgC0ExpwWwmCZ0TNjfz1dKai/EPc+89EuYMDa0/dNMJJaeJBf14
EiMe9Q/VNhQR8WeuctYmLoL9hLyhP/+E+C6YonBZdwEtk9FX1xDdhO21/KbP
zBdgc++cWxOjkwiITmxVjJtHVrFpQoFeF2FkvcftjNI8evd3p6qrdhAUDvMb
zr05bEzI1Wlp7iYGD3y9vTthFvTvFXqsffuJE5U2RQfDZtFcv2h6o7iPYPvW
99WtSPBls36aRm8fsSF/UTmvSIKouG1BGpmPifc/h1BUDMVwSStK6Dz8mHgi
ezGjYZcYzw9s1luxayAWDztZ9BmL0Nmwrox1v5ZQDHd9ZuogQoVPZFfklnJi
MDTA1eKEELxL7P12rELCwWAonXFMiOEyb7d82VzCItjy+INIEUqTxL9ScpOh
YrpPN9VdDCt3H9YduURoSuJ/+apdjHMFe+R2N1QhPYcqR4+VwLKnxU8wVIvy
bqNswxgJLp5i0siBWsR4uV8PhAQXEs2Czsf1gvVu14tlqhjs7ZQZ+cohCENS
Gel0EVK3V0wLhodx2mvuc9VSIdqGTVQyjg2j9qk6ZS5qGtfObzTs+mkcGkxz
ayvjaVwx6yqyHR/FROHylumWaeQkuQZ7ckfQuCnDL6BoCtfDyORH7SOIaNSe
k1WbAp03OKjuPQrdbBudjQ8FcLGqysm/8AylYlnZ/asFaIoeHfjTeRSWJxUH
HkbzUXjaOlLvzjgi6OYuH84LwDxLH496OgHq73n6LQoCOK/VpgQ5TcJD2awh
L0SAsPLQSjlHHkYCtpm07+RDi6FTc3IdH7VhMZo/jH70NUP0OVV8UI8W2+qn
vISlmn9AzSY+kul1l/xzphAsCWyn9fHx///7FxShkKc=
        "]], 
       PolygonBox[{{1.08113211621654, 0.384265247677663}, {1.07176282895392, 
        0.410338457293179}, {1.09050088622452, 0.408444845919959}, {
        1.10692350650818, 0.374314089942472}, {1.08102029224805, 
        0.38457972000036}}]},
      "\"China\""], 
     TooltipBox[
      {RGBColor[0.565685333237576, 0.205171549125472, 0.216808322162991], 
       PolygonBox[{{-1.19424114533975, -0.403841173180835}, \
{-1.22630500428198, -0.331647980223702}, {-1.2782566239936, \
-0.300989481101013}, {-1.27176080563837, -0.285049168992082}, \
{-1.29273188023858, -0.277531049252266}, {-1.33025209100775, \
-0.306297844616997}, {-1.36989848839532, -0.270833118395208}, \
{-1.36925257151969, -0.353761777735679}, {-1.36925257151969, \
-0.353761777735679}, {-1.34499702392791, -0.437016024448821}, \
{-1.3292452641191, -0.48281158624968}, {-1.3292452641191, -0.48281158624968}, \
{-1.32256334439727, -0.480067054920722}, {-1.3137952186015, \
-0.501251763078299}, {-1.30761770760785, -0.479814469086006}, \
{-1.28662001120587, -0.549674867493522}, {-1.27764628169158, \
-0.520097611290332}, {-1.23354713737585, -0.512213576996737}, \
{-1.26017101659274, -0.409454383912825}, {-1.24232034830743, \
-0.37074530734419}, {-1.19424114533975, -0.403841173180835}, \
{-1.19424114533975, -0.403841173180835}}]},
      "\"Colombia\""], 
     TooltipBox[
      {RGBColor[0.737162736552746, 0.281162968960394, 0.59002895275989], 
       PolygonBox[{{0.421651897303275, -1.34989246886578}, {
        0.437914209350024, -1.29873583250181}, {
        0.391176060374575, -1.31356952886577}, {
        0.38684740542229, -1.33153750318943}, {
        0.31913023999016, -1.35001591837839}, {
        0.318650130054008, -1.36213580980585}, {
        0.351195060977002, -1.35797054114354}, {
        0.353697193752117, -1.36926925589231}, {
        0.353697193752117, -1.36926925589231}, {
        0.421651897303275, -1.34989246886578}}]},
      "\"Congo\""], 
     TooltipBox[
      {RGBColor[0.562960220489574, 0.21250543439393, 0.649253497174386], 
       PolygonBox[{{-1.26546658901983, -0.140826707983379}, \
{-1.28050717566319, -0.167066437405127}, {-1.30162089472708, \
-0.162125452786861}, {-1.2832328914238, -0.0972375740611045}, \
{-1.26765219637442, -0.0956860853698945}, {-1.26546658901983, \
-0.140826707983379}}]},
      "\"Costa Rica\""], 
     TooltipBox[
      {RGBColor[0.153757712342763, 0.0108952885015491, 0.242937516704685], 
       PolygonBox[{{-0.178237473241261, -1.34778840713859}, \
{-0.0730122235276422, -1.34813207891472}, {-0.0730122235276422, \
-1.34813207891472}, {-0.0605081230339437, -1.29105281339953}, \
{-0.0605081230339437, -1.29105281339953}, {-0.123009806762844, \
-1.27362230609026}, {-0.12303129803041, -1.27384482296496}, \
{-0.177867792366886, -1.27095979136283}, {-0.177867792366886, \
-1.27095979136283}, {-0.194027409597196, -1.30345462527904}, \
{-0.194027409597196, -1.30345462527904}, {-0.177845409950511, \
-1.34784019729497}}]},
      "\"Cote d'Ivoire\""], 
     TooltipBox[
      {RGBColor[0.633301854196862, 0.41970066034695, 0.317982237721131], 
       PolygonBox[{{0.258266703507711, -0.765214345575893}, {
        0.191277307121382, -0.736080188589808}, {
        0.182993029487947, -0.734855531958806}, {
        0.203823610600412, -0.724316726619541}, {
        0.210439973192446, -0.708918666520223}, {
        0.231018795056599, -0.716673239394222}, {
        0.242500183166379, -0.710307159442284}, {
        0.247257609384978, -0.726314455576295}, {
        0.242176765653712, -0.725191875508916}, {
        0.209582852679191, -0.733316898782488}, {
        0.214183629409859, -0.742056591125846}, {
        0.219372768663829, -0.74696889046995}, {
        0.257363708973687, -0.763271580809863}, {
        0.258266703507711, -0.765214345575893}}]},
      "\"Croatia\""], 
     TooltipBox[
      {RGBColor[0.751737135396712, 0.352190442783742, 0.120165989340149], 
       PolygonBox[{{-1.11518781221546, -0.0992008903747662}, \
{-1.08756470935906, -0.169659912328837}, {-1.09455024737005, \
-0.246667551498946}, {-1.10092430895621, -0.312914189947879}, \
{-1.11772174138617, -0.248475256137715}, {-1.09737449299731, \
-0.156505210843077}, {-1.11518781221546, -0.0992008903747662}}]},
      "\"Cuba\""], 
     TooltipBox[
      {RGBColor[0.736865186795246, 0.440418795011413, 0.215614546744468], 
       PolygonBox[{{0.518313988122805, -0.751806681632961}, {
        0.507076545046195, -0.779835778964554}, {
        0.492467623958488, -0.780011083417261}, {
        0.518313988122805, -0.751806681632961}}]},
      "\"Cyprus\""], 
     TooltipBox[
      {RGBColor[0.851706955534958, 0.781952774596632, 0.141188024740185], 
       PolygonBox[{{0.202991623051869, -0.68455693672848}, {
        0.211645558944311, -0.660518736954962}, {
        0.22464475567327, -0.648125553090248}, {
        0.171476049987605, -0.647485318283944}, {
        0.142298328206829, -0.663762397814222}, {
        0.168379750971715, -0.683801956915674}, {
        0.202991623051869, -0.68455693672848}}]},
      "\"Czech Republic\""], 
     TooltipBox[
      {RGBColor[0.649929213506892, 0.646535406409486, 0.565144452433641], 
       PolygonBox[{{0.0908749245289849, -0.596189829871162}, {
        0.0813493296659083, -0.569216028749893}, {
        0.0980047005930675, -0.558662695314442}, {
        0.0819483442725566, -0.565187892112646}, {
        0.101753691462396, -0.546352504126062}, {
        0.0992447922661907, -0.596259498002563}, {
        0.090833131100198, -0.595915641833842}}]},
      "\"Denmark\""], 
     TooltipBox[
      {RGBColor[0.404025288187439, 0.368766244546498, 0.0565064536495959], 
       PolygonBox[{{0.421651897303275, -1.34989246886578}, {
        0.437914209350024, -1.29873583250181}, {
        0.444499214451534, -1.27642787397298}, {
        0.517663984051511, -1.26010656698746}, {
        0.622760677208135, -1.19886533782092}, {
        0.703163946174468, -1.17645402892555}, {
        0.721015269011756, -1.18586178868153}, {
        0.712910987100188, -1.22137542323064}, {
        0.712910987100188, -1.22137542323064}, {
        0.681302579637714, -1.23928479171617}, {
        0.602142848708934, -1.27961868919952}, {
        0.5206067350492, -1.31490251631876}, {
        0.437016024448821, -1.34499702392791}, {
        0.421651897303275, -1.34989246886578}}]},
      "\"Democratic Republic of the Congo\""], 
     TooltipBox[
      {RGBColor[0.0021842319440678, 0.191519853793509, 0.719512747372112], 
       PolygonBox[{{0.867419477765331, -0.921019815504945}, {
        0.854865897081479, -0.932377768154096}, {
        0.853602791556854, -0.911648145481145}, {
        0.842738283991868, -0.943655782398373}, {
        0.866796351985793, -0.931153098814062}, {
        0.867419477765331, -0.921019815504945}}]},
      "\"Djibouti\""], 
     TooltipBox[
      {RGBColor[0.902748741306833, 0.991288943442519, 0.948582337088824], 
       PolygonBox[{{-1.09362451352694, -0.360270601863105}, \
{-1.08449977224453, -0.431209491321136}, {-1.11598154792292, \
-0.367275815604619}, {-1.09362451352694, -0.360270601863105}}]},
      "\"Dominican Republic\""], 
     TooltipBox[
      {RGBColor[0.0862108931752497, 0.483048080959883, 0.673306705721388], 
       PolygonBox[{{-1.39288650673277, -0.244677705077062}, \
{-1.36989848839532, -0.270833118395208}, {-1.36925257151969, \
-0.353761777735679}, {-1.36925257151969, -0.353761777735679}, \
{-1.36978344275432, -0.351700611253573}, {-1.38916395212669, \
-0.264997196422431}, {-1.39288650673277, -0.244677705077062}}]},
      "\"Ecuador\""], 
     TooltipBox[
      {RGBColor[0.196845201692112, 0.734020450391507, 0.362882091619734], 
       PolygonBox[{{0.641720930116107, -0.895795672341347}, {
        0.538074413079161, -0.850054229341313}, {
        0.581975636483644, -0.854745706170843}, {
        0.576993427031157, -0.825053200039191}, {
        0.576608166698776, -0.826548423244323}, {
        0.552659454571066, -0.8111818055236}, {
        0.550953435063514, -0.810196307405362}, {
        0.414346700761478, -0.882529803984992}, {
        0.472650265685084, -1.01360176574234}, {
        0.626331979321844, -0.930909972370642}, {
        0.641720930116107, -0.895795672341347}}]},
      "\"Egypt\""], 
     TooltipBox[
      {RGBColor[0.936441518926141, 0.756426406680699, 0.51840590364704], 
       PolygonBox[{{-1.23821558888763, -0.0468460331179025}, \
{-1.23475648249735, 
        0.00215505879622066}, {-1.22527551066417, -0.0139009060963167}, \
{-1.23821558888763, -0.0468460331179025}}]},
      "\"El Salvador\""], 
     TooltipBox[
      {RGBColor[0.511175136084776, 0.15448874432951, 0.615238381940514], 
       PolygonBox[{{0.23860282967462, -1.38136305032265}, {
        0.236122838022201, -1.36463860705919}, {
        0.272612320834712, -1.36017264068953}, {
        0.275880433879489, -1.37440357003607}, {
        0.23860282967462, -1.38136305032265}}]},
      "\"Equatorial Guinea\""], 
     TooltipBox[
      {RGBColor[0.868476690140148, 0.86463972967529, 0.589344291895868], 
       PolygonBox[{{0.728841960017028, -0.986172756052667}, {
        0.715383561628229, -0.949346050931107}, {
        0.733387892130999, -0.918151246295393}, {
        0.777249349873768, -0.935647445397382}, {
        0.853602791556854, -0.911648145481145}, {
        0.850106892824736, -0.922328083808489}, {
        0.766636075454311, -0.952367846977842}, {
        0.728841960017028, -0.986172756052667}}]},
      "\"Eritrea\""], 
     TooltipBox[
      {RGBColor[0.211213093753076, 0.499710445593649, 0.808133276025694], 
       PolygonBox[{{0.24737343204828, -0.464589508047126}, {
        0.256828074329747, -0.491266795881813}, {
        0.226015522117218, -0.505264028015609}, {
        0.211385432910452, -0.486927698035751}, {
        0.24737343204828, -0.464589508047126}}]},
      "\"Estonia\""], 
     TooltipBox[
      {RGBColor[0.5871600599518, 0.019693239959567, 0.780197698221537], 
       PolygonBox[{{0.728841960017028, -0.986172756052667}, {
        0.766636075454311, -0.952367846977842}, {
        0.850106892824736, -0.922328083808489}, {
        0.842738283991868, -0.943655782398373}, {
        0.866796351985793, -0.931153098814062}, {
        0.902560798440537, -0.934085154061405}, {
        0.974838310403411, -0.878261957874581}, {
        0.955503442733523, -0.957172567852658}, {
        0.911063481765714, -1.01539684352387}, {
        0.872506622458075, -1.05780809316814}, {
        0.795821753741683, -1.098039157755}, {
        0.714788515782288, -1.10137905469587}, {
        0.71999572080542, -1.05613405706063}, {
        0.736859042940993, -1.00863588183765}, {
        0.728841960017028, -0.986172756052667}}]},
      "\"Ethiopia\""], 
     TooltipBox[
      {RGBColor[
       0.905384534718861, 0.595871116509282, 0.0711109028707431], {}, {}},
      "\"Falkland Islands\""], 
     TooltipBox[
      {RGBColor[0.693986805046288, 0.422336453758979, 0.922564410787894]},
      "\"Fiji\""], 
     TooltipBox[
      {RGBColor[0.874265701178631, 0.95996635465478, 0.0594543621392449], 
       PolygonBox[{{0.171516013794204, -0.382235030180207}, {
        0.186384378583742, -0.391642167623049}, {
        0.169504378408467, -0.439280864267665}, {
        0.185420948381087, -0.472733666669371}, {
        0.202597467685347, -0.480004856413011}, {
        0.237483854650695, -0.449160643685577}, {
        0.245269109397436, -0.398939224442785}, {
        0.176514310976078, -0.318221905263266}, {
        0.176098015114011, -0.318125568061854}, {
        0.16184003928846, -0.30566264413256}, {
        0.15846697672769, -0.328536045673848}, {
        0.127934184825173, -0.340363382776247}, {
        0.171516013794204, -0.382235030180207}}]},
      "\"Finland\""], 
     TooltipBox[
      {RGBColor[0.986122891861753, 0.117839294497932, 0.441560451007741], 
       PolygonBox[{{0.102908199443901, -0.778166766436672}, {
        0.101619108749793, -0.778875757211867}, {
        0.101200413766638, -0.779200024072052}, {
        0.0534138063163515, -0.786875035295668}, {
        0.0452575463016063, -0.805287511269029}, {
        0.0245985702169268, -0.805117690224207}, {
        0.0210435323439752, -0.80362007838354}, {-0.0243887538006001, \
-0.79071497208489}, {-0.0145009515727743, -0.74394458978519}, \
{-0.0590645383474456, -0.705843116700257}, {-0.0166427460054092, \
-0.706209361576175}, {-0.023224699059436, -0.688020085505437}, {
        0., -0.694962468988263}, {0.0296419325776646, -0.665582796296258}, {
        0.07009962607559, -0.688126951600439}, {
        0.0768228917214943, -0.68850725236002}, {
        0.100380745417517, -0.693734935148556}, {
        0.095481568949316, -0.71719240406325}, {
        0.0775159962097096, -0.741665829492651}, {
        0.0918708126844487, -0.744646003177747}, {
        0.102908199443901, -0.778166766436672}}]},
      "\"France\""], 
     TooltipBox[
      {RGBColor[0.548279226054469, 0.831634147532243, 0.502600912557418], 
       PolygonBox[{{-1.09177711961488, -0.788380459749253}, \
{-1.07352498203041, -0.810919215944902}, {-1.06985256147654, \
-0.845424067797287}, {-1.10231907599518, -0.838729078910433}, \
{-1.12928799198328, -0.802048903917455}, {-1.09177711961488, \
-0.788380459749253}}]},
      "\"French Guiana\""], 
     TooltipBox[
      {RGBColor[0.573083760867593, 0.683639496379179, 0.242289855636375], 
       PolygonBox[{{0.23860282967462, -1.38136305032265}, {
        0.224564536443981, -1.39627030655661}, {
        0.224564536443981, -1.39627030655661}, {
        0.264997196422431, -1.38916395212669}, {
        0.351700611253572, -1.36978344275432}, {
        0.353697193752117, -1.36926925589231}, {
        0.353697193752117, -1.36926925589231}, {
        0.351195060977002, -1.35797054114354}, {
        0.318650130054008, -1.36213580980585}, {
        0.31913023999016, -1.35001591837839}, {
        0.272612320834712, -1.36017264068953}, {
        0.275880433879489, -1.37440357003607}, {
        0.23860282967462, -1.38136305032265}, {
        0.23860282967462, -1.38136305032265}}]},
      "\"Gabon\""], 
     TooltipBox[
      {RGBColor[0.291387818804343, 0.0733733152739434, 0.875506220353485], 
       PolygonBox[{{-0.352719724316879, -1.18569391233579}, \
{-0.326905223162933, -1.19496423820389}, {-0.358681558480101, \
-1.19176833993415}, {-0.3585502963344, -1.1913322035737}, \
{-0.295730520590755, -1.20399900742056}, {-0.352719724316879, \
-1.18569391233579}}]},
      "\"The Gambia\""], 
     TooltipBox[
      {RGBColor[0.655129795684575, 0.271694578844776, 0.293175617052406], 
       PolygonBox[{{0.508675221345217, -0.606215522501817}, {
        0.556633622857932, -0.577418541074718}, {
        0.590227037398288, -0.564033208130715}, {
        0.60997298120953, -0.567814632841487}, {
        0.584387804709516, -0.584047920524875}, {
        0.571925653190084, -0.609749451735716}, {
        0.544483058539171, -0.614705160081436}, {
        0.508675221345217, -0.606215522501817}}]},
      "\"Georgia\""], 
     TooltipBox[
      {RGBColor[0.970121685634624, 0.0592586791752931, 0.200583675974033], 
       PolygonBox[{{0.0790534374305641, -0.6257723927953}, {
        0.106871592640003, -0.616581629492795}, {
        0.090833131100198, -0.595915641833842}, {
        0.0992447922661907, -0.596259498002563}, {
        0.0991992647135842, -0.595985969940863}, {
        0.117024340157419, -0.607698782150309}, {
        0.153395754183484, -0.603261644981262}, {
        0.152228904537572, -0.600134405987067}, {
        0.171476049987605, -0.647485318283944}, {
        0.142298328206829, -0.663762397814222}, {
        0.168379750971715, -0.683801956915674}, {
        0.163677936412025, -0.706154982643083}, {
        0.122457911989656, -0.713907242473257}, {
        0.120380724834887, -0.714260437202609}, {
        0.095481568949316, -0.71719240406325}, {
        0.100380745417517, -0.693734935148556}, {
        0.0768228917214943, -0.68850725236002}, {
        0.0728509099042845, -0.677950101746538}, {
        0.0704087239219622, -0.668024942222452}, {
        0.0790534374305641, -0.6257723927953}}]},
      "\"Germany\""], 
     TooltipBox[
      {RGBColor[0.599188812006118, 0.547785231875645, 0.136694268387399], 
       PolygonBox[{{-0.0730122235276422, -1.34813207891472}, {
        0., -1.34322567311519}, {0.0279992545649475, -1.33667045268134}, {
        0., -1.2775356350312}, {-0.00185614579599811, -1.27619094337471}, {
        0., -1.27080921736828}, {-0.00332579071487952, -1.27035557440805}, \
{-0.0628837657324476, -1.27060129122169}, {-0.0605081230339437, \
-1.29105281339953}, {-0.0730122235276422, -1.34813207891472}}]},
      "\"Ghana\""], 
     TooltipBox[
      {RGBColor[0.326317974795401, 0.639222457351338, 0.4883308697364], 
       PolygonBox[{{-0.0846801468338878, -0.901419479652322}, \
{-0.0849666888837727, -0.901653030589599}, {-0.0847044050577968, \
-0.901677708250062}}]},
      "\"Gibraltar\""], 
     TooltipBox[
      {RGBColor[0.150571376525646, 0.208478680297469, 0.197662006343597], 
       PolygonBox[{{0.365870522382473, -0.749039414581311}, {
        0.335177737216589, -0.763556197879213}, {
        0.321755962939583, -0.773603254862568}, {
        0.330634929374254, -0.797567048441747}, {
        0.356254949706623, -0.797662597903665}, {
        0.341198069262504, -0.8149942497033}, {
        0.3550345354411, -0.828357634045127}, {
        0.316471242504423, -0.820154394998568}, {
        0.330417268831126, -0.808990038919939}, {
        0.344925782252007, -0.803480842221569}, {
        0.298337997771278, -0.802921508868271}, {
        0.29103240476326, -0.798881829125424}, {
        0.297853115728985, -0.776609042975929}, {
        0.321011097249632, -0.758708006441833}, {
        0.363280086142893, -0.732893272933912}, {
        0.365870522382473, -0.749039414581311}}]},
      "\"Greece\""], 
     TooltipBox[
      {RGBColor[0.940051643681931, 0.318937228993403, 0.70587776774005], 
       PolygonBox[CompressedData["
1:eJxdlHk01AkAx8dNrdlpbIuySk219darVoiOndBLUnIvjX2FWcUsOdLSgWhr
xu421AvVOtoOkwxjzUxj5DsatzH3b3hFEg1avY7tekjb/rt/fN7n389fH5fY
lBCmKYlE2vGJ/7zFjdliPq1EpHdiAj2TgDDj5Xl5XjeCiMKlLtZ66F/Vj7oq
25Fq+Czww7cE8mZCVwQ8lIG3om2OzdUj3sZqD8mnHQN/vParNtdhyDyJPTzS
CsXZ9weG1Vr8/HHcjG0lB0XWz85P10B8rTSH/Axwkpg4H1uvxzupYXLTmAwP
qv0vqW5p8D5gNsh8Vga6/vAbWpQaY5a+oVlKCXjUg4EZ2zQoOmI9bv1Aguuh
S4fOqVSoMl7Ye++YCLxvbumeR6ixYsKJV7hRgpOi+NWZhUq4Z7pWSNlC2Mb9
yBELlKDY/DBalCyCZ6f/nuAlvXj3pC2hwL4B5J6JNMcbvbCr7ogwXmpEzVfZ
dz9mdGPMOs1nin0TT9feGKmKacPmWqOwrICPuYv+zIJyOarUC4ZuF1WAm/jl
Pq+we3jrkPfLmRwBan/63X+3txy3T09JeNpbULgdH+FFybByfNTyTDofYU2a
sohVMrgWHouts2pE2ESzTaEPsNbdilJuUY35zcUmjZ0tiHTcQhzqaUD9Smfa
IkYTFJHcuykzPBwdrDS7ai1F1vcT/FpKHfy8qNKl42LwR+s45vUi7F9j3xYX
LwRj/aBURRJCZylYVeosweNXZXHZy8RQ0dd4stgiuFVfUNo+kmC5gT4v1r0J
E6b0WeGVZnCmoqh+S+4g3khOinZswYDN2P3U2AYURAbceegsg8XG0W3MA0Ls
9RgvbfUGuEEZh0nPBUgN5LkudupAgt8XwXnDf+GUL5dzJbsLxg0xz8Mr+OAU
hVzcmtUNj8HLm8RXRJjy3MFfuK8XOcNDx2vSGrB/yTwW9YECogvim/VSEbbn
s9RM016ctRzI9V0IeElM+OKHatAea/kz/R3o+i28xK1MBcJ41J4W2gna7O50
f6EaJ444eVtwexHCKs5p5miwrvl97gtjF1xuBgkoCzSQ77yotWIpMNFYszM6
SIdo5v2c6QYFKotj8k4ptXh7KU3RH68C40ZPSfMiPVaNxRba5/Yhc/IliUvW
wcIuybvIqERWk9w9PUEPhuOu6ZDePliQn43uyNdBIWTERa9WYzIoivzovB6V
hya/nveiDzMfroU+CSSQaFxzrp2jAj95OPtzrg7Fom1zPolqUMO2Fr1kEvgu
6XaEolGFsKu7n/7drUfG8j/3+CzW4MRg3c6TEgL/lJhu8ahSY7pV5MErMCBt
/tqOgRINqISD8XQ4gZS9JylyowaVdZoNuRIDDjaOy3xbtfB9HbCdbjsAqnV7
Tkc2ASljnZVZqeFTN/1wMssAWgYl3InVj3bddu3d0H7YzTzyenPOgIB6QUuI
0wDmNgdfpy0iUJ7SmbuL3I/jtrULXCr0+FAuEHE+EmA4XP41eZkWnrOJWaUd
evz/L/8CQyl62A==
        "]], 
       PolygonBox[{{-0.277612480062104, -0.199484803642125}, \
{-0.278003717028138, -0.218505582537161}, {-0.29001239771837, \
-0.214076124527805}, {-0.277612480062104, -0.199484803642125}}]},
      "\"Greenland\""], 
     TooltipBox[
      {RGBColor[0.624578245476004, 0.256412147302752, 0.0766473733570279], 
       PolygonBox[{{-1.20480807676899, -0.0227829051561389}, \
{-1.20699081205175, -0.0375797714296957}, {-1.22527551066417, \
-0.0139009060963167}, {-1.23475648249735, 
        0.00215505879622066}, {-1.22280097410079, 
        0.0480439811215027}, {-1.20215027055934, 
        0.0363789980010012}, {-1.2022013222483, 
        0.00909253428233332}, {-1.1779841597086, 
        0.0202190256188556}, {-1.1780228879459, -0.0178203534461417}, \
{-1.20480807676899, -0.0227829051561389}}]},
      "\"Guatemala\""], 
     TooltipBox[
      {RGBColor[0.414489948935708, 0.551204930202061, 0.380905926949267], 
       PolygonBox[{{-0.298708922188255, -1.26362766476856}, \
{-0.329790185865963, -1.22936318892471}, {-0.29624678120822, \
-1.2137186648909}, {-0.246455035748486, -1.22780972982684}, \
{-0.246990941154161, -1.22862720979704}, {-0.195684800569493, \
-1.23783553208492}, {-0.178268476115919, -1.27112892729578}, \
{-0.177867792366886, -1.27095979136283}, {-0.194027409597196, \
-1.30345462527904}, {-0.232721732531597, -1.2848335190027}, \
{-0.250069694797649, -1.26101895005981}, {-0.298708922188255, \
-1.26362766476856}}]},
      "\"Guinea\""], 
     TooltipBox[
      {RGBColor[0.421517577672453, 0.142795370090932, 0.258029313149655], 
       PolygonBox[{{-0.360797490425724, -1.20133092622827}, \
{-0.325877210176994, -1.21619030540934}, {-0.338767916871484, \
-1.22155764474416}, {-0.329790185865963, -1.22936318892471}, \
{-0.29624678120822, -1.2137186648909}, {-0.360797490425724, \
-1.20133092622827}}]},
      "\"Guinea-Bissau\""], 
     TooltipBox[
      {RGBColor[0.410784241314644, 0.36225889849716, 0.942211694116899], 
       PolygonBox[{{-1.13115451331694, -0.727583031755341}, \
{-1.13903285066799, -0.692996724992301}, {-1.12565973558503, \
-0.690255656874396}, {-1.13004145839535, -0.652868101480074}, \
{-1.17535334846521, -0.641267048315064}, {-1.17646054887011, \
-0.659299185921453}, {-1.17303833948772, -0.686384051460851}, \
{-1.2006240525616, -0.71429625010602}, {-1.15860837509067, \
-0.767835875799911}, {-1.15736515022733, -0.721798421687818}, \
{-1.13115451331694, -0.727583031755341}}]},
      "\"Guyana\""], 
     TooltipBox[
      {RGBColor[0.658840501143537, 0.862999009438998, 0.225564630109761], 
       PolygonBox[{{-1.11609824099069, -0.36767407830253}, \
{-1.12682035856555, -0.312847958524502}, {-1.1130439291142, \
-0.354147683647705}, {-1.10305160318399, -0.327786095962858}, \
{-1.09351966878937, -0.360588709091992}, {-1.11609824099069, \
-0.36767407830253}}]},
      "\"Haiti\""], 
     TooltipBox[
      {RGBColor[0.615893719321498, 0.0196180437921986, 0.374668139702598], 
       PolygonBox[{{-1.20699081205175, -0.0375797714296957}, \
{-1.20878964776442, -0.145566126734658}, {-1.24387452071427, \
-0.0586596333266846}, {-1.23821558888763, -0.0468460331179025}, \
{-1.22527551066417, -0.0139009060963167}, {-1.20699081205175, \
-0.0375797714296957}}]},
      "\"Honduras\""], 
     TooltipBox[
      {RGBColor[0.074993253584115, 0.40741503902403, 0.821956037448601], 
       PolygonBox[{{0.279216098001384, -0.660997079170294}, {
        0.267671322072013, -0.657548240824109}, {
        0.211466051253498, -0.684546007725533}, {
        0.2040780750404, -0.706273925804402}, {
        0.231018795056599, -0.716673239394222}, {
        0.258865818656696, -0.701058428888005}, {
        0.279216098001384, -0.660997079170294}}]},
      "\"Hungary\""], 
     TooltipBox[
      {RGBColor[0.434616496020667, 0.756056024590712, 0.701537271283979], 
       PolygonBox[{{-0.16484434982599, -0.421354614666874}, \
{-0.177338650500552, -0.39737550243009}, {-0.157219315737889, \
-0.395074694375714}, {-0.176201915154551, -0.38604448363211}, \
{-0.160348619882207, -0.375629263912686}, {-0.154695897429944, \
-0.401251273062575}, {-0.113242320086293, -0.390630737371702}, \
{-0.100157755708897, -0.41295121706807}, {-0.143097754463507, \
-0.436089196228599}, {-0.16484434982599, -0.421354614666874}}]},
      "\"Iceland\""], 
     TooltipBox[
      {RGBColor[0.197377791972597, 0.178204348717915, 0.679408651233684], 
       PolygonBox[{{1.11943195641502, -0.0188883064856827}, {
        1.11160243480831, -0.0407606108984796}, {
        1.14514793659184, -0.0717121789312571}, {
        1.19048085743657, -0.203849052304292}, {
        1.25003613742876, -0.223790999619809}, {
        1.27498073191475, -0.237454747687619}, {
        1.27317570910119, -0.294716061031407}, {
        1.14595426641733, -0.343802756245416}, {
        1.06534979173405, -0.327405193844161}, {
        1.07533985552865, -0.346979905682509}, {
        1.0732109967315, -0.375132349413473}, {
        1.03969821504449, -0.400144102262285}, {
        1.03918508416705, -0.367994738600429}, {
        1.01454833024597, -0.405790381023098}, {
        1.02477307397431, -0.350858244727627}, {
        0.978926162679153, -0.365680965519365}, {
        0.979577546668114, -0.320175294967612}, {
        0.948889066310753, -0.259883375512487}, {
        0.93405032740458, -0.2435920477039}, {
        0.892703121552333, -0.256821796781723}, {
        0.895122739310639, -0.193259851358577}, {
        0.908495579331462, -0.156924434836112}, {
        0.92188203057948, -0.180866063657295}, {
        0.943611494480429, -0.174888053173421}, {
        0.941829705752227, -0.193329873721934}, {
        0.984791624942382, -0.155388423580628}, {
        1.00232759435375, -0.175535122940342}, {
        1.02928932428422, -0.130637898193695}, {
        1.05351108998309, -0.0490680676193174}, {
        1.03153222371913, -0.0333183017466322}, {
        1.04009476301506, -0.019668178522439}, {1.03313622118858, 
        0.0297604147573577}, {1.00237394990669, 0.106827972877538}, {
        1.01839559137746, 0.13136288727222}, {1.03567791668488, 
        0.129612429108544}, {1.04648164863976, 0.0940096985907508}, {
        1.11747540398819, 0.0507442611612365}, {1.0937704763128, 
        0.0436116858755877}, {1.10416188226881, 0.0311634749061271}, {
        1.09441267003194, 0.0222877022593407}, {1.07316633033069, 
        0.0449789958641194}, {1.07042161321802, -0.00280236363264346}, {
        1.05004720926057, -0.0290247921366278}, {
        1.07026763949695, -0.0183701696187272}, {
        1.11943195641502, -0.0188883064856827}}]},
      "\"India\""], 
     TooltipBox[
      {RGBColor[0.287047322348272, 0.646172861770536, 0.797298421768647], 
       PolygonBox[{{1.33827017651557, 0.12257719101049}, {1.33637699977728, 
        0.176332858932987}, {1.36989114384253, 0.314585842579265}, {
        1.37803001364732, 0.303820116051723}, {1.37038190715037, 
        0.334907852654136}, {1.37295913319638, 0.339091755388782}, {
        1.37295913319638, 0.339091755388782}, {1.38916395212669, 
        0.264997196422431}, {1.39575067414839, 0.227771937723506}, {
        1.39575067414839, 0.227771937723506}, {1.33827017651557, 
        0.12257719101049}, {1.33827017651557, 0.12257719101049}}], {}, {}, 
       PolygonBox[{{1.30762051913016, 0.466908925015321}, {1.33538287036074, 
        0.46556695495612}, {1.33538287036074, 0.46556695495612}, {
        1.31490251631876, 0.5206067350492}, {1.27961868919952, 
        0.602142848708934}, {1.25723953006988, 0.647571435464585}, {
        1.25723953006988, 0.647571435464585}, {1.23759487133744, 
        0.655272753950218}, {1.22604178754767, 0.680072357614147}, {
        1.21951006208624, 0.622265352893594}, {1.20707565312938, 
        0.630596880881168}, {1.22312258283891, 0.593037301148215}, {
        1.25958203378581, 0.58423322951815}, {1.31421946887749, 
        0.493110209461432}, {1.30762051913016, 0.466908925015321}, {
        1.30762051913016, 
        0.466908925015321}}], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
       PolygonBox[{{1.22726102100636, 0.702730664137003}, {1.2166522934742, 
        0.703378605842025}, {1.13968937260419, 0.80545281510299}, {
        1.16522800616321, 0.793375509978703}, {1.21791088346694, 
        0.71026463459151}, {1.22061038756767, 0.714220051358062}, {
        1.22061038756767, 0.714220051358062}, {1.22726102100636, 
        0.702730664137003}}], {}, {}, {}, {}, {}, {}, {}, {}, 
       PolygonBox[{{1.09867942723997, 0.88652253966225}, {1.1137317355805, 
        0.867536926205677}, {1.11427561535733, 0.870855816435788}, {
        1.11427561535733, 0.870855816435788}, {1.11688038843566, 
        0.867512650010257}, {1.11688038843566, 0.867512650010257}, {
        1.11688521191901, 0.859082732430222}, {1.09207069604383, 
        0.854754921990686}, {1.11096975733736, 0.856592003435944}, {
        1.09867942723997, 0.88652253966225}, {1.09867942723997, 
        0.88652253966225}}], {}, {}},
      "\"Indonesia\""], 
     TooltipBox[
      {RGBColor[0.257891073561231, 0.14425195225734, 0.388143548620881], 
       PolygonBox[{{0.942826778126306, -0.509430155485346}, {
        0.901250750020601, -0.567914081966123}, {
        0.845968539296507, -0.621046884936027}, {
        0.768118195944378, -0.641487581414679}, {
        0.74971860191655, -0.662517813669043}, {
        0.668917684998453, -0.659642434948313}, {
        0.659237055874755, -0.628880874400832}, {
        0.626977477588628, -0.631369956601111}, {
        0.599480865745902, -0.603680708986367}, {
        0.622998036237836, -0.598129781360598}, {
        0.634155633835839, -0.56832970411275}, {
        0.655189998394486, -0.571894374457563}, {
        0.697740447435826, -0.56300556663721}, {
        0.716626128225741, -0.522572760809617}, {
        0.733222038750486, -0.472529359005668}, {
        0.76652124904128, -0.450314994072709}, {
        0.801755647134655, -0.439251570256854}, {
        0.830387439775723, -0.468217569727995}, {
        0.868131727299253, -0.464513205520058}, {
        0.87524891619651, -0.487824460253796}, {
        0.93206978078765, -0.46810303768194}, {
        0.942826778126306, -0.509430155485346}}]},
      "\"Iran\""], 
     TooltipBox[
      {RGBColor[0.386514180454004, 0.895632175064071, 0.20204025814044], 
       PolygonBox[{{0.742373544789606, -0.669610132207438}, {
        0.74971860191655, -0.662517813669043}, {
        0.668917684998453, -0.659642434948313}, {
        0.659237055874755, -0.628880874400832}, {
        0.626977477588628, -0.631369956601111}, {
        0.600116739467119, -0.65836458252308}, {
        0.611785513031033, -0.703778726186398}, {
        0.594451904420784, -0.739349057632}, {
        0.61188101289686, -0.747572514123278}, {
        0.712092166437155, -0.719169957813432}, {
        0.735828099813729, -0.697055411482858}, {
        0.742373544789606, -0.669610132207438}}]},
      "\"Iraq\""], 
     TooltipBox[
      {RGBColor[0.729303047477344, 0.523515171015005, 0.67006754495431], 
       PolygonBox[{{-0.0673111277959279, -0.612965853314688}, \
{-0.0718694160103489, -0.644112881423334}, {-0.111994673509814, \
-0.650636586934653}, {-0.117737911457683, -0.637325977172374}, \
{-0.0971937500161013, -0.632701969309494}, {-0.108267976367271, \
-0.606790544093878}, {-0.0757924843467744, -0.595777605279788}, \
{-0.0865953423338855, -0.604667403622311}, {-0.0673111277959279, \
-0.612965853314688}}]},
      "\"Ireland\""], 
     TooltipBox[
      {RGBColor[0.586146538818942, 0.709685003685145, 0.148847031312407], 
       PolygonBox[{{0.550953435063514, -0.810196307405362}, {
        0.54785542002994, -0.779519413943591}, {
        0.552545771796919, -0.773688108336055}, {
        0.553521427636243, -0.77267559176391}, {
        0.55419550344164, -0.772192259042552}, {
        0.559035842659707, -0.779415102817716}, {
        0.567256147068003, -0.795753312391263}, {
        0.576993427031157, -0.825053200039191}, {
        0.576608166698776, -0.826548423244323}, {
        0.552659454571066, -0.8111818055236}, {
        0.550953435063514, -0.810196307405362}}]},
      "\"Israel\""], 
     TooltipBox[
      {RGBColor[0.595074291370195, 0.178731499794912, 0.887728966236544], 
       PolygonBox[{{0.179187780160361, -0.734129675313289}, {
        0.16106841799252, -0.740796818888267}, {
        0.166838741745932, -0.759879994377934}, {
        0.267760654696408, -0.799479307969992}, {
        0.241257418042121, -0.808422908332561}, {
        0.243005104045095, -0.843752985584702}, {
        0.228105555350591, -0.8133274375505}, {
        0.155382668072084, -0.791992077798354}, {
        0.136995519224022, -0.769088454371628}, {
        0.102908199443901, -0.778166766436672}, {
        0.0918708126844487, -0.744646003177747}, {
        0.133503860260702, -0.722668485821724}, {
        0.175605575804403, -0.719453437243973}, {
        0.179187780160361, -0.734129675313289}}], 
       PolygonBox[{{0.234962719352208, -0.840597776522724}, {
        0.233643966227928, -0.866925614178985}, {
        0.18919093073957, -0.859297785648225}, {
        0.234962719352208, -0.840597776522724}}], 
       PolygonBox[{{0.132679173626986, -0.814680677741606}, {
        0.132749371389576, -0.852586831787275}, {
        0.117938120579149, -0.825234441512831}, {
        0.132679173626986, -0.814680677741606}}]},
      "\"Italy\""], 
     TooltipBox[
      {RGBColor[0.71423053529174, 0.839018266779483, 0.477194228510933], 
       PolygonBox[{{-1.14773095122307, -0.23629127065624}}]},
      "\"Jamaica\""], 
     TooltipBox[
      {RGBColor[0.690351174263947, 0.536026186573826, 0.159609615545798], 
       PolygonBox[{{0.719378956498631, 0.639818024913917}, {0.709031456555902,
         0.616713836284848}, {0.73135037128393, 0.604667394258758}, {
        0.747019918198976, 0.641782745166841}, {0.719378956498631, 
        0.639818024913917}}], 
       PolygonBox[{{0.66763740396669, 0.658379906364975}, {0.701116297304022, 
        0.654182922965273}, {0.705208833530615, 0.635344430186318}, {
        0.667820343657478, 0.658560309403774}}], 
       PolygonBox[{{0.516126156564636, 0.640404161354756}, {0.523976030159939,
         0.672269607283809}, {0.588168834959906, 0.709292007388085}, {
        0.611762443144321, 0.700042300901801}, {0.630707151287204, 
        0.672810533573881}, {0.66107350708596, 0.679005990278334}, {
        0.652282594997093, 0.659916747449495}, {0.710658822680662, 
        0.615230237773331}, {0.667881952519684, 0.624628569056702}, {
        0.607517727229393, 0.646186899509758}, {0.586941539602162, 
        0.664584455542769}, {0.516126156564636, 0.640404161354756}}], 
       PolygonBox[{{0.466593381271281, 0.596139250614255}, {0.460953045849587,
         0.629044272160045}, {0.444768949434036, 0.654867315213588}, {
        0.487705832472637, 0.652721183692338}, {0.512040308670156, 
        0.620418810025652}, {0.511722845542361, 0.636454860026321}, {
        0.52815483942593, 0.630174617019376}, {0.49471203376509, 
        0.619715061012751}, {0.466585833799774, 0.596487016949243}}], 
       PolygonBox[{{0.821834361103065, 0.648657591418231}, {0.838157653599795,
         0.64663428341254}, {0.822028900734156, 0.648811137697762}}]},
      "\"Japan\""], 
     TooltipBox[
      {RGBColor[0.190146906162661, 0.0441783124934116, 0.738727764805178], 
       PolygonBox[{{0.578577181721028, -0.827317839138598}, {
        0.577233400863762, -0.824885324550827}, {
        0.567256147068003, -0.795753312391263}, {
        0.559035842659707, -0.779415102817716}, {
        0.594291437208083, -0.739149476670766}, {
        0.61188101289686, -0.747572514123278}, {
        0.588119207528145, -0.780460548845724}, {
        0.608761429008721, -0.793353340291235}, {
        0.578577181721028, -0.827317839138598}}]},
      "\"Jordan\""], 
     TooltipBox[
      {RGBColor[0.901718541984567, 0.0458949539053216, 0.656034763872531], 
       PolygonBox[{{0.562797366154163, -0.485508038667378}, {
        0.569779863447587, -0.458114771947973}, {
        0.595985704275379, -0.446395283065403}, {
        0.608943860267876, -0.454719947903964}, {
        0.605635966661996, -0.48059510433282}, {
        0.593526615511412, -0.494215305529948}, {
        0.652051340360904, -0.494336262300093}, {
        0.681002721146538, -0.459342135406208}, {
        0.634517887649971, -0.427987719308771}, {
        0.646850311214281, -0.393806775682727}, {
        0.698151478836254, -0.368612752371976}, {
        0.764368983313162, -0.31011908200479}, {
        0.771901288729698, -0.288602065930611}, {
        0.764705314504112, -0.263060363699324}, {
        0.764849269399855, -0.214269417419123}, {
        0.783919815476823, -0.163055556114324}, {
        0.8009777459055, -0.137393286519913}, {
        0.755014932588238, -0.13494187715982}, {
        0.756802360439984, -0.0987392156650872}, {
        0.724096872474716, -0.0884803335754674}, {
        0.727683462795257, -0.0549276703361}, {
        0.698022994048637, -0.0325109434513562}, {
        0.697727663847287, -0.0266007351244812}, {
        0.672349518572661, -0.0762083427772725}, {
        0.649349748926223, -0.120740657675469}, {
        0.596973008949957, -0.134533677903286}, {
        0.599069266843238, -0.165948961920622}, {
        0.565286969204842, -0.198699386954359}, {
        0.54210707435274, -0.293320028373653}, {
        0.586360988493298, -0.32658778157738}, {
        0.539353342879448, -0.390187655150393}, {
        0.511422355599471, -0.413157302645406}, {
        0.506025677597489, -0.474359418691597}, {
        0.562797366154163, -0.485508038667378}}]},
      "\"Kazakhstan\""], 
     TooltipBox[
      {RGBColor[0.352213584351175, 0.00608636692049661, 0.843854695764881], 
       PolygonBox[{{0.796936471453218, -1.16828603538162}, {
        0.798141692385666, -1.13845422760268}, {
        0.761189392931962, -1.12850968360683}, {
        0.795821753741683, -1.098039157755}, {
        0.872506622458075, -1.05780809316814}, {
        0.911358810185195, -1.01513178294403}, {
        0.904283077958003, -1.04087003425722}, {
        0.934321552812622, -1.06162292550124}, {
        0.934321552812622, -1.06162292550124}, {
        0.901453651284566, -1.08967027792159}, {
        0.831253875554907, -1.14412280563537}, {
        0.796936471453218, -1.16828603538162}}]},
      "\"Kenya\""], 
     TooltipBox[
      {RGBColor[0.926731716395187, 0.828698413336169, 0.336018821966187], 
       PolygonBox[{{0.764324398469367, -0.678201468402401}, {
        0.742373544789606, -0.669610132207438}, {
        0.735828099813729, -0.697055411482858}, {
        0.764324398469367, -0.678201468402401}}]},
      "\"Kuwait\""], 
     TooltipBox[
      {RGBColor[0.25770815694594, 0.217046712710042, 0.679851382023762], 
       PolygonBox[{{0.820262691400985, -0.232626451438526}, {
        0.813119350144144, -0.271802947380676}, {
        0.793041480320659, -0.295454780505038}, {
        0.794158630168443, -0.242798659187674}, {
        0.78353868828144, -0.266229755282946}, {
        0.764705314504112, -0.263060363699324}, {
        0.764849269399855, -0.214269417419123}, {
        0.783919815476823, -0.163055556114324}, {
        0.8009777459055, -0.137393286519913}, {
        0.811733152196262, -0.23276073585973}, {
        0.820262691400985, -0.232626451438526}}]},
      "\"Kyrgyzstan\""], 
     TooltipBox[
      {RGBColor[0.740944530595992, 0.0789766571510275, 0.329317746473497], 
       PolygonBox[{{1.12450223610479, 0.199966890435575}, {1.10341934921143, 
        0.217482420020624}, {1.08773718917674, 0.233852634326286}, {
        1.10513252492687, 0.258528276152622}, {1.1006174662112, 
        0.287715247498445}, {1.12333494195242, 0.277650540720373}, {
        1.14702443675574, 0.360921898742575}, {1.16480890371932, 
        0.368380684410277}, {1.18350254514252, 0.321920233923219}, {
        1.14382216586667, 0.300431779050643}, {1.13760637197071, 
        0.271016066096427}, {1.16029666553095, 0.223787972060701}, {
        1.13104778058987, 0.225663523012008}, {1.12450223610479, 
        0.199966890435575}}]},
      "\"Laos\""], 
     TooltipBox[
      {RGBColor[0.965620846732022, 0.90192626381651, 0.601782428640095], 
       PolygonBox[{{0.226015522117218, -0.505264028015609}, {
        0.256828074329747, -0.491266795881813}, {
        0.275290065362652, -0.51557247765271}, {
        0.262840863501576, -0.531040053688251}, {
        0.241211489751261, -0.525639188434957}, {
        0.21242206120149, -0.543899235653942}, {
        0.20619261185381, -0.525691354147598}, {
        0.233042447060724, -0.513739223040115}, {
        0.226015522117218, -0.505264028015609}}]},
      "\"Latvia\""], 
     TooltipBox[
      {RGBColor[0.63896657220955, 0.429594660158197, 0.742316648270711], 
       PolygonBox[{{0.545563092664831, -0.751822592406917}, {
        0.54785542002994, -0.779519413943591}, {
        0.552545771796919, -0.773688108336055}, {
        0.553521427636243, -0.77267559176391}, {
        0.545563092664831, -0.751822592406917}}]},
      "\"Lebanon\""], 
     TooltipBox[
      {RGBColor[0.411635522477434, 0.594788259716138, 0.690866895353018], 
       PolygonBox[{{-0.264384075006889, -1.29948924517337}, \
{-0.178237473241261, -1.34778840713859}, {-0.194027409597196, \
-1.30345462527904}, {-0.232721732531597, -1.2848335190027}, \
{-0.264384075006889, -1.29948924517337}}]},
      "\"Liberia\""], 
     TooltipBox[
      {RGBColor[0.840598106286144, 0.365740568572112, 0.938753495843608], 
       PolygonBox[{{0.19029301604722, -0.932542720642236}, {
        0.268763241778338, -0.942460097871226}, {
        0.329644601172856, -0.939564545489942}, {
        0.3533974577164, -0.887297209341427}, {
        0.414346700761478, -0.882529803984992}, {
        0.472650265685084, -1.01360176574234}, {
        0.472650265685084, -1.01360176574234}, {
        0.484807753012208, -1.03967358145137}, {
        0.469492194326178, -1.05449673351758}, {
        0.302260191994464, -1.05410655935962}, {
        0.285145875297856, -1.06666073982892}, {
        0.227942564615513, -1.07238545272188}, {
        0.172736385479343, -1.04341592035697}, {
        0.165036913872897, -0.982709247292334}, {
        0.19029301604722, -0.932542720642236}}]},
      "\"Libya\""], 
     TooltipBox[
      {RGBColor[0.338653311001844, 0.834511739365647, 0.521885872807231], 
       PolygonBox[{{0.122061337647125, -0.72166996256481}, {
        0.120638479152873, -0.718339589978729}, {
        0.12068334640877, -0.718606751223058}, {
        0.122061337647125, -0.72166996256481}}]},
      "\"Liechtenstein\""], 
     TooltipBox[
      {RGBColor[0.0120217794484207, 0.509954897665674, 0.49849291739946], 
       PolygonBox[{{0.21242206120149, -0.543899235653942}, {
        0.241211489751261, -0.525639188434957}, {
        0.262840863501576, -0.531040053688251}, {
        0.263219266449905, -0.556425683324424}, {
        0.246771397245447, -0.567535358826019}, {
        0.239448953166215, -0.569163038805903}, {
        0.235372303102574, -0.557656765630552}, {
        0.216285584276439, -0.555220996966861}, {
        0.21242206120149, -0.543899235653942}}]},
      "\"Lithuania\""], 
     TooltipBox[
      {RGBColor[0.264177715861291, 0.794975066738379, 0.830103515641912], 
       PolygonBox[{{0.0728509099042845, -0.677950101746538}, {
        0.0768228917214943, -0.68850725236002}, {
        0.0700719642364146, -0.687855411534777}, {
        0.0728509099042845, -0.677950101746538}}]},
      "\"Luxembourg\""], 
     TooltipBox[
      {RGBColor[0.757548386803468, 0.185201058710264, 0.465657320264882], 
       PolygonBox[{{0.286631920407292, -0.76527434816901}, {
        0.293361435670609, -0.755027789962517}, {
        0.314442536691013, -0.746205718677578}, {
        0.321114378723266, -0.758952111650765}, {
        0.297853115728985, -0.776609042975929}, {
        0.286631920407292, -0.76527434816901}}]},
      "\"Macedonia\""], 
     TooltipBox[
      {RGBColor[0.864482668909889, 0.855622122986958, 0.583418630070169]},
      "\"Madagascar\""], 
     TooltipBox[
      {RGBColor[0.826690748055332, 0.434888008751693, 0.113305474716247]},
      "\"Malawi\""], 
     TooltipBox[
      {RGBColor[0.171783107592735, 0.231902488339193, 0.744021113398675], 
       PolygonBox[{{1.30762051913016, 0.466908925015321}, {1.31421946887749, 
        0.493110209461432}, {1.25958203378581, 0.58423322951815}, {
        1.22312258283891, 0.593037301148215}, {1.20689216886597, 
        0.630947978271402}, {1.17458148760511, 0.65869519294159}, {
        1.1889451313608, 0.618046782248498}, {1.1792184206809, 
        0.604735669128711}, {1.22425051064187, 0.574784168987272}, {
        1.22638884995827, 0.572743374537426}, {1.22597310556355, 
        0.572114872555289}, {1.23845085391035, 0.553553559300022}, {
        1.28508068711373, 0.504911735592028}, {1.30125687145094, 
        0.509520387064619}, {1.30762051913016, 0.466908925015321}}], 
       PolygonBox[{{1.31205696461296, 0.234500566947126}, {1.35216740388121, 
        0.269780698303212}, {1.3597595616846, 0.326867753414107}, {
        1.35294546024074, 0.344861473468553}, {1.31662294993914, 
        0.314878263824167}, {1.30556749761725, 0.279889419593343}, {
        1.31765986019735, 0.259708926950172}, {1.31205696461296, 
        0.234500566947126}}]},
      "\"Malaysia\""], 
     TooltipBox[
      {RGBColor[0.272707368430103, 0.806042539020623, 0.293148992495586], 
       PolygonBox[{{0.0859120138159599, -1.15608577983895}, {
        0., -1.12079619571947}, {-0.08992014489952, -1.07083044599033}, \
{-0.123200850021865, -1.06751347863739}, {-0.116029715559877, \
-1.20501466918481}, {-0.240936749071267, -1.18424195624107}, \
{-0.254946573530896, -1.19430355198793}, {-0.259016150359072, \
-1.19295605722579}, {-0.246455035748486, -1.22780972982684}, \
{-0.246990941154161, -1.22862720979704}, {-0.195684800569493, \
-1.23783553208492}, {-0.177867792366886, -1.27095979136283}, \
{-0.12303129803041, -1.27384482296496}, {-0.085653013277207, \
-1.23522177506905}, {0., -1.21752285801744}, {
        0.00495826889921382, -1.21751276188978}, {
        0.0817831523497211, -1.20480312731574}, {
        0.0859120138159599, -1.15608577983895}}]},
      "\"Mali\""], 
     TooltipBox[
      {RGBColor[0.405367802396831, 0.438195629064455, 0.284156666213392], 
       PolygonBox[{{-0.33313092687625, -1.08623096067893}, \
{-0.319180657111813, -1.09862702781498}, {-0.342322388708299, \
-1.15319693136996}, {-0.278490581277418, -1.17049130671311}, \
{-0.254994662909852, -1.19452882787732}, {-0.240936749071267, \
-1.18424195624107}, {-0.116029715559877, -1.20501466918481}, \
{-0.123200850021865, -1.06751347863739}, {-0.08992014489952, \
-1.07083044599033}, {-0.156792874565818, -1.0286480863331}, \
{-0.159702523531405, -1.04773699486061}, {-0.220352820447257, \
-1.03667851378467}, {-0.250524252896803, -1.07656383852983}, \
{-0.25374773978041, -1.09910221301298}, {-0.33313092687625, \
-1.08623096067893}}]},
      "\"Mauritania\""], 
     TooltipBox[
      {RGBColor[0.281127213047165, 0.895412904731157, 0.939702711664995], 
       PolygonBox[{{-1.05212474259892, 0.131670707095843}, {-1.09920163198848,
         0.152200942553793}, {-1.15932425202457, 
        0.1191228778666}, {-1.16588862465197, 
        0.0240825952335838}, {-1.16296873921713, 
        0.0277453614275001}, {-1.13231380611607, 
        0.00658760901657823}, {-1.12250330107807, -0.0565362080745289}, \
{-1.16822098915888, -0.0346719895350715}, {-1.1780228879459, \
-0.0178203534461417}, {-1.1779841597086, 
        0.0202190256188556}, {-1.2022013222483, 
        0.00909253428233332}, {-1.20215027055934, 
        0.0363789980010012}, {-1.22280097410079, 
        0.0480439811215027}, {-1.21493370638613, 
        0.059065921178747}, {-1.22280097410079, 
        0.0480439811215027}, {-1.19326380492117, 
        0.101599514320831}, {-1.19300163199099, 
        0.163067367778388}, {-1.13858740458962, 
        0.273000384260995}, {-1.10684661089976, 
        0.305915790480113}, {-1.06913255821618, 
        0.30085520631714}, {-1.00477756840813, 
        0.35383803771213}, {-0.940516842399525, 
        0.383179669271142}, {-0.902733354098392, 
        0.384738075230353}, {-0.879226387474121, 
        0.410612904839615}, {-0.945215590837499, 
        0.398626830271059}, {-1.03862042562218, 
        0.368134826137067}, {-0.999281165020388, 
        0.40576600382557}, {-0.937052001435003, 
        0.437286416762163}, {-0.933466101933968, 
        0.41690800104117}, {-0.855783181897987, 
        0.438240550715269}, {-0.87083428204574, 
        0.400845963994346}, {-0.926120937556157, 
        0.319793297555896}, {-0.932779195084446, 
        0.276596952861364}, {-0.979842980245273, 
        0.245210720784976}, {-0.992798151226401, 
        0.189985047209339}, {-1.04069529860392, 
        0.16638190134098}, {-1.05212474259892, 0.131670707095843}}]},
      "\"Mexico\""], 
     TooltipBox[
      {RGBColor[0.0199789503521014, 0.486152146308786, 0.0653093890892454], 
       PolygonBox[{{0.319841530537915, -0.636856848294627}, {
        0.338454066341871, -0.629015684854844}, {
        0.363635407563086, -0.639247863295783}, {
        0.357727201649556, -0.668091413817284}, {
        0.319841530537915, -0.636856848294627}}]},
      "\"Moldova\""], 
     TooltipBox[
      {RGBColor[0.182154324861527, 0.834777891641838, 0.0204948260439039], 
       PolygonBox[{{0.101845670221087, -0.778846164459118}, {
        0.101008123821101, -0.77949470171261}, {
        0.100973749389055, -0.779229429112339}, {
        0.101619108749793, -0.778875757211867}}]},
      "\"Monaco\""], 
     TooltipBox[
      {RGBColor[0.200826720179356, 0.326532201874569, 0.251359261571669], 
       PolygonBox[{{0.69719820523064, -0.0261743555448596}, {
        0.733723797292817, 0.0115262544687219}, {0.760201042955887, 
        0.0092880699485619}, {0.773726786500706, 0.0731387150532272}, {
        0.796793470396397, 0.0891400214148107}, {0.788928701148755, 
        0.215086650973381}, {0.754022529756089, 0.276430586422716}, {
        0.729196732059304, 0.294121239968001}, {0.708140469944662, 
        0.286107321432876}, {0.640127217584811, 0.36808947575424}, {
        0.630277278268497, 0.341263683306131}, {0.648180067449199, 
        0.310324055439261}, {0.613453575563532, 0.308758623841492}, {
        0.658856662409713, 0.221089872451444}, {0.662454790404905, 
        0.156801159059959}, {0.6407919394316, 0.100727314166733}, {
        0.682780990756358, 0.0878700367991039}, {0.669227488652946, 
        0.0278539322875881}, {0.69719820523064, -0.0261743555448596}}]},
      "\"Mongolia\""], 
     TooltipBox[
      {RGBColor[0.193804077988572, 0.765938711427663, 0.213226727158322], 
       PolygonBox[{{-0.0353915925678125, -0.921269195777736}, \
{-0.0858338146813681, -0.905216343911939}, {-0.100243198559668, \
-0.917780972585123}, {-0.155059653225392, -0.948623055196621}, \
{-0.179489070017557, -0.994239137394156}, {-0.236063386504885, \
-1.00777990932531}, {-0.155968539642498, -1.02323999273371}, \
{-0.153599139233404, -1.0076954139171}, {-0.062442967546942, \
-0.983372899612254}, {-0.0648464858042504, -0.972034789055569}, \
{-0.0199926511941404, -0.967885910044187}, {-0.0353915925678125, \
-0.921269195777736}}]},
      "\"Morocco\""], 
     TooltipBox[
      {RGBColor[0.079576153978934, 0.961901589649379, 0.0219175980289884]},
      "\"Mozambique\""], 
     TooltipBox[
      {RGBColor[0.940519358728219, 0.273533614958311, 0.668752597153793]},
      "\"Namibia\""], 
     TooltipBox[
      {RGBColor[0.616549795632157, 0.502323729663764, 0.989376948744918], 
       PolygonBox[{{0.984746382618298, -0.155674881274107}, {
        1.03153222371913, -0.0333183017466322}, {
        1.05351108998309, -0.0490680676193174}, {
        1.02928932428422, -0.130637898193695}, {
        1.00232759435375, -0.175535122940342}, {
        0.984746382618298, -0.155674881274107}}]},
      "\"Nepal\""], 
     TooltipBox[
      {RGBColor[0.387625384106628, 0.721136890901, 0.562621017998769], 
       PolygonBox[{{0.0388515629152048, -0.660436062439113}, {
        0.0524124152432166, -0.632994812363908}, {
        0.079200785963114, -0.625475507210877}, {
        0.0704087239219622, -0.668024942222452}, {
        0.0388515629152048, -0.660436062439113}}]},
      "\"Netherlands\""], 
     TooltipBox[
      {RGBColor[
       0.969397998392817, 0.901473237797842, 0.655827501811755], {}, {}},
      "\"New Zealand\""], 
     TooltipBox[
      {RGBColor[0.380466693137242, 0.134620106750979, 0.880978411753939], 
       PolygonBox[{{-1.20878964776442, -0.145566126734658}, \
{-1.26546658901983, -0.140826707983379}, {-1.26765219637442, \
-0.0956860853698945}, {-1.24413580249521, -0.0579465562962687}, \
{-1.20878964776442, -0.145566126734658}}]},
      "\"Nicaragua\""], 
     TooltipBox[
      {RGBColor[0.455000781632399, 0.0539344912626728, 0.88326084517931], 
       PolygonBox[{{0.285145875297856, -1.06666073982892}, {
        0.227630610692783, -1.07245171315479}, {
        0.0859120138159599, -1.15608577983895}, {
        0.0817831523497211, -1.20480312731574}, {
        0.00495826889921382, -1.21751276188978}, {
        0.0527631845984336, -1.25889144709056}, {
        0.0785106560735092, -1.25958428642253}, {
        0.0792859400651015, -1.26021392985277}, {
        0.105072427760733, -1.22982026043044}, {
        0.208802952794827, -1.23016435148529}, {
        0.291149715330406, -1.20041257358199}, {
        0.317959889492549, -1.14782277442007}, {
        0.31481744587998, -1.09789890793495}, {
        0.285145875297856, -1.06666073982892}}]},
      "\"Niger\""], 
     TooltipBox[
      {RGBColor[0.687174333765366, 0.689062070204736, 0.840707764104351], 
       PolygonBox[{{0.202044389784956, -1.33858969736503}, {
        0.144581743047494, -1.35288542339166}, {
        0.123347734077096, -1.33386665859956}, {
        0.0632038510747455, -1.3319999053825}, {
        0.0785106560735092, -1.25958428642253}, {
        0.0792859400651015, -1.26021392985277}, {
        0.105072427760733, -1.22982026043044}, {
        0.208802952794827, -1.23016435148529}, {
        0.291149715330406, -1.20041257358199}, {
        0.302734923581435, -1.20672378791395}, {
        0.319811810433679, -1.22339871635005}, {
        0.272668448228013, -1.29577246830996}, {
        0.226013096277478, -1.3084762679155}, {
        0.202044389784956, -1.33858969736503}}]},
      "\"Nigeria\""], 
     TooltipBox[
      {RGBColor[0.803684691200376, 0.725272744115988, 0.667144472175747], 
       PolygonBox[{{0.679819363698796, 0.538174527395577}, {0.674124802749461,
         0.517274154415655}, {0.613246898885865, 0.527165262500596}, {
        0.612598642178157, 0.52506053898041}, {0.696387808594616, 
        0.47623183484309}, {0.70435018756845, 0.50519549751006}, {
        0.719593083303286, 0.497650757218711}, {0.705046104137553, 
        0.525525169833701}, {0.679819363698796, 0.538174527395577}}]},
      "\"North Korea\""], 
     TooltipBox[
      {RGBColor[0.900188405376131, 0.530151076242065, 0.0565201469621945], 
       PolygonBox[{{0.179649484909609, -0.301564226675462}, {
        0.176703482541689, -0.293310387415731}, {
        0.161653103942823, -0.290433305242377}, {
        0.152254960770106, -0.29061889444305}, {
        0.141661746173381, -0.298787439869719}, {
        0.111543817023056, -0.341268737291224}, {
        0.0922385761878895, -0.393776372199098}, {
        0.0753006452163081, -0.447579146663891}, {
        0.0900425731798472, -0.444558802947945}, {
        0.0561254252398892, -0.464929432780141}, {
        0.0425956171454718, -0.478847648594382}, {
        0.0576967440068631, -0.482665204300362}, {
        0.0452320091633016, -0.49701610773396}, {
        0.066566514787982, -0.49233656150833}, {
        0.0457741869592759, -0.50459981813582}, {
        0.0629383535584193, -0.505299289304424}, {
        0.0475259976965165, -0.52391121257318}, {
        0.0632333790155343, -0.54651012593894}, {
        0.0952848270127882, -0.510793305479962}, {
        0.106003610610413, -0.524145344980895}, {
        0.0960524661924798, -0.446776406392432}, {
        0.127835171719222, -0.340400582921488}, {
        0.15846697672769, -0.328536045673848}, {
        0.16184003928846, -0.30566264413256}, {
        0.176098015114011, -0.318125568061854}, {
        0.176514310976078, -0.318221905263266}, {
        0.179853397400828, -0.301109132914078}}], 
       PolygonBox[{{0.0706956805277748, -0.152649480272937}, {
        0.0764218390374533, -0.172320336020627}, {
        0.052529850574214, -0.163774989947284}, {
        0.0706956805277748, -0.152649480272937}}], 
       PolygonBox[{{0.0338178831809509, -0.179261897220608}, {
        0.0462465790579434, -0.200315941457657}, {
        0.0600171466525092, -0.192692873261503}, {
        0.0488951429273477, -0.202365842282469}, {
        0.0658492539622024, -0.224459572079396}, {
        0.0718996122351003, -0.182061717549465}, {
        0.048598094854768, -0.166192523512587}, {
        0.0547748581296563, -0.185511150426021}, {
        0.0338178831809509, -0.179261897220608}}]},
      "\"Norway\""], 
     TooltipBox[
      {RGBColor[0.0505946765435901, 0.397864675712367, 0.540774127497147], 
       PolygonBox[{{0.955450266454057, -0.717372351943503}, {
        0.983174488945714, -0.619138018798601}, {
        0.96388140582352, -0.560992374438326}, {
        0.903262763003241, -0.595592054731485}, {
        0.91134555004771, -0.618575027810295}, {
        0.934397710156839, -0.614563041861314}, {
        0.914992314152825, -0.715299067612243}, {
        0.955450266454057, -0.717372351943503}}]},
      "\"Oman\""], 
     TooltipBox[
      {RGBColor[0.668894762855566, 0.32945778564259, 0.835243657713598], 
       PolygonBox[{{0.942826778126306, -0.509430155485346}, {
        0.985383976679935, -0.424373385524572}, {
        1.01454833024597, -0.405790381023098}, {
        1.02477307397431, -0.350858244727627}, {
        0.978926162679153, -0.365680965519365}, {
        0.979577546668114, -0.320175294967612}, {
        0.948889066310753, -0.259883375512487}, {
        0.93405032740458, -0.2435920477039}, {
        0.892703121552333, -0.256821796781723}, {
        0.895122739310639, -0.193259851358577}, {
        0.859714592597777, -0.23734304730448}, {
        0.854833405823567, -0.283812977130089}, {
        0.881514886873234, -0.322588639127329}, {
        0.908175798255022, -0.342567373692293}, {
        0.901617683622944, -0.387987044780766}, {
        0.917385933569797, -0.403659471662747}, {
        0.87524891619651, -0.487824460253796}, {
        0.93206978078765, -0.46810303768194}, {
        0.942826778126306, -0.509430155485346}}]},
      "\"Pakistan\""], 
     TooltipBox[
      {RGBColor[0.57137612910433, 0.767421525057724, 0.673630283830835], 
       PolygonBox[{{-1.28050717566319, -0.167066437405127}, \
{-1.27580480899253, -0.224193578282929}, {-1.27370505623376, \
-0.228410790663914}, {-1.27154549135819, -0.285000909007685}, \
{-1.29273188023858, -0.277531049252266}, {-1.2768937662265, \
-0.268695816822772}, {-1.2781532890793, -0.236122650212112}, \
{-1.27907939659988, -0.234754998730154}, {-1.30358424401401, \
-0.219704757542423}, {-1.30162089472708, -0.162125452786861}, \
{-1.28050717566319, -0.167066437405127}}]},
      "\"Panama\""], 
     TooltipBox[
      {RGBColor[
       0.454776964576356, 0.43675602235335, 0.886443113303785], {}, {}},
      "\"Papua New Guinea\""], 
     TooltipBox[
      {RGBColor[0.218629502198436, 0.400842473313684, 0.553495177174041]},
      "\"Paraguay\""], 
     TooltipBox[
      {RGBColor[0.199268779538419, 0.5295674319937, 0.560134709209333]},
      "\"Peru\""], 
     TooltipBox[
      {RGBColor[0.749810485973665, 0.473996035422431, 0.862422959817953], 
       PolygonBox[{{0.989066599489092, 0.624859334475272}, {1.03604965624141, 
        0.631993820342015}, {1.04498458860539, 0.651711542027432}, {
        1.02408401792929, 0.689021053569868}, {1.03624514212506, 
        0.701151185273647}, {1.03848863301414, 0.662439914303163}, {
        1.04695893150286, 0.669558170170363}, {1.06185177182517, 
        0.628811497600495}, {1.04080762674371, 0.595674154167533}, {
        1.00537003709706, 0.594574182485628}, {0.988884793433777, 
        0.625147015846058}}], 
       PolygonBox[{{1.04575387312703, 0.686061322226012}, {1.0456343061849, 
        0.707060816507015}, {1.04575387312703, 0.686061322226012}}], 
       PolygonBox[{{1.06812121687363, 0.625827976544001}, {1.0596353128956, 
        0.650617992164697}, {1.07483177655622, 0.648806485594693}, {
        1.06793912570712, 0.62613865392952}}], 
       PolygonBox[{{1.04943451682784, 0.747173471530045}, {1.06089528780412, 
        0.788369288876949}, {1.07712968788509, 0.788339759531133}, {
        1.07399786980502, 0.770798700947668}, {1.09525188802372, 
        0.778355002773328}, {1.09384182894121, 0.729042197786011}, {
        1.12418460159941, 0.699289659615951}, {1.08751657741101, 
        0.717085060321977}, {1.09219906631839, 0.727947301575889}, {
        1.05723201522376, 0.754580370739561}, {1.0492532469513, 
        0.747044411506989}}], 
       PolygonBox[{{1.05921959792257, 0.726168293987545}, {1.07106806195254, 
        0.71701757228619}, {1.05900831931788, 0.726476377751913}}], 
       PolygonBox[{{1.06173368835982, 0.70363483813435}, {1.08555224554023, 
        0.710816564025914}, {1.08732735305416, 0.690038920995772}, {
        1.06173368835982, 0.70363483813435}}], 
       PolygonBox[{{1.06814915326148, 0.668318049728958}, {1.05963048948074, 
        0.69252264837385}, {1.08609688541697, 0.676912763047964}, {
        1.06814915326148, 0.668318049728958}}], 
       PolygonBox[{{1.10215590518518, 0.623993107324268}, {1.1106893745236, 
        0.633954306189402}, {1.16328300342141, 0.597418559584802}, {
        1.10235180252316, 0.624104015942608}}]},
      "\"Philippines\""], 
     TooltipBox[
      {RGBColor[0.659946303833202, 0.219659409731599, 0.417475888460237], 
       PolygonBox[{{0.152228904537572, -0.600134405987067}, {
        0.204887503334168, -0.574861747158024}, {
        0.246771397245447, -0.567535358826019}, {
        0.263872713357846, -0.603980777286447}, {
        0.268079211576779, -0.645606362036393}, {
        0.171476049987605, -0.647485318283944}, {
        0.152228904537572, -0.600134405987067}}]},
      "\"Poland\""], 
     TooltipBox[
      {RGBColor[0.811828283274363, 0.262081628120835, 0.678885282234453], 
       PolygonBox[{{-0.114824257141479, -0.882088778820679}, \
{-0.1378753021025, -0.878780760383153}, {-0.142845885711235, \
-0.853613353439078}, {-0.123829156043853, -0.80453094539098}, \
{-0.0883343319538715, -0.815340252876288}, {-0.114824257141479, \
-0.882088778820679}}]},
      "\"Portugal\""], 
     TooltipBox[
      {RGBColor[0.74858112560467, 0.482370497631773, 0.426837970407237], 
       PolygonBox[{{-1.0792462192283, -0.452196400665601}}]},
      "\"Puerto Rico\""], 
     TooltipBox[
      {RGBColor[0.107509153130123, 0.981159600546947, 0.808740213800938], 
       PolygonBox[{{0.842065665041119, -0.676634978657976}, {
        0.824819427676753, -0.661987578017776}, {
        0.836000884590814, -0.681016186216246}, {
        0.842065665041119, -0.676634978657976}}]},
      "\"Qatar\""], 
     TooltipBox[
      {RGBColor[0.97206100583088, 0.670753130776773, 0.0947164872431613], 
       PolygonBox[{{0.377090914805578, -0.662005354493928}, {
        0.37580075200788, -0.689744650740963}, {
        0.300018367968854, -0.717803420502075}, {
        0.258865818656696, -0.701058428888005}, {
        0.279216098001384, -0.660997079170294}, {
        0.319841530537915, -0.636856848294627}, {
        0.357727201649556, -0.668091413817284}, {
        0.377090914805578, -0.662005354493928}}]},
      "\"Romania\""], 
     TooltipBox[
      {RGBColor[
       0.590110711602502, 0.571218532517196, 0.117257953602732], {
        PolygonBox[CompressedData["
1:eJxllmk81XkbxkVqoumJEkmylVEpSegZ5koimiwpiiZkVw0SSVKmpkhNMcpQ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         "]], 
        PolygonBox[{{-5.21168065650441*^-17, 
         0.425566021168959}, {-0.00582532216310335, 
         0.408665841995096}, {-0.0528953952402676, 
         0.442499263860631}, {-0.0523937465085162, 
         0.417670135460881}, {-0.0738247319835426, 
         0.406904048033125}, {-0.0436193653245996, 
         0.394048328730703}, {-0.0396017174025207, 
         0.40878664031454}, {-4.58779363343134*^-17, 
         0.374621779653165}, {-4.58779363343134*^-17, 
         0.374621779653165}, {-4.58951854254862*^-17, 
         0.374762629171449}, {-5.21168065650441*^-17, 0.425566021168959}}]}, 
       PolygonBox[{{0.216285584276439, -0.555220996966861}, {
        0.235372303102574, -0.557656765630552}, {
        0.239448953166215, -0.569163038805903}, {
        0.205054715167296, -0.574802123478805}, {
        0.218276067521554, -0.561295976464125}, {
        0.216285584276439, -0.555220996966861}}], 
       PolygonBox[{{0.390622995333911, 0.496987964328206}, {0.461562456730212,
         0.592547406899734}, {0.440899859217922, 0.598386367744389}, {
        0.41532350132626, 0.556185620013742}, {0.407698500976993, 
        0.576880035773073}, {0.370466866183263, 0.491923794056726}, {
        0.390622995333911, 0.496987964328206}}], 
       PolygonBox[{{0.286217256256205, 0.620378516297727}, {0.272278729284077,
         0.61346807698683}, {0.286217256256205, 0.620378516297727}}], 
       PolygonBox[{{0.175866792805199, 0.218343718237236}, {0.172656582664328,
         0.233190086083742}, {0.175803271752456, 0.218394866575157}}], 
       PolygonBox[{{0.138511378682665, 0.209267865629891}, {0.125639509920972,
         0.226193930983984}, {0.138511378682665, 0.209267865629891}}], 
       PolygonBox[{{0.170614240290614, 0.202133104823118}, {0.155229371255317,
         0.211319181752107}, {0.143158730561531, 0.207520393814322}, {
        0.158285513685554, 0.180384160538198}, {0.175162399808785, 
        0.187291794496362}, {0.169604572364857, 0.202605148664185}}], 
       PolygonBox[{{0.207065920565691, 0.0345271238938133}, {
        0.193212623790617, 0.0530987077647481}, {0.179888777433146, 
        0.0394414127428503}, {0.207075955338229, 0.034466889399181}}], 
       PolygonBox[{{0.184796412440964, 0.0308138036913574}, {
        0.169933977676737, 0.0224728174233539}, {0.181908939407332, 
        0.00905596345790914}, {0.184805367994634, 0.0307600472910631}}], 
       PolygonBox[{{0.247432006066518, -0.197522375427994}, {
        0.234273185844349, -0.171671444054361}, {
        0.24430088879907, -0.161290757433607}, {
        0.282687918467891, -0.179168596833918}, {
        0.247207534875143, -0.197343182430126}}], 
       PolygonBox[{{0.223489447180212, -0.145228188778566}, {
        0.234187265076164, -0.169834960459687}, {
        0.211459220820557, -0.0832960022465909}, {
        0.223447192557741, -0.145293193078284}}]},
      "\"Russia\""], 
     TooltipBox[
      {RGBColor[0.895447707704742, 0.0605432796088016, 0.0110838233078634]},
      "\"Rwanda\""], 
     TooltipBox[
      {RGBColor[0.367447467629068, 0.421451672282311, 0.198120319790849], 
       PolygonBox[{{0.168095000982364, -0.764539909440718}, {
        0.168095000982364, -0.764539909440718}}]},
      "\"San Marino\""], 
     TooltipBox[
      {RGBColor[0.351137519474662, 0.147788057897468, 0.00397578382207431], 
       PolygonBox[{{0.578577181721028, -0.827317839138598}, {
        0.583721427674401, -0.847206452342381}, {
        0.714806245419924, -0.876959756926491}, {
        0.813905211829187, -0.879450693672736}, {
        0.829895043215954, -0.844507331367476}, {
        0.868649634294285, -0.851139703900076}, {
        0.914992314152825, -0.715299067612243}, {
        0.934397710156839, -0.614563041861314}, {
        0.91134555004771, -0.618575027810295}, {
        0.906357079763649, -0.638575220062143}, {
        0.850418001910128, -0.684568595578853}, {
        0.842065665041119, -0.676634978657976}, {
        0.836000884590814, -0.681016186216246}, {
        0.764324398469367, -0.678201468402401}, {
        0.735828099813729, -0.697055411482858}, {
        0.712092166437155, -0.719169957813432}, {
        0.61188101289686, -0.747572514123278}, {
        0.588119207528145, -0.780460548845724}, {
        0.608761429008721, -0.793353340291235}, {
        0.578577181721028, -0.827317839138598}}]},
      "\"Saudi Arabia\""], 
     TooltipBox[
      {RGBColor[0.386292036516486, 0.0890558913538268, 0.468902775663015], 
       PolygonBox[{{-0.34225625313711, -1.15297413747664}, \
{-0.367833652161025, -1.16425706264846}, {-0.352719724316879, \
-1.18569391233579}, {-0.295730520590755, -1.20399900742056}, \
{-0.3585502963344, -1.1913322035737}, {-0.330879519452776, \
-1.20261680747547}, {-0.360797490425724, -1.20133092622827}, \
{-0.29624678120822, -1.2137186648909}, {-0.246455035748486, \
-1.22780972982684}, {-0.259016150359072, -1.19295605722579}, \
{-0.254994662909852, -1.19452882787732}, {-0.278490581277418, \
-1.17049130671311}, {-0.342322388708299, -1.15319693136996}}]},
      "\"Senegal\""], 
     TooltipBox[
      {RGBColor[0.255394658217404, 0.903921538884714, 0.66221792094659], 
       PolygonBox[{{0.258266703507711, -0.765214345575893}, {
        0.257363708973687, -0.763271580809863}, {
        0.247257609384978, -0.726314455576295}, {
        0.242500183166379, -0.710307159442284}, {
        0.258865818656696, -0.701058428888005}, {
        0.300018367968854, -0.717803420502075}, {
        0.314442536691013, -0.746205718677578}, {
        0.293361435670609, -0.755027789962517}, {
        0.286631920407292, -0.76527434816901}, {
        0.277603778103357, -0.755861663107469}, {
        0.270550644051058, -0.76969917188104}, {
        0.258266703507711, -0.765214345575893}}]},
      "\"Serbia and Montenegro\""], 
     TooltipBox[
      {RGBColor[0.361393622532892, 0.274235057670457, 0.0951813250837759], 
       PolygonBox[{{-0.298708922188255, -1.26362766476856}, \
{-0.264006057727957, -1.29956609640351}, {-0.232347979770106, \
-1.28490116065093}, {-0.250069694797649, -1.26101895005981}, \
{-0.298708922188255, -1.26362766476856}}]},
      "\"Sierra Leone\""], 
     TooltipBox[
      {RGBColor[0.69015691511571, 0.69064049175612, 0.179518570427296], 
       PolygonBox[{{1.35563897682488, 0.337579935745836}, {1.35563897682488, 
        0.337579935745836}}]},
      "\"Singapore\""], 
     TooltipBox[
      {RGBColor[0.505070613481274, 0.118938382598514, 0.573382538153387], 
       PolygonBox[{{0.268079211576779, -0.645606362036393}, {
        0.22464475567327, -0.648125553090248}, {
        0.211645558944311, -0.660518736954962}, {
        0.202991623051869, -0.68455693672848}, {
        0.211466051253498, -0.684546007725533}, {
        0.267671322072013, -0.657548240824109}, {
        0.268079211576779, -0.645606362036393}}]},
      "\"Slovakia\""], 
     TooltipBox[
      {RGBColor[0.284070862722554, 0.444527333872473, 0.10785455929065], 
       PolygonBox[{{0.182993029487947, -0.734855531958806}, {
        0.179187780160361, -0.734129675313289}, {
        0.175605575804403, -0.719453437243973}, {
        0.2040780750404, -0.706273925804402}, {
        0.210439973192446, -0.708918666520223}, {
        0.203823610600412, -0.724316726619541}, {
        0.182993029487947, -0.734855531958806}}]},
      "\"Slovenia\""], 
     TooltipBox[
      {RGBColor[0.20593507052432, 0.862619190440242, 0.246407014081624], 
       PolygonBox[{{0.969698344405517, -1.02941008391078}, {
        1.0084185872445, -0.909578888235564}, {
        1.00022577005383, -0.79799348371446}, {
        0.975145295137235, -0.795781547747997}, {
        0.903776418958578, -0.906409229117665}, {
        0.867419477765331, -0.921019815504945}, {
        0.867192194346278, -0.921852451955339}, {
        0.866796351985793, -0.931153098814062}, {
        0.902560798440537, -0.934085154061405}, {
        0.974838310403411, -0.878261957874581}, {
        0.955503442733523, -0.957172567852658}, {
        0.911063481765714, -1.01539684352387}, {
        0.904283077958003, -1.04087003425722}, {
        0.934127098956015, -1.06179403040139}, {
        0.934127098956015, -1.06179403040139}, {
        0.968095801287603, -1.03091731944386}, {
        0.969698344405517, -1.02941008391078}}]},
      "\"Somalia\""], 
     TooltipBox[
      {RGBColor[0.756717039815989, 0.0581470126268514, 0.858643406618168]},
      "\"South Africa\""], 
     TooltipBox[
      {RGBColor[0.860114977565137, 0.667661148462162, 0.589244236963836]},
      "\"Lesotho\""], 
     TooltipBox[
      {RGBColor[0.603248748400764, 0.956193438680423, 0.00544322751557177], 
       PolygonBox[{{0.705046104137553, 0.525525169833701}, {0.75110198031538, 
        0.556124419059099}, {0.707490543653169, 0.581828928087183}, {
        0.679819363698796, 0.538174527395577}, {0.705046104137553, 
        0.525525169833701}}]},
      "\"South Korea\""], 
     TooltipBox[
      {RGBColor[0.227850614430944, 0.329013690730307, 0.861012113596648], 
       PolygonBox[{{0.0452575463016063, -0.805287511269029}, {
        0., -0.846027345741764}, {-0.00175536536193861, -0.862070466357643}, {
        0., -0.867056047321792}, {-0.033374466220975, -0.895937020697827}, \
{-0.0847044050577968, -0.901677708250062}, {-0.114824257141479, \
-0.882088778820679}, {-0.0883343319538715, -0.815340252876288}, \
{-0.123829156043853, -0.80453094539098}, {-0.128477652940522, \
-0.785999846651085}, {-0.107885968010599, -0.777492271219276}, \
{-0.0243887538006001, -0.79071497208489}, {
        0.0208097678519139, -0.803626165699343}, {
        0.0245985702169268, -0.805117690224207}, {
        0.0452575463016063, -0.805287511269029}}]},
      "\"Spain\""], 
     TooltipBox[
      {RGBColor[0.315286312399862, 0.537210122674824, 0.149495120303011], 
       PolygonBox[{{1.29655854732887, -0.233287703992726}, {
        1.32063156393688, -0.221787836306422}, {
        1.30829410888479, -0.186586116829191}, {
        1.26878727210589, -0.225624669548106}, {
        1.27561421541305, -0.210795351700205}, {
        1.29655854732887, -0.233287703992726}}]},
      "\"Sri Lanka\""], 
     TooltipBox[
      {RGBColor[0.355941500115373, 0.196347929801348, 0.963827584521437], 
       PolygonBox[{{0.733387892130999, -0.918151246295393}, {
        0.671211838413251, -0.893970234734619}, {
        0.641720930116107, -0.895795672341347}, {
        0.626331979321844, -0.930909972370642}, {
        0.472650265685084, -1.01360176574234}, {
        0.484807753012208, -1.03967358145137}, {
        0.469492194326178, -1.05449673351758}, {
        0.491259593455522, -1.10338711243434}, {
        0.471446759302288, -1.11426188676445}, {
        0.464051556019837, -1.15825694822722}, {
        0.492558618138231, -1.17366154604911}, {
        0.495121904249889, -1.17306954164657}, {
        0.519778910007117, -1.19445936498172}, {
        0.622760677208135, -1.19886533782092}, {
        0.703163946174468, -1.17645402892555}, {
        0.761189392931962, -1.12850968360683}, {
        0.795821753741683, -1.098039157755}, {
        0.714788515782288, -1.10137905469587}, {
        0.71999572080542, -1.05613405706063}, {
        0.736859042940993, -1.00863588183765}, {
        0.715383561628229, -0.949346050931107}, {
        0.733387892130999, -0.918151246295393}}]},
      "\"Sudan\""], 
     TooltipBox[
      {RGBColor[0.865424257580458, 0.911414166242901, 0.0884933705106974], 
       PolygonBox[{{-1.09177711961488, -0.788380459749253}, \
{-1.13115451331694, -0.727583031755341}, {-1.15736515022733, \
-0.721798421687818}, {-1.15860837509067, -0.767835875799911}, \
{-1.12905463763975, -0.802377366540814}, {-1.09177711961488, \
-0.788380459749253}}]},
      "\"Suriname\""], 
     TooltipBox[
      {RGBColor[0.757892513997117, 0.0028050671402152, 0.665007152161277]},
      "\"Swaziland\""], 
     TooltipBox[
      {RGBColor[0.331776330694709, 0.699745501370265, 0.144161660522047], 
       PolygonBox[{{0.106003610610413, -0.524145344980895}, {
        0.137077565706562, -0.579878910134382}, {
        0.159325103051954, -0.561173319506315}, {
        0.150682946164305, -0.51921779811637}, {
        0.168146023001637, -0.50497510986137}, {
        0.145149548178988, -0.50564146169038}, {
        0.170707508557099, -0.493438033620307}, {
        0.141711828684215, -0.454053742149454}, {
        0.171516013794204, -0.382235030180207}, {
        0.127934184825173, -0.340363382776247}, {
        0.0960524661924798, -0.446776406392432}, {
        0.106003610610413, -0.524145344980895}}]},
      "\"Sweden\""], 
     TooltipBox[
      {RGBColor[0.80489217459614, 0.664115182232547, 0.11050126440643], 
       PolygonBox[{{0.0918708126844487, -0.744646003177747}, {
        0.133503860260702, -0.722668485821724}, {
        0.122061337647125, -0.72166996256481}, {
        0.120638479152873, -0.718339589978729}, {
        0.120380724834887, -0.714260437202609}, {
        0.095481568949316, -0.71719240406325}, {
        0.0775159962097096, -0.741665829492651}, {
        0.0918708126844487, -0.744646003177747}}]},
      "\"Switzerland\""], 
     TooltipBox[
      {RGBColor[0.540912912121283, 0.848698735915717, 0.658671954716975], 
       PolygonBox[{{0.533236950748014, -0.736187009636427}, {
        0.545563092664831, -0.751822592406917}, {
        0.55419550344164, -0.772192259042552}, {
        0.559035842659707, -0.779415102817716}, {
        0.594291437208083, -0.739149476670766}, {
        0.611785513031033, -0.703778726186398}, {
        0.599941286366904, -0.658172099795173}, {
        0.534455709396759, -0.717898605100971}, {
        0.533236950748014, -0.736187009636427}}]},
      "\"Syria\""], 
     TooltipBox[
      {RGBColor[0.882650649975486, 0.211899221390976, 0.987686622319069], 
       PolygonBox[{{0.9168950246952, 0.557115666202576}, {0.911311819848235, 
        0.569450826255876}, {0.962309575837093, 0.5717562897783}, {
        0.947079843713439, 0.549371113342875}, {0.9168950246952, 
        0.557115666202576}}]},
      "\"Taiwan\""], 
     TooltipBox[
      {RGBColor[0.343385642317113, 0.345440527300662, 0.0624041010879646], 
       PolygonBox[{{0.823153649036396, -0.336481560198053}, {
        0.813651876870757, -0.325163018958358}, {
        0.788913476608309, -0.325435174300417}, {
        0.782738413100392, -0.291357014943513}, {
        0.793041480320659, -0.295454780505038}, {
        0.813119350144144, -0.271802947380676}, {
        0.820262691400985, -0.232626451438526}, {
        0.858063044511747, -0.231523178022547}, {
        0.8518739465741, -0.28200530122868}, {
        0.82180021969981, -0.283770932642398}, {
        0.823153649036396, -0.336481560198053}}]},
      "\"Tajikistan\""], 
     TooltipBox[
      {RGBColor[0.631745122203696, 0.147037712515765, 0.381612942779225]},
      "\"Tanzania\""], 
     TooltipBox[
      {RGBColor[0.196979843507507, 0.720330955960795, 0.058544342005068], 
       PolygonBox[{{1.23163364604286, 0.282458846925879}, {1.2273933489308, 
        0.235618238846185}, {1.21813834658868, 0.220641244401327}, {
        1.2643703626176, 0.203651157720031}, {1.30125461049381, 
        0.239216202981039}, {1.30556749761725, 0.279889419593343}, {
        1.31765986019735, 0.259708926950172}, {1.31205696461296, 
        0.234500566947126}, {1.2956031841189, 0.188623183880388}, {
        1.26598210920913, 0.194853283205657}, {1.24299696614628, 
        0.211725161049326}, {1.20375462595122, 0.173106277227985}, {
        1.18374460056792, 0.186075084496761}, {1.15819545996301, 
        0.149395677803879}, {1.12450223610479, 0.199966890435575}, {
        1.13104778058987, 0.225663523012008}, {1.16029666553095, 
        0.223787972060701}, {1.13760637197071, 0.271016066096427}, {
        1.14382216586667, 0.300431779050643}, {1.18350254514252, 
        0.321920233923219}, {1.20894272852582, 0.264329006658566}, {
        1.23163364604286, 0.282458846925879}}]},
      "\"Thailand\""], 
     TooltipBox[
      {RGBColor[0.623720428782108, 0.194174776367292, 0.0553238037995178], 
       PolygonBox[{{0.0279992545649475, -1.33667045268134}, {
        0.0384528429572117, -1.33489486590405}, {
        0.0203521736867897, -1.27199363138073}, {-0.00369532202636874, \
-1.27035455322859}, {
        0., -1.27080921736828}, {-0.00185614579599811, -1.27619094337471}, {
        0., -1.2775356350312}, {0.0279992545649475, -1.33667045268134}}]},
      "\"Togo\""], 
     TooltipBox[
      {RGBColor[0.726768011310359, 0.923974927411843, 0.0500131158452447], 
       PolygonBox[{{0.133857337987503, -0.883352415707857}, {
        0.170791979325898, -0.874573147805536}, {
        0.162599594073499, -0.922148121746256}, {
        0.19029301604722, -0.932542720642236}, {
        0.165036913872897, -0.982709247292334}, {
        0.122791276890418, -0.932692346447169}, {
        0.133857337987503, -0.883352415707857}}]},
      "\"Tunisia\""], 
     TooltipBox[
      {RGBColor[0.250431629203378, 0.0626528290778128, 0.813473663005413], 
       PolygonBox[{{0.533236950748014, -0.736187009636427}, {
        0.525359195675759, -0.722652747029254}, {
        0.491720355279541, -0.763000635879756}, {
        0.44873893746055, -0.787255124913288}, {
        0.412491386099254, -0.796910953097476}, {
        0.42328417475726, -0.785029560099111}, {
        0.385694322911056, -0.782684587925214}, {
        0.397077223831158, -0.773735605906122}, {
        0.372863438439809, -0.759430790801701}, {
        0.408439010013848, -0.718495962299756}, {
        0.465093854581022, -0.665458089223783}, {
        0.544483058539171, -0.614705160081436}, {
        0.599841992234032, -0.603693041025872}, {
        0.626977477588628, -0.631369956601111}, {
        0.600116739467119, -0.65836458252308}, {
        0.534455709396759, -0.717898605100971}, {
        0.533236950748014, -0.736187009636427}}], 
       PolygonBox[{{0.365870522382473, -0.749039414581311}, {
        0.372607230762371, -0.757794247877377}, {
        0.401883520316558, -0.725514698760098}, {
        0.382236311865634, -0.718377748765084}, {
        0.363066880764948, -0.732998915818694}, {
        0.365870522382473, -0.749039414581311}}]},
      "\"Turkey\""], 
     TooltipBox[
      {RGBColor[0.509100203723962, 0.401732893287661, 0.403980874360838], 
       PolygonBox[{{0.652051340360904, -0.494336262300093}, {
        0.677018239204164, -0.478173946837577}, {
        0.666843500118839, -0.507692133953771}, {
        0.716626128225741, -0.522572760809617}, {
        0.733222038750486, -0.472529359005668}, {
        0.76652124904128, -0.450314994072709}, {
        0.801755647134655, -0.439251570256854}, {
        0.816550495991501, -0.397082841370774}, {
        0.805783447307032, -0.362415211551477}, {
        0.769593938411813, -0.382587970403177}, {
        0.715382666757528, -0.406944602440656}, {
        0.683466014782424, -0.416098659773277}, {
        0.681002721146538, -0.459342135406208}, {
        0.652051340360904, -0.494336262300093}}]},
      "\"Turkmenistan\""], 
     TooltipBox[
      {RGBColor[0.930823013029928, 0.297200982332986, 0.414046270968592], 
       PolygonBox[{{0.842065665041119, -0.676634978657976}, {
        0.880964486336654, -0.63732147345066}, {
        0.877691723447138, -0.583873292604869}, {
        0.903262763003241, -0.595592054731485}, {
        0.91134555004771, -0.618575027810295}, {
        0.906357079763649, -0.638575220062143}, {
        0.850418001910128, -0.684568595578853}, {
        0.842065665041119, -0.676634978657976}}]},
      "\"UAE\""], 
     TooltipBox[
      {RGBColor[0.0605952320437249, 0.585382485729266, 0.234796881245022], 
       PolygonBox[{{-0.0471199502838646, -0.538583496248086}, \
{-0.0284520024381855, -0.53989161477358}, {-0.041475411485408, \
-0.558119072077227}, {-0.0176888744454045, -0.557701759650106}, \
{-0.0375472288324452, -0.583257923570123}, {0., -0.621905820602448}, {
        0.00145431445349752, -0.624944473912244}, {0., -0.625775073921454}, {
        0.0198279762968112, -0.642848660994197}, {
        0.00441702226748686, -0.660190324881267}, {
        0.00273666527983861, -0.671993587066744}, {-0.0578061457186843, \
-0.671982618187976}, {-0.0272490144259973, -0.654693538574593}, \
{-0.0492336075854583, -0.654786012407847}, {-0.0523870222537929, \
-0.634933969839545}, {-0.0299997522161995, -0.628373797477965}, \
{-0.0316647531413498, -0.600855238292338}, {-0.0540339082148047, \
-0.601485742415106}, {-0.0499030279004834, -0.578141259470106}, \
{-0.0604441814221526, -0.593345109418398}, {-0.0471199502838646, \
-0.538583496248086}}], 
       PolygonBox[{{-0.0757574679810152, -0.595502354155387}, \
{-0.0671328204116011, -0.612985407394456}, {-0.0672809218180916, \
-0.612690783893243}, {-0.0865953423338855, -0.604667403622311}, \
{-0.0757574679810152, -0.595502354155387}}]},
      "\"United Kingdom\""], 
     TooltipBox[
      {RGBColor[0.782301148764896, 0.913557519527959, 0.20376954295004], 
       PolygonBox[CompressedData["
1:eJxllGs0FHgAxUcPIlIhtrRFqTYlsR3v/tJqKY9QkuxSml5CRwitltYr1SJR
djJF6DnFISTtDRFmPKamGMOQwbwwg14S1n7d/XDPPff8Pt1z7rl6h4LdqbMo
FMr+Gf3r/tOex9MPSeGdtUNHX7WT/C2Wq6muluJkhpBjPM0jvTr2o4JsMaK2
u1s0ufGJW4bakmG+EPF/hpVtovJJadBUTpxMiMycWOoRmy5S8e7dN8+xAcQo
G96puMEndm3PTzxL6sdwRSB7i20XafKP6tN/LoAvZe9TQVEHmdTVjNjzqBfr
h22PUgRc0s4JoISYCeD2A3HOLG8nMQ9UmjfTBJgS6MtvJnKJzyz7l5m8XnzL
CHcMsGsnjtnznLM7elGga7LTxKadOFPf6w58EiAyY61LtS+HcKI9fsld1Yc0
0xxO2sM3RKPvupsP+pF10OJnamEtWcu2KrpsPQBx9jw1nchS8kFjyM9LNoDF
kaNxh/eHYUtz6LtZ6UIcZWpq9/gVoyzKqJLlKMbV/cFOE8MVCM6lefZdEMPQ
hOOX4V2BWGWl1I9fxWjXPXZC/VYFavpyQse1xAjtYYQq3K2BnVMeLU9BDN4y
GiXGvQbFllKZ4aAIVz+HvBRtq8G9DwuvHKeIMKd+w+fvdtXjwMR8fn+oEFJ7
xdSD6iy0c6fljWZCRHc+vK6u0YKepbN9MVeI6WTDmE0pLVCYs0pysaQfmmXV
DovDW5HGbGvPix7AoiefWq6KXsMtdrvJVXURku4l96g0tyKIqZTStl4E8nWN
TNbaCvZQuOJUpwjOV+gPXWexcddTNfBRtwjGcXT/2RT2/7i7zxeHpYvEqI4s
Y28PbsV4B8PyyhkxzI0UypN6m9BBRMKSV2KsPbfHzEarCUbmN3LT6RLQPOi/
HeSwcP5sW4qDngS51tI+vpwJFXPbIMaOGb5givHRlYk32lHzS3olSGIljhaB
hYJE9wiLVVIElVmFPNvHQtKDVn3b21K0jlmdjbjPhJPZZNpeEylUTFSdr3OY
KBxU9POfliAzvOubV1gjfh/LSxcGSnCYy2+gPm7Eed7NBCNrKTbWPu4eiW+E
nzD/8O5RCVKyQpPHuPUIWRZmqieUgMlhlLqX1qNHVJU0314KiYaDLVVSj5L8
yZMGxVJ4/GEco6jJxMT4xq05Mzlyvn3+PoUGbLjNLo4USeG0Pj+qcTUL63pJ
5nnrQUzphIpKNjRBtFx9Y/A7Ka7ZOCJugAkDz4bL3c6DUNvKUacVNWJHFxRp
XoMI3NT9oJbJgs1bM5Oe5EHU7V1s32bbCAetDEl47SBsXXk9/Akmbgf4+XPj
hmCf6nU7fuwVUnv6f3x6axixDTk672f2d8F4JFrHRYY8/uo6Xmk1Vsy76V0a
J0fl2VQDlvkr9P1U6GvXL4dLVueRNa/rEPpmM/v4RzlWyyeHVzrW4qa1+PQu
XzkMeZG+ahEvYPE6KkPbWI7+SOUHafdfQGT4ckV8uwwLFRZcTDetxOGLKq7N
dTJQ+qws55ZXQEJo092Kcmg1dU7zFJ6gMESwK/+FDOELGBTlawx4TdJcrd7K
YHDBNI+7pAA+B7bt3t0kw42aU0tVAm8gQLswYVokQ7W518hpy1hU+mjyXMZl
UFVqHeDSE2CcrqcwslGOwcf0PCXpJZR+2Wn5vZkcn3Xp4mZqClEpTvjLW1kO
lZWO9803F5HyFfSIeTN9NFoSUygOVeQsVbUq5q0c44+OjWZ0vCC2DOXlhQVy
nBo5fYniVEuMzr2/RamV4e33ZEmQWz2pYQbc7/aWQXOLafZC/xbi07muyoM7
hHI6o6SmmE1qLX71q88dQnAv3eXcGQ4xFpnyuruksCmL54Td4ZL//u8/dz0p
CQ==
        "]], 
       PolygonBox[{{-0.449004803618811, 
        0.376759765113371}, {-0.459009189641553, 
        0.394577943055543}, {-0.439940332214453, 
        0.382659030862074}, {-0.435810122094456, 
        0.396093472838973}, {-0.37020648349786, 
        0.374539287646808}, {-0.386421208764197, 
        0.388449821011014}, {-0.3356315766518, 
        0.392974085896427}, {-0.264901254517919, 
        0.419302343024853}, {-0.262830156779872, 
        0.448880192976653}, {-0.248819762368119, 
        0.467633699859228}, {-0.251712953681646, 
        0.423091436482625}, {-0.241028913242634, 
        0.482374575462806}, {-0.214942069032933, 
        0.543805812629617}, {-0.173441324283453, 
        0.579334368357812}, {-0.21507396247323, 
        0.516682009596127}, {-0.209701001262503, 
        0.488876296848606}, {-0.182152494115642, 
        0.504566030412184}, {-0.165485031313813, 
        0.514397148748774}, {-0.15728853181519, 
        0.480751258859695}, {-0.146520788747343, 
        0.499982054235397}, {-0.142282915239645, 
        0.481882896521528}, {-0.127498651427674, 
        0.476385701773341}, {-0.117095303096234, 
        0.476726678125227}, {-0.124437327143888, 
        0.446185477486047}, {-0.14801399538561, 
        0.433547716324498}, {-0.141420869384063, 
        0.410328243933646}, {-0.0867360912597006, 
        0.412782290356393}, {-0.109862235833911, 
        0.39041136992871}, {-0.129965029799756, 
        0.395290883816123}, {-0.120270175503526, 
        0.381061718578001}, {-0.138317236150531, 
        0.384893339847806}, {-0.0855603408155282, 
        0.365745352447434}, {-0.107778931406929, 
        0.326530494803057}, {-0.129051163589049, 
        0.296325795632343}, {-0.222265669043563, 
        0.274638552006889}, {-0.32257625704395, 
        0.398348502589294}, {-0.365396179072057, 
        0.371397399576427}, {-0.448895189650701, 0.376890359374593}}], 
       PolygonBox[{{-0.468376903888492, 
        1.04299720682722}, {-0.491270630565272, 
        1.04400323224635}, {-0.479038711804863, 
        1.05930953618941}, {-0.468376903888492, 1.04299720682722}}], 
       PolygonBox[{{-0.247984680303854, 
        0.492348866172903}, {-0.260382899192809, 
        0.496658180939889}, {-0.239360749896539, 
        0.508667485938173}, {-0.247984680303854, 0.492348866172903}}]},
      "\"USA\""], 
     TooltipBox[
      {RGBColor[0.0378170377375146, 0.061970192804101, 0.855013177522891], 
       PolygonBox[{{0.703163946174468, -1.17645402892555}, {
        0.721015269011756, -1.18586178868153}, {
        0.712910987100188, -1.22137542323064}, {
        0.712910987100188, -1.22137542323064}, {
        0.757773520542205, -1.19406000333529}, {
        0.796936471453218, -1.16828603538162}, {
        0.796936471453218, -1.16828603538162}, {
        0.798141692385666, -1.13845422760268}, {
        0.761189392931962, -1.12850968360683}, {
        0.703163946174468, -1.17645402892555}, {
        0.703163946174468, -1.17645402892555}}]},
      "\"Uganda\""], 
     TooltipBox[
      {RGBColor[0.580049114167932, 0.843642261370223, 0.00664638900458321], 
       PolygonBox[{{0.263762759385702, -0.603729102588004}, {
        0.302135197121091, -0.584541566911228}, {
        0.340931766981947, -0.553454949309448}, {
        0.365922857975258, -0.544892980473433}, {
        0.440762409999392, -0.533421782007884}, {
        0.462335104362617, -0.552293321140845}, {
        0.452791249806985, -0.574019443194674}, {
        0.442776131267277, -0.586873083863402}, {
        0.426070637480729, -0.612654951275809}, {
        0.453505953927468, -0.615870335911738}, {
        0.42897411681118, -0.644843730081376}, {
        0.407577088597632, -0.640178744467735}, {
        0.417021290194386, -0.623723624529732}, {
        0.392384925518016, -0.632852098574289}, {
        0.383578903593531, -0.61985660103496}, {
        0.377090914805578, -0.662005354493928}, {
        0.357727201649556, -0.668091413817284}, {
        0.363635407563086, -0.639247863295783}, {
        0.338454066341871, -0.629015684854844}, {
        0.319841530537915, -0.636856848294627}, {
        0.279216098001384, -0.660997079170294}, {
        0.267671322072013, -0.657548240824109}, {
        0.268079211576779, -0.645606362036393}, {
        0.263762759385702, -0.603729102588004}}]},
      "\"Ukraine\""], 
     TooltipBox[
      {RGBColor[0.128245166212532, 0.656074186756089, 0.793629145524978]},
      "\"Uruguay\""], 
     TooltipBox[
      {RGBColor[0.756214759801206, 0.0655923371347192, 0.842600523750676], 
       PolygonBox[{{0.681002721146538, -0.459342135406208}, {
        0.634517887649971, -0.427987719308771}, {
        0.646850311214281, -0.393806775682727}, {
        0.698151478836254, -0.368612752371976}, {
        0.764368983313162, -0.31011908200479}, {
        0.771901288729698, -0.288602065930611}, {
        0.764705314504112, -0.263060363699324}, {
        0.78353868828144, -0.266229755282946}, {
        0.794158630168443, -0.242798659187674}, {
        0.793041480320659, -0.295454780505038}, {
        0.782738413100392, -0.291357014943513}, {
        0.788913476608309, -0.325435174300417}, {
        0.813651876870757, -0.325163018958358}, {
        0.823153649036396, -0.336481560198053}, {
        0.805783447307032, -0.362415211551477}, {
        0.769593938411813, -0.382587970403177}, {
        0.715382666757528, -0.406944602440656}, {
        0.683466014782424, -0.416098659773277}, {
        0.681002721146538, -0.459342135406208}}]},
      "\"Uzbekistan\""], 
     TooltipBox[
      {RGBColor[0.284528941801016, 0.354481866513544, 0.661611462773881], 
       PolygonBox[{{-1.13004145839535, -0.652868101480074}, \
{-1.14780324658627, -0.620183473720446}, {-1.12935689733323, \
-0.629883481663121}, {-1.14443374490931, -0.582698851319333}, \
{-1.12464597517384, -0.601766863916436}, {-1.16551157439158, \
-0.541424600116259}, {-1.18595991366374, -0.471950769748521}, \
{-1.18030940448602, -0.429208710036354}, {-1.18842449770731, \
-0.437255076758527}, {-1.20955556032645, -0.402756399467378}, \
{-1.23209977110617, -0.409069067465896}, {-1.19424114533975, \
-0.403841173180835}, {-1.24232034830743, -0.37074530734419}, \
{-1.26017101659274, -0.409454383912825}, {-1.23354713737585, \
-0.512213576996737}, {-1.27764628169158, -0.520097611290332}, \
{-1.28662001120587, -0.549674867493522}, {-1.24057849081831, \
-0.621235431825163}, {-1.23090494982336, -0.579219902954232}, \
{-1.21898115284825, -0.624231678111468}, {-1.1958978318817, \
-0.648869189397158}, {-1.17646054887011, -0.659299185921453}, \
{-1.17535334846521, -0.641267048315064}, {-1.13004145839535, \
-0.652868101480074}}]},
      "\"Venezuela\""], 
     TooltipBox[
      {RGBColor[0.911777510720748, 0.98732795946803, 0.940435595544953], 
       PolygonBox[{{1.24015342063817, 0.319571120700729}, {1.26106304715676, 
        0.334364808324155}, {1.23690173422268, 0.3503965532694}, {
        1.23764767482065, 0.367783065031546}, {1.19189350172272, 
        0.416227844175117}, {1.14825917163034, 0.394256827272354}, {
        1.13252949778423, 0.337263020697325}, {1.10939835687496, 
        0.313579569268503}, {1.06993352521592, 0.347298419929048}, {
        1.07049358001214, 0.350235928486327}, {1.06106836537375, 
        0.294592717853168}, {1.08773718917674, 0.233852634326286}, {
        1.10513252492687, 0.258528276152622}, {1.1006174662112, 
        0.287715247498445}, {1.12333494195242, 0.277650540720373}, {
        1.14702443675574, 0.360921898742575}, {1.16480890371932, 
        0.368380684410277}, {1.19552436773345, 0.378094710135335}, {
        1.21513150729917, 0.344993152547656}, {1.24015342063817, 
        0.319571120700729}}]},
      "\"Vietnam\""], 
     TooltipBox[
      {RGBColor[0.601016230730156, 0.326395024991483, 0.752531078223009], 
       PolygonBox[{{-0.236063386504885, -1.00777990932531}, \
{-0.33313092687625, -1.08623096067893}, {-0.25374773978041, \
-1.09910221301298}, {-0.250524252896803, -1.07656383852983}, \
{-0.220352820447257, -1.03667851378467}, {-0.159702523531405, \
-1.04773699486061}, {-0.156792874565818, -1.0286480863331}, \
{-0.155968539642498, -1.02323999273371}, {-0.236063386504885, \
-1.00777990932531}}]},
      "\"Western Sahara\""], 
     TooltipBox[
      {RGBColor[0.158134446780057, 0.687458711202197, 0.122625482041442], 
       PolygonBox[{{0.829895043215954, -0.844507331367476}, {
        0.813747012436706, -0.879279754153694}, {
        0.860629723756602, -0.905330917334076}, {
        0.924704316360136, -0.812372591677192}, {
        0.955241550875431, -0.71765025080549}, {
        0.914992314152825, -0.715299067612243}, {
        0.868649634294285, -0.851139703900076}, {
        0.829895043215954, -0.844507331367476}}]},
      "\"Yemen\""], 
     TooltipBox[
      {RGBColor[0.714714040485494, 0.0961642539759556, 0.832445533679305]},
      "\"Zambia\""], 
     TooltipBox[
      {RGBColor[0.54257636787351, 0.871071779115271, 0.0895178649713724]},
      "\"Zimbabwe\""]}}, 
   {Thickness[0.001], 
    LineBox[{{7.49879891330929*^-33, 6.12323399573677*^-17}, {
     7.49879891330929*^-33, 6.12323399573677*^-17}, {7.69341711276369*^-18, 
     0.0628215181562565}, {1.53792417516746*^-17, 0.125581039058627}, {
     2.30498889357349*^-17, 0.188216626637029}, {3.06977886622626*^-17, 
     0.250666467128609}, {3.83153933775695*^-17, 0.312868930080462}, {
     4.58951854254862*^-17, 0.374762629171449}, {5.34296844663809*^-17, 
     0.436286482793085}, {6.09114548593512*^-17, 0.49737977432971}, {
     6.83331130003044*^-17, 0.557982212078458}, {7.5687334608683*^-17, 
     0.618033988749895}, {8.29668619556455*^-17, 0.677475840490583}, {
     9.01645110265684*^-17, 0.736249105369356}, {9.72731786108014*^-17, 
     0.794295781269561}, {1.04285849311679*^-16, 0.851558583130145}, {
     1.11195602469869*^-16, 0.907980999479094}, {1.17995618993229*^-16, 
     0.963507348203431}, {1.24679188086426*^-16, 1.01808283150074}, {
     1.31239713873683*^-16, 1.07165358995799}, {1.37670721908109*^-16, 
     1.12416675570426}, {1.43965865561199*^-16, 1.17557050458495}, {
     1.50118932286191*^-16, 1.22581410730595}, {1.56123849749094*^-16, 
     1.27484797949738}, {1.61974691821355*^-16, 1.3226237306473}, {
     1.67665684428231*^-16, 1.36909421185738}, {8.65956056235493*^-17, 
     1.4142135623731}}], LineBox[CompressedData["
1:eJyFlEtIVGEUx6eEHk6gPTY9XLiqjdIiKRrlEJaCC6FcuAmiaOpm0cDgJimN
KAiEcFNm1jA2LmxTLXKEHh7atBtsIU0URFBBSESjzSBDaY97fgOdTQPDx73f
/c53/o/zrz+WOBRfGYlEgt//P2v+WtV0unizORcbOJFKl+R/z1eHg7ODT7Jy
vHn77p3XS3J5eHm85uELWU5daCokS9KWrs5liy+lPDFfrtpbkgeds+2tl17J
UHZj9O5cUd70NdVsWHwrU7nEyNYrRYlmMr0zE+8laBvak19blJO7ujc93/9B
MvHu5MFz36W3sX19LPdJYqmGjm2zC1JXV7vvvnyWUzfO33u3ZUEuzhx4PDYy
J7d/rJvq6pyXw7UfuyZff5HGwcLmjkRBlm49i46Xv8rq1ukdmf5vssbWn/a+
wb47YufuWJ1+qxvYPfV2b4v1EVhf9NljfYOj2nCBM2+44eGR8QJPLcbbkvE4
ZrzCc9x4d7o8ZT8Z7is6jIbnlfqxsL5y/2R4v9Kf6aL0b7qow6fgPx3i1x7j
x3RR+BsI+VPHr64y/leM/uVfbRV7r0dNBzun6GB11emvZ0wH60udf9T5S53/
1PlTY//6V52/1flfI/YzXdhX9u08ulAfXbgfXegPXegfXcCHLuBHF/hR+DH+
0AV+0QX+0aWy8p7v0I866Gv6V+6lD/xBn/gHHOACJ7jhAX/CE7zBI/6GZ/yP
Dm4+lPmx+VLmi/rMH/czn/TH/NI/8+3wVXxIPlh+KPkBf/ja8Us+Kflk+aXk
l+Wbkm+Wf0r+Of3JTyU/nX/E+Uuc/8T5k3yv5Irztzj/V3LK5xbPvwAoGnVm

     "]], 
    LineBox[{{-8.65956056235493*^-17, 
     1.4142135623731}, {-1.67665684428231*^-16, 
     1.36909421185738}, {-1.61974691821355*^-16, 
     1.3226237306473}, {-1.56123849749094*^-16, 
     1.27484797949738}, {-1.50118932286191*^-16, 
     1.22581410730595}, {-1.43965865561199*^-16, 
     1.17557050458495}, {-1.37670721908109*^-16, 
     1.12416675570426}, {-1.31239713873683*^-16, 
     1.07165358995799}, {-1.24679188086426*^-16, 
     1.01808283150074}, {-1.17995618993229*^-16, 
     0.963507348203431}, {-1.11195602469869*^-16, 
     0.907980999479094}, {-1.04285849311679*^-16, 
     0.851558583130145}, {-9.72731786108014*^-17, 
     0.794295781269561}, {-9.01645110265684*^-17, 
     0.736249105369356}, {-8.29668619556455*^-17, 
     0.677475840490583}, {-7.5687334608683*^-17, 
     0.618033988749895}, {-6.83331130003044*^-17, 
     0.557982212078458}, {-6.09114548593512*^-17, 
     0.49737977432971}, {-5.34296844663809*^-17, 
     0.436286482793085}, {-4.58951854254862*^-17, 
     0.374762629171449}, {-3.83153933775695*^-17, 
     0.312868930080462}, {-3.06977886622626*^-17, 
     0.250666467128609}, {-2.30498889357349*^-17, 
     0.188216626637029}, {-1.53792417516746*^-17, 
     0.125581039058627}, {-7.69341711276369*^-18, 
     0.0628215181562565}, {-7.49879891330929*^-33, 
     6.12323399573677*^-17}, {-7.49879891330929*^-33, 
     6.12323399573677*^-17}}], LineBox[CompressedData["
1:eJx1VUtIVGEUnmrRJBSiWRERCGG1aJEGEh2EIYTsQSgmRFlN5BOkIodyUzSN
YZMzegWDFlaLMGgpFJmnB0RQkDm4KIKa0QqiTVPRw0VDD873/XAvNDD83Md/
/nO+1y0/fLShZX4oFGr/+/+31jUne5+f3Doe3r+0qmLUk+D1tkL4RsVEvfYt
S01vGfGkuiR1c+NYVEcfvR3rjXvypDZSlu/u1Ktr72dWN3kyde77q1Pp41oZ
jYQ3rfBkbmZl471MTHP1tz4seDoo/YeGYj9/9Wh+TdOxbPugFE91/M4vOa0v
rxSSdZ8HpKcwuap23lk90lo07H1Ky4EdDYvff4zrl+WNBy9PpiS3vWhd24OE
xp+Vv0mk+yX1blHJtzPndffCZNelyovS8TU/8nh9n+b2PhzeMHFBZm1V3Be8
pwO2TxJWR7NWV/J2jkbtXGmzPvSE9SUvrE8ts74FcyjmklmbU3/Y3AIcNGO4
yDXDSe8YbnLdcNSI4SrAWXca7gIe1HipGufzPeAFPGgNeGH92+CF50+DF/Cg
5IX9e+AFPGgpeOH83eAFPGgzeCF+5CWAr74G/l3ghWsW9/neLuxjHdYN8K8x
9NGCvkr9+tEhv77Ig5s7oE+9C5yIW41f37rPr38N4Ude8Nzxhv3C/ajveMf5
ThfUCftD/05XmE84H+YXzg98hPgAP6dr6pz4An8h/uBHyAt9RF5Qx/mOPiT/
0IdQH/QxeaHPqS/mAPXHnKA+gZNQv8wZ8sIcov79ueX8IfQP/CX0F+vTfzyf
/oR/hbywf/ob/hf6n/MzH5AfwvwgfsyXAL7MJ+aWW5lfyDe3j/wy/wL8Mz+F
+Vns14+bg3PN+fUnAX0y34X5Xu3XN78P1D+/H5sD35P/Xv8BXghDWw==
     "]]}},
  AspectRatio->Automatic]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->542178915]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldPlot"]], "InlineFormula"],
 " works by creating a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics object that represents the map. Each country on the map is given \
as a ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " primitive. To make a map from a list of countries, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must know the vertices of these polygons for each country in your list. \
These data are contained in the package ",
 StyleBox["WorldData", "MR"],
 ", which is automatically loaded when ",
 StyleBox["WorldPlot`", "MR"],
 "is loaded. As noted above, the vertex data are given as ordered pairs of \
latitude and longitude expressed in minutes. By convention, latitudes north \
of the equator are positive while those to the south are negative, and \
longitudes east of Greenwich are positive and those to the west are negative. \
"
}], "Text",
 CellID->6331],

Cell[TextData[{
 "You can specify your own database of geographic coordinates by setting the \
option ",
 Cell[BoxData[
  ButtonBox["WorldDatabase",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldDatabase"]], "InlineFormula"],
 ". The setting for this option is the name of the function that is applied \
to a country name to yield its polygonal vertices. The names of the countries \
that appear in your database are specified using the option ",
 Cell[BoxData[
  ButtonBox["WorldCountries",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldCountries"]], "InlineFormula"],
 ". The setting for this option is the name of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list that contains the allowable country names. The default value is ",
 StyleBox["World", "MR"],
 ", which is a list given in the package ",
 StyleBox["WorldNames", "MR"],
 ". This package is also automatically loaded when you load ",
 StyleBox["WorldPlot`", "MR"],
 ". "
}], "Text",
 CellID->5642],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WorldGraphics",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldGraphics"], "[", 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["options", "TI"], "]"}], Cell[
    "a graphics object representing a planetary map", "TableText"]},
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     StyleBox["wg", "TI"], ",", 
     StyleBox["options", "TI"], "]"}], Cell[TextData[{
     "display a ",
     ButtonBox["WorldGraphics",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldGraphics"],
     " object using the options specified"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Graphics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Graphics"], "[", 
     ButtonBox["WorldGraphics",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldGraphics"], "[", 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["options", "TI"], "]", "]"}], Cell[TextData[{
     "convert a ",
     ButtonBox["WorldGraphics",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/WorldGraphics"],
     " object to a ",
     ButtonBox["Graphics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Graphics"],
     " object"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->22596],

Cell[TextData[{
 "Creating and displaying ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 " objects. "
}], "Caption",
 CellID->7444],

Cell[TextData[{
 "Built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " work by building up a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object, and then displaying it. The resulting ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object can be manipulated and redisplayed using various options. ",
 Cell[BoxData[
  ButtonBox["WorldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldPlot"]], "InlineFormula"],
 " works in a very similar way, creating a ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 " object and then displaying it. A ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 " object is essentially a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object that has been adapted to work with geographic data. All coordinates \
given in the primitives ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " are given as ",
 StyleBox["{", "MR"],
 StyleBox["lat", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["long", "TI"],
 StyleBox["}", "MR"],
 " with the latitude and longitude given in minutes of an arc. You can \
convert data given in degrees and minutes into minutes using the function ",
 Cell[BoxData[
  ButtonBox["ToMinutes",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/ToMinutes"]], "InlineFormula"],
 ". Thus ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"], "[", 
   RowBox[{
    ButtonBox["ToMinutes",
     BaseStyle->"Link",
     ButtonData->"paclet:WorldPlot/ref/ToMinutes"], "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"41", ",", " ", "49"}], "}"}], ",", " ", 
      RowBox[{"-", 
       RowBox[{"{", 
        RowBox[{"87", ",", " ", "37"}], "}"}]}]}], "}"}], "]"}], "]"}]], 
  "InlineFormula"],
 " represents a point displayed at the location of Chicago, Illinois, which \
is at latitude ",
 Cell[BoxData[
  FormBox["41", TraditionalForm]], "InlineFormula"],
 " degrees, ",
 Cell[BoxData[
  FormBox["49", TraditionalForm]], "InlineFormula"],
 " seconds North and longitude ",
 Cell[BoxData[
  FormBox["87", TraditionalForm]], "InlineFormula"],
 " degrees, ",
 Cell[BoxData[
  FormBox["37", TraditionalForm]], "InlineFormula"],
 " minutes West. Before a ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 " object is displayed, it is internally converted to a standard ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object using the projection specified by the value of ",
 Cell[BoxData[
  ButtonBox["WorldProjection",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldProjection"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15960],

Cell["\<\
Here is the list of the vertices of the polygon that give the map of Ireland. \
\
\>", "MathCaption",
 CellID->5345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WorldData", "[", "\"\<Ireland\>\"", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "382"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3087", ",", 
      RowBox[{"-", "586"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "628"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3160", ",", 
      RowBox[{"-", "524"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3246", ",", 
      RowBox[{"-", "607"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3303", ",", 
      RowBox[{"-", "435"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3266", ",", 
      RowBox[{"-", "489"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{487, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->199535790]
}, Open  ]],

Cell["\<\
This is a list of the latitude and longitude in minutes of two cities in \
Africa. \
\>", "MathCaption",
 CellID->7009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"capetown", ",", "cairo"}], "}"}], "=", 
  RowBox[{"ToMinutes", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "33"}], ",", 
         RowBox[{"-", "56"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "22"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"30", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"31", ",", "15"}], "}"}]}], "}"}]}], "}"}], "]"}]}]], "Input",\

 CellLabel->"In[10]:=",
 CellID->11421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2036"}], ",", "1102"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1803", ",", "1875"}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->258122955]
}, Open  ]],

Cell[TextData[{
 "You can combine maps with ",
 Cell[BoxData[
  ButtonBox["WorldGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:WorldPlot/ref/WorldGraphics"]], "InlineFormula"],
 " objects using ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". The map of Africa given by ",
 StyleBox["afmap", "MR"],
 " was defined above. "
}], "MathCaption",
 CellID->768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"afmap", ",", 
    RowBox[{"WorldGraphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", 
        RowBox[{"{", 
         RowBox[{"0.05", ",", "0.03"}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"capetown", ",", "cairo"}], "}"}], "]"}]}], "}"}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->29746],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.7], 
    PolygonBox[{{3600, 3471.05309230731}, {3600, 3471.05309230731}, {
      3600, 3412.95823439019}, {3600, 3354.19801350288}, {
      3600, 3294.78388506685}, {3600, 3234.72743198416}, {
      3600, 3174.04036237936}, {3600, 3112.73450731688}, {
      3600, 3050.82181849466}, {3600, 2988.31436591406}, {
      3600, 2925.22433552679}, {3600, 2861.56402685931}, {
      3600, 2797.3458506149}, {3600, 2732.58232625428}, {
      3600, 2667.28607955485}, {3600, 2601.46984014926}, {
      3600, 2535.14643904381}, {3600, 2468.32880611695}, {
      3600, 2401.02996759861}, {3600, 2333.2630435307}, {
      3600, 2265.04124520936}, {3600, 2196.37787260932}, {
      3600, 2127.28631179114}, {3600, 2057.78003229148}, {
      3600, 1987.87258449726}, {3600, 1917.57759700394}, {
      3600, 1846.90877395861}, {3600, 1775.87989238835}, {
      3600, 1704.50479951435}, {3600, 1632.7974100524}, {
      3600, 1560.77170350015}, {3600, 1488.4417214118}, {
      3600, 1415.82156466067}, {3600, 1342.92539069022}, {
      3600, 1269.76741075399}, {3600, 1196.36188714512}, {
      3600, 1122.7231304159}, {3600, 1048.86549658785}, {
      3600, 974.803384353024}, {3600, 900.551232266952}, {
      3600, 826.123515933806}, {3600, 751.534745184353}, {
      3600, 676.799461247243}, {3600, 601.932233914158}, {
      3600, 526.947658699407}, {3600, 451.860353994504}, {
      3600, 376.684958218277}, {3600, 301.436126963085}, {
      3600, 226.128530137678}, {3600, 150.776849107272}, {
      3600, 75.3957738313845}, {3600, 0}, {3600, -75.3957738313845}, {
      3600, -150.776849107272}, {3600, -226.128530137678}, {
      3600, -301.436126963085}, {3600, -376.684958218277}, {
      3600, -451.860353994504}, {3600, -526.947658699407}, {
      3600, -601.932233914158}, {3600, -676.799461247243}, {
      3600, -751.534745184353}, {3600, -826.123515933806}, {
      3600, -900.551232266952}, {3600, -974.803384353024}, {
      3600, -1048.86549658785}, {3600, -1122.7231304159}, {
      3600, -1196.36188714512}, {3600, -1269.76741075399}, {
      3600, -1342.92539069022}, {3600, -1415.82156466067}, {
      3600, -1488.4417214118}, {3600, -1560.77170350015}, {
      3600, -1632.7974100524}, {3600, -1704.50479951435}, {
      3600, -1775.87989238835}, {3600, -1846.90877395861}, {
      3600, -1917.57759700394}, {3600, -1987.87258449726}, {
      3600, -2057.78003229148}, {3600, -2127.28631179114}, {
      3600, -2196.37787260932}, {3600, -2265.04124520936}, {
      3600, -2333.2630435307}, {3600, -2401.02996759861}, {
      3600, -2468.32880611695}, {3600, -2535.14643904381}, {
      3600, -2601.46984014926}, {3600, -2667.28607955485}, {
      3600, -2732.58232625428}, {3600, -2797.3458506149}, {
      3600, -2861.56402685931}, {3600, -2925.22433552679}, {
      3600, -2988.31436591406}, {3600, -3050.82181849466}, {
      3600, -3112.73450731688}, {3600, -3174.04036237936}, {
      3600, -3234.72743198416}, {3600, -3294.78388506685}, {
      3600, -3354.19801350288}, {3600, -3412.95823439019}, {
      3600, -3471.05309230731}, {3600, -3471.05309230731}, {
      3600, -3471.05309230731}, {3552, -3471.05309230731}, {
      3504, -3471.05309230731}, {3456, -3471.05309230731}, {
      3408, -3471.05309230731}, {3360, -3471.05309230731}, {
      3312, -3471.05309230731}, {3264, -3471.05309230731}, {
      3216, -3471.05309230731}, {3168, -3471.05309230731}, {
      3120, -3471.05309230731}, {3072, -3471.05309230731}, {
      3024, -3471.05309230731}, {2976, -3471.05309230731}, {
      2928, -3471.05309230731}, {2880, -3471.05309230731}, {
      2832, -3471.05309230731}, {2784, -3471.05309230731}, {
      2736, -3471.05309230731}, {2688, -3471.05309230731}, {
      2640, -3471.05309230731}, {2592, -3471.05309230731}, {
      2544, -3471.05309230731}, {2496, -3471.05309230731}, {
      2448, -3471.05309230731}, {2400, -3471.05309230731}, {
      2352, -3471.05309230731}, {2304, -3471.05309230731}, {
      2256, -3471.05309230731}, {2208, -3471.05309230731}, {
      2160, -3471.05309230731}, {2112, -3471.05309230731}, {
      2064, -3471.05309230731}, {2016, -3471.05309230731}, {
      1968, -3471.05309230731}, {1920, -3471.05309230731}, {
      1872, -3471.05309230731}, {1824, -3471.05309230731}, {
      1776, -3471.05309230731}, {1728, -3471.05309230731}, {
      1680, -3471.05309230731}, {1632, -3471.05309230731}, {
      1584, -3471.05309230731}, {1536, -3471.05309230731}, {
      1488, -3471.05309230731}, {1440, -3471.05309230731}, {
      1392, -3471.05309230731}, {1344, -3471.05309230731}, {
      1296, -3471.05309230731}, {1248, -3471.05309230731}, {
      1200, -3471.05309230731}, {1152, -3471.05309230731}, {
      1104, -3471.05309230731}, {1056, -3471.05309230731}, {
      1008, -3471.05309230731}, {960, -3471.05309230731}, {
      912, -3471.05309230731}, {864, -3471.05309230731}, {
      816, -3471.05309230731}, {768, -3471.05309230731}, {
      720, -3471.05309230731}, {672, -3471.05309230731}, {
      624, -3471.05309230731}, {576, -3471.05309230731}, {
      528, -3471.05309230731}, {480, -3471.05309230731}, {
      432, -3471.05309230731}, {384, -3471.05309230731}, {
      336, -3471.05309230731}, {288, -3471.05309230731}, {
      240, -3471.05309230731}, {192, -3471.05309230731}, {
      144, -3471.05309230731}, {96, -3471.05309230731}, {
      48, -3471.05309230731}, {
      0, -3471.05309230731}, {-48, -3471.05309230731}, {-96, \
-3471.05309230731}, {-144, -3471.05309230731}, {-192, -3471.05309230731}, \
{-240, -3471.05309230731}, {-288, -3471.05309230731}, {-336, \
-3471.05309230731}, {-384, -3471.05309230731}, {-432, -3471.05309230731}, \
{-480, -3471.05309230731}, {-528, -3471.05309230731}, {-576, \
-3471.05309230731}, {-624, -3471.05309230731}, {-672, -3471.05309230731}, \
{-720, -3471.05309230731}, {-768, -3471.05309230731}, {-816, \
-3471.05309230731}, {-864, -3471.05309230731}, {-912, -3471.05309230731}, \
{-960, -3471.05309230731}, {-1008, -3471.05309230731}, {-1056, \
-3471.05309230731}, {-1104, -3471.05309230731}, {-1152, -3471.05309230731}, \
{-1200, -3471.05309230731}, {-1200, -3471.05309230731}, {-1200, \
-3412.95823439019}, {-1200, -3354.19801350288}, {-1200, -3294.78388506685}, \
{-1200, -3234.72743198416}, {-1200, -3174.04036237936}, {-1200, \
-3112.73450731688}, {-1200, -3050.82181849466}, {-1200, -2988.31436591406}, \
{-1200, -2925.22433552679}, {-1200, -2861.56402685931}, {-1200, \
-2797.3458506149}, {-1200, -2732.58232625428}, {-1200, -2667.28607955485}, \
{-1200, -2601.46984014926}, {-1200, -2535.14643904381}, {-1200, \
-2468.32880611695}, {-1200, -2401.02996759861}, {-1200, -2333.2630435307}, \
{-1200, -2265.04124520936}, {-1200, -2196.37787260932}, {-1200, \
-2127.28631179114}, {-1200, -2057.78003229148}, {-1200, -1987.87258449726}, \
{-1200, -1917.57759700394}, {-1200, -1846.90877395861}, {-1200, \
-1775.87989238835}, {-1200, -1704.50479951435}, {-1200, -1632.7974100524}, \
{-1200, -1560.77170350015}, {-1200, -1488.4417214118}, {-1200, \
-1415.82156466067}, {-1200, -1342.92539069022}, {-1200, -1269.76741075399}, \
{-1200, -1196.36188714512}, {-1200, -1122.7231304159}, {-1200, \
-1048.86549658785}, {-1200, -974.803384353024}, {-1200, -900.551232266952}, \
{-1200, -826.123515933806}, {-1200, -751.534745184353}, {-1200, \
-676.799461247243}, {-1200, -601.932233914158}, {-1200, -526.947658699407}, \
{-1200, -451.860353994504}, {-1200, -376.684958218277}, {-1200, \
-301.436126963085}, {-1200, -226.128530137678}, {-1200, -150.776849107272}, \
{-1200, -75.3957738313845}, {-1200, 
      0}, {-1200, 75.3957738313845}, {-1200, 150.776849107272}, {-1200, 
       226.128530137678}, {-1200, 301.436126963085}, {-1200, 
       376.684958218277}, {-1200, 451.860353994504}, {-1200, 
       526.947658699407}, {-1200, 601.932233914158}, {-1200, 
       676.799461247243}, {-1200, 751.534745184353}, {-1200, 
       826.123515933806}, {-1200, 900.551232266952}, {-1200, 
       974.803384353024}, {-1200, 1048.86549658785}, {-1200, 
       1122.7231304159}, {-1200, 1196.36188714512}, {-1200, 
       1269.76741075399}, {-1200, 1342.92539069022}, {-1200, 
       1415.82156466067}, {-1200, 1488.4417214118}, {-1200, 
       1560.77170350015}, {-1200, 1632.7974100524}, {-1200, 
       1704.50479951435}, {-1200, 1775.87989238835}, {-1200, 
       1846.90877395861}, {-1200, 1917.57759700394}, {-1200, 
       1987.87258449726}, {-1200, 2057.78003229148}, {-1200, 
       2127.28631179114}, {-1200, 2196.37787260932}, {-1200, 
       2265.04124520936}, {-1200, 2333.2630435307}, {-1200, 
       2401.02996759861}, {-1200, 2468.32880611695}, {-1200, 
       2535.14643904381}, {-1200, 2601.46984014926}, {-1200, 
       2667.28607955485}, {-1200, 2732.58232625428}, {-1200, 
       2797.3458506149}, {-1200, 2861.56402685931}, {-1200, 
       2925.22433552679}, {-1200, 2988.31436591406}, {-1200, 
       3050.82181849466}, {-1200, 3112.73450731688}, {-1200, 
       3174.04036237936}, {-1200, 3234.72743198416}, {-1200, 
       3294.78388506685}, {-1200, 3354.19801350288}, {-1200, 
       3412.95823439019}, {-1200, 3471.05309230731}, {-1200, 
       3471.05309230731}, {-1200, 3471.05309230731}, {-1152, 
       3471.05309230731}, {-1104, 3471.05309230731}, {-1056, 
       3471.05309230731}, {-1008, 3471.05309230731}, {-960, 
       3471.05309230731}, {-912, 3471.05309230731}, {-864, 
       3471.05309230731}, {-816, 3471.05309230731}, {-768, 
       3471.05309230731}, {-720, 3471.05309230731}, {-672, 
       3471.05309230731}, {-624, 3471.05309230731}, {-576, 
       3471.05309230731}, {-528, 3471.05309230731}, {-480, 
       3471.05309230731}, {-432, 3471.05309230731}, {-384, 
       3471.05309230731}, {-336, 3471.05309230731}, {-288, 
       3471.05309230731}, {-240, 3471.05309230731}, {-192, 
       3471.05309230731}, {-144, 3471.05309230731}, {-96, 
       3471.05309230731}, {-48, 3471.05309230731}, {0, 3471.05309230731}, {
      48, 3471.05309230731}, {96, 3471.05309230731}, {
      144, 3471.05309230731}, {192, 3471.05309230731}, {
      240, 3471.05309230731}, {288, 3471.05309230731}, {
      336, 3471.05309230731}, {384, 3471.05309230731}, {
      432, 3471.05309230731}, {480, 3471.05309230731}, {
      528, 3471.05309230731}, {576, 3471.05309230731}, {
      624, 3471.05309230731}, {672, 3471.05309230731}, {
      720, 3471.05309230731}, {768, 3471.05309230731}, {
      816, 3471.05309230731}, {864, 3471.05309230731}, {
      912, 3471.05309230731}, {960, 3471.05309230731}, {
      1008, 3471.05309230731}, {1056, 3471.05309230731}, {
      1104, 3471.05309230731}, {1152, 3471.05309230731}, {
      1200, 3471.05309230731}, {1248, 3471.05309230731}, {
      1296, 3471.05309230731}, {1344, 3471.05309230731}, {
      1392, 3471.05309230731}, {1440, 3471.05309230731}, {
      1488, 3471.05309230731}, {1536, 3471.05309230731}, {
      1584, 3471.05309230731}, {1632, 3471.05309230731}, {
      1680, 3471.05309230731}, {1728, 3471.05309230731}, {
      1776, 3471.05309230731}, {1824, 3471.05309230731}, {
      1872, 3471.05309230731}, {1920, 3471.05309230731}, {
      1968, 3471.05309230731}, {2016, 3471.05309230731}, {
      2064, 3471.05309230731}, {2112, 3471.05309230731}, {
      2160, 3471.05309230731}, {2208, 3471.05309230731}, {
      2256, 3471.05309230731}, {2304, 3471.05309230731}, {
      2352, 3471.05309230731}, {2400, 3471.05309230731}, {
      2448, 3471.05309230731}, {2496, 3471.05309230731}, {
      2544, 3471.05309230731}, {2592, 3471.05309230731}, {
      2640, 3471.05309230731}, {2688, 3471.05309230731}, {
      2736, 3471.05309230731}, {2784, 3471.05309230731}, {
      2832, 3471.05309230731}, {2880, 3471.05309230731}, {
      2928, 3471.05309230731}, {2976, 3471.05309230731}, {
      3024, 3471.05309230731}, {3072, 3471.05309230731}, {
      3120, 3471.05309230731}, {3168, 3471.05309230731}, {
      3216, 3471.05309230731}, {3264, 3471.05309230731}, {
      3312, 3471.05309230731}, {3360, 3471.05309230731}, {
      3408, 3471.05309230731}, {3456, 3471.05309230731}, {
      3504, 3471.05309230731}, {3552, 3471.05309230731}, {
      3600, 3471.05309230731}, {3600, 3471.05309230731}}]}, {{
     {GrayLevel[1], 
      TooltipBox[
       PolygonBox[{{517, 3244.78095137098}, {
         0, 3161.31894235768}, {-133, 3103.74308311347}, {-71, 
          2869.55232939765}, {-229, 2837.54691579025}, {-218, 
          2778.51226350272}, {-520, 2594.58459443247}, {-520, 
          2507.36507616271}, {-520, 2475.31165276552}, {-288, 
          2282.13861339978}, {0, 2008.30289668409}, {255, 1771.42894794786}, {
         720, 2154.68539567287}, {564, 2379.90246734831}, {
         572, 2719.0224513327}, {450, 3010.51968083594}, {
         517, 3244.78095137098}}],
       "\"Algeria\""], 
      TooltipBox[
       PolygonBox[{{791, -551.954653827464}, {735, -573.825985215659}, {
         828, -1104.27867994567}, {706, -1601.32450486808}, {
         831, -1608.8235176078}, {1409, -1635.79167036149}, {
         1320, -1503.53486623716}, {1320, -1214.73569345687}, {
         1441, -1214.73569345687}, {1439, -1018.03030523621}, {
         1330, -1018.03030523621}, {1307, -684.590793292707}, {
         1080, -760.866652462946}, {1019, -681.474433333481}, {
         991, -553.51719965749}, {791, -550.39206129327}}],
       "\"Angola\""], 
      TooltipBox[
       PolygonBox[{{98, 584.758104799124}, {164, 598.810118229931}, {
         214, 1099.66545615696}, {144, 1111.9655157339}, {
         58, 1030.36857503334}, {98, 584.758104799124}}],
       "\"Benin\""], 
      TooltipBox[
       PolygonBox[{{1516, -1650.75464680077}, {1260, -1697.05054452012}, {
         1200, -2022.87560444592}, {1200, -2262.18899499536}, {
         1239, -2437.54244857924}, {1368, -2337.51194021024}, {
         1531, -2338.9278436816}, {1763, -2040.34024881972}, {
         1516, -1650.75464680077}}],
       "\"Botswana\""], 
      TooltipBox[
       PolygonBox[{{-161, 889.707780162161}, {-331, 977.89320011788}, {-238, 
          1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
         144, 1113.5026011418}, {
         58, 1030.36857503334}, {-10, 1042.70126495359}, {-170, 
          1030.36857503334}, {-161, 889.707780162161}}],
       "\"Burkina Faso\""], 
      TooltipBox[
       PolygonBox[{{1741, -259.081894015257}, {1765, -418.981093943756}, {
         1834, -226.128530137678}, {1741, -259.081894015257}}],
       "\"Burundi\""], 
      TooltipBox[
       PolygonBox[{{589, 221.420189217303}, {585, 389.219686517686}, {
         516, 453.425622178119}, {588, 639.381428855105}, {
         713, 665.889194819279}, {879, 1082.74316419852}, {
         844, 1222.38709052735}, {941, 936.153187350014}, {
         837, 903.648677596752}, {930, 707.956034423855}, {
         865, 569.140060142951}, {972, 208.863798798875}, {
         798, 204.154857131711}, {680, 204.154857131711}, {
         589, 221.420189217303}}],
       "\"Cameroon\""], 
      TooltipBox[
       PolygonBox[{{930, 707.956034423855}, {1115, 754.645636715053}, {
         1366, 1025.7423741631}, {1373, 1022.6578060613}, {
         1411, 818.361117322034}, {1647, 472.205809875953}, {
         1340, 389.219686517686}, {1152, 467.511293421359}, {
         1118, 328.094233087995}, {995, 328.094233087995}, {
         972, 208.863798798875}, {865, 569.140060142951}, {
         930, 707.956034423855}}],
       "\"CAR\""], 
      TooltipBox[
       PolygonBox[{{1440, 1802.55703986236}, {960, 2153.24497219633}, {
         900, 2109.94809384208}, {960, 1877.87150205711}, {
         929, 1569.79184543056}, {818, 1280.45204041304}, {
         844, 1222.38709052735}, {941, 936.153187350014}, {
         837, 903.648677596752}, {930, 707.956034423855}, {
         1115, 754.645636715053}, {1366, 1025.7423741631}, {
         1310, 1196.36188714512}, {1376, 1447.62768228824}, {
         1440, 1461.24240826966}, {1440, 1802.55703986236}}],
       "\"Chad\""], 
      TooltipBox[
       PolygonBox[{{670, -371.983905546271}, {722, -472.205809875953}, {
         785, -436.205591111035}, {954, -368.849712831753}, {
         1118, 328.094233087995}, {995, 328.094233087995}, {
         972, 208.863798798875}, {798, 204.154857131711}, {
         790, 116.229951705076}, {870, 87.9607040355678}, {
         867, -179.037963298042}, {695, -219.850704595417}, {
         670, -371.983905546271}}],
       "\"Congo\""], 
      TooltipBox[
       PolygonBox[{{791, -551.954653827464}, {732, -544.141226759291}, {
         786, -436.205591111035}, {954, -368.849712831753}, {
         1118, 328.094233087995}, {1152, 467.511293421359}, {
         1340, 389.219686517686}, {1647, 472.205809875953}, {
         1852, 328.094233087995}, {1878, 199.445759991742}, {
         1776, -130.363429036583}, {1742, -257.512895699638}, {
         1765, -418.981093943756}, {1846, -768.641472578387}, {
         1702, -869.56018778221}, {1702, -1081.20422171256}, {
         1788, -1136.54750303505}, {1788, -1256.02230010298}, {
         1632, -1082.74316419852}, {1439, -1018.03030523621}, {
         1330, -1018.03030523621}, {1307, -684.590793292707}, {
         1080, -760.866652462946}, {1019, -681.474433333481}, {
         991, -553.51719965749}, {791, -551.954653827464}}],
       "\"Democratic Republic of the Congo\""], 
      TooltipBox[
       PolygonBox[{{2597, 1078.1260624095}, {2551, 1079.66518773948}, {
         2587, 1188.70181933527}, {2506, 1078.1260624095}, {
         2577, 1030.36857503334}, {2597, 1078.1260624095}}],
       "\"Djibouti\""], 
      TooltipBox[
       PolygonBox[{{2137, 2121.50977541667}, {1940, 2667.28607955485}, {
         2055, 2512.9281680693}, {2098, 2663.18766612341}, {
         2094, 2657.71996054722}, {2056, 2798.68933528385}, {
         2053, 2808.08709081776}, {1509, 2833.53648294498}, {
         1500, 2022.87560444592}, {2036, 2001.01016255312}, {
         2137, 2121.50977541667}}],
       "\"Egypt\""], 
      TooltipBox[
       PolygonBox[{{588, 94.242994761331}, {589, 221.420189217303}, {
         680, 204.154857131711}, {681, 94.242994761331}, {
         588, 94.242994761331}}],
       "\"Equatorial Guinea\""], 
      TooltipBox[
       PolygonBox[{{2188, 1339.88226985267}, {2220, 1584.81477540078}, {
         2317, 1671.67931922504}, {2383, 1405.20772631382}, {
         2587, 1188.70181933527}, {2560, 1151.89877679309}, {
         2330, 1364.21445200797}, {2188, 1339.88226985267}}],
       "\"Eritrea\""], 
      TooltipBox[
       PolygonBox[{{2188, 1339.88226985267}, {2330, 1364.21445200797}, {
         2560, 1151.89877679309}, {2506, 1078.1260624095}, {
         2577, 1030.36857503334}, {2641, 844.746111217247}, {
         2879, 751.534745184353}, {2697, 461.251384941784}, {
         2514, 375.117972357707}, {2371, 323.39042584595}, {
         2156, 434.639909632171}, {1979, 745.31220007407}, {
         2057, 988.704941954054}, {2169, 1187.16950350532}, {
         2188, 1339.88226985267}}],
       "\"Ethiopia\""], 
      TooltipBox[
       PolygonBox[{{588, 94.242994761331}, {523, -59.6890448789258}, {
         670, -371.983905546271}, {695, -219.850704595417}, {
         867, -179.037963298042}, {870, 87.9607040355678}, {
         790, 116.229951705076}, {798, 204.154857131711}, {
         680, 204.154857131711}, {681, 94.242994761331}, {
         588, 94.242994761331}}],
       "\"Gabon\""], 
      TooltipBox[
       PolygonBox[{{-186, 478.464605144901}, {0, 528.510935927489}, {
         72, 573.825985215659}, {
         0, 993.337293308689}, {-5, 1002.59972308212}, {
         0, 1039.6186192399}, {-9, 1042.70126495359}, {-170, 
          1030.36857503334}, {-161, 889.707780162161}, {-186, 
          478.464605144901}}],
       "\"Ghana\""], 
      TooltipBox[
       PolygonBox[{{-798, 847.848882519074}, {-901, 1025.7423741631}, {-823, 
          1185.6370872219}, {-681, 1165.70659328125}, {-682, 
          1159.57076670214}, {-539, 1159.57076670214}, {-479, 
          951.619321660995}, {-478, 953.165494379191}, {-508, 
          711.070391241948}, {-616, 796.617243867505}, {-673, 
          937.700159401424}, {-798, 847.848882519074}}],
       "\"Guinea\""], 
      TooltipBox[
       PolygonBox[{{-1003, 1151.89877679309}, {-900, 1119.64999927209}, {-930,
           1061.18969147728}, {-901, 1025.7423741631}, {-823, 
          1185.6370872219}, {-1003, 1151.89877679309}}],
       "\"Guinea-Bissau\""], 
      TooltipBox[
       PolygonBox[{{-452, 409.584094331548}, {-186, 478.464605144901}, {-186, 
          478.464605144901}, {-161, 889.707780162161}, {-161, 
          889.707780162161}, {-331, 979.437983947626}, {-331, 
          977.89320011788}, {-478, 953.165494379191}, {-478, 
          953.165494379191}, {-508, 711.070391241948}, {-508, 
          711.070391241948}, {-451, 409.584094331548}}],
       "\"Cote d'Ivoire\""], 
      TooltipBox[
       PolygonBox[{{2494, -157.057481212802}, {2352, -439.336843206435}, {
         2035, -94.242994761331}, {2102, 180.607888429184}, {
         2040, 397.052825652379}, {2156, 434.639909632171}, {
         2371, 323.39042584595}, {2515, 375.117972357707}, {
         2459, 266.926554101265}, {2494, -157.057481212802}}],
       "\"Kenya\""], 
      TooltipBox[
       PolygonBox[{{-690, 651.857658916043}, {-452, 409.584094331548}, {-508, 
          711.070391241948}, {-616, 796.617243867505}, {-690, 
          651.857658916043}}],
       "\"Liberia\""], 
      TooltipBox[
       PolygonBox[{{692, 2954.21213399624}, {955, 2806.74526623126}, {
         1160, 2723.09283479484}, {1303, 2937.09752777115}, {
         1509, 2833.53648294498}, {1500, 2022.87560444592}, {
         1500, 2022.87560444592}, {1500, 1846.90877395861}, {
         1440, 1802.55703986236}, {960, 2153.24497219633}, {
         898, 2108.50207895224}, {720, 2154.68539567287}, {
         564, 2379.90246734831}, {572, 2719.0224513327}, {
         692, 2954.21213399624}}],
       "\"Libya\""], 
      TooltipBox[
       PolygonBox[{{2599, -2011.2188016591}, {2671, -1842.47987411883}, {
         2668, -1505.04348309984}, {2880, -1376.36949432997}, {
         2957, -1118.11329152481}, {3030, -1426.4295327563}, {
         2978, -1447.62768228824}, {2828, -2280.71489192437}, {
         2644, -2277.86687013947}, {2599, -2011.2188016591}}],
       "\"Madagascar\""], 
      TooltipBox[
       PolygonBox[{{1979, -889.707780162161}, {2060, -912.93917427904}, {
         2097, -1082.74316419852}, {2074, -1246.85410460893}, {
         2155, -1386.99904431572}, {2117, -1590.82019968929}, {
         2072, -1359.65440293531}, {1993, -1307.90231790923}, {
         1979, -889.707780162161}}],
       "\"Malawi\""], 
      TooltipBox[
       PolygonBox[{{255, 1771.42894794786}, {
         0, 2008.30289668409}, {-288, 2282.13861339978}, {-395, 
          2282.13861339978}, {-330, 1443.08723082259}, {-690, 
          1456.70527446827}, {-723, 1373.33142995544}, {-735, 
          1376.36949432997}, {-681, 1165.70659328125}, {-682, 
          1159.57076670214}, {-539, 1159.57076670214}, {-478, 
          953.165494379191}, {-331, 977.89320011788}, {-238, 
          1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
         233, 1462.75453908525}, {255, 1771.42894794786}}],
       "\"Mali\""], 
      TooltipBox[
       PolygonBox[{{-1023, 1914.64043117697}, {-972, 1866.08437707629}, {-992,
           1492.9709931035}, {-803, 1491.46136203177}, {-723, 
          1371.81222339529}, {-690, 1456.70527446827}, {-330, 
          1443.08723082259}, {-395, 2282.13861339978}, {-288, 
          2282.13861339978}, {-520, 2476.7075942153}, {-520, 
          2367.20419266102}, {-720, 2367.20419266102}, {-786, 
          2101.26933075711}, {-780, 1964.48330674702}, {-1023, 
          1914.64043117697}}],
       "\"Mauritania\""], 
      TooltipBox[
       PolygonBox[{{-132, 3105.0283610337}, {-325, 3167.68300282426}, {-374, 
          3098.59934625873}, {-557, 2905.39116834584}, {-614, 
          2644.03497082848}, {-791, 2507.36507616271}, {-520, 
          2507.36507616271}, {-520, 2594.58459443247}, {-218, 
          2778.51226350272}, {-229, 2837.54691579025}, {-71, 
          2869.55232939765}, {-132, 3105.0283610337}}],
       "\"Morocco\""], 
      TooltipBox[
       PolygonBox[{{2426, -982.527302848187}, {2440, -1423.39928629924}, {
         2074, -1812.91818037868}, {2130, -2204.98448605948}, {
         1969, -2333.2630435307}, {1974, -2438.94400368425}, {
         1928, -2437.54244857924}, {1918, -2362.9678246747}, {
         1878, -2059.23221872404}, {1982, -1849.8605926703}, {
         1979, -1553.25128557259}, {1825, -1455.19264984283}, {
         1993, -1307.90231790923}, {2072, -1359.65440293531}, {
         2117, -1590.82019968929}, {2155, -1386.99904431572}, {
         2074, -1246.85410460893}, {2097, -1082.74316419852}, {
         2426, -982.527302848187}}],
       "\"Mozambique\""], 
      TooltipBox[
       PolygonBox[{{706, -1601.32450486808}, {872, -2082.44342096423}, {
         867, -2121.50977541667}, {989, -2583.55679110253}, {
         1200, -2571.13379166761}, {1200, -2262.18899499536}, {
         1200, -2022.87560444592}, {1260, -1697.05054452012}, {
         1516, -1650.75464680077}, {1409, -1635.79167036149}, {
         831, -1608.8235176078}, {706, -1601.32450486808}}],
       "\"Namibia\""], 
      TooltipBox[
       PolygonBox[{{898, 2108.50207895224}, {719, 2154.68539567287}, {
         255, 1771.42894794786}, {233, 1462.75453908525}, {
         14, 1397.62284355361}, {144, 1113.5026011418}, {
         214, 1099.66545615696}, {216, 1095.05139492517}, {
         293, 1286.55516229006}, {578, 1196.36188714512}, {
         818, 1280.45204041304}, {929, 1569.79184543056}, {
         960, 1877.87150205711}, {898, 2108.50207895224}}],
       "\"Niger\""], 
      TooltipBox[
       PolygonBox[{{515, 451.860353994504}, {366, 401.752307029661}, {
         317, 555.079698651133}, {163, 598.810118229931}, {
         214, 1099.66545615696}, {216, 1095.05139492517}, {
         293, 1286.55516229006}, {578, 1196.36188714512}, {
         818, 1280.45204041304}, {845, 1220.85701746224}, {
         879, 1082.74316419852}, {713, 665.889194819279}, {
         588, 639.381428855105}, {515, 451.860353994504}}],
       "\"Nigeria\""], 
      TooltipBox[
       PolygonBox[{{989, -2583.55679110253}, {1099, -3032.65137663086}, {
         1200, -3083.14299325223}, {1674, -2943.68505250796}, {
         1974, -2438.94400368425}, {1928, -2437.54244857924}, {
         1849, -2434.73871972293}, {1918, -2364.38014744091}, {
         1878, -2059.23221872404}, {1762, -2038.88580840386}, {
         1531, -2338.9278436816}, {1368, -2337.51194021024}, {
         1239, -2437.54244857924}, {1200, -2262.18899499536}, {
         1200, -2571.13379166761}, {989, -2583.55679110253}}],
       "\"South Africa\""], 
      TooltipBox[
       PolygonBox[{{1722, -2586.31505592921}, {1621, -2670.01722689374}, {
         1686, -2754.22998473465}, {1767, -2646.77376229944}, {
         1722, -2586.31505592921}}],
       "\"Lesotho\""], 
      TooltipBox[
       PolygonBox[{{1776, -130.363429036583}, {1741, -259.081894015257}, {
         1834, -226.128530137678}, {1829, -100.52515789574}, {
         1776, -130.363429036583}}],
       "\"Rwanda\""], 
      TooltipBox[
       PolygonBox[{{-992, 1494.48049784607}, {-1052, 1374.85052030985}, {-994,
           1268.24060428473}, {-828, 1249.91059316788}, {-1005, 
          1220.85701746224}, {-923, 1199.42520655736}, {-1003, 
          1151.89877679309}, {-823, 1185.6370872219}, {-681, 
          1165.70659328125}, {-735, 1376.36949432997}, {-723, 
          1371.81222339529}, {-803, 1491.46136203177}, {-992, 
          1492.9709931035}}],
       "\"Senegal\""], 
      TooltipBox[
       PolygonBox[{{-798, 847.848882519074}, {-689, 651.857658916043}, {-615, 
          796.617243867505}, {-673, 937.700159401424}, {-798, 
          847.848882519074}}],
       "\"Sierra Leone\""], 
      TooltipBox[
       PolygonBox[{{2493, -157.057481212802}, {2877, 420.547137235123}, {
         3085, 979.437983947626}, {3047, 1122.7231304159}, {
         2695, 976.348333542772}, {2597, 1078.1260624095}, {
         2595, 1075.04753819981}, {2577, 1030.36857503334}, {
         2641, 844.746111217247}, {2879, 751.534745184353}, {
         2697, 461.251384941784}, {2514, 375.117972357707}, {
         2459, 266.926554101265}, {2493, -157.057481212802}}],
       "\"Somalia\""], 
      TooltipBox[
       PolygonBox[{{2317, 1671.67931922504}, {2214, 2025.78809593257}, {
         2137, 2121.50977541667}, {2036, 2001.01016255312}, {
         1500, 2022.87560444592}, {1500, 1846.90877395861}, {
         1440, 1802.55703986236}, {1440, 1461.24240826966}, {
         1376, 1447.62768228824}, {1310, 1196.36188714512}, {
         1366, 1025.7423741631}, {1373, 1022.6578060613}, {
         1411, 818.361117322034}, {1647, 472.205809875953}, {
         1852, 328.094233087995}, {2040, 397.052825652379}, {
         2156, 434.639909632171}, {1979, 745.31220007407}, {
         2057, 988.704941954054}, {2169, 1187.16950350532}, {
         2220, 1584.81477540078}, {2317, 1671.67931922504}}],
       "\"Sudan\""], 
      TooltipBox[
       PolygonBox[{{1928, -2437.54244857924}, {1918, -2362.9678246747}, {
         1849, -2434.73871972293}, {1928, -2437.54244857924}}],
       "\"Swaziland\""], 
      TooltipBox[
       PolygonBox[{{2426, -982.527302848187}, {2327, -569.140060142951}, {
         2352, -439.336843206435}, {2035, -94.242994761331}, {
         1829, -100.52515789574}, {1834, -226.128530137678}, {
         1765, -418.981093943756}, {1846, -768.641472578387}, {
         1979, -883.509862696526}, {2060, -912.93917427904}, {
         2098, -1082.74316419852}, {2426, -982.527302848187}}],
       "\"Tanzania\""], 
      TooltipBox[
       PolygonBox[{{-994, 1268.24060428473}, {-918, 1256.02230010298}, {-1005,
           1217.79656154958}, {-1005, 1220.85701746224}, {-828, 
          1249.91059316788}, {-994, 1268.24060428473}}],
       "\"The Gambia\""], 
      TooltipBox[
       PolygonBox[{{72, 573.825985215659}, {99, 584.758104799124}, {
         55, 1030.36857503334}, {-10, 1042.70126495359}, {
         0, 1039.6186192399}, {-5, 1002.59972308212}, {0, 993.337293308689}, {
         72, 573.825985215659}}],
       "\"Togo\""], 
      TooltipBox[
       PolygonBox[{{517, 3244.78095137098}, {663, 3256.07015412574}, {
         600, 3032.65137663086}, {692, 2954.21213399624}, {
         572, 2719.0224513327}, {450, 3010.51968083594}, {
         517, 3244.78095137098}}],
       "\"Tunisia\""], 
      TooltipBox[
       PolygonBox[{{1852, 328.094233087995}, {1878, 199.445759991742}, {
         1776, -130.363429036583}, {1829, -100.52515789574}, {
         2035, -94.242994761331}, {2102, 180.607888429184}, {
         2040, 397.052825652379}, {1852, 328.094233087995}}],
       "\"Uganda\""], 
      TooltipBox[
       PolygonBox[{{-791, 2507.36507616271}, {-1023, 1914.64043117697}, {-780,
           1964.48330674702}, {-786, 2101.26933075711}, {-720, 
          2367.20419266102}, {-520, 2367.20419266102}, {-520, 
          2476.7075942153}, {-520, 2507.36507616271}, {-791, 
          2507.36507616271}}],
       "\"Western Sahara\""], 
      TooltipBox[
       PolygonBox[{{1846, -768.641472578387}, {1702, -869.56018778221}, {
         1702, -1081.20422171256}, {1788, -1136.54750303505}, {
         1788, -1256.02230010298}, {1632, -1082.74316419852}, {
         1439, -1018.03030523621}, {1441, -1214.73569345687}, {
         1320, -1214.73569345687}, {1320, -1503.53486623716}, {
         1409, -1635.79167036149}, {1516, -1650.75464680077}, {
         1629, -1650.75464680077}, {1825, -1455.19264984283}, {
         1993, -1307.90231790923}, {1979, -889.707780162161}, {
         1979, -883.509862696526}, {1846, -770.196242009763}}],
       "\"Zambia\""], 
      TooltipBox[
       PolygonBox[{{1878, -2059.23221872404}, {1762, -2038.88580840386}, {
         1516, -1650.75464680077}, {1629, -1650.75464680077}, {
         1825, -1455.19264984283}, {1979, -1553.25128557259}, {
         1982, -1849.8605926703}, {1878, -2059.23221872404}}],
       "\"Zimbabwe\""]}, 
     {GrayLevel[0], Thickness[0.001], 
      LineBox[{{517, 3244.78095137098}, {
        0, 3161.31894235768}, {-133, 3103.74308311347}, {-71, 
         2869.55232939765}, {-229, 2837.54691579025}, {-218, 
         2778.51226350272}, {-520, 2594.58459443247}, {-520, 
         2507.36507616271}, {-520, 2475.31165276552}, {-288, 
         2282.13861339978}, {0, 2008.30289668409}, {255, 1771.42894794786}, {
        720, 2154.68539567287}, {564, 2379.90246734831}, {
        572, 2719.0224513327}, {450, 3010.51968083594}, {
        517, 3244.78095137098}}], 
      LineBox[{{791, -551.954653827464}, {735, -573.825985215659}, {
        828, -1104.27867994567}, {706, -1601.32450486808}, {
        831, -1608.8235176078}, {1409, -1635.79167036149}, {
        1320, -1503.53486623716}, {1320, -1214.73569345687}, {
        1441, -1214.73569345687}, {1439, -1018.03030523621}, {
        1330, -1018.03030523621}, {1307, -684.590793292707}, {
        1080, -760.866652462946}, {1019, -681.474433333481}, {
        991, -553.51719965749}, {791, -550.39206129327}}], 
      LineBox[{{98, 584.758104799124}, {164, 598.810118229931}, {
        214, 1099.66545615696}, {144, 1111.9655157339}, {
        58, 1030.36857503334}, {98, 584.758104799124}}], 
      LineBox[{{1516, -1650.75464680077}, {1260, -1697.05054452012}, {
        1200, -2022.87560444592}, {1200, -2262.18899499536}, {
        1239, -2437.54244857924}, {1368, -2337.51194021024}, {
        1531, -2338.9278436816}, {1763, -2040.34024881972}, {
        1516, -1650.75464680077}}], 
      LineBox[{{-161, 889.707780162161}, {-331, 977.89320011788}, {-238, 
         1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
        144, 1113.5026011418}, {
        58, 1030.36857503334}, {-10, 1042.70126495359}, {-170, 
         1030.36857503334}, {-161, 889.707780162161}}], 
      LineBox[{{1741, -259.081894015257}, {1765, -418.981093943756}, {
        1834, -226.128530137678}, {1741, -259.081894015257}}], 
      LineBox[{{589, 221.420189217303}, {585, 389.219686517686}, {
        516, 453.425622178119}, {588, 639.381428855105}, {
        713, 665.889194819279}, {879, 1082.74316419852}, {
        844, 1222.38709052735}, {941, 936.153187350014}, {
        837, 903.648677596752}, {930, 707.956034423855}, {
        865, 569.140060142951}, {972, 208.863798798875}, {
        798, 204.154857131711}, {680, 204.154857131711}, {
        589, 221.420189217303}}], 
      LineBox[{{930, 707.956034423855}, {1115, 754.645636715053}, {
        1366, 1025.7423741631}, {1373, 1022.6578060613}, {
        1411, 818.361117322034}, {1647, 472.205809875953}, {
        1340, 389.219686517686}, {1152, 467.511293421359}, {
        1118, 328.094233087995}, {995, 328.094233087995}, {
        972, 208.863798798875}, {865, 569.140060142951}, {
        930, 707.956034423855}}], 
      LineBox[{{1440, 1802.55703986236}, {960, 2153.24497219633}, {
        900, 2109.94809384208}, {960, 1877.87150205711}, {
        929, 1569.79184543056}, {818, 1280.45204041304}, {
        844, 1222.38709052735}, {941, 936.153187350014}, {
        837, 903.648677596752}, {930, 707.956034423855}, {
        1115, 754.645636715053}, {1366, 1025.7423741631}, {
        1310, 1196.36188714512}, {1376, 1447.62768228824}, {
        1440, 1461.24240826966}, {1440, 1802.55703986236}}], 
      LineBox[{{670, -371.983905546271}, {722, -472.205809875953}, {
        785, -436.205591111035}, {954, -368.849712831753}, {
        1118, 328.094233087995}, {995, 328.094233087995}, {
        972, 208.863798798875}, {798, 204.154857131711}, {
        790, 116.229951705076}, {870, 87.9607040355678}, {
        867, -179.037963298042}, {695, -219.850704595417}, {
        670, -371.983905546271}}], 
      LineBox[{{791, -551.954653827464}, {732, -544.141226759291}, {
        786, -436.205591111035}, {954, -368.849712831753}, {
        1118, 328.094233087995}, {1152, 467.511293421359}, {
        1340, 389.219686517686}, {1647, 472.205809875953}, {
        1852, 328.094233087995}, {1878, 199.445759991742}, {
        1776, -130.363429036583}, {1742, -257.512895699638}, {
        1765, -418.981093943756}, {1846, -768.641472578387}, {
        1702, -869.56018778221}, {1702, -1081.20422171256}, {
        1788, -1136.54750303505}, {1788, -1256.02230010298}, {
        1632, -1082.74316419852}, {1439, -1018.03030523621}, {
        1330, -1018.03030523621}, {1307, -684.590793292707}, {
        1080, -760.866652462946}, {1019, -681.474433333481}, {
        991, -553.51719965749}, {791, -551.954653827464}}], 
      LineBox[{{2597, 1078.1260624095}, {2551, 1079.66518773948}, {
        2587, 1188.70181933527}, {2506, 1078.1260624095}, {
        2577, 1030.36857503334}, {2597, 1078.1260624095}}], 
      LineBox[{{2137, 2121.50977541667}, {1940, 2667.28607955485}, {
        2055, 2512.9281680693}, {2098, 2663.18766612341}, {
        2094, 2657.71996054722}, {2056, 2798.68933528385}, {
        2053, 2808.08709081776}, {1509, 2833.53648294498}, {
        1500, 2022.87560444592}, {2036, 2001.01016255312}, {
        2137, 2121.50977541667}}], 
      LineBox[{{588, 94.242994761331}, {589, 221.420189217303}, {
        680, 204.154857131711}, {681, 94.242994761331}, {
        588, 94.242994761331}}], 
      LineBox[{{2188, 1339.88226985267}, {2220, 1584.81477540078}, {
        2317, 1671.67931922504}, {2383, 1405.20772631382}, {
        2587, 1188.70181933527}, {2560, 1151.89877679309}, {
        2330, 1364.21445200797}, {2188, 1339.88226985267}}], 
      LineBox[{{2188, 1339.88226985267}, {2330, 1364.21445200797}, {
        2560, 1151.89877679309}, {2506, 1078.1260624095}, {
        2577, 1030.36857503334}, {2641, 844.746111217247}, {
        2879, 751.534745184353}, {2697, 461.251384941784}, {
        2514, 375.117972357707}, {2371, 323.39042584595}, {
        2156, 434.639909632171}, {1979, 745.31220007407}, {
        2057, 988.704941954054}, {2169, 1187.16950350532}, {
        2188, 1339.88226985267}}], 
      LineBox[{{588, 94.242994761331}, {523, -59.6890448789258}, {
        670, -371.983905546271}, {695, -219.850704595417}, {
        867, -179.037963298042}, {870, 87.9607040355678}, {
        790, 116.229951705076}, {798, 204.154857131711}, {
        680, 204.154857131711}, {681, 94.242994761331}, {
        588, 94.242994761331}}], 
      LineBox[{{-186, 478.464605144901}, {0, 528.510935927489}, {
        72, 573.825985215659}, {
        0, 993.337293308689}, {-5, 1002.59972308212}, {
        0, 1039.6186192399}, {-9, 1042.70126495359}, {-170, 
         1030.36857503334}, {-161, 889.707780162161}, {-186, 
         478.464605144901}}], 
      LineBox[{{-798, 847.848882519074}, {-901, 1025.7423741631}, {-823, 
         1185.6370872219}, {-681, 1165.70659328125}, {-682, 
         1159.57076670214}, {-539, 1159.57076670214}, {-479, 
         951.619321660995}, {-478, 953.165494379191}, {-508, 
         711.070391241948}, {-616, 796.617243867505}, {-673, 
         937.700159401424}, {-798, 847.848882519074}}], 
      LineBox[{{-1003, 1151.89877679309}, {-900, 1119.64999927209}, {-930, 
         1061.18969147728}, {-901, 1025.7423741631}, {-823, 
         1185.6370872219}, {-1003, 1151.89877679309}}], 
      LineBox[{{-452, 409.584094331548}, {-186, 478.464605144901}, {-186, 
         478.464605144901}, {-161, 889.707780162161}, {-161, 
         889.707780162161}, {-331, 979.437983947626}, {-331, 
         977.89320011788}, {-478, 953.165494379191}, {-478, 
         953.165494379191}, {-508, 711.070391241948}, {-508, 
         711.070391241948}, {-451, 409.584094331548}}], 
      LineBox[{{2494, -157.057481212802}, {2352, -439.336843206435}, {
        2035, -94.242994761331}, {2102, 180.607888429184}, {
        2040, 397.052825652379}, {2156, 434.639909632171}, {
        2371, 323.39042584595}, {2515, 375.117972357707}, {
        2459, 266.926554101265}, {2494, -157.057481212802}}], 
      LineBox[{{-690, 651.857658916043}, {-452, 409.584094331548}, {-508, 
         711.070391241948}, {-616, 796.617243867505}, {-690, 
         651.857658916043}}], 
      LineBox[{{692, 2954.21213399624}, {955, 2806.74526623126}, {
        1160, 2723.09283479484}, {1303, 2937.09752777115}, {
        1509, 2833.53648294498}, {1500, 2022.87560444592}, {
        1500, 2022.87560444592}, {1500, 1846.90877395861}, {
        1440, 1802.55703986236}, {960, 2153.24497219633}, {
        898, 2108.50207895224}, {720, 2154.68539567287}, {
        564, 2379.90246734831}, {572, 2719.0224513327}, {
        692, 2954.21213399624}}], 
      LineBox[{{2599, -2011.2188016591}, {2671, -1842.47987411883}, {
        2668, -1505.04348309984}, {2880, -1376.36949432997}, {
        2957, -1118.11329152481}, {3030, -1426.4295327563}, {
        2978, -1447.62768228824}, {2828, -2280.71489192437}, {
        2644, -2277.86687013947}, {2599, -2011.2188016591}}], 
      LineBox[{{1979, -889.707780162161}, {2060, -912.93917427904}, {
        2097, -1082.74316419852}, {2074, -1246.85410460893}, {
        2155, -1386.99904431572}, {2117, -1590.82019968929}, {
        2072, -1359.65440293531}, {1993, -1307.90231790923}, {
        1979, -889.707780162161}}], 
      LineBox[{{255, 1771.42894794786}, {
        0, 2008.30289668409}, {-288, 2282.13861339978}, {-395, 
         2282.13861339978}, {-330, 1443.08723082259}, {-690, 
         1456.70527446827}, {-723, 1373.33142995544}, {-735, 
         1376.36949432997}, {-681, 1165.70659328125}, {-682, 
         1159.57076670214}, {-539, 1159.57076670214}, {-478, 
         953.165494379191}, {-331, 977.89320011788}, {-238, 
         1260.60496482189}, {0, 1397.62284355361}, {14, 1397.62284355361}, {
        233, 1462.75453908525}, {255, 1771.42894794786}}], 
      LineBox[{{-1023, 1914.64043117697}, {-972, 1866.08437707629}, {-992, 
         1492.9709931035}, {-803, 1491.46136203177}, {-723, 
         1371.81222339529}, {-690, 1456.70527446827}, {-330, 
         1443.08723082259}, {-395, 2282.13861339978}, {-288, 
         2282.13861339978}, {-520, 2476.7075942153}, {-520, 
         2367.20419266102}, {-720, 2367.20419266102}, {-786, 
         2101.26933075711}, {-780, 1964.48330674702}, {-1023, 
         1914.64043117697}}], 
      LineBox[{{-132, 3105.0283610337}, {-325, 3167.68300282426}, {-374, 
         3098.59934625873}, {-557, 2905.39116834584}, {-614, 
         2644.03497082848}, {-791, 2507.36507616271}, {-520, 
         2507.36507616271}, {-520, 2594.58459443247}, {-218, 
         2778.51226350272}, {-229, 2837.54691579025}, {-71, 
         2869.55232939765}, {-132, 3105.0283610337}}], 
      LineBox[{{2426, -982.527302848187}, {2440, -1423.39928629924}, {
        2074, -1812.91818037868}, {2130, -2204.98448605948}, {
        1969, -2333.2630435307}, {1974, -2438.94400368425}, {
        1928, -2437.54244857924}, {1918, -2362.9678246747}, {
        1878, -2059.23221872404}, {1982, -1849.8605926703}, {
        1979, -1553.25128557259}, {1825, -1455.19264984283}, {
        1993, -1307.90231790923}, {2072, -1359.65440293531}, {
        2117, -1590.82019968929}, {2155, -1386.99904431572}, {
        2074, -1246.85410460893}, {2097, -1082.74316419852}, {
        2426, -982.527302848187}}], 
      LineBox[{{706, -1601.32450486808}, {872, -2082.44342096423}, {
        867, -2121.50977541667}, {989, -2583.55679110253}, {
        1200, -2571.13379166761}, {1200, -2262.18899499536}, {
        1200, -2022.87560444592}, {1260, -1697.05054452012}, {
        1516, -1650.75464680077}, {1409, -1635.79167036149}, {
        831, -1608.8235176078}, {706, -1601.32450486808}}], 
      LineBox[{{898, 2108.50207895224}, {719, 2154.68539567287}, {
        255, 1771.42894794786}, {233, 1462.75453908525}, {
        14, 1397.62284355361}, {144, 1113.5026011418}, {
        214, 1099.66545615696}, {216, 1095.05139492517}, {
        293, 1286.55516229006}, {578, 1196.36188714512}, {
        818, 1280.45204041304}, {929, 1569.79184543056}, {
        960, 1877.87150205711}, {898, 2108.50207895224}}], 
      LineBox[{{515, 451.860353994504}, {366, 401.752307029661}, {
        317, 555.079698651133}, {163, 598.810118229931}, {
        214, 1099.66545615696}, {216, 1095.05139492517}, {
        293, 1286.55516229006}, {578, 1196.36188714512}, {
        818, 1280.45204041304}, {845, 1220.85701746224}, {
        879, 1082.74316419852}, {713, 665.889194819279}, {
        588, 639.381428855105}, {515, 451.860353994504}}], 
      LineBox[{{989, -2583.55679110253}, {1099, -3032.65137663086}, {
        1200, -3083.14299325223}, {1674, -2943.68505250796}, {
        1974, -2438.94400368425}, {1928, -2437.54244857924}, {
        1849, -2434.73871972293}, {1918, -2364.38014744091}, {
        1878, -2059.23221872404}, {1762, -2038.88580840386}, {
        1531, -2338.9278436816}, {1368, -2337.51194021024}, {
        1239, -2437.54244857924}, {1200, -2262.18899499536}, {
        1200, -2571.13379166761}, {989, -2583.55679110253}}], 
      LineBox[{{1722, -2586.31505592921}, {1621, -2670.01722689374}, {
        1686, -2754.22998473465}, {1767, -2646.77376229944}, {
        1722, -2586.31505592921}}], 
      LineBox[{{1776, -130.363429036583}, {1741, -259.081894015257}, {
        1834, -226.128530137678}, {1829, -100.52515789574}, {
        1776, -130.363429036583}}], 
      LineBox[{{-992, 1494.48049784607}, {-1052, 1374.85052030985}, {-994, 
         1268.24060428473}, {-828, 1249.91059316788}, {-1005, 
         1220.85701746224}, {-923, 1199.42520655736}, {-1003, 
         1151.89877679309}, {-823, 1185.6370872219}, {-681, 
         1165.70659328125}, {-735, 1376.36949432997}, {-723, 
         1371.81222339529}, {-803, 1491.46136203177}, {-992, 
         1492.9709931035}}], 
      LineBox[{{-798, 847.848882519074}, {-689, 651.857658916043}, {-615, 
         796.617243867505}, {-673, 937.700159401424}, {-798, 
         847.848882519074}}], 
      LineBox[{{2493, -157.057481212802}, {2877, 420.547137235123}, {
        3085, 979.437983947626}, {3047, 1122.7231304159}, {
        2695, 976.348333542772}, {2597, 1078.1260624095}, {
        2595, 1075.04753819981}, {2577, 1030.36857503334}, {
        2641, 844.746111217247}, {2879, 751.534745184353}, {
        2697, 461.251384941784}, {2514, 375.117972357707}, {
        2459, 266.926554101265}, {2493, -157.057481212802}}], 
      LineBox[{{2317, 1671.67931922504}, {2214, 2025.78809593257}, {
        2137, 2121.50977541667}, {2036, 2001.01016255312}, {
        1500, 2022.87560444592}, {1500, 1846.90877395861}, {
        1440, 1802.55703986236}, {1440, 1461.24240826966}, {
        1376, 1447.62768228824}, {1310, 1196.36188714512}, {
        1366, 1025.7423741631}, {1373, 1022.6578060613}, {
        1411, 818.361117322034}, {1647, 472.205809875953}, {
        1852, 328.094233087995}, {2040, 397.052825652379}, {
        2156, 434.639909632171}, {1979, 745.31220007407}, {
        2057, 988.704941954054}, {2169, 1187.16950350532}, {
        2220, 1584.81477540078}, {2317, 1671.67931922504}}], 
      LineBox[{{1928, -2437.54244857924}, {1918, -2362.9678246747}, {
        1849, -2434.73871972293}, {1928, -2437.54244857924}}], 
      LineBox[{{2426, -982.527302848187}, {2327, -569.140060142951}, {
        2352, -439.336843206435}, {2035, -94.242994761331}, {
        1829, -100.52515789574}, {1834, -226.128530137678}, {
        1765, -418.981093943756}, {1846, -768.641472578387}, {
        1979, -883.509862696526}, {2060, -912.93917427904}, {
        2098, -1082.74316419852}, {2426, -982.527302848187}}], 
      LineBox[{{-994, 1268.24060428473}, {-918, 1256.02230010298}, {-1005, 
         1217.79656154958}, {-1005, 1220.85701746224}, {-828, 
         1249.91059316788}, {-994, 1268.24060428473}}], 
      LineBox[{{72, 573.825985215659}, {99, 584.758104799124}, {
        55, 1030.36857503334}, {-10, 1042.70126495359}, {
        0, 1039.6186192399}, {-5, 1002.59972308212}, {0, 993.337293308689}, {
        72, 573.825985215659}}], 
      LineBox[{{517, 3244.78095137098}, {663, 3256.07015412574}, {
        600, 3032.65137663086}, {692, 2954.21213399624}, {
        572, 2719.0224513327}, {450, 3010.51968083594}, {
        517, 3244.78095137098}}], 
      LineBox[{{1852, 328.094233087995}, {1878, 199.445759991742}, {
        1776, -130.363429036583}, {1829, -100.52515789574}, {
        2035, -94.242994761331}, {2102, 180.607888429184}, {
        2040, 397.052825652379}, {1852, 328.094233087995}}], 
      LineBox[{{-791, 2507.36507616271}, {-1023, 1914.64043117697}, {-780, 
         1964.48330674702}, {-786, 2101.26933075711}, {-720, 
         2367.20419266102}, {-520, 2367.20419266102}, {-520, 
         2476.7075942153}, {-520, 2507.36507616271}, {-791, 
         2507.36507616271}}], 
      LineBox[{{1846, -768.641472578387}, {1702, -869.56018778221}, {
        1702, -1081.20422171256}, {1788, -1136.54750303505}, {
        1788, -1256.02230010298}, {1632, -1082.74316419852}, {
        1439, -1018.03030523621}, {1441, -1214.73569345687}, {
        1320, -1214.73569345687}, {1320, -1503.53486623716}, {
        1409, -1635.79167036149}, {1516, -1650.75464680077}, {
        1629, -1650.75464680077}, {1825, -1455.19264984283}, {
        1993, -1307.90231790923}, {1979, -889.707780162161}, {
        1979, -883.509862696526}, {1846, -770.196242009763}}], 
      LineBox[{{1878, -2059.23221872404}, {1762, -2038.88580840386}, {
        1516, -1650.75464680077}, {1629, -1650.75464680077}, {
        1825, -1455.19264984283}, {1979, -1553.25128557259}, {
        1982, -1849.8605926703}, {1878, -2059.23221872404}}]}}, 
    {Dashing[{0.05, 0.03}], 
     LineBox[{{1102, -3014.43063914386}, {1875, 2704.08001996782}}]}}, 
   {Thickness[0.012], 
    LineBox[{{3600, 3471.05309230731}, {3600, 3471.05309230731}, {
      3600, 3412.95823439019}, {3600, 3354.19801350288}, {
      3600, 3294.78388506685}, {3600, 3234.72743198416}, {
      3600, 3174.04036237936}, {3600, 3112.73450731688}, {
      3600, 3050.82181849466}, {3600, 2988.31436591406}, {
      3600, 2925.22433552679}, {3600, 2861.56402685931}, {
      3600, 2797.3458506149}, {3600, 2732.58232625428}, {
      3600, 2667.28607955485}, {3600, 2601.46984014926}, {
      3600, 2535.14643904381}, {3600, 2468.32880611695}, {
      3600, 2401.02996759861}, {3600, 2333.2630435307}, {
      3600, 2265.04124520936}, {3600, 2196.37787260932}, {
      3600, 2127.28631179114}, {3600, 2057.78003229148}, {
      3600, 1987.87258449726}, {3600, 1917.57759700394}, {
      3600, 1846.90877395861}, {3600, 1775.87989238835}, {
      3600, 1704.50479951435}, {3600, 1632.7974100524}, {
      3600, 1560.77170350015}, {3600, 1488.4417214118}, {
      3600, 1415.82156466067}, {3600, 1342.92539069022}, {
      3600, 1269.76741075399}, {3600, 1196.36188714512}, {
      3600, 1122.7231304159}, {3600, 1048.86549658785}, {
      3600, 974.803384353024}, {3600, 900.551232266952}, {
      3600, 826.123515933806}, {3600, 751.534745184353}, {
      3600, 676.799461247243}, {3600, 601.932233914158}, {
      3600, 526.947658699407}, {3600, 451.860353994504}, {
      3600, 376.684958218277}, {3600, 301.436126963085}, {
      3600, 226.128530137678}, {3600, 150.776849107272}, {
      3600, 75.3957738313845}, {3600, 0}, {3600, -75.3957738313845}, {
      3600, -150.776849107272}, {3600, -226.128530137678}, {
      3600, -301.436126963085}, {3600, -376.684958218277}, {
      3600, -451.860353994504}, {3600, -526.947658699407}, {
      3600, -601.932233914158}, {3600, -676.799461247243}, {
      3600, -751.534745184353}, {3600, -826.123515933806}, {
      3600, -900.551232266952}, {3600, -974.803384353024}, {
      3600, -1048.86549658785}, {3600, -1122.7231304159}, {
      3600, -1196.36188714512}, {3600, -1269.76741075399}, {
      3600, -1342.92539069022}, {3600, -1415.82156466067}, {
      3600, -1488.4417214118}, {3600, -1560.77170350015}, {
      3600, -1632.7974100524}, {3600, -1704.50479951435}, {
      3600, -1775.87989238835}, {3600, -1846.90877395861}, {
      3600, -1917.57759700394}, {3600, -1987.87258449726}, {
      3600, -2057.78003229148}, {3600, -2127.28631179114}, {
      3600, -2196.37787260932}, {3600, -2265.04124520936}, {
      3600, -2333.2630435307}, {3600, -2401.02996759861}, {
      3600, -2468.32880611695}, {3600, -2535.14643904381}, {
      3600, -2601.46984014926}, {3600, -2667.28607955485}, {
      3600, -2732.58232625428}, {3600, -2797.3458506149}, {
      3600, -2861.56402685931}, {3600, -2925.22433552679}, {
      3600, -2988.31436591406}, {3600, -3050.82181849466}, {
      3600, -3112.73450731688}, {3600, -3174.04036237936}, {
      3600, -3234.72743198416}, {3600, -3294.78388506685}, {
      3600, -3354.19801350288}, {3600, -3412.95823439019}, {
      3600, -3471.05309230731}}], 
    LineBox[{{3600, -3471.05309230731}, {3600, -3471.05309230731}, {
      3552, -3471.05309230731}, {3504, -3471.05309230731}, {
      3456, -3471.05309230731}, {3408, -3471.05309230731}, {
      3360, -3471.05309230731}, {3312, -3471.05309230731}, {
      3264, -3471.05309230731}, {3216, -3471.05309230731}, {
      3168, -3471.05309230731}, {3120, -3471.05309230731}, {
      3072, -3471.05309230731}, {3024, -3471.05309230731}, {
      2976, -3471.05309230731}, {2928, -3471.05309230731}, {
      2880, -3471.05309230731}, {2832, -3471.05309230731}, {
      2784, -3471.05309230731}, {2736, -3471.05309230731}, {
      2688, -3471.05309230731}, {2640, -3471.05309230731}, {
      2592, -3471.05309230731}, {2544, -3471.05309230731}, {
      2496, -3471.05309230731}, {2448, -3471.05309230731}, {
      2400, -3471.05309230731}, {2352, -3471.05309230731}, {
      2304, -3471.05309230731}, {2256, -3471.05309230731}, {
      2208, -3471.05309230731}, {2160, -3471.05309230731}, {
      2112, -3471.05309230731}, {2064, -3471.05309230731}, {
      2016, -3471.05309230731}, {1968, -3471.05309230731}, {
      1920, -3471.05309230731}, {1872, -3471.05309230731}, {
      1824, -3471.05309230731}, {1776, -3471.05309230731}, {
      1728, -3471.05309230731}, {1680, -3471.05309230731}, {
      1632, -3471.05309230731}, {1584, -3471.05309230731}, {
      1536, -3471.05309230731}, {1488, -3471.05309230731}, {
      1440, -3471.05309230731}, {1392, -3471.05309230731}, {
      1344, -3471.05309230731}, {1296, -3471.05309230731}, {
      1248, -3471.05309230731}, {1200, -3471.05309230731}, {
      1152, -3471.05309230731}, {1104, -3471.05309230731}, {
      1056, -3471.05309230731}, {1008, -3471.05309230731}, {
      960, -3471.05309230731}, {912, -3471.05309230731}, {
      864, -3471.05309230731}, {816, -3471.05309230731}, {
      768, -3471.05309230731}, {720, -3471.05309230731}, {
      672, -3471.05309230731}, {624, -3471.05309230731}, {
      576, -3471.05309230731}, {528, -3471.05309230731}, {
      480, -3471.05309230731}, {432, -3471.05309230731}, {
      384, -3471.05309230731}, {336, -3471.05309230731}, {
      288, -3471.05309230731}, {240, -3471.05309230731}, {
      192, -3471.05309230731}, {144, -3471.05309230731}, {
      96, -3471.05309230731}, {48, -3471.05309230731}, {
      0, -3471.05309230731}, {-48, -3471.05309230731}, {-96, \
-3471.05309230731}, {-144, -3471.05309230731}, {-192, -3471.05309230731}, \
{-240, -3471.05309230731}, {-288, -3471.05309230731}, {-336, \
-3471.05309230731}, {-384, -3471.05309230731}, {-432, -3471.05309230731}, \
{-480, -3471.05309230731}, {-528, -3471.05309230731}, {-576, \
-3471.05309230731}, {-624, -3471.05309230731}, {-672, -3471.05309230731}, \
{-720, -3471.05309230731}, {-768, -3471.05309230731}, {-816, \
-3471.05309230731}, {-864, -3471.05309230731}, {-912, -3471.05309230731}, \
{-960, -3471.05309230731}, {-1008, -3471.05309230731}, {-1056, \
-3471.05309230731}, {-1104, -3471.05309230731}, {-1152, -3471.05309230731}, \
{-1200, -3471.05309230731}}], 
    LineBox[{{-1200, -3471.05309230731}, {-1200, -3412.95823439019}, {-1200, \
-3354.19801350288}, {-1200, -3294.78388506685}, {-1200, -3234.72743198416}, \
{-1200, -3174.04036237936}, {-1200, -3112.73450731688}, {-1200, \
-3050.82181849466}, {-1200, -2988.31436591406}, {-1200, -2925.22433552679}, \
{-1200, -2861.56402685931}, {-1200, -2797.3458506149}, {-1200, \
-2732.58232625428}, {-1200, -2667.28607955485}, {-1200, -2601.46984014926}, \
{-1200, -2535.14643904381}, {-1200, -2468.32880611695}, {-1200, \
-2401.02996759861}, {-1200, -2333.2630435307}, {-1200, -2265.04124520936}, \
{-1200, -2196.37787260932}, {-1200, -2127.28631179114}, {-1200, \
-2057.78003229148}, {-1200, -1987.87258449726}, {-1200, -1917.57759700394}, \
{-1200, -1846.90877395861}, {-1200, -1775.87989238835}, {-1200, \
-1704.50479951435}, {-1200, -1632.7974100524}, {-1200, -1560.77170350015}, \
{-1200, -1488.4417214118}, {-1200, -1415.82156466067}, {-1200, \
-1342.92539069022}, {-1200, -1269.76741075399}, {-1200, -1196.36188714512}, \
{-1200, -1122.7231304159}, {-1200, -1048.86549658785}, {-1200, \
-974.803384353024}, {-1200, -900.551232266952}, {-1200, -826.123515933806}, \
{-1200, -751.534745184353}, {-1200, -676.799461247243}, {-1200, \
-601.932233914158}, {-1200, -526.947658699407}, {-1200, -451.860353994504}, \
{-1200, -376.684958218277}, {-1200, -301.436126963085}, {-1200, \
-226.128530137678}, {-1200, -150.776849107272}, {-1200, -75.3957738313845}, \
{-1200, 0}, {-1200, 75.3957738313845}, {-1200, 150.776849107272}, {-1200, 
       226.128530137678}, {-1200, 301.436126963085}, {-1200, 
       376.684958218277}, {-1200, 451.860353994504}, {-1200, 
       526.947658699407}, {-1200, 601.932233914158}, {-1200, 
       676.799461247243}, {-1200, 751.534745184353}, {-1200, 
       826.123515933806}, {-1200, 900.551232266952}, {-1200, 
       974.803384353024}, {-1200, 1048.86549658785}, {-1200, 
       1122.7231304159}, {-1200, 1196.36188714512}, {-1200, 
       1269.76741075399}, {-1200, 1342.92539069022}, {-1200, 
       1415.82156466067}, {-1200, 1488.4417214118}, {-1200, 
       1560.77170350015}, {-1200, 1632.7974100524}, {-1200, 
       1704.50479951435}, {-1200, 1775.87989238835}, {-1200, 
       1846.90877395861}, {-1200, 1917.57759700394}, {-1200, 
       1987.87258449726}, {-1200, 2057.78003229148}, {-1200, 
       2127.28631179114}, {-1200, 2196.37787260932}, {-1200, 
       2265.04124520936}, {-1200, 2333.2630435307}, {-1200, 
       2401.02996759861}, {-1200, 2468.32880611695}, {-1200, 
       2535.14643904381}, {-1200, 2601.46984014926}, {-1200, 
       2667.28607955485}, {-1200, 2732.58232625428}, {-1200, 
       2797.3458506149}, {-1200, 2861.56402685931}, {-1200, 
       2925.22433552679}, {-1200, 2988.31436591406}, {-1200, 
       3050.82181849466}, {-1200, 3112.73450731688}, {-1200, 
       3174.04036237936}, {-1200, 3234.72743198416}, {-1200, 
       3294.78388506685}, {-1200, 3354.19801350288}, {-1200, 
       3412.95823439019}, {-1200, 3471.05309230731}, {-1200, 
       3471.05309230731}}], 
    LineBox[{{-1200, 3471.05309230731}, {-1152, 3471.05309230731}, {-1104, 
       3471.05309230731}, {-1056, 3471.05309230731}, {-1008, 
       3471.05309230731}, {-960, 3471.05309230731}, {-912, 
       3471.05309230731}, {-864, 3471.05309230731}, {-816, 
       3471.05309230731}, {-768, 3471.05309230731}, {-720, 
       3471.05309230731}, {-672, 3471.05309230731}, {-624, 
       3471.05309230731}, {-576, 3471.05309230731}, {-528, 
       3471.05309230731}, {-480, 3471.05309230731}, {-432, 
       3471.05309230731}, {-384, 3471.05309230731}, {-336, 
       3471.05309230731}, {-288, 3471.05309230731}, {-240, 
       3471.05309230731}, {-192, 3471.05309230731}, {-144, 
       3471.05309230731}, {-96, 3471.05309230731}, {-48, 3471.05309230731}, {
      0, 3471.05309230731}, {48, 3471.05309230731}, {96, 3471.05309230731}, {
      144, 3471.05309230731}, {192, 3471.05309230731}, {
      240, 3471.05309230731}, {288, 3471.05309230731}, {
      336, 3471.05309230731}, {384, 3471.05309230731}, {
      432, 3471.05309230731}, {480, 3471.05309230731}, {
      528, 3471.05309230731}, {576, 3471.05309230731}, {
      624, 3471.05309230731}, {672, 3471.05309230731}, {
      720, 3471.05309230731}, {768, 3471.05309230731}, {
      816, 3471.05309230731}, {864, 3471.05309230731}, {
      912, 3471.05309230731}, {960, 3471.05309230731}, {
      1008, 3471.05309230731}, {1056, 3471.05309230731}, {
      1104, 3471.05309230731}, {1152, 3471.05309230731}, {
      1200, 3471.05309230731}, {1248, 3471.05309230731}, {
      1296, 3471.05309230731}, {1344, 3471.05309230731}, {
      1392, 3471.05309230731}, {1440, 3471.05309230731}, {
      1488, 3471.05309230731}, {1536, 3471.05309230731}, {
      1584, 3471.05309230731}, {1632, 3471.05309230731}, {
      1680, 3471.05309230731}, {1728, 3471.05309230731}, {
      1776, 3471.05309230731}, {1824, 3471.05309230731}, {
      1872, 3471.05309230731}, {1920, 3471.05309230731}, {
      1968, 3471.05309230731}, {2016, 3471.05309230731}, {
      2064, 3471.05309230731}, {2112, 3471.05309230731}, {
      2160, 3471.05309230731}, {2208, 3471.05309230731}, {
      2256, 3471.05309230731}, {2304, 3471.05309230731}, {
      2352, 3471.05309230731}, {2400, 3471.05309230731}, {
      2448, 3471.05309230731}, {2496, 3471.05309230731}, {
      2544, 3471.05309230731}, {2592, 3471.05309230731}, {
      2640, 3471.05309230731}, {2688, 3471.05309230731}, {
      2736, 3471.05309230731}, {2784, 3471.05309230731}, {
      2832, 3471.05309230731}, {2880, 3471.05309230731}, {
      2928, 3471.05309230731}, {2976, 3471.05309230731}, {
      3024, 3471.05309230731}, {3072, 3471.05309230731}, {
      3120, 3471.05309230731}, {3168, 3471.05309230731}, {
      3216, 3471.05309230731}, {3264, 3471.05309230731}, {
      3312, 3471.05309230731}, {3360, 3471.05309230731}, {
      3408, 3471.05309230731}, {3456, 3471.05309230731}, {
      3504, 3471.05309230731}, {3552, 3471.05309230731}, {
      3600, 3471.05309230731}, {3600, 3471.05309230731}}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{307, 432},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->253282186]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToMinutes",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/ToMinutes"], "[", 
     StyleBox["deg", "TI"], "]"}], Cell[TextData[{
     "convert ",
     Cell[BoxData["deg"], "InlineFormula"],
     " into minutes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToMinutes",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/ToMinutes"], "[", "{", 
     StyleBox["deg", "TI"], ",", 
     StyleBox["min", "TI"], "}", "]"}], Cell[
    "convert when the argument is in degrees and minutes", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToMinutes",
      BaseStyle->"Link",
      ButtonData->"paclet:WorldPlot/ref/ToMinutes"], "[", "{", 
     StyleBox["deg", "TI"], ",", 
     StyleBox["min", "TI"], ",", 
     StyleBox["sec", "TI"], "}", "]"}], Cell["\<\
convert when the argument is in degrees, minutes, and seconds\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->3467],

Cell["Converting into minutes. ", "Caption",
 CellID->629],

Cell[TextData[{
 "Giving the name of the continent is the same as giving the list of names of \
countries in that continent. ",
 StyleBox["World", "MR"],
 " gives the list of all the countries in the world. As previously noted, the \
names of countries are strings and need to be included in quotes. The names \
of continents are symbols and do not require quotes. The following countries \
can be given: "
}], "Text",
 CellID->18119],

Cell[BoxData[GridBox[{
   {"Belize", "Bermuda"},
   {"Canada", 
    RowBox[{"Costa", " ", "Rica"}]},
   {"Cuba", 
    RowBox[{"Dominican", " ", "Republic"}]},
   {
    RowBox[{"El", " ", "Salvador"}], "Greenland"},
   {"Guatemala", "Haiti"},
   {"Honduras", "Jamaica"},
   {"Mexico", "Nicaragua"},
   {"Panama", 
    RowBox[{"Puerto", " ", "Rico"}]},
   {"USA", "\[Null]"}
  }]], "DefinitionBox",
 CellID->14667],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["NorthAmerica", "MR"],
 "."
}], "Caption",
 CellID->26950],

Cell[BoxData[GridBox[{
   {"Albania", "Andorra"},
   {"Austria", "Belarus"},
   {"Belgium", 
    RowBox[{"Bosnia", " ", "and", " ", "Herzegovina"}]},
   {"Bulgaria", "Croatia"},
   {"Cyprus", 
    RowBox[{"Czech", " ", "Republic"}]},
   {"Denmark", "Estonia"},
   {"Finland", "France"},
   {"Germany", "Gibraltar"},
   {"Greece", "Hungary"},
   {"Iceland", "Ireland"},
   {"Italy", "Latvia"},
   {"Liechtenstein", "Lithuania"},
   {"Luxembourg", "Macedonia"},
   {"Moldova", "Monaco"},
   {"Netherlands", "Norway"},
   {"Poland", "Portugal"},
   {"Romania", "Russia"},
   {
    RowBox[{"San", " ", "Marino"}], 
    RowBox[{"Serbia", " ", "and", " ", "Montenegro"}]},
   {"Slovakia", "Slovenia"},
   {"Spain", "Sweden"},
   {"Switzerland", "Turkey"},
   {"Ukraine", 
    RowBox[{"United", " ", "Kingdom"}]}
  }]], "DefinitionBox",
 CellID->12532],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Europe", "MR"],
 "."
}], "Caption",
 CellID->18557],

Cell[BoxData[GridBox[{
   {"Argentina", "Bolivia"},
   {"Brazil", "Chile"},
   {"Colombia", "Ecuador"},
   {
    RowBox[{"French", " ", "Guiana"}], "Guyana"},
   {"Paraguay", "Peru"},
   {"Suriname", "Uruguay"},
   {"Venezuela", "\[Null]"}
  }]], "DefinitionBox",
 CellID->5589],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["SouthAmerica", "MR"],
 "."
}], "Caption",
 CellID->4834],

Cell[BoxData[GridBox[{
   {"Australia", "Fiji"},
   {"Indonesia", 
    RowBox[{"New", " ", "Zealand"}]},
   {
    RowBox[{"Papua", " ", "New", " ", "Guinea"}], "\[Null]"}
  }]], "DefinitionBox",
 CellID->18859],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Oceania", "MR"],
 "."
}], "Caption",
 CellID->17393],

Cell[BoxData[GridBox[{
   {"Afghanistan", "Armenia"},
   {"Azerbaijan", "Bahrain"},
   {"Bangladesh", "Bhutan"},
   {"Brunei", "Burma"},
   {"Cambodia", "China"},
   {"Georgia", "India"},
   {"Indonesia", "Iran"},
   {"Iraq", "Israel"},
   {"Japan", "Jordan"},
   {"Kazakhstan", "Kuwait"},
   {"Kyrgyzstan", "Laos"},
   {"Lebanon", "Malaysia"},
   {"Mongolia", "Nepal"},
   {
    RowBox[{"North", " ", "Korea"}], "Oman"},
   {"Pakistan", "Philippines"},
   {"Qatar", "Russia"},
   {
    RowBox[{"Saudi", " ", "Arabia"}], "Singapore"},
   {
    RowBox[{"South", " ", "Korea"}], 
    RowBox[{"Sri", " ", "Lanka"}]},
   {"Syria", "Taiwan"},
   {"Tajikistan", "Thailand"},
   {"Turkey", "Turkmenistan"},
   {"Uzbekistan", "Vietnam"}
  }]], "DefinitionBox",
 CellID->16363],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Asia", "MR"],
 "."
}], "Caption",
 CellID->30606],

Cell[BoxData[GridBox[{
   {"Bahrain", "Egypt"},
   {"Iran", "Iraq"},
   {"Israel", "Jordan"},
   {"Kuwait", "Lebanon"},
   {"Oman", "Qatar"},
   {
    RowBox[{"Saudi", " ", "Arabia"}], "Syria"},
   {"Turkey", "UAE"},
   {"Yemen", "\[Null]"}
  }]], "DefinitionBox",
 CellID->18978],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["MiddleEast", "MR"],
 "."
}], "Caption",
 CellID->12641],

Cell[BoxData[GridBox[{
   {"Algeria", "Angola"},
   {"Benin", "Botswana"},
   {"Burkina", "Burundi"},
   {"Cameroon", "CAR"},
   {"Chad", "Congo"},
   {
    RowBox[{
     RowBox[{
      RowBox[{"Cote", " ", "d"}], "\[CloseCurlyQuote]"}], "Ivoire"}], 
    "Djibouti"},
   {"Egypt", 
    RowBox[{"Equatorial", " ", "Guinea"}]},
   {"Eritrea", "Ethiopia"},
   {"Gabon", "Ghana"},
   {"Guinea", "Guinea\[Hyphen]Bissau"},
   {"Kenya", "Lesotho"},
   {"Liberia", "Libya"},
   {"Madagascar", "Malawi"},
   {"Mali", "Mauritania"},
   {"Morocco", "Mozambique"},
   {"Namibia", "Niger"},
   {"Nigeria", "Rwanda"},
   {"Senegal", 
    RowBox[{"Sierra", " ", "Leone"}]},
   {"Somalia", 
    RowBox[{"South", " ", "Africa"}]},
   {"Sudan", "Swaziland"},
   {"Tanzania", 
    RowBox[{"The", " ", "Gambia"}]},
   {"Togo", "Tunisia"},
   {"Uganda", 
    RowBox[{"Western", " ", "Sahara"}]},
   {"Zaire", "Zambia"},
   {"Zimbabwe", "\[Null]"}
  }]], "DefinitionBox",
 CellID->15458],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Africa", "MR"],
 "."
}], "Caption",
 CellID->24]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"World Plotting Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 20.3118606}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  WorldPlot Package Tutorial", "language" -> "en", "paclet" -> 
    "WorldPlot Package", "status" -> "ObsoleteFlag", "summary" -> 
    "Displaying a map. To make a map of an entire continent, you can give the \
name of the continent in place of the list of country names. Thus, for \
example, WorldPlot[Oceania] is equivalent to WorldPlot[{\"Indonesia\",\"Papua \
New Guinea\",\"Fiji\",\"Australia\",\"New Zealand\"}]. The names of the \
countries that can be mapped are listed at the end of this tutorial. Note \
that the names of countries are strings. This means they must be surrounded \
by quotes when you use them in a list of countries. However, the continent \
names represent lists and therefore are not strings but symbols. They should \
not be put in quotes. This loads the package. ", "synonyms" -> {}, "title" -> 
    "World Plotting Package", "type" -> "Tutorial", "uri" -> 
    "WorldPlot/tutorial/WorldPlotting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2328, 46, 70, "AnchorBarGrid"],
Cell[2931, 71, 373, 12, 70, "ObsolescenceNote",
 CellID->429636518],
Cell[CellGroupData[{
Cell[3329, 87, 54, 1, 70, "Title",
 CellID->7815],
Cell[3386, 90, 1095, 31, 70, "DefinitionBox",
 CellID->17118],
Cell[4484, 123, 53, 1, 70, "Caption",
 CellID->21122],
Cell[4540, 126, 1073, 26, 70, "Text",
 CellID->31246],
Cell[5616, 154, 63, 1, 70, "MathCaption",
 CellID->23220],
Cell[5682, 157, 93, 3, 70, "Input",
 CellID->25297],
Cell[5778, 162, 131, 4, 70, "MathCaption",
 CellID->31871],
Cell[CellGroupData[{
Cell[5934, 170, 106, 3, 28, "Input",
 CellID->18646],
Cell[6043, 175, 35967, 605, 380, "Output",
 CellID->727051308]
}, Open  ]],
Cell[42025, 783, 137, 4, 70, "MathCaption",
 CellID->10328],
Cell[CellGroupData[{
Cell[42187, 791, 162, 5, 70, "Input",
 CellID->1746],
Cell[42352, 798, 110579, 1866, 70, "Output",
 CellID->119348936]
}, Open  ]],
Cell[152946, 2667, 747, 21, 70, "DefinitionBox",
 CellID->15924],
Cell[153696, 2690, 76, 1, 70, "Caption",
 CellID->19040],
Cell[153775, 2693, 1703, 47, 70, "Text",
 CellID->24388],
Cell[155481, 2742, 72, 1, 70, "MathCaption",
 CellID->25938],
Cell[155556, 2745, 466, 11, 70, "Input",
 CellID->29228],
Cell[156025, 2758, 155, 4, 70, "MathCaption",
 CellID->26372],
Cell[CellGroupData[{
Cell[156205, 2766, 166, 5, 70, "Input",
 CellID->3321],
Cell[156374, 2773, 27765, 455, 70, "Output",
 CellID->823499]
}, Open  ]],
Cell[184154, 3231, 1075, 22, 70, "Text",
 CellID->19559],
Cell[185232, 3255, 1534, 40, 70, "Text",
 CellID->18372],
Cell[186769, 3297, 957, 30, 70, "DefinitionBox",
 CellID->25738],
Cell[187729, 3329, 47, 1, 70, "Caption",
 CellID->15570],
Cell[187779, 3332, 358, 9, 70, "Text",
 CellID->22176],
Cell[188140, 3343, 940, 28, 70, "Text",
 CellID->22005],
Cell[189083, 3373, 507, 15, 70, "Text",
 CellID->5032],
Cell[189593, 3390, 622, 16, 70, "Text",
 CellID->429],
Cell[190218, 3408, 452, 10, 70, "Text",
 CellID->29619],
Cell[190673, 3420, 419, 12, 70, "Text",
 CellID->5389],
Cell[191095, 3434, 582, 18, 70, "Text",
 CellID->1968],
Cell[191680, 3454, 543, 14, 70, "Text",
 CellID->13542],
Cell[192226, 3470, 1542, 42, 70, "Text",
 CellID->16983],
Cell[193771, 3514, 187, 4, 70, "MathCaption",
 CellID->11637],
Cell[CellGroupData[{
Cell[193983, 3522, 242, 7, 70, "Input",
 CellID->31161],
Cell[194228, 3531, 50440, 874, 70, "Output",
 CellID->525880775]
}, Open  ]],
Cell[244683, 4408, 1542, 45, 70, "DefinitionBox3Col",
 CellID->11887],
Cell[246228, 4455, 204, 8, 70, "Caption",
 CellID->10061],
Cell[246435, 4465, 4695, 136, 70, "DefinitionBox3Col",
 CellID->9543],
Cell[251133, 4603, 384, 13, 70, "Caption",
 CellID->19469],
Cell[251520, 4618, 1200, 37, 70, "Text",
 CellID->9804],
Cell[252723, 4657, 1454, 46, 70, "Text",
 CellID->22984],
Cell[254180, 4705, 2447, 79, 70, "Text",
 CellID->11997],
Cell[256630, 4786, 1015, 26, 70, "Text",
 CellID->32371],
Cell[257648, 4814, 186, 4, 70, "MathCaption",
 CellID->2784],
Cell[CellGroupData[{
Cell[257859, 4822, 463, 12, 70, "Input",
 CellID->32001],
Cell[258325, 4836, 61204, 1078, 70, "Output",
 CellID->101371584]
}, Open  ]],
Cell[319544, 5917, 1016, 26, 70, "Text",
 CellID->1587],
Cell[320563, 5945, 2128, 70, 70, "Text",
 CellID->2348],
Cell[322694, 6017, 443, 12, 70, "MathCaption",
 CellID->7654],
Cell[CellGroupData[{
Cell[323162, 6033, 603, 19, 70, "Input",
 CellID->31287],
Cell[323768, 6054, 150617, 2870, 70, "Output",
 CellID->542178915]
}, Open  ]],
Cell[474400, 8927, 1091, 28, 70, "Text",
 CellID->6331],
Cell[475494, 8957, 1011, 25, 70, "Text",
 CellID->5642],
Cell[476508, 8984, 1514, 47, 70, "DefinitionBox",
 CellID->22596],
Cell[478025, 9033, 227, 8, 70, "Caption",
 CellID->7444],
Cell[478255, 9043, 3899, 126, 70, "Text",
 CellID->15960],
Cell[482157, 9171, 126, 4, 70, "MathCaption",
 CellID->5345],
Cell[CellGroupData[{
Cell[482308, 9179, 114, 3, 70, "Input",
 CellID->1529],
Cell[482425, 9184, 1000, 35, 54, "Output",
 CellID->199535790]
}, Open  ]],
Cell[483440, 9222, 129, 4, 70, "MathCaption",
 CellID->7009],
Cell[CellGroupData[{
Cell[483594, 9230, 625, 23, 70, "Input",
 CellID->11421],
Cell[484222, 9255, 336, 12, 36, "Output",
 CellID->258122955]
}, Open  ]],
Cell[484573, 9270, 433, 15, 70, "MathCaption",
 CellID->768],
Cell[CellGroupData[{
Cell[485031, 9289, 457, 15, 70, "Input",
 CellID->29746],
Cell[485491, 9306, 61991, 1081, 70, "Output",
 CellID->253282186]
}, Open  ]],
Cell[547497, 10390, 1108, 34, 70, "DefinitionBox",
 CellID->3467],
Cell[548608, 10426, 58, 1, 70, "Caption",
 CellID->629],
Cell[548669, 10429, 434, 9, 70, "Text",
 CellID->18119],
Cell[549106, 10440, 412, 15, 70, "DefinitionBox",
 CellID->14667],
Cell[549521, 10457, 111, 5, 70, "Caption",
 CellID->26950],
Cell[549635, 10464, 845, 29, 70, "DefinitionBox",
 CellID->12532],
Cell[550483, 10495, 105, 5, 70, "Caption",
 CellID->18557],
Cell[550591, 10502, 278, 10, 70, "DefinitionBox",
 CellID->5589],
Cell[550872, 10514, 110, 5, 70, "Caption",
 CellID->4834],
Cell[550985, 10521, 210, 7, 70, "DefinitionBox",
 CellID->18859],
Cell[551198, 10530, 106, 5, 70, "Caption",
 CellID->17393],
Cell[551307, 10537, 768, 28, 70, "DefinitionBox",
 CellID->16363],
Cell[552078, 10567, 103, 5, 70, "Caption",
 CellID->30606],
Cell[552184, 10574, 280, 11, 70, "DefinitionBox",
 CellID->18978],
Cell[552467, 10587, 109, 5, 70, "Caption",
 CellID->12641],
Cell[552579, 10594, 965, 36, 70, "DefinitionBox",
 CellID->15458],
Cell[553547, 10632, 102, 5, 70, "Caption",
 CellID->24]
}, Open  ]],
Cell[553664, 10640, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

