(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13471,        432]
NotebookOptionsPosition[     10844,        345]
NotebookOutlinePosition[     12150,        382]
CellTagsIndexPosition[     12065,        377]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookToSymbolicNotebookML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/NotebookToSymbolicNotebookML"], 
          "SymbolicNotebookMLToNotebook" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicNotebookMLToNotebook"], 
          "SymbolicExpressionMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicExpressionMLToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookToSymbolicNotebookML\"\>", 
       2->"\<\"SymbolicNotebookMLToNotebook\"\>", 
       3->"\<\"SymbolicExpressionMLToExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpressionToSymbolicExpressionML", "ObjectName",
 CellID->5610],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionToSymbolicExpressionML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to ExpressionML and returns the corresponding SymbolicXML. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6450]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->19982],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<XMLDeclaration\>\"", ",", "\"\<DOCTYPEDeclaration\>\"", ",", 
      "\"\<DocumentHeader\>\""}], "}"}], Cell[TextData[{
     "annotations to add to the output (acceptable values are combinations of \
\n",
     Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
     ", and ",
     Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28621]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505713019],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->17344689],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->280350446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicExpressionML", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"5", "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4345],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{"\<\"xmlns\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Log\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Function\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Symbol\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"Plus\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Number\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"5\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Function\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Sin\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}], ",",
    
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16883]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14895],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookToSymbolicNotebookML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/NotebookToSymbolicNotebookML",
    ButtonNote->"ObsLink: No successor for NotebookToSymbolicNotebookML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicNotebookMLToNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicNotebookMLToNotebook",
    ButtonNote->"ObsLink: No successor for SymbolicNotebookMLToNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicExpressionMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicExpressionMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20280]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5193],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->148268558],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->28816443]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionToSymbolicExpressionML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 26.6245222}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ExpressionToSymbolicExpressionML[expr] converts expr to ExpressionML and \
returns the corresponding SymbolicXML. ", "synonyms" -> {}, "title" -> 
    "ExpressionToSymbolicExpressionML", "type" -> "Symbol", "uri" -> 
    "XML/ref/ExpressionToSymbolicExpressionML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4808, 151, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505713019]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11922, 370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2151, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2774, 81, 69, 1, 70, "ObjectName",
 CellID->5610],
Cell[2846, 84, 535, 16, 70, "Usage",
 CellID->6450]
}, Open  ]],
Cell[CellGroupData[{
Cell[3418, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3896, 122, 69, 1, 70, "Notes",
 CellID->19982],
Cell[3968, 125, 803, 21, 70, "3ColumnTableMod",
 CellID->28621]
}, Closed]],
Cell[CellGroupData[{
Cell[4808, 151, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505713019],
Cell[CellGroupData[{
Cell[5193, 165, 147, 5, 70, "ExampleSection",
 CellID->17344689],
Cell[5343, 172, 126, 3, 70, "Input",
 CellID->280350446],
Cell[CellGroupData[{
Cell[5494, 179, 209, 6, 28, "Input",
 CellID->4345],
Cell[5706, 187, 2750, 69, 173, "Output",
 CellID->16883]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8517, 263, 311, 9, 70, "SeeAlsoSection",
 CellID->14895],
Cell[8831, 274, 984, 28, 70, "SeeAlso",
 CellID->20280]
}, Open  ]],
Cell[CellGroupData[{
Cell[9852, 307, 313, 9, 70, "TutorialsSection",
 CellID->5193],
Cell[10168, 318, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[10344, 326, 319, 9, 70, "MoreAboutSection",
 CellID->148268558],
Cell[10666, 337, 136, 3, 70, "MoreAbout",
 CellID->28816443]
}, Open  ]],
Cell[10817, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

