(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17093,        530]
NotebookOptionsPosition[     14230,        435]
NotebookOutlinePosition[     15528,        472]
CellTagsIndexPosition[     15443,        467]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Exporting XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ExportingXML"], 
          "Working with MathML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Exporting XML\"\>", 
       3->"\<\"Working with MathML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToSymbolicMathML"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"ExpressionToMathML\"\>", 4->"\<\"MathMLToExpression\"\>", 
       5->"\<\"SymbolicMathMLToExpression\"\>", 
       6->"\<\"BoxesToSymbolicMathML\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpressionToSymbolicMathML", "ObjectName",
 CellID->23158],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionToSymbolicMathML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression, ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", into a MathML-flavored SymbolicXML structure. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4464]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The output is in content MathML wherever possible.", "Notes",
 CellID->13762],

Cell["The following options can be given: ", "Notes",
 CellID->8510],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "annotations to add to the output (acceptable values are combinations of \
\n",
     Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
     ", and ",
     Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formats\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<PresentationMathML\>\"", ",", "\"\<ContentMathML\>\""}], 
     "}"}], Cell["type of MathML markup to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeMarkupAnnotations\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to add annotation when exporting a formula with constructs \
specific to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " and no clear counterpart in MathML"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathAttributes\>\"", 
    RowBox[{"{", "}"}], Cell[
    "attributes to add to the root element of the MathML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UseUnicodePlane1Characters\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to replace plane 1 Unicode characters with similar plane 0 characters\
\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->30946]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214203938],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85031886],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->99183943],

Cell["Generate some MathML-flavored SymbolicXML:", "ExampleText",
 CellID->12584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicMathML", "[", 
  RowBox[{"x", "+", "y", "+", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10270],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", 
     "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"semantics\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mrow\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mo\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"y\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mo\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"z\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",",
         
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"annotation-xml\"\>", ",", 
          RowBox[{"{", 
           RowBox[{"\<\"encoding\"\>", "\[Rule]", "\<\"MathML-Content\"\>"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"apply\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"plus\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"y\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"z\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
           "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{556, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32715]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13540],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31065],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Exporting XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ExportingXML"]], "Tutorials",
 CellID->455443521],

Cell[TextData[ButtonBox["Working with MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "Tutorials",
 CellID->300390898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->277051674],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->69002144]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionToSymbolicMathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 26.8589032}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ExpressionToSymbolicMathML[expr] converts the Mathematica expression, \
expr, into a MathML-flavored SymbolicXML structure. ", "synonyms" -> {}, 
    "title" -> "ExpressionToSymbolicMathML", "type" -> "Symbol", "uri" -> 
    "XML/ref/ExpressionToSymbolicMathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6669, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214203938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15300, 460}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2909, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3532, 95, 64, 1, 70, "ObjectName",
 CellID->23158],
Cell[3599, 98, 591, 18, 70, "Usage",
 CellID->4464]
}, Open  ]],
Cell[CellGroupData[{
Cell[4227, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4705, 138, 83, 1, 70, "Notes",
 CellID->13762],
Cell[4791, 141, 68, 1, 70, "Notes",
 CellID->8510],
Cell[4862, 144, 1770, 42, 70, "3ColumnTableMod",
 CellID->30946]
}, Closed]],
Cell[CellGroupData[{
Cell[6669, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214203938],
Cell[CellGroupData[{
Cell[7054, 205, 147, 5, 70, "ExampleSection",
 CellID->85031886],
Cell[7204, 212, 125, 3, 70, "Input",
 CellID->99183943],
Cell[7332, 217, 81, 1, 70, "ExampleText",
 CellID->12584],
Cell[CellGroupData[{
Cell[7438, 222, 151, 4, 28, "Input",
 CellID->10270],
Cell[7592, 228, 2841, 70, 139, "Output",
 CellID->32715]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10494, 305, 311, 9, 70, "SeeAlsoSection",
 CellID->13540],
Cell[10808, 316, 2098, 66, 70, "SeeAlso",
 CellID->27297]
}, Open  ]],
Cell[CellGroupData[{
Cell[12943, 387, 314, 9, 70, "TutorialsSection",
 CellID->31065],
Cell[13260, 398, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[13402, 403, 144, 3, 70, "Tutorials",
 CellID->455443521],
Cell[13549, 408, 144, 3, 70, "Tutorials",
 CellID->300390898]
}, Open  ]],
Cell[CellGroupData[{
Cell[13730, 416, 319, 9, 70, "MoreAboutSection",
 CellID->277051674],
Cell[14052, 427, 136, 3, 70, "MoreAbout",
 CellID->69002144]
}, Open  ]],
Cell[14203, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

