(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20722,        715]
NotebookOptionsPosition[     16806,        576]
NotebookOutlinePosition[     18054,        613]
CellTagsIndexPosition[     17969,        608]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"ToSymbolicXML\"\>", 3->"\<\"ToVerboseXML\"\>", 
       4->"\<\"ToCompactXML\"\>", 5->"\<\"RawXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromSymbolicXML", "ObjectName",
 CellID->19485],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromSymbolicXML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts a SymbolicXML expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a more native format, if one is available."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FromSymbolicXML"], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["ToSymbolicXML",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/ToSymbolicXML"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10199],

Cell[TextData[{
 "Given a SymbolicXML expression, ",
 Cell[BoxData["FromSymbolicXML"], "InlineFormula"],
 " will attempt to interpret it."
}], "Notes",
 CellID->11567]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35754657],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->885086244],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->63212508],

Cell[TextData[{
 "Create an ExpressionML file using ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<example1\>\"", ",", " ", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{"Cell", "[", 
      RowBox[{"\"\<I am a test file\>\"", ",", "\"\<Text\>\""}], "]"}], "}"}],
     "]"}], ",", " ", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24075],

Cell[BoxData["\<\"example1\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28026]
}, Open  ]],

Cell["Import this ExpressionML file as SymbolicXML:", "ExampleText",
 CellID->20124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<example1\>\"", ",", " ", "\"\<SymbolicXML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27607],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Notebook\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Function\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Symbol\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"List\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Function\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Cell\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"String\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"I am a test file\"\>", "}"}]}], "]"}], 
                  ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"String\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Text\"\>", "}"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}], ",",
    
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{578, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17774]
}, Open  ]],

Cell[TextData[{
 "Use the output as the argument for ",
 Cell[BoxData["FromSymbolicXML"], "InlineFormula"],
 " to interpret the SymbolicXML as a notebook expression:"
}], "ExampleText",
 CellID->2884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromSymbolicXML", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20128],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"I am a test file\"\>", ",", "\<\"Text\"\>"}], "]"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3145],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->20289868],

Cell["Create a MathML file:", "ExampleText",
 CellID->20481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<example2\>\"", ",", " ", 
   RowBox[{"x", "^", "3"}], ",", " ", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11714],

Cell[BoxData["\<\"example2\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"!!", "example2"}], "Input"]], "Input",
 CellLabel->"In[3]:=",
 CellID->24168],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>3</Number>
 </Function>
</Expression>\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->13338]
}, Open  ]],

Cell["Import the file as SymbolicXML:", "ExampleText",
 CellID->20307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<example2\>\"", ",", " ", "\"\<SymbolicXML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26793],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Number\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"3\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{568, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23504]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["FromSymbolicXML"], "InlineFormula"],
 " to interpret the output as a box expression:"
}], "ExampleText",
 CellID->1105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromSymbolicXML", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1697],

Cell[BoxData[
 SuperscriptBox["x", "3"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->18217]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4879],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->603170324]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4208],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->1671511862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->286324930],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->489705190]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromSymbolicXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 27.1714112}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "FromSymbolicXML[expr] converts a SymbolicXML expression expr to a more \
native format, if one is available.", "synonyms" -> {}, "title" -> 
    "FromSymbolicXML", "type" -> "Symbol", "uri" -> 
    "XML/ref/FromSymbolicXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4519, 146, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->35754657]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17827, 601}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2329, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2952, 84, 53, 1, 70, "ObjectName",
 CellID->19485],
Cell[3008, 87, 530, 16, 70, "Usage",
 CellID->20741]
}, Open  ]],
Cell[CellGroupData[{
Cell[3575, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4053, 125, 259, 9, 70, "Notes",
 CellID->10199],
Cell[4315, 136, 167, 5, 70, "Notes",
 CellID->11567]
}, Closed]],
Cell[CellGroupData[{
Cell[4519, 146, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35754657],
Cell[CellGroupData[{
Cell[4903, 160, 148, 5, 70, "ExampleSection",
 CellID->885086244],
Cell[5054, 167, 125, 3, 70, "Input",
 CellID->63212508],
Cell[5182, 172, 209, 8, 70, "ExampleText",
 CellID->23849],
Cell[CellGroupData[{
Cell[5416, 184, 327, 9, 28, "Input",
 CellID->24075],
Cell[5746, 195, 169, 5, 36, "Output",
 CellID->28026]
}, Open  ]],
Cell[5930, 203, 84, 1, 70, "ExampleText",
 CellID->20124],
Cell[CellGroupData[{
Cell[6039, 208, 162, 5, 70, "Input",
 CellID->27607],
Cell[6204, 215, 2970, 74, 173, "Output",
 CellID->17774]
}, Open  ]],
Cell[9189, 292, 200, 5, 70, "ExampleText",
 CellID->2884],
Cell[CellGroupData[{
Cell[9414, 301, 107, 3, 70, "Input",
 CellID->20128],
Cell[9524, 306, 306, 10, 36, "Output",
 CellID->24546]
}, Open  ]],
Cell[9845, 319, 120, 3, 70, "ExampleDelimiter",
 CellID->3145],
Cell[9968, 324, 125, 3, 70, "Input",
 CellID->20289868],
Cell[10096, 329, 60, 1, 70, "ExampleText",
 CellID->20481],
Cell[CellGroupData[{
Cell[10181, 334, 190, 5, 70, "Input",
 CellID->11714],
Cell[10374, 341, 169, 5, 36, "Output",
 CellID->20149]
}, Open  ]],
Cell[CellGroupData[{
Cell[10580, 351, 113, 4, 70, "Input",
 CellID->24168],
Cell[10696, 357, 387, 13, 70, "Print",
 CellID->13338]
}, Open  ]],
Cell[11098, 373, 70, 1, 70, "ExampleText",
 CellID->20307],
Cell[CellGroupData[{
Cell[11193, 378, 162, 5, 70, "Input",
 CellID->26793],
Cell[11358, 385, 2047, 54, 139, "Output",
 CellID->23504]
}, Open  ]],
Cell[13420, 442, 159, 5, 70, "ExampleText",
 CellID->1105],
Cell[CellGroupData[{
Cell[13604, 451, 106, 3, 70, "Input",
 CellID->1697],
Cell[13713, 456, 177, 6, 36, "Output",
 CellID->18217]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13951, 469, 310, 9, 70, "SeeAlsoSection",
 CellID->4879],
Cell[14264, 480, 1507, 53, 70, "SeeAlso",
 CellID->603170324]
}, Open  ]],
Cell[CellGroupData[{
Cell[15808, 538, 313, 9, 70, "TutorialsSection",
 CellID->4208],
Cell[16124, 549, 144, 3, 70, "Tutorials",
 CellID->1671511862]
}, Open  ]],
Cell[CellGroupData[{
Cell[16305, 557, 319, 9, 70, "MoreAboutSection",
 CellID->286324930],
Cell[16627, 568, 137, 3, 70, "MoreAbout",
 CellID->489705190]
}, Open  ]],
Cell[16779, 574, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

