(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11435,        390]
NotebookOptionsPosition[      8965,        307]
NotebookOutlinePosition[     10218,        343]
CellTagsIndexPosition[     10134,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToSymbolicMathML"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 
       2->"\<\"ExpressionToMathML\"\>", 3->"\<\"MathMLToExpression\"\>", 
       4->"\<\"ExpressionToSymbolicMathML\"\>", 
       5->"\<\"SymbolicMathMLToExpression\"\>", 
       6->"\<\"BoxesToSymbolicMathML\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathMLToBoxes", "ObjectName",
 CellID->28343],

Cell[TextData[{
 "Same functionality now provided by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"], "[", 
   RowBox[{
    StyleBox["string", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MathML\>\"", ",", "\"\<Boxes\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->18258],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MathMLToBoxes", "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts the string containing MathML-flavored XML text into a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " box expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->31289948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->95278061],

Cell[TextData[{
 "Generate some MathML data using ",
 Cell[BoxData[
  ButtonBox["BoxesToMathML",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/BoxesToMathML",
   ButtonNote->"ObsLink: No successor for BoxesToMathML"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`BoxesToMathML", "[", 
  RowBox[{"SuperscriptBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18298],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\
\\n  <mi>x</mi>\\n  <mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{347, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39]
}, Open  ]],

Cell[TextData[{
 "Convert the output back into a box expression using ",
 Cell[BoxData["MathMLToBoxes"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`MathMLToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3205],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
     ",", "\<\"MathMLPresentationTag\"\>", ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{544, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19997]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24441],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8871],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathMLToBoxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 27.6089224}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  XML Package Symbol", "language" -> "en", "paclet" -> 
    "XML Package", "status" -> "ObsoleteFlag", "summary" -> 
    "MathMLToBoxes[string] converts the string containing MathML-flavored XML \
text into a Mathematica box expression.", "synonyms" -> {}, "title" -> 
    "MathMLToBoxes", "type" -> "Symbol", "uri" -> "XML/ref/MathMLToBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3773, 117, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9999, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2151, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2774, 77, 51, 1, 70, "ObjectName",
 CellID->28343],
Cell[2828, 80, 387, 14, 70, "ObsolescenceNote",
 CellID->18258],
Cell[3218, 96, 518, 16, 70, "Usage",
 CellID->16859]
}, Open  ]],
Cell[CellGroupData[{
Cell[3773, 117, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4150, 131, 147, 5, 70, "ExampleSection",
 CellID->31289948],
Cell[4300, 138, 125, 3, 70, "Input",
 CellID->95278061],
Cell[4428, 143, 283, 9, 70, "ExampleText",
 CellID->18516],
Cell[CellGroupData[{
Cell[4736, 156, 197, 5, 28, "Input",
 CellID->18298],
Cell[4936, 163, 272, 6, 122, "Output",
 CellID->39]
}, Open  ]],
Cell[5223, 172, 162, 5, 70, "ExampleText",
 CellID->31283],
Cell[CellGroupData[{
Cell[5410, 181, 115, 3, 70, "Input",
 CellID->3205],
Cell[5528, 186, 463, 14, 54, "Output",
 CellID->19997]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6052, 207, 311, 9, 70, "SeeAlsoSection",
 CellID->24441],
Cell[6366, 218, 2065, 65, 70, "SeeAlso",
 CellID->17683]
}, Open  ]],
Cell[CellGroupData[{
Cell[8468, 288, 313, 9, 70, "TutorialsSection",
 CellID->8871],
Cell[8784, 299, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[8938, 305, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

