(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11159,        380]
NotebookOptionsPosition[      8671,        296]
NotebookOutlinePosition[      9945,        333]
CellTagsIndexPosition[      9861,        328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToSymbolicMathML"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"ExpressionToMathML\"\>", 
       4->"\<\"ExpressionToSymbolicMathML\"\>", 
       5->"\<\"SymbolicMathMLToExpression\"\>", 
       6->"\<\"BoxesToSymbolicMathML\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathMLToExpression", "ObjectName",
 CellID->26792],

Cell[TextData[{
 "Same functionality now provided by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"], "[", 
   RowBox[{
    StyleBox["string", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MathML\>\"", ",", "\"\<Expression\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->27065],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MathMLToExpression", "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts the string containing MathML-flavored XML text into a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19278]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2221860],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->257445852],

Cell["Convert an expression to MathML:", "ExampleText",
 CellID->6702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`ExpressionToMathML", "[", 
  RowBox[{"3", " ", "+", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28564],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <mrow>\\n   <mi>x</mi>\\n   <mo>+</mo>\\n   <mn>3</mn>\\n  \
</mrow>\\n  <annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    \
<plus/>\\n    <ci>x</ci>\\n    <cn type='integer'>3</cn>\\n   </apply>\\n  \
</annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31539]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["MathMLToExpression"], "InlineFormula"],
 " to recover the original ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->2572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`MathMLToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2257],

Cell[BoxData[
 RowBox[{"3", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2370]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4198],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathMLToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 28.0464336}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  XML Package Symbol", "language" -> "en", "paclet" -> 
    "XML Package", "status" -> "ObsoleteFlag", "summary" -> 
    "MathMLToExpression[string] converts the string containing \
MathML-flavored XML text into a Mathematica expression.", "synonyms" -> {}, 
    "title" -> "MathMLToExpression", "type" -> "Symbol", "uri" -> 
    "XML/ref/MathMLToExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3769, 117, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9726, 321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2136, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2759, 77, 56, 1, 70, "ObjectName",
 CellID->26792],
Cell[2818, 80, 392, 14, 70, "ObsolescenceNote",
 CellID->27065],
Cell[3213, 96, 519, 16, 70, "Usage",
 CellID->19278]
}, Open  ]],
Cell[CellGroupData[{
Cell[3769, 117, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4146, 131, 146, 5, 70, "ExampleSection",
 CellID->2221860],
Cell[4295, 138, 126, 3, 70, "Input",
 CellID->257445852],
Cell[4424, 143, 70, 1, 70, "ExampleText",
 CellID->6702],
Cell[CellGroupData[{
Cell[4519, 148, 154, 4, 28, "Input",
 CellID->28564],
Cell[4676, 154, 491, 9, 292, "Output",
 CellID->31539]
}, Open  ]],
Cell[5182, 166, 208, 8, 70, "ExampleText",
 CellID->2572],
Cell[CellGroupData[{
Cell[5415, 178, 120, 3, 70, "Input",
 CellID->2257],
Cell[5538, 183, 175, 6, 36, "Output",
 CellID->2370]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5774, 196, 311, 9, 70, "SeeAlsoSection",
 CellID->10976],
Cell[6088, 207, 2049, 65, 70, "SeeAlso",
 CellID->7547]
}, Open  ]],
Cell[CellGroupData[{
Cell[8174, 277, 313, 9, 70, "TutorialsSection",
 CellID->4198],
Cell[8490, 288, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[8644, 294, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

