(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20176,        626]
NotebookOptionsPosition[     17128,        523]
NotebookOutlinePosition[     18434,        560]
CellTagsIndexPosition[     18349,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpressionToSymbolicExpressionML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicExpressionML"], 
          "SymbolicNotebookMLToNotebook" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicNotebookMLToNotebook"], 
          "SymbolicExpressionMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicExpressionMLToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ExpressionToSymbolicExpressionML\"\>", 
       2->"\<\"SymbolicNotebookMLToNotebook\"\>", 
       3->"\<\"SymbolicExpressionMLToExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookToSymbolicNotebookML", "ObjectName",
 CellID->2814],

Cell["The NotebookML format is no longer supported.", "ObsolescenceNote",
 CellID->21154],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NotebookToSymbolicNotebookML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to NotebookML and returns the corresponding SymbolicXML. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18012]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When exporting GIF images for ",
 Cell[BoxData["BoxData"], "InlineFormula"],
 " or ",
 Cell[BoxData["GraphicsData"], "InlineFormula"],
 ", you need to have a filename for naming them. Control this with the ",
 Cell[BoxData["\"\<FileName\>\""], "InlineFormula"],
 " option. By default, GIF images are saved with the name \"",
 StyleBox["temp_", "MR"],
 StyleBox["N", "MR",
  FontSlant->"Italic"],
 StyleBox[".gif", "MR"],
 "\" (where ",
 StyleBox["N", "MR",
  FontSlant->"Italic"],
 " is a sequential number)."
}], "Notes",
 CellID->19752],

Cell["The following options can be given: ", "Notes",
 CellID->3338],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<XMLDeclaration\>\"", ",", "\"\<DOCTYPEDeclaration\>\"", ",", 
      "\"\<StyleAdvisories\>\"", ",", "\"\<DocumentHeader\>\""}], "}"}], Cell[
    TextData[{
     "annotations to add to the output (acceptable values are combinations of \
",
     Cell[BoxData[
      FormBox["\"\<DocumentHeader\>\"", TraditionalForm]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      FormBox["\"\<XMLDeclaration\>\"", TraditionalForm]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      FormBox["\"\<DOCTYPEDeclaration\>\"", TraditionalForm]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      FormBox["\"\<StyleAdvisories\>\"", TraditionalForm]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsFormats\>\"", 
    RowBox[{"{", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "}"}], Cell[
    "how to export graphics data", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BoxFormats\>\"", 
    RowBox[{"{", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "}"}], Cell[
    "how to export box data", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StyleSheets\>\"", 
    RowBox[{"{", "}"}], Cell[
    "specify a stylesheet (CSS or XSLT) for the notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FileName\>\"", "\"\<temp.xml\>\"", 
    Cell["default filename for exported images", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FilesDirectory\>\"", 
    "\"\<NBMLFiles\>\"", Cell[
    "default directory for exported images", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->8706]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168961247],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->490669521],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->713693838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`NotebookML`NotebookToSymbolicNotebookML", "[", 
  RowBox[{"Cell", "[", "\"\<hi\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14145],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Cell\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Cell\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"CreatedBy\"\>", "\[Rule]", "\<\"Mathematica 6.0\"\>"}], 
       ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xhtml\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/1999/xhtml\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"String\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "\<\"hi\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{564, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5991]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`NotebookML`NotebookToSymbolicNotebookML", "[", 
   RowBox[{"SelectedNotebook", "[", "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1969],

Cell[TextData[{
 "Here ",
 Cell[BoxData["BoxData"], "InlineFormula"],
 " is exported as a GIF image. The autogenerated filename for the GIF image \
is in the ",
 Cell[BoxData["\"\<src\>\""], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->21839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`NotebookML`NotebookToSymbolicNotebookML", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"BoxData", "[", "\"\<hi\>\"", "]"}], "]"}], ",", 
   RowBox[{"\"\<BoxFormats\>\"", "->", "\"\<GIF\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24308],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Cell\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Cell\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"CreatedBy\"\>", "\[Rule]", "\<\"Mathematica 6.0\"\>"}], 
       ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xhtml\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/1999/xhtml\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"BoxData\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://www.w3.org/1999/xhtml\"\>", 
             ",", "\<\"img\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             
             RowBox[{"\<\"src\"\>", 
              "\[Rule]", "\<\"NBMLFiles\\\\temp_1.gif\"\>"}], ",", 
             RowBox[{"\<\"width\"\>", "\[Rule]", "\<\"14\"\>"}], ",", 
             RowBox[{"\<\"height\"\>", "\[Rule]", "\<\"15\"\>"}], ",", 
             RowBox[{"\<\"border\"\>", "\[Rule]", "\<\"0\"\>"}], ",", 
             RowBox[{"\<\"align\"\>", "\[Rule]", "\<\"absmiddle\"\>"}], ",", 
             
             RowBox[{"\<\"alt\"\>", 
              "\[Rule]", "\<\"[Graphics:NBMLFiles\\\\temp_1.gif]\"\>"}]}], 
            "}"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{564, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->16565]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<FilesDirectory\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<FileName\>\""], "InlineFormula"],
 " to change the directory and name of the image file:"
}], "ExampleText",
 CellID->23762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`NotebookML`NotebookToSymbolicNotebookML", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"BoxData", "[", "\"\<hi\>\"", "]"}], "]"}], ",", 
   RowBox[{"\"\<BoxFormats\>\"", "->", "\"\<GIF\>\""}], ",", 
   RowBox[{"\"\<FileName\>\"", "->", "\"\<myFile\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19473],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Cell\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Cell\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"CreatedBy\"\>", "\[Rule]", "\<\"Mathematica 6.0\"\>"}], 
       ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xhtml\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/1999/xhtml\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"BoxData\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://www.w3.org/1999/xhtml\"\>", 
             ",", "\<\"img\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             
             RowBox[{"\<\"src\"\>", 
              "\[Rule]", "\<\"NBMLFiles\\\\myFile_1.gif\"\>"}], ",", 
             RowBox[{"\<\"width\"\>", "\[Rule]", "\<\"14\"\>"}], ",", 
             RowBox[{"\<\"height\"\>", "\[Rule]", "\<\"15\"\>"}], ",", 
             RowBox[{"\<\"border\"\>", "\[Rule]", "\<\"0\"\>"}], ",", 
             RowBox[{"\<\"align\"\>", "\[Rule]", "\<\"absmiddle\"\>"}], ",", 
             
             RowBox[{"\<\"alt\"\>", 
              "\[Rule]", "\<\"[Graphics:NBMLFiles\\\\myFile_1.gif]\"\>"}]}], 
            "}"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{564, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->23681]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicExpressionML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicExpressionML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicNotebookMLToNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicNotebookMLToNotebook",
    ButtonNote->"ObsLink: No successor for SymbolicNotebookMLToNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicExpressionMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicExpressionMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12525],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookToSymbolicNotebookML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 28.2495638}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  XML Package Symbol", "language" -> "en", "paclet" -> 
    "XML Package", "status" -> "ObsoleteFlag", "summary" -> 
    "NotebookToSymbolicNotebookML[expr] converts expr to NotebookML and \
returns the corresponding SymbolicXML. ", "synonyms" -> {}, "title" -> 
    "NotebookToSymbolicNotebookML", "type" -> "Symbol", "uri" -> 
    "XML/ref/NotebookToSymbolicNotebookML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6167, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->168961247]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18206, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1630, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2253, 67, 65, 1, 70, "ObjectName",
 CellID->2814],
Cell[2321, 70, 89, 1, 70, "ObsolescenceNote",
 CellID->21154],
Cell[2413, 73, 530, 16, 70, "Usage",
 CellID->18012]
}, Open  ]],
Cell[CellGroupData[{
Cell[2980, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3458, 111, 556, 17, 70, "Notes",
 CellID->19752],
Cell[4017, 130, 68, 1, 70, "Notes",
 CellID->3338],
Cell[4088, 133, 2042, 49, 70, "3ColumnTableMod",
 CellID->8706]
}, Closed]],
Cell[CellGroupData[{
Cell[6167, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168961247],
Cell[CellGroupData[{
Cell[6552, 201, 148, 5, 70, "ExampleSection",
 CellID->490669521],
Cell[6703, 208, 126, 3, 70, "Input",
 CellID->713693838],
Cell[CellGroupData[{
Cell[6854, 215, 175, 4, 28, "Input",
 CellID->14145],
Cell[7032, 221, 1724, 46, 139, "Output",
 CellID->5991]
}, Open  ]],
Cell[8771, 270, 191, 5, 70, "Input",
 CellID->1969],
Cell[8965, 277, 258, 8, 70, "ExampleText",
 CellID->21839],
Cell[CellGroupData[{
Cell[9248, 289, 287, 7, 70, "Input",
 CellID->24308],
Cell[9538, 298, 2565, 66, 173, "Output",
 CellID->16565]
}, Open  ]],
Cell[12118, 367, 237, 7, 70, "ExampleText",
 CellID->23762],
Cell[CellGroupData[{
Cell[12380, 378, 350, 8, 70, "Input",
 CellID->19473],
Cell[12733, 388, 2569, 66, 173, "Output",
 CellID->23681]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15363, 461, 310, 9, 70, "SeeAlsoSection",
 CellID->3079],
Cell[15676, 472, 917, 27, 70, "SeeAlso",
 CellID->8313]
}, Open  ]],
Cell[CellGroupData[{
Cell[16630, 504, 314, 9, 70, "TutorialsSection",
 CellID->12525],
Cell[16947, 515, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[17101, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

