(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15136,        542]
NotebookOptionsPosition[     11853,        425]
NotebookOutlinePosition[     13066,        461]
CellTagsIndexPosition[     12981,        456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"ToSymbolicXML\"\>", 3->"\<\"FromSymbolicXML\"\>", 
       4->"\<\"ToVerboseXML\"\>", 5->"\<\"ToCompactXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RawXML", "ObjectName",
 CellID->31102],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RawXML", "[", 
       StyleBox[
        RowBox[{"\"\<\>", "string", "\"\<\>"}], "TI"], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]",
     "represents a raw string fragment of XML that can be used inside a \
SymbolicXML expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->837254406],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->24069976],

Cell["A raw string fragment of XML:", "ExampleText",
 CellID->23859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rawFragment", "=", 
  RowBox[{"ExportString", "[", 
   RowBox[{"1", ",", "\"\<MathML\>\"", ",", 
    RowBox[{"ConversionOptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Annotations\>\"", "\[Rule]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"\"\<Formats\>\"", "\[Rule]", "\"\<PresentationMathML\>\""}]}],
       "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23305],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mn>1</mn>\\n</math>\"\>"], "Output",
 ImageSize->{347, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22496]
}, Open  ]],

Cell[TextData[{
 "A composed SymbolicXML expression with an embedded fragment of ",
 Cell[BoxData["RawXML"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"composedFragment", " ", "=", " ", 
  RowBox[{"XMLElement", "[", 
   RowBox[{"\"\<p\>\"", ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"RawXML", " ", "@", " ", "rawFragment"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24223],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"p\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "RawXML", 
     "[", "\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mn>1</mn>\\n</math>\"\>", "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{524, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4852]
}, Open  ]],

Cell["The composite expression exports as XML:", "ExampleText",
 CellID->17879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"composedFragment", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30519],

Cell[BoxData["\<\"<p><math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mn>1</mn>\\n</math></p>\"\>"], "Output",
 ImageSize->{368, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6126]
}, Open  ]],

Cell["\<\
The composite expression and variants are recognized as SymbolicXML:\
\>", "ExampleText",
 CellID->7793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLQ", " ", "@", " ", "composedFragment"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31585],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->21465]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ToSymbolicXML",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/ToSymbolicXML"]], "InlineFormula"],
 " expands any ",
 Cell[BoxData["RawXML"], "InlineFormula"],
 " fragments into SymbolicXML fragments, if possible:"
}], "ExampleText",
 CellID->31371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", " ", "@", " ", "composedFragment"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->15444],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"p\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"math\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mn\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->17107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", " ", "@", " ", 
  RowBox[{"RawXML", " ", "@", " ", "rawFragment"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->17271],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", ",", "\<\"xmlns\"\>"}],
       "}"}], "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"mn\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{550, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->24087]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20595],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1495]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31417],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->9629790],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->236053155]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RawXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 28.5308210}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "RawXML[\"string \"] represents a raw string fragment of XML that can be \
used inside a SymbolicXML expression. ", "synonyms" -> {}, "title" -> 
    "RawXML", "type" -> "Symbol", "uri" -> "XML/ref/RawXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3577, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12846, 449}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2367, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2990, 85, 44, 1, 70, "ObjectName",
 CellID->31102],
Cell[3037, 88, 503, 16, 70, "Usage",
 CellID->25587]
}, Open  ]],
Cell[CellGroupData[{
Cell[3577, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3954, 123, 148, 5, 70, "ExampleSection",
 CellID->837254406],
Cell[4105, 130, 125, 3, 70, "Input",
 CellID->24069976],
Cell[4233, 135, 68, 1, 70, "ExampleText",
 CellID->23859],
Cell[CellGroupData[{
Cell[4326, 140, 440, 12, 47, "Input",
 CellID->23305],
Cell[4769, 154, 237, 6, 71, "Output",
 CellID->22496]
}, Open  ]],
Cell[5021, 163, 166, 5, 70, "ExampleText",
 CellID->24833],
Cell[CellGroupData[{
Cell[5212, 172, 292, 9, 70, "Input",
 CellID->24223],
Cell[5507, 183, 402, 13, 71, "Output",
 CellID->4852]
}, Open  ]],
Cell[5924, 199, 79, 1, 70, "ExampleText",
 CellID->17879],
Cell[CellGroupData[{
Cell[6028, 204, 152, 4, 70, "Input",
 CellID->30519],
Cell[6183, 210, 243, 6, 71, "Output",
 CellID->6126]
}, Open  ]],
Cell[6441, 219, 114, 3, 70, "ExampleText",
 CellID->7793],
Cell[CellGroupData[{
Cell[6580, 226, 124, 3, 70, "Input",
 CellID->31585],
Cell[6707, 231, 157, 5, 36, "Output",
 CellID->21465]
}, Open  ]],
Cell[6879, 239, 310, 10, 70, "ExampleText",
 CellID->31371],
Cell[CellGroupData[{
Cell[7214, 253, 125, 3, 70, "Input",
 CellID->15444],
Cell[7342, 258, 780, 24, 71, "Output",
 CellID->17107]
}, Open  ]],
Cell[CellGroupData[{
Cell[8159, 287, 158, 4, 70, "Input",
 CellID->17271],
Cell[8320, 293, 609, 18, 71, "Output",
 CellID->24087]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8990, 318, 311, 9, 70, "SeeAlsoSection",
 CellID->20595],
Cell[9304, 329, 1520, 53, 70, "SeeAlso",
 CellID->1495]
}, Open  ]],
Cell[CellGroupData[{
Cell[10861, 387, 314, 9, 70, "TutorialsSection",
 CellID->31417],
Cell[11178, 398, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[11354, 406, 317, 9, 70, "MoreAboutSection",
 CellID->9629790],
Cell[11674, 417, 137, 3, 70, "MoreAbout",
 CellID->236053155]
}, Open  ]],
Cell[11826, 423, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

