(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14389,        467]
NotebookOptionsPosition[     11794,        379]
NotebookOutlinePosition[     13067,        416]
CellTagsIndexPosition[     12982,        411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/BoxesToSymbolicMathML"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"ExpressionToMathML\"\>", 4->"\<\"MathMLToExpression\"\>", 
       5->"\<\"ExpressionToSymbolicMathML\"\>", 
       6->"\<\"SymbolicMathMLToExpression\"\>", 
       7->"\<\"BoxesToSymbolicMathML\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicMathMLToBoxes", "ObjectName",
 CellID->22988],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicMathMLToBoxes", "[", 
       StyleBox["smml", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the MathML-flavored SymbolicXML structure, ",
     Cell[BoxData[
      StyleBox["smml", "TI"]], "InlineFormula"],
     ", into a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " box expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24616]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->811158907],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->77931988],

Cell["Generate MathML-flavored SymbolicXML:", "ExampleText",
 CellID->24524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicMathML", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12129],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", 
     "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"semantics\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"msup\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mn\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",",
         
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"annotation-xml\"\>", ",", 
          RowBox[{"{", 
           RowBox[{"\<\"encoding\"\>", "\[Rule]", "\<\"MathML-Content\"\>"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"apply\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"power\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"cn\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                  "}"}], ",", 
                 RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
           "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{531, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27442]
}, Open  ]],

Cell[TextData[{
 "Use the result to convert the data back into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression:"
}], "ExampleText",
 CellID->1984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicMathMLToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4872],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"TagBox", "[", 
      RowBox[{
       RowBox[{"SuperscriptBox", "[", 
        RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
       ",", "\<\"MathMLPresentationTag\"\>", ",", 
       RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"\<\"AnnotationsTagWrapper\"\>", "[", 
      RowBox[{"TagBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
        ",", "\<\"MathMLContentTag\"\>", ",", 
        RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{544, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7049]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3915],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7288],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->436647490],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->76272397]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicMathMLToBoxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 34.8278572}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "SymbolicMathMLToBoxes[smml] converts the MathML-flavored SymbolicXML \
structure, smml, into a Mathematica box expression.", "synonyms" -> {}, 
    "title" -> "SymbolicMathMLToBoxes", "type" -> "Symbol", "uri" -> 
    "XML/ref/SymbolicMathMLToBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3972, 117, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12847, 404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2660, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3283, 91, 59, 1, 70, "ObjectName",
 CellID->22988],
Cell[3345, 94, 590, 18, 70, "Usage",
 CellID->24616]
}, Open  ]],
Cell[CellGroupData[{
Cell[3972, 117, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4349, 131, 148, 5, 70, "ExampleSection",
 CellID->811158907],
Cell[4500, 138, 125, 3, 70, "Input",
 CellID->77931988],
Cell[4628, 143, 76, 1, 70, "ExampleText",
 CellID->24524],
Cell[CellGroupData[{
Cell[4729, 148, 141, 4, 28, "Input",
 CellID->12129],
Cell[4873, 154, 2192, 56, 122, "Output",
 CellID->27442]
}, Open  ]],
Cell[7080, 213, 170, 6, 70, "ExampleText",
 CellID->1984],
Cell[CellGroupData[{
Cell[7275, 223, 112, 3, 70, "Input",
 CellID->4872],
Cell[7390, 228, 893, 24, 88, "Output",
 CellID->7049]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8344, 259, 310, 9, 70, "SeeAlsoSection",
 CellID->3915],
Cell[8657, 270, 2108, 66, 70, "SeeAlso",
 CellID->11056]
}, Open  ]],
Cell[CellGroupData[{
Cell[10802, 341, 313, 9, 70, "TutorialsSection",
 CellID->7288],
Cell[11118, 352, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[11294, 360, 319, 9, 70, "MoreAboutSection",
 CellID->436647490],
Cell[11616, 371, 136, 3, 70, "MoreAbout",
 CellID->76272397]
}, Open  ]],
Cell[11767, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

