(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13790,        450]
NotebookOptionsPosition[     11112,        361]
NotebookOutlinePosition[     12467,        399]
CellTagsIndexPosition[     12382,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToSymbolicMathML"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"ExpressionToMathML\"\>", 4->"\<\"MathMLToExpression\"\>", 
       5->"\<\"ExpressionToSymbolicMathML\"\>", 
       6->"\<\"BoxesToSymbolicMathML\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicMathMLToExpression", "ObjectName",
 CellID->9072],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicMathMLToExpression", "[", 
       StyleBox["smml", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the MathML-flavored SymbolicXML structure, ",
     Cell[BoxData[
      StyleBox["smml", "TI"]], "InlineFormula"],
     ", into a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. The output is in the form of content MathML, wherever \
possible."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27257630],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->152496608],

Cell["Generate MathML-flavored SymbolicXML:", "ExampleText",
 CellID->7912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicMathML", "[", 
  RowBox[{"x", " ", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12289],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", 
     "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"semantics\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"msup\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mn\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",",
         
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"annotation-xml\"\>", ",", 
          RowBox[{"{", 
           RowBox[{"\<\"encoding\"\>", "\[Rule]", "\<\"MathML-Content\"\>"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"apply\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"power\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"cn\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                  "}"}], ",", 
                 RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
           "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{531, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17253]
}, Open  ]],

Cell[TextData[{
 "Use the result to recover the original ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->29979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicMathMLToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7299],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12322]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30876],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15137]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10193],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->730085347],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->75673292]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicMathMLToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 35.0309874}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "SymbolicMathMLToExpression[smml] converts the MathML-flavored \
SymbolicXML structure, smml, into a Mathematica expression. The output is in \
the form of content MathML, wherever possible.", "synonyms" -> {}, "title" -> 
    "SymbolicMathMLToExpression", "type" -> "Symbol", "uri" -> 
    "XML/ref/SymbolicMathMLToExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4016, 117, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12247, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2633, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3256, 90, 63, 1, 70, "ObjectName",
 CellID->9072],
Cell[3322, 93, 657, 19, 70, "Usage",
 CellID->30977]
}, Open  ]],
Cell[CellGroupData[{
Cell[4016, 117, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4393, 131, 147, 5, 70, "ExampleSection",
 CellID->27257630],
Cell[4543, 138, 126, 3, 70, "Input",
 CellID->152496608],
Cell[4672, 143, 75, 1, 70, "ExampleText",
 CellID->7912],
Cell[CellGroupData[{
Cell[4772, 148, 146, 4, 28, "Input",
 CellID->12289],
Cell[4921, 154, 2192, 56, 122, "Output",
 CellID->17253]
}, Open  ]],
Cell[7128, 213, 159, 6, 70, "ExampleText",
 CellID->29979],
Cell[CellGroupData[{
Cell[7312, 223, 117, 3, 70, "Input",
 CellID->7299],
Cell[7432, 228, 177, 6, 36, "Output",
 CellID->12322]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7670, 241, 311, 9, 70, "SeeAlsoSection",
 CellID->30876],
Cell[7984, 252, 2098, 66, 70, "SeeAlso",
 CellID->15137]
}, Open  ]],
Cell[CellGroupData[{
Cell[10119, 323, 314, 9, 70, "TutorialsSection",
 CellID->10193],
Cell[10436, 334, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[10612, 342, 319, 9, 70, "MoreAboutSection",
 CellID->730085347],
Cell[10934, 353, 136, 3, 70, "MoreAbout",
 CellID->75673292]
}, Open  ]],
Cell[11085, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

