(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14733,        506]
NotebookOptionsPosition[     11676,        404]
NotebookOutlinePosition[     13037,        442]
CellTagsIndexPosition[     12952,        437]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"ToSymbolicXML\"\>", 3->"\<\"FromSymbolicXML\"\>", 
       4->"\<\"ToCompactXML\"\>", 5->"\<\"RawXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToVerboseXML", "ObjectName",
 CellID->5794],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToVerboseXML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates an equivalent SymbolicXML expression that \
explicitly exposes all the namespace information for elements and attributes \
in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToVerboseXML", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]exposes only namespaces that match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23791]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->13341],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AttributesDefaultNameSpace\>\"", 
    "\"\<NullNameSpace\>\"", Cell[
    "controls how attribute namespaces are expanded", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->24837]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249851845],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->178274422],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->87766445],

Cell["Create some sample XML:", "ExampleText",
 CellID->5284],

Cell[BoxData[
 RowBox[{
  RowBox[{"xml", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<foo\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<http://www.w3.org/2000/xmlns/\>\"", ",", "\"\<xmlns\>\""}], 
         "}"}], "\[Rule]", "\"\<http://www.wolfram.com\>\""}], ",", 
       RowBox[{"\"\<att\>\"", "\[Rule]", "\"\<val\>\""}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5253],

Cell[TextData[{
 Cell[BoxData["ToVerboseXML"], "InlineFormula"],
 " gives explicit namespace information for elements. With the default value \
of ",
 Cell[BoxData["\"\<AttributesDefaultNameSpace\>\""], "InlineFormula"],
 ", the namespaces of attributes are set to an empty string (",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->20727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToVerboseXML", "[", 
  RowBox[{"xml", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<NullNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30285],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://www.wolfram.com\"\>", ",", "\<\"foo\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
        ",", "\<\"xmlns\"\>"}], "}"}], 
      "\[Rule]", "\<\"http://www.wolfram.com\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2426]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<AttributesDefaultNameSpace\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData["\"\<ElementNameSpace\>\""], "InlineFormula"],
 ", the namespace of the enclosing element is used:"
}], "ExampleText",
 CellID->19670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToVerboseXML", "[", 
  RowBox[{"xml", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14536],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://www.wolfram.com\"\>", ",", "\<\"foo\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
        ",", "\<\"xmlns\"\>"}], "}"}], 
      "\[Rule]", "\<\"http://www.wolfram.com\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"http://www.wolfram.com\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{459, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3281]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17438],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28900],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->45506835],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->368969556]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToVerboseXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 36.8122830}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ToVerboseXML[expr] generates an equivalent SymbolicXML expression that \
explicitly exposes all the namespace information for elements and attributes \
in expr. ToVerboseXML[expr, pattern] exposes only namespaces that match \
pattern.", "synonyms" -> {}, "title" -> "ToVerboseXML", "type" -> "Symbol", 
    "uri" -> "XML/ref/ToVerboseXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4990, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->249851845]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12809, 430}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 84, 49, 1, 70, "ObjectName",
 CellID->5794],
Cell[3013, 87, 929, 28, 70, "Usage",
 CellID->23791]
}, Open  ]],
Cell[CellGroupData[{
Cell[3979, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4457, 137, 68, 1, 70, "Notes",
 CellID->13341],
Cell[4528, 140, 425, 10, 70, "3ColumnTableMod",
 CellID->24837]
}, Closed]],
Cell[CellGroupData[{
Cell[4990, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249851845],
Cell[CellGroupData[{
Cell[5375, 169, 148, 5, 70, "ExampleSection",
 CellID->178274422],
Cell[5526, 176, 125, 3, 70, "Input",
 CellID->87766445],
Cell[5654, 181, 61, 1, 70, "ExampleText",
 CellID->5284],
Cell[5718, 184, 508, 15, 70, "Input",
 CellID->5253],
Cell[6229, 201, 370, 9, 70, "ExampleText",
 CellID->20727],
Cell[CellGroupData[{
Cell[6624, 214, 221, 7, 70, "Input",
 CellID->30285],
Cell[6848, 223, 684, 22, 54, "Output",
 CellID->2426]
}, Open  ]],
Cell[7547, 248, 258, 7, 70, "ExampleText",
 CellID->19670],
Cell[CellGroupData[{
Cell[7830, 259, 224, 7, 70, "Input",
 CellID->14536],
Cell[8057, 268, 706, 22, 71, "Output",
 CellID->3281]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8824, 297, 311, 9, 70, "SeeAlsoSection",
 CellID->17438],
Cell[9138, 308, 1508, 53, 70, "SeeAlso",
 CellID->9958]
}, Open  ]],
Cell[CellGroupData[{
Cell[10683, 366, 314, 9, 70, "TutorialsSection",
 CellID->28900],
Cell[11000, 377, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[11176, 385, 318, 9, 70, "MoreAboutSection",
 CellID->45506835],
Cell[11497, 396, 137, 3, 70, "MoreAbout",
 CellID->368969556]
}, Open  ]],
Cell[11649, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

