(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19197,        634]
NotebookOptionsPosition[     15682,        514]
NotebookOutlinePosition[     17023,        552]
CellTagsIndexPosition[     16938,        547]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Importing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Importing XML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLGetString" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGetString"], 
          "InitializeXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/InitializeXMLParser"], 
          "ReleaseXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/ReleaseXMLParser"], 
          "XMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLParser"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XMLGetString\"\>", 
       2->"\<\"InitializeXMLParser\"\>", 3->"\<\"ReleaseXMLParser\"\>", 
       4->"\<\"XMLParser\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XMLGet", "ObjectName",
 CellID->13245],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLGet", "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the XML expression tree corresponding to the \
contents of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLGet", "[", 
       RowBox[{
        StyleBox["\"\<file\>\"", "TI"], ",", 
        StyleBox["parser", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses the pre-initialized ",
     Cell[BoxData[
      ButtonBox["XMLParser",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/XMLParser"]], "InlineFormula"],
     " object to parse the file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLGet", "[", 
       RowBox[{"\"\<http://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", " ", "\[Ellipsis]"}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]reads from a URL. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->14726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This is similar to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{
    StyleBox["file", "TI"], ",", 
    ButtonBox["\"\<XML\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/XML"]}], "]"}]], "InlineFormula"],
 ". However, it can take a pre-initialized XML parser."
}], "Notes",
 CellID->201],

Cell["The following options can be given: ", "Notes",
 CellID->6424],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<NormalizeWhitespace\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to remove leading, trailing, and multiple internal whitespace in \
elements\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeNamespaces\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to explicitly include namespaces", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ValidateAgainstDTD\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to validate the XML against the DTD content model", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeEmbeddedObjects\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether to retain comments and processing instructions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AllowRemoteDTDAccess\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to seek DTDs on the network", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadDTD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to read the DTD", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeDefaultedAttributes\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to explicitly include default attributes as defined in the DTD\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AllowUnrecognizedEntities\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether entities undefined by the DTD are considered errors", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PreserveCDATASections\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the distinction between CDATA sections and regular character data is \
maintained on import\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->24083]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->664410894],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->442528467],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->7785466],

Cell["Create a file:", "ExampleText",
 CellID->28752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<temp.xml\>\"", ",", "\"\<Here is an example file.\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11324],

Cell[BoxData["\<\"temp.xml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"temp", ".", "xml"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27740],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <String>Here is an example file.</String>
</Expression>\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->18255]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["XMLGet"], "InlineFormula"],
 " returns the contents of the file as an XML expression:"
}], "ExampleText",
 CellID->4468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XMLGet", "[", "\"\<temp.xml\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22070],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"String\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "\<\"Here is an example file.\"\>", "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{557, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->16843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10030],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->29127018],

Cell["\<\
Retrieve data via HTTP. This retrieves stock quotes and returns the data as \
SymbolicXML:\
\>", "ExampleText",
 CellID->15756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "XMLGet", "[", 
   "\"\<http://www.webservicex.net/stockquote.asmx/GetQuote?symbol=IBM\>\"", 
   "]"}], " "}]], "Input",
 CellLabelAutoDelete->False,
 CellLabel->"In[2]:=",
 CellID->10765],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
     RowBox[{
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], ",", 
      RowBox[{"\<\"Encoding\"\>", "\[Rule]", "\<\"utf-8\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"string\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"xmlns\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://www.webserviceX.NET/\"\>"}], "}"}], ",", 
     RowBox[{
     "{", "\<\"<StockQuotes><Stock><Symbol>IBM</Symbol><Last>82.06</Last><\
Date>1/3/2006</Date><Time>4:01pm</Time><Change>-0.14</Change><Open>82.45</\
Open><High>82.55</High><Low>80.81</Low><Volume>11715100</Volume><MktCap>129.\
6B</MktCap><PreviousClose>82.20</PreviousClose><PercentageChange>-0.17%</\
PercentageChange><AnnRange>71.85 - \
99.10</AnnRange><Earns>5.16</Earns><P-E>15.93</P-E><Name>INTL BUSINESS \
MAC</Name></Stock></StockQuotes>\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellLabelAutoDelete->False,
 ImageSize->{585, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3114]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGetString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializeXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/InitializeXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ReleaseXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7389],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "Tutorials",
 CellID->50522651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17129695],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->167962452]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XMLGet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 42.8124366}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "XMLGet[\"file\"] returns the XML expression tree corresponding to the \
contents of \" file\". XMLGet[\"file\", parser] uses the pre-initialized \
XMLParser object to parse the file. XMLGet[\"http:// url\", ...] reads from a \
URL. ", "synonyms" -> {}, "title" -> "XMLGet", "type" -> "Symbol", "uri" -> 
    "XML/ref/XMLGet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7720, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->664410894]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16795, 540}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2239, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2862, 82, 44, 1, 70, "ObjectName",
 CellID->13245],
Cell[2909, 85, 1229, 37, 70, "Usage",
 CellID->14726]
}, Open  ]],
Cell[CellGroupData[{
Cell[4175, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4653, 144, 408, 14, 70, "Notes",
 CellID->201],
Cell[5064, 160, 68, 1, 70, "Notes",
 CellID->6424],
Cell[5135, 163, 2548, 61, 70, "3ColumnTableMod",
 CellID->24083]
}, Closed]],
Cell[CellGroupData[{
Cell[7720, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->664410894],
Cell[CellGroupData[{
Cell[8105, 243, 148, 5, 70, "ExampleSection",
 CellID->442528467],
Cell[8256, 250, 124, 3, 70, "Input",
 CellID->7785466],
Cell[8383, 255, 53, 1, 70, "ExampleText",
 CellID->28752],
Cell[CellGroupData[{
Cell[8461, 260, 170, 5, 28, "Input",
 CellID->11324],
Cell[8634, 267, 169, 5, 36, "Output",
 CellID->19773]
}, Open  ]],
Cell[CellGroupData[{
Cell[8840, 277, 112, 4, 70, "Input",
 CellID->27740],
Cell[8955, 283, 338, 9, 70, "Print",
 CellID->18255]
}, Open  ]],
Cell[9308, 295, 151, 4, 70, "ExampleText",
 CellID->4468],
Cell[CellGroupData[{
Cell[9484, 303, 113, 3, 70, "Input",
 CellID->22070],
Cell[9600, 308, 1525, 41, 122, "Output",
 CellID->16843]
}, Open  ]],
Cell[11140, 352, 121, 3, 70, "ExampleDelimiter",
 CellID->10030],
Cell[11264, 357, 125, 3, 70, "Input",
 CellID->29127018],
Cell[11392, 362, 137, 4, 70, "ExampleText",
 CellID->15756],
Cell[CellGroupData[{
Cell[11554, 370, 225, 8, 70, "Input",
 CellID->10765],
Cell[11782, 380, 1346, 33, 190, "Output",
 CellID->3114]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13189, 420, 311, 9, 70, "SeeAlsoSection",
 CellID->28745],
Cell[13503, 431, 1004, 35, 70, "SeeAlso",
 CellID->6170]
}, Open  ]],
Cell[CellGroupData[{
Cell[14544, 471, 313, 9, 70, "TutorialsSection",
 CellID->7389],
Cell[14860, 482, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[15002, 487, 143, 3, 70, "Tutorials",
 CellID->50522651]
}, Open  ]],
Cell[CellGroupData[{
Cell[15182, 495, 318, 9, 70, "MoreAboutSection",
 CellID->17129695],
Cell[15503, 506, 137, 3, 70, "MoreAbout",
 CellID->167962452]
}, Open  ]],
Cell[15655, 512, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

