(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10178,        360]
NotebookOptionsPosition[      7635,        275]
NotebookOutlinePosition[      8921,        312]
CellTagsIndexPosition[      8837,        307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLGet" :> Documentation`HelpLookup["paclet:XML/ref/XMLGet"], 
          "XMLGetString" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGetString"], 
          "InitializeXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/InitializeXMLParser"], 
          "ReleaseXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/ReleaseXMLParser"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"XMLGet\"\>", 
       2->"\<\"XMLGetString\"\>", 3->"\<\"InitializeXMLParser\"\>", 
       4->"\<\"ReleaseXMLParser\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XMLParser", "ObjectName",
 CellID->27222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLParser", "[", 
       RowBox[{
        StyleBox["root", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a parser object created by ",
     Cell[BoxData[
      ButtonBox["InitializeXMLParser",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/InitializeXMLParser"]], "InlineFormula"],
     " for XML documents with a root element ",
     Cell[BoxData[
      StyleBox["root", "TI"]], "InlineFormula"],
     " and corresponding to the DTD ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An ",
 Cell[BoxData["XMLParser"], "InlineFormula"],
 " parser object can be used with ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 " to avoid reloading a DTD."
}], "Notes",
 CellID->553]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3730227],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->236449586],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->523550886],

Cell["Initialize a MathML parser (with a pre-loaded DTD):", "ExampleText",
 CellID->8490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathMLParser", "=", 
  RowBox[{"InitializeXMLParser", "[", 
   RowBox[{
   "\"\<math\>\"", ",", 
    "\"\<http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29648],

Cell[BoxData[
 RowBox[{"XMLParser", "[", 
  RowBox[{"\<\"math\"\>", 
   ",", "\<\"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\"\>"}], 
  "]"}]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28054]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/ReleaseXMLParser"]], "InlineFormula"],
 " frees up resources when the parser is done:"
}], "ExampleText",
 CellID->5517],

Cell[BoxData[
 RowBox[{"ReleaseXMLParser", "[", "mathMLParser", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24192]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8029],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGet",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGetString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializeXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/InitializeXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ReleaseXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26271],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XMLParser - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 43.2655732}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "XMLParser[root, \" file\"] represents a parser object created by \
InitializeXMLParser for XML documents with a root element root and \
corresponding to the DTD \" file\".", "synonyms" -> {}, "title" -> 
    "XMLParser", "type" -> "Symbol", "uri" -> "XML/ref/XMLParser"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4061, 134, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3730227]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8696, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1537, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2160, 64, 47, 1, 70, "ObjectName",
 CellID->27222],
Cell[2210, 67, 876, 25, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[3123, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3601, 114, 423, 15, 70, "Notes",
 CellID->553]
}, Closed]],
Cell[CellGroupData[{
Cell[4061, 134, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3730227],
Cell[CellGroupData[{
Cell[4444, 148, 148, 5, 70, "ExampleSection",
 CellID->236449586],
Cell[4595, 155, 126, 3, 70, "Input",
 CellID->523550886],
Cell[4724, 160, 89, 1, 70, "ExampleText",
 CellID->8490],
Cell[CellGroupData[{
Cell[4838, 165, 244, 8, 47, "Input",
 CellID->29648],
Cell[5085, 175, 282, 9, 36, "Output",
 CellID->28054]
}, Open  ]],
Cell[5382, 187, 236, 7, 70, "ExampleText",
 CellID->5517],
Cell[5621, 196, 119, 3, 70, "Input",
 CellID->24192]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5789, 205, 310, 9, 70, "SeeAlsoSection",
 CellID->8029],
Cell[6102, 216, 998, 35, 70, "SeeAlso",
 CellID->3128]
}, Open  ]],
Cell[CellGroupData[{
Cell[7137, 256, 314, 9, 70, "TutorialsSection",
 CellID->26271],
Cell[7454, 267, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[7608, 273, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

