(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74900,       2717]
NotebookOptionsPosition[     60523,       2192]
NotebookOutlinePosition[     62348,       2236]
CellTagsIndexPosition[     62305,       2233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Representing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/RepresentingXML"], 
          "Importing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"], 
          "Transforming XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/TransformingXML"], 
          "MathML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Representing XML\"\>", 3->"\<\"Importing XML\"\>", 
       4->"\<\"Transforming XML\"\>", 
       5->"\<\"MathML\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "ExportString" :> 
          Documentation`HelpLookup["paclet:ref/ExportString"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Automatic\"\>", 
       3->"\<\"Export\"\>", 4->"\<\"ExportString\"\>", 
       5->"\<\"None\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exporting XML", "Title",
 PageBreakAbove->True,
 CellID->23407],

Cell[CellGroupData[{

Cell["Functions for Exporting XML", "Section",
 CellID->22494],

Cell[CellGroupData[{

Cell["Export", "Subsection",
 CellID->9505],

Cell[TextData[{
 "You can export XML data from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the standard ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " function."
}], "Text",
 CellID->28440],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     RowBox[{
      StyleBox["file", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[
    "exports to a format determined by file extension", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     RowBox[{
      StyleBox["file", "TI"], ",", 
      StyleBox["expr", "TI"], ",", 
      StyleBox["format", "TI"]}], "]"}], Cell[
    "exports to a specific format", "TableText"]}
  }]], "DefinitionBox",
 CellID->20383],

Cell[TextData[{
 "The first argument of the function specifies the file to which the data \
should be exported. The second argument specifies the data to be exported. \
For exporting XML data, this can be a symbolic XML expression or any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. You can also specify an optional third argument to control the \
form of the output. For exporting XML data, the relevant file formats are ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["\"\<SVG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SVG"]], "InlineFormula"],
 "."
}], "Text",
 CellID->14262],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 " as the format, all expressions are exported as ExpressionML."
}], "MathCaption",
 CellID->21409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.xml\>\"", ",", 
   RowBox[{"x", "^", "2"}], ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28607],

Cell[BoxData["\<\"test.xml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"test", ".", "xml"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4360],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>2</Number>
 </Function>
</Expression>\
\>", "Print",
 CellLabel->"From In[2]:=",
 CellID->5471]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 " specified, the same expression is written out as MathML."
}], "MathCaption",
 CellID->11171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", 
   RowBox[{"x", "^", "2"}], ",", "\"\<MathML\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20654],

Cell[BoxData["\<\"test.mml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"test", ".", "mml"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11514],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
 CellLabel->"From In[4]:=",
 CellID->14523]
}, Open  ]],

Cell[TextData[{
 "With only two arguments, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " determines the export format based on the filename extension. ",
 StyleBox[".xml", "MR"],
 " is associated with XML. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["filename", "TI"], 
     StyleBox[".", "MR"], 
     StyleBox["xml", "MR"]}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["filename", "TI"], 
     StyleBox[".", "MR"], 
     StyleBox["xml", "MR"]}], ",", 
    StyleBox["expr", "TI"], ",", 
    ButtonBox["\"\<XML\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/XML"]}], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->21229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.xml\>\"", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->489],

Cell[BoxData["\<\"test.xml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->6766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"test", ".", "xml"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->17887],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>2</Number>
 </Function>
</Expression>\
\>", "Print",
 CellLabel->"From In[6]:=",
 CellID->29756]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox[".mml", "MR"],
 " extension is associated with MathML."
}], "MathCaption",
 CellID->26632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->7470],

Cell[BoxData["\<\"test.mml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->25739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"test", ".", "mml"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20666],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
 CellLabel->"From In[8]:=",
 CellID->8522]
}, Open  ]],

Cell[TextData[{
 "You can control details of the export process using options for ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "Text",
 CellID->7283],

Cell["\<\
Delete the test files created by evaluating the commands in this section.\
\>", "MathCaption",
 CellID->8160],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DeleteFile", "[", 
   RowBox[{"{", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Directory", "[", "]"}], "}"}], ",", "\"\<test.xml\>\""}], 
     "]"}], "}"}], "]"}], ";"}], "\n", 
 RowBox[{"DeleteFile", "[", 
  RowBox[{"{", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Directory", "[", "]"}], "}"}], ",", "\"\<test.mml\>\""}], 
    "]"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->17553]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExportString", "Subsection",
 CellID->24705],

Cell[TextData[{
 "You can convert ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions into XML strings using ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 "."
}], "Text",
 CellID->27091],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ExportString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExportString"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["format", "TI"]}], "]"}], Cell[
    "export to a string", "TableText"]}
  }]], "DefinitionBox",
 CellID->1259],

Cell[TextData[{
 "For exporting as XML, the relevant formats are ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["\"\<SVG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SVG"]], "InlineFormula"],
 "."
}], "Text",
 CellID->25386],

Cell["Produce a symbolic XML expression.", "MathCaption",
 CellID->31687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<root><child/></root>\>\"", ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->4629],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"child\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{534, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->42]
}, Open  ]],

Cell[TextData[{
 "If a symbolic XML expression is supplied as the first argument of ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 ", the output is ordinary XML."
}], "MathCaption",
 CellID->28317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"%", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->22045],

Cell[BoxData["\<\"<root>\\n <child/>\\n</root>\"\>"], "Output",
 ImageSize->{67, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->12356]
}, Open  ]],

Cell["\<\
If the first argument is some other type of expression, the output is \
ExpressionML.\
\>", "MathCaption",
 CellID->13388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\"\<some text\>\"", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->25452],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\\n    \
xmlns='http://www.wolfram.com/XML/'>\\n <String>some \
text</String>\\n</Expression>\"\>"], "Output",
 ImageSize->{515, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->3154]
}, Open  ]],

Cell[TextData[{
 "You can control details of the export process using",
 " ",
 "options for ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 "."
}], "Text",
 CellID->30466]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export Options", "Section",
 CellID->11833],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellID->27760],

Cell[TextData[{
 "Standard",
 " ",
 "options for ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " can be used for greater control over the export process. "
}], "Text",
 CellID->26919],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     RowBox[{
      StyleBox["file", "TI"], ",", 
      StyleBox["expr", "TI"], ",", 
      StyleBox["format", "TI"], ",", 
      RowBox[{
       StyleBox["option1", "TI"], "->", 
       StyleBox["value1", "TI"]}], ",", 
      RowBox[{
       StyleBox["option2", "TI"], "->", 
       StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["export to a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExportString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExportString"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["format", "TI"], ",", 
      RowBox[{
       StyleBox["option1", "TI"], "->", 
       StyleBox["value1", "TI"]}], ",", 
      RowBox[{
       StyleBox["option2", "TI"], "->", 
       StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["export to a string", "TableText"]}
  }]], "DefinitionBox",
 CellID->25631],

Cell["Options for exporting XML data.", "Text",
 CellID->6738],

Cell[TextData[Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->21267],

Cell[TextData[Cell[BoxData["\"\<AttributeQuoting\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->25776],

Cell[TextData[Cell[BoxData["\"\<CheckXML\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->21098],

Cell[TextData[Cell[BoxData["\"\<ElementFormatting\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->24314],

Cell[TextData[Cell[BoxData["\"\<Entities\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->16320],

Cell[TextData[Cell[BoxData["\"\<NamespacePrefixes\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->13053],

Cell[TextData[Cell[BoxData["\"\<PrefixCreation\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->24007]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Annotations\"", "Subsection",
 CellID->16469],

Cell[TextData[{
 "This option controls which annotations are added to the output XML. The \
value is a list whose elements can be any combination of ",
 Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 ". The order in the list is irrelevant. "
}], "Text",
 CellID->24216],

Cell[CellGroupData[{

Cell["\"XMLDeclaration\"", "Subsubsection",
 CellID->9722],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 " is one of the annotations, then an XML declaration, ",
 StyleBox["<?xml version=\"1.0\"?>", "MR"],
 ", is included in the header."
}], "MathCaption",
 CellID->19842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"x", ",", "\"\<XML\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DocumentHeader\>\"", ",", "\"\<XMLDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->29007],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\\n    \
xmlns='http://www.wolfram.com/XML/'>\\n \
<Symbol>x</Symbol>\\n</Expression>\"\>"], "Output",
 ImageSize->{417, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->15463]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"DOCTYPEDeclaration\"", "Subsubsection",
 CellID->26260],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 " is one of the annotations, then an XML document type declaration of the \
form ",
 StyleBox["<!DOCTYPE ", "MR"],
 StyleBox["... ", "TR"],
 StyleBox[">", "MR"],
 " appears in the header. This specifies the DTD for the XML application in \
which the output is written."
}], "MathCaption",
 CellID->30947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"x", ",", "\"\<XML\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DocumentHeader\>\"", ",", "\"\<DOCTYPEDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->13793],

Cell[BoxData["\<\"<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\\n    \
xmlns='http://www.wolfram.com/XML/'>\\n \
<Symbol>x</Symbol>\\n</Expression>\"\>"], "Output",
 ImageSize->{515, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->28630]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"DocumentHeader\"", "Subsubsection",
 CellID->18717],

Cell[TextData[{
 "With",
 " ",
 Cell[BoxData[
  RowBox[{"\"\<Annotations\>\"", " ", "->", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "\"\<DocumentHeader\>\"", ",", " ", "\"\<XMLDeclaration\>\"", ",", " ", 
     "\"\<DOCTYPEDeclaration\>\""}], "}"}]}]], "InlineFormula"],
 ",\nthe header automatically contains an XML declaration and a document type \
declaration for the DTD. "
}], "MathCaption",
 CellID->23043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"x", ",", "\"\<XML\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<DocumentHeader\>\"", ",", "\"\<XMLDeclaration\>\"", ",", 
      "\"\<DOCTYPEDeclaration\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->31376],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\\n    \
xmlns='http://www.wolfram.com/XML/'>\\n \
<Symbol>x</Symbol>\\n</Expression>\"\>"], "Output",
 ImageSize->{515, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->25314]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"],
 " does not contain ",
 Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
 ", the output has no header. This is true even if ",
 Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"],
 " contains other elements such as ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->16626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"x", ",", "\"\<XML\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<XMLDeclaration\>\"", ",", "\"\<DOCTYPEDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->17117],

Cell[BoxData["\<\"<Expression xmlns:mathematica='http://www.wolfram.com/XML/'\
\\n    xmlns='http://www.wolfram.com/XML/'>\\n \
<Symbol>x</Symbol>\\n</Expression>\"\>"], "Output",
 ImageSize->{417, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->1334]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<Annotations\>\"", "->", "\"\<DocumentHeader\>\""}]], 
  "InlineFormula"],
 " is useful for controlling the form of symbolic XML generated. Add an ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", "Document", "]"}]], 
  "InlineFormula"],
 " to the symbolic XML output."
}], "MathCaption",
 CellID->20620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`ExpressionToSymbolicMathML", "[", 
  RowBox[{
   RowBox[{"x", "+", "2"}], ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", "\"\<DocumentHeader\>\"", "}"}]}], ",", " ", 
   RowBox[{"\"\<Formats\>\"", "->", "\"\<PresentationMathML\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->14171],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"xmlns\"\>", 
       "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"mrow\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mi\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mo\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mn\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{438, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->26792]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{"\"\<Annotations\>\"", " ", "->", " ", 
   RowBox[{"{", "\"\<DocumentHeader\>\"", "}"}]}]], "InlineFormula"],
 " is not specified, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", "Document", "]"}]], 
  "InlineFormula"],
 " is omitted from the output."
}], "MathCaption",
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`ExpressionToSymbolicMathML", "[", 
  RowBox[{
   RowBox[{"x", "+", "2"}], ",", " ", 
   RowBox[{"\"\<Formats\>\"", "->", "\"\<PresentationMathML\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->19154],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", 
     "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"mrow\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mi\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mo\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mn\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}],
   "]"}]], "Output",
 ImageSize->{549, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->18866]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"AttributeQuoting\"", "Subsection",
 CellID->14693],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<AttributeQuoting\>\"", "'", Cell[
    "attribute values are enclosed by single quotes (default)", 
     "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], "\\\"", Cell[
    "attribute values are enclosed by double quotes", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.28], 
     Scaled[0.13], {
      Scaled[0.59]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->30664],

Cell["Values for \"AttributeQuoting\".", "Caption",
 CellID->23775],

Cell[TextData[{
 "The default setting, ",
 Cell[BoxData[
  RowBox[{"\"\<AttributeQuoting\>\"", "->", "\"\<'\>\""}]], "InlineFormula"],
 ",",
 " ",
 "ensures that there is no conflict with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, which are typically enclosed in double quotes. "
}], "MathCaption",
 CellID->13000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<foo\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<color\>\"", "\[Rule]", "\"\<blue\>\""}], "}"}], ",", 
     RowBox[{"{", "\"\<some data\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", 
   ",", 
   RowBox[{"\"\<AttributeQuoting\>\"", "\[Rule]", "\"\<'\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12212],

Cell[BoxData["\<\"<foo color='blue'>some data</foo>\"\>"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21100]
}, Open  ]],

Cell[TextData[{
 "To enclose attribute values in double quotes, set ",
 Cell[BoxData[
  RowBox[{"\"\<AttributeQuoting\>\"", "->", "\"\<\\\"\>\""}]], 
  "InlineFormula"],
 ". The double-quote character must be preceded by a forward slash to escape \
it. "
}], "MathCaption",
 CellID->7551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<foo\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<color\>\"", "\[Rule]", "\"\<blue\>\""}], "}"}], ",", 
     RowBox[{"{", "\"\<some data\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", 
   ",", 
   RowBox[{"\"\<AttributeQuoting\>\"", "\[Rule]", "\"\<\\\"\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25476],

Cell[BoxData["\<\"<foo color=\\\"blue\\\">some data</foo>\"\>"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6379]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"CheckXML\"", "Subsection",
 CellID->10943],

Cell["\<\
This option determines whether the symbolic XML expression being exported is \
first checked for errors.\
\>", "Text",
 CellID->17877],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<CheckXML\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "the file being exported is checked for errors (default)", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "the file being exported is not checked for errors", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->3789],

Cell["Values for \"CheckXML\".", "Caption",
 CellID->361],

Cell[TextData[{
 "Set this option to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if you are confident the symbolic XML is correct. "
}], "Text",
 CellID->11385],

Cell["Checking the XML for errors can cause processing delays.", "MathCaption",
 CellID->8272],

Cell[BoxData[
 RowBox[{
  RowBox[{"largeSymbolicXML", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<test.xml\>\"", ",", "\"\<XML\>\""}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[14]:=",
 CellID->11434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<myFile\>\"", ",", "largeSymbolicXML", ",", "\"\<XML\>\""}], 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->15144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"16.083333333333332`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->29561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{
    "\"\<myFile\>\"", ",", "largeSymbolicXML", ",", "\"\<XML\>\"", ",", 
     RowBox[{"\"\<CheckXML\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->25563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"13.766666666666666`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->14504]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<CheckXML\>\""], "InlineFormula"],
 " can be quite useful, since a small error may completely ruin the exported \
form of a large symbolic XML expression. With the option on, small errors can \
often be fixed."
}], "Text",
 CellID->12946],

Cell["\<\
Here the symbolic XML expression has an error, but it is fixed to give a \
reasonable result.\
\>", "MathCaption",
 CellID->23888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<myFile\>\"", ",", 
   RowBox[{"XMLElement", "[", "\"\<foo\>\"", "]"}], ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->20308],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLElement", "::", "\<\"argrx\"\>"}], ":", 
  " ", "\<\"\\!\\(XMLElement\\) called with \\!\\(1\\) arguments; \\!\\(3\\) \
arguments are expected.\"\>"}]], "Message", "MSG",
 CellLabel->"From In[17]:=",
 CellID->12157],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "::", "\<\"autoFix\"\>"}], ":", 
  " ", "\<\"There is an error in the SymbolicXML expression begin exported. \
An automated attempt has been made to fix the error, however the fix may \
yield XML different to that desired.  The function XML`SymbolicXMLErrors will \
detail the errors in the SymbolicXML expression.\"\>"}]], "Message", "MSG",
 CellLabel->"From In[17]:=",
 CellID->1430],

Cell[BoxData["\<\"myFile\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->5123]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", "myFile"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->6464],

Cell["<foo/>", "Print",
 CellLabel->"From In[18]:=",
 CellID->4074]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<CheckXML\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", nothing is output to the file."
}], "MathCaption",
 CellID->4346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<myFile\>\"", ",", 
   RowBox[{"XMLElement", "[", "\"\<foo\>\"", "]"}], ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<CheckXML\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->13837],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "::", "\<\"unrecov\"\>"}], ":", 
  " ", "\<\"An unrecoverable error occurred while exporting the \
symbolic\:f39fXML.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"From In[19]:=",
 CellID->1981],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->25318]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"ElementFormatting\"", "Subsection",
 CellID->26611],

Cell["\<\
This option controls how elements are indented in the XML file.\
\>", "Text",
 CellID->16292],

Cell[BoxData[GridBox[{
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["\<\
all child nodes of an element are indented and long lines are wrapped\
\>", "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no extra indentation is added", "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
elements with mixed content are not indented,while elements with element-only \
content are indented. (default)\
\>", "TableText"]},
   {
    StyleBox["fn", "TI"], Cell[
    "a user\[Hyphen]defined function", "TableText"]}
  }]], "DefinitionBox",
 CellID->17591],

Cell["Values for \"ElementFormatting\".", "Caption",
 CellID->3832],

Cell[TextData[{
 "An example using ",
 Cell[BoxData[
  RowBox[{"\"\<ElementFormatting\>\"", " ", "->", " ", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 StyleBox[".",
  FontFamily->"Times New Roman"]
}], "MathCaption",
 CellID->27123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<root\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<child\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", "\"\<b\>\""}], "}"}]}], "]"}], 
   ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<ElementFormatting\>\"", "\[Rule]", "All"}]}], "]"}]], "Input",\

 CellLabel->"In[20]:=",
 CellID->6461],

Cell[BoxData["\<\"<root>\\n a\\n <child/>\\n b\\n</root>\"\>"], "Output",
 ImageSize->{67, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->16991]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<p\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{
     "{", "\"\<This is a long paragraph. It is made of several sentences. It \
keeps going and going. It doesn't look very nice on one long line, but if its \
indented, its much easier to read.\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", 
   ",", 
   RowBox[{"\"\<ElementFormatting\>\"", "\[Rule]", "All"}]}], "]"}]], "Input",\

 CellLabel->"In[21]:=",
 CellID->31461],

Cell[BoxData["\<\"<p>\\n This is a long paragraph. It is made of several\\n \
sentences. It keeps going and going. It doesn&apos;t\\n look very nice on one \
long line, but if its\\n indented, its much easier to read.\\n</p>\"\>"], \
"Output",
 ImageSize->{375, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->27330]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<ElementFormatting\>\"", " ", "->", " ", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", no extra indentation is added."
}], "MathCaption",
 CellID->28498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<root\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<child\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", "\"\<b\>\""}], "}"}]}], "]"}], 
   ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<ElementFormatting\>\"", "\[Rule]", "None"}]}], "]"}]], "Input",\

 CellLabel->"In[22]:=",
 CellID->17369],

Cell[BoxData["\<\"<root>a<child/>b</root>\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->17291]
}, Open  ]],

Cell[TextData[{
 "W",
 StyleBox["ith",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  RowBox[{"\"\<ElementFormatting\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 StyleBox[", ",
  FontFamily->"Times New Roman",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["elem",
  FontVariations->{"CompatibilityType"->0}],
 "ents with mixed content (strings as content) are not indented, while \
elements with element-only content are indented."
}], "MathCaption",
 CellID->8400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<element-only\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<empty\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<string-only\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\"\<a string\>\"", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<mixed\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<a\>\"", ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\"\<empty\>\"", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "}"}]}], "]"}], ",", "\"\<b\>\""}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<element-only\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<empty\>\"", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}]}], "}"}]}], "]"}], 
   ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->14179],

Cell[BoxData["\<\"<element-only>\\n <empty/>\\n <string-only>a \
string</string-only>\\n <mixed>a<empty/>b</mixed>\\n <element-only>\\n  \
<empty/>\\n </element-only>\\n</element-only>\"\>"], "Output",
 ImageSize->{256, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->24117]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<ElementFormatting\>\"", " ", "->", " ", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", long strings are linewrapped. This can be used to produce output similar \
to HTML. On the other hand, ",
 Cell[BoxData[
  RowBox[{"ElementFormatting", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " produces one long line of text."
}], "MathCaption",
 CellID->2317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<p\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{
     "{", "\"\<This is a long paragraph. It is made of several sentences. It \
keeps going and going. It doesn't look very nice on one long line, but if its \
indented, its much easier to read.\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\""}],
   "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->19914],

Cell[BoxData["\<\"<p>This is a long paragraph. It is made of several \
sentences. It keeps going and going. It doesn&apos;t look very nice on one \
long line, but if its indented, its much easier to read.</p>\"\>"], "Output",
 ImageSize->{466, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->1595]
}, Open  ]],

Cell[TextData[{
 "Advanced users can also specify a function to determine formatting. The \
function is passed a two-element list, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["namespace", "TI"], ",", " ", 
    StyleBox["localName", "TI"]}], "}"}]], "InlineFormula"],
 ". The function should return ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " when indenting is wanted, ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " when no indenting is wanted, and ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " when the element-only content should be indented and mixed content should \
not be indented."
}], "MathCaption",
 CellID->1441],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myIndentFunction", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<indent\>\""}], "}"}], "]"}], ":=", 
   "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"myIndentFunction", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<noIndent\>\""}], "}"}], "]"}], ":=", 
   "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"myIndentFunction", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<autoIndent\>\""}], "}"}], "]"}], ":=", 
   "Automatic"}], ";"}]}], "Input",
 CellLabel->"In[25]:=",
 CellID->5936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<indent\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<noIndent\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<indent\>\"", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<autoIndent\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<autoIndent\>\"", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\"\<foo\>\"", "}"}]}], "]"}], "}"}]}], "]"}]}], 
      "}"}]}], "]"}], ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<ElementFormatting\>\"", "\[Rule]", "myIndentFunction"}]}], 
  "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->21867],

Cell[BoxData["\<\"<indent>\\n <noIndent><indent/></noIndent>\\n \
<autoIndent>\\n  <autoIndent>foo</autoIndent>\\n \
</autoIndent>\\n</indent>\"\>"], "Output",
 ImageSize->{221, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->7028]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Entities\"", "Subsection",
 CellID->31453],

Cell[TextData[{
 "When exporting XML documents, it is sometimes desirable to represent \
special characters using named character entities. ",
 Cell[BoxData["\"\<Entities\>\""], "InlineFormula"],
 " supports output of named character entities. "
}], "Text",
 CellID->27909],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<Entities\>\"", "\"\<HTML\>\"", Cell[
    "resolves entity names defined in HTML", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], "\"\<MathML\>\"", Cell[
    "resolves entity names defined in MathML", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    StyleBox["list",
     FontSlant->"Italic"], Cell[
    "a list of character replacement rules", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->13973],

Cell["Values for \"Entities\".", "Caption",
 CellID->17981],

Cell[TextData[{
 "You can also specify a list as the value of this option. For example, if \
you want to export both HTML and MathML entities, use ",
 Cell[BoxData[
  RowBox[{"\"\<Entities\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["\"\<HTML\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/format/HTML"], ",", 
     ButtonBox["\"\<MathML\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/format/MathML"]}], "}"}]}]], "InlineFormula"],
 ". If neither the ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 " settings are used, all characters are still output correctly in XML. \
However, they may be numeric entities or encoded in UTF-8."
}], "Text",
 CellID->11503],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 " setting to turn an \[Alpha] into the named character entity ",
 StyleBox["&alpha;", "MR"],
 "."
}], "MathCaption",
 CellID->26569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xmlString", "=", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<foo\>\"", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "\"\<\[Alpha]\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", 
    ",", 
    RowBox[{"\"\<Entities\>\"", "->", "\"\<HTML\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[29]:=",
 CellID->6816],

Cell[BoxData["\<\"<foo>&alpha;</foo>\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->1883]
}, Open  ]],

Cell["\<\
If you use your own list of character replacement rules to be used, you are \
also responsible for including some basic escaping required by XML. For \
example:\
\>", "Text",
 CellID->25367],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{"\"\<Entities\>\"", "->", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\"\<&\>\"", "->", "\"\<&amp;\>\""}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"\"\<<\>\"", "->", "\"\<&lt;\>\""}], ",", "\[IndentingNewLine]", 
    RowBox[{"\"\<>\>\"", "->", "\"\<&gt;\>\""}], ",", "\[IndentingNewLine]", 
    RowBox[{"\"\<\\\"\>\"", "->", "\"\<&quot;\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<'\>\"", "->", "\"\<&apos;\>\""}], ",", "\[IndentingNewLine]",
     
    RowBox[{"\"\<\!\(\*
StyleBox[\"h\", \"TR\"]\)\>\"", "->", "\"\<&lowerCaseH;\>\""}]}], 
   "\[IndentingNewLine]", "}"}]}]], "InlineFormula"]], "IndentedText",
 CellID->5385],

Cell[TextData[{
 "If you specify any value for ",
 Cell[BoxData["\"\<Entities\>\""], "InlineFormula"],
 ", ensure that appropriate entity declarations are present. For example, by \
using the ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 " setting, you can easily generate XML with HTML entities."
}], "Text",
 CellID->28402],

Cell["\<\
The Icelandic character \"thorn\" is exported as the corresponding character \
entity reference.\
\>", "MathCaption",
 CellID->5230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xmlString", "=", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<foo\>\"", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "\"\<\[Thorn]\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", 
    ",", 
    RowBox[{"\"\<Entities\>\"", "->", "\"\<HTML\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[31]:=",
 CellID->17157],

Cell[BoxData["\<\"<foo>&thorn;</foo>\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->28681]
}, Open  ]],

Cell["\<\
Here, the entity is not declared and the literal output is retained.\
\>", "MathCaption",
 CellID->15567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"xmlString", ",", " ", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->8310],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"nonFatalParseError\"\>"}], ":", 
  " ", "\<\"Entity 'thorn' was not found at Line: 1 Character: 13 in \
/tmp/m0000124091\"\>"}]], "Message", "MSG",
 CellLabel->"From In[32]:=",
 CellID->1866],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"foo\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"\[EntityStart]thorn\[EntityEnd]\"\>", "}"}]}], "]"}], 
   ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{409, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->3687]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"NamespacePrefixes\"", "Subsection",
 CellID->13171],

Cell[TextData[{
 "This option lets you generate XML markup with a specific namespace \
declaration and namespace prefixes. The option is specified in the form ",
 Cell[BoxData[
  RowBox[{"\"\<NamespacePrefixes\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["url", "TI"], " ", "->", " ", 
     StyleBox["prefix", "TI"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->3477],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<NamespacePrefix\>\""], "InlineFormula"],
 " to generate presentation markup with each MathML element having a \
namespace prefix ",
 StyleBox["\"mml\"", "MR"],
 " associated with the MathML namespace."
}], "MathCaption",
 CellID->31245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<test.mml\>\"", ",", 
     SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
     RowBox[{"\"\<Formats\>\"", "\[Rule]", "\"\<PresentationMathML\>\""}], 
     ",", 
     RowBox[{"\"\<NamespacePrefixes\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<http://www.w3.org/1998/Math/MathML\>\"", "\[Rule]", "\"\<m\>\""}],
        "}"}]}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->32764],

Cell[BoxData["\<\"test.mml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->6238]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"test", ".", "mml"}]}]], "Input",
 CellLabel->"In[34]:=",
 CellID->27671],

Cell["\<\
<m:math xmlns:m='http://www.w3.org/1998/Math/MathML'
    xmlns='http://www.w3.org/1998/Math/MathML'>
 <m:msup>
  <m:mi>x</m:mi>
  <m:mn>2</m:mn>
 </m:msup>
</m:math>\
\>", "Print",
 CellLabel->"From In[34]:=",
 CellID->2047]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"PrefixCreation\"", "Subsection",
 CellID->26115],

Cell["\<\
This option controls whether a namespace declaration should be automatically \
generated when exporting tags that have a namespace associated with them, but \
no namespace declaration is present in the symbolic XML.\
\>", "Text",
 CellID->4592],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<PrefixCreation\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
generates a namespace declaration for any elements that have a namespace \
prefix but no corresponding namespace declaration\
\>", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "does not generate a namespace declaration  for any element", 
     "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
generates a namespace declaration for any elements that have a namespace \
prefix in the form of a URL\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->27311],

Cell["Values for \"PrefixCreation\".", "Caption",
 CellID->32657],

Cell["A sample of symbolic XML. ", "MathCaption",
 CellID->1405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sxml", " ", "=", " ", 
  RowBox[{"XMLElement", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<http://www.mydoc.net/2001/XML\>\"", ",", "\"\<tag\>\""}], 
     "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "\"\<data\>\"", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://www.mydoc.net/2001/XML\"\>", ",", "\<\"tag\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "\<\"data\"\>", "}"}]}], "]"}]], "Output",
 ImageSize->{416, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7171]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<PrefixCreation\>\"", "->", "\"\<True\>\""}]], 
  "InlineFormula"],
 ", any namespace prefix generated has the form ",
 Cell[BoxData[
  StyleBox["nsi", "MR"]], "InlineFormula"],
 " , where ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is an index that starts at 0 and is incremented by 1 whenever another \
namespace is needed."
}], "MathCaption",
 CellID->20580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{"sxml", ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<PrefixCreation\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22740],

Cell[BoxData["\<\"<ns0:tag \
xmlns:ns0='http://www.mydoc.net/2001/XML'>data</ns0:tag>\"\>"], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22530]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<PrefixCreation\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a namespace declaration is automatically included only if the specified \
namespace has the form of a URL. "
}], "MathCaption",
 CellID->13675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<http://www.mydoc.net/2001/XML\>\"", ",", "\"\<tag\>\""}], 
      "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\"\<c\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<PrefixCreation\>\"", "\[Rule]", "Automatic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24320],

Cell[BoxData["\<\"<ns0:tag \
xmlns:ns0='http://www.mydoc.net/2001/XML'>c</ns0:tag>\"\>"], "Output",
 ImageSize->{438, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<mydoc\>\"", ",", "\"\<tag\>\""}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\"\<c\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<PrefixCreation\>\"", "\[Rule]", "Automatic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13377],

Cell[BoxData["\<\"<mydoc:tag>c</mydoc:tag>\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10998]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<PrefixCreation\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the namespace is literally used as a namespace prefix. "
}], "MathCaption",
 CellID->16586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{"sxml", ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<PrefixCreation\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21604],

Cell[BoxData["\<\"<http://www.mydoc.net/2001/XML:tag>c</http://www.mydoc.net/\
2001/XML:tag>\"\>"], "Output",
 ImageSize->{508, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->4489]
}, Open  ]],

Cell[TextData[{
 "The XML produced in this case is not meaningful because there is no \
namespace declaration of the form ",
 StyleBox["xmlns:", "MR"],
 StyleBox["prefix", "TI"],
 StyleBox[" = \"http://www.mydoc.net/2001/XML\"", "MR"],
 ". This is desirable when you are exporting the XML as a fragment to be \
enclosed in an outer piece of XML, for which the namespace has a binding. "
}], "Text",
 CellID->19631],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->370881992],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "RelatedTutorials",
 CellID->1866278227],

Cell[TextData[ButtonBox["Representing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/RepresentingXML"]], "RelatedTutorials",
 CellID->1368766954],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "RelatedTutorials",
 CellID->296442083],

Cell[TextData[ButtonBox["Transforming XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/TransformingXML"]], "RelatedTutorials",
 CellID->616508677],

Cell[TextData[ButtonBox["MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exporting XML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 43.6249574}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Tutorial", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "You can export XML data from Mathematica using the standard Export \
function. The first argument of the function specifies the file to which the \
data should be exported. The second argument specifies the data to be \
exported. For exporting XML data, this can be a symbolic XML expression or \
any other Mathematica expression. You can also specify an optional third \
argument to control the form of the output. For exporting XML data, the \
relevant file formats are \"XML\", \"ExpressionML\", \"MathML\", and \"SVG\". \
With \"XML\" as the format, all expressions are exported as ExpressionML.", 
    "synonyms" -> {}, "title" -> "Exporting XML", "type" -> "Tutorial", "uri" -> 
    "XML/tutorial/ExportingXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2072, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2697, 73, 69, 2, 70, "Title",
 PageBreakAbove->True,
 CellID->23407],
Cell[CellGroupData[{
Cell[2791, 79, 62, 1, 70, "Section",
 CellID->22494],
Cell[CellGroupData[{
Cell[2878, 84, 43, 1, 70, "Subsection",
 CellID->9505],
Cell[2924, 87, 280, 11, 70, "Text",
 CellID->28440],
Cell[3207, 100, 639, 21, 70, "DefinitionBox",
 CellID->20383],
Cell[3849, 123, 1030, 29, 70, "Text",
 CellID->14262],
Cell[4882, 154, 249, 8, 70, "MathCaption",
 CellID->21409],
Cell[CellGroupData[{
Cell[5156, 166, 180, 5, 28, "Input",
 CellID->28607],
Cell[5339, 173, 169, 5, 36, "Output",
 CellID->18038]
}, Open  ]],
Cell[CellGroupData[{
Cell[5545, 183, 111, 4, 70, "Input",
 CellID->4360],
Cell[5659, 189, 370, 13, 70, "Print",
 CellID->5471]
}, Open  ]],
Cell[6044, 205, 251, 8, 70, "MathCaption",
 CellID->11171],
Cell[CellGroupData[{
Cell[6320, 217, 183, 5, 70, "Input",
 CellID->20654],
Cell[6506, 224, 169, 5, 36, "Output",
 CellID->29947]
}, Open  ]],
Cell[CellGroupData[{
Cell[6712, 234, 112, 4, 70, "Input",
 CellID->11514],
Cell[6827, 240, 346, 18, 70, "Print",
 CellID->14523]
}, Open  ]],
Cell[7188, 261, 970, 35, 70, "MathCaption",
 CellID->21229],
Cell[CellGroupData[{
Cell[8183, 300, 158, 5, 70, "Input",
 CellID->489],
Cell[8344, 307, 168, 5, 36, "Output",
 CellID->6766]
}, Open  ]],
Cell[CellGroupData[{
Cell[8549, 317, 112, 4, 70, "Input",
 CellID->17887],
Cell[8664, 323, 371, 13, 70, "Print",
 CellID->29756]
}, Open  ]],
Cell[9050, 339, 125, 5, 70, "MathCaption",
 CellID->26632],
Cell[CellGroupData[{
Cell[9200, 348, 159, 5, 70, "Input",
 CellID->7470],
Cell[9362, 355, 169, 5, 36, "Output",
 CellID->25739]
}, Open  ]],
Cell[CellGroupData[{
Cell[9568, 365, 112, 4, 70, "Input",
 CellID->20666],
Cell[9683, 371, 345, 18, 70, "Print",
 CellID->8522]
}, Open  ]],
Cell[10043, 392, 231, 8, 70, "Text",
 CellID->7283],
Cell[10277, 402, 119, 3, 70, "MathCaption",
 CellID->8160],
Cell[10399, 407, 509, 17, 70, "Input",
 CellID->17553]
}, Open  ]],
Cell[CellGroupData[{
Cell[10945, 429, 50, 1, 70, "Subsection",
 CellID->24705],
Cell[10998, 432, 286, 11, 70, "Text",
 CellID->27091],
Cell[11287, 445, 324, 11, 70, "DefinitionBox",
 CellID->1259],
Cell[11614, 458, 645, 23, 70, "Text",
 CellID->25386],
Cell[12262, 483, 73, 1, 70, "MathCaption",
 CellID->31687],
Cell[CellGroupData[{
Cell[12360, 488, 168, 5, 70, "Input",
 CellID->4629],
Cell[12531, 495, 572, 18, 36, "Output",
 CellID->42]
}, Open  ]],
Cell[13118, 516, 281, 8, 70, "MathCaption",
 CellID->28317],
Cell[CellGroupData[{
Cell[13424, 528, 138, 4, 70, "Input",
 CellID->22045],
Cell[13565, 534, 190, 5, 71, "Output",
 CellID->12356]
}, Open  ]],
Cell[13770, 542, 132, 4, 70, "MathCaption",
 CellID->13388],
Cell[CellGroupData[{
Cell[13927, 550, 154, 4, 70, "Input",
 CellID->25452],
Cell[14084, 556, 419, 9, 122, "Output",
 CellID->3154]
}, Open  ]],
Cell[14518, 568, 254, 10, 70, "Text",
 CellID->30466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14821, 584, 49, 1, 70, "Section",
 CellID->11833],
Cell[CellGroupData[{
Cell[14895, 589, 50, 1, 70, "Subsection",
 CellID->27760],
Cell[14948, 592, 392, 15, 70, "Text",
 CellID->26919],
Cell[15343, 609, 1095, 35, 70, "DefinitionBox",
 CellID->25631],
Cell[16441, 646, 62, 1, 70, "Text",
 CellID->6738],
Cell[16506, 649, 103, 2, 70, "BulletedText",
 CellID->21267],
Cell[16612, 653, 108, 2, 70, "BulletedText",
 CellID->25776],
Cell[16723, 657, 100, 2, 70, "BulletedText",
 CellID->21098],
Cell[16826, 661, 109, 2, 70, "BulletedText",
 CellID->24314],
Cell[16938, 665, 100, 2, 70, "BulletedText",
 CellID->16320],
Cell[17041, 669, 109, 2, 70, "BulletedText",
 CellID->13053],
Cell[17153, 673, 106, 2, 70, "BulletedText",
 CellID->24007]
}, Open  ]],
Cell[CellGroupData[{
Cell[17296, 680, 53, 1, 70, "Subsection",
 CellID->16469],
Cell[17352, 683, 420, 10, 70, "Text",
 CellID->24216],
Cell[CellGroupData[{
Cell[17797, 697, 58, 1, 70, "Subsubsection",
 CellID->9722],
Cell[17858, 700, 253, 7, 70, "MathCaption",
 CellID->19842],
Cell[CellGroupData[{
Cell[18136, 711, 323, 8, 70, "Input",
 CellID->29007],
Cell[18462, 721, 333, 8, 105, "Output",
 CellID->15463]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18844, 735, 63, 1, 70, "Subsubsection",
 CellID->26260],
Cell[18910, 738, 394, 11, 70, "MathCaption",
 CellID->30947],
Cell[CellGroupData[{
Cell[19329, 753, 327, 8, 70, "Input",
 CellID->13793],
Cell[19659, 763, 387, 9, 105, "Output",
 CellID->28630]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20095, 778, 59, 1, 70, "Subsubsection",
 CellID->18717],
Cell[20157, 781, 432, 12, 70, "MathCaption",
 CellID->23043],
Cell[CellGroupData[{
Cell[20614, 797, 365, 9, 70, "Input",
 CellID->31376],
Cell[20982, 808, 412, 9, 122, "Output",
 CellID->25314]
}, Open  ]],
Cell[21409, 820, 482, 13, 70, "MathCaption",
 CellID->16626],
Cell[CellGroupData[{
Cell[21916, 837, 327, 8, 70, "Input",
 CellID->17117],
Cell[22246, 847, 306, 7, 88, "Output",
 CellID->1334]
}, Open  ]],
Cell[22567, 857, 425, 13, 70, "MathCaption",
 CellID->20620],
Cell[CellGroupData[{
Cell[23017, 874, 358, 9, 70, "Input",
 CellID->14171],
Cell[23378, 885, 1226, 35, 88, "Output",
 CellID->26792]
}, Open  ]],
Cell[24619, 923, 414, 14, 70, "MathCaption",
 CellID->8964],
Cell[CellGroupData[{
Cell[25058, 941, 249, 7, 70, "Input",
 CellID->19154],
Cell[25310, 950, 1021, 29, 71, "Output",
 CellID->18866]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26392, 986, 58, 1, 70, "Subsection",
 CellID->14693],
Cell[26453, 989, 785, 21, 70, "DefinitionBox3Col",
 CellID->30664],
Cell[27241, 1012, 67, 1, 70, "Caption",
 CellID->23775],
Cell[27311, 1015, 335, 11, 70, "MathCaption",
 CellID->13000],
Cell[CellGroupData[{
Cell[27671, 1030, 422, 12, 70, "Input",
 CellID->12212],
Cell[28096, 1044, 195, 5, 36, "Output",
 CellID->21100]
}, Open  ]],
Cell[28306, 1052, 288, 8, 70, "MathCaption",
 CellID->7551],
Cell[CellGroupData[{
Cell[28619, 1064, 425, 12, 70, "Input",
 CellID->25476],
Cell[29047, 1078, 200, 5, 36, "Output",
 CellID->6379]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29296, 1089, 50, 1, 70, "Subsection",
 CellID->10943],
Cell[29349, 1092, 144, 4, 70, "Text",
 CellID->17877],
Cell[29496, 1098, 764, 21, 70, "DefinitionBox3Col",
 CellID->3789],
Cell[30263, 1121, 57, 1, 70, "Caption",
 CellID->361],
Cell[30323, 1124, 235, 8, 70, "Text",
 CellID->11385],
Cell[30561, 1134, 94, 1, 70, "MathCaption",
 CellID->8272],
Cell[30658, 1137, 208, 7, 70, "Input",
 CellID->11434],
Cell[CellGroupData[{
Cell[30891, 1148, 229, 7, 70, "Input",
 CellID->15144],
Cell[31123, 1157, 254, 9, 36, "Output",
 CellID->29561]
}, Open  ]],
Cell[CellGroupData[{
Cell[31414, 1171, 293, 9, 70, "Input",
 CellID->25563],
Cell[31710, 1182, 254, 9, 36, "Output",
 CellID->14504]
}, Open  ]],
Cell[31979, 1194, 272, 6, 70, "Text",
 CellID->12946],
Cell[32254, 1202, 140, 4, 70, "MathCaption",
 CellID->23888],
Cell[CellGroupData[{
Cell[32419, 1210, 206, 6, 70, "Input",
 CellID->20308],
Cell[32628, 1218, 253, 6, 70, "Message",
 CellID->12157],
Cell[32884, 1226, 429, 8, 70, "Message",
 CellID->1430],
Cell[33316, 1236, 167, 5, 36, "Output",
 CellID->5123]
}, Open  ]],
Cell[CellGroupData[{
Cell[33520, 1246, 89, 3, 70, "Input",
 CellID->6464],
Cell[33612, 1251, 67, 2, 70, "Print",
 CellID->4074]
}, Open  ]],
Cell[33694, 1256, 260, 9, 70, "MathCaption",
 CellID->4346],
Cell[CellGroupData[{
Cell[33979, 1269, 262, 6, 70, "Input",
 CellID->13837],
Cell[34244, 1277, 282, 8, 70, "Message",
 CellID->1981],
Cell[34529, 1287, 161, 5, 36, "Output",
 CellID->25318]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34739, 1298, 59, 1, 70, "Subsection",
 CellID->26611],
Cell[34801, 1301, 103, 3, 70, "Text",
 CellID->16292],
Cell[34907, 1306, 726, 23, 70, "DefinitionBox",
 CellID->17591],
Cell[35636, 1331, 67, 1, 70, "Caption",
 CellID->3832],
Cell[35706, 1334, 290, 10, 70, "MathCaption",
 CellID->27123],
Cell[CellGroupData[{
Cell[36021, 1348, 536, 16, 70, "Input",
 CellID->6461],
Cell[36560, 1366, 200, 5, 105, "Output",
 CellID->16991]
}, Open  ]],
Cell[CellGroupData[{
Cell[36797, 1376, 529, 14, 70, "Input",
 CellID->31461],
Cell[37329, 1392, 372, 8, 122, "Output",
 CellID->27330]
}, Open  ]],
Cell[37716, 1403, 268, 9, 70, "MathCaption",
 CellID->28498],
Cell[CellGroupData[{
Cell[38009, 1416, 538, 16, 70, "Input",
 CellID->17369],
Cell[38550, 1434, 186, 5, 36, "Output",
 CellID->17291]
}, Open  ]],
Cell[38751, 1442, 672, 20, 70, "MathCaption",
 CellID->8400],
Cell[CellGroupData[{
Cell[39448, 1466, 1322, 36, 70, "Input",
 CellID->14179],
Cell[40773, 1504, 330, 7, 156, "Output",
 CellID->24117]
}, Open  ]],
Cell[41118, 1514, 549, 16, 70, "MathCaption",
 CellID->2317],
Cell[CellGroupData[{
Cell[41692, 1534, 460, 12, 70, "Input",
 CellID->19914],
Cell[42155, 1548, 352, 7, 71, "Output",
 CellID->1595]
}, Open  ]],
Cell[42522, 1558, 862, 26, 70, "MathCaption",
 CellID->1441],
Cell[43387, 1586, 591, 20, 70, "Input",
 CellID->5936],
Cell[CellGroupData[{
Cell[44003, 1610, 1022, 28, 70, "Input",
 CellID->21867],
Cell[45028, 1640, 287, 7, 122, "Output",
 CellID->7028]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45364, 1653, 50, 1, 70, "Subsection",
 CellID->31453],
Cell[45417, 1656, 273, 6, 70, "Text",
 CellID->27909],
Cell[45693, 1664, 772, 21, 70, "DefinitionBox3Col",
 CellID->13973],
Cell[46468, 1687, 59, 1, 70, "Caption",
 CellID->17981],
Cell[46530, 1690, 932, 26, 70, "Text",
 CellID->11503],
Cell[47465, 1718, 288, 10, 70, "MathCaption",
 CellID->26569],
Cell[CellGroupData[{
Cell[47778, 1732, 385, 11, 70, "Input",
 CellID->6816],
Cell[48166, 1745, 180, 5, 36, "Output",
 CellID->1883]
}, Open  ]],
Cell[48361, 1753, 200, 5, 70, "Text",
 CellID->25367],
Cell[CellGroupData[{
Cell[48586, 1762, 704, 15, 70, "IndentedText",
 CellID->5385],
Cell[49293, 1779, 409, 11, 70, "Text",
 CellID->28402],
Cell[49705, 1792, 142, 4, 70, "MathCaption",
 CellID->5230],
Cell[CellGroupData[{
Cell[49872, 1800, 386, 11, 70, "Input",
 CellID->17157],
Cell[50261, 1813, 181, 5, 36, "Output",
 CellID->28681]
}, Open  ]],
Cell[50457, 1821, 115, 3, 70, "MathCaption",
 CellID->15567],
Cell[CellGroupData[{
Cell[50597, 1828, 150, 4, 70, "Input",
 CellID->8310],
Cell[50750, 1834, 257, 6, 70, "Message",
 CellID->1866],
Cell[51010, 1842, 476, 15, 36, "Output",
 CellID->3687]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51547, 1864, 59, 1, 70, "Subsection",
 CellID->13171],
Cell[51609, 1867, 390, 11, 70, "Text",
 CellID->3477],
Cell[52002, 1880, 280, 8, 70, "MathCaption",
 CellID->31245],
Cell[CellGroupData[{
Cell[52307, 1892, 500, 14, 70, "Input",
 CellID->32764],
Cell[52810, 1908, 169, 5, 36, "Output",
 CellID->6238]
}, Open  ]],
Cell[CellGroupData[{
Cell[53016, 1918, 113, 4, 70, "Input",
 CellID->27671],
Cell[53132, 1924, 234, 10, 70, "Print",
 CellID->2047]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53415, 1940, 56, 1, 70, "Subsection",
 CellID->26115],
Cell[53474, 1943, 254, 5, 70, "Text",
 CellID->4592],
Cell[53731, 1950, 1142, 33, 70, "DefinitionBox3Col",
 CellID->27311],
Cell[54876, 1985, 65, 1, 70, "Caption",
 CellID->32657],
Cell[54944, 1988, 64, 1, 70, "MathCaption",
 CellID->1405],
Cell[CellGroupData[{
Cell[55033, 1993, 328, 10, 70, "Input",
 CellID->53],
Cell[55364, 2005, 377, 12, 36, "Output",
 CellID->7171]
}, Open  ]],
Cell[55756, 2020, 435, 14, 70, "MathCaption",
 CellID->20580],
Cell[CellGroupData[{
Cell[56216, 2038, 209, 5, 70, "Input",
 CellID->22740],
Cell[56428, 2045, 229, 6, 36, "Output",
 CellID->22530]
}, Open  ]],
Cell[56672, 2054, 352, 10, 70, "MathCaption",
 CellID->13675],
Cell[CellGroupData[{
Cell[57049, 2068, 448, 13, 70, "Input",
 CellID->24320],
Cell[57500, 2083, 226, 6, 36, "Output",
 CellID->25790]
}, Open  ]],
Cell[CellGroupData[{
Cell[57763, 2094, 417, 12, 70, "Input",
 CellID->13377],
Cell[58183, 2108, 186, 5, 36, "Output",
 CellID->10998]
}, Open  ]],
Cell[58384, 2116, 292, 9, 70, "MathCaption",
 CellID->16586],
Cell[CellGroupData[{
Cell[58701, 2129, 210, 5, 70, "Input",
 CellID->21604],
Cell[58914, 2136, 235, 6, 36, "Output",
 CellID->4489]
}, Open  ]],
Cell[59164, 2145, 414, 9, 70, "Text",
 CellID->19631],
Cell[CellGroupData[{
Cell[59603, 2158, 72, 1, 70, "RelatedTutorialsSection",
 CellID->370881992],
Cell[59678, 2161, 151, 3, 70, "RelatedTutorials",
 CellID->1866278227],
Cell[59832, 2166, 158, 3, 70, "RelatedTutorials",
 CellID->1368766954],
Cell[59993, 2171, 151, 3, 70, "RelatedTutorials",
 CellID->296442083],
Cell[60147, 2176, 157, 3, 70, "RelatedTutorials",
 CellID->616508677],
Cell[60307, 2181, 138, 3, 70, "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[60496, 2190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

