(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    123810,       4184]
NotebookOptionsPosition[    105178,       3511]
NotebookOutlinePosition[    107085,       3556]
CellTagsIndexPosition[    107042,       3553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Representing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/RepresentingXML"], 
          "Exporting XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ExportingXML"], 
          "Transforming XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/TransformingXML"], 
          "MathML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Representing XML\"\>", 3->"\<\"Exporting XML\"\>", 
       4->"\<\"Transforming XML\"\>", 
       5->"\<\"MathML\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"], "XMLGet" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGet"], "XMLGetString" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGetString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Import\"\>", 
       2->"\<\"ImportString\"\>", 3->"\<\"XMLGet\"\>", 
       4->"\<\"XMLGetString\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Importing XML", "Title",
 PageBreakAbove->True,
 CellID->7321],

Cell[CellGroupData[{

Cell["Functions for Importing XML", "Section",
 CellID->18319],

Cell[CellGroupData[{

Cell["Import", "Subsection",
 CellID->29881],

Cell[TextData[{
 "You can import XML data into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the standard ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " function, which has the following syntax. "
}], "Text",
 CellID->31626],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     StyleBox["file", "TI"], "]"}], Cell[
    "import format determined by file extension", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{
      StyleBox["file", "TI"], ",", 
      StyleBox["format", "TI"]}], "]"}], Cell[
    "import from a specific format", "TableText"]}
  }]], "DefinitionBox",
 CellID->13020],

Cell[TextData[{
 "The first argument specifies the file to be imported. You can also specify \
an optional second argument to control the form of the output. For importing \
XML data, the relevant file formats are ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1411],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 " as the import format, any XML formats that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not recognize are returned as a symbolic XML expression. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "does support ExpressionML and MathML on import. An ExpressionML file is \
imported as the corresponding cell expression. A MathML file is returned as \
the corresponding box expression. "
}], "Text",
 CellID->20454],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<XML\>\""], "InlineFormula"],
 " as the import format, even ExpressionML and MathML files are imported as \
symbolic XML. This overrides any interpretation beyond just importing as \
XML."
}], "Text",
 CellID->25893],

Cell["A simple MathML equation.", "MathCaption",
 CellID->21984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/eqn.mml\>\"", ",", "\"\<Text\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2357],

Cell[BoxData["\<\"<math xmlns=\\\"http://www.w3.org/1998/Math/MathML\\\">\\n \
<semantics>\\n  <msup>\\n   <mi>x</mi>\\n   <mn>2</mn>\\n  </msup>\\n  \
<annotation-xml encoding=\\\"MathML-Content\\\">\\n   <apply>\\n    \
<power/>\\n    <ci>x</ci>\\n    <cn type=\\\"integer\\\">2</cn>\\n   </apply>\
\\n  </annotation-xml>\\n </semantics>\\n</math>\\n\\n\"\>"], "Output",
 ImageSize->{347, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->476371990]
}, Open  ]],

Cell["\<\
Importing this file returns the equation as a box expression.\
\>", "MathCaption",
 CellID->30336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/eqn.mml\>\"", ",", "\"\<MathML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->18829],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"TagBox", "[", 
      RowBox[{
       RowBox[{"SuperscriptBox", "[", 
        RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
       ",", "\<\"MathMLPresentationTag\"\>", ",", 
       RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"\<\"AnnotationsTagWrapper\"\>", "[", 
      RowBox[{"TagBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
        ",", "\<\"MathMLContentTag\"\>", ",", 
        RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{544, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->686965399]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<XMLObject\>\""], "InlineFormula"],
 " specified as the Import element, the equation is imported as a symbolic \
XML expression."
}], "MathCaption",
 CellID->21457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/eqn.mml\>\"", ",", "\"\<XMLObject\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->32405],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"math\"\>", ",", 
      RowBox[{"\<\"System\"\>", 
       "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\
\\\\6.0\\\\SystemFiles\\\\IncludeFiles\\\\XML\\\\mathml2.dtd\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"xmlns\"\>", 
       "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"semantics\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"msup\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mi\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mn\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
          ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"annotation-xml\"\>", ",", 
            RowBox[{"{", 
             
             RowBox[{"\<\"encoding\"\>", 
              "\[Rule]", "\<\"MathML-Content\"\>"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"XMLElement", "[", 
              RowBox[{"\<\"apply\"\>", ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"power\"\>", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"ci\"\>", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"cn\"\>", ",", 
                   RowBox[{"{", 
                    RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                    "}"}], ",", 
                   RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}],
              "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{557, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->97487978]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " is used with only one argument, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes the data in the file based on its file extension. Any file with \
a ",
 StyleBox[".xml", "MR"],
 " extension is imported as XML. ExpressionML or MathML, formats supported by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the file will be interpreted in the appropriate way. All other XML \
formats are imported as symbolic XML. "
}], "Text",
 CellID->2334],

Cell[TextData[{
 "Import a file with the ",
 StyleBox[".mml", "MR"],
 " extension. "
}], "MathCaption",
 CellID->30049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/eqn.mml\>\"", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->19094],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"TagBox", "[", 
      RowBox[{
       RowBox[{"SuperscriptBox", "[", 
        RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
       ",", "\<\"MathMLPresentationTag\"\>", ",", 
       RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"\<\"AnnotationsTagWrapper\"\>", "[", 
      RowBox[{"TagBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
        ",", "\<\"MathMLContentTag\"\>", ",", 
        RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{544, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->124846248]
}, Open  ]],

Cell[TextData[{
 "Display the box expression as conventional mathematical notation using ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->31270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->30119],

Cell[GraphicsData["CompressedBitmap", "\<\
eJx9jcEOQDAMhrtNmMPi6uhpOHmIRSR2EIL3r3ZFkLCk7d+vf7vWb0M/+i10
vmoWPw+hW6t6WggZBQCOoiiBNJKK4RCp3jMkUniKqKlkEWjOiVBxCDeHy350
YGQHHpfYI2N5aZS8xXZ9dec2S6H5i6ofal///10AtQPlU4i7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//DisplayForm=",
 CellID->820504952]
}, Open  ]],

Cell[TextData[{
 "Control the details of the import process, such as how to treat whitespace, \
whether to recognize entities, or whether to validate against a DTD, by \
specifying options to ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "Text",
 CellID->29313]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImportString", "Subsection",
 CellID->15253],

Cell[TextData[{
 "Use the standard ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " function to import XML data from a string. "
}], "Text",
 CellID->16117],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ImportString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImportString"], "[", 
     RowBox[{
      StyleBox["string", "TI"], ",", 
      StyleBox["format", "TI"]}], "]"}], Cell[
    "import from a string using a specific format", "TableText"]}
  }]], "DefinitionBox",
 CellID->4977],

Cell[TextData[{
 "For importing XML data, the relevant file formats are: ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "."
}], "Text",
 CellID->19160],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["\"\<XML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XML"]], "InlineFormula"],
 " as the import format, any XML formats that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not recognize are returned as a symbolic XML expression."
}], "Text",
 CellID->21505],

Cell[TextData[{
 "A simple XML expression converted to symbolic XML using ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<person gender='male'><name>Joe Smith</name></person>\>\"", ",", 
   "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->24591],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"person\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"gender\"\>", "\[Rule]", "\<\"male\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"name\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "\<\"Joe Smith\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",",
    
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{531, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->247707228]
}, Open  ]],

Cell["\<\
An ExpressionML file is imported as the corresponding cell expression. A \
MathML file is returned as the corresponding box expression.\
\>", "Text",
 CellID->3576],

Cell[TextData[{
 "Importing a simple MathML expression. The MathML markup is automatically \
converted to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression. "
}], "MathCaption",
 CellID->4854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>\"", ",", "\"\<XML\>\""}],
   "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->20072],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"1\"\>"}], "}"}], 
      "]"}], ",", "\<\"MathMLPresentationTag\"\>", ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{520, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1392073110]
}, Open  ]],

Cell[TextData[{
 "Stop the automatic interpretation of imported files by specifying ",
 Cell[BoxData["\"\<XMLElement\>\""], "InlineFormula"],
 " as the Import element."
}], "MathCaption",
 CellID->23016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<XML\>\"", ",", "\"\<XMLElement\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->25050],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"mi\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"mo\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"mn\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{521, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->1767332991]
}, Open  ]],

Cell[TextData[{
 "Control the details of the import process, such as how to treat whitespace, \
whether to recognize entities, or whether to validate against a DTD, by \
specifying options to ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 "."
}], "Text",
 CellID->21945]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLGet", "Subsection",
 CellID->1852],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " function can be used to import an XML document as symbolic XML. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLGet",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGet"], "[", 
   StyleBox["file", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{
    StyleBox["file", "TI"], ",", "\"\<XML\>\""}], "]"}]], "InlineFormula"],
 ". The advantage of using ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " is that it can retrieve files posted at a URL. "
}], "Text",
 CellID->20747],

Cell["\<\
Retrieves stock quotes from a website and return the data as symbolic XML.\
\>", "MathCaption",
 CellID->32521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "[", 
   RowBox[{
   "$InstallationDirectory", " ", "<>", " ", 
    "\"\</Documentation/English/System/ExampleData/paintings.xml\>\""}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[24]:=",
 CellID->8061],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
     RowBox[{
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], ",", 
      RowBox[{"\<\"Encoding\"\>", "\[Rule]", "\<\"ISO8859-1\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"PAINTINGS\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"No.5, 1948\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Jackson Pollock\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1948\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$140,000,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Woman III\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Willem de Kooning\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1953\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$137,500,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Portrait of Adele Block-Bauer I\"\>", "}"}]}], 
            "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Gustav Klimt\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1907\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$135,000,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Portrait of Dr. Gachet\"\>", "}"}]}], "]"}], 
           ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Vincent van Gogh\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1890\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$82,500,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{
             "{", "\<\"Bal au moulin de la Galette, Montmartre\"\>", "}"}]}], 
            "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Pierre-Auguste Renoir\"\>", "}"}]}], "]"}], 
           ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1876\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$78,100,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{578, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->194275885]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " exists only in the ",
 Cell[BoxData["XML`Parser`"], "InlineFormula"],
 " context. You must use the full name of the function, ",
 Cell[BoxData["XML`Parser`XMLGet"], "InlineFormula"],
 ", when doing an evaluation. To use the function without the context name \
prefix, add the ",
 Cell[BoxData["XML`Parser`"], "InlineFormula"],
 " context to your context path."
}], "Text",
 CellID->20259],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " also accepts an optional second argument, which specifies a \
pre-initialized parser object. "
}], "Text",
 CellID->28366],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["XMLGet",
      BaseStyle->"Link",
      ButtonData->"paclet:XML/ref/XMLGet"], "[", 
     StyleBox["file", "TI"], ",", 
     StyleBox["xmlParserObject", "TI"], "]"}], Cell[
    "import using a pre-initialized parser", "TableText"]}
  }]], "DefinitionBox",
 CellID->2885],

Cell[TextData[{
 "Initializing the parser involves loading a DTD into memory either from a \
URL or a local file. This only needs to be done once in each kernel session. \
Subsequent references to the DTD are processed much faster. For more \
information on initializing the parser, see ",
 Cell[BoxData[
  ButtonBox["InitializeXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/InitializeXMLParser"]], "InlineFormula"],
 "."
}], "Text",
 CellID->14439],

Cell[TextData[{
 "You can also specify options ",
 Cell[BoxData["XMLGet"], "InlineFormula"],
 ". The options for ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " are the same as the ones for ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ". However, the syntax is slightly different. The",
 " ",
 "option can be specified directly in the ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " function, such that"
}], "Text",
 CellID->2718],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"], "[", 
  RowBox[{
   StyleBox["file", "TI"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->9107],

Cell["is equivalent to", "Text",
 CellID->5268]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"], "[", 
  RowBox[{
   StyleBox["file", "TI"], ",", "\"\<XML\>\"", ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->3554]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLGetString", "Subsection",
 CellID->32050],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 " function can be used to import an XML string as symbolic XML. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGetString"], "[", 
   StyleBox["string", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"], "[", 
   RowBox[{
    StyleBox["string", "TI"], ",", "\"\<XML\>\""}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->7432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  "\"\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>\"", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->13799],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mi\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mo\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mn\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->32020]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 " exists only in the ",
 Cell[BoxData["XML`Parser`"], "InlineFormula"],
 " context. Use the full name of the function, ",
 Cell[BoxData["XML`Parser`XMLGetString"], "InlineFormula"],
 ", when doing an evaluation. To use the function without the context name \
prefix, add the ",
 Cell[BoxData["XML`Parser`"], "InlineFormula"],
 " context to your context path."
}], "Text",
 CellID->16735],

Cell[TextData[{
 "The advantage of using ",
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 " is that it accepts a pre-initialized parser object as its second \
argument."
}], "Text",
 CellID->31098],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["XMLGetString",
      BaseStyle->"Link",
      ButtonData->"paclet:XML/ref/XMLGetString"], "[", 
     StyleBox["string", "TI"], ",", 
     StyleBox["xmlParserObject", "TI"], "]"}], Cell[
    "import from a string using a pre-initialized parser", "TableText"]}
  }]], "DefinitionBox",
 CellID->2792],

Cell[TextData[{
 "Initializing the parser involves loading a DTD into memory either from a \
URL or a local file. This only needs to be done once in each kernel session. \
Subsequent references to the DTD are processed much faster. For more \
information on initializing the parser, see ",
 Cell[BoxData[
  ButtonBox["InitializeXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/InitializeXMLParser"]], "InlineFormula"],
 "."
}], "Text",
 CellID->3916],

Cell[TextData[{
 "Load the XML package and then pre-initialize the parser, ",
 Cell[BoxData["XHTMLParser"], "InlineFormula"],
 ", according to the XHTML DTD located at the specified URI\:f3b5."
}], "MathCaption",
 CellID->26182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XHTMLParser", "=", 
  RowBox[{"XML`Parser`InitializeXMLParser", "[", 
   RowBox[{
   "\"\<html\>\"", ",", 
    "\"\<http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->19029],

Cell[BoxData[
 RowBox[{"XML`Parser`XMLParser", "[", 
  RowBox[{"\<\"html\"\>", 
   ",", "\<\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\>"}], 
  "]"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->25316]
}, Open  ]],

Cell[TextData[{
 "Import an XML string. The string is validated with respect to the DTD \
stored in ",
 Cell[BoxData["XHTMLParser"], "InlineFormula"],
 " by setting ",
 Cell[BoxData[
  RowBox[{"\"\<ValidateAgainstDTD\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{"Valid", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " in the output indicates that the input string was valid XML with respect \
to the XHTML DTD."
}], "MathCaption",
 CellID->3059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{
  "\"\<<html><head><title>test</title></head><body><p>Here is some \
text.</p></body></html>\>\"", ",", "XHTMLParser", ",", 
   RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->13758],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"html\"\>", ",", 
      RowBox[{"\<\"System\"\>", 
       "\[Rule]", \
"\<\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"html\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"head\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"title\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"test\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
       
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"body\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"p\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Here is some text.\"\>", "}"}]}], "]"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{571, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->4583]
}, Open  ]],

Cell[TextData[{
 "You can also specify options for ",
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 ". The options for ",
 Cell[BoxData[
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"]], "InlineFormula"],
 " are the same as those for ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 ". However, the syntax for is slightly different. The",
 " ",
 "option can be specified directly in the ",
 Cell[BoxData[
  ButtonBox["XMLGet",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGet"]], "InlineFormula"],
 " function such that"
}], "Text",
 CellID->22399],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLGetString",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/XMLGetString"], "[", 
  RowBox[{
   StyleBox["string", "TI"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->1135],

Cell["is equivalent to", "Text",
 CellID->8357]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"], "[", 
  RowBox[{
   StyleBox["string", "TI"], ",", "\"\<XML\>\"", ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->20070]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Entities and Validation", "Section",
 CellID->15271],

Cell["\<\
An XML document can contain any characters included in the Unicode character \
set.\
\>", "Text",
 CellID->22342],

Cell[TextData[{
 "When importing an XML document into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", all numeric Unicode character entity references are automatically \
resolved into the corresponding ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " character."
}], "MathCaption",
 CellID->17780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<hand>\n<card suit='&#9824;' value='2'/>\n<card suit='&#9825;' \
value='10'/>\n<card suit='&#9826;' value='6'/>\n<card suit='&#9827;' \
value='4'/>\n<card suit='&#9827;' value='5'/>\n</hand>\>\"", ",", 
   "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->13877],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"hand\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"card\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"suit\"\>", "\[Rule]", "\<\"\[SpadeSuit]\"\>"}], ",", 
           RowBox[{"\<\"value\"\>", "\[Rule]", "\<\"2\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"card\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"suit\"\>", "\[Rule]", "\<\"\[HeartSuit]\"\>"}], ",", 
           RowBox[{"\<\"value\"\>", "\[Rule]", "\<\"10\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"card\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"suit\"\>", "\[Rule]", "\<\"\[DiamondSuit]\"\>"}], ",",
            
           RowBox[{"\<\"value\"\>", "\[Rule]", "\<\"6\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"card\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"suit\"\>", "\[Rule]", "\<\"\[ClubSuit]\"\>"}], ",", 
           RowBox[{"\<\"value\"\>", "\[Rule]", "\<\"4\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"card\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"suit\"\>", "\[Rule]", "\<\"\[ClubSuit]\"\>"}], ",", 
           RowBox[{"\<\"value\"\>", "\[Rule]", "\<\"5\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{539, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->30406]
}, Open  ]],

Cell["\<\
Entities that are not built into XML are resolved according to the rules \
present in the DTD. \
\>", "MathCaption",
 CellID->28295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY WRI \\\"Wolfram \
Research, Inc.\\\">]>\n<root>&WRI;</root>\>\"", ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->17686],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"root\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT root (#PCDATA)*><!ENTITY WRI 'Wolfram \
Research, Inc.'>\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"Wolfram Research, Inc.\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{501, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->2403]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can also validate the XML data to ensure that it conforms to a content \
model defined by a DTD. If the document is well formed, a symbolic XML \
expression will be returned. If the document is not valid, warning messages \
will be issued and the document wrapper will indicate the invalid nature of \
the document with the option ",
 Cell[BoxData[
  RowBox[{"Valid", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->8252],

Cell[TextData[{
 "You can control the aspects of how entities are treated and whether the \
document is validated or not by using the options for ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "Text",
 CellID->15718]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import Options", "Section",
 CellID->23035],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellID->7285],

Cell[TextData[{
 "The standard options of ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " give you more control over the import process. The syntax for specifying \
an option is: "
}], "Text",
 CellID->28428],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"], "[", 
  RowBox[{
   StyleBox["file", "TI"], ",", " ", 
   RowBox[{
    StyleBox["option", "TI"], " ", "->", " ", 
    StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->16678],

Cell["The following options are available for importing XML data:", "Text",
 CellID->25960]
}, Open  ]],

Cell[TextData[Cell[BoxData["\"\<NormalizeWhitespace\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->101],

Cell[TextData[Cell[BoxData["\"\<AllowRemoteDTDAccess\>\""], \
"InlineFormula"]], "BulletedText",
 CellID->20949],

Cell[TextData[Cell[BoxData["\"\<AllowUnrecognizedEntities\>\""], \
"InlineFormula"]], "BulletedText",
 CellID->2364],

Cell[TextData[Cell[BoxData["\"\<ReadDTD\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->26385],

Cell[TextData[Cell[BoxData["\"\<ValidateAgainstDTD\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->27626],

Cell[TextData[Cell[BoxData["\"\<IncludeDefaultedAttributes\>\""], \
"InlineFormula"]], "BulletedText",
 CellID->17157],

Cell[TextData[Cell[BoxData["\"\<IncludeEmbeddedObjects\>\""], \
"InlineFormula"]], "BulletedText",
 CellID->2737],

Cell[TextData[Cell[BoxData["\"\<IncludeNamespaces\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->4841],

Cell[TextData[Cell[BoxData["\"\<PreserveCDATASections\>\""], \
"InlineFormula"]], "BulletedText",
 CellID->18938]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"NormalizeWhitespace\"", "Subsection",
 CellID->11593],

Cell["\<\
This option controls how whitespace is processed. Whitespace is defined as a \
space, tab, or newline character. \
\>", "Text",
 CellID->17096],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {
    StyleBox["\"\<NormalizeWhitespace\>\"",
     FontFamily->"Courier"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "all the whitespace inside an element is normalized (default)", 
     "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "all the whitespace in the original XML document is preserved", 
     "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
ignorable whitespace is removed and non-ignorable whitespace is preserved\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->31033],

Cell["Values for \"NormalizeWhitespace\".", "Caption",
 CellID->4493],

Cell[TextData[{
 "Normalizing whitespace means that all leading and trailing whitespace is \
stripped and any interior whitespace is reduced to a single whitespace \
character. ",
 Cell[BoxData[
  RowBox[{"\"\<NormalizeWhitespace\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is the default setting for this option."
}], "Text",
 CellID->29768],

Cell["\<\
Whitespace is ignorable when it occurs in places where character data is not \
permitted according to the content model specified by the DTD. The primary \
use of ignorable whitespace is to add indentation for formatting purposes.\
\>", "Text",
 CellID->27873],

Cell[TextData[{
 "Whitespace handling with the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<NormalizeWhitespace\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->29935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<foo>     a   b   </foo>\>\"", ",", " ", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->19109],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"foo\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"a b\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->30096]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<NormalizeWhitespace\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " preserves the whitespace as it appears in the original string."
}], "MathCaption",
 CellID->20381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<foo>     a   b   </foo>\>\"", ",", " ", "\"\<XML\>\"", ",", " ", 
   RowBox[{"\"\<NormalizeWhitespace\>\"", " ", "\[Rule]", " ", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->21561],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"foo\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"     a   b   \"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->25739]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{"\"\<NormalizeWhitespace\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is specified, pattern matching on the resulting symbolic XML expression \
may become problematic because of the intervening whitespace."
}], "Text",
 CellID->5584]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"AllowRemoteDTDAccess\"", "Subsection",
 CellID->25923],

Cell["\<\
This option controls whether the parser may access the network in order to \
retrieve DTDs.\
\>", "Text",
 CellID->28499],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<AllowRemoteDTDAccess\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
the parser will automatically access the network to retrieve DTDs\
\>", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
remote DTDs will not be retrieved, but local DTDs can still be used\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->16731],

Cell["Values for \"AllowRemoteDTDAccess\".", "Caption",
 CellID->11849],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{"\"\<AllowRemoteDTDAccess\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " and the document refers to a remote DTD, the parse will fail and an error \
message will be generated, unless the option ",
 Cell[BoxData["\"\<ReadDTD\>\""], "InlineFormula"],
 " is also set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25442]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"AllowUnrecognizedEntities\"", "Subsection",
 CellID->8606],

Cell["\<\
This option determines what the parser will do if undefined entity references \
are encountered in the XML document. \
\>", "Text",
 CellID->6850],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<AllowUnrecognizedEntities\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
any undefined entities are wrapped in special entity delimiter characters, \
and no error messages are reported\
\>", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], 
    StyleBox[Cell[
     "an error message is reported and the parse fails", "TableText"],
     SingleLetterItalics->False]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
an error message is reported for any unrecognized entity,and the entity is \
wrapped in special entity delimiter characters (default)\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->28287],

Cell["Values for \"AllowUnrecognizedEntities\".", "Caption",
 CellID->26040],

Cell[TextData[{
 "This contains an undefined entity called \[OpenCurlyQuote]dogs\
\[CloseCurlyQuote]. If",
 " ",
 Cell[BoxData["\"\<AllowUnrecognizedEntities\>\""], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then an error message is reported and the parse fails. "
}], "MathCaption",
 CellID->22769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats 'Himalayans'>]>\
\n<root>\n   &dogs;\n</root>\>\"", ",", "\"\<XML\>\"", ",", " ", 
   RowBox[{
   "\"\<AllowUnrecognizedEntities\>\"", " ", "\[Rule]", " ", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->9223],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"parseError\"\>"}], ":", 
  " ", "\<\"Entity 'dogs' was not found at Line: 1 Character: 88 in \
/tmp/m0000083951\"\>"}]], "Message", "MSG",
 CellLabel->"From In[17]:=",
 CellID->1588],

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "::", "\<\"probableDTDError\"\>"}], ":", 
  " ", "\<\"There was an error parsing the XML document.  This may be due to \
undeclared entities in the XML document, or an error loading the DTD.  Check \
that entities are correctly declared or use the \\\"AllowUnrecognizedEntities\
\\\"  option.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"From In[17]:=",
 CellID->16467],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->12083]
}, Open  ]],

Cell[TextData[{
 "With the default setting, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", an error message is reported, and the entity is wrapped in special entity \
delimiter characters. This does not interrupt the importing and parsing of \
the XML data."
}], "MathCaption",
 CellID->3400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats 'Himalayans'>]>\
\n<root>\n   &dogs;\n</root>\>\"", ",", "\"\<XML\>\"", ",", " ", 
   RowBox[{
   "\"\<AllowUnrecognizedEntities\>\"", " ", "\[Rule]", " ", "Automatic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->11158],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"nonFatalParseError\"\>"}], ":", 
  " ", "\<\"Entity 'dogs' was not found at Line: 1 Character: 88 in \
/tmp/m0000093951\"\>"}]], "Message", "MSG",
 CellLabel->"From In[18]:=",
 CellID->15606],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"root\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT root (#PCDATA)*><!ENTITY cats \
'Himalayans'>\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"\[EntityStart]dogs\[EntityEnd]\"\>", "}"}]}], "]"}], 
   ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{531, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->16938]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<AllowUnrecognizedEntities\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " any undefined entities are wrapped in special entity delimiter characters \
and no error messages are reported."
}], "MathCaption",
 CellID->19463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats 'Himalayans'>]>\
\n<root>\n   &dogs;\n</root>\>\"", ",", "\"\<XML\>\"", ",", 
   RowBox[{
   "\"\<AllowUnrecognizedEntities\>\"", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->20920],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"root\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT root (#PCDATA)*><!ENTITY cats \
'Himalayans'>\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"\[EntityStart]dogs\[EntityEnd]\"\>", "}"}]}], "]"}], 
   ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{531, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->18366]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"ReadDTD\"", "Subsection",
 CellID->15758],

Cell["\<\
This option determines whether an external DTD subset is read or not. The \
most important uses of a DTD are to define a content model for validation and \
to define character entities. \
\>", "Text",
 CellID->19685],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<ReadDTD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "external DTDs are read (default)", "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "external DTDs are ignored", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->9023],

Cell["Values for \"ReadDTD\".", "Caption",
 CellID->20229],

Cell[TextData[{
 "Since reading the DTD can directly affect the contents of the document, ",
 Cell[BoxData[
  RowBox[{"\"\<ReadDTD\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is the default setting. Setting ",
 Cell[BoxData[
  RowBox[{"\"\<ReadDTD\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " can improve the efficiency, but only make this change if you are certain \
that no information is required from the DTD."
}], "Text",
 CellID->19298],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"\"\<ReadDTD\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is the only way to prevent the parser from attempting to read the DTD. ",
 Cell[BoxData[
  RowBox[{"\"\<AllowRemoteDTDAccess\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " will prevent network access and ",
 Cell[BoxData[
  RowBox[{"\"\<ValidateAgainstDTD\>\"", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " will prevent validation from happening, but neither will prevent an error \
caused by the parser failing to read the DTD."
}], "Text",
 CellID->29356],

Cell[TextData[{
 Cell[BoxData["\"\<ReadDTD\>\""], "InlineFormula"],
 " is ignored if you are using a pre-initialized parser. For more information \
on pre-initialized parsers, see ",
 Cell[BoxData[
  ButtonBox["InitializeXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/InitializeXMLParser"]], "InlineFormula"],
 "."
}], "Text",
 CellID->5470]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"ValidateAgainstDTD\"", "Subsection",
 CellID->23175],

Cell["\<\
This option determines whether the XML document is validated or not. \
\>", "Text",
 CellID->24196],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<ValidateAgainstDTD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
a validation attempt will be made on import even if there is no DOCTYPE \
declaration in the XML document\
\>", "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "no validation attempt will be made on import", "TableText"]},
   {"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
a validation attempt will be made on import only if there is a DOCTYPE \
declaration in the XML document (default)\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->1683],

Cell["Values for \"ValidateAgainstDTD\".", "Caption",
 CellID->9988],

Cell[TextData[{
 "If the document is valid, the parser will set the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Document\>\"", "]"}]], 
  "InlineFormula"],
 " option ",
 Cell[BoxData[
  RowBox[{"\"\<Valid\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". If the document is invalid, the parser will generate validity error \
messages and will set ",
 Cell[BoxData[
  RowBox[{"\"\<Valid\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->7619],

Cell[TextData[{
 "Parse a document that is not valid by setting ",
 Cell[BoxData["\"\<ValidateAgainstDTD\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". The parser generates error messages."
}], "MathCaption",
 CellID->2946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "[", 
   RowBox[{
   "\"\<<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n]>\n<root>\n  <child/>\n\
</root>\>\"", ",", 
    RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->32190],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "::", "\<\"nonFatalParseError\"\>"}], 
  ":", " ", "\<\"No character data is allowed by content model at Line: 1 \
Character: 52\"\>"}]], "Message", "MSG",
 CellLabel->"From In[20]:=",
 CellID->8275],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "::", "\<\"nonFatalParseError\"\>"}], 
  ":", " ", "\<\"Unknown element 'child' at Line: 1 Character: 60\"\>"}]], \
"Message", "MSG",
 CellLabel->"From In[20]:=",
 CellID->2469],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "::", "\<\"nonFatalParseError\"\>"}], 
  ":", " ", "\<\"No character data is allowed by content model at Line: 1 \
Character: 61\"\>"}]], "Message", "MSG",
 CellLabel->"From In[20]:=",
 CellID->25519],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(XML`Parser`XMLGetString :: \
\\\"nonFatalParseError\\\"\\) will be suppressed during this \
calculation.\"\>"}]], "Message", "MSG",
 CellLabel->"From In[20]:=",
 CellID->14341],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}, 
 \"Valid\" -> False]\
\>", "Output",
 ImageSize->{266, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]//InputForm=",
 CellID->26197]
}, Open  ]],

Cell[TextData[{
 "If the document is valid, then no messages are generated and ",
 Cell[BoxData[
  RowBox[{"\"\<Valid\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is included in the output."
}], "MathCaption",
 CellID->8545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "[", 
   RowBox[{
   "\"\<<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n]>\n<root></root>\>\"", ",", 
    
    RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1654],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, {}], {}, \"Valid\" -> True]\
\>", "Output",
 ImageSize->{343, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]//InputForm=",
 CellID->7158]
}, Open  ]],

Cell[TextData[{
 "Parsing with ",
 Cell[BoxData["\"\<ValidateAgainstDTD\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " generates no error messages, nor does it add a ",
 Cell[BoxData["\"\<Valid\>\""], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Document\>\"", "]"}]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->14058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "[", 
   RowBox[{
   "\"\<<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n]>\n<root>\n  <child/>\n\
</root>\>\"", ",", 
    RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "False"}]}], "]"}], "//",
   "InputForm"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->5794],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}]\
\>", "Output",
 ImageSize->{259, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]//InputForm=",
 CellID->23791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "[", 
   RowBox[{
   "\"\<<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n]>\n<root></root>\>\"", ",", 
    
    RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "False"}]}], "]"}], "//",
   "InputForm"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->13341],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, {}], {}]\
\>", "Output",
 ImageSize->{231, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]//InputForm=",
 CellID->24837]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<ValidateAgainstDTD\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", validation is attempted even if there is no DOCTYPE declaration."
}], "MathCaption",
 CellID->28900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"\"\<<root/>\>\"", ",", 
   RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->13232],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "::", "\<\"nonFatalParseError\"\>"}], 
  ":", " ", "\<\"Unknown element 'root' at Line: 1 Character: 8\"\>"}]], \
"Message", "MSG",
 CellLabel->"From In[24]:=",
 CellID->12675],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGetString", "::", "\<\"nonFatalParseError\"\>"}], 
  ":", " ", "\<\"Root element different from DOCTYPE at Line: 1 Character: \
8\"\>"}]], "Message", "MSG",
 CellLabel->"From In[24]:=",
 CellID->19736],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->17438]
}, Open  ]],

Cell[TextData[{
 "For validation only when there is a DOCTYPE Declaration, use",
 " ",
 Cell[BoxData[
  RowBox[{"\"\<ValidateAgainstDTD\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". When no DTD is specified, the parser does not attempt to validate the XML \
string."
}], "MathCaption",
 CellID->9958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<root/>\>\"", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->30580],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->27085]
}, Open  ]],

Cell["\<\
Here the parser tries to validate the input string because a DTD is specified \
explicitly. \
\>", "MathCaption",
 CellID->15013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ImportString", "[", 
   RowBox[{
   "\"\<<!DOCTYPE root [<!ELEMENT root EMPTY>]>\n<root>\n  <child/>\n\
</root>\>\"", ",", "\"\<XML\>\""}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->5284],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"nonFatalParseError\"\>"}], ":", 
  " ", "\<\"No character data is allowed by content model at Line: 1 \
Character: 50 in /tmp/m0000123951\"\>"}]], "Message", "MSG",
 CellLabel->"From In[26]:=",
 CellID->5253],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"nonFatalParseError\"\>"}], ":", 
  " ", "\<\"Unknown element 'child' at Line: 1 Character: 58 in \
/tmp/m0000123951\"\>"}]], "Message", "MSG",
 CellLabel->"From In[26]:=",
 CellID->20727],

Cell[BoxData[
 RowBox[{
  RowBox[{"XML`Parser`XMLGet", "::", "\<\"nonFatalParseError\"\>"}], ":", 
  " ", "\<\"No character data is allowed by content model at Line: 1 \
Character: 59 in /tmp/m0000123951\"\>"}]], "Message", "MSG",
 CellLabel->"From In[26]:=",
 CellID->30285],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(XML`Parser`XMLGet :: \
\\\"nonFatalParseError\\\"\\) will be suppressed during this \
calculation.\"\>"}]], "Message", "MSG",
 CellLabel->"From In[26]:=",
 CellID->2426],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \"<!ELEMENT root EMPTY>\"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}, 
 \"Valid\" -> False]\
\>", "Output",
 ImageSize->{266, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]//InputForm=",
 CellID->19670]
}, Open  ]],

Cell[TextData[{
 "Even when using a pre-initialized parser, ",
 Cell[BoxData[
  RowBox[{"\"\<ValidateAgainstDTD\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " will not validate unless there is a DOCTYPE declaration in the document."
}], "Text",
 CellID->14536]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"IncludeDefaultedAttributes\"", "Subsection",
 CellID->3281],

Cell[TextData[{
 "This option determines whether attributes that are specified by the DTD as \
default attributes are included in the symbolic XML expression. ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeDefaultedAttributes\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is the default setting because the default values for attributes are known \
to application developers and it is unnecessary to include the values in the \
symbolic XML expression. Setting ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeDefaultedAttributes\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " will include the values."
}], "Text",
 CellID->23370],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<IncludeDefaultedAttributes\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
default attributes in the DTD are included in the symbolic XML expression\
\>", "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "default attributes are not included (default)", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->6549],

Cell["Values for \"IncludeDefaultedAttributes\".", "Caption",
 CellID->1348],

Cell["Assign a variable to represent the XML fragment. ", "MathCaption",
 CellID->9077],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "xmlString", "=", 
   "\"\<<!DOCTYPE test [<!ELEMENT test EMPTY>\n<!ATTLIST test\n\
\\tMovie\\t\\tCDATA\\t#FIXED\\t\\\"The Lord of The Rings.\\\"\n>]>\n<test/>\>\
\""}], ";"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->26199],

Cell["Convert the XML fragment into symbolic XML.", "MathCaption",
 CellID->16835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"xmlString", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->3573],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"test\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT test EMPTY> <!ATTLIST test \\tMovie CDATA \
#FIXED 'The Lord of The Rings.' >\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"test\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{529, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->28137]
}, Open  ]],

Cell[TextData[{
 "To include default attributes in the imported symbolic XML, set ",
 Cell[BoxData["\"\<IncludeDefaultedAttributes\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->8351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"xmlString", ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<IncludeDefaultedAttributes\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->28731],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"test\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT test EMPTY> <!ATTLIST test \\tMovie CDATA \
#FIXED 'The Lord of The Rings.' >\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"test\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Movie\"\>", "\[Rule]", "\<\"The Lord of The Rings.\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{529, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->27617]
}, Open  ]],

Cell[TextData[{
 "Including default attributes in the expression is not the same as \
validation; thus, they can be included even with ",
 Cell[BoxData[
  RowBox[{"\"\<ValidateAgainstDTD\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->5233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"xmlString", ",", "\"\<XML\>\"", ",", 
   RowBox[{"\"\<IncludeDefaultedAttributes\>\"", "\[Rule]", "True"}], ",", 
   RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->30571],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"test\"\>", ",", 
      RowBox[{"\<\"InternalSubset\"\>", 
       "\[Rule]", "\<\"<!ELEMENT test EMPTY> <!ATTLIST test \\tMovie CDATA \
#FIXED 'The Lord of The Rings.' >\"\>"}]}], "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"test\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Movie\"\>", "\[Rule]", "\<\"The Lord of The Rings.\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{529, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->27376]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"IncludeEmbeddedObjects\"", "Subsection",
 CellID->25529],

Cell["\<\
This option determines the treatment of comments and processing instructions \
that occur inside the document tree. \
\>", "Text",
 CellID->17731],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<IncludeEmbeddedObjects\>\"", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["\<\
all the embedded objects will be included in the document tree\
\>", "TableText"]},
   {"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no embedded objects are included (default)", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    StyleBox["Comments",
     FontFamily->"Courier"], 
    RowBox[{"only", " ", 
     StyleBox["embedded",
      SingleLetterItalics->False], 
     StyleBox[" ",
      SingleLetterItalics->False], 
     StyleBox["comments",
      SingleLetterItalics->False], 
     StyleBox[" ",
      SingleLetterItalics->False], 
     StyleBox["are",
      SingleLetterItalics->False], 
     StyleBox[" ",
      SingleLetterItalics->False], 
     StyleBox["included",
      SingleLetterItalics->False]}]},
   {"", "ProcessingInstructions", Cell[
    "only embedded processing instructions are included", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->11044],

Cell["Values for \"IncludeEmbeddedObjects\".", "Caption",
 CellID->20342],

Cell["\<\
Set a variable to represent a simple XML fragment to facilitate further \
examples.\
\>", "MathCaption",
 CellID->30000],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "xmlexample", " ", "=", " ", 
   "\"\<<!--Comment-->\n<?Instruction?>\n<root>\n<blank/>\n</root>\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->7528],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<IncludeEmbeddedObjects\>\"", " ", "->", " ", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " includes all the embedded objects in the document tree."
}], "MathCaption",
 CellID->30916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlexample", ",", " ", 
   RowBox[{"\"\<IncludeEmbeddedObjects\>\"", "\[Rule]", " ", "All"}]}], 
  "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->12634],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Comment\"\>", "]"}], 
      "[", "\<\"Comment\"\>", "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"ProcessingInstruction\"\>", "]"}], 
      "[", "\<\"Instruction\"\>", "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"blank\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->4999]
}, Open  ]],

Cell[TextData[{
 "The default setting of ",
 Cell[BoxData["\"\<IncludeEmbeddedObjects\>\""], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " since comments and processing instructions are not intended to affect \
applications using the XML document. Including them may hamper pattern \
matching. "
}], "MathCaption",
 CellID->17757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlexample", ",", " ", 
   RowBox[{"\"\<IncludeEmbeddedObjects\>\"", " ", "\[Rule]", " ", "None"}]}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->29240],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Comment\"\>", "]"}], 
      "[", "\<\"Comment\"\>", "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"ProcessingInstruction\"\>", "]"}], 
      "[", "\<\"Instruction\"\>", "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"blank\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->581]
}, Open  ]],

Cell[TextData[{
 "Using the ",
 Cell[BoxData["\"\<ProcessingInstructions\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<Comments\>\""], "InlineFormula"],
 " settings will include only the embedded processing instructions or \
comments, respectively. Setting ",
 Cell[BoxData["\"\<IncludeEmbeddedObjects\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Comments\>\"", ",", " ", "\"\<ProcessingInstructions\>\""}], 
   "}"}]], "InlineFormula"],
 " includes a list of the embedded comments and processing instructions."
}], "MathCaption",
 CellID->13623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlexample", ",", 
   RowBox[{
   "\"\<IncludeEmbeddedObjects\>\"", "\[Rule]", 
    "\"\<ProcessingInstructions\>\""}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->15941],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Comment\"\>", "]"}], 
      "[", "\<\"Comment\"\>", "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"ProcessingInstruction\"\>", "]"}], 
      "[", "\<\"Instruction\"\>", "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"blank\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->7131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlexample", ",", 
   RowBox[{
   "\"\<IncludeEmbeddedObjects\>\"", "\[Rule]", "\"\<Comments\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->15749],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Comment\"\>", "]"}], 
      "[", "\<\"Comment\"\>", "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"ProcessingInstruction\"\>", "]"}], 
      "[", "\<\"Instruction\"\>", "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"blank\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->31539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlexample", ",", 
   RowBox[{"\"\<IncludeEmbeddedObjects\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Comments\>\"", ",", "\"\<ProcessingInstructions\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->9299],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Comment\"\>", "]"}], 
      "[", "\<\"Comment\"\>", "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"ProcessingInstruction\"\>", "]"}], 
      "[", "\<\"Instruction\"\>", "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"blank\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->25575]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"IncludeNamespaces\"", "Subsection",
 CellID->4099],

Cell["This option determines how namespaces are handled.", "Text",
 CellID->14363],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<IncludeNamespaces\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
specifies the explicit namespace for each element and attribute\
\>", "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "no namespace information is reported", "TableText"]},
   {"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the namespace is determined by scoping (default)", "TableText"]},
   {"", "Unparsed", Cell["\<\
used for handling documents that use namespaces in a non-standard way\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->13245],

Cell["Values for \"IncludeNamespaces\".", "Caption",
 CellID->14726],

Cell["\<\
Set a variable to represent a simple XML fragment with namespaces.\
\>", "Text",
 CellID->201],

Cell["\<\
<root xmlns=\"http://mynamespace.com\"
     xmlns:same=\"http://mynamespace.com\"
     xmlns:foo=\"http://anothernamespace.com\">
     <child attr1=\"a\"  same:attr2=\"b\"  foo:attr3=\"c\"/>
     <foo:child/>
     <same:child/>
</root>\
\>", "Program",
 CellID->6424],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "xmlString", "=", 
   "\"\<<root xmlns='http://mynamespace.com'\n     \
xmlns:same='http://mynamespace.com\\'\n    \
xmlns:foo='http://anothernamespace.com'>\n    <child attr1='a'  \
same:attr2='b'  foo:attr3='c'/>\n    <foo:child/>\n    <same:child/>\n</root>\
\>\""}], ";"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->24083],

Cell[CellGroupData[{

Cell["True", "Subsubsection",
 CellID->7389],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<IncludeNamespaces\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " reports the namespace information for each element and attribute via a \
list, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["namespace", "TI"], ",", " ", 
    StyleBox["localname", "TI"]}], "}"}]], "InlineFormula"],
 ". This form is more verbose, but more faithful to the data model of the XML \
document. This form may also be easier to use for pattern matching."
}], "Text",
 CellID->20735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlString", ",", 
   RowBox[{"\"\<IncludeNamespaces\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",\

 CellLabel->"In[38]:=",
 CellID->22024],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://mynamespace.com\"\>", ",", "\<\"root\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://mynamespace.com\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"same\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://mynamespace.com\\\\\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"foo\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://anothernamespace.com\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"http://mynamespace.com\"\>", ",", "\<\"child\"\>"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"\"\>", ",", "\<\"attr1\"\>"}], "}"}], 
            "\[Rule]", "\<\"a\"\>"}], ",", 
           RowBox[{
            RowBox[{"{", 
             
             RowBox[{"\<\"http://mynamespace.com\\\\\"\>", 
              ",", "\<\"attr2\"\>"}], "}"}], "\[Rule]", "\<\"b\"\>"}], ",", 
           RowBox[{
            RowBox[{"{", 
             
             RowBox[{"\<\"http://anothernamespace.com\"\>", 
              ",", "\<\"attr3\"\>"}], "}"}], "\[Rule]", "\<\"c\"\>"}]}], 
          "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\<\"http://anothernamespace.com\"\>", 
           ",", "\<\"child\"\>"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\<\"http://mynamespace.com\\\\\"\>", 
           ",", "\<\"child\"\>"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{494, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->18895]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["False", "Subsubsection",
 CellID->28745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<IncludeNamespaces\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " only reports the local name of each element or attribute. This setting \
makes the symbolic XML expression easier to read, but restrict use of it for \
applications with only a single namespace. The names of all the child \
elements appear to be identical when parsed this way, so this option value \
cannot be trusted whenever multiple namespaces are used."
}], "Text",
 CellID->6170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlString", ",", 
   RowBox[{"\"\<IncludeNamespaces\>\"", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->11483],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"http://mynamespace.com\"\>"}],
        ",", 
       RowBox[{"\<\"same\"\>", 
        "\[Rule]", "\<\"http://mynamespace.com\\\\\"\>"}], ",", 
       RowBox[{"\<\"foo\"\>", 
        "\[Rule]", "\<\"http://anothernamespace.com\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"child\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"attr1\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
           RowBox[{"\<\"attr2\"\>", "\[Rule]", "\<\"b\"\>"}], ",", 
           RowBox[{"\<\"attr3\"\>", "\[Rule]", "\<\"c\"\>"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"child\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"child\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{505, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->28717]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic", "Subsubsection",
 CellID->28392],

Cell[TextData[{
 "With the default value ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeNamespaces\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the namespace is determined by means of scoping. If the namespace of an \
element is the same as the default namespace, then the name is represented as \
a single string for the local name. If the namespace of an element is \
different, then the name is represented by a list with the structure ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["namespace", "TI"], ",", " ", 
    StyleBox["localname", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28752],

Cell[TextData[{
 "For example, the only element whose name is represented by a two-string \
list is the one in namespace ",
 StyleBox["http://anothernamespace.com", "MR"],
 ". The other elements are implicitly contained in the ",
 StyleBox["http://mynamespace.com", "MR"],
 " namespace. Attributes are not compacted since, according to the W3C \
specification, the attributes and the elements have different namespace \
scoping."
}], "Text",
 CellID->11324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", "xmlString", "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->19773],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://mynamespace.com\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"same\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://mynamespace.com\\\\\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"foo\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://anothernamespace.com\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"child\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"attr1\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
           RowBox[{
            RowBox[{"{", 
             
             RowBox[{"\<\"http://mynamespace.com\\\\\"\>", 
              ",", "\<\"attr2\"\>"}], "}"}], "\[Rule]", "\<\"b\"\>"}], ",", 
           RowBox[{
            RowBox[{"{", 
             
             RowBox[{"\<\"http://anothernamespace.com\"\>", 
              ",", "\<\"attr3\"\>"}], "}"}], "\[Rule]", "\<\"c\"\>"}]}], 
          "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\<\"http://anothernamespace.com\"\>", 
           ",", "\<\"child\"\>"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\<\"http://mynamespace.com\\\\\"\>", 
           ",", "\<\"child\"\>"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{494, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->27740]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unparsed", "Subsubsection",
 CellID->18255],

Cell[TextData[{
 "Some documents use names in a non-namespace-compliant fashion, because the \
XML namespace recommendation, which extends XML, was made after the initial \
XML recommendation. ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeNamespaces\>\"", "->", "\"\<Unparsed\>\""}]], 
  "InlineFormula"],
 " is provided to allow parsing of these documents. The name is always \
represented as the exact single string that appears in the XML file. Unless \
absolutely necessary, this option value should not be used."
}], "Text",
 CellID->4468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`Parser`XMLGetString", "[", 
  RowBox[{"xmlString", ",", 
   RowBox[{"\"\<IncludeNamespaces\>\"", "\[Rule]", "\"\<Unparsed\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->22070],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"root\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"http://mynamespace.com\"\>"}],
        ",", 
       RowBox[{"\<\"xmlns:same\"\>", 
        "\[Rule]", "\<\"http://mynamespace.com\\\\\"\>"}], ",", 
       RowBox[{"\<\"xmlns:foo\"\>", 
        "\[Rule]", "\<\"http://anothernamespace.com\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"child\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"attr1\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
           RowBox[{"\<\"same:attr2\"\>", "\[Rule]", "\<\"b\"\>"}], ",", 
           RowBox[{"\<\"foo:attr3\"\>", "\[Rule]", "\<\"c\"\>"}]}], "}"}], 
         ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"foo:child\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"same:child\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{566, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->16843]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"PreserveCDATASections\"", "Subsection",
 CellID->10030],

Cell[TextData[{
 "This option controls whether the distinction between CDATA sections and \
regular character data is maintained on import. CDATA sections are meant as a \
convenience for document authors; for most applications they should not be \
treated differently from ordinary data. Preserving CDATA sections can make \
pattern matching difficult so the default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]]],
 "."
}], "Text",
 CellID->15756],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<PreserveCDATASections\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "information about CDATA sections is preserved", "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "information about CDATA sections is removed", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10765],

Cell["Values for \"PreserveCDATASections\".", "Caption",
 CellID->3114],

Cell[TextData[{
 "Here is an example of the default behavior of ",
 Cell[BoxData["\"\<PreserveCDATASections\>\""], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->2980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<foo><![CDATA[ 5 < 7 << 2*10^123]]></foo>\>\"", ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->1458],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"foo\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"5 < 7 << 2*10^123\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->12358]
}, Open  ]],

Cell[TextData[{
 "To preserve CDATA sections, specify ",
 Cell[BoxData[
  RowBox[{"\"\<PreserveCDATASections\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->8124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<foo><![CDATA[ 5 < 7 << 2*10^123]]></foo>\>\"", ",", "\"\<XML\>\"", 
   ",", 
   RowBox[{"\"\<PreserveCDATASections\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->6008],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"foo\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLObject", "[", "\<\"CDATASection\"\>", "]"}], 
       "[", "\<\"5 < 7 << 2*10^123\"\>", "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{493, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->25311]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->2262667],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "RelatedTutorials",
 CellID->1866278227],

Cell[TextData[ButtonBox["Representing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/RepresentingXML"]], "RelatedTutorials",
 CellID->1368766954],

Cell[TextData[ButtonBox["Exporting XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ExportingXML"]], "RelatedTutorials",
 CellID->523248764],

Cell[TextData[ButtonBox["Transforming XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/TransformingXML"]], "RelatedTutorials",
 CellID->616508677],

Cell[TextData[ButtonBox["MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Importing XML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 44.4062274}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Tutorial", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "You can import XML data into Mathematica using the standard Import \
function, which has the following syntax. The first argument specifies the \
file to be imported. You can also specify an optional second argument to \
control the form of the output. For importing XML data, the relevant file \
formats are \"XML\", \"ExpressionML\", and \"MathML\". With \"XML\" as the \
import format, any XML formats that Mathematica does not recognize are \
returned as a symbolic XML expression. Mathematica does support ExpressionML \
and MathML on import. An ExpressionML file is imported as the corresponding \
cell expression. A MathML file is returned as the corresponding box \
expression. ", "synonyms" -> {}, "title" -> "Importing XML", "type" -> 
    "Tutorial", "uri" -> "XML/tutorial/ImportingXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2013, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2638, 72, 68, 2, 70, "Title",
 PageBreakAbove->True,
 CellID->7321],
Cell[CellGroupData[{
Cell[2731, 78, 62, 1, 70, "Section",
 CellID->18319],
Cell[CellGroupData[{
Cell[2818, 83, 44, 1, 70, "Subsection",
 CellID->29881],
Cell[2865, 86, 313, 11, 70, "Text",
 CellID->31626],
Cell[3181, 99, 545, 18, 70, "DefinitionBox",
 CellID->13020],
Cell[3729, 119, 662, 20, 70, "Text",
 CellID->1411],
Cell[4394, 141, 583, 16, 70, "Text",
 CellID->20454],
Cell[4980, 159, 260, 7, 70, "Text",
 CellID->25893],
Cell[5243, 168, 64, 1, 70, "MathCaption",
 CellID->21984],
Cell[CellGroupData[{
Cell[5332, 173, 160, 5, 70, "Input",
 CellID->2357],
Cell[5495, 180, 504, 9, 309, "Output",
 CellID->476371990]
}, Open  ]],
Cell[6014, 192, 108, 3, 70, "MathCaption",
 CellID->30336],
Cell[CellGroupData[{
Cell[6147, 199, 164, 5, 70, "Input",
 CellID->18829],
Cell[6314, 206, 899, 24, 88, "Output",
 CellID->686965399]
}, Open  ]],
Cell[7228, 233, 208, 6, 70, "MathCaption",
 CellID->21457],
Cell[CellGroupData[{
Cell[7461, 243, 167, 5, 70, "Input",
 CellID->32405],
Cell[7631, 250, 2775, 70, 156, "Output",
 CellID->97487978]
}, Open  ]],
Cell[10421, 323, 606, 19, 70, "Text",
 CellID->2334],
Cell[11030, 344, 119, 5, 70, "MathCaption",
 CellID->30049],
Cell[CellGroupData[{
Cell[11174, 353, 125, 3, 70, "Input",
 CellID->19094],
Cell[11302, 358, 899, 24, 88, "Output",
 CellID->124846248]
}, Open  ]],
Cell[12216, 385, 256, 8, 70, "MathCaption",
 CellID->31270],
Cell[CellGroupData[{
Cell[12497, 397, 104, 3, 28, "Input",
 CellID->30119],
Cell[12604, 402, 395, 10, 50, "Output",
 Evaluatable->False,
 CellID->820504952]
}, Open  ]],
Cell[13014, 415, 342, 10, 70, "Text",
 CellID->29313]
}, Open  ]],
Cell[CellGroupData[{
Cell[13393, 430, 50, 1, 70, "Subsection",
 CellID->15253],
Cell[13446, 433, 240, 8, 70, "Text",
 CellID->16117],
Cell[13689, 443, 352, 11, 70, "DefinitionBox",
 CellID->4977],
Cell[14044, 456, 522, 18, 70, "Text",
 CellID->19160],
Cell[14569, 476, 341, 11, 70, "Text",
 CellID->21505],
Cell[14913, 489, 241, 8, 70, "MathCaption",
 CellID->153],
Cell[CellGroupData[{
Cell[15179, 501, 205, 6, 70, "Input",
 CellID->24591],
Cell[15387, 509, 667, 20, 54, "Output",
 CellID->247707228]
}, Open  ]],
Cell[16069, 532, 174, 4, 70, "Text",
 CellID->3576],
Cell[16246, 538, 214, 7, 70, "MathCaption",
 CellID->4854],
Cell[CellGroupData[{
Cell[16485, 549, 194, 6, 70, "Input",
 CellID->20072],
Cell[16682, 557, 508, 15, 54, "Output",
 CellID->1392073110]
}, Open  ]],
Cell[17205, 575, 203, 5, 70, "MathCaption",
 CellID->23016],
Cell[CellGroupData[{
Cell[17433, 584, 257, 7, 70, "Input",
 CellID->25050],
Cell[17693, 593, 754, 22, 54, "Output",
 CellID->1767332991]
}, Open  ]],
Cell[18462, 618, 354, 10, 70, "Text",
 CellID->21945]
}, Open  ]],
Cell[CellGroupData[{
Cell[18853, 633, 43, 1, 70, "Subsection",
 CellID->1852],
Cell[18899, 636, 842, 28, 70, "Text",
 CellID->20747],
Cell[19744, 666, 121, 3, 70, "MathCaption",
 CellID->32521],
Cell[CellGroupData[{
Cell[19890, 673, 258, 8, 70, "Input",
 CellID->8061],
Cell[20151, 683, 5536, 136, 292, "Output",
 CellID->194275885]
}, Open  ]],
Cell[25702, 822, 526, 14, 70, "Text",
 CellID->20259],
Cell[26231, 838, 260, 8, 70, "Text",
 CellID->28366],
Cell[26494, 848, 326, 10, 70, "DefinitionBox",
 CellID->2885],
Cell[26823, 860, 467, 11, 70, "Text",
 CellID->14439],
Cell[27293, 873, 658, 22, 70, "Text",
 CellID->2718],
Cell[CellGroupData[{
Cell[27976, 899, 425, 14, 70, "IndentedText",
 CellID->9107],
Cell[28404, 915, 47, 1, 70, "Text",
 CellID->5268]
}, Open  ]],
Cell[28466, 919, 441, 14, 70, "IndentedText",
 CellID->3554]
}, Open  ]],
Cell[CellGroupData[{
Cell[28944, 938, 50, 1, 70, "Subsection",
 CellID->32050],
Cell[28997, 941, 683, 23, 70, "Text",
 CellID->7432],
Cell[CellGroupData[{
Cell[29705, 968, 169, 4, 70, "Input",
 CellID->13799],
Cell[29877, 974, 932, 27, 54, "Output",
 CellID->32020]
}, Open  ]],
Cell[30824, 1004, 535, 14, 70, "Text",
 CellID->16735],
Cell[31362, 1020, 283, 9, 70, "Text",
 CellID->31098],
Cell[31648, 1031, 354, 10, 70, "DefinitionBox",
 CellID->2792],
Cell[32005, 1043, 466, 11, 70, "Text",
 CellID->3916],
Cell[32474, 1056, 228, 5, 70, "MathCaption",
 CellID->26182],
Cell[CellGroupData[{
Cell[32727, 1065, 266, 8, 70, "Input",
 CellID->19029],
Cell[32996, 1075, 305, 9, 54, "Output",
 CellID->25316]
}, Open  ]],
Cell[33316, 1087, 630, 19, 70, "MathCaption",
 CellID->3059],
Cell[CellGroupData[{
Cell[33971, 1110, 315, 8, 70, "Input",
 CellID->13758],
Cell[34289, 1120, 1430, 41, 88, "Output",
 CellID->4583]
}, Open  ]],
Cell[35734, 1164, 775, 25, 70, "Text",
 CellID->22399],
Cell[CellGroupData[{
Cell[36534, 1193, 439, 14, 70, "IndentedText",
 CellID->1135],
Cell[36976, 1209, 47, 1, 70, "Text",
 CellID->8357]
}, Open  ]],
Cell[37038, 1213, 456, 14, 70, "IndentedText",
 CellID->20070]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37543, 1233, 58, 1, 70, "Section",
 CellID->15271],
Cell[37604, 1236, 123, 4, 70, "Text",
 CellID->22342],
Cell[37730, 1242, 311, 10, 70, "MathCaption",
 CellID->17780],
Cell[CellGroupData[{
Cell[38066, 1256, 342, 8, 70, "Input",
 CellID->13877],
Cell[38411, 1266, 2026, 51, 105, "Output",
 CellID->30406]
}, Open  ]],
Cell[40452, 1320, 142, 4, 70, "MathCaption",
 CellID->28295],
Cell[CellGroupData[{
Cell[40619, 1328, 260, 7, 70, "Input",
 CellID->17686],
Cell[40882, 1337, 779, 21, 71, "Output",
 CellID->2403]
}, Open  ]],
Cell[41676, 1361, 653, 17, 70, "Text",
 CellID->8252],
Cell[42332, 1380, 296, 9, 70, "Text",
 CellID->15718]
}, Open  ]],
Cell[CellGroupData[{
Cell[42665, 1394, 49, 1, 70, "Section",
 CellID->23035],
Cell[CellGroupData[{
Cell[42739, 1399, 49, 1, 70, "Subsection",
 CellID->7285],
Cell[42791, 1402, 281, 9, 70, "Text",
 CellID->28428],
Cell[CellGroupData[{
Cell[43097, 1415, 324, 10, 70, "IndentedText",
 CellID->16678],
Cell[43424, 1427, 91, 1, 70, "Text",
 CellID->25960]
}, Open  ]],
Cell[43530, 1431, 109, 2, 70, "BulletedText",
 CellID->101],
Cell[43642, 1435, 112, 2, 70, "BulletedText",
 CellID->20949],
Cell[43757, 1439, 116, 2, 70, "BulletedText",
 CellID->2364],
Cell[43876, 1443, 99, 2, 70, "BulletedText",
 CellID->26385],
Cell[43978, 1447, 110, 2, 70, "BulletedText",
 CellID->27626],
Cell[44091, 1451, 118, 2, 70, "BulletedText",
 CellID->17157],
Cell[44212, 1455, 113, 2, 70, "BulletedText",
 CellID->2737],
Cell[44328, 1459, 108, 2, 70, "BulletedText",
 CellID->4841],
Cell[44439, 1463, 113, 2, 70, "BulletedText",
 CellID->18938]
}, Open  ]],
Cell[CellGroupData[{
Cell[44589, 1470, 61, 1, 70, "Subsection",
 CellID->11593],
Cell[44653, 1473, 153, 4, 70, "Text",
 CellID->17096],
Cell[44809, 1479, 1102, 33, 70, "DefinitionBox3Col",
 CellID->31033],
Cell[45914, 1514, 69, 1, 70, "Caption",
 CellID->4493],
Cell[45986, 1517, 425, 11, 70, "Text",
 CellID->29768],
Cell[46414, 1530, 270, 5, 70, "Text",
 CellID->27873],
Cell[46687, 1537, 279, 9, 70, "MathCaption",
 CellID->29935],
Cell[CellGroupData[{
Cell[46991, 1550, 177, 5, 70, "Input",
 CellID->19109],
Cell[47171, 1557, 445, 14, 36, "Output",
 CellID->30096]
}, Open  ]],
Cell[47631, 1574, 293, 8, 70, "MathCaption",
 CellID->20381],
Cell[CellGroupData[{
Cell[47949, 1586, 265, 7, 70, "Input",
 CellID->21561],
Cell[48217, 1595, 455, 14, 36, "Output",
 CellID->25739]
}, Open  ]],
Cell[48687, 1612, 366, 10, 70, "Text",
 CellID->5584]
}, Open  ]],
Cell[CellGroupData[{
Cell[49090, 1627, 62, 1, 70, "Subsection",
 CellID->25923],
Cell[49155, 1630, 131, 4, 70, "Text",
 CellID->28499],
Cell[49289, 1636, 811, 23, 70, "DefinitionBox3Col",
 CellID->16731],
Cell[50103, 1661, 71, 1, 70, "Caption",
 CellID->11849],
Cell[50177, 1664, 547, 17, 70, "Text",
 CellID->25442]
}, Open  ]],
Cell[CellGroupData[{
Cell[50761, 1686, 66, 1, 70, "Subsection",
 CellID->8606],
Cell[50830, 1689, 156, 4, 70, "Text",
 CellID->6850],
Cell[50989, 1695, 1204, 34, 70, "DefinitionBox3Col",
 CellID->28287],
Cell[52196, 1731, 76, 1, 70, "Caption",
 CellID->26040],
Cell[52275, 1734, 400, 12, 70, "MathCaption",
 CellID->22769],
Cell[CellGroupData[{
Cell[52700, 1750, 345, 9, 70, "Input",
 CellID->9223],
Cell[53048, 1761, 248, 6, 70, "Message",
 CellID->1588],
Cell[53299, 1769, 458, 10, 70, "Message",
 CellID->16467],
Cell[53760, 1781, 161, 5, 36, "Output",
 CellID->12083]
}, Open  ]],
Cell[53936, 1789, 373, 10, 70, "MathCaption",
 CellID->3400],
Cell[CellGroupData[{
Cell[54334, 1803, 350, 9, 70, "Input",
 CellID->11158],
Cell[54687, 1814, 257, 6, 70, "Message",
 CellID->15606],
Cell[54947, 1822, 782, 22, 71, "Output",
 CellID->16938]
}, Open  ]],
Cell[55744, 1847, 356, 10, 70, "MathCaption",
 CellID->19463],
Cell[CellGroupData[{
Cell[56125, 1861, 340, 9, 70, "Input",
 CellID->20920],
Cell[56468, 1872, 781, 22, 71, "Output",
 CellID->18366]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57298, 1900, 49, 1, 70, "Subsection",
 CellID->15758],
Cell[57350, 1903, 226, 5, 70, "Text",
 CellID->19685],
Cell[57579, 1910, 668, 19, 70, "DefinitionBox3Col",
 CellID->9023],
Cell[58250, 1931, 58, 1, 70, "Caption",
 CellID->20229],
Cell[58311, 1934, 609, 16, 70, "Text",
 CellID->19298],
Cell[58923, 1952, 808, 22, 70, "Text",
 CellID->29356],
Cell[59734, 1976, 359, 10, 70, "Text",
 CellID->5470]
}, Open  ]],
Cell[CellGroupData[{
Cell[60130, 1991, 60, 1, 70, "Subsection",
 CellID->23175],
Cell[60193, 1994, 109, 3, 70, "Text",
 CellID->24196],
Cell[60305, 1999, 1022, 28, 70, "DefinitionBox3Col",
 CellID->1683],
Cell[61330, 2029, 68, 1, 70, "Caption",
 CellID->9988],
Cell[61401, 2032, 706, 23, 70, "Text",
 CellID->7619],
Cell[62110, 2057, 325, 10, 70, "MathCaption",
 CellID->2946],
Cell[CellGroupData[{
Cell[62460, 2071, 319, 9, 70, "Input",
 CellID->32190],
Cell[62782, 2082, 260, 6, 70, "Message",
 CellID->8275],
Cell[63045, 2090, 238, 6, 70, "Message",
 CellID->2469],
Cell[63286, 2098, 261, 6, 70, "Message",
 CellID->25519],
Cell[63550, 2106, 287, 7, 70, "Message",
 CellID->14341],
Cell[63840, 2115, 377, 13, 146, "Output",
 CellID->26197]
}, Open  ]],
Cell[64232, 2131, 306, 9, 70, "MathCaption",
 CellID->8545],
Cell[CellGroupData[{
Cell[64563, 2144, 307, 9, 70, "Input",
 CellID->1654],
Cell[64873, 2155, 340, 11, 114, "Output",
 CellID->7158]
}, Open  ]],
Cell[65228, 2169, 551, 19, 70, "MathCaption",
 CellID->14058],
Cell[CellGroupData[{
Cell[65804, 2192, 319, 9, 70, "Input",
 CellID->5794],
Cell[66126, 2203, 354, 12, 130, "Output",
 CellID->23791]
}, Open  ]],
Cell[CellGroupData[{
Cell[66517, 2220, 309, 9, 70, "Input",
 CellID->13341],
Cell[66829, 2231, 322, 11, 114, "Output",
 CellID->24837]
}, Open  ]],
Cell[67166, 2245, 317, 10, 70, "MathCaption",
 CellID->28900],
Cell[CellGroupData[{
Cell[67508, 2259, 214, 6, 70, "Input",
 CellID->13232],
Cell[67725, 2267, 237, 6, 70, "Message",
 CellID->12675],
Cell[67965, 2275, 250, 6, 70, "Message",
 CellID->19736],
Cell[68218, 2283, 487, 15, 36, "Output",
 CellID->17438]
}, Open  ]],
Cell[68720, 2301, 392, 11, 70, "MathCaption",
 CellID->9958],
Cell[CellGroupData[{
Cell[69137, 2316, 152, 4, 70, "Input",
 CellID->30580],
Cell[69292, 2322, 431, 14, 36, "Output",
 CellID->27085]
}, Open  ]],
Cell[69738, 2339, 139, 4, 70, "MathCaption",
 CellID->15013],
Cell[CellGroupData[{
Cell[69902, 2347, 251, 7, 70, "Input",
 CellID->5284],
Cell[70156, 2356, 274, 6, 70, "Message",
 CellID->5253],
Cell[70433, 2364, 253, 6, 70, "Message",
 CellID->20727],
Cell[70689, 2372, 275, 6, 70, "Message",
 CellID->30285],
Cell[70967, 2380, 280, 7, 70, "Message",
 CellID->2426],
Cell[71250, 2389, 375, 13, 146, "Output",
 CellID->19670]
}, Open  ]],
Cell[71640, 2405, 350, 9, 70, "Text",
 CellID->14536]
}, Open  ]],
Cell[CellGroupData[{
Cell[72027, 2419, 67, 1, 70, "Subsection",
 CellID->3281],
Cell[72097, 2422, 777, 18, 70, "Text",
 CellID->23370],
Cell[72877, 2442, 751, 20, 70, "DefinitionBox3Col",
 CellID->6549],
Cell[73631, 2464, 76, 1, 70, "Caption",
 CellID->1348],
Cell[73710, 2467, 87, 1, 70, "MathCaption",
 CellID->9077],
Cell[73800, 2470, 263, 8, 70, "Input",
 CellID->26199],
Cell[74066, 2480, 82, 1, 70, "MathCaption",
 CellID->16835],
Cell[CellGroupData[{
Cell[74173, 2485, 145, 4, 70, "Input",
 CellID->3573],
Cell[74321, 2491, 767, 21, 88, "Output",
 CellID->28137]
}, Open  ]],
Cell[75103, 2515, 314, 10, 70, "MathCaption",
 CellID->8351],
Cell[CellGroupData[{
Cell[75442, 2529, 225, 6, 70, "Input",
 CellID->28731],
Cell[75670, 2537, 854, 23, 122, "Output",
 CellID->27617]
}, Open  ]],
Cell[76539, 2563, 351, 10, 70, "MathCaption",
 CellID->5233],
Cell[CellGroupData[{
Cell[76915, 2577, 294, 7, 70, "Input",
 CellID->30571],
Cell[77212, 2586, 798, 22, 105, "Output",
 CellID->27376]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78059, 2614, 64, 1, 70, "Subsection",
 CellID->25529],
Cell[78126, 2617, 156, 4, 70, "Text",
 CellID->17731],
Cell[78285, 2623, 1391, 42, 70, "DefinitionBox3Col",
 CellID->11044],
Cell[79679, 2667, 73, 1, 70, "Caption",
 CellID->20342],
Cell[79755, 2670, 130, 4, 70, "MathCaption",
 CellID->30000],
Cell[79888, 2676, 200, 7, 70, "Input",
 CellID->7528],
Cell[80091, 2685, 285, 8, 70, "MathCaption",
 CellID->30916],
Cell[CellGroupData[{
Cell[80401, 2697, 222, 6, 70, "Input",
 CellID->12634],
Cell[80626, 2705, 834, 25, 71, "Output",
 CellID->4999]
}, Open  ]],
Cell[81475, 2733, 425, 12, 70, "MathCaption",
 CellID->17757],
Cell[CellGroupData[{
Cell[81925, 2749, 228, 6, 70, "Input",
 CellID->29240],
Cell[82156, 2757, 833, 25, 71, "Output",
 CellID->581]
}, Open  ]],
Cell[83004, 2785, 589, 15, 70, "MathCaption",
 CellID->13623],
Cell[CellGroupData[{
Cell[83618, 2804, 245, 7, 70, "Input",
 CellID->15941],
Cell[83866, 2813, 834, 25, 71, "Output",
 CellID->7131]
}, Open  ]],
Cell[CellGroupData[{
Cell[84737, 2843, 229, 7, 70, "Input",
 CellID->15749],
Cell[84969, 2852, 835, 25, 71, "Output",
 CellID->31539]
}, Open  ]],
Cell[CellGroupData[{
Cell[85841, 2882, 307, 8, 70, "Input",
 CellID->9299],
Cell[86151, 2892, 835, 25, 71, "Output",
 CellID->25575]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87035, 2923, 58, 1, 70, "Subsection",
 CellID->4099],
Cell[87096, 2926, 82, 1, 70, "Text",
 CellID->14363],
Cell[87181, 2929, 1024, 28, 70, "DefinitionBox3Col",
 CellID->13245],
Cell[88208, 2959, 68, 1, 70, "Caption",
 CellID->14726],
Cell[88279, 2962, 104, 3, 70, "Text",
 CellID->201],
Cell[88386, 2967, 277, 9, 70, "Program",
 CellID->6424],
Cell[88666, 2978, 364, 10, 70, "Input",
 CellID->24083],
Cell[CellGroupData[{
Cell[89055, 2992, 44, 1, 70, "Subsubsection",
 CellID->7389],
Cell[89102, 2995, 597, 16, 70, "Text",
 CellID->20735],
Cell[CellGroupData[{
Cell[89724, 3015, 206, 6, 70, "Input",
 CellID->22024],
Cell[89933, 3023, 2522, 73, 173, "Output",
 CellID->18895]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92504, 3102, 46, 1, 70, "Subsubsection",
 CellID->28745],
Cell[92553, 3105, 578, 12, 70, "Text",
 CellID->6170],
Cell[CellGroupData[{
Cell[93156, 3121, 208, 6, 70, "Input",
 CellID->11483],
Cell[93367, 3129, 1421, 38, 88, "Output",
 CellID->28717]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94837, 3173, 50, 1, 70, "Subsubsection",
 CellID->28392],
Cell[94890, 3176, 709, 18, 70, "Text",
 CellID->28752],
Cell[95602, 3196, 457, 10, 70, "Text",
 CellID->11324],
Cell[CellGroupData[{
Cell[96084, 3210, 124, 3, 70, "Input",
 CellID->19773],
Cell[96211, 3215, 2246, 64, 156, "Output",
 CellID->27740]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98506, 3285, 49, 1, 70, "Subsubsection",
 CellID->18255],
Cell[98558, 3288, 538, 11, 70, "Text",
 CellID->4468],
Cell[CellGroupData[{
Cell[99121, 3303, 219, 6, 70, "Input",
 CellID->22070],
Cell[99343, 3311, 1461, 39, 88, "Output",
 CellID->16843]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100865, 3357, 63, 1, 70, "Subsection",
 CellID->10030],
Cell[100931, 3360, 510, 12, 70, "Text",
 CellID->15756],
Cell[101444, 3374, 714, 19, 70, "DefinitionBox3Col",
 CellID->10765],
Cell[102161, 3395, 71, 1, 70, "Caption",
 CellID->3114],
Cell[102235, 3398, 171, 5, 70, "MathCaption",
 CellID->2980],
Cell[CellGroupData[{
Cell[102431, 3407, 191, 6, 70, "Input",
 CellID->1458],
Cell[102625, 3415, 459, 14, 36, "Output",
 CellID->12358]
}, Open  ]],
Cell[103099, 3432, 271, 9, 70, "MathCaption",
 CellID->8124],
Cell[CellGroupData[{
Cell[103395, 3445, 266, 8, 70, "Input",
 CellID->6008],
Cell[103664, 3455, 559, 17, 54, "Output",
 CellID->25311]
}, Open  ]],
Cell[CellGroupData[{
Cell[104260, 3477, 70, 1, 70, "RelatedTutorialsSection",
 CellID->2262667],
Cell[104333, 3480, 151, 3, 70, "RelatedTutorials",
 CellID->1866278227],
Cell[104487, 3485, 158, 3, 70, "RelatedTutorials",
 CellID->1368766954],
Cell[104648, 3490, 151, 3, 70, "RelatedTutorials",
 CellID->523248764],
Cell[104802, 3495, 157, 3, 70, "RelatedTutorials",
 CellID->616508677],
Cell[104962, 3500, 138, 3, 70, "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[105151, 3509, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

