(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    102741,       3465]
NotebookOptionsPosition[     83794,       2799]
NotebookOutlinePosition[     86451,       2854]
CellTagsIndexPosition[     86408,       2851]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"XML Capabilities" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
         "Representing XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/RepresentingXML"], 
         "Importing XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"], 
         "Exporting XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ExportingXML"], 
         "Transforming XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/TransformingXML"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
      2->"\<\"Representing XML\"\>", 3->"\<\"Importing XML\"\>", 
      4->"\<\"Exporting XML\"\>", 
      5->"\<\"Transforming XML\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Working with MathML", "Title",
 PageBreakAbove->True,
 CellID->16088],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->29467],

Cell[TextData[{
 "MathML is an XML-based markup language for representing mathematics. It was \
developed by the W3C to provide an effective way to display math in web pages \
and facilitate the transfer and re-use of mathematical content between \
applications. The great advantage is that it can encode information about \
both the meaning and appearance of mathematical notation. This makes it an \
ideal data format for storing and exchanging mathematical information. For \
example, a MathML equation can be copied out of a web page and directly \
pasted into an application like ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for evaluation. "
}], "Text",
 CellID->31375],

Cell["\<\
As a common and widely accepted standard for representing mathematics, MathML \
provides the foundation for many interesting and useful applications. For \
example, you can use MathML to create dynamic mathematical websites featuring \
interactive equations, set up a database of technical documents whose \
contents can be easily searched, indexed, and archived, or develop speech \
synthesis software for audio rendering of mathematics.\
\>", "Text",
 CellID->21163],

Cell["\<\
MathML has grown rapidly in popularity since it was first released in 1998, \
gaining broad support in both industry and academia. It is currently possible \
to view MathML equations in the leading web browsers, either directly or \
using freely available plug-ins. As more tools for authoring, viewing, and \
processing MathML become available, its importance is only expected to grow. \
\
\>", "Text",
 CellID->11612],

Cell[TextData[{
 "Wolfram Research was a key participant in the development of MathML and is \
committed to supporting this important web technology.",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " 6.0 includes full support for MathML 2.0. You can import MathML equations \
into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook and evaluate them, or export equations from a notebook as MathML \
and paste them into an HTML document. There are also several kernel commands \
for converting between MathML and the boxes and expressions used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent mathematics. "
}], "Text",
 CellID->10474]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax of MathML", "Section",
 CellID->13649],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellID->27930],

Cell["\<\
Since it is an XML application, the syntax rules of MathML are defined by the \
XML specification. Each MathML expression consists of a series of elements, \
written in the angle bracket syntax similar to HTML. Each element can take \
several attributes. The allowed elements and attributes are determined by the \
MathML DTD. \
\>", "Text",
 CellID->24628],

Cell["\<\
All MathML elements fall into one of three categories: interface elements, \
presentation elements, and content elements. \
\>", "Text",
 CellID->25395],

Cell[TextData[{
 "Interface elements, such as the top-level ",
 StyleBox["math", "MR"],
 " element determine how a MathML expression is embedded in other XML \
documents. "
}], "Text",
 CellID->583],

Cell[TextData[{
 "Presentation elements encode information about the visual two-dimensional \
structure of a mathematical expression, that is its . For example, the ",
 StyleBox["mrow", "MR"],
 ", ",
 StyleBox["mfrac", "MR"],
 ", ",
 StyleBox["msqrt", "MR"],
 ", and ",
 StyleBox["msub", "MR"],
 " elements represent a row, a fraction, a square root, and a subscripted \
expression, respectively."
}], "Text",
 CellID->13833],

Cell[TextData[{
 "Content elements encode information about the logical meaning of a \
mathematical expression. For example, ",
 StyleBox["plus", "MR"],
 " and ",
 StyleBox["sin", "MR"],
 " represent addition and the trigonometric sine function, and ",
 StyleBox["apply", "MR"],
 " represents the operation of applying a function. "
}], "Text",
 CellID->3127],

Cell["\<\
A given equation can be represented in several different ways in MathML:\
\>", "Text",
 CellID->2045],

Cell["\<\
Presentation MathML\[LongDash]Presentation elements only. It is useful in \
situations where only the display of mathematics is important. For example, \
to include equations in a web page that are intended only for viewing. \
\>", "BulletedText",
 CellID->25000],

Cell[TextData[{
 "Content MathML\[LongDash]Content elements only. It is useful in situations \
where it is important to encode mathematical meaning. For example, you can \
use it to post an equation on a web page that readers can copy and paste into \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for evaluation."
}], "BulletedText",
 CellID->21985],

Cell[CellGroupData[{

Cell["\<\
Combined markup\[LongDash]combination of content and presentation elements. \
It is used when you want to encode both the appearance and meaning of \
equations. For example, you can use combined markup to specify a non-standard \
notation for a common mathematical construct or to associate a specific \
mathematical meaning with a notation that usually has a different meaning. \
\>", "BulletedText",
 CellID->31990],

Cell[TextData[{
 "Using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can generate presentation, content, or combined markup for any \
equation."
}], "Text",
 CellID->9772]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Presentation MathML", "Subsection",
 CellID->4638],

Cell[TextData[{
 "Presentation MathML consists of about 30 elements and 50 attributes, which \
encode the visual two-dimensional structure of a mathematical expression. For \
example, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typeset expression ",
 StyleBox["x + 1", "Input"],
 " would have the following MathML representation."
}], "Text",
 CellID->3771],

Cell[BoxData[
 RowBox[{"x", "+", "1"}]], "DisplayMath",
 Evaluatable->False,
 FontWeight->"Bold",
 CellID->12793],

Cell[BoxData["\<\"<math>\\n <mrow>\\n  <mi>x</mi>\\n  <mo>+</mo>\\n  \
<mn>1</mn>\\n </mrow>\\n</math>\"\>"], "Output",
 ImageSize->{88, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->11696],

Cell[TextData[{
 "The entire expression is enclosed in a ",
 StyleBox["math", "MR"],
 " element. This must be the root element for every instance of MathML \
markup. The other presentation elements:"
}], "Text",
 CellID->14373],

Cell[TextData[{
 StyleBox["mrow", "MR"],
 "\[LongDash]displays its sub-elements in a horizontal row."
}], "BulletedText",
 CellID->22061],

Cell[TextData[{
 StyleBox["mi", "MR"],
 "\[LongDash]represents an identifier such as the name of a function or \
variable."
}], "BulletedText",
 CellID->24908],

Cell[TextData[{
 StyleBox["mo", "MR"],
 "\[LongDash]represents an operator or delimiter. "
}], "BulletedText",
 CellID->30716],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["mn", "MR"],
 "\[LongDash]represents a number. "
}], "BulletedText",
 CellID->5300],

Cell["\<\
Identifiers, operators, and numbers are each represented by different \
elements because each has slightly different typesetting conventions for \
fonts, spacing, and so on. For example, variables are typically rendered in \
an italic font, numbers are displayed in a normal font, and operators are \
rendered with extra space around them, depending on whether they occur in a \
prefix, postfix, or infix position. \
\>", "Text",
 CellID->16739],

Cell[TextData[{
 "In addition to the ",
 StyleBox["mi", "MR"],
 StyleBox[", ",
  FontFamily->"Times New Roman"],
 StyleBox["mn", "MR"],
 ", and ",
 StyleBox["mo", "MR"],
 " elements, there are presentation elements corresponding to common \
notational structures such as fractions, square roots, subscripts, \
superscripts, and matrices. Any given formula can be represented by \
decomposing it into its constituent parts and replacing each notational \
construct by the corresponding presentation elements. For example, the \
typeset expression ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["x"], 
    RowBox[{
     SuperscriptBox["y", "2"], "-", "1"}]], TraditionalForm]]],
 "would have the following MathML representation."
}], "Text",
 CellID->827],

Cell[BoxData[
 FractionBox[
  SqrtBox["x"], 
  RowBox[{
   SuperscriptBox["y", "2"], "-", "1"}]]], "DisplayMath",
 Evaluatable->False,
 FontWeight->"Bold",
 CellID->13497],

Cell[BoxData["\<\"<math>\\n <mfrac>\\n  <msqrt>\\n   <mi>x</mi>\\n  \
</msqrt>\\n  <mrow>\\n   <msup>\\n    <mi>y</mi>\\n    <mn>2</mn>\\n   \
</msup>\\n   <mo>-</mo>\\n   <mn>1</mn>\\n  </mrow>\\n \
</mfrac>\\n</math>\"\>"], "Output",
 ImageSize->{102, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->3872],

Cell[TextData[{
 "Here, the ",
 StyleBox["mfrac", "MR"],
 ", ",
 StyleBox["msqrt", "MR"],
 ", and ",
 StyleBox["msup", "MR"],
 " elements represent a fraction, a square root, and a superscripted \
expression, respectively. Each of these elements takes a fixed number of \
child elements, which have a specific meaning based on their position. These \
child elements are called arguments. For example, both the ",
 StyleBox["mfrac", "MR"],
 " and ",
 StyleBox["msup", "MR"],
 " elements take two arguments, with the following syntax."
}], "Text",
 CellID->30578]
}, Open  ]],

Cell[TextData[{
 StyleBox["<mfrac>", "MR"],
 " ",
 StyleBox["numerator", "TI"],
 " ",
 StyleBox["denominator", "TI"],
 " ",
 StyleBox["</mfrac>", "MR"]
}], "IndentedText",
 CellID->19289],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["<msup>", "MR"],
 " ",
 StyleBox["base", "TI"],
 " ",
 StyleBox["superscript", "TI"],
 " ",
 StyleBox["</msup>", "MR"]
}], "IndentedText",
 CellID->3772],

Cell[TextData[{
 "The ",
 StyleBox["mrow", "MR"],
 " element is used to enclose other elements that appear in a horizontal row. \
For example, the typeset expression ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 "would have the following MathML representation."
}], "Text",
 CellID->5693],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "DisplayMath",
 Evaluatable->False,
 FontWeight->"Bold",
 CellID->7658],

Cell[BoxData["\<\"<math>\\n <mrow>\\n   <msubsup>\\n    <mo>&int;</mo>\\n    \
<mn>0</mn>\\n    <mi>&inf;</mi>\\n   </msubsup>\\n   <msup>\\n     \
<mi>&exp;</mi>\\n     <mrow>\\n      <mo>-</mo>\\n      <mi>x</mi>\\n     \
</mrow>\\n   </msup>\\n    <mrow>\\n     <mo>&dd;</mo>\\n     <mi>x</mi>\\n   \
  </mrow>\\n   </mrow>\\n</math>\"\>"], "Output",
 CellEditDuplicate->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{137, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->12999],

Cell[TextData[{
 "Here, the limits of the integral are shown using the presentation element \
",
 StyleBox["msubsup", "MR"],
 ", which takes three arguments, with the following syntax."
}], "Text",
 CellID->7478]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["<msubsup>", "MR"],
 " ",
 StyleBox["base", "TI"],
 " ",
 StyleBox["subscript", "TI"],
 " ",
 StyleBox["superscript", "TI"],
 " ",
 StyleBox["</msubsup>", "MR"]
}], "IndentedText",
 CellID->7366],

Cell[TextData[{
 "Another notable feature is that the symbols representing the integral sign, \
the exponential, and the differential d are represented using the character \
entities ",
 StyleBox["&int;", "MR"],
 ", ",
 StyleBox["&exp;", "MR"],
 ", and ",
 StyleBox["&dd;", "MR"],
 ". These are among approximately 2,000 special symbols defined by the MathML \
DTD. These can be included in a document using a named entity reference or a \
character entity reference, which uses the Unicode character code. "
}], "Text",
 CellID->29610],

Cell[TextData[{
 "The ",
 StyleBox["mstyle", "MR"],
 " element is used for applying styles to an equation. Any attributes \
specified in an ",
 StyleBox["mstyle", "MR"],
 " element are inherited by all its child elements. You can use this element \
to specify properties like the font size and color for an equation. Note the \
use of the entity ",
 StyleBox["&InvisibleTimes;", "MR"],
 " to denote multiplication."
}], "Text",
 CellID->30642],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   RowBox[{"2", " ", "x"}], "+", "1"}], TraditionalForm]], "DisplayMath",
 Evaluatable->False,
 FontSize->18,
 FontColor->RGBColor[1, 0, 0],
 CellID->29995],

Cell[BoxData["\<\"<math>\\n<mstyle fontsize='24 pt' fontcolor='red'>\\n \
<mrow>\\n  <msup>\\n    <mi>x</mi>\\n   <mn>2</mn>\\n  </msup>\\n  <mo>-</mo>\
\\n  <mrow>\\n   <mn>2</mn>\\n   <mo>&InvisibleTimes;</mo>\\n   <mi>x</mi>\\n \
 </mrow>\\n  <mo>+</mo>\\n  <mn>1</mn>\\n </mrow>\\n \
</mstyle>\\n</math>\"\>"], "Output",
 CellEditDuplicate->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{291, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->13567],

Cell[TextData[{
 "The examples are intended only to illustrate how presentation markup works \
through a sampling of some of its elements. To see a complete listing of all \
the presentation elements and attributes, see the MathML specification at ",
 ButtonBox["http://www.w3.org/TR/MathML2/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/MathML2/"], None}],
 ". "
}], "Text",
 CellID->3577]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Content MathML", "Subsection",
 CellID->13854],

Cell[TextData[{
 "Content MathML consists of about 140 elements and 12 attributes, which \
encode the logical meaning of a mathematical expression. The content elements \
",
 StyleBox["ci", "MR"],
 " and ",
 StyleBox["cn", "MR"],
 " are used to represent identifiers and numbers, respectively. They are \
analogous to the ",
 StyleBox["mi", "MR"],
 " and ",
 StyleBox["mn", "MR"],
 " elements in presentation markup. For example, the typeset expression ",
 StyleBox["x + 1", "Input"],
 " would have the following content MathML representation."
}], "Text",
 CellID->28454],

Cell[BoxData[
 RowBox[{"x", "+", "1"}]], "DisplayMath",
 FontWeight->"Bold",
 CellID->3992],

Cell[BoxData["\<\"<math>\\n <apply>\\n  <plus/>\\n  <ci>x</ci>\\n  <cn>1</cn>\
\\n </apply>\\n</math>\"\>"], "Output",
 ImageSize->{88, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->27602],

Cell[TextData[{
 "The ",
 StyleBox["apply", "MR"],
 " element is used to apply operators or functions to expressions. The first \
argument of the ",
 StyleBox["apply", "MR"],
 " element is usually an empty element indicating an operator or function. \
The remaining arguments represent one or more expressions to which the first \
argument is applied. In this example, the first argument of the ",
 StyleBox["apply", "MR"],
 " function is the empty element ",
 StyleBox["plus", "MR"],
 ", which denotes addition. "
}], "Text",
 CellID->32226],

Cell[TextData[{
 "The ",
 StyleBox["type", "MR"],
 " attribute of ",
 StyleBox["cn", "MR"],
 " describes the type of number encoded. It can take values ",
 StyleBox["real", "MR"],
 ", ",
 StyleBox["integer", "MR"],
 ", ",
 StyleBox["rational", "MR"],
 ", ",
 StyleBox["complex-polar", "MR"],
 ", ",
 StyleBox["complex-cartesian", "MR"],
 ", and ",
 StyleBox["constant", "MR"],
 ". The empty element ",
 StyleBox["sep", "MR"],
 " is used to separate different parts of a number such as the numerator and \
denominator of a fraction or the real and imaginary parts of a complex \
number. For example:"
}], "Text",
 CellID->29994],

Cell[BoxData[
 RowBox[{"1", "/", "2"}]], "DisplayMath",
 FontWeight->"Bold",
 CellID->25045],

Cell[BoxData["\<\"<math>\\n <cn type=\\\"rational\\\">1<sep/>2</cn>\\n</math>\
\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{242, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->21374],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"4", "\[ImaginaryI]"}]}]], "DisplayMath",
 FontWeight->"Bold",
 CellID->2548],

Cell[BoxData["\<\"<math>\\n <cn \
type=\\\"complex-cartesian\\\">3<sep/>4</cn>\\n</math>\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{305, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->27883],

Cell[TextData[StyleBox["The majority of content elements are empty elements \
representing specific operators or functions. The various elements are \
organized into groups named after the specific elementary subfields of \
mathematics.",
 FontFamily->"Times New Roman"]], "Text",
 CellID->30444],

Cell["Arithmetic, Algebra, and Logic", "BulletedText",
 CellID->11881],

Cell["Elementary Functions", "BulletedText",
 CellID->31975],

Cell["Calculus", "BulletedText",
 CellID->4670],

Cell["Linear Algebra", "BulletedText",
 CellID->28847],

Cell["Sequences and Series", "BulletedText",
 CellID->22318],

Cell["Theory of Sets", "BulletedText",
 CellID->18098],

Cell[CellGroupData[{

Cell["Statistics", "BulletedText",
 CellID->21967],

Cell[TextData[{
 StyleBox["There are elements corresponding to most operators and functions \
that are encountered in high school mathematics. ",
  FontFamily->"Times New Roman"],
 "For example, basic arithmetic operators are represented by ",
 StyleBox["plus", "MR"],
 ", ",
 StyleBox["minus", "MR"],
 ", ",
 StyleBox["times", "MR"],
 ", ",
 StyleBox["divide", "MR"],
 ", and ",
 StyleBox["power", "MR"],
 "."
}], "Text",
 CellID->31594],

Cell[BoxData[
 FractionBox[
  SqrtBox["x"], 
  RowBox[{
   SuperscriptBox["y", "2"], "-", "1"}]]], "DisplayMath",
 FontWeight->"Bold",
 CellID->3572],

Cell[BoxData["\<\"<math>\\n <apply>\\n  <times/>\\n  <apply>\\n   <power/>\\n \
  <ci>x</ci>\\n   <cn>1<sep/>2</cn>\\n  </apply>\\n  <apply>\\n   <power/>\\n \
  <apply>\\n    <plus/>\\n    <apply>\\n     <power/>\\n     <ci>y</ci>\\n    \
 <cn>2</cn>\\n    </apply>\\n    <cn>-1</cn>\\n   </apply>\\n   \
<cn>-1</cn>\\n  </apply>\\n </apply>\\n</math>\"\>"], "Output",
 CellEditDuplicate->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{144, 390},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->6067],

Cell[TextData[{
 "Integrals are specified using the ",
 StyleBox["int", "MR"],
 " element. The variable of integration is represented using the element ",
 StyleBox["bvar",
  FontFamily->"Courier"],
 ". The upper and lower limits of integration are usually specified using the \
elements ",
 StyleBox["lowlimit", "MR"],
 " and ",
 StyleBox["uplimit", "MR"],
 ". "
}], "Text",
 CellID->5138],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "a", "b"], 
   RowBox[{"x", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "DisplayMath",
 FontWeight->"Bold",
 CellID->30991],

Cell[BoxData["\<\"<math>\\n <apply>\\n  <int/>\\n  <bvar>\\n   <ci>x</ci>\\n  \
</bvar>\\n  <lowlimit>\\n   <ci>a</ci>\\n  </lowlimit>\\n  <uplimit>\\n   \
<ci>b</ci>\\n  </uplimit>\\n  <ci>x</ci>\\n </apply>\\n</math>\"\>"], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{95, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1789],

Cell[TextData[{
 "The ",
 StyleBox["interval", "MR"],
 " element is used to specify closed and open intervals. It takes the \
attribute ",
 StyleBox["closure", "MR"],
 " which can take the values ",
 StyleBox["closed", "MR"],
 ", ",
 StyleBox["open", "MR"],
 ", ",
 StyleBox["closed-open", "MR"],
 ", and ",
 StyleBox["open-closed", "MR"],
 " corresponding to the four types of intervals possible. The default value \
for ",
 StyleBox["closure", "MR"],
 " is ",
 StyleBox["closed", "MR"],
 "."
}], "Text",
 CellID->1268],

Cell[BoxData[
 RowBox[{"[", 
  RowBox[{"a", ",", "b"}], "]"}]], "DisplayMath",
 FontWeight->"Bold",
 CellID->14460],

Cell[BoxData["\<\"<math>\\n <interval>\\n    <ci>a</ci>\\n    <ci>b</ci>\\n   \
</interval>\\n</math>\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{102, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->26512],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0", ",", "1"}]}], "]"}]], "DisplayMath",
 FontWeight->"Bold",
 CellID->18300],

Cell[BoxData["\<\"<math>\\n <interval closure='open-closed'>\\n    <cn>0</cn>\
\\n    <cn>1</cn>\\n   </interval>\\n</math>\"\>"], "Output",
 CellEditDuplicate->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{235, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->16812],

Cell[TextData[{
 "You can also use the ",
 StyleBox["interval", "MR"],
 " element to specify the limits of a definite integral as an alternative to \
using ",
 StyleBox["uplimit", "MR"],
 " and ",
 StyleBox["lowlimit", "MR"],
 ". "
}], "Text",
 CellID->8434],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "a", "b"], 
   RowBox[{"x", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "DisplayMath",
 FontWeight->"Bold",
 CellID->1677],

Cell[BoxData["\<\"<math>\\n <apply>\\n  <int/>\\n  <bvar>\\n  <interval>\\n   \
 <ci>a</ci>\\n     <ci>b</ci>\\n   </interval>\\n  <ci>x</ci>\\n \
</apply>\\n</math>\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{109, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->17575],

Cell[TextData[{
 "The ",
 StyleBox["matrix", "MR"],
 " and ",
 StyleBox["matrixrow", "MR"],
 " elements are used to represent a matrix and a row of a matrix, \
respectively. The ",
 StyleBox["eq", "MR"],
 " element is used to express equality. "
}], "Text",
 CellID->4617],

Cell[BoxData[
 FormBox[
  RowBox[{"M", "=", 
   RowBox[{"(", GridBox[{
      {"a", "b"},
      {"c", "d"}
     }], ")"}]}], TraditionalForm]], "DisplayMath",
 FontWeight->"Bold",
 CellID->21890],

Cell[BoxData[
 RowBox[{"<", "math", ">", "\[IndentingNewLine]", "<", "apply", ">", 
  "\[IndentingNewLine]", "<", 
  RowBox[{"eq", "/"}], ">", "\[IndentingNewLine]", "<", "ci", ">", "A", "<", 
  RowBox[{"/", "ci"}], ">", "\[IndentingNewLine]", "<", "matrix", ">", 
  "\[IndentingNewLine]", "<", "matrixrow", ">", "\[IndentingNewLine]", "<", 
  "ci", ">", "a", "<", 
  RowBox[{"/", "ci"}], ">", "\[IndentingNewLine]", "<", "ci", ">", "b", "<", 
  RowBox[{"/", "ci"}], ">", "\[IndentingNewLine]", "<", 
  RowBox[{"/", "matrixrow"}], ">", "\[IndentingNewLine]", "<", "matrixrow", 
  ">", "\[IndentingNewLine]", "<", "ci", ">", "c", "<", 
  RowBox[{"/", "ci"}], ">", "\[IndentingNewLine]", "<", "ci", ">", "d", "<", 
  RowBox[{"/", "ci"}], ">", "\[IndentingNewLine]", "<", 
  RowBox[{"/", "matrixrow"}], ">", "\[IndentingNewLine]", "<", 
  RowBox[{"/", "matrix"}], ">", "\[IndentingNewLine]", "<", 
  RowBox[{"/", "apply"}], ">", "\[IndentingNewLine]", "<", "math", 
  ">"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{110, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->47],

Cell[TextData[{
 "The examples are intended only to illustrate how content markup works \
through a representative sampling of some of its elements. To see a complete \
listing of all the content elements and attributes, see the MathML \
specification at ",
 ButtonBox["http://www.w3.org/TR/MathML2/.",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/MathML2/"], None}],
 " "
}], "Text",
 CellID->30990]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Importing MathML", "Section",
 CellID->23340],

Cell[TextData[{
 "There are two",
 " ",
 "ways to import MathML equations into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellID->26705],

Cell[TextData[{
 "Copy and paste MathML equations from another application, such as a web \
browser, directly into a notebook. When you paste a valid MathML expression \
into a notebook, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " brings up a dialog box asking if you want to paste the literal markup or \
interpret it. If you choose to interpret the markup, it is automatically \
converted into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "BulletedText",
 CellID->6484],

Cell[CellGroupData[{

Cell[TextData[{
 "Use the ",
 StyleBox["Import",
  FontFamily->"Courier"],
 " command with ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 " as the import format."
}], "BulletedText",
 CellID->25643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", "\"\<MathML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29814],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], 
     ",", "\<\"MathMLPresentationTag\"\>", ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{544, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4564]
}, Open  ]],

Cell[TextData[{
 "By default, MathML markup is imported as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression. You can convert the boxes into an expression using the ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " command."
}], "Text",
 CellID->11500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10298],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7682]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathML Import Options", "Subsection",
 CellID->23875],

Cell[TextData[{
 "The standard ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options can be used for greater control over the export process. The \
syntax for specifying a conversion option is as follows. "
}], "Text",
 CellID->30370],

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"], "[", 
  RowBox[{
   StyleBox["file", "TI"], ",", 
   StyleBox["expr", "TI"], ",", 
   ButtonBox["\"\<MathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/MathML"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->14923]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating MathML ", "Section",
 CellID->16498],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 includes several functions for generating MathML from the boxes and \
expressions used internally by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent equations. You can enter an equation in a notebook using \
palettes, menus, or keyboard shortcuts and then convert it into MathML using \
one of these conversion functions. All the MathML conversion functions are \
located in the ",
 Cell[BoxData["XML`MathML`"], "InlineFormula"],
 " context. "
}], "Text",
 CellID->31051],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " to generate MathML from a box structure. By default, this generates \
presentation markup only."
}], "MathCaption",
 CellID->28864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<MathML\>\"", ",", "\"\<Boxes\>\""}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->22677],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\
\\n  <mi>x</mi>\\n  <mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{347, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23023]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " to convert a typeset equation into MathML. By default, this generates \
combined markup with both the presentation and content markup enclosed in a \
",
 StyleBox["semantics", "MR"],
 " element. "
}], "MathCaption",
 CellID->260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<MathML\>\"", ",", "\"\<Expression\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18764],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <msup>\\n   <mi>x</mi>\\n   <mn>2</mn>\\n  </msup>\\n  \
<annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    <power/>\\n    \
<ci>x</ci>\\n    <cn type='integer'>2</cn>\\n   </apply>\\n  \
</annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15117]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["annotation-xml", "MR"],
 " element is used to provide additional information of the type specified by \
its encoding attribute. Here, the encoding attribute has the value ",
 StyleBox["\"MathML-Content\"", "MR"],
 " indicating that the ",
 StyleBox["annotation-xml", "MR"],
 " element contains content MathML. "
}], "Text",
 CellID->15467],

Cell[TextData[{
 "Use \"Presentation\" and \"Semantics\" to generate either presentation \
MathML or content MathML only. Set ",
 Cell[BoxData[
  RowBox[{"\"\<Annotations\>\"", " ", "->", " ", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 " to suppress the header information."
}], "MathCaption",
 CellID->20770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "1"}], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Presentation\>\"", "\[Rule]", "True"}], ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->12919],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mrow>\
\\n  <msup>\\n   <mi>x</mi>\\n   <mn>2</mn>\\n  </msup>\\n  <mo>+</mo>\\n  \
<mn>1</mn>\\n </mrow>\\n</math>\"\>"], "Output",
 ImageSize->{347, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->1207137482]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " evaluates its first argument before converting it to MathML. An expression \
that can be simplified on evaluation may give unexpected results."
}], "Text",
 CellID->297],

Cell["\<\
Generate the presentation markup for the following definite integral.\
\>", "MathCaption",
 CellID->15727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4665],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10300]
}, Open  ]],

Cell["\<\
Since the integral evaluates to 1, this command generates the MathML \
representation of 1 instead of the integral. \
\>", "MathCaption",
 CellID->21888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<MathML\>\"", ",", "\"\<Expression\>\""}], "}"}], ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->14969],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mn>1</mn>\\n</math>\"\>"], "Output",
 ImageSize->{347, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->1081646765]
}, Open  ]],

Cell[TextData[{
 "To get the MathML representation of the integral, force the integral to \
remain unevaluated by wrapping the ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " function around it. "
}], "MathCaption",
 CellID->14398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "]"}], ",", "\"\<MathML\>\"", 
   ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->1244],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mrow>\
\\n  <msubsup>\\n   <mo>&#8747;</mo>\\n   <mn>0</mn>\\n   <mi>&#8734;</mi>\\n \
 </msubsup>\\n  <mrow>\\n   <msup>\\n    <mi>&#8519;</mi>\\n    <mrow>\\n     \
<mo>-</mo>\\n     <mi>x</mi>\\n    </mrow>\\n   </msup>\\n   <mo>&#8290;</mo>\
\\n   <mrow>\\n    <mo>&#8518;</mo>\\n    <mi>x</mi>\\n   </mrow>\\n  </mrow>\
\\n </mrow>\\n</math>\"\>"], "Output",
 ImageSize->{347, 390},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->1514318404]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Options", "Subsection",
 CellID->26850],

Cell["Functions that generate MathML as output:", "Text",
 CellID->20456],

Cell[TextData[Cell[BoxData[
 ButtonBox["ExportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExportString"]], "InlineFormula"]], "BulletedText",
 CellID->25605],

Cell[TextData[Cell[BoxData[
 ButtonBox["BoxesToSymbolicMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/BoxesToSymbolicMathML"]], "InlineFormula"]], "BulletedText",\

 CellID->25810],

Cell[TextData[Cell[BoxData[
 ButtonBox["ExpressionToSymbolicMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/ExpressionToSymbolicMathML"]], "InlineFormula"]], \
"BulletedText",
 CellID->8428],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFormula"]], "BulletedText",
 CellID->3913],

Cell["They all accept these options:", "Text",
 CellID->420]
}, Open  ]],

Cell[TextData[Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->16882],

Cell[TextData[Cell[BoxData["\"\<Presentation\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->3032],

Cell[TextData[Cell[BoxData["\"\<Semantics\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->792508201],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData["\"\<NamespacePrefixes\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->23266],

Cell["\<\
Using these options, you can control various features of the generated \
MathML, such as including an XML or DTD declaration, generating presentation \
markup, content markup, or both, and using an explicit namespace declaration \
and prefix.\
\>", "Text",
 CellID->16387],

Cell[TextData[{
 "You can specify the options explicitly each time you evaluate one of the \
MathML functions. Or use the ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " command to change the default values of the options for a particular \
function. The option values you set are then used for all subsequent \
evaluations of that function. "
}], "Text",
 CellID->20631]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exporting MathML", "Section",
 CellID->31464],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellID->21501],

Cell[TextData[{
 "Use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s sophisticated typesetting capabilities to create \
properly formatted equations and then convert them into MathML for display on \
the web. There are several ways to export mathematical expressions from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook as MathML."
}], "Text",
 CellID->15380],

Cell[TextData[{
 StyleBox["Edit \[RightTriangle] Copy As \[RightTriangle] MathML", 
  "MenuName"],
 " copies the selected expression onto the Clipboard in MathML format. This \
is a convenient way to copy a specific mathematical formula from a notebook \
and paste it into an HTML document. "
}], "BulletedText",
 CellID->30585],

Cell[TextData[{
 "Use ",
 StyleBox["File \[RightTriangle] Save As", "MenuName"],
 ", choosing ",
 StyleBox["XML \[Dash] XHTML+MathML (*.xml)", "MenuName"],
 " from the ",
 StyleBox["Save as Type:", "MenuName"],
 " submenu. This converts your entire notebook into XHTML with all equations \
in the notebook saved as MathML. The equations are embedded in the XHTML file \
in the form of MathML \[OpenCurlyDoubleQuote]data islands,\
\[CloseCurlyDoubleQuote] which can be displayed by a web browser, either \
directly or using a special plug-in."
}], "BulletedText",
 CellID->16702],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 " as the export format or ",
 StyleBox[".mml", "MR"],
 " as the file extension."
}], "BulletedText",
 CellID->11073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->28227],

Cell[BoxData["\<\"test.mml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->2098764397]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->27954],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <msup>\\n   <mi>x</mi>\\n   <mn>2</mn>\\n  </msup>\\n  \
<annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    <power/>\\n    \
<ci>x</ci>\\n    <cn type='integer'>2</cn>\\n   </apply>\\n  \
</annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->621485794]
}, Open  ]],

Cell[TextData[{
 "The output contains both presentation and content markup, enclosed in a ",
 StyleBox["semantics", "MR"],
 " element. You can choose to generate only presentation or content markup by \
changing the value of ",
 Cell[BoxData[
  RowBox[{"\"\<Presentation\>\"", " ", "and", " ", "\"\<Semantics\>\""}]], 
  "InlineFormula"],
 ". The ",
 StyleBox["xmlns", "MR"],
 " attribute is added to the top-level ",
 StyleBox["math", "MR"],
 " element to provide information about the namespace of the enclosed \
elements."
}], "Text",
 CellID->27147]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathML Export Options", "Subsection",
 CellID->371],

Cell[TextData[{
 "The standard options of the ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " functions can be used for greater control over the export process. The \
syntax for specifying a conversion option is:"
}], "Text",
 CellID->1137],

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"], "[", 
  RowBox[{
   StyleBox["file", "TI"], ",", 
   StyleBox["expr", "TI"], ",", 
   ButtonBox["\"\<MathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/MathML"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->26633],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"], "[", 
  RowBox[{
   StyleBox["expr", "TI"], ",", 
   ButtonBox["\"\<MathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/MathML"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option2", "TI"], "->", 
    StyleBox["value2", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->24312],

Cell["\<\
Options can also be specified directly in any function that produces MathML \
as output:\
\>", "Text",
 CellID->7862]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 ButtonBox["XML`MathML`ExpressionToMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/ExpressionToMathML"]], "InlineFormula"]], "BulletedText",
 CellID->5320],

Cell[TextData[Cell[BoxData[
 ButtonBox["XML`MathML`BoxesToMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/BoxesToMathML"]], "InlineFormula"]], "BulletedText",
 CellID->27101],

Cell[TextData[Cell[BoxData[
 ButtonBox["XML`MathML`BoxesToSymbolicMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/BoxesToSymbolicMathML"]], "InlineFormula"]], "BulletedText",\

 CellID->32555],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox["XML`MathML`ExpressionToSymbolicMathML",
  BaseStyle->"Link",
  ButtonData->
   "paclet:XML/ref/ExpressionToSymbolicMathML"]], "InlineFormula"]], \
"BulletedText",
 CellID->4685],

Cell["\<\
The syntax for specifying a conversion option in one of these functions is:\
\>", "Text",
 CellID->28086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XML`MathML`ExpressionToMathML",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/ExpressionToMathML"], "[", 
  RowBox[{
   StyleBox["expr", "TI"], ",", 
   ButtonBox["\"\<MathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/MathML"], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", 
   RowBox[{
    StyleBox["option1", "TI"], "->", 
    StyleBox["value1", "TI"]}], ",", "\[Ellipsis]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->13117],

Cell[TextData[{
 "When exporting as MathML, you can use any of the ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options available for exporting general XML documents. "
}], "Text",
 CellID->22741]
}, Open  ]],

Cell[TextData[Cell[BoxData["\"\<AttributeQuoting\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->19763],

Cell[TextData[Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->10648],

Cell[TextData[Cell[BoxData["\"\<CheckXML\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->27932],

Cell[TextData[Cell[BoxData["\"\<ElementFormatting\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->18667],

Cell[TextData[Cell[BoxData["\"\<Entities\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->28953],

Cell[TextData[Cell[BoxData["\"\<NamespacePrefixes\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->31146],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData["\"\<PrefixCreation\>\""], "InlineFormula"]], \
"BulletedText",
 CellID->213],

Cell["\<\
There are additional options specifically for exporting MathML.\
\>", "Text",
 CellID->23594]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<Presentation\>\""], "InlineFormula"],
 "\[LongDash]controls whether to export presentation MathML"
}], "BulletedText",
 CellID->15707],

Cell[TextData[{
 Cell[BoxData["\"\<Semantics\>\""], "InlineFormula"],
 "\[LongDash]controls whether to export content MathM."
}], "BulletedText",
 CellID->991755513],

Cell[TextData[{
 Cell[BoxData["\"\<IncludeMarkupAnnotations\>\""], "InlineFormula"],
 "\[LongDash]",
 "controls whether to include the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encoding of the expression as an annotation."
}], "BulletedText",
 CellID->12075],

Cell[TextData[{
 Cell[BoxData["\"\<MathAttributes\>\""], "InlineFormula"],
 "\[LongDash]",
 "provides a way to insert additional attributes into the root tag of a \
MathML expression. "
}], "BulletedText",
 CellID->3266],

Cell[TextData[{
 Cell[BoxData["\"\<UseUnicodePlane1Characters\>\""], "InlineFormula"],
 "\[LongDash]",
 "controls whether to include a namespace prefix for each MathML element."
}], "BulletedText",
 CellID->16729]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Annotations\"", "Subsection",
 CellID->18482],

Cell[TextData[{
 "This option controls which annotations are added to the output MathML. The \
value is a list whose elements can be ",
 Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 ". The order of the elements in the list is not relevant. "
}], "Text",
 CellID->24508],

Cell[CellGroupData[{

Cell["XMLDeclaration", "Subsubsection",
 CellID->1802],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 " is one of the annotations, an XML declaration, ",
 StyleBox["<?xml version=\"1.0\"?>", "MR"],
 ", is included in the header."
}], "Text",
 CellID->12494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", 
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DocumentHeader\>\"", ",", "\"\<XMLDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->22571],

Cell[BoxData["\<\"test.mml\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->1814322624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<test.mml\>\"", ",", "\"\<Text\>\""}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->698],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<math \
xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\\n  <mi>x</mi>\\n  \
<mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{347, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->1200037815]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DOCTYPEDeclaration", "Subsubsection",
 CellID->29144],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 " is one of the annotations, an XML document type declaration of the form ",
 StyleBox["<!DOCTYPE ", "MR"],
 StyleBox["...", "TR"],
 StyleBox[">", "MR"],
 " appears in the header. This statement specifies the DTD for the XML \
application in which the output is written."
}], "Text",
 CellID->22444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DocumentHeader\>\"", ",", "\"\<DOCTYPEDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->28101],

Cell[BoxData["\<\"<!DOCTYPE math PUBLIC '-//W3C//DTD MathML 2.0//EN' \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'>\\n<math \
xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\\n  <mi>x</mi>\\n  \
<mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{410, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->2016627728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DocumentHeader", "Subsubsection",
 CellID->18740],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<Annotations\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<DocumentHeader\>\"", ",", " ", "\"\<XMLDeclaration\>\"", ",", " ", 
     "\"\<DOCTYPEDeclaration\>\""}], "}"}]}]], "InlineFormula"],
 " automatically adds a header containing an XML declaration and a document \
type declaration for the MathML DTD to the output."
}], "Text",
 CellID->8303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<DocumentHeader\>\"", ",", "\"\<DOCTYPEDeclaration\>\"", ",", 
      "\"\<XMLDeclaration\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->26559],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<!DOCTYPE math PUBLIC '-//W3C//DTD \
MathML 2.0//EN' 'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'>\\n<math \
xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\\n  <mi>x</mi>\\n  \
<mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{410, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->1875307542]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"],
 " does not contain ",
 Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
 ", then the output MathML has no header. This is true even if the ",
 Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"],
 " contains other elements such as ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->12270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Annotations\>\"", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DOCTYPEDeclaration\>\"", ",", "\"\<XMLDeclaration\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->4788],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\
\\n  <mi>x</mi>\\n  <mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{347, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->1823855022]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Presentation\" and \"Semantics\"", "Subsection",
 CellID->8400],

Cell[TextData[{
 "These option controls which type of MathML markup is generated.",
 " ",
 "The default settings are",
 StyleBox["\"Presentation\"->True and \"Semantics\"->False.",
  FontFamily->"Times New Roman"]
}], "Text",
 CellID->25541],

Cell["Export presentation MathML only.", "MathCaption",
 CellID->19514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Presentation\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->15505],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <msup>\
\\n  <mi>x</mi>\\n  <mn>2</mn>\\n </msup>\\n</math>\"\>"], "Output",
 ImageSize->{347, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->611592310]
}, Open  ]],

Cell["Export content MathML only. ", "MathCaption",
 CellID->22711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<Presentation\>\"", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->17375],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<apply>\\n  <power/>\\n  <ci>x</ci>\\n  <cn type='integer'>2</cn>\\n </apply>\
\\n</math>\"\>"], "Output",
 ImageSize->{347, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->1175219628]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"IncludeMarkupAnnotations\"", "Subsection",
 CellID->8106],

Cell[TextData[{
 "This option determines whether an extra annotation should be added when \
exporting a formula containing constructs specific to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that do not have a clear counterpart in MathML. "
}], "Text",
 CellID->6258],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<IncludeMarkupAnnotations\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "\[Hyphen]specific information is included in a separate annotation \
element (default)"
    }], "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "an extra annotation element is not added", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->27397],

Cell["Values for \"IncludeMarkupAnnotations\".", "Caption",
 CellID->14394],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeMarkupAnnotations\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " annotation is enclosed in a ",
 StyleBox["semantics", "MR"],
 " element. This allows lossless import back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->20159],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " special character, ",
 Cell[BoxData["->"], "InlineFormula"],
 ", does not have a corresponding character in Unicode. (Unicode\
\[CloseCurlyQuote]s right arrow character looks the same but does not have \
the same code point.) When exporting \[Rule], an extra annotation is added to \
the markup. "
}], "MathCaption",
 CellID->27123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<IncludeMarkupAnnotations\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->12415],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mrow>\
\\n  <mi>a</mi>\\n  <semantics>\\n   <mo>&#8594;</mo>\\n   <annotation \
encoding='Mathematica'>&quot;\\\\[Rule]&quot;</annotation>\\n  \
</semantics>\\n  <mi>b</mi>\\n </mrow>\\n</math>\"\>"], "Output",
 ImageSize->{494, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->1047297293]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeMarkupAnnotations\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", no extra annotation is included. "
}], "MathCaption",
 CellID->27822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<IncludeMarkupAnnotations\>\"", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->10258],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mrow>\
\\n  <mi>a</mi>\\n  <mo>&#8594;</mo>\\n  <mi>b</mi>\\n \
</mrow>\\n</math>\"\>"], "Output",
 ImageSize->{347, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->1427791209]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"MathAttributes\"", "Subsection",
 CellID->30876],

Cell[TextData[{
 "This option lets you add attributes to the root element of a MathML \
expression. The option has the syntax ",
 Cell[BoxData[
  RowBox[{"\"\<MathAttributes\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["attribute1", "TI"], " ", "->", " ", 
      StyleBox["value1", "TI"]}], ",", "  ", 
     RowBox[{
      StyleBox["attribute2", "TI"], " ", "->", " ", 
      StyleBox["value2", "TI"]}], ",", 
     StyleBox["...", "TR"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->30396],

Cell["\<\
Export a MathML expression and specify that it should be displayed in inline \
form.\
\>", "MathCaption",
 CellID->18706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<MathAttributes\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<display\>\"", "\[Rule]", " ", "\"\<inline\>\""}], "}"}]}], 
   ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->22105],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'\\n    \
display='inline'>\\n <semantics>\\n  <msup>\\n   <mi>x</mi>\\n   \
<mn>2</mn>\\n  </msup>\\n  <annotation-xml encoding='MathML-Content'>\\n   \
<apply>\\n    <power/>\\n    <ci>x</ci>\\n    <cn type='integer'>2</cn>\\n   \
</apply>\\n  </annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{340, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->1283167267]
}, Open  ]],

Cell["Export a MathML expression in display form.", "MathCaption",
 CellID->8387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<MathAttributes\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<display\>\"", "\[Rule]", " ", "\"\<block\>\""}], "}"}]}], 
   ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->1143],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'\\n    \
display='block'>\\n <semantics>\\n  <msup>\\n   <mi>x</mi>\\n   <mn>2</mn>\\n \
 </msup>\\n  <annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    \
<power/>\\n    <ci>x</ci>\\n    <cn type='integer'>2</cn>\\n   </apply>\\n  \
</annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{340, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->1161473295]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"UseUnicodePlane1Characters\"", "Subsection",
 CellID->16139],

Cell["\<\
This option controls whether plane 1 Unicode characters should be replaced \
with similar plane 0 characters. This is useful because currently most \
browsers cannot properly display plane 1 characters.\
\>", "Text",
 CellID->18388],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["value", "TableHeader"], Cell[
    "effect", "TableHeader"]},
   {"\"\<UseUnicodePlane1Characters\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
special characters belonging to plane 1 of Unicode are exported without being \
replaced (default)\
\>", "TableText"]},
   {
    StyleBox["",
     SingleLetterItalics->False], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "special characters belonging to plane 1 of Unicode are replaced by \
plane 0 characters with an attached ",
     Cell[BoxData["mathvariant"], "InlineFormula"],
     " attribute"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->2839],

Cell["Values for \"UseUnicodePlane1Characters\".", "Caption",
 CellID->2277],

Cell[TextData[{
 "With",
 " ",
 Cell[BoxData["\"\<UseUnicodePlane1Characters\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", special plane 1 Unicode characters (e.g., Gothic, scripted, and \
double-struck characters), are written out with their plane 1 numeric \
character codes."
}], "MathCaption",
 CellID->22372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\[GothicG]", ",", "\"\<MathML\>\""}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->30752],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mi>&#120100;</mi>\\n</math>\"\>"], "Output",
 ImageSize->{347, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->255317835]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<UseUnicodePlane1Characters\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", any special plane 1 Unicode character is replaced by a corresponding \
plane 0 character with a suitable value of the ",
 StyleBox["mathvariant", "MR"],
 " attribute specified. "
}], "MathCaption",
 CellID->4682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\[GothicG]", ",", "\"\<MathML\>\"", ",", 
   RowBox[{"\"\<UseUnicodePlane1Characters\>\"", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->771],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mi \
mathvariant='fraktur'>g</mi>\\n</math>\"\>"], "Output",
 ImageSize->{347, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->454526139]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbols for MathML Elements", "Section",
 CellID->19529],

Cell[TextData[{
 "Since certain content elements in MathML do not have a direct analog in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", a few symbols are specially defined in the XML`MathML` context."
}], "Text",
 CellID->5584],

Cell["Symbols with the MathML markup they are meant to represent. ", \
"MathCaption",
 CellID->1447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "XML`MathML`Symbols`*"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6868],

Cell[BoxData[GridBox[{
   {
    StyleBox["XML`MathML`Symbols`",
     FontFamily->"Helvetica",
     FontSize->12,
     FontWeight->"Bold"]},
   {GridBox[{
      {
       ButtonBox[
        StyleBox["Cardinality",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`Cardinality"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["CovariantDerivativeIndex",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", 
          "XML`MathML`Symbols`CovariantDerivativeIndex"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IndefiniteSum",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IndefiniteSum"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["CartesianProduct",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`CartesianProduct"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Declare",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Declare"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IntervalClosed",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IntervalClosed"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["Codomain",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Codomain"},
        
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["DerivativeIndex",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`DerivativeIndex"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IntervalClosedOpen",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IntervalClosedOpen"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedIntegrate",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedIntegrate"},
        
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Divides",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Divides"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IntervalOpen",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IntervalOpen"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedLimit",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedLimit"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Domain",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Domain"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IntervalOpenClosed",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IntervalOpenClosed"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedList",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedList"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["DomainIntegrate",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`DomainIntegrate"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Moment",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Moment"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedMax",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedMax"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["DomainOfApplication",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`DomainOfApplication"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["MomentAbout",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`MomentAbout"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedMin",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedMin"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["DomainProduct",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`DomainProduct"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Multiscripts",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`Multiscripts"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedProduct",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedProduct"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["DomainSum",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`DomainSum"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Otherwise",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`Otherwise"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedSet",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedSet"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Image",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Image"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Piece",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{"Info3262951743-8292581", "XML`MathML`Symbols`Piece"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]},
      {
       ButtonBox[
        StyleBox["ConditionedSum",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`ConditionedSum"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["IndefiniteProduct",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`IndefiniteProduct"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic], 
       ButtonBox[
        StyleBox["Piecewise",
         FontVariations->{"Underline"->True},
         FontColor->RGBColor[0, 0, 1]],
        ButtonData:>{
         "Info3262951743-8292581", "XML`MathML`Symbols`Piecewise"},
        ButtonFrame->"None",
        ButtonFunction:>(Internal`PutInformation[#, LongForm -> False]& ),
        ButtonNote->"XML`MathML`Symbols`",
        Evaluator->Automatic]}
     },
     GridBoxItemSize->{
      "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, {1.05}}, 
       "RowsIndexed" -> {}}]}
  },
  ColumnsEqual->True,
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, 0.8, {1.2}, 0.2}, "RowsIndexed" -> {}}]], "Print",
 ShowCellLabel->False,
 CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 ButtonBoxOptions->{Active->True},
 CellID->3939]
}, Open  ]],

Cell["\<\
Examples that use these symbols. These all have a traditional typeset form.\
\>", "MathCaption",
 CellID->11999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`Piecewise", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"XML`MathML`Piece", "[", 
    RowBox[{"r", ",", 
     RowBox[{"0", "<", "y", "<", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"XML`MathML`Piece", "[", 
    RowBox[{"t", ",", 
     RowBox[{"0", "<", "y", "<", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"XML`MathML`Otherwise", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->19615],

Cell[BoxData[
 RowBox[{"XML`MathML`Piecewise", "[", 
  RowBox[{
   RowBox[{"XML`MathML`Piece", "[", 
    RowBox[{"r", ",", 
     RowBox[{"0", "<", "y", "<", "1"}]}], "]"}], ",", 
   RowBox[{"XML`MathML`Piece", "[", 
    RowBox[{"t", ",", 
     RowBox[{"0", "<", "y", "<", "1"}]}], "]"}], ",", 
   RowBox[{"XML`MathML`Otherwise", "[", "2", "]"}]}], "]"}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->25522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`Multiscripts", "[", 
  RowBox[{"G", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "None"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"None", ",", "c"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->24242],

Cell[BoxData[
 RowBox[{"XML`MathML`Multiscripts", "[", 
  RowBox[{"G", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "None"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"None", ",", "c"}], "}"}], "}"}]}], "]"}]], "Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->14712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConditionedLimit", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"x", "<", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->24707],

Cell[BoxData[
 RowBox[{"ConditionedLimit", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"x", "<", "3"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->13631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConditionedSum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "<", "10"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->18848],

Cell[BoxData[
 RowBox[{"ConditionedSum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "<", "10"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->17454]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->235231338],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "RelatedTutorials",
 CellID->1866278227],

Cell[TextData[ButtonBox["Representing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/RepresentingXML"]], "RelatedTutorials",
 CellID->1368766954],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "RelatedTutorials",
 CellID->296442083],

Cell[TextData[ButtonBox["Exporting XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ExportingXML"]], "RelatedTutorials",
 CellID->523248764],

Cell[TextData[ButtonBox["Transforming XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/TransformingXML"]], "RelatedTutorials",
 CellID->616508677]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with MathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 45.0937450}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Tutorial", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "MathML is an XML-based markup language for representing mathematics. It \
was developed by the W3C to provide an effective way to display math in web \
pages and facilitate the transfer and re-use of mathematical content between \
applications. The great advantage is that it can encode information about \
both the meaning and appearance of mathematical notation. This makes it an \
ideal data format for storing and exchanging mathematical information. For \
example, a MathML equation can be copied out of a web page and directly \
pasted into an application like Mathematica for evaluation. As a common and \
widely accepted standard for representing mathematics, MathML provides the \
foundation for many interesting and useful applications. For example, you can \
use MathML to create dynamic mathematical websites featuring interactive \
equations, set up a database of technical documents whose contents can be \
easily searched, indexed, and archived, or develop speech synthesis software \
for audio rendering of mathematics. MathML has grown rapidly in popularity \
since it was first released in 1998, gaining broad support in both industry \
and academia. It is currently possible to view MathML equations in the \
leading web browsers, either directly or using freely available plug-ins. As \
more tools for authoring, viewing, and processing MathML become available, \
its importance is only expected to grow. ", "synonyms" -> {}, "title" -> 
    "Working with MathML", "type" -> "Tutorial", "uri" -> 
    "XML/tutorial/MathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1150, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1775, 52, 75, 2, 70, "Title",
 PageBreakAbove->True,
 CellID->16088],
Cell[CellGroupData[{
Cell[1875, 58, 47, 1, 70, "Section",
 CellID->29467],
Cell[1925, 61, 685, 13, 70, "Text",
 CellID->31375],
Cell[2613, 76, 478, 8, 70, "Text",
 CellID->21163],
Cell[3094, 86, 429, 8, 70, "Text",
 CellID->11612],
Cell[3526, 96, 676, 16, 70, "Text",
 CellID->10474]
}, Open  ]],
Cell[CellGroupData[{
Cell[4239, 117, 51, 1, 70, "Section",
 CellID->13649],
Cell[CellGroupData[{
Cell[4315, 122, 46, 1, 70, "Subsection",
 CellID->27930],
Cell[4364, 125, 367, 7, 70, "Text",
 CellID->24628],
Cell[4734, 134, 162, 4, 70, "Text",
 CellID->25395],
Cell[4899, 140, 198, 6, 70, "Text",
 CellID->583],
Cell[5100, 148, 425, 13, 70, "Text",
 CellID->13833],
Cell[5528, 163, 359, 10, 70, "Text",
 CellID->3127],
Cell[5890, 175, 111, 3, 70, "Text",
 CellID->2045],
Cell[6004, 180, 273, 5, 70, "BulletedText",
 CellID->25000],
Cell[6280, 187, 359, 9, 70, "BulletedText",
 CellID->21985],
Cell[CellGroupData[{
Cell[6664, 200, 427, 7, 70, "BulletedText",
 CellID->31990],
Cell[7094, 209, 186, 7, 70, "Text",
 CellID->9772]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7329, 222, 56, 1, 70, "Subsection",
 CellID->4638],
Cell[7388, 225, 372, 10, 70, "Text",
 CellID->3771],
Cell[7763, 237, 113, 4, 70, "DisplayMath",
 Evaluatable->False,
 CellID->12793],
Cell[7879, 243, 223, 5, 139, "Output",
 CellID->11696],
Cell[8105, 250, 227, 6, 70, "Text",
 CellID->14373],
Cell[8335, 258, 137, 4, 70, "BulletedText",
 CellID->22061],
Cell[8475, 264, 159, 5, 70, "BulletedText",
 CellID->24908],
Cell[8637, 271, 126, 4, 70, "BulletedText",
 CellID->30716],
Cell[CellGroupData[{
Cell[8788, 279, 109, 4, 70, "BulletedText",
 CellID->5300],
Cell[8900, 285, 455, 8, 70, "Text",
 CellID->16739],
Cell[9358, 295, 763, 22, 70, "Text",
 CellID->827],
Cell[10124, 319, 171, 7, 70, "DisplayMath",
 Evaluatable->False,
 CellID->13497],
Cell[10298, 328, 339, 7, 275, "Output",
 CellID->3872],
Cell[10640, 337, 561, 16, 70, "Text",
 CellID->30578]
}, Open  ]],
Cell[11216, 356, 187, 9, 70, "IndentedText",
 CellID->19289],
Cell[CellGroupData[{
Cell[11428, 369, 179, 9, 70, "IndentedText",
 CellID->3772],
Cell[11610, 380, 449, 14, 70, "Text",
 CellID->5693],
Cell[12062, 396, 270, 9, 70, "DisplayMath",
 Evaluatable->False,
 CellID->7658],
Cell[12335, 407, 535, 11, 360, "Output",
 CellID->12999],
Cell[12873, 420, 212, 6, 70, "Text",
 CellID->7478]
}, Open  ]],
Cell[CellGroupData[{
Cell[13122, 431, 221, 11, 70, "IndentedText",
 CellID->7366],
Cell[13346, 444, 536, 13, 70, "Text",
 CellID->29610],
Cell[13885, 459, 443, 12, 70, "Text",
 CellID->30642],
Cell[14331, 473, 226, 8, 70, "DisplayMath",
 Evaluatable->False,
 CellID->29995],
Cell[14560, 483, 506, 11, 326, "Output",
 CellID->13567],
Cell[15069, 496, 419, 10, 70, "Text",
 CellID->3577]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15537, 512, 52, 1, 70, "Subsection",
 CellID->13854],
Cell[15592, 515, 572, 16, 70, "Text",
 CellID->28454],
Cell[16167, 533, 91, 3, 70, "DisplayMath",
 CellID->3992],
Cell[16261, 538, 222, 5, 139, "Output",
 CellID->27602],
Cell[16486, 545, 542, 14, 70, "Text",
 CellID->32226],
Cell[17031, 561, 627, 23, 70, "Text",
 CellID->29994],
Cell[17661, 586, 92, 3, 70, "DisplayMath",
 CellID->25045],
Cell[17756, 591, 250, 7, 71, "Output",
 CellID->21374],
Cell[18009, 600, 121, 4, 70, "DisplayMath",
 CellID->2548],
Cell[18133, 606, 259, 7, 71, "Output",
 CellID->27883],
Cell[18395, 615, 296, 5, 70, "Text",
 CellID->30444],
Cell[18694, 622, 70, 1, 70, "BulletedText",
 CellID->11881],
Cell[18767, 625, 60, 1, 70, "BulletedText",
 CellID->31975],
Cell[18830, 628, 47, 1, 70, "BulletedText",
 CellID->4670],
Cell[18880, 631, 54, 1, 70, "BulletedText",
 CellID->28847],
Cell[18937, 634, 60, 1, 70, "BulletedText",
 CellID->22318],
Cell[19000, 637, 54, 1, 70, "BulletedText",
 CellID->18098],
Cell[CellGroupData[{
Cell[19079, 642, 50, 1, 70, "BulletedText",
 CellID->21967],
Cell[19132, 645, 438, 16, 70, "Text",
 CellID->31594],
Cell[19573, 663, 149, 6, 70, "DisplayMath",
 CellID->3572],
Cell[19725, 671, 550, 11, 411, "Output",
 CellID->6067],
Cell[20278, 684, 390, 13, 70, "Text",
 CellID->5138],
Cell[20671, 699, 213, 7, 70, "DisplayMath",
 CellID->30991],
Cell[20887, 708, 390, 9, 275, "Output",
 CellID->1789],
Cell[21280, 719, 520, 21, 70, "Text",
 CellID->1268],
Cell[21803, 742, 115, 4, 70, "DisplayMath",
 CellID->14460],
Cell[21921, 748, 273, 7, 122, "Output",
 CellID->26512],
Cell[22197, 757, 129, 5, 70, "DisplayMath",
 CellID->18300],
Cell[22329, 764, 322, 8, 122, "Output",
 CellID->16812],
Cell[22654, 774, 258, 10, 70, "Text",
 CellID->8434],
Cell[22915, 786, 212, 7, 70, "DisplayMath",
 CellID->1677],
Cell[23130, 795, 337, 8, 207, "Output",
 CellID->17575],
Cell[23470, 805, 272, 10, 70, "Text",
 CellID->4617],
Cell[23745, 817, 194, 8, 70, "DisplayMath",
 CellID->21890],
Cell[23942, 827, 1134, 22, 292, "Output",
 CellID->47],
Cell[25079, 851, 427, 11, 70, "Text",
 CellID->30990]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25567, 869, 51, 1, 70, "Section",
 CellID->23340],
Cell[25621, 872, 163, 8, 70, "Text",
 CellID->26705],
Cell[25787, 882, 512, 13, 70, "BulletedText",
 CellID->6484],
Cell[CellGroupData[{
Cell[26324, 899, 285, 11, 70, "BulletedText",
 CellID->25643],
Cell[CellGroupData[{
Cell[26634, 914, 149, 4, 70, "Input",
 CellID->29814],
Cell[26786, 920, 462, 14, 54, "Output",
 CellID->4564]
}, Open  ]],
Cell[27263, 937, 357, 11, 70, "Text",
 CellID->11500],
Cell[CellGroupData[{
Cell[27645, 952, 104, 3, 70, "Input",
 CellID->10298],
Cell[27752, 957, 176, 6, 36, "Output",
 CellID->7682]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27977, 969, 59, 1, 70, "Subsection",
 CellID->23875],
Cell[28039, 972, 309, 9, 70, "Text",
 CellID->30370],
Cell[28351, 983, 560, 18, 70, "IndentedText",
 CellID->14923]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28960, 1007, 53, 1, 70, "Section",
 CellID->16498],
Cell[29016, 1010, 563, 14, 70, "Text",
 CellID->31051],
Cell[29582, 1026, 286, 9, 70, "MathCaption",
 CellID->28864],
Cell[CellGroupData[{
Cell[29893, 1039, 286, 9, 70, "Input",
 CellID->22677],
Cell[30182, 1050, 275, 6, 122, "Output",
 CellID->23023]
}, Open  ]],
Cell[30472, 1059, 384, 12, 70, "MathCaption",
 CellID->260],
Cell[CellGroupData[{
Cell[30881, 1075, 234, 8, 70, "Input",
 CellID->18764],
Cell[31118, 1085, 476, 9, 275, "Output",
 CellID->15117]
}, Open  ]],
Cell[31609, 1097, 375, 10, 70, "Text",
 CellID->15467],
Cell[31987, 1109, 312, 8, 70, "MathCaption",
 CellID->20770],
Cell[CellGroupData[{
Cell[32324, 1121, 419, 10, 70, "Input",
 CellID->12919],
Cell[32746, 1133, 338, 7, 190, "Output",
 CellID->1207137482]
}, Open  ]],
Cell[33099, 1143, 315, 8, 70, "Text",
 CellID->297],
Cell[33417, 1153, 116, 3, 70, "MathCaption",
 CellID->15727],
Cell[CellGroupData[{
Cell[33558, 1160, 245, 8, 70, "Input",
 CellID->4665],
Cell[33806, 1170, 154, 5, 36, "Output",
 CellID->10300]
}, Open  ]],
Cell[33975, 1178, 163, 4, 70, "MathCaption",
 CellID->21888],
Cell[CellGroupData[{
Cell[34163, 1186, 482, 14, 70, "Input",
 CellID->14969],
Cell[34648, 1202, 243, 6, 71, "Output",
 CellID->1081646765]
}, Open  ]],
Cell[34906, 1211, 314, 9, 70, "MathCaption",
 CellID->14398],
Cell[CellGroupData[{
Cell[35245, 1224, 464, 14, 70, "Input",
 CellID->1244],
Cell[35712, 1240, 569, 10, 411, "Output",
 CellID->1514318404]
}, Open  ]],
Cell[CellGroupData[{
Cell[36318, 1255, 53, 1, 70, "Subsection",
 CellID->26850],
Cell[36374, 1258, 73, 1, 70, "Text",
 CellID->20456],
Cell[36450, 1261, 169, 4, 70, "BulletedText",
 CellID->25605],
Cell[36622, 1267, 197, 6, 70, "BulletedText",
 CellID->25810],
Cell[36822, 1275, 206, 6, 70, "BulletedText",
 CellID->8428],
Cell[CellGroupData[{
Cell[37053, 1285, 156, 4, 70, "BulletedText",
 CellID->3913],
Cell[37212, 1291, 60, 1, 70, "Text",
 CellID->420]
}, Open  ]],
Cell[37287, 1295, 103, 2, 70, "BulletedText",
 CellID->16882],
Cell[37393, 1299, 103, 2, 70, "BulletedText",
 CellID->3032],
Cell[37499, 1303, 105, 2, 70, "BulletedText",
 CellID->792508201],
Cell[CellGroupData[{
Cell[37629, 1309, 109, 2, 70, "BulletedText",
 CellID->23266],
Cell[37741, 1313, 282, 6, 70, "Text",
 CellID->16387],
Cell[38026, 1321, 452, 11, 70, "Text",
 CellID->20631]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38539, 1339, 51, 1, 70, "Section",
 CellID->31464],
Cell[CellGroupData[{
Cell[38615, 1344, 50, 1, 70, "Subsection",
 CellID->21501],
Cell[38668, 1347, 404, 11, 70, "Text",
 CellID->15380],
Cell[39075, 1360, 328, 7, 70, "BulletedText",
 CellID->30585],
Cell[39406, 1369, 578, 13, 70, "BulletedText",
 CellID->16702],
Cell[CellGroupData[{
Cell[40009, 1386, 410, 15, 70, "BulletedText",
 CellID->11073],
Cell[CellGroupData[{
Cell[40444, 1405, 162, 5, 70, "Input",
 CellID->28227],
Cell[40609, 1412, 175, 5, 36, "Output",
 CellID->2098764397]
}, Open  ]],
Cell[CellGroupData[{
Cell[40821, 1422, 225, 6, 70, "Input",
 CellID->27954],
Cell[41049, 1430, 481, 9, 275, "Output",
 CellID->621485794]
}, Open  ]],
Cell[41545, 1442, 553, 15, 70, "Text",
 CellID->27147]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42147, 1463, 57, 1, 70, "Subsection",
 CellID->371],
Cell[42207, 1466, 449, 14, 70, "Text",
 CellID->1137],
Cell[42659, 1482, 560, 18, 70, "IndentedText",
 CellID->26633],
Cell[CellGroupData[{
Cell[43244, 1504, 539, 17, 70, "IndentedText",
 CellID->24312],
Cell[43786, 1523, 127, 4, 70, "Text",
 CellID->7862]
}, Open  ]],
Cell[43928, 1530, 199, 5, 70, "BulletedText",
 CellID->5320],
Cell[44130, 1537, 190, 5, 70, "BulletedText",
 CellID->27101],
Cell[44323, 1544, 208, 6, 70, "BulletedText",
 CellID->32555],
Cell[CellGroupData[{
Cell[44556, 1554, 217, 6, 70, "BulletedText",
 CellID->4685],
Cell[44776, 1562, 115, 3, 70, "Text",
 CellID->28086]
}, Open  ]],
Cell[CellGroupData[{
Cell[44928, 1570, 566, 17, 70, "IndentedText",
 CellID->13117],
Cell[45497, 1589, 272, 8, 70, "Text",
 CellID->22741]
}, Open  ]],
Cell[45784, 1600, 108, 2, 70, "BulletedText",
 CellID->19763],
Cell[45895, 1604, 103, 2, 70, "BulletedText",
 CellID->10648],
Cell[46001, 1608, 100, 2, 70, "BulletedText",
 CellID->27932],
Cell[46104, 1612, 109, 2, 70, "BulletedText",
 CellID->18667],
Cell[46216, 1616, 100, 2, 70, "BulletedText",
 CellID->28953],
Cell[46319, 1620, 109, 2, 70, "BulletedText",
 CellID->31146],
Cell[CellGroupData[{
Cell[46453, 1626, 104, 2, 70, "BulletedText",
 CellID->213],
Cell[46560, 1630, 103, 3, 70, "Text",
 CellID->23594]
}, Open  ]],
Cell[46678, 1636, 169, 4, 70, "BulletedText",
 CellID->15707],
Cell[46850, 1642, 165, 4, 70, "BulletedText",
 CellID->991755513],
Cell[47018, 1648, 271, 8, 70, "BulletedText",
 CellID->12075],
Cell[47292, 1658, 220, 6, 70, "BulletedText",
 CellID->3266],
Cell[47515, 1666, 213, 5, 70, "BulletedText",
 CellID->16729]
}, Open  ]],
Cell[CellGroupData[{
Cell[47765, 1676, 53, 1, 70, "Subsection",
 CellID->18482],
Cell[47821, 1679, 422, 10, 70, "Text",
 CellID->24508],
Cell[CellGroupData[{
Cell[48268, 1693, 54, 1, 70, "Subsubsection",
 CellID->1802],
Cell[48325, 1696, 241, 7, 70, "Text",
 CellID->12494],
Cell[CellGroupData[{
Cell[48591, 1707, 347, 9, 70, "Input",
 CellID->22571],
Cell[48941, 1718, 175, 5, 36, "Output",
 CellID->1814322624]
}, Open  ]],
Cell[CellGroupData[{
Cell[49153, 1728, 146, 4, 70, "Input",
 CellID->698],
Cell[49302, 1734, 307, 7, 139, "Output",
 CellID->1200037815]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49658, 1747, 59, 1, 70, "Subsubsection",
 CellID->29144],
Cell[49720, 1750, 389, 10, 70, "Text",
 CellID->22444],
Cell[CellGroupData[{
Cell[50134, 1764, 332, 9, 70, "Input",
 CellID->28101],
Cell[50469, 1775, 386, 8, 156, "Output",
 CellID->2016627728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50904, 1789, 55, 1, 70, "Subsubsection",
 CellID->18740],
Cell[50962, 1792, 409, 10, 70, "Text",
 CellID->8303],
Cell[CellGroupData[{
Cell[51396, 1806, 370, 10, 70, "Input",
 CellID->26559],
Cell[51769, 1818, 410, 8, 173, "Output",
 CellID->1875307542]
}, Open  ]],
Cell[52194, 1829, 491, 13, 70, "Text",
 CellID->12270],
Cell[CellGroupData[{
Cell[52710, 1846, 331, 9, 70, "Input",
 CellID->4788],
Cell[53044, 1857, 281, 6, 122, "Output",
 CellID->1823855022]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53386, 1870, 71, 1, 70, "Subsection",
 CellID->8400],
Cell[53460, 1873, 241, 7, 70, "Text",
 CellID->25541],
Cell[53704, 1882, 71, 1, 70, "MathCaption",
 CellID->19514],
Cell[CellGroupData[{
Cell[53800, 1887, 228, 6, 70, "Input",
 CellID->15505],
Cell[54031, 1895, 280, 6, 122, "Output",
 CellID->611592310]
}, Open  ]],
Cell[54326, 1904, 67, 1, 70, "MathCaption",
 CellID->22711],
Cell[CellGroupData[{
Cell[54418, 1909, 293, 7, 70, "Input",
 CellID->17375],
Cell[54714, 1918, 313, 7, 139, "Output",
 CellID->1175219628]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55076, 1931, 65, 1, 70, "Subsection",
 CellID->8106],
Cell[55144, 1934, 277, 7, 70, "Text",
 CellID->6258],
Cell[55424, 1943, 830, 23, 70, "DefinitionBox3Col",
 CellID->27397],
Cell[56257, 1968, 75, 1, 70, "Caption",
 CellID->14394],
Cell[56335, 1971, 453, 17, 70, "Text",
 CellID->20159],
Cell[56791, 1990, 409, 11, 70, "MathCaption",
 CellID->27123],
Cell[CellGroupData[{
Cell[57225, 2005, 248, 7, 70, "Input",
 CellID->12415],
Cell[57476, 2014, 416, 8, 190, "Output",
 CellID->1047297293]
}, Open  ]],
Cell[57907, 2025, 270, 9, 70, "MathCaption",
 CellID->27822],
Cell[CellGroupData[{
Cell[58202, 2038, 249, 7, 70, "Input",
 CellID->10258],
Cell[58454, 2047, 304, 7, 139, "Output",
 CellID->1427791209]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58807, 2060, 56, 1, 70, "Subsection",
 CellID->30876],
Cell[58866, 2063, 537, 16, 70, "Text",
 CellID->30396],
Cell[59406, 2081, 131, 4, 70, "MathCaption",
 CellID->18706],
Cell[CellGroupData[{
Cell[59562, 2089, 379, 10, 70, "Input",
 CellID->22105],
Cell[59944, 2101, 505, 9, 292, "Output",
 CellID->1283167267]
}, Open  ]],
Cell[60464, 2113, 81, 1, 70, "MathCaption",
 CellID->8387],
Cell[CellGroupData[{
Cell[60570, 2118, 377, 10, 70, "Input",
 CellID->1143],
Cell[60950, 2130, 504, 9, 292, "Output",
 CellID->1161473295]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61503, 2145, 68, 1, 70, "Subsection",
 CellID->16139],
Cell[61574, 2148, 242, 5, 70, "Text",
 CellID->18388],
Cell[61819, 2155, 973, 27, 70, "DefinitionBox3Col",
 CellID->2839],
Cell[62795, 2184, 76, 1, 70, "Caption",
 CellID->2277],
Cell[62874, 2187, 420, 13, 70, "MathCaption",
 CellID->22372],
Cell[CellGroupData[{
Cell[63319, 2204, 150, 4, 70, "Input",
 CellID->30752],
Cell[63472, 2210, 250, 6, 71, "Output",
 CellID->255317835]
}, Open  ]],
Cell[63737, 2219, 439, 13, 70, "MathCaption",
 CellID->4682],
Cell[CellGroupData[{
Cell[64201, 2236, 228, 6, 70, "Input",
 CellID->771],
Cell[64432, 2244, 264, 6, 71, "Output",
 CellID->454526139]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64757, 2257, 62, 1, 70, "Section",
 CellID->19529],
Cell[64822, 2260, 237, 6, 70, "Text",
 CellID->5584],
Cell[65062, 2268, 100, 2, 70, "MathCaption",
 CellID->1447],
Cell[CellGroupData[{
Cell[65187, 2274, 101, 3, 70, "Input",
 CellID->6868],
Cell[65291, 2279, 14411, 361, 70, "Print",
 CellID->3939]
}, Open  ]],
Cell[79717, 2643, 122, 3, 70, "MathCaption",
 CellID->11999],
Cell[CellGroupData[{
Cell[79864, 2650, 473, 11, 70, "Input",
 CellID->19615],
Cell[80340, 2663, 493, 14, 54, "Output",
 CellID->25522]
}, Open  ]],
Cell[CellGroupData[{
Cell[80870, 2682, 305, 10, 70, "Input",
 CellID->24242],
Cell[81178, 2694, 394, 13, 36, "Output",
 CellID->14712]
}, Open  ]],
Cell[CellGroupData[{
Cell[81609, 2712, 268, 9, 70, "Input",
 CellID->24707],
Cell[81880, 2723, 357, 12, 36, "Output",
 CellID->13631]
}, Open  ]],
Cell[CellGroupData[{
Cell[82274, 2740, 235, 8, 70, "Input",
 CellID->18848],
Cell[82512, 2750, 324, 11, 36, "Output",
 CellID->17454]
}, Open  ]],
Cell[CellGroupData[{
Cell[82873, 2766, 72, 1, 70, "RelatedTutorialsSection",
 CellID->235231338],
Cell[82948, 2769, 151, 3, 70, "RelatedTutorials",
 CellID->1866278227],
Cell[83102, 2774, 158, 3, 70, "RelatedTutorials",
 CellID->1368766954],
Cell[83263, 2779, 151, 3, 70, "RelatedTutorials",
 CellID->296442083],
Cell[83417, 2784, 151, 3, 70, "RelatedTutorials",
 CellID->523248764],
Cell[83571, 2789, 157, 3, 70, "RelatedTutorials",
 CellID->616508677]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[83767, 2797, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

