(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    283487,       8750]
NotebookOptionsPosition[    264084,       8056]
NotebookOutlinePosition[    266146,       8103]
CellTagsIndexPosition[    266103,       8100]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"XML Capabilities" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
         "Representing XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/RepresentingXML"], 
         "Importing XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"], 
         "Exporting XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ExportingXML"], 
         "MathML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
      2->"\<\"Representing XML\"\>", 3->"\<\"Importing XML\"\>", 
      4->"\<\"Exporting XML\"\>", 
      5->"\<\"MathML\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Transforming XML", "Title",
 PageBreakAbove->True,
 CellID->3388],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->2497],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is uniquely suited for processing symbolic expressions because of its \
powerful pattern-matching abilities and large collection of built-in \
structural manipulation functions. This tutorial provides a few examples to \
illustrate the use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for processing XML data."
}], "Text",
 CellID->27711],

Cell[TextData[{
 "When you import an arbitrary XML document into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is automatically converted into a symbolic XML expression. Symbolic \
XML is the format used for representing XML documents in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax. The conversion to symbolic XML translates the XML document into a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, while preserving its structure. The advantage of converting \
XML data into symbolic XML is that you can directly manipulate symbolic XML \
using any of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s built-in functions. "
}], "Text",
 CellID->11091],

Cell["Convert an XML string into symbolic XML.", "MathCaption",
 CellID->11874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"ImportString", "[", 
   RowBox[{
   "\"\<<colors><blue/><blue/><red/><blue/><red/></colors>\>\"", ",", 
    "\"\<XML\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18563],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"colors\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"red\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"red\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{567, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9125]
}, Open  ]],

Cell["\<\
Use a simple transformation rule to remove the unwanted \
\[OpenCurlyDoubleQuote]red\[CloseCurlyDoubleQuote] element from the list.\
\>", "MathCaption",
 CellID->7007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newdata", "=", 
  RowBox[{"data", "/.", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<red\>\"", ",", "__"}], "]"}], "\[Rule]", 
    RowBox[{"Sequence", "[", "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18370],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"colors\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"blue\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{581, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15121]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " to convert symbolic XML into native XML syntax, which was designed to be \
easy to read."
}], "MathCaption",
 CellID->7727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"newdata", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2658],

Cell[BoxData["\<\"<colors>\\n <blue/>\\n <blue/>\\n \
<blue/>\\n</colors>\"\>"], "Output",
 ImageSize->{67, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24336]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualizing the XML Tree", "Section",
 CellID->18275],

Cell[TextData[{
 "Many XML tools display an XML document as a collapsible tree, where the \
nodes correspond to the elements of the document. This example shows how to \
produce a similar visualization using cell grouping in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellID->1221],

Cell[TextData[{
 "We will do this by recursively traversing the symbolic XML expression and \
creating a ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " expression that contains cells for each of ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " object\[CloseCurlyQuote]s attributes and children. Each nested ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " expression will be indented from the previous one. We start with the \
function to process an ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " object."
}], "Text",
 CellID->11576],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLNote", "[", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"tag_", ",", "attributes_", ",", "data_"}], "]"}], ",", " ", 
    "m_Integer"}], "]"}], ":=", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"TextData", "[", "\[IndentingNewLine]", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"tag", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Swiss\>\""}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], "]"}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Sequence", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"XMLNote", "[", 
             RowBox[{"#1", ",", "m"}], "]"}], "&"}], ")"}], "/@", 
          "attributes"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Sequence", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"XMLNote", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"m", "+", "30"}]}], "]"}], "&"}], ")"}], "/@", 
          "data"}]}]}], "\[IndentingNewLine]", "}"}], ",", "Open"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "Inherited"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1799],

Cell[TextData[{
 "We use the integer ",
 StyleBox["m", "TI"],
 " for indentation. When we map ",
 Cell[BoxData["XMLNote"], "InlineFormula"],
 " onto the ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " object",
 "\[CloseCurlyQuote]",
 "s children, we pass a larger value for ",
 StyleBox["m", "TI"],
 ", increasing the indentation for the child elements."
}], "Text",
 CellID->24919],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " expression contains a list of cells. In the definition, we have only \
created a cell for the ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " x. However, we have then mapped ",
 Cell[BoxData["XMLNote"], "InlineFormula"],
 " onto the attribute list. Since this returns a list, we need to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", " ", 
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"], "]"}]], "InlineFormula"],
 " to the result in order to merge that list into the ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " expression",
 "\[CloseCurlyQuote]",
 "s list of cells. We then do the same thing to the children of the ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 "."
}], "Text",
 CellID->14241],

Cell[TextData[{
 "However, we have not yet defined ",
 Cell[BoxData["XMLNote"], "InlineFormula"],
 " to work on attributes. The attributes of an ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " object are stored in symbolic XML as rules. In most cases, the rule \
contains two strings: the key and the value. However, when namespaces are \
involved, the first element of the rule may be a list containing two strings: \
the namespace and the key. We will need to make two definitions to handle the \
attributes."
}], "Text",
 CellID->28611],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLNote", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"an_String", ",", "a_String"}], "}"}], "\[Rule]", "v_String"}], 
    ",", "m_Integer"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StyleBox", "[", 
       RowBox[{"an", ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"Hue", "[", "0.6", "]"}]}]}], "]"}], ",", "\"\< \>\"", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"StyleBox", "[", 
       RowBox[{"a", ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
      "\"\< = \>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"StyleBox", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"m", "+", "5"}], ",", "Inherited"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->5712],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLNote", "[", 
   RowBox[{
    RowBox[{"a_String", "\[Rule]", "v_String"}], ",", "m_Integer"}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StyleBox", "[", 
       RowBox[{"a", ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
      "\"\< = \>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"StyleBox", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"m", "+", "5"}], ",", "Inherited"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30209],

Cell[TextData[{
 "We will need one more definition in order to process simple symbolic XML \
expressions. The text nodes in an XML document are stored simply as ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " objects in symbolic XML. Thus, we need a definition that handles ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " objects."
}], "Text",
 CellID->23635],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLNote", "[", 
   RowBox[{"s_String", ",", "m_Integer"}], "]"}], ":=", "\[IndentingNewLine]",
   
  RowBox[{"Cell", "[", 
   RowBox[{"s", ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "0.9", "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"m", "+", "25"}], ",", "Inherited"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->23263],

Cell["\<\
Construct a simple notebook to visualize a basic XML document. \
\>", "MathCaption",
 CellID->17830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"ImportString", "[", 
   RowBox[{
    RowBox[{"ExportString", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["2"]], ",", "\"\<MathML\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XML\>\"", ",", "\"\<XMLObject\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->8514],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"xmlns\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"semantics\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mfrac\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mn\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"msqrt\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"mn\"\>", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}], "}"}]}], "]"}]}],
              "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"annotation-xml\"\>", ",", 
            RowBox[{"{", 
             
             RowBox[{"\<\"encoding\"\>", 
              "\[Rule]", "\<\"MathML-Content\"\>"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"XMLElement", "[", 
              RowBox[{"\<\"apply\"\>", ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"times\"\>", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"cn\"\>", ",", 
                   RowBox[{"{", 
                    RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                    "}"}], ",", 
                   RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\<\"apply\"\>", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"power\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"apply\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"power\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"cn\"\>", ",", 
                    RowBox[{"{", 
                    RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                    "}"}], ",", 
                    RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"cn\"\>", ",", 
                    RowBox[{"{", 
                    RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"rational\"\>"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\<\"1\"\>", ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"sep\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\<\"2\"\>"}], "}"}]}], 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"cn\"\>", ",", 
                    RowBox[{"{", 
                    RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                    "}"}], ",", 
                    RowBox[{"{", "\<\"-1\"\>", "}"}]}], "]"}]}], "}"}]}], 
                  "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]}], "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{566, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->3336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPut", "@", "\[IndentingNewLine]", 
  RowBox[{"Notebook", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"XMLNote", "[", 
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "]"}], "}"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "\"\<Manual\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[13]:=",
 CellID->5783],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{"\[LeftSkeleton]", "\<\"Untitled-1\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 11]]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->31032]
}, Open  ]],

Cell[TextData[{
 "Since the default value of the option ",
 Cell[BoxData["\"\<IncludeEmbeddedObjects\>\""], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", we did not alter comments, processing instructions, or anything else that \
would be stored in an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 ". Adding definitions for these is not difficult and would be a good \
exercise in processing symbolic XML."
}], "Text",
 CellID->24988]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating XML Data", "Section",
 CellID->3339],

Cell["\<\
XML applications are used for more than just document layout. XML is also an \
excellent format for storing structured data. Many commercial database \
vendors are now adding XML support to their products, allowing you to work \
with databases using XML as an intermediate format.\
\>", "Text",
 CellID->23705],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s symbolic pattern-matching capabilities make it an ideal \
tool for extracting and manipulating information from XML documents. To \
illustrate this, let us manipulate an XML file containing data on major \
league baseball players."
}], "Text",
 CellID->14670],

Cell[TextData[{
 "Import this file into ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "as symbolic XML."
}], "MathCaption",
 CellID->15940],

Cell[BoxData[
 RowBox[{
  RowBox[{"AL", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/ALHitters.xml\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->9868],

Cell[TextData[{
 "Each player\[CloseCurlyQuote]s information is stored in a ",
 StyleBox["PlayerRecord", "MR"],
 " element. Extract this with ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->28391],

Cell[BoxData[
 RowBox[{
  RowBox[{"players", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"AL", ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", "_"}], "]"}], ",", 
     "Infinity"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->7728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "players", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->4985],

Cell[BoxData["294"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->5537]
}, Open  ]],

Cell[TextData[{
 "The XML document contains records for 294 players. Inside each ",
 StyleBox["PlayerRecord", "MR"],
 ", there is a ",
 StyleBox["TEAM", "MR"],
 " element which specifies a player",
 "\[CloseCurlyQuote]",
 "s team. By passing a slightly more sophisticated pattern to ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 ", we can extract a list of all players on the Yankees team."
}], "MathCaption",
 CellID->26320],

Cell[BoxData[
 RowBox[{
  RowBox[{"yankees", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"AL", ",", "\[IndentingNewLine]", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"___", ",", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<TEAM\>\"", ",", "_", ",", 
           RowBox[{"{", "\"\<NYY\>\"", "}"}]}], "]"}], ",", "___"}], "}"}]}], 
      "]"}], ",", "Infinity"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->13124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "yankees", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->30997],

Cell[BoxData["21"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->9354]
}, Open  ]],

Cell[TextData[{
 "The variable ",
 StyleBox["yankees", "MR"],
 " now contains a list of symbolic XML expressions for all the Yankees \
players. Look at the first element of ",
 StyleBox["yankees", "MR"],
 "."
}], "MathCaption",
 CellID->28703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", "yankees", "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->5494],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"PlayerRecord\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"PLAYER\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"Bernie Williams\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"TEAM\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"NYY\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"POS\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"OF\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"STATUS\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"A\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"GP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"141\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"GS\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"140\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"AB\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"537\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"AVG\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0.307\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"R\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"108\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"H\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"165\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"Doubles\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"37\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"Triples\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"6\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"HR\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"30\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"RBI\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"121\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"SH\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"SF\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"3\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"BB\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"71\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"SO\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"84\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"HBP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"5\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"SB\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"13\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"CS\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"5\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"GIDP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"OBP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0.391\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"Slg\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0.566\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"TB\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"304\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"ParkAdj\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"0.97882\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"Outs\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"372\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"TBxOBP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"118.9\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"RP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"116.3\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"BJRC\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"124.5\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"PJRP\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"111.2\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"RPper27Outs\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"8.44\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"BJRCper27Outs\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"9.04\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"PJRPper27Outs\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"8.07\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"Salary\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"12357143\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"DollarsPerRun\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"106210\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"DollarsPerRunCreated\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"99230\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"DollarsPerRunProduced\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"111145\"\>", "}"}]}], "]"}], ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"PictureIndex\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"8190\"\>", "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{577, 322},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->30562]
}, Open  ]],

Cell[TextData[{
 "The player's name is stored in the ",
 StyleBox["PLAYER", "MR"],
 " element of each ",
 StyleBox["PlayerRecord", "MR"],
 " element. Extract the name from one ",
 StyleBox["PlayerRecord", "MR"],
 " element."
}], "MathCaption",
 CellID->23865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"First", "[", "yankees", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<PLAYER\>\"", ",", "_", ",", 
       RowBox[{"{", "name_", "}"}]}], "]"}], "\[Rule]", "name"}], ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->17554],

Cell[BoxData["\<\"Bernie Williams\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->20700]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to extract all the names from ",
 StyleBox["yankees", "MR"],
 "."
}], "MathCaption",
 CellID->32302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\"\<PLAYER\>\"", ",", "_", ",", 
          RowBox[{"{", "name_", "}"}]}], "]"}], "\[Rule]", "name"}], ",", 
       "2"}], "]"}], "]"}], "&"}], ",", "\[IndentingNewLine]", "yankees"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->29714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Bernie Williams\"\>", ",", "\<\"Derek Jeter\"\>", 
   ",", "\<\"David Justice\"\>", ",", "\<\"Jorge Posada\"\>", 
   ",", "\<\"Paul Oneill\"\>", ",", "\<\"Tino Martinez\"\>", 
   ",", "\<\"Chuck Knoblauch\"\>", ",", "\<\"Jose Canseco\"\>", 
   ",", "\<\"Scott Brosius\"\>", ",", "\<\"Luis Polonia\"\>", 
   ",", "\<\"Shane Spencer\"\>", ",", "\<\"Glenallen Hill\"\>", 
   ",", "\<\"Clay Bellinger\"\>", ",", "\<\"Jose Vizcaino\"\>", 
   ",", "\<\"Luis Sojo\"\>", ",", "\<\"Chris Turner\"\>", 
   ",", "\<\"Ryan Thompson\"\>", ",", "\<\"Alfonso Soriano\"\>", 
   ",", "\<\"Lance Johnson\"\>", ",", "\<\"Felix Jose\"\>", 
   ",", "\<\"Roberto Kelly\"\>"}], "}"}]], "Output",
 ImageSize->{490, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->31629]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " on ",
 StyleBox["yankees", "MR"],
 " with an appropriate pattern."
}], "MathCaption",
 CellID->16794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"yankees", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"___", ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\"\<PLAYER\>\"", ",", "_", ",", 
          RowBox[{"{", "name_", "}"}]}], "]"}], ",", "___"}], "}"}]}], "]"}], 
    "\[Rule]", "name"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->21026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Bernie Williams\"\>", ",", "\<\"Derek Jeter\"\>", 
   ",", "\<\"David Justice\"\>", ",", "\<\"Jorge Posada\"\>", 
   ",", "\<\"Paul Oneill\"\>", ",", "\<\"Tino Martinez\"\>", 
   ",", "\<\"Chuck Knoblauch\"\>", ",", "\<\"Jose Canseco\"\>", 
   ",", "\<\"Scott Brosius\"\>", ",", "\<\"Luis Polonia\"\>", 
   ",", "\<\"Shane Spencer\"\>", ",", "\<\"Glenallen Hill\"\>", 
   ",", "\<\"Clay Bellinger\"\>", ",", "\<\"Jose Vizcaino\"\>", 
   ",", "\<\"Luis Sojo\"\>", ",", "\<\"Chris Turner\"\>", 
   ",", "\<\"Ryan Thompson\"\>", ",", "\<\"Alfonso Soriano\"\>", 
   ",", "\<\"Lance Johnson\"\>", ",", "\<\"Felix Jose\"\>", 
   ",", "\<\"Roberto Kelly\"\>"}], "}"}]], "Output",
 ImageSize->{490, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->20463]
}, Open  ]],

Cell[TextData[{
 "Symbolic XML is a general-purpose format for expressing arbitrary XML data. \
In some cases, you may find it more useful to convert symbolic XML into a \
different type of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. This type of conversion is easy to do using pattern-matching."
}], "Text",
 CellID->528],

Cell["\<\
Import an XML file containing data about baseball pitchers and translate the \
symbolic XML into a list of rules.\
\>", "MathCaption",
 CellID->31748],

Cell[BoxData[
 RowBox[{
  RowBox[{"NL", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/NLPitchers.xml\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->25679],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"myTransform", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"_", ",", "_", ",", "children_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Apply", "[", 
    RowBox[{"Sequence", ",", 
     RowBox[{"Map", "[", 
      RowBox[{"myTransform", ",", "children"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->21351],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"myTransform", "[", "s_String", "]"}], ":=", "s"}], ";"}]], "Input",\

 CellLabel->"In[25]:=",
 CellID->20199],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"myTransform", "[", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\"\<Document\>\"", "]"}], "[", 
     RowBox[{"_", ",", "root_", ",", "_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"myTransform", "[", "root", "]"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->3],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"myTransform", "[", 
    RowBox[{"PlayerAttribute", "[", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"name_", ",", "_", ",", 
       RowBox[{"{", "value_", "}"}]}], "]"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"name", "\[Rule]", "value"}]}], ";"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->18442],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"myTransform", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", "children_"}], "]"}], 
    "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Pitcher", "@@", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"myTransform", "[", 
        RowBox[{"PlayerAttribute", "[", "#", "]"}], "]"}], "&"}], ",", 
      "children"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->19280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"myTransform", "[", "NL", "]"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->10016],

Cell[BoxData[
 RowBox[{"Pitcher", "[", 
  RowBox[{
   RowBox[{"\<\"PLAYER\"\>", "\[Rule]", "\<\"Randy Johnson\"\>"}], ",", 
   RowBox[{"\<\"TEAM\"\>", "\[Rule]", "\<\"ARI\"\>"}], ",", 
   RowBox[{"\<\"POS\"\>", "\[Rule]", "\<\"SP\"\>"}], ",", 
   RowBox[{"\<\"GP\"\>", "\[Rule]", "\<\"35\"\>"}], ",", 
   RowBox[{"\<\"GS\"\>", "\[Rule]", "\<\"35\"\>"}], ",", 
   RowBox[{"\<\"STATUS\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
   RowBox[{"\<\"W\"\>", "\[Rule]", "\<\"19\"\>"}], ",", 
   RowBox[{"\<\"L\"\>", "\[Rule]", "\<\"7\"\>"}], ",", 
   RowBox[{"\<\"S\"\>", "\[Rule]", "\<\"0\"\>"}], ",", 
   RowBox[{"\<\"IP\"\>", "\[Rule]", "\<\"248.2\"\>"}], ",", 
   RowBox[{"\<\"ERA\"\>", "\[Rule]", "\<\"2.64\"\>"}], ",", 
   RowBox[{"\<\"ParkAdj\"\>", "\[Rule]", "\<\"0.97441\"\>"}], ",", 
   RowBox[{"\<\"PAERA\"\>", "\[Rule]", "\<\"2.57\"\>"}], ",", 
   RowBox[{"\<\"_90ERA\"\>", "\[Rule]", "\<\"5.94\"\>"}], ",", 
   RowBox[{"\<\"_50ERA\"\>", "\[Rule]", "\<\"4.54\"\>"}], ",", 
   RowBox[{"\<\"RPper9inn\"\>", "\[Rule]", "\<\"3.4\"\>"}], ",", 
   RowBox[{"\<\"RP\"\>", "\[Rule]", "\<\"93.0\"\>"}], ",", 
   RowBox[{"\<\"RunRatio\"\>", "\[Rule]", "\<\"0.64\"\>"}], ",", 
   RowBox[{"\<\"PAERAWinsOver162\"\>", "\[Rule]", "\<\"123.461\"\>"}], ",", 
   RowBox[{"\<\"Games\"\>", "\[Rule]", "\<\"27.6\"\>"}], ",", 
   RowBox[{"\<\"PAERAwins\"\>", "\[Rule]", "\<\"21.0\"\>"}], ",", 
   RowBox[{"\<\"PAERAloses\"\>", "\[Rule]", "\<\"6.6\"\>"}], ",", 
   RowBox[{"\<\"AVG\"\>", "\[Rule]", "\<\"0.213\"\>"}], ",", 
   RowBox[{"\<\"OBA\"\>", "\[Rule]", "\<\"0.276\"\>"}], ",", 
   RowBox[{"\<\"ShutOut\"\>", "\[Rule]", "\<\"3\"\>"}], ",", 
   RowBox[{"\<\"H\"\>", "\[Rule]", "\<\"202\"\>"}], ",", 
   RowBox[{"\<\"R\"\>", "\[Rule]", "\<\"89\"\>"}], ",", 
   RowBox[{"\<\"ER\"\>", "\[Rule]", "\<\"73\"\>"}], ",", 
   RowBox[{"\<\"HR\"\>", "\[Rule]", "\<\"23\"\>"}], ",", 
   RowBox[{"\<\"K\"\>", "\[Rule]", "\<\"347\"\>"}], ",", 
   RowBox[{"\<\"WP\"\>", "\[Rule]", "\<\"5\"\>"}], ",", 
   RowBox[{"\<\"BLK\"\>", "\[Rule]", "\<\"2\"\>"}], ",", 
   RowBox[{"\<\"HBP\"\>", "\[Rule]", "\<\"6\"\>"}], ",", 
   RowBox[{"\<\"E\"\>", "\[Rule]", "\<\"3\"\>"}], ",", 
   RowBox[{"\<\"Salary\"\>", "\[Rule]", "\<\"13350000\"\>"}], ",", 
   RowBox[{"\<\"DollarsPerRun\"\>", "\[Rule]", "\<\"143563\"\>"}], ",", 
   RowBox[{"\<\"PictureIndex\"\>", "\[Rule]", "\<\"7762\"\>"}]}], 
  "]"}]], "Output",
 ImageSize->{583, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->15290]
}, Open  ]],

Cell[TextData[{
 "All the information about the player is stored in a list of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rules with ",
 StyleBox["Pitcher", "MR"],
 " as the head."
}], "Text",
 CellID->15098],

Cell["\<\
In addition to transforming the data into a different expression syntax, we \
can also modify the data and leave the overall expression in symbolic XML. \
This way we can alter our data, but still export it to an XML file for use \
with other applications. As an example, we will work with the salaries of \
American League hitters.\
\>", "Text",
 CellID->9858],

Cell[TextData[{
 "Delete any ",
 StyleBox["PlayerRecord", "MR"],
 " entries where the salary is not available."
}], "MathCaption",
 CellID->1730],

Cell[BoxData[
 RowBox[{
  RowBox[{"AL", "=", 
   RowBox[{"AL", "/.", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", 
       RowBox[{"{", 
        RowBox[{"___", ",", "\[IndentingNewLine]", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<Salary\>\"", ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", "\"\<#N/A\>\"", "}"}]}], "]"}], ",", "___"}], "}"}]}],
       "]"}], "\[Rule]", 
     RowBox[{"Sequence", "[", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->8553],

Cell["\<\
Create a function to extract name-salary pairs. Then sort these pairs by \
salary and look at the top 10.\
\>", "MathCaption",
 CellID->29551],

Cell[BoxData[
 RowBox[{
  RowBox[{"Salaries", "[", "x_", "]"}], ":=", 
  RowBox[{"Cases", "[", 
   RowBox[{"x", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<PlayerRecord\>\"", ",", "_", ",", 
       RowBox[{"{", 
        RowBox[{"___", ",", "\[IndentingNewLine]", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<PLAYER\>\"", ",", "_", ",", 
           RowBox[{"{", "name_", "}"}]}], "]"}], ",", "___", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<Salary\>\"", ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", "s_", "}"}]}], "]"}], ",", "___"}], "}"}]}], "]"}], 
     "\[RuleDelayed]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"name", ",", 
       RowBox[{"ToExpression", "[", "s", "]"}]}], "}"}]}], ",", "Infinity"}], 
   "]"}]}]], "Input",
 CellLabel->"In[31]:=",
 CellID->23262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rich", "=", 
  RowBox[{
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{"Salaries", "[", "AL", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}], ",", 
     "10"}], "]"}], "//", "TableForm"}]}]], "Input",
 CellLabel->"In[32]:=",
 CellID->444],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Albert Belle\"\>", "12868670"},
    {"\<\"Bernie Williams\"\>", "12357143"},
    {"\<\"Mo Vaughn\"\>", "11166667"},
    {"\<\"Raul Mondesi\"\>", "10000000"},
    {"\<\"Derek Jeter\"\>", "10000000"},
    {"\<\"Rafael Palmeiro\"\>", "8620921"},
    {"\<\"Ivan Rodriguez\"\>", "8600000"},
    {"\<\"Jim Thome\"\>", "8175000"},
    {"\<\"Juan Gonzalez\"\>", "7500000"},
    {"\<\"Kenny Lofton\"\>", "7500000"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{195, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]//TableForm=",
 CellID->21649]
}, Open  ]],

Cell["\<\
To illustrate changing data in symbolic XML, create a function that doubles \
players\[CloseCurlyQuote] salaries.\
\>", "MathCaption",
 CellID->10485],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleSalary", "[", "s_", "]"}], ":=", 
  RowBox[{"ToString", "[", 
   RowBox[{"2", "*", 
    RowBox[{"ToExpression", "[", "s", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->7055],

Cell[BoxData[
 RowBox[{
  RowBox[{"AL", "=", 
   RowBox[{"AL", "/.", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<Salary\>\"", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "sal_", "}"}]}], "]"}], "\[RuleDelayed]", 
     "\[IndentingNewLine]", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<Salary\>\"", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"DoubleSalary", "[", "sal", "]"}], "}"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->12572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"richer", "=", 
  RowBox[{
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{"Salaries", "[", "AL", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}], ",", 
     "10"}], "]"}], "//", "TableForm"}]}]], "Input",
 CellLabel->"In[35]:=",
 CellID->12889],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Albert Belle\"\>", "25737340"},
    {"\<\"Bernie Williams\"\>", "24714286"},
    {"\<\"Mo Vaughn\"\>", "22333334"},
    {"\<\"Raul Mondesi\"\>", "20000000"},
    {"\<\"Derek Jeter\"\>", "20000000"},
    {"\<\"Rafael Palmeiro\"\>", "17241842"},
    {"\<\"Ivan Rodriguez\"\>", "17200000"},
    {"\<\"Jim Thome\"\>", "16350000"},
    {"\<\"Juan Gonzalez\"\>", "15000000"},
    {"\<\"Kenny Lofton\"\>", "15000000"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{195, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]//TableForm=",
 CellID->2858]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualizing XML Data", "Section",
 CellID->17552],

Cell[CellGroupData[{

Cell["Creating a 3D Graphic from an XML File", "Subsection",
 CellID->129],

Cell[TextData[{
 "We will illustrate how to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming and symbolic XML to visualize data in XML format. The molecule \
description markup language (MoDL) is an XML application that describes \
molecules. For details, see ",
 ButtonBox["http://www.oasis-open.org/cover/modl.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.oasis-open.org/cover/modl.html"], None}],
 ". In this example, we convert a MoDL description of the methane molecule \
into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 3D graphic. "
}], "Text",
 CellID->14640],

Cell["\<\
The MoDL file that contains the description of the methane molecule.\
\>", "MathCaption",
 CellID->6860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!!", 
  RowBox[{"methane", ".", "xml"}]}]], "Input",
 Evaluatable->False,
 CellLabel->"In[2]:=",
 CellID->8046],

Cell["\<\
<?xml version=\"1.0\"?>
<modl>
<head animation=\"on\" clockperiod=\"5s\" stepsize=\"1s\" loop=\"true\">
   <meta name=\"title\" content=\"Methane Dance\" />
   <DEFINE name=\"C\">
      <atom radius=\"0.3\" color=\"1 1 0\" />
   </DEFINE>
   <DEFINE name=\"H\">
      <atom radius=\"0.25\" color=\"1 0 0\" />
   </DEFINE>
   <DEFINE name=\"CH4\">
     <molecule>
\t<atom type=\"C\" id=\"c1\" position=\"0 0 0.4\" />
\t<atom type=\"H\" id=\"h1\" position=\"0.5 0.1 -0.4\" />
\t<atom type=\"H\" id=\"h2\" position=\"-1 0.1 0.3\" />
\t<atom type=\"H\" id=\"h3\" position=\"0.3 0.7 1\" />
\t<atom type=\"H\" id=\"h4\" position=\"0.2 -0.9 0.8\" />
\t<bond atom1=\"c1\" atom2=\"h1\" />
\t<bond atom1=\"c1\" atom2=\"h2\" />
\t<bond atom1=\"c1\" atom2=\"h3\" />
\t<bond atom1=\"c1\" atom2=\"h4\" />
     </molecule>
   </DEFINE>
</head>
<body>
  <molecule type=\"CH4\" id=\"m\" />
 
  <TRANSLATE object=\"m\" t=\"0.2\" position=\"-3 1 -2\" />
  <TRANSLATE object=\"m\" t=\"0.4\" position=\"-1 0 -3\" />
  <TRANSLATE object=\"m\" t=\"0.6\" position=\"1 -1 -1\" />
  <TRANSLATE object=\"m\" t=\"0.8\" position=\"1 0 1\" />
  <TRANSLATE object=\"m\" t=\"1\" position=\"0 0 0\" />

  <ROTATE object=\"m\" t=\"0.2\" axis=\"1 0 0\" />
  <ROTATE object=\"m\" t=\"0.4\" axis=\"0 0 1\" angle=\"-1.571\"/>
  <ROTATE object=\"m\" t=\"0.6\" axis=\"0 -1 0\" />
  <ROTATE object=\"m\" t=\"0.8\" axis=\"-1 0 0\" angle=\"-0.78\" />
  <ROTATE object=\"m\" t=\"1\" axis=\"0 0 1\" />
</body>
</modl>\
\>", "Output",
 ImageSize->{448, 639},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28627]
}, Open  ]],

Cell[TextData[{
 "Import the file into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in symbolic XML."
}], "MathCaption",
 CellID->5044],

Cell[BoxData[
 RowBox[{
  RowBox[{"methane", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/methane.xml\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->6422],

Cell[TextData[{
 "To convert the symbolic XML into a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression, load ",
 Cell[BoxData["Graphics`Shapes`"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->25936],

Cell[BoxData[
 RowBox[{"<<", "Graphics`Shapes`"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->7473],

Cell[TextData[{
 "Define a function called ",
 Cell[BoxData["MoDLToGraphics3D"], "InlineFormula"],
 " that turns the symbolic XML into a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression. This function relies on a number of auxiliary functions that \
are defined in ",
 ButtonBox["Implementation Details",
  BaseStyle->"Link",
  ButtonData->"paclet:XML/tutorial/TransformingXML#16534"],
 "."
}], "MathCaption",
 CellID->19154],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoDLToGraphics3D", "[", "modl_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"defs", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"modl", ",", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<DEFINE\>\"", ",", "___"}], "]"}], ",", "Infinity"}], 
        "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"body", "=", 
       RowBox[{"First", "[", 
        RowBox[{"Cases", "[", 
         RowBox[{"modl", ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<body\>\"", ",", "___"}], "]"}], ",", "Infinity"}], 
         "]"}], "]"}]}], ",", "\[IndentingNewLine]", "moldef", ",", "themols",
       ",", "theatoms"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ProcessDefinition", "/@", "defs"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"themols", "=", "\[IndentingNewLine]", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Cases", "[", 
        RowBox[{"body", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<molecule\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"___", ",", 
              RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", "___"}], "}"}], 
            ",", "__"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"moldef", "[", "t", "]"}]}], ",", "\[IndentingNewLine]", 
         "Infinity"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"theatoms", "=", 
      RowBox[{"Cases", "[", 
       RowBox[{"body", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<atom\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"___", ",", 
             RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", "___", ",", 
             RowBox[{"\"\<position\>\"", "\[Rule]", "p_"}], ",", "___"}], 
            "}"}], ",", "\[IndentingNewLine]", "__"}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"Append", "[", 
          RowBox[{
           RowBox[{"moldef", "[", "t", "]"}], ",", 
           RowBox[{"MolStringListToList", "[", "p", "]"}]}], "]"}]}], ",", 
        "Infinity"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"MolToGraphics", "/@", 
        RowBox[{"Join", "[", 
         RowBox[{"themols", ",", "theatoms"}], "]"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[39]:=",
 CellID->333],

Cell["\<\
Apply this function to the original symbolic XML to generate a 3D graphic \
representing the methane molecule. \
\>", "MathCaption",
 CellID->8756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"MoDLToGraphics3D", "[", "methane", "]"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->11051],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06145 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0462967 1.14699 5.68122e-17 1.14699 [
[ 0 0 0 0 ]
[ 1 1.06145 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06145 L
0 1.06145 L
closepath
clip
newpath
.37336 .66509 m .33207 .68456 L .33692 .6624 L .729 0 0 r
F
.37336 .66509 m .37499 .68768 L .33207 .68456 L F
.37022 .6428 m .37336 .66509 L .33692 .6624 L .725 0 0 r
F
.40468 .65531 m .37499 .68768 L .37336 .66509 L .607 0 0 r
F
.39296 .6356 m .37336 .66509 L .37022 .6428 L .629 0 0 r
F
.39296 .6356 m .40468 .65531 L .37336 .66509 L F
.37022 .6428 m .33692 .6624 L .34371 .64082 L .725 0 0 r
F
.36585 .62282 m .37022 .6428 L .34371 .64082 L .714 0 0 r
F
.37782 .61898 m .37022 .6428 L .36585 .62282 L .646 0 0 r
F
.37782 .61898 m .39296 .6356 L .37022 .6428 L F
.37499 .68768 m .32962 .70531 L .33207 .68456 L .727 0 0 r
F
.37499 .68768 m .37496 .70856 L .32962 .70531 L F
.41192 .67632 m .37496 .70856 L .37499 .68768 L .578 0 0 r
F
.40468 .65531 m .41192 .67632 L .37499 .68768 L .607 0 0 r
F
.33692 .6624 m .29858 .66801 L .30857 .64817 L .833 0 0 r
F
.33692 .6624 m .33207 .68456 L .29858 .66801 L F
.34371 .64082 m .33692 .6624 L .30857 .64817 L .806 0 0 r
F
.34371 .64082 m .30857 .64817 L .32319 .63036 L F
.35186 .62176 m .34371 .64082 L .32319 .63036 L .769 0 0 r
F
.36585 .62282 m .34371 .64082 L .35186 .62176 L .714 0 0 r
F
.33207 .68456 m .2942 .68804 L .29858 .66801 L .853 0 0 r
F
.33207 .68456 m .32962 .70531 L .2942 .68804 L F
.37999 .60361 m .36585 .62282 L .35186 .62176 L .66 0 0 r
F
.37999 .60361 m .37782 .61898 L .36585 .62282 L F
.40343 .6218 m .40468 .65531 L .39296 .6356 L .476 0 0 r
F
.38324 .61166 m .39296 .6356 L .37782 .61898 L .554 0 0 r
F
.38324 .61166 m .40343 .6218 L .39296 .6356 L F
.41928 .63648 m .41192 .67632 L .40468 .65531 L .376 0 0 r
F
.40343 .6218 m .41928 .63648 L .40468 .65531 L .476 0 0 r
F
.37496 .70856 m .32982 .72273 L .32962 .70531 L .717 0 0 r
F
.37496 .70856 m .37325 .72581 L .32982 .72273 L F
.41398 .69672 m .37325 .72581 L .37496 .70856 L .53 0 0 r
F
.41192 .67632 m .41398 .69672 L .37496 .70856 L .578 0 0 r
F
.37999 .60361 m .35186 .62176 L .34108 .61619 L .66 0 0 r
F
.35186 .62176 m .32319 .63036 L .34108 .61619 L .769 0 0 r
F
.37999 .60361 m .38324 .61166 L .37782 .61898 L .66 0 0 r
F
.32962 .70531 m .29592 .70638 L .2942 .68804 L .864 0 0 r
F
.32962 .70531 m .32982 .72273 L .29592 .70638 L F
.42926 .65436 m .41398 .69672 L .41192 .67632 L .229 0 0 r
F
.41928 .63648 m .42926 .65436 L .41192 .67632 L .376 0 0 r
F
.32319 .63036 m .29906 .62744 L .31645 .61521 L .878 0 0 r
F
.32319 .63036 m .30857 .64817 L .29906 .62744 L F
.34108 .61619 m .32319 .63036 L .31645 .61521 L .803 0 0 r
F
.37999 .60361 m .34108 .61619 L .33764 .60819 L .66 0 0 r
F
.34108 .61619 m .31645 .61521 L .33764 .60819 L .803 0 0 r
F
.30857 .64817 m .28718 .64379 L .29906 .62744 L .946 0 0 r
F
.30857 .64817 m .29858 .66801 L .28718 .64379 L F
.37999 .60361 m .40343 .6218 L .38324 .61166 L .42 0 0 r
F
.37325 .72581 m .33272 .73513 L .32982 .72273 L .682 0 0 r
F
.37325 .72581 m .36997 .73776 L .33272 .73513 L F
.41059 .71459 m .36997 .73776 L .37325 .72581 L .426 0 0 r
F
.41398 .69672 m .41059 .71459 L .37325 .72581 L .53 0 0 r
F
.43234 .67378 m .41059 .71459 L .41398 .69672 L 0 0 0 r
F
.42926 .65436 m .43234 .67378 L .41398 .69672 L .229 0 0 r
F
.29858 .66801 m .28207 .66274 L .28718 .64379 L .995 0 0 r
F
.29858 .66801 m .2942 .68804 L .28207 .66274 L F
.39738 .60649 m .41928 .63648 L .40343 .6218 L .108 0 0 r
F
.37999 .60361 m .39738 .60649 L .40343 .6218 L .42 0 0 r
F
.37999 .60361 m .33764 .60819 L .34292 .60078 L .66 0 0 r
F
.33764 .60819 m .3264 .60106 L .34292 .60078 L .766 0 0 r
F
.33764 .60819 m .31645 .61521 L .3264 .60106 L F
.32982 .72273 m .3037 .72124 L .29592 .70638 L .84 0 0 r
F
.32982 .72273 m .33272 .73513 L .3037 .72124 L F
.37999 .60361 m .355 .59684 L .36919 .59793 L .66 0 0 r
F
.37999 .60361 m .34292 .60078 L .355 .59684 L F
.36919 .59793 m .39738 .60649 L .37999 .60361 L .255 0 0 r
F
.4111 .61544 m .42926 .65436 L .41928 .63648 L 0 0 0 r
F
.39738 .60649 m .4111 .61544 L .41928 .63648 L .108 0 0 r
F
.31645 .61521 m .31266 .60795 L .3264 .60106 L .796 0 0 r
F
.31645 .61521 m .29906 .62744 L .31266 .60795 L F
.34292 .60078 m .34952 .5935 L .355 .59684 L .542 0 0 r
F
.34292 .60078 m .3264 .60106 L .34952 .5935 L F
.2942 .68804 m .28435 .68246 L .28207 .66274 L .954 0 0 r
F
.2942 .68804 m .29592 .70638 L .28435 .68246 L F
.41059 .71459 m .40197 .72821 L .36997 .73776 L .426 0 0 r
F
.42811 .6929 m .40197 .72821 L .41059 .71459 L 0 0 0 r
F
.43234 .67378 m .42811 .6929 L .41059 .71459 L F
.76272 .37327 m .72199 .39208 L .72617 .37003 L .73 0 0 r
F
.76272 .37327 m .76502 .39584 L .72199 .39208 L F
.76006 .3501 m .76272 .37327 L .72617 .37003 L .725 0 0 r
F
.79707 .3615 m .76502 .39584 L .76272 .37327 L .612 0 0 r
F
.785 .34146 m .76272 .37327 L .76006 .3501 L .634 0 0 r
F
.785 .34146 m .79707 .3615 L .76272 .37327 L F
.36919 .59793 m .37678 .59559 L .39738 .60649 L .255 0 0 r
F
.355 .59684 m .37678 .59559 L .36919 .59793 L .261 0 0 r
F
.355 .59684 m .34952 .5935 L .37678 .59559 L F
.36997 .73776 m .33808 .7412 L .33272 .73513 L .526 0 0 r
F
.36997 .73776 m .36541 .74312 L .33808 .7412 L F
.40197 .72821 m .36541 .74312 L .36997 .73776 L .12 0 0 r
F
.76006 .3501 m .72617 .37003 L .73348 .34772 L .725 0 0 r
F
.7573 .32843 m .76006 .3501 L .73348 .34772 L .714 0 0 r
F
.77044 .32382 m .76006 .3501 L .7573 .32843 L .652 0 0 r
F
.77044 .32382 m .785 .34146 L .76006 .3501 L F
.76502 .39584 m .72132 .41189 L .72199 .39208 L .729 0 0 r
F
.76502 .39584 m .76678 .41582 L .72132 .41189 L F
.80554 .38214 m .76678 .41582 L .76502 .39584 L .58 0 0 r
F
.79707 .3615 m .80554 .38214 L .76502 .39584 L .612 0 0 r
F
.72617 .37003 m .69189 .37211 L .7007 .35291 L .85 0 0 r
F
.72617 .37003 m .72199 .39208 L .69189 .37211 L F
.73348 .34772 m .72617 .37003 L .7007 .35291 L .813 0 0 r
F
.4111 .61544 m .41973 .62973 L .42926 .65436 L 0 0 0 r
F
.41973 .62973 m .43234 .67378 L .42926 .65436 L .895 0 0 r
F
.29906 .62744 m .30314 .62093 L .31266 .60795 L .6 0 0 r
F
.29906 .62744 m .28718 .64379 L .30314 .62093 L F
.73348 .34772 m .7007 .35291 L .71505 .33516 L .813 0 0 r
F
.74327 .32716 m .73348 .34772 L .71505 .33516 L .769 0 0 r
F
.7573 .32843 m .73348 .34772 L .74327 .32716 L .714 0 0 r
F
.37678 .59559 m .4111 .61544 L .39738 .60649 L .486 0 0 r
F
.33272 .73513 m .31689 .73108 L .3037 .72124 L .601 0 0 r
F
.33272 .73513 m .33808 .7412 L .31689 .73108 L F
.72199 .39208 m .6895 .391 L .69189 .37211 L .882 0 0 r
F
.72199 .39208 m .72132 .41189 L .6895 .391 L F
.29592 .70638 m .29391 .70098 L .28435 .68246 L 0 0 0 r
F
.29592 .70638 m .3037 .72124 L .29391 .70098 L F
.77633 .30537 m .7573 .32843 L .74327 .32716 L .671 0 0 r
F
.77633 .30537 m .77044 .32382 L .7573 .32843 L F
.79902 .32487 m .79707 .3615 L .785 .34146 L .521 0 0 r
F
.77773 .31503 m .785 .34146 L .77044 .32382 L .582 0 0 r
F
.77773 .31503 m .79902 .32487 L .785 .34146 L F
.3264 .60106 m .34471 .59748 L .34952 .5935 L 0 0 0 r
F
.3264 .60106 m .31266 .60795 L .34471 .59748 L F
.81657 .33882 m .80554 .38214 L .79707 .3615 L .446 0 0 r
F
.79902 .32487 m .81657 .33882 L .79707 .3615 L .521 0 0 r
F
.76678 .41582 m .72428 .42761 L .72132 .41189 L .714 0 0 r
F
.76678 .41582 m .76781 .43135 L .72428 .42761 L F
.8096 .40149 m .76781 .43135 L .76678 .41582 L .525 0 0 r
F
.80554 .38214 m .8096 .40149 L .76678 .41582 L .58 0 0 r
F
.77633 .30537 m .74327 .32716 L .73361 .32048 L .671 0 0 r
F
.74327 .32716 m .71505 .33516 L .73361 .32048 L .769 0 0 r
F
.4223 .64802 m .42811 .6929 L .43234 .67378 L 1 0 0 r
F
.41973 .62973 m .4223 .64802 L .43234 .67378 L .895 0 0 r
F
.40197 .72821 m .38883 .73615 L .36541 .74312 L .12 0 0 r
F
.42811 .6929 m .41685 .70981 L .40197 .72821 L 0 0 0 r
F
.41685 .70981 m .38883 .73615 L .40197 .72821 L .739 0 0 r
F
.77633 .30537 m .77773 .31503 L .77044 .32382 L .671 0 0 r
F
.28718 .64379 m .29889 .63881 L .30314 .62093 L 0 0 0 r
F
.28718 .64379 m .28207 .66274 L .29889 .63881 L F
.72132 .41189 m .69385 .40778 L .6895 .391 L .892 0 0 r
F
.72132 .41189 m .72428 .42761 L .69385 .40778 L F
.82869 .35564 m .8096 .40149 L .80554 .38214 L .337 0 0 r
F
.81657 .33882 m .82869 .35564 L .80554 .38214 L .446 0 0 r
F
.71505 .33516 m .69603 .32794 L .71181 .31694 L .89 0 0 r
F
.71505 .33516 m .7007 .35291 L .69603 .32794 L F
.73361 .32048 m .71505 .33516 L .71181 .31694 L .803 0 0 r
F
.37678 .59559 m .38259 .60038 L .4111 .61544 L .486 0 0 r
F
.34952 .5935 m .38259 .60038 L .37678 .59559 L .455 0 0 r
F
.38259 .60038 m .41973 .62973 L .4111 .61544 L .833 0 0 r
F
.77633 .30537 m .73361 .32048 L .732 .31086 L .671 0 0 r
F
.73361 .32048 m .71181 .31694 L .732 .31086 L .803 0 0 r
F
.34952 .5935 m .34471 .59748 L .38259 .60038 L .455 0 0 r
F
.7007 .35291 m .68623 .34288 L .69603 .32794 L .972 0 0 r
F
.7007 .35291 m .69189 .37211 L .68623 .34288 L F
.36541 .74312 m .34547 .74017 L .33808 .7412 L .125 0 0 r
F
.36541 .74312 m .35998 .74119 L .34547 .74017 L F
.38883 .73615 m .35998 .74119 L .36541 .74312 L .453 0 0 r
F
.3037 .72124 m .30988 .7164 L .29391 .70098 L 0 0 0 r
F
.3037 .72124 m .31689 .73108 L .30988 .7164 L F
.33808 .7412 m .33429 .73481 L .31689 .73108 L .142 0 0 r
F
.33808 .7412 m .34547 .74017 L .33429 .73481 L F
.77633 .30537 m .79902 .32487 L .77773 .31503 L .506 0 0 r
F
.76781 .43135 m .73066 .43771 L .72428 .42761 L .649 0 0 r
F
.76781 .43135 m .76802 .4409 L .73066 .43771 L F
.80883 .41774 m .76802 .4409 L .76781 .43135 L .396 0 0 r
F
.8096 .40149 m .80883 .41774 L .76781 .43135 L .525 0 0 r
F
.41845 .66856 m .41685 .70981 L .42811 .6929 L .959 0 0 r
F
.4223 .64802 m .41845 .66856 L .42811 .6929 L 1 0 0 r
F
.83415 .37375 m .80883 .41774 L .8096 .40149 L .141 0 0 r
F
.82869 .35564 m .83415 .37375 L .8096 .40149 L .337 0 0 r
F
.69189 .37211 m .68348 .36037 L .68623 .34288 L .971 0 0 r
F
.69189 .37211 m .6895 .391 L .68348 .36037 L F
.31266 .60795 m .34109 .6086 L .34471 .59748 L .376 0 0 r
F
.31266 .60795 m .30314 .62093 L .34109 .6086 L F
.28207 .66274 m .30046 .65986 L .29889 .63881 L .156 0 0 r
F
.28207 .66274 m .28435 .68246 L .30046 .65986 L F
.79655 .30645 m .81657 .33882 L .79902 .32487 L .339 0 0 r
F
.77633 .30537 m .79655 .30645 L .79902 .32487 L .506 0 0 r
F
.77633 .30537 m .732 .31086 L .73917 .30196 L .671 0 0 r
F
.732 .31086 m .72538 .29993 L .73917 .30196 L .77 0 0 r
F
.732 .31086 m .71181 .31694 L .72538 .29993 L F
.72428 .42761 m .70465 .42081 L .69385 .40778 L .762 0 0 r
F
.72428 .42761 m .73066 .43771 L .70465 .42081 L F
.38883 .73615 m .37237 .73749 L .35998 .74119 L .453 0 0 r
F
.39958 .72278 m .37237 .73749 L .38883 .73615 L .753 0 0 r
F
.41685 .70981 m .39958 .72278 L .38883 .73615 L .739 0 0 r
F
.38602 .61202 m .4223 .64802 L .41973 .62973 L .873 0 0 r
F
.38259 .60038 m .38602 .61202 L .41973 .62973 L .833 0 0 r
F
.77633 .30537 m .75244 .29723 L .76667 .29854 L .671 0 0 r
F
.77633 .30537 m .73917 .30196 L .75244 .29723 L F
.76667 .29854 m .79655 .30645 L .77633 .30537 L .439 0 0 r
F
.81337 .31348 m .82869 .35564 L .81657 .33882 L .056 0 0 r
F
.79655 .30645 m .81337 .31348 L .81657 .33882 L .339 0 0 r
F
.71181 .31694 m .71467 .30446 L .72538 .29993 L .781 0 0 r
F
.71181 .31694 m .69603 .32794 L .71467 .30446 L F
.34471 .59748 m .38602 .61202 L .38259 .60038 L .671 0 0 r
F
.31689 .73108 m .33068 .7271 L .30988 .7164 L .369 0 0 r
F
.31689 .73108 m .33429 .73481 L .33068 .7271 L F
.73917 .30196 m .7508 .29083 L .75244 .29723 L .614 0 0 r
F
.73917 .30196 m .72538 .29993 L .7508 .29083 L F
.40846 .68925 m .39958 .72278 L .41685 .70981 L .889 0 0 r
F
.41845 .66856 m .40846 .68925 L .41685 .70981 L .959 0 0 r
F
.6895 .391 m .68815 .37874 L .68348 .36037 L 0 0 0 r
F
.6895 .391 m .69385 .40778 L .68815 .37874 L F
.28435 .68246 m .30776 .68193 L .30046 .65986 L .334 0 0 r
F
.28435 .68246 m .29391 .70098 L .30776 .68193 L F
.34471 .59748 m .34109 .6086 L .38602 .61202 L .671 0 0 r
F
.80883 .41774 m .80318 .42929 L .76802 .4409 L .396 0 0 r
F
.83231 .39142 m .80318 .42929 L .80883 .41774 L 0 0 0 r
F
.83415 .37375 m .83231 .39142 L .80883 .41774 L .141 0 0 r
F
.76667 .29854 m .77814 .29335 L .79655 .30645 L .439 0 0 r
F
.75244 .29723 m .77814 .29335 L .76667 .29854 L .455 0 0 r
F
.36336 .71721 m .35998 .74119 L .37237 .73749 L .65 0 0 r
F
.36336 .71721 m .34547 .74017 L .35998 .74119 L F
.75244 .29723 m .7508 .29083 L .77814 .29335 L .455 0 0 r
F
.36336 .71721 m .33429 .73481 L .34547 .74017 L .65 0 0 r
F
.30314 .62093 m .33905 .62589 L .34109 .6086 L .509 0 0 r
F
.30314 .62093 m .29889 .63881 L .33905 .62589 L F
.76802 .4409 m .73995 .44106 L .73066 .43771 L .318 0 0 r
F
.76802 .4409 m .76735 .4434 L .73995 .44106 L F
.80318 .42929 m .76735 .4434 L .76802 .4409 L 0 0 0 r
F
.82509 .32589 m .83415 .37375 L .82869 .35564 L F
.81337 .31348 m .82509 .32589 L .82869 .35564 L .056 0 0 r
F
.38663 .62948 m .41845 .66856 L .4223 .64802 L .862 0 0 r
F
0 g
.01 w
[ ] 0 setdash
.41537 .65137 m
.41926 .65023 L
s
.35746 .66828 m
.40655 .65394 L
s
.41926 .65023 m
.42135 .64962 L
s
.38602 .61202 m .38663 .62948 L .4223 .64802 L .873 0 0 r
F
0 g
.42135 .64962 m
.4312 .64674 L
s
.69603 .32794 m .70819 .31526 L .71467 .30446 L 0 0 0 r
F
.69603 .32794 m .68623 .34288 L .70819 .31526 L F
.36336 .71721 m .37237 .73749 L .37797 .73044 L .65 0 0 r
F
.39958 .72278 m .37797 .73044 L .37237 .73749 L .753 0 0 r
F
.77814 .29335 m .81337 .31348 L .79655 .30645 L 0 0 0 r
F
.73066 .43771 m .72098 .42872 L .70465 .42081 L F
.73066 .43771 m .73995 .44106 L .72098 .42872 L F
.39331 .70795 m .37797 .73044 L .39958 .72278 L .807 0 0 r
F
.40846 .68925 m .39331 .70795 L .39958 .72278 L .889 0 0 r
F
.29391 .70098 m .32009 .70269 L .30776 .68193 L .449 0 0 r
F
.29391 .70098 m .30988 .7164 L .32009 .70269 L F
.36336 .71721 m .33068 .7271 L .33429 .73481 L .65 0 0 r
F
.69385 .40778 m .69992 .39616 L .68815 .37874 L 0 0 0 r
F
.69385 .40778 m .70465 .42081 L .69992 .39616 L F
.72538 .29993 m .74996 .29183 L .7508 .29083 L F
.72538 .29993 m .71467 .30446 L .74996 .29183 L F
.34109 .6086 m .38663 .62948 L .38602 .61202 L .716 0 0 r
F
.36336 .71721 m .37797 .73044 L .37457 .72269 L .65 0 0 r
F
.39331 .70795 m .37457 .72269 L .37797 .73044 L .807 0 0 r
F
.30988 .7164 m .33613 .71995 L .32009 .70269 L .537 0 0 r
F
.30988 .7164 m .33068 .7271 L .33613 .71995 L F
.82509 .32589 m .83042 .34256 L .83415 .37375 L 0 0 0 r
F
.83042 .34256 m .83231 .39142 L .83415 .37375 L .914 0 0 r
F
.80318 .42929 m .79311 .43491 L .76735 .4434 L 0 0 0 r
F
.83231 .39142 m .82321 .4069 L .80318 .42929 L F
.82321 .4069 m .79311 .43491 L .80318 .42929 L .713 0 0 r
F
.38432 .65106 m .40846 .68925 L .41845 .66856 L .841 0 0 r
F
.38663 .62948 m .38432 .65106 L .41845 .66856 L .862 0 0 r
F
.29889 .63881 m .33884 .64768 L .33905 .62589 L .567 0 0 r
F
.29889 .63881 m .30046 .65986 L .33884 .64768 L F
.68623 .34288 m .70668 .3314 L .70819 .31526 L .047 0 0 r
F
.68623 .34288 m .68348 .36037 L .70668 .3314 L F
.34109 .6086 m .33905 .62589 L .38663 .62948 L .716 0 0 r
F
.36336 .71721 m .33613 .71995 L .33068 .7271 L .65 0 0 r
F
.77814 .29335 m .78794 .29534 L .81337 .31348 L 0 0 0 r
F
.7508 .29083 m .78794 .29534 L .77814 .29335 L .179 0 0 r
F
.78794 .29534 m .82509 .32589 L .81337 .31348 L .687 0 0 r
F
.7508 .29083 m .74996 .29183 L .78794 .29534 L .179 0 0 r
F
0 g
.67092 .50407 m
.7144 .43651 L
s
.37927 .67452 m .39331 .70795 L .40846 .68925 L .812 0 0 r
F
.38432 .65106 m .37927 .67452 L .40846 .68925 L .841 0 0 r
F
.76735 .4434 m .75131 .43716 L .73995 .44106 L .379 0 0 r
F
.76735 .4434 m .76585 .4384 L .75131 .43716 L F
.79311 .43491 m .76585 .4384 L .76735 .4434 L .56 0 0 r
F
.37203 .69738 m .37457 .72269 L .39331 .70795 L .772 0 0 r
F
.37203 .69738 m .36336 .71721 L .37457 .72269 L F
.70465 .42081 m .71769 .41082 L .69992 .39616 L .284 0 0 r
F
.70465 .42081 m .72098 .42872 L .71769 .41082 L F
.73995 .44106 m .74131 .43062 L .72098 .42872 L .385 0 0 r
F
.73995 .44106 m .75131 .43716 L .74131 .43062 L F
.37927 .67452 m .37203 .69738 L .39331 .70795 L .812 0 0 r
F
.30046 .65986 m .34052 .67168 L .33884 .64768 L .6 0 0 r
F
.30046 .65986 m .30776 .68193 L .34052 .67168 L F
.33905 .62589 m .38432 .65106 L .38663 .62948 L .728 0 0 r
F
.82871 .36187 m .82321 .4069 L .83231 .39142 L .98 0 0 r
F
.83042 .34256 m .82871 .36187 L .83231 .39142 L .914 0 0 r
F
.36336 .71721 m .34863 .71616 L .33613 .71995 L .65 0 0 r
F
.32009 .70269 m .33613 .71995 L .34863 .71616 L .64 0 0 r
F
.71467 .30446 m .75 .30037 L .74996 .29183 L .337 0 0 r
F
.71467 .30446 m .70819 .31526 L .75 .30037 L F
.68348 .36037 m .7104 .35131 L .70668 .3314 L .291 0 0 r
F
.68348 .36037 m .68815 .37874 L .7104 .35131 L F
.3439 .69535 m .36336 .71721 L .37203 .69738 L .714 0 0 r
F
.3439 .69535 m .34863 .71616 L .36336 .71721 L F
.33905 .62589 m .33884 .64768 L .38432 .65106 L .728 0 0 r
F
.30776 .68193 m .3439 .69535 L .34052 .67168 L .623 0 0 r
F
.30776 .68193 m .32009 .70269 L .3439 .69535 L F
.79311 .43491 m .7795 .43389 L .76585 .4384 L .56 0 0 r
F
.80764 .41861 m .7795 .43389 L .79311 .43491 L .759 0 0 r
F
.82321 .4069 m .80764 .41861 L .79311 .43491 L .713 0 0 r
F
.32009 .70269 m .34863 .71616 L .3439 .69535 L .64 0 0 r
F
.79505 .3045 m .83042 .34256 L .82509 .32589 L .897 0 0 r
F
.78794 .29534 m .79505 .3045 L .82509 .32589 L .687 0 0 r
F
.62358 .5924 m .57207 .6169 L .57767 .58882 L .73 .567 0 r
F
0 g
.4312 .64674 m
.49617 .62776 L
s
.62358 .5924 m .62617 .62104 L .57207 .6169 L .73 .567 0 r
F
.62002 .56388 m .62358 .5924 L .57767 .58882 L .726 .615 0 r
F
.66544 .57938 m .62617 .62104 L .62358 .5924 L .606 .474 0 r
F
.65041 .55426 m .62358 .5924 L .62002 .56388 L .628 .544 0 r
F
.65041 .55426 m .66544 .57938 L .62358 .5924 L F
.33884 .64768 m .37927 .67452 L .38432 .65106 L .73 0 0 r
F
.74996 .29183 m .79505 .3045 L .78794 .29534 L .625 0 0 r
F
.72098 .42872 m .73968 .4212 L .71769 .41082 L .479 0 0 r
F
0 g
.7144 .43651 m
.72028 .42737 L
s
.72784 .41561 m
.75907 .36708 L
s
.72098 .42872 m .74131 .43062 L .73968 .4212 L .479 0 0 r
F
0 g
.72028 .42737 m
.72219 .42439 L
s
.72219 .42439 m
.72268 .42364 L
s
.34052 .67168 m .37203 .69738 L .37927 .67452 L .726 0 0 r
F
.34052 .67168 m .3439 .69535 L .37203 .69738 L F
.82002 .38188 m .80764 .41861 L .82321 .4069 L .901 0 0 r
F
.82871 .36187 m .82002 .38188 L .82321 .4069 L .98 0 0 r
F
.62002 .56388 m .57767 .58882 L .58662 .56123 L .726 .615 0 r
F
.6158 .53796 m .62002 .56388 L .58662 .56123 L .714 .663 0 r
F
.63181 .53281 m .62002 .56388 L .6158 .53796 L .645 .614 0 r
F
.63181 .53281 m .65041 .55426 L .62002 .56388 L F
.62617 .62104 m .57036 .64298 L .57207 .6169 L .728 .509 0 r
F
0 g
.49617 .62776 m
.5023 .62597 L
s
.62617 .62104 m .62757 .64729 L .57036 .64298 L .728 .509 0 r
F
.67558 .60594 m .62757 .64729 L .62617 .62104 L .576 .392 0 r
F
.66544 .57938 m .67558 .60594 L .62617 .62104 L .606 .474 0 r
F
.57767 .58882 m .53242 .59485 L .54414 .56984 L .848 .686 0 r
F
.57767 .58882 m .57207 .6169 L .53242 .59485 L F
.58662 .56123 m .57767 .58882 L .54414 .56984 L .816 .715 0 r
F
.68815 .37874 m .71905 .37296 L .7104 .35131 L .42 0 0 r
F
.68815 .37874 m .69992 .39616 L .71905 .37296 L F
.33884 .64768 m .34052 .67168 L .37927 .67452 L .73 0 0 r
F
.74996 .29183 m .75 .30037 L .79505 .3045 L .625 0 0 r
F
.80695 .82945 m .76464 .85081 L .76892 .82688 L .73 0 0 r
F
.80695 .82945 m .80944 .85379 L .76464 .85081 L F
.80425 .80597 m .80695 .82945 L .76892 .82688 L .726 0 0 r
F
.84308 .82009 m .80944 .85379 L .80695 .82945 L .611 0 0 r
F
.83048 .79906 m .80695 .82945 L .80425 .80597 L .628 0 0 r
F
.83048 .79906 m .84308 .82009 L .80695 .82945 L F
.77571 .40912 m .76585 .4384 L .7795 .43389 L .664 0 0 r
F
.77571 .40912 m .75131 .43716 L .76585 .4384 L F
.58662 .56123 m .54414 .56984 L .56238 .54724 L .816 .715 0 r
F
.59815 .53654 m .58662 .56123 L .56238 .54724 L .772 .735 0 r
F
.6158 .53796 m .58662 .56123 L .59815 .53654 L .714 .663 0 r
F
.77571 .40912 m .74131 .43062 L .75131 .43716 L .664 0 0 r
F
.70819 .31526 m .75096 .31575 L .75 .30037 L .504 0 0 r
F
.70819 .31526 m .70668 .3314 L .75096 .31575 L F
.80425 .80597 m .76892 .82688 L .77658 .80407 L .726 0 0 r
F
.80157 .78543 m .80425 .80597 L .77658 .80407 L .714 0 0 r
F
.81538 .78174 m .80425 .80597 L .80157 .78543 L .642 0 0 r
F
.81538 .78174 m .83048 .79906 L .80425 .80597 L F
.57207 .6169 m .52836 .62001 L .53242 .59485 L .873 .64 0 r
F
.57207 .6169 m .57036 .64298 L .52836 .62001 L F
.80944 .85379 m .76415 .87372 L .76464 .85081 L .728 0 0 r
F
.80944 .85379 m .81148 .87682 L .76415 .87372 L F
.85204 .84294 m .81148 .87682 L .80944 .85379 L .588 0 0 r
F
.84308 .82009 m .85204 .84294 L .80944 .85379 L .611 0 0 r
F
.76892 .82688 m .73369 .83499 L .74273 .81325 L .856 0 0 r
F
.76892 .82688 m .76464 .85081 L .73369 .83499 L F
.77658 .80407 m .76892 .82688 L .74273 .81325 L .824 0 0 r
F
.79867 .32009 m .82871 .36187 L .83042 .34256 L .894 0 0 r
F
.79505 .3045 m .79867 .32009 L .83042 .34256 L .897 0 0 r
F
.77571 .40912 m .7795 .43389 L .7871 .42529 L .664 0 0 r
F
.80764 .41861 m .7871 .42529 L .7795 .43389 L .759 0 0 r
F
.77658 .80407 m .74273 .81325 L .75764 .79403 L .824 0 0 r
F
.78697 .78441 m .77658 .80407 L .75764 .79403 L .777 0 0 r
F
.80157 .78543 m .77658 .80407 L .78697 .78441 L .714 0 0 r
F
.80517 .40051 m .7871 .42529 L .80764 .41861 L .808 0 0 r
F
.82002 .38188 m .80517 .40051 L .80764 .41861 L .901 0 0 r
F
.76464 .85081 m .73143 .85727 L .73369 .83499 L .878 0 0 r
F
.76464 .85081 m .76415 .87372 L .73143 .85727 L F
.69992 .39616 m .73174 .3941 L .71905 .37296 L .504 0 0 r
F
.69992 .39616 m .71769 .41082 L .73174 .3941 L F
.63757 .51214 m .6158 .53796 L .59815 .53654 L .659 .747 0 r
F
0 g
.6669 .51031 m
.67092 .50407 L
s
.63757 .51214 m .63181 .53281 L .6158 .53796 L .659 .747 0 r
F
.66653 .53575 m .66544 .57938 L .65041 .55426 L .492 .486 0 r
F
0 g
.66605 .51162 m
.6669 .51031 L
s
.64016 .52298 m .65041 .55426 L .63181 .53281 L .561 .591 0 r
F
.64016 .52298 m .66653 .53575 L .65041 .55426 L F
.77571 .40912 m .73968 .4212 L .74131 .43062 L .664 0 0 r
F
.68795 .55416 m .67558 .60594 L .66544 .57938 L .409 .365 0 r
F
.66653 .53575 m .68795 .55416 L .66544 .57938 L .492 .486 0 r
F
.62757 .64729 m .57273 .66471 L .57036 .64298 L .715 .428 0 r
F
.62757 .64729 m .62762 .6688 L .57273 .66471 L F
.67986 .63157 m .62762 .6688 L .62757 .64729 L .528 .278 0 r
F
.67558 .60594 m .67986 .63157 L .62757 .64729 L .576 .392 0 r
F
.63757 .51214 m .59815 .53654 L .58545 .52907 L .659 .747 0 r
F
.59815 .53654 m .56238 .54724 L .58545 .52907 L .772 .735 0 r
F
.82198 .76696 m .80157 .78543 L .78697 .78441 L .645 0 0 r
F
.82198 .76696 m .81538 .78174 L .80157 .78543 L F
.84551 .7858 m .84308 .82009 L .83048 .79906 L .495 0 0 r
F
.8232 .7747 m .83048 .79906 L .81538 .78174 L .554 0 0 r
F
.8232 .7747 m .84551 .7858 L .83048 .79906 L F
.864 .80204 m .85204 .84294 L .84308 .82009 L .431 0 0 r
F
.84551 .7858 m .864 .80204 L .84308 .82009 L .495 0 0 r
F
.81148 .87682 m .76755 .89352 L .76415 .87372 L .717 0 0 r
F
.81148 .87682 m .81289 .89644 L .76755 .89352 L F
.85653 .86554 m .81289 .89644 L .81148 .87682 L .554 0 0 r
F
.85204 .84294 m .85653 .86554 L .81148 .87682 L .588 0 0 r
F
.75 .30037 m .79867 .32009 L .79505 .3045 L .711 0 0 r
F
.82198 .76696 m .78697 .78441 L .77704 .77906 L .645 0 0 r
F
.78697 .78441 m .75764 .79403 L .77704 .77906 L .777 0 0 r
F
.63757 .51214 m .64016 .52298 L .63181 .53281 L .659 .747 0 r
F
.77571 .40912 m .7871 .42529 L .7857 .41581 L .664 0 0 r
F
.80517 .40051 m .7857 .41581 L .7871 .42529 L .808 0 0 r
F
.57036 .64298 m .53249 .64297 L .52836 .62001 L .881 .555 0 r
F
.57036 .64298 m .57273 .66471 L .53249 .64297 L F
.71769 .41082 m .74716 .41247 L .73174 .3941 L .571 0 0 r
F
.71769 .41082 m .73968 .4212 L .74716 .41247 L F
.79835 .34061 m .82002 .38188 L .82871 .36187 L .861 0 0 r
F
.79867 .32009 m .79835 .34061 L .82871 .36187 L .894 0 0 r
F
.70238 .57657 m .67986 .63157 L .67558 .60594 L .294 .2 0 r
F
.68795 .55416 m .70238 .57657 L .67558 .60594 L .409 .365 0 r
F
.70668 .3314 m .75275 .3365 L .75096 .31575 L .569 0 0 r
F
.70668 .3314 m .7104 .35131 L .75275 .3365 L F
.56238 .54724 m .53575 .542 L .55653 .52688 L .893 .871 0 r
F
.56238 .54724 m .54414 .56984 L .53575 .542 L F
.58545 .52907 m .56238 .54724 L .55653 .52688 L .807 .834 0 r
F
.82198 .76696 m .8232 .7747 L .81538 .78174 L .645 0 0 r
F
.75 .30037 m .75096 .31575 L .79867 .32009 L .711 0 0 r
F
.76415 .87372 m .73626 .87798 L .73143 .85727 L .882 0 0 r
F
.76415 .87372 m .76755 .89352 L .73626 .87798 L F
.87689 .82194 m .85653 .86554 L .85204 .84294 L .35 0 0 r
F
.864 .80204 m .87689 .82194 L .85204 .84294 L .431 0 0 r
F
.63757 .51214 m .58545 .52907 L .58253 .51831 L .659 .747 0 r
F
.58545 .52907 m .55653 .52688 L .58253 .51831 L .807 .834 0 r
F
.77571 .40912 m .74716 .41247 L .73968 .4212 L .664 0 0 r
F
.75764 .79403 m .73842 .79336 L .75467 .77947 L .911 0 0 r
F
.75764 .79403 m .74273 .81325 L .73842 .79336 L F
.77704 .77906 m .75764 .79403 L .75467 .77947 L .814 0 0 r
F
.54414 .56984 m .52226 .56236 L .53575 .542 L .969 .883 0 r
F
.54414 .56984 m .53242 .59485 L .52226 .56236 L F
0 g
.5365 .61599 m
.61333 .59354 L
s
.82198 .76696 m .77704 .77906 L .77558 .77136 L .645 0 0 r
F
.77704 .77906 m .75467 .77947 L .77558 .77136 L .814 0 0 r
F
.74273 .81325 m .72845 .81182 L .73842 .79336 L .981 0 0 r
F
.74273 .81325 m .73369 .83499 L .72845 .81182 L F
.79406 .36395 m .80517 .40051 L .82002 .38188 L .82 0 0 r
F
.79835 .34061 m .79406 .36395 L .82002 .38188 L .861 0 0 r
F
.78623 .38762 m .7857 .41581 L .80517 .40051 L .773 0 0 r
F
.78623 .38762 m .77571 .40912 L .7857 .41581 L F
.63757 .51214 m .66653 .53575 L .64016 .52298 L .452 .6 0 r
F
.79406 .36395 m .78623 .38762 L .80517 .40051 L .82 0 0 r
F
.82198 .76696 m .84551 .7858 L .8232 .7747 L .425 0 0 r
F
.7104 .35131 m .75519 .36049 L .75275 .3365 L .605 0 0 r
F
.7104 .35131 m .71905 .37296 L .75519 .36049 L F
.62762 .6688 m .57909 .67997 L .57273 .66471 L .67 .28 0 r
F
.62762 .6688 m .6263 .68345 L .57909 .67997 L F
.67778 .65391 m .6263 .68345 L .62762 .6688 L .426 .077 0 r
F
.67986 .63157 m .67778 .65391 L .62762 .6688 L .528 .278 0 r
F
.75096 .31575 m .79835 .34061 L .79867 .32009 L .729 0 0 r
F
.81289 .89644 m .77461 .90829 L .76755 .89352 L .683 0 0 r
F
.81289 .89644 m .81353 .91078 L .77461 .90829 L F
.85605 .88579 m .81353 .91078 L .81289 .89644 L .488 0 0 r
F
.85653 .86554 m .85605 .88579 L .81289 .89644 L .554 0 0 r
F
.77571 .40912 m .76095 .40784 L .74716 .41247 L .664 0 0 r
F
.73174 .3941 m .74716 .41247 L .76095 .40784 L .647 0 0 r
F
.70832 .60093 m .67778 .65391 L .67986 .63157 L .103 0 0 r
F
.70238 .57657 m .70832 .60093 L .67986 .63157 L .294 .2 0 r
F
.88288 .84367 m .85605 .88579 L .85653 .86554 L .23 0 0 r
F
.87689 .82194 m .88288 .84367 L .85653 .86554 L .35 0 0 r
F
.53242 .59485 m .51751 .58609 L .52226 .56236 L .994 .819 0 r
F
.53242 .59485 m .52836 .62001 L .51751 .58609 L F
0 g
.5023 .62597 m
.52788 .6185 L
s
.73369 .83499 m .72584 .83312 L .72845 .81182 L .952 0 0 r
F
.73369 .83499 m .73143 .85727 L .72584 .83312 L F
.66187 .51511 m .68795 .55416 L .66653 .53575 L .228 .424 0 r
F
.63757 .51214 m .66187 .51511 L .66653 .53575 L .452 .6 0 r
F
.84338 .77108 m .864 .80204 L .84551 .7858 L .212 0 0 r
F
.82198 .76696 m .84338 .77108 L .84551 .7858 L .425 0 0 r
F
.82198 .76696 m .77558 .77136 L .78327 .76423 L .645 0 0 r
F
.77558 .77136 m .76922 .76586 L .78327 .76423 L .71 0 0 r
F
.77558 .77136 m .75467 .77947 L .76922 .76586 L F
.63757 .51214 m .58253 .51831 L .59067 .50831 L .659 .747 0 r
F
.58253 .51831 m .5719 .50777 L .59067 .50831 L .76 .928 0 r
F
.58253 .51831 m .55653 .52688 L .5719 .50777 L F
.75802 .38514 m .77571 .40912 L .78623 .38762 L .714 0 0 r
F
.75802 .38514 m .76095 .40784 L .77571 .40912 L F
.76755 .89352 m .74786 .89512 L .73626 .87798 L .828 0 0 r
F
.76755 .89352 m .77461 .90829 L .74786 .89512 L F
.75096 .31575 m .75275 .3365 L .79835 .34061 L .729 0 0 r
F
.57273 .66471 m .54463 .66149 L .53249 .64297 L .823 .361 0 r
F
.57273 .66471 m .57909 .67997 L .54463 .66149 L F
.71905 .37296 m .75802 .38514 L .75519 .36049 L .629 0 0 r
F
.71905 .37296 m .73174 .3941 L .75802 .38514 L F
.73174 .3941 m .76095 .40784 L .75802 .38514 L .647 0 0 r
F
.82198 .76696 m .79723 .76043 L .81206 .76148 L .645 0 0 r
F
.82198 .76696 m .78327 .76423 L .79723 .76043 L F
.81206 .76148 m .84338 .77108 L .82198 .76696 L .23 0 0 r
F
.86129 .78184 m .87689 .82194 L .864 .80204 L 0 0 0 r
F
.84338 .77108 m .86129 .78184 L .864 .80204 L .212 0 0 r
F
.63757 .51214 m .60688 .50299 L .62486 .50446 L .659 .747 0 r
F
.63757 .51214 m .59067 .50831 L .60688 .50299 L F
.62486 .50446 m .66187 .51511 L .63757 .51214 L .332 .656 0 r
F
.75275 .3365 m .79406 .36395 L .79835 .34061 L .731 0 0 r
F
.75467 .77947 m .75842 .77464 L .76922 .76586 L .531 0 0 r
F
.75467 .77947 m .73842 .79336 L .75842 .77464 L F
.68183 .5258 m .70238 .57657 L .68795 .55416 L 0 .103 0 r
F
.66187 .51511 m .68183 .5258 L .68795 .55416 L .228 .424 0 r
F
0 g
.66331 .51589 m
.66605 .51162 L
s
.75519 .36049 m .78623 .38762 L .79406 .36395 L .726 0 0 r
F
.75519 .36049 m .75802 .38514 L .78623 .38762 L F
.55653 .52688 m .55681 .51566 L .5719 .50777 L .753 .993 0 r
F
.55653 .52688 m .53575 .542 L .55681 .51566 L F
.78327 .76423 m .79599 .75858 L .79723 .76043 L .353 0 0 r
F
.78327 .76423 m .76922 .76586 L .79599 .75858 L F
.73143 .85727 m .73099 .8552 L .72584 .83312 L 0 0 0 r
F
.73143 .85727 m .73626 .87798 L .73099 .8552 L F
.75275 .3365 m .75519 .36049 L .79406 .36395 L .731 0 0 r
F
.59067 .50831 m .603 .49752 L .60688 .50299 L .543 .9 0 r
F
.59067 .50831 m .5719 .50777 L .603 .49752 L F
.52836 .62001 m .52218 .61092 L .51751 .58609 L .817 .539 0 r
F
.52836 .62001 m .53249 .64297 L .52218 .61092 L F
.85605 .88579 m .85055 .90173 L .81353 .91078 L .488 0 0 r
F
.88127 .86515 m .85055 .90173 L .85605 .88579 L .014 0 0 r
F
.88288 .84367 m .88127 .86515 L .85605 .88579 L .23 0 0 r
F
.81206 .76148 m .82448 .76059 L .84338 .77108 L F
.79723 .76043 m .82448 .76059 L .81206 .76148 L .126 0 0 r
F
.79723 .76043 m .79599 .75858 L .82448 .76059 L F
.67778 .65391 m .66938 .67078 L .6263 .68345 L .426 .077 0 r
F
.70502 .62494 m .66938 .67078 L .67778 .65391 L 0 0 0 r
F
.70832 .60093 m .70502 .62494 L .67778 .65391 L .103 0 0 r
F
.62486 .50446 m .6376 .50036 L .66187 .51511 L .332 .656 0 r
F
.60688 .50299 m .6376 .50036 L .62486 .50446 L .326 .76 0 r
F
.81353 .91078 m .78475 .91649 L .77461 .90829 L .557 0 0 r
F
.81353 .91078 m .81331 .91831 L .78475 .91649 L F
.85055 .90173 m .81331 .91831 L .81353 .91078 L .314 0 0 r
F
.8739 .79834 m .88288 .84367 L .87689 .82194 L 0 0 0 r
F
.86129 .78184 m .8739 .79834 L .87689 .82194 L F
.60688 .50299 m .603 .49752 L .6376 .50036 L .326 .76 0 r
F
.73842 .79336 m .75201 .7899 L .75842 .77464 L 0 0 0 r
F
.73842 .79336 m .72845 .81182 L .75201 .7899 L F
.82448 .76059 m .86129 .78184 L .84338 .77108 L .404 0 0 r
F
.6263 .68345 m .58896 .68711 L .57909 .67997 L .474 0 0 r
F
.6263 .68345 m .62367 .68966 L .58896 .68711 L F
.66938 .67078 m .62367 .68966 L .6263 .68345 L .132 0 0 r
F
.77461 .90829 m .76524 .90691 L .74786 .89512 L .539 0 0 r
F
.77461 .90829 m .78475 .91649 L .76524 .90691 L F
.69539 .54337 m .70832 .60093 L .70238 .57657 L 0 0 0 r
F
.68183 .5258 m .69539 .54337 L .70238 .57657 L 0 .103 0 r
F
.53575 .542 m .54702 .53144 L .55681 .51566 L 0 0 0 r
F
.53575 .542 m .52226 .56236 L .54702 .53144 L F
.6376 .50036 m .68183 .5258 L .66187 .51511 L 0 .276 0 r
F
.57909 .67997 m .56378 .67362 L .54463 .66149 L .454 0 0 r
F
.57909 .67997 m .58896 .68711 L .56378 .67362 L F
.73626 .87798 m .74351 .87588 L .73099 .8552 L 0 0 0 r
F
.73626 .87798 m .74786 .89512 L .74351 .87588 L F
.76922 .76586 m .79558 .76457 L .79599 .75858 L .224 0 0 r
F
.76922 .76586 m .75842 .77464 L .79558 .76457 L F
.53249 .64297 m .536 .63436 L .52218 .61092 L 0 0 0 r
F
.53249 .64297 m .54463 .66149 L .536 .63436 L F
.8739 .79834 m .87981 .81905 L .88288 .84367 L F
.87981 .81905 m .88127 .86515 L .88288 .84367 L .876 0 0 r
F
.85055 .90173 m .84044 .91172 L .81331 .91831 L .314 0 0 r
F
.87207 .88427 m .84044 .91172 L .85055 .90173 L 0 0 0 r
F
.88127 .86515 m .87207 .88427 L .85055 .90173 L .014 0 0 r
F
.72845 .81182 m .75076 .81023 L .75201 .7899 L .159 0 0 r
F
.72845 .81182 m .72584 .83312 L .75076 .81023 L F
.5719 .50777 m .60005 .50143 L .603 .49752 L 0 0 0 r
F
.5719 .50777 m .55681 .51566 L .60005 .50143 L F
.82448 .76059 m .83518 .76737 L .86129 .78184 L .404 0 0 r
F
.79599 .75858 m .83518 .76737 L .82448 .76059 L .499 0 0 r
F
.83518 .76737 m .8739 .79834 L .86129 .78184 L .806 0 0 r
F
.69539 .54337 m .70103 .56623 L .70832 .60093 L 0 0 0 r
F
.70103 .56623 m .70502 .62494 L .70832 .60093 L .959 .79 0 r
F
.66938 .67078 m .65528 .68039 L .62367 .68966 L .132 0 0 r
F
.70502 .62494 m .6926 .64621 L .66938 .67078 L 0 0 0 r
F
.6926 .64621 m .65528 .68039 L .66938 .67078 L .646 .943 0 r
F
.79599 .75858 m .79558 .76457 L .83518 .76737 L .499 0 0 r
F
0 g
.75716 .77764 m
.80465 .83841 L
s
.72798 .74028 m
.75598 .77613 L
s
.75598 .77613 m
.75635 .77659 L
s
.67154 .66804 m
.67203 .66868 L
s
.61333 .59354 m
.67038 .66656 L
s
.67203 .66868 m
.72798 .74028 L
s
.52226 .56236 m .54369 .55374 L .54702 .53144 L 0 0 0 r
F
.52226 .56236 m .51751 .58609 L .54369 .55374 L F
.81331 .91831 m .79706 .91713 L .78475 .91649 L F
.81331 .91831 m .81223 .91809 L .79706 .91713 L F
.84044 .91172 m .81223 .91809 L .81331 .91831 L .205 0 0 r
F
.74786 .89512 m .76224 .893 L .74351 .87588 L .122 0 0 r
F
.74786 .89512 m .76524 .90691 L .76224 .893 L F
.6376 .50036 m .64825 .50538 L .68183 .5258 L 0 .276 0 r
F
.603 .49752 m .64825 .50538 L .6376 .50036 L .361 0 0 r
F
.78475 .91649 m .78678 .91206 L .76524 .90691 L .109 0 0 r
F
.78475 .91649 m .79706 .91713 L .78678 .91206 L F
.64825 .50538 m .69539 .54337 L .68183 .5258 L .786 .287 0 r
F
0 g
.61333 .59354 m
.66005 .52094 L
s
.87831 .84196 m .87207 .88427 L .88127 .86515 L .973 0 0 r
F
.87981 .81905 m .87831 .84196 L .88127 .86515 L .876 0 0 r
F
.603 .49752 m .60005 .50143 L .64825 .50538 L .361 0 0 r
F
.75842 .77464 m .79607 .77806 L .79558 .76457 L .456 0 0 r
F
.75842 .77464 m .75201 .7899 L .79607 .77806 L F
.72584 .83312 m .75489 .83366 L .75076 .81023 L .307 0 0 r
F
.72584 .83312 m .73099 .8552 L .75489 .83366 L F
.62367 .68966 m .60148 .68513 L .58896 .68711 L .178 .693 0 r
F
.62367 .68966 m .61995 .68649 L .60148 .68513 L F
.65528 .68039 m .61995 .68649 L .62367 .68966 L .433 .868 0 r
F
.54463 .66149 m .55771 .65397 L .536 .63436 L .122 .372 0 r
F
.54463 .66149 m .56378 .67362 L .55771 .65397 L F
.84044 .91172 m .8266 .9146 L .81223 .91809 L .205 0 0 r
F
.87207 .88427 m .85606 .89905 L .84044 .91172 L 0 0 0 r
F
.85606 .89905 m .8266 .9146 L .84044 .91172 L .654 0 0 r
F
.58896 .68711 m .58819 .67797 L .56378 .67362 L .221 .622 0 r
F
.58896 .68711 m .60148 .68513 L .58819 .67797 L F
.84306 .78135 m .87981 .81905 L .8739 .79834 L .89 0 0 r
F
.83518 .76737 m .84306 .78135 L .8739 .79834 L .806 0 0 r
F
.69798 .59218 m .6926 .64621 L .70502 .62494 L .979 .905 0 r
F
.70103 .56623 m .69798 .59218 L .70502 .62494 L .959 .79 0 r
F
.55681 .51566 m .59835 .51467 L .60005 .50143 L .365 0 0 r
F
.55681 .51566 m .54702 .53144 L .59835 .51467 L F
.51751 .58609 m .54733 .5804 L .54369 .55374 L .225 .138 0 r
F
.51751 .58609 m .52218 .61092 L .54733 .5804 L F
.79558 .76457 m .84306 .78135 L .83518 .76737 L .672 0 0 r
F
.76524 .90691 m .78532 .90476 L .76224 .893 L .375 0 0 r
F
.76524 .90691 m .78678 .91206 L .78532 .90476 L F
.86941 .86472 m .85606 .89905 L .87207 .88427 L .918 0 0 r
F
.87831 .84196 m .86941 .86472 L .87207 .88427 L .973 0 0 r
F
.73099 .8552 m .76406 .85775 L .75489 .83366 L .402 0 0 r
F
.73099 .8552 m .74351 .87588 L .76406 .85775 L F
.65528 .68039 m .63673 .68156 L .61995 .68649 L .433 .868 0 r
F
.67211 .66253 m .63673 .68156 L .65528 .68039 L .735 .954 0 r
F
.6926 .64621 m .67211 .66253 L .65528 .68039 L .646 .943 0 r
F
.79558 .76457 m .79607 .77806 L .84306 .78135 L .672 0 0 r
F
.8233 .89539 m .81223 .91809 L .8266 .9146 L .629 0 0 r
F
.8233 .89539 m .79706 .91713 L .81223 .91809 L F
.65567 .51933 m .70103 .56623 L .69539 .54337 L .891 .541 0 r
F
.64825 .50538 m .65567 .51933 L .69539 .54337 L .786 .287 0 r
F
.8233 .89539 m .78678 .91206 L .79706 .91713 L .629 0 0 r
F
.75201 .7899 m .79743 .79786 L .79607 .77806 L .538 0 0 r
F
.75201 .7899 m .75076 .81023 L .79743 .79786 L F
.84721 .8013 m .87831 .84196 L .87981 .81905 L .89 0 0 r
F
.84306 .78135 m .84721 .8013 L .87981 .81905 L F
.8233 .89539 m .8266 .9146 L .83478 .90793 L .629 0 0 r
F
.85606 .89905 m .83478 .90793 L .8266 .9146 L .654 0 0 r
F
.60005 .50143 m .65567 .51933 L .64825 .50538 L .65 .228 0 r
F
.56378 .67362 m .58515 .66765 L .55771 .65397 L .401 .591 0 r
F
.56378 .67362 m .58819 .67797 L .58515 .66765 L F
.85397 .88498 m .83478 .90793 L .85606 .89905 L .816 0 0 r
F
.86941 .86472 m .85397 .88498 L .85606 .89905 L .918 0 0 r
F
.68637 .61857 m .67211 .66253 L .6926 .64621 L .906 .901 0 r
F
.69798 .59218 m .68637 .61857 L .6926 .64621 L .979 .905 0 r
F
.74351 .87588 m .77735 .87999 L .76406 .85775 L .473 0 0 r
F
.74351 .87588 m .76224 .893 L .77735 .87999 L F
.8233 .89539 m .78532 .90476 L .78678 .91206 L .629 0 0 r
F
.52218 .61092 m .55769 .60867 L .54733 .5804 L .367 .334 0 r
F
.52218 .61092 m .536 .63436 L .55769 .60867 L F
.60005 .50143 m .59835 .51467 L .65567 .51933 L .65 .228 0 r
F
.62953 .65436 m .61995 .68649 L .63673 .68156 L .647 .762 0 r
F
.62953 .65436 m .60148 .68513 L .61995 .68649 L F
.79607 .77806 m .84721 .8013 L .84306 .78135 L .715 0 0 r
F
.62953 .65436 m .58819 .67797 L .60148 .68513 L .647 .762 0 r
F
.54702 .53144 m .59813 .53617 L .59835 .51467 L .503 .24 0 r
F
.54702 .53144 m .54369 .55374 L .59813 .53617 L F
.8233 .89539 m .83478 .90793 L .83357 .90058 L .629 0 0 r
F
.85397 .88498 m .83357 .90058 L .83478 .90793 L .816 0 0 r
F
.76224 .893 m .79336 .89799 L .77735 .87999 L .536 0 0 r
F
.76224 .893 m .78532 .90476 L .79336 .89799 L F
.84712 .82525 m .86941 .86472 L .87831 .84196 L .867 0 0 r
F
.84721 .8013 m .84712 .82525 L .87831 .84196 L .89 0 0 r
F
.75076 .81023 m .79954 .82202 L .79743 .79786 L .578 0 0 r
F
.75076 .81023 m .75489 .83366 L .79954 .82202 L F
.65896 .54105 m .69798 .59218 L .70103 .56623 L .887 .643 0 r
F
.65567 .51933 m .65896 .54105 L .70103 .56623 L .891 .541 0 r
F
.79607 .77806 m .79743 .79786 L .84721 .8013 L .715 0 0 r
F
.62953 .65436 m .63673 .68156 L .64551 .67213 L .647 .762 0 r
F
.67211 .66253 m .64551 .67213 L .63673 .68156 L .735 .954 0 r
F
.8233 .89539 m .79336 .89799 L .78532 .90476 L .629 0 0 r
F
.66733 .64261 m .64551 .67213 L .67211 .66253 L .812 .86 0 r
F
.68637 .61857 m .66733 .64261 L .67211 .66253 L .906 .901 0 r
F
.536 .63436 m .57372 .63552 L .55769 .60867 L .464 .473 0 r
F
.536 .63436 m .55771 .65397 L .57372 .63552 L F
.62953 .65436 m .58515 .66765 L .58819 .67797 L .647 .762 0 r
F
.84274 .85071 m .85397 .88498 L .86941 .86472 L .833 0 0 r
F
.84712 .82525 m .84274 .85071 L .86941 .86472 L .867 0 0 r
F
.8345 .87495 m .83357 .90058 L .85397 .88498 L .782 0 0 r
F
.8345 .87495 m .8233 .89539 L .83357 .90058 L F
.84274 .85071 m .8345 .87495 L .85397 .88498 L .833 0 0 r
F
.75489 .83366 m .80218 .848 L .79954 .82202 L .604 0 0 r
F
.75489 .83366 m .76406 .85775 L .80218 .848 L F
.59835 .51467 m .65896 .54105 L .65567 .51933 L .713 .409 0 r
F
.79743 .79786 m .84712 .82525 L .84721 .8013 L .729 0 0 r
F
.8233 .89539 m .8079 .89439 L .79336 .89799 L .629 0 0 r
F
.77735 .87999 m .79336 .89799 L .8079 .89439 L .636 0 0 r
F
.62953 .65436 m .64551 .67213 L .64282 .66173 L .647 .762 0 r
F
.66733 .64261 m .64282 .66173 L .64551 .67213 L .812 .86 0 r
F
.55771 .65397 m .5937 .65806 L .57372 .63552 L .541 .589 0 r
F
.55771 .65397 m .58515 .66765 L .5937 .65806 L F
.65767 .56845 m .68637 .61857 L .69798 .59218 L .861 .695 0 r
F
.65896 .54105 m .65767 .56845 L .69798 .59218 L .887 .643 0 r
F
.54369 .55374 m .59946 .56384 L .59813 .53617 L .562 .373 0 r
F
.54369 .55374 m .54733 .5804 L .59946 .56384 L F
.80507 .87302 m .8233 .89539 L .8345 .87495 L .714 0 0 r
F
.80507 .87302 m .8079 .89439 L .8233 .89539 L F
.59835 .51467 m .59813 .53617 L .65896 .54105 L .713 .409 0 r
F
.79743 .79786 m .79954 .82202 L .84712 .82525 L .729 0 0 r
F
.76406 .85775 m .80507 .87302 L .80218 .848 L .622 0 0 r
F
.76406 .85775 m .77735 .87999 L .80507 .87302 L F
.77735 .87999 m .8079 .89439 L .80507 .87302 L .636 0 0 r
F
.62953 .65436 m .5937 .65806 L .58515 .66765 L .647 .762 0 r
F
.79954 .82202 m .84274 .85071 L .84712 .82525 L .732 0 0 r
F
.65185 .59864 m .66733 .64261 L .68637 .61857 L .825 .727 0 r
F
.65767 .56845 m .65185 .59864 L .68637 .61857 L .861 .695 0 r
F
.80218 .848 m .8345 .87495 L .84274 .85071 L .728 0 0 r
F
.80218 .848 m .80507 .87302 L .8345 .87495 L F
.64212 .62836 m .64282 .66173 L .66733 .64261 L .777 .75 0 r
F
.64212 .62836 m .62953 .65436 L .64282 .66173 L F
.79954 .82202 m .80218 .848 L .84274 .85071 L .732 0 0 r
F
.65185 .59864 m .64212 .62836 L .66733 .64261 L .825 .727 0 r
F
.54733 .5804 m .60222 .59478 L .59946 .56384 L .597 .464 0 r
F
0 g
.59164 .5743 m
.59225 .57484 L
s
.60114 .58273 m
.61333 .59354 L
s
.58425 .56775 m
.59164 .5743 L
s
.54733 .5804 m .55769 .60867 L .60222 .59478 L .597 .464 0 r
F
.59813 .53617 m .65767 .56845 L .65896 .54105 L .729 .502 0 r
F
.62953 .65436 m .61069 .65295 L .5937 .65806 L .647 .762 0 r
F
.57372 .63552 m .5937 .65806 L .61069 .65295 L .638 .617 0 r
F
.6061 .62561 m .62953 .65436 L .64212 .62836 L .714 .67 0 r
F
.6061 .62561 m .61069 .65295 L .62953 .65436 L F
.59813 .53617 m .59946 .56384 L .65767 .56845 L .729 .502 0 r
F
.55769 .60867 m .6061 .62561 L .60222 .59478 L .62 .541 0 r
F
.55769 .60867 m .57372 .63552 L .6061 .62561 L F
.57372 .63552 m .61069 .65295 L .6061 .62561 L .638 .617 0 r
F
.59946 .56384 m .65185 .59864 L .65767 .56845 L .732 .566 0 r
F
.60222 .59478 m .64212 .62836 L .65185 .59864 L .728 .618 0 r
F
.60222 .59478 m .6061 .62561 L .64212 .62836 L F
.59946 .56384 m .60222 .59478 L .65185 .59864 L .732 .566 0 r
F
.54549 .52355 m .49572 .54676 L .50126 .51998 L .734 0 0 r
F
.54549 .52355 m .54783 .5509 L .49572 .54676 L F
.54194 .49605 m .54549 .52355 L .50126 .51998 L .729 0 0 r
F
.5851 .51054 m .54783 .5509 L .54549 .52355 L .587 0 0 r
F
0 g
.55567 .5424 m
.58425 .56775 L
s
.57069 .48646 m .54549 .52355 L .54194 .49605 L .614 0 0 r
F
.57069 .48646 m .5851 .51054 L .54549 .52355 L F
.54194 .49605 m .50126 .51998 L .50977 .49341 L .729 0 0 r
F
.53748 .47082 m .54194 .49605 L .50977 .49341 L .714 0 0 r
F
.55263 .46569 m .54194 .49605 L .53748 .47082 L .635 0 0 r
F
.55263 .46569 m .57069 .48646 L .54194 .49605 L F
.54783 .5509 m .49364 .5714 L .49572 .54676 L .73 0 0 r
F
.54783 .5509 m .54874 .57572 L .49364 .5714 L F
.59456 .5358 m .54874 .57572 L .54783 .5509 L .549 0 0 r
F
.5851 .51054 m .59456 .5358 L .54783 .5509 L .587 0 0 r
F
.50126 .51998 m .45671 .52472 L .46828 .50102 L .862 0 0 r
F
.50126 .51998 m .49572 .54676 L .45671 .52472 L F
.50977 .49341 m .50126 .51998 L .46828 .50102 L .827 0 0 r
F
.50977 .49341 m .46828 .50102 L .48591 .47946 L F
.52049 .46941 m .50977 .49341 L .48591 .47946 L .778 0 0 r
F
.53748 .47082 m .50977 .49341 L .52049 .46941 L .714 0 0 r
F
.49572 .54676 m .45234 .54841 L .45671 .52472 L .887 0 0 r
F
.49572 .54676 m .49364 .5714 L .45234 .54841 L F
.55726 .44511 m .53748 .47082 L .52049 .46941 L .65 0 0 r
F
.55726 .44511 m .55263 .46569 L .53748 .47082 L F
.58534 .46801 m .5851 .51054 L .57069 .48646 L .453 0 0 r
F
.56022 .4559 m .57069 .48646 L .55263 .46569 L .537 0 0 r
F
.56022 .4559 m .58534 .46801 L .57069 .48646 L F
.60555 .48538 m .59456 .5358 L .5851 .51054 L .35 0 0 r
F
.58534 .46801 m .60555 .48538 L .5851 .51054 L .453 0 0 r
F
.54874 .57572 m .49527 .59164 L .49364 .5714 L .711 0 0 r
F
.54874 .57572 m .54812 .59573 L .49527 .59164 L F
.59818 .55997 m .54812 .59573 L .54874 .57572 L .485 0 0 r
F
.59456 .5358 m .59818 .55997 L .54874 .57572 L .549 0 0 r
F
0 g
.53263 .52196 m
.55421 .5411 L
s
.55726 .44511 m .52049 .46941 L .50798 .46197 L .65 0 0 r
F
.52049 .46941 m .48591 .47946 L .50798 .46197 L .778 0 0 r
F
.55726 .44511 m .56022 .4559 L .55263 .46569 L .65 0 0 r
F
.49364 .5714 m .4557 .56986 L .45234 .54841 L .889 0 0 r
F
.49364 .5714 m .49527 .59164 L .4557 .56986 L F
.6189 .50647 m .59818 .55997 L .59456 .5358 L .204 0 0 r
F
.60555 .48538 m .6189 .50647 L .59456 .5358 L .35 0 0 r
F
.48591 .47946 m .45906 .47326 L .47945 .45917 L .899 0 0 r
F
.48591 .47946 m .46828 .50102 L .45906 .47326 L F
.50798 .46197 m .48591 .47946 L .47945 .45917 L .81 0 0 r
F
.55726 .44511 m .50798 .46197 L .50473 .45125 L .65 0 0 r
F
.50798 .46197 m .47945 .45917 L .50473 .45125 L .81 0 0 r
F
.46828 .50102 m .44558 .49229 L .45906 .47326 L .972 0 0 r
F
.46828 .50102 m .45671 .52472 L .44558 .49229 L F
.55726 .44511 m .58534 .46801 L .56022 .4559 L .415 0 0 r
F
.54812 .59573 m .50056 .60551 L .49527 .59164 L .647 0 0 r
F
.54812 .59573 m .54599 .609 L .50056 .60551 L F
.59552 .58081 m .54599 .609 L .54812 .59573 L .35 0 0 r
F
.59818 .55997 m .59552 .58081 L .54812 .59573 L .485 0 0 r
F
.62402 .52934 m .59552 .58081 L .59818 .55997 L 0 0 0 r
F
.6189 .50647 m .62402 .52934 L .59818 .55997 L .204 0 0 r
F
.45671 .52472 m .44046 .51451 L .44558 .49229 L .994 0 0 r
F
.45671 .52472 m .45234 .54841 L .44046 .51451 L F
.57996 .44746 m .60555 .48538 L .58534 .46801 L .161 0 0 r
F
.55726 .44511 m .57996 .44746 L .58534 .46801 L .415 0 0 r
F
.55726 .44511 m .50473 .45125 L .51212 .4413 L .65 0 0 r
F
.50473 .45125 m .49338 .44016 L .51212 .4413 L .756 0 0 r
F
.50473 .45125 m .47945 .45917 L .49338 .44016 L F
.49527 .59164 m .46666 .58697 L .4557 .56986 L .807 0 0 r
F
.49527 .59164 m .50056 .60551 L .46666 .58697 L F
.55726 .44511 m .52744 .436 L .54474 .43747 L .65 0 0 r
F
.55726 .44511 m .51212 .4413 L .52744 .436 L F
.54474 .43747 m .57996 .44746 L .55726 .44511 L .301 0 0 r
F
.5984 .45713 m .6189 .50647 L .60555 .48538 L 0 0 0 r
F
.57996 .44746 m .5984 .45713 L .60555 .48538 L .161 0 0 r
F
.47945 .45917 m .47814 .44703 L .49338 .44016 L .768 0 0 r
F
.47945 .45917 m .45906 .47326 L .47814 .44703 L F
.51212 .4413 m .52276 .42996 L .52744 .436 L .546 0 0 r
F
.51212 .4413 m .49338 .44016 L .52276 .42996 L F
.45234 .54841 m .44439 .5378 L .44046 .51451 L .841 0 0 r
F
.45234 .54841 m .4557 .56986 L .44439 .5378 L F
.59552 .58081 m .58668 .59628 L .54599 .609 L .35 0 0 r
F
.62023 .55182 m .58668 .59628 L .59552 .58081 L 0 0 0 r
F
.62402 .52934 m .62023 .55182 L .59552 .58081 L F
.54474 .43747 m .55605 .43279 L .57996 .44746 L .301 0 0 r
F
.52744 .436 m .55605 .43279 L .54474 .43747 L .325 0 0 r
F
.52744 .436 m .52276 .42996 L .55605 .43279 L F
.54599 .609 m .50911 .61149 L .50056 .60551 L .403 0 0 r
F
.54599 .609 m .5425 .61405 L .50911 .61149 L F
.58668 .59628 m .5425 .61405 L .54599 .609 L .012 0 0 r
F
.5984 .45713 m .61067 .47336 L .6189 .50647 L 0 0 0 r
F
.61067 .47336 m .62402 .52934 L .6189 .50647 L .713 0 0 r
F
.45906 .47326 m .46799 .46148 L .47814 .44703 L 0 0 0 r
F
.45906 .47326 m .44558 .49229 L .46799 .46148 L F
.55605 .43279 m .5984 .45713 L .57996 .44746 L F
.50056 .60551 m .48434 .59795 L .46666 .58697 L .421 0 0 r
F
.50056 .60551 m .50911 .61149 L .48434 .59795 L F
.4557 .56986 m .45716 .55981 L .44439 .5378 L 0 0 0 r
F
.4557 .56986 m .46666 .58697 L .45716 .55981 L F
.49338 .44016 m .51895 .43287 L .52276 .42996 L F
.49338 .44016 m .47814 .44703 L .51895 .43287 L F
.61539 .4947 m .62023 .55182 L .62402 .52934 L .966 0 0 r
F
.61067 .47336 m .61539 .4947 L .62402 .52934 L .713 0 0 r
F
.58668 .59628 m .57234 .60474 L .5425 .61405 L .012 0 0 r
F
.62023 .55182 m .60772 .57167 L .58668 .59628 L 0 0 0 r
F
.60772 .57167 m .57234 .60474 L .58668 .59628 L .692 0 0 r
F
.44558 .49229 m .46414 .48224 L .46799 .46148 L 0 0 0 r
F
.44558 .49229 m .44046 .51451 L .46414 .48224 L F
.55605 .43279 m .56531 .43681 L .5984 .45713 L F
.52276 .42996 m .56531 .43681 L .55605 .43279 L .288 0 0 r
F
.56531 .43681 m .61067 .47336 L .5984 .45713 L .766 0 0 r
F
.52276 .42996 m .51895 .43287 L .56531 .43681 L .288 0 0 r
F
.5425 .61405 m .52019 .60873 L .50911 .61149 L .205 0 0 r
F
.5425 .61405 m .53795 .61009 L .52019 .60873 L F
.57234 .60474 m .53795 .61009 L .5425 .61405 L .46 0 0 r
F
.46666 .58697 m .47761 .57826 L .45716 .55981 L .056 0 0 r
F
.46666 .58697 m .48434 .59795 L .47761 .57826 L F
.50911 .61149 m .50711 .60154 L .48434 .59795 L .202 0 0 r
F
.50911 .61149 m .52019 .60873 L .50711 .60154 L F
.61189 .51907 m .60772 .57167 L .62023 .55182 L .98 0 0 r
F
.61539 .4947 m .61189 .51907 L .62023 .55182 L .966 0 0 r
F
.47814 .44703 m .51642 .44478 L .51895 .43287 L .278 0 0 r
F
.47814 .44703 m .46799 .46148 L .51642 .44478 L F
.44046 .51451 m .46712 .50732 L .46414 .48224 L .123 0 0 r
F
.44046 .51451 m .44439 .5378 L .46712 .50732 L F
.57234 .60474 m .55377 .60514 L .53795 .61009 L .46 0 0 r
F
.58757 .58684 m .55377 .60514 L .57234 .60474 L .734 0 0 r
F
.60772 .57167 m .58757 .58684 L .57234 .60474 L .692 0 0 r
F
.57151 .44942 m .61539 .4947 L .61067 .47336 L .896 0 0 r
F
.56531 .43681 m .57151 .44942 L .61067 .47336 L .766 0 0 r
F
.51895 .43287 m .57151 .44942 L .56531 .43681 L .622 0 0 r
F
.48434 .59795 m .50371 .59119 L .47761 .57826 L .363 0 0 r
F
.48434 .59795 m .50711 .60154 L .50371 .59119 L F
.6004 .54401 m .58757 .58684 L .60772 .57167 L .909 0 0 r
F
.61189 .51907 m .6004 .54401 L .60772 .57167 L .98 0 0 r
F
.44439 .5378 m .47675 .53411 L .46712 .50732 L .301 0 0 r
F
.44439 .5378 m .45716 .55981 L .47675 .53411 L F
.51895 .43287 m .51642 .44478 L .57151 .44942 L .622 0 0 r
F
.54554 .57788 m .53795 .61009 L .55377 .60514 L .636 0 0 r
F
.54554 .57788 m .52019 .60873 L .53795 .61009 L F
.54554 .57788 m .50711 .60154 L .52019 .60873 L F
.46799 .46148 m .51547 .46473 L .51642 .44478 L .454 0 0 r
F
.46799 .46148 m .46414 .48224 L .51547 .46473 L F
.57392 .4696 m .61189 .51907 L .61539 .4947 L .9 0 0 r
F
.57151 .44942 m .57392 .4696 L .61539 .4947 L .896 0 0 r
F
.54554 .57788 m .55377 .60514 L .56171 .59569 L .636 0 0 r
F
.58757 .58684 m .56171 .59569 L .55377 .60514 L .734 0 0 r
F
.58201 .56688 m .56171 .59569 L .58757 .58684 L .814 0 0 r
F
.6004 .54401 m .58201 .56688 L .58757 .58684 L .909 0 0 r
F
.45716 .55981 m .49207 .55978 L .47675 .53411 L .421 0 0 r
F
.45716 .55981 m .47761 .57826 L .49207 .55978 L F
.54554 .57788 m .50371 .59119 L .50711 .60154 L .636 0 0 r
F
.51642 .44478 m .57392 .4696 L .57151 .44942 L .707 0 0 r
F
.54554 .57788 m .56171 .59569 L .55863 .58526 L .636 0 0 r
F
.58201 .56688 m .55863 .58526 L .56171 .59569 L .814 0 0 r
F
.47761 .57826 m .51143 .58158 L .49207 .55978 L .515 0 0 r
F
.47761 .57826 m .50371 .59119 L .51143 .58158 L F
.57217 .49539 m .6004 .54401 L .61189 .51907 L .874 0 0 r
F
.57392 .4696 m .57217 .49539 L .61189 .51907 L .9 0 0 r
F
.46414 .48224 m .51626 .49079 L .51547 .46473 L .532 0 0 r
F
.46414 .48224 m .46712 .50732 L .51626 .49079 L F
.51642 .44478 m .51547 .46473 L .57392 .4696 L .707 0 0 r
F
.54554 .57788 m .51143 .58158 L .50371 .59119 L .636 0 0 r
F
.56639 .52409 m .58201 .56688 L .6004 .54401 L .836 0 0 r
F
.57217 .49539 m .56639 .52409 L .6004 .54401 L .874 0 0 r
F
.55718 .55262 m .55863 .58526 L .58201 .56688 L .782 0 0 r
F
.55718 .55262 m .54554 .57788 L .55863 .58526 L F
.56639 .52409 m .55718 .55262 L .58201 .56688 L .836 0 0 r
F
.46712 .50732 m .51872 .52024 L .51626 .49079 L .576 0 0 r
F
.46712 .50732 m .47675 .53411 L .51872 .52024 L F
.51547 .46473 m .57217 .49539 L .57392 .4696 L .731 0 0 r
F
.54554 .57788 m .52745 .57646 L .51143 .58158 L .636 0 0 r
F
.49207 .55978 m .51143 .58158 L .52745 .57646 L .627 0 0 r
F
.52259 .54987 m .54554 .57788 L .55718 .55262 L .714 0 0 r
F
.52259 .54987 m .52745 .57646 L .54554 .57788 L F
.51547 .46473 m .51626 .49079 L .57217 .49539 L .731 0 0 r
F
.47675 .53411 m .52259 .54987 L .51872 .52024 L .606 0 0 r
F
.47675 .53411 m .49207 .55978 L .52259 .54987 L F
.49207 .55978 m .52745 .57646 L .52259 .54987 L .627 0 0 r
F
.51626 .49079 m .56639 .52409 L .57217 .49539 L .736 0 0 r
F
.51872 .52024 m .55718 .55262 L .56639 .52409 L .73 0 0 r
F
.51872 .52024 m .52259 .54987 L .55718 .55262 L F
.51626 .49079 m .51872 .52024 L .56639 .52409 L .736 0 0 r
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{237.125, 251.688},
 ImageMargins->{{27, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[27]:=",
 CellID->25391,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 236.125}, {250.688, 0}} -> {0.0403593, -0.000101771, \
0.00369235, 0.00369235}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation Details", "Subsection",
 CellID->16534],

Cell[TextData[{
 "The original MoDL file contains a head and a body. In the head, a number of \
definitions are made, which are used throughout the body. We have extracted \
these definitions into the variable ",
 Cell[BoxData["defs"], "InlineFormula"],
 ". We then map the function ",
 Cell[BoxData["ProcessDefinition"], "InlineFormula"],
 " across the list of definitions. ",
 Cell[BoxData["ProcessDefinition"], "InlineFormula"],
 " constructs a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression out of a definition and stores it in the variable ",
 Cell[BoxData["moldef"], "InlineFormula"],
 ", which is dynamically scoped inside of ",
 Cell[BoxData["MoDLToGraphics3D"], "InlineFormula"],
 "."
}], "Text",
 CellID->23931],

Cell[TextData[{
 "A ",
 StyleBox["DEFINE", "MR"],
 " element in the head typically defines either an atom or a molecule. First, \
consider an atom definition."
}], "Text",
 CellID->22322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Cases", "[", 
   RowBox[{"methane", ",", "\[IndentingNewLine]", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<DEFINE\>\"", ",", "_", ",", 
      RowBox[{"{", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<atom\>\"", ",", "__"}], "]"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", "Infinity"}], "]"}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->27079],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"DEFINE\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"C\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"atom\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\<\"radius\"\>", "\[Rule]", "\<\"0.3\"\>"}], ",", 
        RowBox[{"\<\"color\"\>", "\[Rule]", "\<\"1 1 0\"\>"}]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->8202]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["DEFINE", "MR"],
 " element essentially associates a unique key (in this case C) to an atom \
element. The atom element specifies its color and radius. We will turn this \
into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression of the form ",
 Cell[BoxData[
  RowBox[{"Atom", "[", 
   RowBox[{"radius", ",", " ", "color"}], "]"}]], "InlineFormula",
  ShowStringCharacters->False],
 " and then store it in ",
 Cell[BoxData[
  RowBox[{"moldef", "[", "name", "]"}]], "InlineFormula"],
 ", where ",
 StyleBox["name", "TI"],
 " is the key specified in the ",
 StyleBox["DEFINE", "MR"],
 " element."
}], "Text",
 CellID->11176],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProcessDefinition", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<DEFINE\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<name\>\"", "\[Rule]", "name_String"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<atom\>\"", ",", 
         RowBox[{"{", "a__", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"moldef", "[", "name", "]"}], "=", 
     RowBox[{"Atom", "[", 
      RowBox[{
       RowBox[{"GetRad", "[", "a", "]"}], ",", 
       RowBox[{"GetColor", "[", "a", "]"}]}], "]"}]}], ")"}]}], 
  ";"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->21580],

Cell[TextData[{
 "In this case, ",
 StyleBox["a", "MR"],
 " is the entire sequence of attributes of the atom element. ",
 StyleBox["GetRad", "MR"],
 " and ",
 StyleBox["GetColor", "MR"],
 " are functions we will define later that extract the radius and color from \
this sequence. For now, assume that ",
 StyleBox["GetRad", "MR"],
 " returns a number and that ",
 StyleBox["GetColor", "MR"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". We now need to process definitions of molecule elements. Like the atom \
definitions, molecules are given a unique key in the name attribute of the ",
 StyleBox["DEFINE", "MR"],
 " element. The molecule element then contains atom elements and bond \
elements."
}], "Text",
 CellID->13269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Cases", "[", 
   RowBox[{"methane", ",", "\[IndentingNewLine]", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<DEFINE\>\"", ",", "_", ",", 
      RowBox[{"{", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<molecule\>\"", ",", "__"}], "]"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", "Infinity"}], "]"}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->5388],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"DEFINE\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"CH4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"molecule\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"atom\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"C\"\>"}], ",", 
            RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"c1\"\>"}], ",", 
            RowBox[{"\<\"position\"\>", "\[Rule]", "\<\"0 0 0.4\"\>"}]}], 
           "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"atom\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"H\"\>"}], ",", 
            RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"h1\"\>"}], ",", 
            RowBox[{"\<\"position\"\>", "\[Rule]", "\<\"0.5 0.1 -0.4\"\>"}]}],
            "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"atom\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"H\"\>"}], ",", 
            RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"h2\"\>"}], ",", 
            RowBox[{"\<\"position\"\>", "\[Rule]", "\<\"-1 0.1 0.3\"\>"}]}], 
           "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"atom\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"H\"\>"}], ",", 
            RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"h3\"\>"}], ",", 
            RowBox[{"\<\"position\"\>", "\[Rule]", "\<\"0.3 0.7 1\"\>"}]}], 
           "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"atom\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"H\"\>"}], ",", 
            RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"h4\"\>"}], ",", 
            RowBox[{"\<\"position\"\>", "\[Rule]", "\<\"0.2 -0.9 0.8\"\>"}]}],
            "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"bond\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"atom1\"\>", "\[Rule]", "\<\"c1\"\>"}], ",", 
            RowBox[{"\<\"atom2\"\>", "\[Rule]", "\<\"h1\"\>"}]}], "}"}], ",", 
          
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"bond\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"atom1\"\>", "\[Rule]", "\<\"c1\"\>"}], ",", 
            RowBox[{"\<\"atom2\"\>", "\[Rule]", "\<\"h2\"\>"}]}], "}"}], ",", 
          
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"bond\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"atom1\"\>", "\[Rule]", "\<\"c1\"\>"}], ",", 
            RowBox[{"\<\"atom2\"\>", "\[Rule]", "\<\"h3\"\>"}]}], "}"}], ",", 
          
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"bond\"\>", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\<\"atom1\"\>", "\[Rule]", "\<\"c1\"\>"}], ",", 
            RowBox[{"\<\"atom2\"\>", "\[Rule]", "\<\"h4\"\>"}]}], "}"}], ",", 
          
          RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{570, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->3429]
}, Open  ]],

Cell[TextData[{
 "The atom elements contain three attributes: ",
 StyleBox["type", "MR"],
 ", ",
 StyleBox["id", "MR"],
 ", and ",
 StyleBox["position", "MR"],
 ". The ",
 StyleBox["type", "MR"],
 " attribute references the key from previous atom definitions. The ",
 StyleBox["id", "MR"],
 " attribute is a unique key for this instance of the type of atom defined. \
In other words, the atom elements inside a molecule element represent a \
distinct atom of some previously defined type."
}], "Text",
 CellID->15885],

Cell[TextData[{
 "The ",
 StyleBox["molecule", "MR"],
 " element also contains ",
 StyleBox["bond", "MR"],
 " elements. These have two attributes: ",
 StyleBox["atom1", "MR"],
 " and ",
 StyleBox["atom2", "MR"],
 ". These reference the ",
 StyleBox["id", "MR"],
 " of the ",
 StyleBox["atom", "MR"],
 " elements in that molecule expression."
}], "Text",
 CellID->22002],

Cell[TextData[{
 "When we call ",
 StyleBox["ProcessDefinition", "MR"],
 " on a molecule definition, we will want to store a list of the atoms and \
bonds in ",
 StyleBox["moldef", "MR"],
 "."
}], "Text",
 CellID->27610],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProcessDefinition", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<DEFINE\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<name\>\"", "\[Rule]", "name_String"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<molecule\>\"", ",", 
         RowBox[{"{", "}"}], ",", "subdef_"}], "]"}], "}"}]}], "]"}], "]"}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"moldef", "[", "name", "]"}], "=", 
     RowBox[{"ProcessSubdef", "/@", "subdef"}]}], ")"}]}], ";"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->16327],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProcessSubdef", "[", "\[IndentingNewLine]", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<atom\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", 
        RowBox[{"\"\<id\>\"", "\[Rule]", "id_"}], ",", "pos___"}], "}"}], ",",
       
      RowBox[{"{", "}"}]}], "]"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"moldef", "[", "id", "]"}], "=", 
     RowBox[{"Append", "[", 
      RowBox[{
       RowBox[{"moldef", "[", "t", "]"}], ",", 
       RowBox[{"GetPos", "[", "pos", "]"}]}], "]"}]}], ")"}]}], 
  ";"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->14274],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProcessSubdef", "[", "\[IndentingNewLine]", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<bond\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<atom1\>\"", "\[Rule]", "a1_"}], ",", 
        RowBox[{"\"\<atom2\>\"", "\[Rule]", "a2_"}]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Bond", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"moldef", "[", "a1", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"moldef", "[", "a2", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->5760],

Cell[TextData[{
 "In the definition of ",
 StyleBox["ProcessDefinition", "MR"],
 ", ",
 StyleBox["subdef", "MR"],
 " is the list of atoms and bonds. We map ",
 StyleBox["ProcessSubdef", "MR"],
 " onto this list. By assigning to ",
 StyleBox["moldef[name]", "MR"],
 " a list of the result of ",
 StyleBox["ProcessSubdef", "MR"],
 " on each ",
 StyleBox["atom", "MR"],
 " and ",
 StyleBox["bond", "MR"],
 " element in the molecule. When ",
 StyleBox["ProcessSubdef", "MR"],
 " is called on an atom, it extracts that atom",
 "\[CloseCurlyQuote]",
 "s type from ",
 StyleBox["moldef", "MR"],
 ", appends the position to that expression, and stores the results under ",
 StyleBox["moldef[id]", "MR"],
 ". When ",
 StyleBox["ProcessSubdef", "MR"],
 " is called on a bond, it simply returns a ",
 StyleBox["Bond", "MR"],
 " expression containing the positions of the two atoms it references."
}], "Text",
 CellID->99],

Cell[TextData[{
 "We need an auxiliary function before we define ",
 StyleBox["GetRad", "MR"],
 ", ",
 StyleBox["GetColor", "MR"],
 ", and ",
 StyleBox["GetPos", "MR"],
 ". Since positions are written as space-separated lists of numbers in MoDL, \
we first write a function that turns this string into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list."
}], "Text",
 CellID->25042],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MolStringListToList", "[", "molpos_String", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"stream", "=", 
        RowBox[{"StringToStream", "[", "molpos", "]"}]}], ",", "thelist"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"thelist", "=", 
       RowBox[{"Read", "[", 
        RowBox[{"stream", ",", 
         RowBox[{"{", 
          RowBox[{"Number", ",", "Number", ",", "Number"}], "}"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "stream", "]"}], ";", "\[IndentingNewLine]", 
      "thelist"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->3055],

Cell[TextData[{
 "The functions ",
 StyleBox["GetPos", "MR"],
 ", ",
 StyleBox["GetRad", "MR"],
 ", and ",
 StyleBox["GetColor", "MR"],
 " should take in a sequence of attributes of any length and create a list \
from the position attribute. In symbolic XML, attributes are stored as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rules. Both ",
 StyleBox["GetPos", "MR"],
 " and ",
 StyleBox["GetColor", "MR"],
 " will need to use ",
 StyleBox["MolStringListToList", "MR"],
 ". ",
 StyleBox["GetRad", "MR"],
 " needs only to convert a string to a number."
}], "Text",
 CellID->24393],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetPos", "[", 
    RowBox[{"___", ",", 
     RowBox[{"\"\<position\>\"", "\[Rule]", "p_"}], ",", "___"}], "]"}], ":=",
    
   RowBox[{"MolStringListToList", "[", "p", "]"}]}], ";"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->31065],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetRad", "[", 
    RowBox[{"___", ",", 
     RowBox[{"\"\<radius\>\"", "\[Rule]", "r_"}], ",", "___"}], "]"}], ":=", 
   RowBox[{"ToExpression", "[", "r", "]"}]}], ";"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->4928],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetColor", "[", 
    RowBox[{"___", ",", 
     RowBox[{"\"\<color\>\"", "\[Rule]", "c_"}], ",", "___"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"RGBColor", "@@", 
    RowBox[{"MolStringListToList", "[", "c", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->24572],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetColor", "[", "___", "]"}], ":=", 
   RowBox[{"GrayLevel", "[", "1", "]"}]}], ";"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->29284],

Cell[TextData[{
 "Here is the definition of ",
 StyleBox["MoDLToGraphics3D", "MR"],
 " again for reference."
}], "Text",
 CellID->14726],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoDLToGraphics3D", "[", "modl_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"defs", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"modl", ",", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<DEFINE\>\"", ",", "___"}], "]"}], ",", "Infinity"}], 
        "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"body", "=", 
       RowBox[{"First", "[", 
        RowBox[{"Cases", "[", 
         RowBox[{"modl", ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<body\>\"", ",", "___"}], "]"}], ",", "Infinity"}], 
         "]"}], "]"}]}], ",", "\[IndentingNewLine]", "moldef", ",", "themols",
       ",", "theatoms"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ProcessDefinition", "/@", "defs"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"themols", "=", "\[IndentingNewLine]", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Cases", "[", 
        RowBox[{"body", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<molecule\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"___", ",", 
              RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", "___"}], "}"}], 
            ",", "__"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"moldef", "[", "t", "]"}]}], ",", "\[IndentingNewLine]", 
         "Infinity"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"theatoms", "=", 
      RowBox[{"Cases", "[", 
       RowBox[{"body", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<atom\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"___", ",", 
             RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", "___", ",", 
             RowBox[{"\"\<position\>\"", "\[Rule]", "p_"}], ",", "___"}], 
            "}"}], ",", "\[IndentingNewLine]", "__"}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"Append", "[", 
          RowBox[{
           RowBox[{"moldef", "[", "t", "]"}], ",", 
           RowBox[{"MolStringListToList", "[", "p", "]"}]}], "]"}]}], ",", 
        "Infinity"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"MolToGraphics", "/@", 
        RowBox[{"Join", "[", 
         RowBox[{"themols", ",", "theatoms"}], "]"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[52]:=",
 CellID->28798],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " scopes the variables ",
 StyleBox["defs", "MR"],
 ", ",
 StyleBox["body", "MR"],
 ", ",
 StyleBox["moldef", "MR"],
 ", ",
 StyleBox["themols", "MR"],
 ", and ",
 StyleBox["theatoms", "MR"],
 ". We already discussed ",
 StyleBox["moldef", "MR"],
 ", and ",
 StyleBox["defs", "MR"],
 " simply contains a list of the ",
 StyleBox["DEFINE", "MR"],
 " elements. The function ",
 StyleBox["body", "MR"],
 " just contains the body element of the symbolic XML expression."
}], "Text",
 CellID->20523],

Cell[TextData[{
 "After ",
 StyleBox["ProcessDefinition", "MR"],
 " is mapped to ",
 StyleBox["defs", "MR"],
 ", ",
 StyleBox["themols", "MR"],
 " is defined. Molecules in the body have a ",
 StyleBox["type",
  FontFamily->"Courier"],
 " attribute, which references the key of the molecule type defined in the \
head. The ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " statement then matches the molecules in the body and returns that \
molecule",
 "\[CloseCurlyQuote]",
 "s type definition in ",
 StyleBox["moldef", "MR"],
 "."
}], "Text",
 CellID->26201],

Cell[BoxData[
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"First", "[", 
    RowBox[{"Cases", "[", 
     RowBox[{"methane", ",", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<body\>\"", ",", "__"}], "]"}], ",", "Infinity"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->31587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "@", 
  RowBox[{"Cases", "[", 
   RowBox[{"body", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<molecule\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"___", ",", 
         RowBox[{"\"\<type\>\"", "\[Rule]", "t_"}], ",", "___"}], "}"}], ",", 
       "_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"moldef", "[", "t", "]"}]}], ",", "\[IndentingNewLine]", 
    "Infinity"}], "]"}]}]], "Input",
 CellLabel->"In[54]:=",
 CellID->4088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Atom", "[", 
    RowBox[{"0.3`", ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.4`"}], "}"}]}], "]"}], ",", 
   RowBox[{"Atom", "[", 
    RowBox[{"0.25`", ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.1`", ",", 
       RowBox[{"-", "0.4`"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Atom", "[", 
    RowBox[{"0.25`", ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.1`", ",", "0.3`"}], "}"}]}], "]"}], ",", 
   RowBox[{"Atom", "[", 
    RowBox[{"0.25`", ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.7`", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Atom", "[", 
    RowBox[{"0.25`", ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", 
       RowBox[{"-", "0.9`"}], ",", "0.8`"}], "}"}]}], "]"}], ",", 
   RowBox[{"Bond", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.1`", ",", 
       RowBox[{"-", "0.4`"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Bond", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.1`", ",", "0.3`"}], "}"}]}], "]"}], ",", 
   RowBox[{"Bond", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3`", ",", "0.7`", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Bond", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", 
       RowBox[{"-", "0.9`"}], ",", "0.8`"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{479, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->1997]
}, Open  ]],

Cell[TextData[{
 "In our example, we only have one molecule in the body. If more molecules \
existed, the lists of ",
 StyleBox["Atom", "MR"],
 " and ",
 StyleBox["Bond", "MR"],
 " expressions would be merged with ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression is simply made by drawing each ",
 StyleBox["Atom", "MR"],
 " and ",
 StyleBox["Bond", "MR"],
 ". Also, the body may contain other atoms as well. The definition of ",
 StyleBox["theatoms", "MR"],
 " simply matches these elements, reads their type from ",
 StyleBox["moldef", "MR"],
 ", and appends their positions. If more molecules existed, ",
 StyleBox["theatoms", "MR"],
 " would contain a list of more atoms to be drawn."
}], "Text",
 CellID->11652],

Cell[TextData[{
 "The last line of ",
 StyleBox["MoDLToGraphics3D", "MR"],
 " joins the ",
 StyleBox["Atom", "MR"],
 " and ",
 StyleBox["Bond", "MR"],
 " expressions in ",
 StyleBox["themols", "MR"],
 " with the ",
 StyleBox["Atom", "MR"],
 " expressions in ",
 StyleBox["theatoms", "MR"],
 ". It then maps ",
 StyleBox["MolToGraphics", "MR"],
 " onto this list. ",
 StyleBox["MolToGraphics", "MR"],
 " is simply a function that returns a sphere for ",
 StyleBox["Atom", "MR"],
 " expressions and a line for ",
 StyleBox["Bond", "MR"],
 " expressions. Of course, we also need to define ",
 StyleBox["MolToGraphics", "MR"],
 "."
}], "Text",
 CellID->19175],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MolToGraphics", "[", 
    RowBox[{"Bond", "[", "pts__", "]"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", "pts", "}"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->25750],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MolToGraphics", "[", 
    RowBox[{"Atom", "[", 
     RowBox[{"r_", ",", "col_", ",", "pos_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SurfaceColor", "[", "col", "]"}], ",", 
     RowBox[{"EdgeForm", "[", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"TranslateShape", "[", 
      RowBox[{
       RowBox[{"Sphere", "[", 
        RowBox[{"r", ",", "10", ",", "10"}], "]"}], ",", "pos"}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->10678],

Cell["\<\
The result is a 3D graphic of methane or any other molecule you have defined \
in MoDL.\
\>", "Text",
 CellID->11455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"MoDLToGraphics3D", "[", "methane", "]"}], "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->20893],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06145 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0462967 1.14699 5.68122e-17 1.14699 [
[ 0 0 0 0 ]
[ 1 1.06145 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06145 L
0 1.06145 L
closepath
clip
newpath
.37336 .66509 m .33207 .68456 L .33692 .6624 L .729 0 0 r
F
.37336 .66509 m .37499 .68768 L .33207 .68456 L F
.37022 .6428 m .37336 .66509 L .33692 .6624 L .725 0 0 r
F
.40468 .65531 m .37499 .68768 L .37336 .66509 L .607 0 0 r
F
.39296 .6356 m .37336 .66509 L .37022 .6428 L .629 0 0 r
F
.39296 .6356 m .40468 .65531 L .37336 .66509 L F
.37022 .6428 m .33692 .6624 L .34371 .64082 L .725 0 0 r
F
.36585 .62282 m .37022 .6428 L .34371 .64082 L .714 0 0 r
F
.37782 .61898 m .37022 .6428 L .36585 .62282 L .646 0 0 r
F
.37782 .61898 m .39296 .6356 L .37022 .6428 L F
.37499 .68768 m .32962 .70531 L .33207 .68456 L .727 0 0 r
F
.37499 .68768 m .37496 .70856 L .32962 .70531 L F
.41192 .67632 m .37496 .70856 L .37499 .68768 L .578 0 0 r
F
.40468 .65531 m .41192 .67632 L .37499 .68768 L .607 0 0 r
F
.33692 .6624 m .29858 .66801 L .30857 .64817 L .833 0 0 r
F
.33692 .6624 m .33207 .68456 L .29858 .66801 L F
.34371 .64082 m .33692 .6624 L .30857 .64817 L .806 0 0 r
F
.34371 .64082 m .30857 .64817 L .32319 .63036 L F
.35186 .62176 m .34371 .64082 L .32319 .63036 L .769 0 0 r
F
.36585 .62282 m .34371 .64082 L .35186 .62176 L .714 0 0 r
F
.33207 .68456 m .2942 .68804 L .29858 .66801 L .853 0 0 r
F
.33207 .68456 m .32962 .70531 L .2942 .68804 L F
.37999 .60361 m .36585 .62282 L .35186 .62176 L .66 0 0 r
F
.37999 .60361 m .37782 .61898 L .36585 .62282 L F
.40343 .6218 m .40468 .65531 L .39296 .6356 L .476 0 0 r
F
.38324 .61166 m .39296 .6356 L .37782 .61898 L .554 0 0 r
F
.38324 .61166 m .40343 .6218 L .39296 .6356 L F
.41928 .63648 m .41192 .67632 L .40468 .65531 L .376 0 0 r
F
.40343 .6218 m .41928 .63648 L .40468 .65531 L .476 0 0 r
F
.37496 .70856 m .32982 .72273 L .32962 .70531 L .717 0 0 r
F
.37496 .70856 m .37325 .72581 L .32982 .72273 L F
.41398 .69672 m .37325 .72581 L .37496 .70856 L .53 0 0 r
F
.41192 .67632 m .41398 .69672 L .37496 .70856 L .578 0 0 r
F
.37999 .60361 m .35186 .62176 L .34108 .61619 L .66 0 0 r
F
.35186 .62176 m .32319 .63036 L .34108 .61619 L .769 0 0 r
F
.37999 .60361 m .38324 .61166 L .37782 .61898 L .66 0 0 r
F
.32962 .70531 m .29592 .70638 L .2942 .68804 L .864 0 0 r
F
.32962 .70531 m .32982 .72273 L .29592 .70638 L F
.42926 .65436 m .41398 .69672 L .41192 .67632 L .229 0 0 r
F
.41928 .63648 m .42926 .65436 L .41192 .67632 L .376 0 0 r
F
.32319 .63036 m .29906 .62744 L .31645 .61521 L .878 0 0 r
F
.32319 .63036 m .30857 .64817 L .29906 .62744 L F
.34108 .61619 m .32319 .63036 L .31645 .61521 L .803 0 0 r
F
.37999 .60361 m .34108 .61619 L .33764 .60819 L .66 0 0 r
F
.34108 .61619 m .31645 .61521 L .33764 .60819 L .803 0 0 r
F
.30857 .64817 m .28718 .64379 L .29906 .62744 L .946 0 0 r
F
.30857 .64817 m .29858 .66801 L .28718 .64379 L F
.37999 .60361 m .40343 .6218 L .38324 .61166 L .42 0 0 r
F
.37325 .72581 m .33272 .73513 L .32982 .72273 L .682 0 0 r
F
.37325 .72581 m .36997 .73776 L .33272 .73513 L F
.41059 .71459 m .36997 .73776 L .37325 .72581 L .426 0 0 r
F
.41398 .69672 m .41059 .71459 L .37325 .72581 L .53 0 0 r
F
.43234 .67378 m .41059 .71459 L .41398 .69672 L 0 0 0 r
F
.42926 .65436 m .43234 .67378 L .41398 .69672 L .229 0 0 r
F
.29858 .66801 m .28207 .66274 L .28718 .64379 L .995 0 0 r
F
.29858 .66801 m .2942 .68804 L .28207 .66274 L F
.39738 .60649 m .41928 .63648 L .40343 .6218 L .108 0 0 r
F
.37999 .60361 m .39738 .60649 L .40343 .6218 L .42 0 0 r
F
.37999 .60361 m .33764 .60819 L .34292 .60078 L .66 0 0 r
F
.33764 .60819 m .3264 .60106 L .34292 .60078 L .766 0 0 r
F
.33764 .60819 m .31645 .61521 L .3264 .60106 L F
.32982 .72273 m .3037 .72124 L .29592 .70638 L .84 0 0 r
F
.32982 .72273 m .33272 .73513 L .3037 .72124 L F
.37999 .60361 m .355 .59684 L .36919 .59793 L .66 0 0 r
F
.37999 .60361 m .34292 .60078 L .355 .59684 L F
.36919 .59793 m .39738 .60649 L .37999 .60361 L .255 0 0 r
F
.4111 .61544 m .42926 .65436 L .41928 .63648 L 0 0 0 r
F
.39738 .60649 m .4111 .61544 L .41928 .63648 L .108 0 0 r
F
.31645 .61521 m .31266 .60795 L .3264 .60106 L .796 0 0 r
F
.31645 .61521 m .29906 .62744 L .31266 .60795 L F
.34292 .60078 m .34952 .5935 L .355 .59684 L .542 0 0 r
F
.34292 .60078 m .3264 .60106 L .34952 .5935 L F
.2942 .68804 m .28435 .68246 L .28207 .66274 L .954 0 0 r
F
.2942 .68804 m .29592 .70638 L .28435 .68246 L F
.41059 .71459 m .40197 .72821 L .36997 .73776 L .426 0 0 r
F
.42811 .6929 m .40197 .72821 L .41059 .71459 L 0 0 0 r
F
.43234 .67378 m .42811 .6929 L .41059 .71459 L F
.76272 .37327 m .72199 .39208 L .72617 .37003 L .73 0 0 r
F
.76272 .37327 m .76502 .39584 L .72199 .39208 L F
.76006 .3501 m .76272 .37327 L .72617 .37003 L .725 0 0 r
F
.79707 .3615 m .76502 .39584 L .76272 .37327 L .612 0 0 r
F
.785 .34146 m .76272 .37327 L .76006 .3501 L .634 0 0 r
F
.785 .34146 m .79707 .3615 L .76272 .37327 L F
.36919 .59793 m .37678 .59559 L .39738 .60649 L .255 0 0 r
F
.355 .59684 m .37678 .59559 L .36919 .59793 L .261 0 0 r
F
.355 .59684 m .34952 .5935 L .37678 .59559 L F
.36997 .73776 m .33808 .7412 L .33272 .73513 L .526 0 0 r
F
.36997 .73776 m .36541 .74312 L .33808 .7412 L F
.40197 .72821 m .36541 .74312 L .36997 .73776 L .12 0 0 r
F
.76006 .3501 m .72617 .37003 L .73348 .34772 L .725 0 0 r
F
.7573 .32843 m .76006 .3501 L .73348 .34772 L .714 0 0 r
F
.77044 .32382 m .76006 .3501 L .7573 .32843 L .652 0 0 r
F
.77044 .32382 m .785 .34146 L .76006 .3501 L F
.76502 .39584 m .72132 .41189 L .72199 .39208 L .729 0 0 r
F
.76502 .39584 m .76678 .41582 L .72132 .41189 L F
.80554 .38214 m .76678 .41582 L .76502 .39584 L .58 0 0 r
F
.79707 .3615 m .80554 .38214 L .76502 .39584 L .612 0 0 r
F
.72617 .37003 m .69189 .37211 L .7007 .35291 L .85 0 0 r
F
.72617 .37003 m .72199 .39208 L .69189 .37211 L F
.73348 .34772 m .72617 .37003 L .7007 .35291 L .813 0 0 r
F
.4111 .61544 m .41973 .62973 L .42926 .65436 L 0 0 0 r
F
.41973 .62973 m .43234 .67378 L .42926 .65436 L .895 0 0 r
F
.29906 .62744 m .30314 .62093 L .31266 .60795 L .6 0 0 r
F
.29906 .62744 m .28718 .64379 L .30314 .62093 L F
.73348 .34772 m .7007 .35291 L .71505 .33516 L .813 0 0 r
F
.74327 .32716 m .73348 .34772 L .71505 .33516 L .769 0 0 r
F
.7573 .32843 m .73348 .34772 L .74327 .32716 L .714 0 0 r
F
.37678 .59559 m .4111 .61544 L .39738 .60649 L .486 0 0 r
F
.33272 .73513 m .31689 .73108 L .3037 .72124 L .601 0 0 r
F
.33272 .73513 m .33808 .7412 L .31689 .73108 L F
.72199 .39208 m .6895 .391 L .69189 .37211 L .882 0 0 r
F
.72199 .39208 m .72132 .41189 L .6895 .391 L F
.29592 .70638 m .29391 .70098 L .28435 .68246 L 0 0 0 r
F
.29592 .70638 m .3037 .72124 L .29391 .70098 L F
.77633 .30537 m .7573 .32843 L .74327 .32716 L .671 0 0 r
F
.77633 .30537 m .77044 .32382 L .7573 .32843 L F
.79902 .32487 m .79707 .3615 L .785 .34146 L .521 0 0 r
F
.77773 .31503 m .785 .34146 L .77044 .32382 L .582 0 0 r
F
.77773 .31503 m .79902 .32487 L .785 .34146 L F
.3264 .60106 m .34471 .59748 L .34952 .5935 L 0 0 0 r
F
.3264 .60106 m .31266 .60795 L .34471 .59748 L F
.81657 .33882 m .80554 .38214 L .79707 .3615 L .446 0 0 r
F
.79902 .32487 m .81657 .33882 L .79707 .3615 L .521 0 0 r
F
.76678 .41582 m .72428 .42761 L .72132 .41189 L .714 0 0 r
F
.76678 .41582 m .76781 .43135 L .72428 .42761 L F
.8096 .40149 m .76781 .43135 L .76678 .41582 L .525 0 0 r
F
.80554 .38214 m .8096 .40149 L .76678 .41582 L .58 0 0 r
F
.77633 .30537 m .74327 .32716 L .73361 .32048 L .671 0 0 r
F
.74327 .32716 m .71505 .33516 L .73361 .32048 L .769 0 0 r
F
.4223 .64802 m .42811 .6929 L .43234 .67378 L 1 0 0 r
F
.41973 .62973 m .4223 .64802 L .43234 .67378 L .895 0 0 r
F
.40197 .72821 m .38883 .73615 L .36541 .74312 L .12 0 0 r
F
.42811 .6929 m .41685 .70981 L .40197 .72821 L 0 0 0 r
F
.41685 .70981 m .38883 .73615 L .40197 .72821 L .739 0 0 r
F
.77633 .30537 m .77773 .31503 L .77044 .32382 L .671 0 0 r
F
.28718 .64379 m .29889 .63881 L .30314 .62093 L 0 0 0 r
F
.28718 .64379 m .28207 .66274 L .29889 .63881 L F
.72132 .41189 m .69385 .40778 L .6895 .391 L .892 0 0 r
F
.72132 .41189 m .72428 .42761 L .69385 .40778 L F
.82869 .35564 m .8096 .40149 L .80554 .38214 L .337 0 0 r
F
.81657 .33882 m .82869 .35564 L .80554 .38214 L .446 0 0 r
F
.71505 .33516 m .69603 .32794 L .71181 .31694 L .89 0 0 r
F
.71505 .33516 m .7007 .35291 L .69603 .32794 L F
.73361 .32048 m .71505 .33516 L .71181 .31694 L .803 0 0 r
F
.37678 .59559 m .38259 .60038 L .4111 .61544 L .486 0 0 r
F
.34952 .5935 m .38259 .60038 L .37678 .59559 L .455 0 0 r
F
.38259 .60038 m .41973 .62973 L .4111 .61544 L .833 0 0 r
F
.77633 .30537 m .73361 .32048 L .732 .31086 L .671 0 0 r
F
.73361 .32048 m .71181 .31694 L .732 .31086 L .803 0 0 r
F
.34952 .5935 m .34471 .59748 L .38259 .60038 L .455 0 0 r
F
.7007 .35291 m .68623 .34288 L .69603 .32794 L .972 0 0 r
F
.7007 .35291 m .69189 .37211 L .68623 .34288 L F
.36541 .74312 m .34547 .74017 L .33808 .7412 L .125 0 0 r
F
.36541 .74312 m .35998 .74119 L .34547 .74017 L F
.38883 .73615 m .35998 .74119 L .36541 .74312 L .453 0 0 r
F
.3037 .72124 m .30988 .7164 L .29391 .70098 L 0 0 0 r
F
.3037 .72124 m .31689 .73108 L .30988 .7164 L F
.33808 .7412 m .33429 .73481 L .31689 .73108 L .142 0 0 r
F
.33808 .7412 m .34547 .74017 L .33429 .73481 L F
.77633 .30537 m .79902 .32487 L .77773 .31503 L .506 0 0 r
F
.76781 .43135 m .73066 .43771 L .72428 .42761 L .649 0 0 r
F
.76781 .43135 m .76802 .4409 L .73066 .43771 L F
.80883 .41774 m .76802 .4409 L .76781 .43135 L .396 0 0 r
F
.8096 .40149 m .80883 .41774 L .76781 .43135 L .525 0 0 r
F
.41845 .66856 m .41685 .70981 L .42811 .6929 L .959 0 0 r
F
.4223 .64802 m .41845 .66856 L .42811 .6929 L 1 0 0 r
F
.83415 .37375 m .80883 .41774 L .8096 .40149 L .141 0 0 r
F
.82869 .35564 m .83415 .37375 L .8096 .40149 L .337 0 0 r
F
.69189 .37211 m .68348 .36037 L .68623 .34288 L .971 0 0 r
F
.69189 .37211 m .6895 .391 L .68348 .36037 L F
.31266 .60795 m .34109 .6086 L .34471 .59748 L .376 0 0 r
F
.31266 .60795 m .30314 .62093 L .34109 .6086 L F
.28207 .66274 m .30046 .65986 L .29889 .63881 L .156 0 0 r
F
.28207 .66274 m .28435 .68246 L .30046 .65986 L F
.79655 .30645 m .81657 .33882 L .79902 .32487 L .339 0 0 r
F
.77633 .30537 m .79655 .30645 L .79902 .32487 L .506 0 0 r
F
.77633 .30537 m .732 .31086 L .73917 .30196 L .671 0 0 r
F
.732 .31086 m .72538 .29993 L .73917 .30196 L .77 0 0 r
F
.732 .31086 m .71181 .31694 L .72538 .29993 L F
.72428 .42761 m .70465 .42081 L .69385 .40778 L .762 0 0 r
F
.72428 .42761 m .73066 .43771 L .70465 .42081 L F
.38883 .73615 m .37237 .73749 L .35998 .74119 L .453 0 0 r
F
.39958 .72278 m .37237 .73749 L .38883 .73615 L .753 0 0 r
F
.41685 .70981 m .39958 .72278 L .38883 .73615 L .739 0 0 r
F
.38602 .61202 m .4223 .64802 L .41973 .62973 L .873 0 0 r
F
.38259 .60038 m .38602 .61202 L .41973 .62973 L .833 0 0 r
F
.77633 .30537 m .75244 .29723 L .76667 .29854 L .671 0 0 r
F
.77633 .30537 m .73917 .30196 L .75244 .29723 L F
.76667 .29854 m .79655 .30645 L .77633 .30537 L .439 0 0 r
F
.81337 .31348 m .82869 .35564 L .81657 .33882 L .056 0 0 r
F
.79655 .30645 m .81337 .31348 L .81657 .33882 L .339 0 0 r
F
.71181 .31694 m .71467 .30446 L .72538 .29993 L .781 0 0 r
F
.71181 .31694 m .69603 .32794 L .71467 .30446 L F
.34471 .59748 m .38602 .61202 L .38259 .60038 L .671 0 0 r
F
.31689 .73108 m .33068 .7271 L .30988 .7164 L .369 0 0 r
F
.31689 .73108 m .33429 .73481 L .33068 .7271 L F
.73917 .30196 m .7508 .29083 L .75244 .29723 L .614 0 0 r
F
.73917 .30196 m .72538 .29993 L .7508 .29083 L F
.40846 .68925 m .39958 .72278 L .41685 .70981 L .889 0 0 r
F
.41845 .66856 m .40846 .68925 L .41685 .70981 L .959 0 0 r
F
.6895 .391 m .68815 .37874 L .68348 .36037 L 0 0 0 r
F
.6895 .391 m .69385 .40778 L .68815 .37874 L F
.28435 .68246 m .30776 .68193 L .30046 .65986 L .334 0 0 r
F
.28435 .68246 m .29391 .70098 L .30776 .68193 L F
.34471 .59748 m .34109 .6086 L .38602 .61202 L .671 0 0 r
F
.80883 .41774 m .80318 .42929 L .76802 .4409 L .396 0 0 r
F
.83231 .39142 m .80318 .42929 L .80883 .41774 L 0 0 0 r
F
.83415 .37375 m .83231 .39142 L .80883 .41774 L .141 0 0 r
F
.76667 .29854 m .77814 .29335 L .79655 .30645 L .439 0 0 r
F
.75244 .29723 m .77814 .29335 L .76667 .29854 L .455 0 0 r
F
.36336 .71721 m .35998 .74119 L .37237 .73749 L .65 0 0 r
F
.36336 .71721 m .34547 .74017 L .35998 .74119 L F
.75244 .29723 m .7508 .29083 L .77814 .29335 L .455 0 0 r
F
.36336 .71721 m .33429 .73481 L .34547 .74017 L .65 0 0 r
F
.30314 .62093 m .33905 .62589 L .34109 .6086 L .509 0 0 r
F
.30314 .62093 m .29889 .63881 L .33905 .62589 L F
.76802 .4409 m .73995 .44106 L .73066 .43771 L .318 0 0 r
F
.76802 .4409 m .76735 .4434 L .73995 .44106 L F
.80318 .42929 m .76735 .4434 L .76802 .4409 L 0 0 0 r
F
.82509 .32589 m .83415 .37375 L .82869 .35564 L F
.81337 .31348 m .82509 .32589 L .82869 .35564 L .056 0 0 r
F
.38663 .62948 m .41845 .66856 L .4223 .64802 L .862 0 0 r
F
0 g
.01 w
[ ] 0 setdash
.41537 .65137 m
.41926 .65023 L
s
.35746 .66828 m
.40655 .65394 L
s
.41926 .65023 m
.42135 .64962 L
s
.38602 .61202 m .38663 .62948 L .4223 .64802 L .873 0 0 r
F
0 g
.42135 .64962 m
.4312 .64674 L
s
.69603 .32794 m .70819 .31526 L .71467 .30446 L 0 0 0 r
F
.69603 .32794 m .68623 .34288 L .70819 .31526 L F
.36336 .71721 m .37237 .73749 L .37797 .73044 L .65 0 0 r
F
.39958 .72278 m .37797 .73044 L .37237 .73749 L .753 0 0 r
F
.77814 .29335 m .81337 .31348 L .79655 .30645 L 0 0 0 r
F
.73066 .43771 m .72098 .42872 L .70465 .42081 L F
.73066 .43771 m .73995 .44106 L .72098 .42872 L F
.39331 .70795 m .37797 .73044 L .39958 .72278 L .807 0 0 r
F
.40846 .68925 m .39331 .70795 L .39958 .72278 L .889 0 0 r
F
.29391 .70098 m .32009 .70269 L .30776 .68193 L .449 0 0 r
F
.29391 .70098 m .30988 .7164 L .32009 .70269 L F
.36336 .71721 m .33068 .7271 L .33429 .73481 L .65 0 0 r
F
.69385 .40778 m .69992 .39616 L .68815 .37874 L 0 0 0 r
F
.69385 .40778 m .70465 .42081 L .69992 .39616 L F
.72538 .29993 m .74996 .29183 L .7508 .29083 L F
.72538 .29993 m .71467 .30446 L .74996 .29183 L F
.34109 .6086 m .38663 .62948 L .38602 .61202 L .716 0 0 r
F
.36336 .71721 m .37797 .73044 L .37457 .72269 L .65 0 0 r
F
.39331 .70795 m .37457 .72269 L .37797 .73044 L .807 0 0 r
F
.30988 .7164 m .33613 .71995 L .32009 .70269 L .537 0 0 r
F
.30988 .7164 m .33068 .7271 L .33613 .71995 L F
.82509 .32589 m .83042 .34256 L .83415 .37375 L 0 0 0 r
F
.83042 .34256 m .83231 .39142 L .83415 .37375 L .914 0 0 r
F
.80318 .42929 m .79311 .43491 L .76735 .4434 L 0 0 0 r
F
.83231 .39142 m .82321 .4069 L .80318 .42929 L F
.82321 .4069 m .79311 .43491 L .80318 .42929 L .713 0 0 r
F
.38432 .65106 m .40846 .68925 L .41845 .66856 L .841 0 0 r
F
.38663 .62948 m .38432 .65106 L .41845 .66856 L .862 0 0 r
F
.29889 .63881 m .33884 .64768 L .33905 .62589 L .567 0 0 r
F
.29889 .63881 m .30046 .65986 L .33884 .64768 L F
.68623 .34288 m .70668 .3314 L .70819 .31526 L .047 0 0 r
F
.68623 .34288 m .68348 .36037 L .70668 .3314 L F
.34109 .6086 m .33905 .62589 L .38663 .62948 L .716 0 0 r
F
.36336 .71721 m .33613 .71995 L .33068 .7271 L .65 0 0 r
F
.77814 .29335 m .78794 .29534 L .81337 .31348 L 0 0 0 r
F
.7508 .29083 m .78794 .29534 L .77814 .29335 L .179 0 0 r
F
.78794 .29534 m .82509 .32589 L .81337 .31348 L .687 0 0 r
F
.7508 .29083 m .74996 .29183 L .78794 .29534 L .179 0 0 r
F
0 g
.67092 .50407 m
.7144 .43651 L
s
.37927 .67452 m .39331 .70795 L .40846 .68925 L .812 0 0 r
F
.38432 .65106 m .37927 .67452 L .40846 .68925 L .841 0 0 r
F
.76735 .4434 m .75131 .43716 L .73995 .44106 L .379 0 0 r
F
.76735 .4434 m .76585 .4384 L .75131 .43716 L F
.79311 .43491 m .76585 .4384 L .76735 .4434 L .56 0 0 r
F
.37203 .69738 m .37457 .72269 L .39331 .70795 L .772 0 0 r
F
.37203 .69738 m .36336 .71721 L .37457 .72269 L F
.70465 .42081 m .71769 .41082 L .69992 .39616 L .284 0 0 r
F
.70465 .42081 m .72098 .42872 L .71769 .41082 L F
.73995 .44106 m .74131 .43062 L .72098 .42872 L .385 0 0 r
F
.73995 .44106 m .75131 .43716 L .74131 .43062 L F
.37927 .67452 m .37203 .69738 L .39331 .70795 L .812 0 0 r
F
.30046 .65986 m .34052 .67168 L .33884 .64768 L .6 0 0 r
F
.30046 .65986 m .30776 .68193 L .34052 .67168 L F
.33905 .62589 m .38432 .65106 L .38663 .62948 L .728 0 0 r
F
.82871 .36187 m .82321 .4069 L .83231 .39142 L .98 0 0 r
F
.83042 .34256 m .82871 .36187 L .83231 .39142 L .914 0 0 r
F
.36336 .71721 m .34863 .71616 L .33613 .71995 L .65 0 0 r
F
.32009 .70269 m .33613 .71995 L .34863 .71616 L .64 0 0 r
F
.71467 .30446 m .75 .30037 L .74996 .29183 L .337 0 0 r
F
.71467 .30446 m .70819 .31526 L .75 .30037 L F
.68348 .36037 m .7104 .35131 L .70668 .3314 L .291 0 0 r
F
.68348 .36037 m .68815 .37874 L .7104 .35131 L F
.3439 .69535 m .36336 .71721 L .37203 .69738 L .714 0 0 r
F
.3439 .69535 m .34863 .71616 L .36336 .71721 L F
.33905 .62589 m .33884 .64768 L .38432 .65106 L .728 0 0 r
F
.30776 .68193 m .3439 .69535 L .34052 .67168 L .623 0 0 r
F
.30776 .68193 m .32009 .70269 L .3439 .69535 L F
.79311 .43491 m .7795 .43389 L .76585 .4384 L .56 0 0 r
F
.80764 .41861 m .7795 .43389 L .79311 .43491 L .759 0 0 r
F
.82321 .4069 m .80764 .41861 L .79311 .43491 L .713 0 0 r
F
.32009 .70269 m .34863 .71616 L .3439 .69535 L .64 0 0 r
F
.79505 .3045 m .83042 .34256 L .82509 .32589 L .897 0 0 r
F
.78794 .29534 m .79505 .3045 L .82509 .32589 L .687 0 0 r
F
.62358 .5924 m .57207 .6169 L .57767 .58882 L .73 .567 0 r
F
0 g
.4312 .64674 m
.49617 .62776 L
s
.62358 .5924 m .62617 .62104 L .57207 .6169 L .73 .567 0 r
F
.62002 .56388 m .62358 .5924 L .57767 .58882 L .726 .615 0 r
F
.66544 .57938 m .62617 .62104 L .62358 .5924 L .606 .474 0 r
F
.65041 .55426 m .62358 .5924 L .62002 .56388 L .628 .544 0 r
F
.65041 .55426 m .66544 .57938 L .62358 .5924 L F
.33884 .64768 m .37927 .67452 L .38432 .65106 L .73 0 0 r
F
.74996 .29183 m .79505 .3045 L .78794 .29534 L .625 0 0 r
F
.72098 .42872 m .73968 .4212 L .71769 .41082 L .479 0 0 r
F
0 g
.7144 .43651 m
.72028 .42737 L
s
.72784 .41561 m
.75907 .36708 L
s
.72098 .42872 m .74131 .43062 L .73968 .4212 L .479 0 0 r
F
0 g
.72028 .42737 m
.72219 .42439 L
s
.72219 .42439 m
.72268 .42364 L
s
.34052 .67168 m .37203 .69738 L .37927 .67452 L .726 0 0 r
F
.34052 .67168 m .3439 .69535 L .37203 .69738 L F
.82002 .38188 m .80764 .41861 L .82321 .4069 L .901 0 0 r
F
.82871 .36187 m .82002 .38188 L .82321 .4069 L .98 0 0 r
F
.62002 .56388 m .57767 .58882 L .58662 .56123 L .726 .615 0 r
F
.6158 .53796 m .62002 .56388 L .58662 .56123 L .714 .663 0 r
F
.63181 .53281 m .62002 .56388 L .6158 .53796 L .645 .614 0 r
F
.63181 .53281 m .65041 .55426 L .62002 .56388 L F
.62617 .62104 m .57036 .64298 L .57207 .6169 L .728 .509 0 r
F
0 g
.49617 .62776 m
.5023 .62597 L
s
.62617 .62104 m .62757 .64729 L .57036 .64298 L .728 .509 0 r
F
.67558 .60594 m .62757 .64729 L .62617 .62104 L .576 .392 0 r
F
.66544 .57938 m .67558 .60594 L .62617 .62104 L .606 .474 0 r
F
.57767 .58882 m .53242 .59485 L .54414 .56984 L .848 .686 0 r
F
.57767 .58882 m .57207 .6169 L .53242 .59485 L F
.58662 .56123 m .57767 .58882 L .54414 .56984 L .816 .715 0 r
F
.68815 .37874 m .71905 .37296 L .7104 .35131 L .42 0 0 r
F
.68815 .37874 m .69992 .39616 L .71905 .37296 L F
.33884 .64768 m .34052 .67168 L .37927 .67452 L .73 0 0 r
F
.74996 .29183 m .75 .30037 L .79505 .3045 L .625 0 0 r
F
.80695 .82945 m .76464 .85081 L .76892 .82688 L .73 0 0 r
F
.80695 .82945 m .80944 .85379 L .76464 .85081 L F
.80425 .80597 m .80695 .82945 L .76892 .82688 L .726 0 0 r
F
.84308 .82009 m .80944 .85379 L .80695 .82945 L .611 0 0 r
F
.83048 .79906 m .80695 .82945 L .80425 .80597 L .628 0 0 r
F
.83048 .79906 m .84308 .82009 L .80695 .82945 L F
.77571 .40912 m .76585 .4384 L .7795 .43389 L .664 0 0 r
F
.77571 .40912 m .75131 .43716 L .76585 .4384 L F
.58662 .56123 m .54414 .56984 L .56238 .54724 L .816 .715 0 r
F
.59815 .53654 m .58662 .56123 L .56238 .54724 L .772 .735 0 r
F
.6158 .53796 m .58662 .56123 L .59815 .53654 L .714 .663 0 r
F
.77571 .40912 m .74131 .43062 L .75131 .43716 L .664 0 0 r
F
.70819 .31526 m .75096 .31575 L .75 .30037 L .504 0 0 r
F
.70819 .31526 m .70668 .3314 L .75096 .31575 L F
.80425 .80597 m .76892 .82688 L .77658 .80407 L .726 0 0 r
F
.80157 .78543 m .80425 .80597 L .77658 .80407 L .714 0 0 r
F
.81538 .78174 m .80425 .80597 L .80157 .78543 L .642 0 0 r
F
.81538 .78174 m .83048 .79906 L .80425 .80597 L F
.57207 .6169 m .52836 .62001 L .53242 .59485 L .873 .64 0 r
F
.57207 .6169 m .57036 .64298 L .52836 .62001 L F
.80944 .85379 m .76415 .87372 L .76464 .85081 L .728 0 0 r
F
.80944 .85379 m .81148 .87682 L .76415 .87372 L F
.85204 .84294 m .81148 .87682 L .80944 .85379 L .588 0 0 r
F
.84308 .82009 m .85204 .84294 L .80944 .85379 L .611 0 0 r
F
.76892 .82688 m .73369 .83499 L .74273 .81325 L .856 0 0 r
F
.76892 .82688 m .76464 .85081 L .73369 .83499 L F
.77658 .80407 m .76892 .82688 L .74273 .81325 L .824 0 0 r
F
.79867 .32009 m .82871 .36187 L .83042 .34256 L .894 0 0 r
F
.79505 .3045 m .79867 .32009 L .83042 .34256 L .897 0 0 r
F
.77571 .40912 m .7795 .43389 L .7871 .42529 L .664 0 0 r
F
.80764 .41861 m .7871 .42529 L .7795 .43389 L .759 0 0 r
F
.77658 .80407 m .74273 .81325 L .75764 .79403 L .824 0 0 r
F
.78697 .78441 m .77658 .80407 L .75764 .79403 L .777 0 0 r
F
.80157 .78543 m .77658 .80407 L .78697 .78441 L .714 0 0 r
F
.80517 .40051 m .7871 .42529 L .80764 .41861 L .808 0 0 r
F
.82002 .38188 m .80517 .40051 L .80764 .41861 L .901 0 0 r
F
.76464 .85081 m .73143 .85727 L .73369 .83499 L .878 0 0 r
F
.76464 .85081 m .76415 .87372 L .73143 .85727 L F
.69992 .39616 m .73174 .3941 L .71905 .37296 L .504 0 0 r
F
.69992 .39616 m .71769 .41082 L .73174 .3941 L F
.63757 .51214 m .6158 .53796 L .59815 .53654 L .659 .747 0 r
F
0 g
.6669 .51031 m
.67092 .50407 L
s
.63757 .51214 m .63181 .53281 L .6158 .53796 L .659 .747 0 r
F
.66653 .53575 m .66544 .57938 L .65041 .55426 L .492 .486 0 r
F
0 g
.66605 .51162 m
.6669 .51031 L
s
.64016 .52298 m .65041 .55426 L .63181 .53281 L .561 .591 0 r
F
.64016 .52298 m .66653 .53575 L .65041 .55426 L F
.77571 .40912 m .73968 .4212 L .74131 .43062 L .664 0 0 r
F
.68795 .55416 m .67558 .60594 L .66544 .57938 L .409 .365 0 r
F
.66653 .53575 m .68795 .55416 L .66544 .57938 L .492 .486 0 r
F
.62757 .64729 m .57273 .66471 L .57036 .64298 L .715 .428 0 r
F
.62757 .64729 m .62762 .6688 L .57273 .66471 L F
.67986 .63157 m .62762 .6688 L .62757 .64729 L .528 .278 0 r
F
.67558 .60594 m .67986 .63157 L .62757 .64729 L .576 .392 0 r
F
.63757 .51214 m .59815 .53654 L .58545 .52907 L .659 .747 0 r
F
.59815 .53654 m .56238 .54724 L .58545 .52907 L .772 .735 0 r
F
.82198 .76696 m .80157 .78543 L .78697 .78441 L .645 0 0 r
F
.82198 .76696 m .81538 .78174 L .80157 .78543 L F
.84551 .7858 m .84308 .82009 L .83048 .79906 L .495 0 0 r
F
.8232 .7747 m .83048 .79906 L .81538 .78174 L .554 0 0 r
F
.8232 .7747 m .84551 .7858 L .83048 .79906 L F
.864 .80204 m .85204 .84294 L .84308 .82009 L .431 0 0 r
F
.84551 .7858 m .864 .80204 L .84308 .82009 L .495 0 0 r
F
.81148 .87682 m .76755 .89352 L .76415 .87372 L .717 0 0 r
F
.81148 .87682 m .81289 .89644 L .76755 .89352 L F
.85653 .86554 m .81289 .89644 L .81148 .87682 L .554 0 0 r
F
.85204 .84294 m .85653 .86554 L .81148 .87682 L .588 0 0 r
F
.75 .30037 m .79867 .32009 L .79505 .3045 L .711 0 0 r
F
.82198 .76696 m .78697 .78441 L .77704 .77906 L .645 0 0 r
F
.78697 .78441 m .75764 .79403 L .77704 .77906 L .777 0 0 r
F
.63757 .51214 m .64016 .52298 L .63181 .53281 L .659 .747 0 r
F
.77571 .40912 m .7871 .42529 L .7857 .41581 L .664 0 0 r
F
.80517 .40051 m .7857 .41581 L .7871 .42529 L .808 0 0 r
F
.57036 .64298 m .53249 .64297 L .52836 .62001 L .881 .555 0 r
F
.57036 .64298 m .57273 .66471 L .53249 .64297 L F
.71769 .41082 m .74716 .41247 L .73174 .3941 L .571 0 0 r
F
.71769 .41082 m .73968 .4212 L .74716 .41247 L F
.79835 .34061 m .82002 .38188 L .82871 .36187 L .861 0 0 r
F
.79867 .32009 m .79835 .34061 L .82871 .36187 L .894 0 0 r
F
.70238 .57657 m .67986 .63157 L .67558 .60594 L .294 .2 0 r
F
.68795 .55416 m .70238 .57657 L .67558 .60594 L .409 .365 0 r
F
.70668 .3314 m .75275 .3365 L .75096 .31575 L .569 0 0 r
F
.70668 .3314 m .7104 .35131 L .75275 .3365 L F
.56238 .54724 m .53575 .542 L .55653 .52688 L .893 .871 0 r
F
.56238 .54724 m .54414 .56984 L .53575 .542 L F
.58545 .52907 m .56238 .54724 L .55653 .52688 L .807 .834 0 r
F
.82198 .76696 m .8232 .7747 L .81538 .78174 L .645 0 0 r
F
.75 .30037 m .75096 .31575 L .79867 .32009 L .711 0 0 r
F
.76415 .87372 m .73626 .87798 L .73143 .85727 L .882 0 0 r
F
.76415 .87372 m .76755 .89352 L .73626 .87798 L F
.87689 .82194 m .85653 .86554 L .85204 .84294 L .35 0 0 r
F
.864 .80204 m .87689 .82194 L .85204 .84294 L .431 0 0 r
F
.63757 .51214 m .58545 .52907 L .58253 .51831 L .659 .747 0 r
F
.58545 .52907 m .55653 .52688 L .58253 .51831 L .807 .834 0 r
F
.77571 .40912 m .74716 .41247 L .73968 .4212 L .664 0 0 r
F
.75764 .79403 m .73842 .79336 L .75467 .77947 L .911 0 0 r
F
.75764 .79403 m .74273 .81325 L .73842 .79336 L F
.77704 .77906 m .75764 .79403 L .75467 .77947 L .814 0 0 r
F
.54414 .56984 m .52226 .56236 L .53575 .542 L .969 .883 0 r
F
.54414 .56984 m .53242 .59485 L .52226 .56236 L F
0 g
.5365 .61599 m
.61333 .59354 L
s
.82198 .76696 m .77704 .77906 L .77558 .77136 L .645 0 0 r
F
.77704 .77906 m .75467 .77947 L .77558 .77136 L .814 0 0 r
F
.74273 .81325 m .72845 .81182 L .73842 .79336 L .981 0 0 r
F
.74273 .81325 m .73369 .83499 L .72845 .81182 L F
.79406 .36395 m .80517 .40051 L .82002 .38188 L .82 0 0 r
F
.79835 .34061 m .79406 .36395 L .82002 .38188 L .861 0 0 r
F
.78623 .38762 m .7857 .41581 L .80517 .40051 L .773 0 0 r
F
.78623 .38762 m .77571 .40912 L .7857 .41581 L F
.63757 .51214 m .66653 .53575 L .64016 .52298 L .452 .6 0 r
F
.79406 .36395 m .78623 .38762 L .80517 .40051 L .82 0 0 r
F
.82198 .76696 m .84551 .7858 L .8232 .7747 L .425 0 0 r
F
.7104 .35131 m .75519 .36049 L .75275 .3365 L .605 0 0 r
F
.7104 .35131 m .71905 .37296 L .75519 .36049 L F
.62762 .6688 m .57909 .67997 L .57273 .66471 L .67 .28 0 r
F
.62762 .6688 m .6263 .68345 L .57909 .67997 L F
.67778 .65391 m .6263 .68345 L .62762 .6688 L .426 .077 0 r
F
.67986 .63157 m .67778 .65391 L .62762 .6688 L .528 .278 0 r
F
.75096 .31575 m .79835 .34061 L .79867 .32009 L .729 0 0 r
F
.81289 .89644 m .77461 .90829 L .76755 .89352 L .683 0 0 r
F
.81289 .89644 m .81353 .91078 L .77461 .90829 L F
.85605 .88579 m .81353 .91078 L .81289 .89644 L .488 0 0 r
F
.85653 .86554 m .85605 .88579 L .81289 .89644 L .554 0 0 r
F
.77571 .40912 m .76095 .40784 L .74716 .41247 L .664 0 0 r
F
.73174 .3941 m .74716 .41247 L .76095 .40784 L .647 0 0 r
F
.70832 .60093 m .67778 .65391 L .67986 .63157 L .103 0 0 r
F
.70238 .57657 m .70832 .60093 L .67986 .63157 L .294 .2 0 r
F
.88288 .84367 m .85605 .88579 L .85653 .86554 L .23 0 0 r
F
.87689 .82194 m .88288 .84367 L .85653 .86554 L .35 0 0 r
F
.53242 .59485 m .51751 .58609 L .52226 .56236 L .994 .819 0 r
F
.53242 .59485 m .52836 .62001 L .51751 .58609 L F
0 g
.5023 .62597 m
.52788 .6185 L
s
.73369 .83499 m .72584 .83312 L .72845 .81182 L .952 0 0 r
F
.73369 .83499 m .73143 .85727 L .72584 .83312 L F
.66187 .51511 m .68795 .55416 L .66653 .53575 L .228 .424 0 r
F
.63757 .51214 m .66187 .51511 L .66653 .53575 L .452 .6 0 r
F
.84338 .77108 m .864 .80204 L .84551 .7858 L .212 0 0 r
F
.82198 .76696 m .84338 .77108 L .84551 .7858 L .425 0 0 r
F
.82198 .76696 m .77558 .77136 L .78327 .76423 L .645 0 0 r
F
.77558 .77136 m .76922 .76586 L .78327 .76423 L .71 0 0 r
F
.77558 .77136 m .75467 .77947 L .76922 .76586 L F
.63757 .51214 m .58253 .51831 L .59067 .50831 L .659 .747 0 r
F
.58253 .51831 m .5719 .50777 L .59067 .50831 L .76 .928 0 r
F
.58253 .51831 m .55653 .52688 L .5719 .50777 L F
.75802 .38514 m .77571 .40912 L .78623 .38762 L .714 0 0 r
F
.75802 .38514 m .76095 .40784 L .77571 .40912 L F
.76755 .89352 m .74786 .89512 L .73626 .87798 L .828 0 0 r
F
.76755 .89352 m .77461 .90829 L .74786 .89512 L F
.75096 .31575 m .75275 .3365 L .79835 .34061 L .729 0 0 r
F
.57273 .66471 m .54463 .66149 L .53249 .64297 L .823 .361 0 r
F
.57273 .66471 m .57909 .67997 L .54463 .66149 L F
.71905 .37296 m .75802 .38514 L .75519 .36049 L .629 0 0 r
F
.71905 .37296 m .73174 .3941 L .75802 .38514 L F
.73174 .3941 m .76095 .40784 L .75802 .38514 L .647 0 0 r
F
.82198 .76696 m .79723 .76043 L .81206 .76148 L .645 0 0 r
F
.82198 .76696 m .78327 .76423 L .79723 .76043 L F
.81206 .76148 m .84338 .77108 L .82198 .76696 L .23 0 0 r
F
.86129 .78184 m .87689 .82194 L .864 .80204 L 0 0 0 r
F
.84338 .77108 m .86129 .78184 L .864 .80204 L .212 0 0 r
F
.63757 .51214 m .60688 .50299 L .62486 .50446 L .659 .747 0 r
F
.63757 .51214 m .59067 .50831 L .60688 .50299 L F
.62486 .50446 m .66187 .51511 L .63757 .51214 L .332 .656 0 r
F
.75275 .3365 m .79406 .36395 L .79835 .34061 L .731 0 0 r
F
.75467 .77947 m .75842 .77464 L .76922 .76586 L .531 0 0 r
F
.75467 .77947 m .73842 .79336 L .75842 .77464 L F
.68183 .5258 m .70238 .57657 L .68795 .55416 L 0 .103 0 r
F
.66187 .51511 m .68183 .5258 L .68795 .55416 L .228 .424 0 r
F
0 g
.66331 .51589 m
.66605 .51162 L
s
.75519 .36049 m .78623 .38762 L .79406 .36395 L .726 0 0 r
F
.75519 .36049 m .75802 .38514 L .78623 .38762 L F
.55653 .52688 m .55681 .51566 L .5719 .50777 L .753 .993 0 r
F
.55653 .52688 m .53575 .542 L .55681 .51566 L F
.78327 .76423 m .79599 .75858 L .79723 .76043 L .353 0 0 r
F
.78327 .76423 m .76922 .76586 L .79599 .75858 L F
.73143 .85727 m .73099 .8552 L .72584 .83312 L 0 0 0 r
F
.73143 .85727 m .73626 .87798 L .73099 .8552 L F
.75275 .3365 m .75519 .36049 L .79406 .36395 L .731 0 0 r
F
.59067 .50831 m .603 .49752 L .60688 .50299 L .543 .9 0 r
F
.59067 .50831 m .5719 .50777 L .603 .49752 L F
.52836 .62001 m .52218 .61092 L .51751 .58609 L .817 .539 0 r
F
.52836 .62001 m .53249 .64297 L .52218 .61092 L F
.85605 .88579 m .85055 .90173 L .81353 .91078 L .488 0 0 r
F
.88127 .86515 m .85055 .90173 L .85605 .88579 L .014 0 0 r
F
.88288 .84367 m .88127 .86515 L .85605 .88579 L .23 0 0 r
F
.81206 .76148 m .82448 .76059 L .84338 .77108 L F
.79723 .76043 m .82448 .76059 L .81206 .76148 L .126 0 0 r
F
.79723 .76043 m .79599 .75858 L .82448 .76059 L F
.67778 .65391 m .66938 .67078 L .6263 .68345 L .426 .077 0 r
F
.70502 .62494 m .66938 .67078 L .67778 .65391 L 0 0 0 r
F
.70832 .60093 m .70502 .62494 L .67778 .65391 L .103 0 0 r
F
.62486 .50446 m .6376 .50036 L .66187 .51511 L .332 .656 0 r
F
.60688 .50299 m .6376 .50036 L .62486 .50446 L .326 .76 0 r
F
.81353 .91078 m .78475 .91649 L .77461 .90829 L .557 0 0 r
F
.81353 .91078 m .81331 .91831 L .78475 .91649 L F
.85055 .90173 m .81331 .91831 L .81353 .91078 L .314 0 0 r
F
.8739 .79834 m .88288 .84367 L .87689 .82194 L 0 0 0 r
F
.86129 .78184 m .8739 .79834 L .87689 .82194 L F
.60688 .50299 m .603 .49752 L .6376 .50036 L .326 .76 0 r
F
.73842 .79336 m .75201 .7899 L .75842 .77464 L 0 0 0 r
F
.73842 .79336 m .72845 .81182 L .75201 .7899 L F
.82448 .76059 m .86129 .78184 L .84338 .77108 L .404 0 0 r
F
.6263 .68345 m .58896 .68711 L .57909 .67997 L .474 0 0 r
F
.6263 .68345 m .62367 .68966 L .58896 .68711 L F
.66938 .67078 m .62367 .68966 L .6263 .68345 L .132 0 0 r
F
.77461 .90829 m .76524 .90691 L .74786 .89512 L .539 0 0 r
F
.77461 .90829 m .78475 .91649 L .76524 .90691 L F
.69539 .54337 m .70832 .60093 L .70238 .57657 L 0 0 0 r
F
.68183 .5258 m .69539 .54337 L .70238 .57657 L 0 .103 0 r
F
.53575 .542 m .54702 .53144 L .55681 .51566 L 0 0 0 r
F
.53575 .542 m .52226 .56236 L .54702 .53144 L F
.6376 .50036 m .68183 .5258 L .66187 .51511 L 0 .276 0 r
F
.57909 .67997 m .56378 .67362 L .54463 .66149 L .454 0 0 r
F
.57909 .67997 m .58896 .68711 L .56378 .67362 L F
.73626 .87798 m .74351 .87588 L .73099 .8552 L 0 0 0 r
F
.73626 .87798 m .74786 .89512 L .74351 .87588 L F
.76922 .76586 m .79558 .76457 L .79599 .75858 L .224 0 0 r
F
.76922 .76586 m .75842 .77464 L .79558 .76457 L F
.53249 .64297 m .536 .63436 L .52218 .61092 L 0 0 0 r
F
.53249 .64297 m .54463 .66149 L .536 .63436 L F
.8739 .79834 m .87981 .81905 L .88288 .84367 L F
.87981 .81905 m .88127 .86515 L .88288 .84367 L .876 0 0 r
F
.85055 .90173 m .84044 .91172 L .81331 .91831 L .314 0 0 r
F
.87207 .88427 m .84044 .91172 L .85055 .90173 L 0 0 0 r
F
.88127 .86515 m .87207 .88427 L .85055 .90173 L .014 0 0 r
F
.72845 .81182 m .75076 .81023 L .75201 .7899 L .159 0 0 r
F
.72845 .81182 m .72584 .83312 L .75076 .81023 L F
.5719 .50777 m .60005 .50143 L .603 .49752 L 0 0 0 r
F
.5719 .50777 m .55681 .51566 L .60005 .50143 L F
.82448 .76059 m .83518 .76737 L .86129 .78184 L .404 0 0 r
F
.79599 .75858 m .83518 .76737 L .82448 .76059 L .499 0 0 r
F
.83518 .76737 m .8739 .79834 L .86129 .78184 L .806 0 0 r
F
.69539 .54337 m .70103 .56623 L .70832 .60093 L 0 0 0 r
F
.70103 .56623 m .70502 .62494 L .70832 .60093 L .959 .79 0 r
F
.66938 .67078 m .65528 .68039 L .62367 .68966 L .132 0 0 r
F
.70502 .62494 m .6926 .64621 L .66938 .67078 L 0 0 0 r
F
.6926 .64621 m .65528 .68039 L .66938 .67078 L .646 .943 0 r
F
.79599 .75858 m .79558 .76457 L .83518 .76737 L .499 0 0 r
F
0 g
.75716 .77764 m
.80465 .83841 L
s
.72798 .74028 m
.75598 .77613 L
s
.75598 .77613 m
.75635 .77659 L
s
.67154 .66804 m
.67203 .66868 L
s
.61333 .59354 m
.67038 .66656 L
s
.67203 .66868 m
.72798 .74028 L
s
.52226 .56236 m .54369 .55374 L .54702 .53144 L 0 0 0 r
F
.52226 .56236 m .51751 .58609 L .54369 .55374 L F
.81331 .91831 m .79706 .91713 L .78475 .91649 L F
.81331 .91831 m .81223 .91809 L .79706 .91713 L F
.84044 .91172 m .81223 .91809 L .81331 .91831 L .205 0 0 r
F
.74786 .89512 m .76224 .893 L .74351 .87588 L .122 0 0 r
F
.74786 .89512 m .76524 .90691 L .76224 .893 L F
.6376 .50036 m .64825 .50538 L .68183 .5258 L 0 .276 0 r
F
.603 .49752 m .64825 .50538 L .6376 .50036 L .361 0 0 r
F
.78475 .91649 m .78678 .91206 L .76524 .90691 L .109 0 0 r
F
.78475 .91649 m .79706 .91713 L .78678 .91206 L F
.64825 .50538 m .69539 .54337 L .68183 .5258 L .786 .287 0 r
F
0 g
.61333 .59354 m
.66005 .52094 L
s
.87831 .84196 m .87207 .88427 L .88127 .86515 L .973 0 0 r
F
.87981 .81905 m .87831 .84196 L .88127 .86515 L .876 0 0 r
F
.603 .49752 m .60005 .50143 L .64825 .50538 L .361 0 0 r
F
.75842 .77464 m .79607 .77806 L .79558 .76457 L .456 0 0 r
F
.75842 .77464 m .75201 .7899 L .79607 .77806 L F
.72584 .83312 m .75489 .83366 L .75076 .81023 L .307 0 0 r
F
.72584 .83312 m .73099 .8552 L .75489 .83366 L F
.62367 .68966 m .60148 .68513 L .58896 .68711 L .178 .693 0 r
F
.62367 .68966 m .61995 .68649 L .60148 .68513 L F
.65528 .68039 m .61995 .68649 L .62367 .68966 L .433 .868 0 r
F
.54463 .66149 m .55771 .65397 L .536 .63436 L .122 .372 0 r
F
.54463 .66149 m .56378 .67362 L .55771 .65397 L F
.84044 .91172 m .8266 .9146 L .81223 .91809 L .205 0 0 r
F
.87207 .88427 m .85606 .89905 L .84044 .91172 L 0 0 0 r
F
.85606 .89905 m .8266 .9146 L .84044 .91172 L .654 0 0 r
F
.58896 .68711 m .58819 .67797 L .56378 .67362 L .221 .622 0 r
F
.58896 .68711 m .60148 .68513 L .58819 .67797 L F
.84306 .78135 m .87981 .81905 L .8739 .79834 L .89 0 0 r
F
.83518 .76737 m .84306 .78135 L .8739 .79834 L .806 0 0 r
F
.69798 .59218 m .6926 .64621 L .70502 .62494 L .979 .905 0 r
F
.70103 .56623 m .69798 .59218 L .70502 .62494 L .959 .79 0 r
F
.55681 .51566 m .59835 .51467 L .60005 .50143 L .365 0 0 r
F
.55681 .51566 m .54702 .53144 L .59835 .51467 L F
.51751 .58609 m .54733 .5804 L .54369 .55374 L .225 .138 0 r
F
.51751 .58609 m .52218 .61092 L .54733 .5804 L F
.79558 .76457 m .84306 .78135 L .83518 .76737 L .672 0 0 r
F
.76524 .90691 m .78532 .90476 L .76224 .893 L .375 0 0 r
F
.76524 .90691 m .78678 .91206 L .78532 .90476 L F
.86941 .86472 m .85606 .89905 L .87207 .88427 L .918 0 0 r
F
.87831 .84196 m .86941 .86472 L .87207 .88427 L .973 0 0 r
F
.73099 .8552 m .76406 .85775 L .75489 .83366 L .402 0 0 r
F
.73099 .8552 m .74351 .87588 L .76406 .85775 L F
.65528 .68039 m .63673 .68156 L .61995 .68649 L .433 .868 0 r
F
.67211 .66253 m .63673 .68156 L .65528 .68039 L .735 .954 0 r
F
.6926 .64621 m .67211 .66253 L .65528 .68039 L .646 .943 0 r
F
.79558 .76457 m .79607 .77806 L .84306 .78135 L .672 0 0 r
F
.8233 .89539 m .81223 .91809 L .8266 .9146 L .629 0 0 r
F
.8233 .89539 m .79706 .91713 L .81223 .91809 L F
.65567 .51933 m .70103 .56623 L .69539 .54337 L .891 .541 0 r
F
.64825 .50538 m .65567 .51933 L .69539 .54337 L .786 .287 0 r
F
.8233 .89539 m .78678 .91206 L .79706 .91713 L .629 0 0 r
F
.75201 .7899 m .79743 .79786 L .79607 .77806 L .538 0 0 r
F
.75201 .7899 m .75076 .81023 L .79743 .79786 L F
.84721 .8013 m .87831 .84196 L .87981 .81905 L .89 0 0 r
F
.84306 .78135 m .84721 .8013 L .87981 .81905 L F
.8233 .89539 m .8266 .9146 L .83478 .90793 L .629 0 0 r
F
.85606 .89905 m .83478 .90793 L .8266 .9146 L .654 0 0 r
F
.60005 .50143 m .65567 .51933 L .64825 .50538 L .65 .228 0 r
F
.56378 .67362 m .58515 .66765 L .55771 .65397 L .401 .591 0 r
F
.56378 .67362 m .58819 .67797 L .58515 .66765 L F
.85397 .88498 m .83478 .90793 L .85606 .89905 L .816 0 0 r
F
.86941 .86472 m .85397 .88498 L .85606 .89905 L .918 0 0 r
F
.68637 .61857 m .67211 .66253 L .6926 .64621 L .906 .901 0 r
F
.69798 .59218 m .68637 .61857 L .6926 .64621 L .979 .905 0 r
F
.74351 .87588 m .77735 .87999 L .76406 .85775 L .473 0 0 r
F
.74351 .87588 m .76224 .893 L .77735 .87999 L F
.8233 .89539 m .78532 .90476 L .78678 .91206 L .629 0 0 r
F
.52218 .61092 m .55769 .60867 L .54733 .5804 L .367 .334 0 r
F
.52218 .61092 m .536 .63436 L .55769 .60867 L F
.60005 .50143 m .59835 .51467 L .65567 .51933 L .65 .228 0 r
F
.62953 .65436 m .61995 .68649 L .63673 .68156 L .647 .762 0 r
F
.62953 .65436 m .60148 .68513 L .61995 .68649 L F
.79607 .77806 m .84721 .8013 L .84306 .78135 L .715 0 0 r
F
.62953 .65436 m .58819 .67797 L .60148 .68513 L .647 .762 0 r
F
.54702 .53144 m .59813 .53617 L .59835 .51467 L .503 .24 0 r
F
.54702 .53144 m .54369 .55374 L .59813 .53617 L F
.8233 .89539 m .83478 .90793 L .83357 .90058 L .629 0 0 r
F
.85397 .88498 m .83357 .90058 L .83478 .90793 L .816 0 0 r
F
.76224 .893 m .79336 .89799 L .77735 .87999 L .536 0 0 r
F
.76224 .893 m .78532 .90476 L .79336 .89799 L F
.84712 .82525 m .86941 .86472 L .87831 .84196 L .867 0 0 r
F
.84721 .8013 m .84712 .82525 L .87831 .84196 L .89 0 0 r
F
.75076 .81023 m .79954 .82202 L .79743 .79786 L .578 0 0 r
F
.75076 .81023 m .75489 .83366 L .79954 .82202 L F
.65896 .54105 m .69798 .59218 L .70103 .56623 L .887 .643 0 r
F
.65567 .51933 m .65896 .54105 L .70103 .56623 L .891 .541 0 r
F
.79607 .77806 m .79743 .79786 L .84721 .8013 L .715 0 0 r
F
.62953 .65436 m .63673 .68156 L .64551 .67213 L .647 .762 0 r
F
.67211 .66253 m .64551 .67213 L .63673 .68156 L .735 .954 0 r
F
.8233 .89539 m .79336 .89799 L .78532 .90476 L .629 0 0 r
F
.66733 .64261 m .64551 .67213 L .67211 .66253 L .812 .86 0 r
F
.68637 .61857 m .66733 .64261 L .67211 .66253 L .906 .901 0 r
F
.536 .63436 m .57372 .63552 L .55769 .60867 L .464 .473 0 r
F
.536 .63436 m .55771 .65397 L .57372 .63552 L F
.62953 .65436 m .58515 .66765 L .58819 .67797 L .647 .762 0 r
F
.84274 .85071 m .85397 .88498 L .86941 .86472 L .833 0 0 r
F
.84712 .82525 m .84274 .85071 L .86941 .86472 L .867 0 0 r
F
.8345 .87495 m .83357 .90058 L .85397 .88498 L .782 0 0 r
F
.8345 .87495 m .8233 .89539 L .83357 .90058 L F
.84274 .85071 m .8345 .87495 L .85397 .88498 L .833 0 0 r
F
.75489 .83366 m .80218 .848 L .79954 .82202 L .604 0 0 r
F
.75489 .83366 m .76406 .85775 L .80218 .848 L F
.59835 .51467 m .65896 .54105 L .65567 .51933 L .713 .409 0 r
F
.79743 .79786 m .84712 .82525 L .84721 .8013 L .729 0 0 r
F
.8233 .89539 m .8079 .89439 L .79336 .89799 L .629 0 0 r
F
.77735 .87999 m .79336 .89799 L .8079 .89439 L .636 0 0 r
F
.62953 .65436 m .64551 .67213 L .64282 .66173 L .647 .762 0 r
F
.66733 .64261 m .64282 .66173 L .64551 .67213 L .812 .86 0 r
F
.55771 .65397 m .5937 .65806 L .57372 .63552 L .541 .589 0 r
F
.55771 .65397 m .58515 .66765 L .5937 .65806 L F
.65767 .56845 m .68637 .61857 L .69798 .59218 L .861 .695 0 r
F
.65896 .54105 m .65767 .56845 L .69798 .59218 L .887 .643 0 r
F
.54369 .55374 m .59946 .56384 L .59813 .53617 L .562 .373 0 r
F
.54369 .55374 m .54733 .5804 L .59946 .56384 L F
.80507 .87302 m .8233 .89539 L .8345 .87495 L .714 0 0 r
F
.80507 .87302 m .8079 .89439 L .8233 .89539 L F
.59835 .51467 m .59813 .53617 L .65896 .54105 L .713 .409 0 r
F
.79743 .79786 m .79954 .82202 L .84712 .82525 L .729 0 0 r
F
.76406 .85775 m .80507 .87302 L .80218 .848 L .622 0 0 r
F
.76406 .85775 m .77735 .87999 L .80507 .87302 L F
.77735 .87999 m .8079 .89439 L .80507 .87302 L .636 0 0 r
F
.62953 .65436 m .5937 .65806 L .58515 .66765 L .647 .762 0 r
F
.79954 .82202 m .84274 .85071 L .84712 .82525 L .732 0 0 r
F
.65185 .59864 m .66733 .64261 L .68637 .61857 L .825 .727 0 r
F
.65767 .56845 m .65185 .59864 L .68637 .61857 L .861 .695 0 r
F
.80218 .848 m .8345 .87495 L .84274 .85071 L .728 0 0 r
F
.80218 .848 m .80507 .87302 L .8345 .87495 L F
.64212 .62836 m .64282 .66173 L .66733 .64261 L .777 .75 0 r
F
.64212 .62836 m .62953 .65436 L .64282 .66173 L F
.79954 .82202 m .80218 .848 L .84274 .85071 L .732 0 0 r
F
.65185 .59864 m .64212 .62836 L .66733 .64261 L .825 .727 0 r
F
.54733 .5804 m .60222 .59478 L .59946 .56384 L .597 .464 0 r
F
0 g
.59164 .5743 m
.59225 .57484 L
s
.60114 .58273 m
.61333 .59354 L
s
.58425 .56775 m
.59164 .5743 L
s
.54733 .5804 m .55769 .60867 L .60222 .59478 L .597 .464 0 r
F
.59813 .53617 m .65767 .56845 L .65896 .54105 L .729 .502 0 r
F
.62953 .65436 m .61069 .65295 L .5937 .65806 L .647 .762 0 r
F
.57372 .63552 m .5937 .65806 L .61069 .65295 L .638 .617 0 r
F
.6061 .62561 m .62953 .65436 L .64212 .62836 L .714 .67 0 r
F
.6061 .62561 m .61069 .65295 L .62953 .65436 L F
.59813 .53617 m .59946 .56384 L .65767 .56845 L .729 .502 0 r
F
.55769 .60867 m .6061 .62561 L .60222 .59478 L .62 .541 0 r
F
.55769 .60867 m .57372 .63552 L .6061 .62561 L F
.57372 .63552 m .61069 .65295 L .6061 .62561 L .638 .617 0 r
F
.59946 .56384 m .65185 .59864 L .65767 .56845 L .732 .566 0 r
F
.60222 .59478 m .64212 .62836 L .65185 .59864 L .728 .618 0 r
F
.60222 .59478 m .6061 .62561 L .64212 .62836 L F
.59946 .56384 m .60222 .59478 L .65185 .59864 L .732 .566 0 r
F
.54549 .52355 m .49572 .54676 L .50126 .51998 L .734 0 0 r
F
.54549 .52355 m .54783 .5509 L .49572 .54676 L F
.54194 .49605 m .54549 .52355 L .50126 .51998 L .729 0 0 r
F
.5851 .51054 m .54783 .5509 L .54549 .52355 L .587 0 0 r
F
0 g
.55567 .5424 m
.58425 .56775 L
s
.57069 .48646 m .54549 .52355 L .54194 .49605 L .614 0 0 r
F
.57069 .48646 m .5851 .51054 L .54549 .52355 L F
.54194 .49605 m .50126 .51998 L .50977 .49341 L .729 0 0 r
F
.53748 .47082 m .54194 .49605 L .50977 .49341 L .714 0 0 r
F
.55263 .46569 m .54194 .49605 L .53748 .47082 L .635 0 0 r
F
.55263 .46569 m .57069 .48646 L .54194 .49605 L F
.54783 .5509 m .49364 .5714 L .49572 .54676 L .73 0 0 r
F
.54783 .5509 m .54874 .57572 L .49364 .5714 L F
.59456 .5358 m .54874 .57572 L .54783 .5509 L .549 0 0 r
F
.5851 .51054 m .59456 .5358 L .54783 .5509 L .587 0 0 r
F
.50126 .51998 m .45671 .52472 L .46828 .50102 L .862 0 0 r
F
.50126 .51998 m .49572 .54676 L .45671 .52472 L F
.50977 .49341 m .50126 .51998 L .46828 .50102 L .827 0 0 r
F
.50977 .49341 m .46828 .50102 L .48591 .47946 L F
.52049 .46941 m .50977 .49341 L .48591 .47946 L .778 0 0 r
F
.53748 .47082 m .50977 .49341 L .52049 .46941 L .714 0 0 r
F
.49572 .54676 m .45234 .54841 L .45671 .52472 L .887 0 0 r
F
.49572 .54676 m .49364 .5714 L .45234 .54841 L F
.55726 .44511 m .53748 .47082 L .52049 .46941 L .65 0 0 r
F
.55726 .44511 m .55263 .46569 L .53748 .47082 L F
.58534 .46801 m .5851 .51054 L .57069 .48646 L .453 0 0 r
F
.56022 .4559 m .57069 .48646 L .55263 .46569 L .537 0 0 r
F
.56022 .4559 m .58534 .46801 L .57069 .48646 L F
.60555 .48538 m .59456 .5358 L .5851 .51054 L .35 0 0 r
F
.58534 .46801 m .60555 .48538 L .5851 .51054 L .453 0 0 r
F
.54874 .57572 m .49527 .59164 L .49364 .5714 L .711 0 0 r
F
.54874 .57572 m .54812 .59573 L .49527 .59164 L F
.59818 .55997 m .54812 .59573 L .54874 .57572 L .485 0 0 r
F
.59456 .5358 m .59818 .55997 L .54874 .57572 L .549 0 0 r
F
0 g
.53263 .52196 m
.55421 .5411 L
s
.55726 .44511 m .52049 .46941 L .50798 .46197 L .65 0 0 r
F
.52049 .46941 m .48591 .47946 L .50798 .46197 L .778 0 0 r
F
.55726 .44511 m .56022 .4559 L .55263 .46569 L .65 0 0 r
F
.49364 .5714 m .4557 .56986 L .45234 .54841 L .889 0 0 r
F
.49364 .5714 m .49527 .59164 L .4557 .56986 L F
.6189 .50647 m .59818 .55997 L .59456 .5358 L .204 0 0 r
F
.60555 .48538 m .6189 .50647 L .59456 .5358 L .35 0 0 r
F
.48591 .47946 m .45906 .47326 L .47945 .45917 L .899 0 0 r
F
.48591 .47946 m .46828 .50102 L .45906 .47326 L F
.50798 .46197 m .48591 .47946 L .47945 .45917 L .81 0 0 r
F
.55726 .44511 m .50798 .46197 L .50473 .45125 L .65 0 0 r
F
.50798 .46197 m .47945 .45917 L .50473 .45125 L .81 0 0 r
F
.46828 .50102 m .44558 .49229 L .45906 .47326 L .972 0 0 r
F
.46828 .50102 m .45671 .52472 L .44558 .49229 L F
.55726 .44511 m .58534 .46801 L .56022 .4559 L .415 0 0 r
F
.54812 .59573 m .50056 .60551 L .49527 .59164 L .647 0 0 r
F
.54812 .59573 m .54599 .609 L .50056 .60551 L F
.59552 .58081 m .54599 .609 L .54812 .59573 L .35 0 0 r
F
.59818 .55997 m .59552 .58081 L .54812 .59573 L .485 0 0 r
F
.62402 .52934 m .59552 .58081 L .59818 .55997 L 0 0 0 r
F
.6189 .50647 m .62402 .52934 L .59818 .55997 L .204 0 0 r
F
.45671 .52472 m .44046 .51451 L .44558 .49229 L .994 0 0 r
F
.45671 .52472 m .45234 .54841 L .44046 .51451 L F
.57996 .44746 m .60555 .48538 L .58534 .46801 L .161 0 0 r
F
.55726 .44511 m .57996 .44746 L .58534 .46801 L .415 0 0 r
F
.55726 .44511 m .50473 .45125 L .51212 .4413 L .65 0 0 r
F
.50473 .45125 m .49338 .44016 L .51212 .4413 L .756 0 0 r
F
.50473 .45125 m .47945 .45917 L .49338 .44016 L F
.49527 .59164 m .46666 .58697 L .4557 .56986 L .807 0 0 r
F
.49527 .59164 m .50056 .60551 L .46666 .58697 L F
.55726 .44511 m .52744 .436 L .54474 .43747 L .65 0 0 r
F
.55726 .44511 m .51212 .4413 L .52744 .436 L F
.54474 .43747 m .57996 .44746 L .55726 .44511 L .301 0 0 r
F
.5984 .45713 m .6189 .50647 L .60555 .48538 L 0 0 0 r
F
.57996 .44746 m .5984 .45713 L .60555 .48538 L .161 0 0 r
F
.47945 .45917 m .47814 .44703 L .49338 .44016 L .768 0 0 r
F
.47945 .45917 m .45906 .47326 L .47814 .44703 L F
.51212 .4413 m .52276 .42996 L .52744 .436 L .546 0 0 r
F
.51212 .4413 m .49338 .44016 L .52276 .42996 L F
.45234 .54841 m .44439 .5378 L .44046 .51451 L .841 0 0 r
F
.45234 .54841 m .4557 .56986 L .44439 .5378 L F
.59552 .58081 m .58668 .59628 L .54599 .609 L .35 0 0 r
F
.62023 .55182 m .58668 .59628 L .59552 .58081 L 0 0 0 r
F
.62402 .52934 m .62023 .55182 L .59552 .58081 L F
.54474 .43747 m .55605 .43279 L .57996 .44746 L .301 0 0 r
F
.52744 .436 m .55605 .43279 L .54474 .43747 L .325 0 0 r
F
.52744 .436 m .52276 .42996 L .55605 .43279 L F
.54599 .609 m .50911 .61149 L .50056 .60551 L .403 0 0 r
F
.54599 .609 m .5425 .61405 L .50911 .61149 L F
.58668 .59628 m .5425 .61405 L .54599 .609 L .012 0 0 r
F
.5984 .45713 m .61067 .47336 L .6189 .50647 L 0 0 0 r
F
.61067 .47336 m .62402 .52934 L .6189 .50647 L .713 0 0 r
F
.45906 .47326 m .46799 .46148 L .47814 .44703 L 0 0 0 r
F
.45906 .47326 m .44558 .49229 L .46799 .46148 L F
.55605 .43279 m .5984 .45713 L .57996 .44746 L F
.50056 .60551 m .48434 .59795 L .46666 .58697 L .421 0 0 r
F
.50056 .60551 m .50911 .61149 L .48434 .59795 L F
.4557 .56986 m .45716 .55981 L .44439 .5378 L 0 0 0 r
F
.4557 .56986 m .46666 .58697 L .45716 .55981 L F
.49338 .44016 m .51895 .43287 L .52276 .42996 L F
.49338 .44016 m .47814 .44703 L .51895 .43287 L F
.61539 .4947 m .62023 .55182 L .62402 .52934 L .966 0 0 r
F
.61067 .47336 m .61539 .4947 L .62402 .52934 L .713 0 0 r
F
.58668 .59628 m .57234 .60474 L .5425 .61405 L .012 0 0 r
F
.62023 .55182 m .60772 .57167 L .58668 .59628 L 0 0 0 r
F
.60772 .57167 m .57234 .60474 L .58668 .59628 L .692 0 0 r
F
.44558 .49229 m .46414 .48224 L .46799 .46148 L 0 0 0 r
F
.44558 .49229 m .44046 .51451 L .46414 .48224 L F
.55605 .43279 m .56531 .43681 L .5984 .45713 L F
.52276 .42996 m .56531 .43681 L .55605 .43279 L .288 0 0 r
F
.56531 .43681 m .61067 .47336 L .5984 .45713 L .766 0 0 r
F
.52276 .42996 m .51895 .43287 L .56531 .43681 L .288 0 0 r
F
.5425 .61405 m .52019 .60873 L .50911 .61149 L .205 0 0 r
F
.5425 .61405 m .53795 .61009 L .52019 .60873 L F
.57234 .60474 m .53795 .61009 L .5425 .61405 L .46 0 0 r
F
.46666 .58697 m .47761 .57826 L .45716 .55981 L .056 0 0 r
F
.46666 .58697 m .48434 .59795 L .47761 .57826 L F
.50911 .61149 m .50711 .60154 L .48434 .59795 L .202 0 0 r
F
.50911 .61149 m .52019 .60873 L .50711 .60154 L F
.61189 .51907 m .60772 .57167 L .62023 .55182 L .98 0 0 r
F
.61539 .4947 m .61189 .51907 L .62023 .55182 L .966 0 0 r
F
.47814 .44703 m .51642 .44478 L .51895 .43287 L .278 0 0 r
F
.47814 .44703 m .46799 .46148 L .51642 .44478 L F
.44046 .51451 m .46712 .50732 L .46414 .48224 L .123 0 0 r
F
.44046 .51451 m .44439 .5378 L .46712 .50732 L F
.57234 .60474 m .55377 .60514 L .53795 .61009 L .46 0 0 r
F
.58757 .58684 m .55377 .60514 L .57234 .60474 L .734 0 0 r
F
.60772 .57167 m .58757 .58684 L .57234 .60474 L .692 0 0 r
F
.57151 .44942 m .61539 .4947 L .61067 .47336 L .896 0 0 r
F
.56531 .43681 m .57151 .44942 L .61067 .47336 L .766 0 0 r
F
.51895 .43287 m .57151 .44942 L .56531 .43681 L .622 0 0 r
F
.48434 .59795 m .50371 .59119 L .47761 .57826 L .363 0 0 r
F
.48434 .59795 m .50711 .60154 L .50371 .59119 L F
.6004 .54401 m .58757 .58684 L .60772 .57167 L .909 0 0 r
F
.61189 .51907 m .6004 .54401 L .60772 .57167 L .98 0 0 r
F
.44439 .5378 m .47675 .53411 L .46712 .50732 L .301 0 0 r
F
.44439 .5378 m .45716 .55981 L .47675 .53411 L F
.51895 .43287 m .51642 .44478 L .57151 .44942 L .622 0 0 r
F
.54554 .57788 m .53795 .61009 L .55377 .60514 L .636 0 0 r
F
.54554 .57788 m .52019 .60873 L .53795 .61009 L F
.54554 .57788 m .50711 .60154 L .52019 .60873 L F
.46799 .46148 m .51547 .46473 L .51642 .44478 L .454 0 0 r
F
.46799 .46148 m .46414 .48224 L .51547 .46473 L F
.57392 .4696 m .61189 .51907 L .61539 .4947 L .9 0 0 r
F
.57151 .44942 m .57392 .4696 L .61539 .4947 L .896 0 0 r
F
.54554 .57788 m .55377 .60514 L .56171 .59569 L .636 0 0 r
F
.58757 .58684 m .56171 .59569 L .55377 .60514 L .734 0 0 r
F
.58201 .56688 m .56171 .59569 L .58757 .58684 L .814 0 0 r
F
.6004 .54401 m .58201 .56688 L .58757 .58684 L .909 0 0 r
F
.45716 .55981 m .49207 .55978 L .47675 .53411 L .421 0 0 r
F
.45716 .55981 m .47761 .57826 L .49207 .55978 L F
.54554 .57788 m .50371 .59119 L .50711 .60154 L .636 0 0 r
F
.51642 .44478 m .57392 .4696 L .57151 .44942 L .707 0 0 r
F
.54554 .57788 m .56171 .59569 L .55863 .58526 L .636 0 0 r
F
.58201 .56688 m .55863 .58526 L .56171 .59569 L .814 0 0 r
F
.47761 .57826 m .51143 .58158 L .49207 .55978 L .515 0 0 r
F
.47761 .57826 m .50371 .59119 L .51143 .58158 L F
.57217 .49539 m .6004 .54401 L .61189 .51907 L .874 0 0 r
F
.57392 .4696 m .57217 .49539 L .61189 .51907 L .9 0 0 r
F
.46414 .48224 m .51626 .49079 L .51547 .46473 L .532 0 0 r
F
.46414 .48224 m .46712 .50732 L .51626 .49079 L F
.51642 .44478 m .51547 .46473 L .57392 .4696 L .707 0 0 r
F
.54554 .57788 m .51143 .58158 L .50371 .59119 L .636 0 0 r
F
.56639 .52409 m .58201 .56688 L .6004 .54401 L .836 0 0 r
F
.57217 .49539 m .56639 .52409 L .6004 .54401 L .874 0 0 r
F
.55718 .55262 m .55863 .58526 L .58201 .56688 L .782 0 0 r
F
.55718 .55262 m .54554 .57788 L .55863 .58526 L F
.56639 .52409 m .55718 .55262 L .58201 .56688 L .836 0 0 r
F
.46712 .50732 m .51872 .52024 L .51626 .49079 L .576 0 0 r
F
.46712 .50732 m .47675 .53411 L .51872 .52024 L F
.51547 .46473 m .57217 .49539 L .57392 .4696 L .731 0 0 r
F
.54554 .57788 m .52745 .57646 L .51143 .58158 L .636 0 0 r
F
.49207 .55978 m .51143 .58158 L .52745 .57646 L .627 0 0 r
F
.52259 .54987 m .54554 .57788 L .55718 .55262 L .714 0 0 r
F
.52259 .54987 m .52745 .57646 L .54554 .57788 L F
.51547 .46473 m .51626 .49079 L .57217 .49539 L .731 0 0 r
F
.47675 .53411 m .52259 .54987 L .51872 .52024 L .606 0 0 r
F
.47675 .53411 m .49207 .55978 L .52259 .54987 L F
.49207 .55978 m .52745 .57646 L .52259 .54987 L .627 0 0 r
F
.51626 .49079 m .56639 .52409 L .57217 .49539 L .736 0 0 r
F
.51872 .52024 m .55718 .55262 L .56639 .52409 L .73 0 0 r
F
.51872 .52024 m .52259 .54987 L .55718 .55262 L F
.51626 .49079 m .51872 .52024 L .56639 .52409 L .736 0 0 r
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{271.313, 287.938},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[27]:=",
 CellID->10630,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 270.313}, {286.938, 0}} -> {0.0403593, -2.76835, \
0.00322536, 0.00322536}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Comparing XSLT and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellID->7406],

Cell[TextData[{
 "In many situations, you need to transform a document from one XML format \
into another; one popular technique used for this purpose is XSLT \
transformations. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s pattern-matching and transformation abilities allow you \
to do similar transformations by importing the original document and then \
manipulating the symbolic XML. This section gives examples of some basic XSLT \
transformations and shows how to do the equivalent transformations in ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",
 CellID->9531],

Cell[CellGroupData[{

Cell["A Simple Template", "Subsection",
 CellID->10489],

Cell[TextData[{
 "In our example, XML dialect uses the ",
 StyleBox["code", "MR"],
 " tag to enclose program code. Typically, this is displayed in a monospace \
font. If we were to convert such a document to XHTML, we would probably want \
to use the ",
 StyleBox["pre",
  FontFamily->"Courier"],
 " tag for code."
}], "Text",
 CellID->15165],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<xsl:template match=\"code\">\n\t<pre class=\"code\">\
\n\t\t<xsl:value-of select=\".\"/>\n\t</pre>\n</xsl:template>", "MR"]], \
"IndentedText",
 CellID->4521],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can create a function to do the same."
}], "Text",
 CellID->30127],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xslt", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<pre\>\"", ",", "_", ",", 
      RowBox[{"{", "value_String", "}"}]}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<pre\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<class\>\"", "->", "\"\<code\>\""}], "}"}], ",", 
     RowBox[{"{", "value", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->9964],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xslt", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<code\>\"", ",", "_", ",", "data_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<pre\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<class\>\"", "->", "\"\<code\>\""}], "}"}], ",", "data"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->440]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inserting Attribute Values", "Subsection",
 CellID->21113],

Cell[TextData[{
 "Now consider an XML application that uses the ",
 StyleBox["termdef", "MR"],
 " element to indicate the definition of a new term. We would like to anchor \
the definition with an element named ",
 StyleBox["a", "MR"],
 " so that we can link directly to that location in the document. Assuming we \
have templates to handle whatever string formatting is inside the ",
 StyleBox["termdef", "MR"],
 " element, we can use the following XSLT."
}], "Text",
 CellID->30389],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<xsl:template match=\"termdef\">\n\t<span \
class=\"termdef\">\n\t\t<a name=\"{@id}\">[Definition:]&nbsp;&nbsp;</a>\n\t\t\
<xsl:apply-templates/>\n\t</span>\n</xsl:template>", "MR"]], "IndentedText",
 CellID->22710],

Cell[TextData[{
 "Notice that the ",
 StyleBox["name",
  FontFamily->"Courier"],
 " attribute in the resultant XHTML gets the value of the ",
 StyleBox["id", "MR"],
 " attribute of the original ",
 StyleBox["termdef", "MR"],
 " element."
}], "Text",
 CellID->20488],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can do the following."
}], "Text",
 CellID->13763],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xslt", "[", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<termdef\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"___", ",", 
        RowBox[{"\"\<id\>\"", "\[Rule]", "id_"}], ",", "___"}], "}"}], ",", 
      "contents_"}], "]"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<span\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<class\>\"", "->", "\"\<termdef\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<a\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<name\>\"", "\[Rule]", "id"}], "}"}], ",", 
         RowBox[{"{", "\"\<[Definitions:]  \>\"", "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"xslt", "/@", "contents"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->30320]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Predicates", "Subsection",
 CellID->8188],

Cell[TextData[{
 "Consider a more complicated example, which will use XPath predicates. \
Assume we would like to match a",
 StyleBox[" ",
  FontFamily->"Times New Roman"],
 StyleBox["note", "MR"],
 StyleBox[" ",
  FontFamily->"Times New Roman"],
 "element, but only if it either has a ",
 StyleBox["role", "MR"],
 " attribute set to ",
 StyleBox["example", "MR"],
 " or if it contains an ",
 StyleBox["eg", "MR"],
 " element as a child. Let us look at an XSLT template and then explain what \
it does."
}], "Text",
 CellID->23821],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<xsl:template match=\"note[@role='example' or \
child::eg]\">\n\t<div class=\"exampleOuter\">\n\t\t<div class=\"exampleHeader\
\">Example</div>\n\t\t<xsl:if test=\"*[1][self::p]\">\n\t\t\t<div \
class=\"exampleWrapper\">\n\t\t\t\t<xsl:apply-templates select=\"*[1]\"/>\n\t\
\t\t</div>\n\t\t</xsl:if>\n\t\t<div class=\"exampleInner\">\n\t\t\t\
<xsl:apply-templates select=\"eg\"/>\n\t\t</div>\n\t\t<xsl:if \
test=\"*[position()>1 and self::p]\">\n\t\t\t<div class=\"exampleWrapper\">\n\
\t\t\t\t<xsl:apply-templates\n\t\t\t\t\tselect=\"*[position>1 and \
self::p]\"/>\n\t\t\t</div>\n\t\t</xsl:if>\n\t</div>\n</xsl:template>", \
"MR"]], "IndentedText",
 CellID->17264],

Cell[TextData[{
 "The first ",
 StyleBox["xsl:if", "MR"],
 " element checks to see if the first child element is a ",
 StyleBox["p", "MR"],
 " element. If it is, then ",
 StyleBox["xsl:apply-templates", "MR"],
 " is called on that child. This is similar to calling ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " across the results of ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 ". In the second ",
 StyleBox["xsl:if", "MR"],
 " element, we check if there are ",
 StyleBox["p", "MR"],
 " child elements beyond the first child. If so, ",
 StyleBox["xsl:apply-templates", "MR"],
 " is called on those. Here is the corresponding ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "Text",
 CellID->6003],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xslt", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<note\>\"", ",", 
       RowBox[{"atts", ":", 
        RowBox[{"{", 
         RowBox[{"___", ",", 
          RowBox[{"\"\<role\>\"", "->", "\"\<example\>\""}], ",", "___"}], 
         "}"}]}], ",", "contents"}], "]"}], " ", "|", "\[IndentingNewLine]", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<note\>\"", ",", "atts_", ",", 
       RowBox[{"contents", ":", 
        RowBox[{"{", 
         RowBox[{"___", ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<eg\>\"", ",", "___"}], "]"}], ",", "___"}], "}"}]}]}],
       "]"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<div\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<class\>\"", "->", "\"\<exampleOuter\>\""}], "}"}], ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<div\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<class\>\"", "->", "\"\<exampleHeader\>\""}], "}"}], 
         ",", 
         RowBox[{"{", "\"\<Example\>\"", "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{"contents", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"XMLElement", "[", 
              RowBox[{"\"\<p\>\"", ",", "___"}], "]"}], ",", "___"}], "}"}]}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<div\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<class\>\"", "->", "\"\<exampleWrapper\>\""}], "}"}], 
           ",", 
           RowBox[{"xslt", "[", 
            RowBox[{"contents", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Sequence", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<div\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<class\>\"", "->", "\"\<exampleInner\>\""}], "}"}], ",",
          
         RowBox[{"Map", "[", 
          RowBox[{"xslt", ",", 
           RowBox[{"Cases", "[", 
            RowBox[{"contents", ",", 
             RowBox[{"XMLElement", "[", 
              RowBox[{"\"\<eg\>\"", ",", "___"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Map", "[", 
         RowBox[{"xslt", ",", 
          RowBox[{"Cases", "[", 
           RowBox[{
            RowBox[{"Drop", "[", 
             RowBox[{"contents", ",", "1"}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\"\<p\>\"", ",", "___"}], "]"}]}], "]"}]}], "]"}]}]}], 
      "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->9754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"If", "[", 
    RowBox[{"False", ",", "bob", ",", 
     RowBox[{"Sequence", "@@", 
      RowBox[{"{", "}"}]}]}], "]"}], ",", "b"}], "}"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->14722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->25316]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Traversing Upwards", "Subsection",
 CellID->5854],

Cell[TextData[{
 "To select an ancestor or sibling, we have to realize that an XML document \
is just a stream of characters that follows a grammar. Tools for manipulating \
XML documents treat XML according to some model. In the case of XSLT (and its \
path-selection language, XPath), this model is that of a tree. Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a list-based language, it treats XML as nested expression lists."
}], "Text",
 CellID->6586],

Cell["\<\
While these two models are similar, they have important differences. Most \
notably, in nested lists you do not inherently have any concept of the \
containing list. Technically, any transformation that can be done with axis \
types like ancestor can also be done without them. However, it is often \
convenient to traverse up the XML document.\
\>", "Text",
 CellID->26425],

Cell[TextData[{
 "Let us look at an example and then discuss how to implement the same \
behavior in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Consider the following XML document."
}], "Text",
 CellID->9524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myxml", "=", 
  RowBox[{
  "XML`Parser`XMLGetString", "[", 
   "\"\<<document>\n\t<body>\n\t\t<p>This is a paragraph.</p>\n\t\t<p>This \
paragraph contains a bibliography referece:\n\t\t\t<bibref ref=\\\"mybibref\\\
\"/>\n\t\t</p>\n\t</body>\n\t<bibliography>\n\t\t<bibl id=\\\"mybibref\\\">My \
Bibliography Reference</bibl>\n\t</bibliography>\n</document>\>\"", 
   "]"}]}]], "Input",
 CellLabel->"In[63]:=",
 CellID->15818],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"document\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"body\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"p\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"This is a paragraph.\"\>", "}"}]}], "]"}], ",",
            
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"p\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"This paragraph contains a bibliography referece:\"\
\>", ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"bibref\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{"\<\"ref\"\>", "\[Rule]", "\<\"mybibref\"\>"}], 
                  "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"bibliography\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"bibl\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"id\"\>", "\[Rule]", "\<\"mybibref\"\>"}], "}"}], 
            ",", 
            RowBox[{"{", "\<\"My Bibliography Reference\"\>", "}"}]}], "]"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{555, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->27302]
}, Open  ]],

Cell[TextData[{
 "Assume we simply want to have a template that matches ",
 StyleBox["bibref", "MR"],
 " elements and replaces them with the text inside of the corresponding ",
 StyleBox["bibl", "MR"],
 " element. In XSLT, we would write the following template."
}], "Text",
 CellID->30120],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<xsl:template match=\"bibref\">\n\t<xsl:param \
name=\"ref\">\n\t\t<xsl:value-of select=\"@ref\"/>\n\t</xsl:param>\n\t\
<xsl:value-of select=\"/bibliography/bibl[@id = $ref][1]\"/>\n\
</xsl:template>", "MR"]], "IndentedText",
 CellID->32659],

Cell[TextData[{
 "The problem with using the same approach in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that once we have matched a ",
 StyleBox["bibref", "MR"],
 " element, we no longer have any information about the elements containing \
it. As a remedy, we will instead pass an expression containing the entire \
symbolic XML expression. Notice that the ",
 StyleBox["bibref", "MR"],
 " element in question can be obtained from"
}], "Text",
 CellID->488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
  "myxml", ",", "2", ",", "3", ",", "1", ",", "3", ",", "2", ",", "3", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[64]:=",
 CellID->30682],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"bibref\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ref\"\>", "\[Rule]", "\<\"mybibref\"\>"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{274, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[64]=",
 CellID->18341]
}, Open  ]],

Cell[TextData[{
 "We can pass this expression wrapped in ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ". so that we can easily obtain the ",
 StyleBox["bibref", "MR"],
 " element by calling ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ". We can access ancestors by dropping indices from the ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " expression. However, we will need to write a pattern-matching function so \
that we can match these in definitions of functions."
}], "Text",
 CellID->2574],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"XMLMatchQ", "[", 
    RowBox[{"expr_", ",", "patt_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"Hold", "[", 
        RowBox[{"Part", "[", "___", "]"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"ReleaseHold", "[", "expr", "]"}], ",", "patt"}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->6500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XMLMatchQ", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
     "myxml", ",", "2", ",", "3", ",", "1", ",", "3", ",", "2", ",", "3", ",",
       "2"}], "]"}], "]"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<bibref\>\"", ",", "_", ",", "_"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[66]:=",
 CellID->25566],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->26222]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " transformation then becomes relatively simple."
}], "Text",
 CellID->5754],

Cell[BoxData[
 RowBox[{"Clear", "[", "xslt", "]"}]], "Input",
 CellLabel->"In[67]:=",
 CellID->1552],

Cell[BoxData[
 RowBox[{
  RowBox[{"xslt", "[", 
   RowBox[{"xml_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"XMLMatchQ", "[", 
       RowBox[{"#", ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\"\<bibref\>\"", ",", 
          RowBox[{"{", "___", "}"}], ",", "_"}], "]"}]}], "]"}], "&"}], 
     ")"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ref", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ref", "=", 
      RowBox[{"\"\<ref\>\"", "/.", 
       RowBox[{
        RowBox[{"ReleaseHold", "[", "xml", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"First", "[", 
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Part", "[", 
          RowBox[{"xml", ",", "1", ",", "1"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<bibliography\>\"", ",", "_", ",", 
           RowBox[{"{", 
            RowBox[{"___", ",", "\[IndentingNewLine]", 
             RowBox[{"XMLElement", "[", 
              RowBox[{"\"\<bibl\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<id\>\"", "\[Rule]", "ref"}], "}"}], ",", 
               RowBox[{"{", "s_", "}"}]}], "]"}], ",", "___"}], "}"}]}], 
          "]"}], "\[Rule]", "s"}], ",", "2"}], "]"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[68]:=",
 CellID->850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xslt", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Part", "[", 
    RowBox[{
    "myxml", ",", "2", ",", "3", ",", "1", ",", "3", ",", "2", ",", "3", ",", 
     "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->1516],

Cell[BoxData["\<\"My Bibliography Reference\"\>"], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[69]=",
 CellID->13226]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting a Notebook to HTML", "Section",
 CellID->23486],

Cell[TextData[{
 "Suppose you need to export a notebook in a specific XML format (one not \
listed under the ",
 StyleBox["File \[RightTriangle] Save As ", "MenuName"],
 "dialog\[CloseCurlyQuote]s ",
 StyleBox["Save As Type:", "MenuName"],
 " submenu). One option would be to export to ExpressionML and then use some \
external tool (e.g., XSLT rules) to transform to the desired form of XML. But \
often it is just as easy to perform the manipulation within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", converting the notebook expression directly into symbolic XML and saving \
the latter. Anyone with a basic command of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns and programming should be able to do this. Users coming from an \
XSLT background may even feel a sense of deja vu; since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are essentially trees, the techniques are much the same."
}], "Text",
 CellID->6602],

Cell[TextData[{
 "As an example, let us recreate an abridged version of the ",
 StyleBox["File \[RightTriangle] Save As \[RightTriangle] Web Page (*.html)", 
  "MenuName"],
 " functionality."
}], "Text",
 CellID->7737],

Cell["Create an example notebook.", "MathCaption",
 CellID->28901],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
      RowBox[{"Directory", "[", "]"}], ",", 
      "\"\<ExampleData/Shakespeare.nb\>\""}], "]"}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[70]:=",
 CellID->17901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"NotebookGet", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[71]:=",
 CellID->22749],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Cell", "[", 
     RowBox[{"CellGroupData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{"\<\"Quotations\"\>", ",", "\<\"Title\"\>"}], "]"}], ",", 
         RowBox[{"Cell", "[", 
          RowBox[{"CellGroupData", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cell", "[", 
               RowBox[{"\<\"Shakespeare\"\>", ",", "\<\"Section\"\>"}], "]"}],
               ",", 
              RowBox[{"Cell", "[", 
               RowBox[{
                RowBox[{"TextData", "[", 
                 RowBox[{"{", 
                  
                  RowBox[{"\<\"Now is the winter of our discontent made \
glorious summer by this \"\>", ",", 
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\<\"Son of York\"\>", ",", 
                    RowBox[{"FontSlant", "\[Rule]", "\<\"Italic\"\>"}]}], 
                    "]"}], ",", "\<\".  And all the clouds that lowered on \
our house, in the Ocean's deep bosum buried.\"\>"}], "}"}], "]"}], 
                ",", "\<\"Text\"\>"}], "]"}], ",", 
              RowBox[{"Cell", "[", 
               RowBox[{
                RowBox[{"TextData", "[", 
                 RowBox[{"{", 
                  
                  RowBox[{"\<\"Forgive me, though bleeding piece of earth, \
that I am meek and gentle with these butchers.  Thou art the ruinest of the \
noblest man that ever lived in the tide of time.  Woe to the hands \"\>", ",",
                    
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\<\"that shed this costy blood\"\>", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\<\"Bold\"\>"}]}], 
                    "]"}], ",", "\<\"!\"\>"}], "}"}], "]"}], 
                ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", "Open"}], "]"}], 
          "]"}]}], "}"}], ",", "Open"}], "]"}], "]"}], "}"}], ",", 
   RowBox[{"FrontEndVersion", "\[Rule]", "\<\"4.1 for X\"\>"}], ",", 
   RowBox[{"ScreenRectangle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1280.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1024.`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"520.`", ",", "600.`"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"22.`", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "63.`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"CellLabelAutoDelete", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{543, 458},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[71]=",
 CellID->15967]
}, Open  ]],

Cell[TextData[{
 "We define a recursive function, ",
 StyleBox["transform", "MR"],
 ", to process the original notebook expression from top to bottom, similar \
to the templates of XSLT."
}], "Text",
 CellID->30102],

Cell["\<\
Establish a default definition to discard anything not explicitly matched by \
other patterns. \
\>", "MathCaption",
 CellID->4265],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "transform", "]"}], ";"}]], "Input",
 CellLabel->"In[73]:=",
 CellID->21881],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", "___", "]"}], ":=", 
   RowBox[{"Sequence", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->31843],

Cell[TextData[{
 "The definition uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"], "[", "]"}]], "InlineFormula"],
 " since ",
 StyleBox["transform", "MR"],
 " will be applied recursively. The best \"null'' result is one that can \
dropped in the midst of a list of arguments without disrupting the syntax."
}], "Text",
 CellID->16710],

Cell["Start with the notebook expression itself.", "MathCaption",
 CellID->14508],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"contents_List", ",", "___"}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<html\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<body\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"transform", "/@", "content"}]}], "]"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[75]:=",
 CellID->26489],

Cell[TextData[StyleBox["Note:",
 FontWeight->"Bold"]], "Text",
 CellID->10184],

Cell[TextData[{
 "The argument pattern must be robust enough to accept all variants. (Even \
though the notebook options are discarded in this conversion, a ",
 Cell[BoxData[
  ButtonBox["BlankNullSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankNullSequence"]], "InlineFormula"],
 " (",
 StyleBox["___", "MR"],
 ") is included to allow for them)."
}], "BulletedText",
 CellID->18121],

Cell[TextData[{
 "The only thing done with the ",
 StyleBox["contents", "Input",
  FontWeight->"Plain"],
 " argument is to pass it back to ",
 StyleBox["transform", "MR"],
 " ."
}], "BulletedText",
 CellID->10106],

Cell[TextData[{
 "The third argument is ",
 StyleBox["always",
  FontSlant->"Italic"],
 " a ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". Forgetting this is a common pitfall."
}], "BulletedText",
 CellID->23987],

Cell[CellGroupData[{

Cell[TextData[{
 "Those familiar with HTML will notice that we have dropped the ",
 StyleBox["head", "MR"],
 " element."
}], "BulletedText",
 CellID->31371],

Cell["\<\
The same general theme is followed for the remaining definitions.\
\>", "Text",
 CellID->32490],

Cell["\<\
Discard cell-grouping information, since the HTML has no use for it.\
\>", "MathCaption",
 CellID->24972],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"CellGroupData", "[", 
      RowBox[{"contents_List", ",", "___"}], "]"}], "]"}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"(", 
     RowBox[{"transform", "/@", "contents"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[76]:=",
 CellID->10518],

Cell[TextData[{
 "Translate to",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " sectional heads their HTML counterparts."
}], "MathCaption",
 CellID->2073],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"title_String", ",", "\"\<Title\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<h1\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "title", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"title_String", ",", "\"\<Section\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<h2\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "title", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[77]:=",
 CellID->32353],

Cell[TextData[{
 "Since the contents of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["Text", "MR"],
 "-style cell can be a simple string or a ",
 Cell[BoxData["TextData"], "InlineFormula"],
 "-wrapped list if the text has substructure of its own, create a definition \
for both cases."
}], "MathCaption",
 CellID->1281],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"contents_String", ",", "\"\<Text\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<p\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "contents", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"TextData", "[", "contents_List", "]"}], ",", "\"\<Text\>\""}], 
     "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<p\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"transform", "/@", "contents"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[79]:=",
 CellID->2662],

Cell["Simple strings should just be passed on.", "MathCaption",
 CellID->27996],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", "contents_String", "]"}], ":=", "contents"}], 
  ";"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->28213],

Cell["Deal with (simple) font changes.", "MathCaption",
 CellID->9451],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"StyleBox", "[", 
     RowBox[{"contents_String", ",", 
      RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<i\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "contents", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"transform", "[", 
    RowBox[{"StyleBox", "[", 
     RowBox[{"contents_String", ",", 
      RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "]"}], "]"}], ":=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<b\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "contents", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[82]:=",
 CellID->29115],

Cell["Here is the final product.", "MathCaption",
 CellID->8804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "=", 
  RowBox[{"transform", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[84]:=",
 CellID->19785],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"html\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"body\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"h1\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"Quotations\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"h2\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"Shakespeare\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"p\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\<\"Now is the winter of our discontent made glorious \
summer by this \"\>", ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"i\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Son of York\"\>", "}"}]}], "]"}], 
            ",", "\<\".  And all the clouds that lowered on our house, in the \
Ocean's deep bosum buried.\"\>"}], "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"p\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\<\"Forgive me, though bleeding piece of earth, that I am \
meek and gentle with these butchers.  Thou art the ruinest of the noblest man \
that ever lived in the tide of time.  Woe to the hands \"\>", ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"b\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"that shed this costy blood\"\>", "}"}]}], 
             "]"}], ",", "\<\"!\"\>"}], "}"}]}], "]"}]}], "}"}]}], "]"}], 
    "}"}]}], "]"}]], "Output",
 ImageSize->{576, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[84]=",
 CellID->20333]
}, Open  ]],

Cell[TextData[{
 "Get output in a more human-readable form by using ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->21564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"result", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->10504],

Cell[BoxData["\<\"<html>\\n <body>\\n  <h1>Quotations</h1>\\n  \
<h2>Shakespeare</h2>\\n  <p>Now is the winter of our discontent made glorious \
summer by this <i>Son of York</i>.  And all the clouds that lowered on our \
house, in the Ocean&apos;s deep bosum buried.</p>\\n  <p>Forgive me, though \
bleeding piece of earth, that I am meek and gentle with these butchers.  Thou \
art the ruinest of the noblest man that ever lived in the tide of time.  Woe \
to the hands <b>that shed this costy blood</b>!</p>\\n \
</body>\\n</html>\"\>"], "Output",
 ImageSize->{564, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[379]=",
 CellID->12837]
}, Open  ]],

Cell["Verify that this is well-formed XML.", "MathCaption",
 CellID->11453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLErrors", "[", "result", "]"}]], "Input",
 CellLabel->"In[88]:=",
 CellID->13784],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[88]=",
 CellID->16333]
}, Open  ]],

Cell["\<\
The symbolic XML can be exported to a file, suitable for viewing with a web \
browser.\
\>", "MathCaption",
 CellID->16972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Quotes.html\>\"", ",", "result", ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[89]:=",
 CellID->26921],

Cell[BoxData["\<\"Quotes.html\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[89]=",
 CellID->31544]
}, Open  ]],

Cell[TextData[{
 "An alternative is to apply a list of replacement rules using ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 " (",
 StyleBox["//.", "MR"],
 ")."
}], "MathCaption",
 CellID->15370],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb2html", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Notebook", "[", 
       RowBox[{"contents_List", ",", "___"}], "]"}], "->", 
      "\[IndentingNewLine]", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<html\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\"\<body\>\"", ",", 
           RowBox[{"{", "}"}], ",", "contents"}], "]"}], "}"}]}], "]"}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", "contents___", "}"}], ",", "___"}], "]"}], "]"}], "->", 
      "contents"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"title_", ",", "\"\<Title\>\""}], "]"}], "->", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<h1\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "title", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"title_", ",", "\"\<Section\>\""}], "]"}], "->", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<h2\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "title", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"contents_", ",", "\"\<Text\>\""}], "]"}], "->", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<p\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "contents", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]",
      
     RowBox[{
      RowBox[{"TextData", "[", 
       RowBox[{"{", "contents___", "}"}], "]"}], "->", "contents"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StyleBox", "[", 
       RowBox[{"contents_", ",", 
        RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], "->", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<i\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "contents", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]",
      
     RowBox[{
      RowBox[{"StyleBox", "[", 
       RowBox[{"contents_", ",", 
        RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "]"}], "->", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<b\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "contents", "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}], "\n", 
 RowBox[{"result2", "=", 
  RowBox[{"data", "//.", "nb2html"}]}]}], "Input",
 CellLabel->"In[90]:=",
 CellID->13257],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"html\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"body\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"h1\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"Quotations\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"h2\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"Shakespeare\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"p\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\<\"Now is the winter of our discontent made glorious \
summer by this \"\>", ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"i\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Son of York\"\>", "}"}]}], "]"}], 
            ",", "\<\".  And all the clouds that lowered on our house, in the \
Ocean's deep bosum buried.\"\>"}], "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"p\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\<\"Forgive me, though bleeding piece of earth, that I am \
meek and gentle with these butchers.  Thou art the ruinest of the noblest man \
that ever lived in the tide of time.  Woe to the hands \"\>", ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"b\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"that shed this costy blood\"\>", "}"}]}], 
             "]"}], ",", "\<\"!\"\>"}], "}"}]}], "]"}]}], "}"}]}], "]"}], 
    "}"}]}], "]"}]], "Output",
 ImageSize->{576, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[90]=",
 CellID->88]
}, Open  ]],

Cell["The two methods produce identical results.", "MathCaption",
 CellID->6129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "===", "result2"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->20297],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->3340]
}, Open  ]],

Cell["Here is how the two methods differ.", "Text",
 CellID->19923]
}, Open  ]],

Cell[TextData[{
 "Since the recursion occurs implicitly via ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 ", the latter implementation is cleaner in spots. In particular, contrast \
the handling of ",
 StyleBox["Text", "MR"],
 StyleBox[" ",
  FontFamily->"Times New Roman"],
 "cells: the ",
 Cell[BoxData["TextData"], "InlineFormula"],
 " rule can be separated from the ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " rule. The same could be accomplished for the recursive function, but at \
the cost of additional patterns for the various forms that ",
 StyleBox["contents", "MR"],
 " might take (for example, ",
 Cell[BoxData["_List"], "InlineFormula"],
 " versus ",
 Cell[BoxData["_String"], "InlineFormula"],
 " and so on). ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 ", by acting on all subexpressions, obviates this need."
}], "BulletedText",
 CellID->27901],

Cell[CellGroupData[{

Cell[TextData[{
 "There is no default rule for the second method. Any unhandled parts of the \
original ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression will pass through unchanged, probably rendering invalid XML."
}], "BulletedText",
 CellID->15343],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " to remove the definitions of all the symbols. "
}], "MathCaption",
 CellID->5876],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "nb", ",", "data", ",", "transform", ",", "result", ",", "nb2html", ",", 
    "result2"}], "]"}], ";"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->1731]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verifying Symbolic XML Syntax", "Section",
 CellID->27500],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["XML`SymbolicXMLErrors",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/SymbolicXMLErrors"]], "InlineFormula"],
 " to find errors in a symbolic XML expression. This function returns a part \
specification that you can use with functions like ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " to access the problematic part of your symbolic XML expression."
}], "Text",
 CellID->15648],

Cell["\<\
Import an XML file containing data about the American League hitters.\
\>", "MathCaption",
 CellID->13613],

Cell[BoxData[
 RowBox[{
  RowBox[{"AL", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/ALHitters.xml\>\"", ",", "\"\<XML\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[95]:=",
 CellID->253],

Cell["\<\
Assume that any player whose salary is \"#N/A\". is making $1,000,000. \
Perform the transformation, but we make an easily overlooked mistake and use \
the string \"1000000\" as the third element, rather than a list containing \
that string.\
\>", "MathCaption",
 CellID->20311],

Cell[BoxData[
 RowBox[{
  RowBox[{"AL", "=", 
   RowBox[{"AL", "/.", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<Salary\>\"", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\"\<#N/A\>\"", "}"}]}], "]"}], "\[Rule]", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\"\<Salary\>\"", ",", 
       RowBox[{"{", "}"}], ",", "\"\<1000000\>\""}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[96]:=",
 CellID->9693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " produces errors when writing modified XML to a file. Use ",
 Cell[BoxData[
  ButtonBox["SymbolicXMLErrors",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/SymbolicXMLErrors"]], "InlineFormula"],
 " to find the problematic expressions."
}], "MathCaption",
 CellID->6332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ALerrors", "=", 
  RowBox[{"XML`SymbolicXMLErrors", "[", "AL", "]"}]}]], "Input",
 CellLabel->"In[97]:=",
 CellID->27451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{507, 373},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->487792580]
}, Open  ]],

Cell[TextData[{
 StyleBox["XMLElement::name", "MR"],
 " messages are the first indication that something is wrong. The output of \
",
 Cell[BoxData[
  ButtonBox["SymbolicXMLErrors",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/SymbolicXMLErrors"]], "InlineFormula"],
 ", however, shows exactly where something went wrong. ",
 StyleBox["ALerrors", "MR"],
 " now contains a list of part specifications where the errors occurred. \
Examine the first error."
}], "MathCaption",
 CellID->31599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", "ALerrors", "]"}]], "Input",
 CellLabel->"In[98]:=",
 CellID->216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "39", ",", "3", ",", "35"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[410]=",
 CellID->23212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"AL", ",", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"First", "[", "ALerrors", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[99]:=",
 CellID->6834],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"Salary\"\>", ",", 
   RowBox[{"{", "}"}], ",", "\<\"1000000\"\>"}], "]"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[99]=",
 CellID->3849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"FoldList", "[", 
    RowBox[{"Part", ",", "AL", ",", 
     RowBox[{"First", "[", "ALerrors", "]"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"s_", ",", "__"}], "]"}], "\[Rule]", "s"}]}], "]"}]], "Input",
 CellLabel->"In[100]:=",
 CellID->32252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AmericanLeagueIndividualHitters\"\>", 
   ",", "\<\"PlayerRecord\"\>", ",", "\<\"Salary\"\>"}], "}"}]], "Output",
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[100]=",
 CellID->20912]
}, Open  ]],

Cell["This problem is easy enough to fix.", "MathCaption",
 CellID->10141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Part", "[", 
   RowBox[{"AL", ",", 
    RowBox[{"Sequence", "@@", 
     RowBox[{"First", "[", "ALerrors", "]"}]}]}], "]"}], "=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Part", "[", 
    RowBox[{"AL", ",", 
     RowBox[{"Sequence", "@@", 
      RowBox[{"First", "[", "ALerrors", "]"}]}]}], "]"}], "/.", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<Salary\>\"", ",", "p_", ",", "s_String"}], "]"}], "\[Rule]",
     
    RowBox[{"XMLElement", "[", 
     RowBox[{"\"\<Salary\>\"", ",", "p", ",", 
      RowBox[{"{", "s", "}"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[101]:=",
 CellID->23209],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"Salary\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "\<\"1000000\"\>", "}"}]}], "]"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[101]=",
 CellID->27450]
}, Open  ]],

Cell["The rest of the errors are of the same nature.", "MathCaption",
 CellID->9180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"AL", ",", 
   RowBox[{"Rest", "[", "ALerrors", "]"}]}], "]"}]], "Input",
 CellLabel->"In[102]:=",
 CellID->17569],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 747},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[102]=",
 CellID->336237564]
}, Open  ]],

Cell[TextData[{
 "Use",
 StyleBox[" ",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to fix the rest of the errors in the same way."
}], "MathCaption",
 CellID->4562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"AL", ",", 
        RowBox[{"Sequence", "@@", "#"}]}], "]"}], "=", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"AL", ",", 
         RowBox[{"Sequence", "@@", "#"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\"\<Salary\>\"", ",", "p_", ",", "s_String"}], "]"}], 
        "\[Rule]", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\"\<Salary\>\"", ",", "p", ",", 
          RowBox[{"{", "s", "}"}]}], "]"}]}]}]}], ")"}], "&"}], ",", 
   "\[IndentingNewLine]", "ALerrors"}], "]"}]], "Input",
 CellLabel->"In[103]:=",
 CellID->23365],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{476, 747},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[103]=",
 CellID->341584345]
}, Open  ]],

Cell[TextData[{
 "Verify that the mistake is fixed using ",
 Cell[BoxData[
  ButtonBox["SymbolicXMLErrors",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/SymbolicXMLErrors"]], "InlineFormula"],
 " again."
}], "MathCaption",
 CellID->12817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`SymbolicXMLErrors", "[", "AL", "]"}]], "Input",
 CellLabel->"In[104]:=",
 CellID->11011],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[104]=",
 CellID->763]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->273866680],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "RelatedTutorials",
 CellID->1866278227],

Cell[TextData[ButtonBox["Representing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/RepresentingXML"]], "RelatedTutorials",
 CellID->1368766954],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "RelatedTutorials",
 CellID->296442083],

Cell[TextData[ButtonBox["Exporting XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ExportingXML"]], "RelatedTutorials",
 CellID->523248764],

Cell[TextData[ButtonBox["MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transforming XML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 46.8125390}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Tutorial", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "Mathematica is uniquely suited for processing symbolic expressions \
because of its powerful pattern-matching abilities and large collection of \
built-in structural manipulation functions. This tutorial provides a few \
examples to illustrate the use of Mathematica for processing XML data. When \
you import an arbitrary XML document into Mathematica, it is automatically \
converted into a symbolic XML expression. Symbolic XML is the format used for \
representing XML documents in Mathematica syntax. The conversion to symbolic \
XML translates the XML document into a Mathematica expression, while \
preserving its structure. The advantage of converting XML data into symbolic \
XML is that you can directly manipulate symbolic XML using any of \
Mathematica's built-in functions. Convert an XML string into symbolic XML.", 
    "synonyms" -> {}, "title" -> "Transforming XML", "type" -> "Tutorial", 
    "uri" -> "XML/tutorial/TransformingXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1120, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1745, 52, 71, 2, 70, "Title",
 PageBreakAbove->True,
 CellID->3388],
Cell[CellGroupData[{
Cell[1841, 58, 46, 1, 70, "Section",
 CellID->2497],
Cell[1890, 61, 419, 11, 70, "Text",
 CellID->27711],
Cell[2312, 74, 725, 19, 70, "Text",
 CellID->11091],
Cell[3040, 95, 79, 1, 70, "MathCaption",
 CellID->11874],
Cell[CellGroupData[{
Cell[3144, 100, 230, 7, 28, "Input",
 CellID->18563],
Cell[3377, 109, 1201, 35, 71, "Output",
 CellID->9125]
}, Open  ]],
Cell[4593, 147, 177, 4, 70, "MathCaption",
 CellID->7007],
Cell[CellGroupData[{
Cell[4795, 155, 259, 8, 28, "Input",
 CellID->18370],
Cell[5057, 165, 900, 27, 54, "Output",
 CellID->15121]
}, Open  ]],
Cell[5972, 195, 278, 9, 70, "MathCaption",
 CellID->7727],
Cell[CellGroupData[{
Cell[6275, 208, 142, 4, 70, "Input",
 CellID->2658],
Cell[6420, 214, 216, 6, 105, "Output",
 CellID->24336]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6685, 226, 59, 1, 70, "Section",
 CellID->18275],
Cell[6747, 229, 319, 8, 70, "Text",
 CellID->1221],
Cell[7069, 239, 869, 25, 70, "Text",
 CellID->11576],
Cell[7941, 266, 1693, 47, 70, "Input",
 CellID->1799],
Cell[9637, 315, 463, 16, 70, "Text",
 CellID->24919],
Cell[10103, 333, 1214, 37, 70, "Text",
 CellID->14241],
Cell[11320, 372, 620, 14, 70, "Text",
 CellID->28611],
Cell[11943, 388, 1259, 36, 70, "Input",
 CellID->5712],
Cell[13205, 426, 990, 29, 70, "Input",
 CellID->30209],
Cell[14198, 457, 505, 14, 70, "Text",
 CellID->23635],
Cell[14706, 473, 625, 19, 70, "Input",
 CellID->23263],
Cell[15334, 494, 110, 3, 70, "MathCaption",
 CellID->17830],
Cell[CellGroupData[{
Cell[15469, 501, 354, 12, 70, "Input",
 CellID->8514],
Cell[15826, 515, 4607, 109, 190, "Output",
 CellID->3336]
}, Open  ]],
Cell[CellGroupData[{
Cell[20470, 629, 388, 12, 70, "Input",
 CellID->5783],
Cell[20861, 643, 371, 12, 36, "Output",
 CellID->31032]
}, Open  ]],
Cell[21247, 658, 609, 17, 70, "Text",
 CellID->24988]
}, Open  ]],
Cell[CellGroupData[{
Cell[21893, 680, 55, 1, 70, "Section",
 CellID->3339],
Cell[21951, 683, 320, 6, 70, "Text",
 CellID->23705],
Cell[22274, 691, 346, 8, 70, "Text",
 CellID->14670],
Cell[22623, 701, 147, 6, 70, "MathCaption",
 CellID->15940],
Cell[22773, 709, 176, 6, 70, "Input",
 CellID->9868],
Cell[22952, 717, 297, 10, 70, "MathCaption",
 CellID->28391],
Cell[23252, 729, 290, 9, 70, "Input",
 CellID->7728],
Cell[CellGroupData[{
Cell[23567, 742, 104, 3, 70, "Input",
 CellID->4985],
Cell[23674, 747, 156, 5, 36, "Output",
 CellID->5537]
}, Open  ]],
Cell[23845, 755, 496, 14, 70, "MathCaption",
 CellID->26320],
Cell[24344, 771, 547, 14, 70, "Input",
 CellID->13124],
Cell[CellGroupData[{
Cell[24916, 789, 105, 3, 70, "Input",
 CellID->30997],
Cell[25024, 794, 155, 5, 36, "Output",
 CellID->9354]
}, Open  ]],
Cell[25194, 802, 243, 8, 70, "MathCaption",
 CellID->28703],
Cell[CellGroupData[{
Cell[25462, 814, 103, 3, 70, "Input",
 CellID->5494],
Cell[25568, 819, 6580, 167, 343, "Output",
 CellID->30562]
}, Open  ]],
Cell[32163, 989, 259, 9, 70, "MathCaption",
 CellID->23865],
Cell[CellGroupData[{
Cell[32447, 1002, 387, 11, 70, "Input",
 CellID->17554],
Cell[32837, 1015, 178, 5, 36, "Output",
 CellID->20700]
}, Open  ]],
Cell[33030, 1023, 237, 10, 70, "MathCaption",
 CellID->32302],
Cell[CellGroupData[{
Cell[33292, 1037, 498, 14, 70, "Input",
 CellID->29714],
Cell[33793, 1053, 844, 17, 105, "Output",
 CellID->31629]
}, Open  ]],
Cell[34652, 1073, 257, 10, 70, "MathCaption",
 CellID->16794],
Cell[CellGroupData[{
Cell[34934, 1087, 505, 13, 70, "Input",
 CellID->21026],
Cell[35442, 1102, 844, 17, 105, "Output",
 CellID->20463]
}, Open  ]],
Cell[36301, 1122, 345, 8, 70, "Text",
 CellID->528],
Cell[36649, 1132, 160, 4, 70, "MathCaption",
 CellID->31748],
Cell[36812, 1138, 178, 6, 70, "Input",
 CellID->25679],
Cell[36993, 1146, 402, 13, 70, "Input",
 CellID->21351],
Cell[37398, 1161, 156, 6, 70, "Input",
 CellID->20199],
Cell[37557, 1169, 361, 11, 70, "Input",
 CellID->3],
Cell[37921, 1182, 369, 11, 70, "Input",
 CellID->18442],
Cell[38293, 1195, 493, 15, 70, "Input",
 CellID->19280],
Cell[CellGroupData[{
Cell[38811, 1214, 137, 4, 70, "Input",
 CellID->10016],
Cell[38951, 1220, 2497, 45, 122, "Output",
 CellID->15290]
}, Open  ]],
Cell[41463, 1268, 219, 8, 70, "Text",
 CellID->15098],
Cell[41685, 1278, 371, 7, 70, "Text",
 CellID->9858],
Cell[42059, 1287, 145, 5, 70, "MathCaption",
 CellID->1730],
Cell[42207, 1294, 562, 16, 70, "Input",
 CellID->8553],
Cell[42772, 1312, 152, 4, 70, "MathCaption",
 CellID->29551],
Cell[42927, 1318, 930, 24, 70, "Input",
 CellID->23262],
Cell[CellGroupData[{
Cell[43882, 1346, 508, 17, 70, "Input",
 CellID->444],
Cell[44393, 1365, 924, 25, 182, "Output",
 CellID->21649]
}, Open  ]],
Cell[45332, 1393, 160, 4, 70, "MathCaption",
 CellID->10485],
Cell[45495, 1399, 229, 7, 70, "Input",
 CellID->7055],
Cell[45727, 1408, 536, 17, 70, "Input",
 CellID->12572],
Cell[CellGroupData[{
Cell[46288, 1429, 512, 17, 70, "Input",
 CellID->12889],
Cell[46803, 1448, 928, 25, 182, "Output",
 CellID->2858]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47780, 1479, 55, 1, 70, "Section",
 CellID->17552],
Cell[CellGroupData[{
Cell[47860, 1484, 74, 1, 70, "Subsection",
 CellID->129],
Cell[47937, 1487, 625, 17, 70, "Text",
 CellID->14640],
Cell[48565, 1506, 114, 3, 70, "MathCaption",
 CellID->6860],
Cell[CellGroupData[{
Cell[48704, 1513, 135, 5, 70, "Input",
 Evaluatable->False,
 CellID->8046],
Cell[48842, 1520, 1626, 46, 660, "Output",
 CellID->28627]
}, Open  ]],
Cell[50483, 1569, 145, 6, 70, "MathCaption",
 CellID->5044],
Cell[50631, 1577, 179, 6, 70, "Input",
 CellID->6422],
Cell[50813, 1585, 294, 10, 70, "MathCaption",
 CellID->25936],
Cell[51110, 1597, 99, 3, 70, "Input",
 CellID->7473],
Cell[51212, 1602, 516, 15, 70, "MathCaption",
 CellID->19154],
Cell[51731, 1619, 2583, 63, 70, "Input",
 CellID->333],
Cell[54317, 1684, 157, 4, 70, "MathCaption",
 CellID->8756],
Cell[CellGroupData[{
Cell[54499, 1692, 146, 4, 70, "Input",
 CellID->11051],
Cell[54648, 1698, 57127, 1752, 70, 52315, 1669, "GraphicsData", "PostScript", \
"Graphics",
 CellID->25391]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111824, 3456, 60, 1, 70, "Subsection",
 CellID->16534],
Cell[111887, 3459, 740, 18, 70, "Text",
 CellID->23931],
Cell[112630, 3479, 187, 6, 70, "Text",
 CellID->22322],
Cell[CellGroupData[{
Cell[112842, 3489, 426, 11, 70, "Input",
 CellID->27079],
Cell[113271, 3502, 615, 17, 36, "Output",
 CellID->8202]
}, Open  ]],
Cell[113901, 3522, 673, 22, 70, "Text",
 CellID->11176],
Cell[114577, 3546, 786, 24, 70, "Input",
 CellID->21580],
Cell[115366, 3572, 821, 23, 70, "Text",
 CellID->13269],
Cell[CellGroupData[{
Cell[116212, 3599, 429, 11, 70, "Input",
 CellID->5388],
Cell[116644, 3612, 3789, 93, 173, "Output",
 CellID->3429]
}, Open  ]],
Cell[120448, 3708, 517, 15, 70, "Text",
 CellID->15885],
Cell[120968, 3725, 369, 15, 70, "Text",
 CellID->22002],
Cell[121340, 3742, 220, 8, 70, "Text",
 CellID->27610],
Cell[121563, 3752, 666, 19, 70, "Input",
 CellID->16327],
Cell[122232, 3773, 703, 21, 70, "Input",
 CellID->14274],
Cell[122938, 3796, 704, 20, 70, "Input",
 CellID->5760],
Cell[123645, 3818, 910, 29, 70, "Text",
 CellID->99],
Cell[124558, 3849, 393, 13, 70, "Text",
 CellID->25042],
Cell[124954, 3864, 758, 22, 70, "Input",
 CellID->3055],
Cell[125715, 3888, 592, 21, 70, "Text",
 CellID->24393],
Cell[126310, 3911, 280, 9, 70, "Input",
 CellID->31065],
Cell[126593, 3922, 266, 8, 70, "Input",
 CellID->4928],
Cell[126862, 3932, 335, 10, 70, "Input",
 CellID->24572],
Cell[127200, 3944, 183, 6, 70, "Input",
 CellID->29284],
Cell[127386, 3952, 136, 5, 70, "Text",
 CellID->14726],
Cell[127525, 3959, 2585, 63, 70, "Input",
 CellID->28798],
Cell[130113, 4024, 624, 25, 70, "Text",
 CellID->20523],
Cell[130740, 4051, 628, 23, 70, "Text",
 CellID->26201],
Cell[131371, 4076, 312, 10, 70, "Input",
 CellID->31587],
Cell[CellGroupData[{
Cell[131708, 4090, 514, 14, 70, "Input",
 CellID->4088],
Cell[132225, 4106, 2263, 68, 139, "Output",
 CellID->1997]
}, Open  ]],
Cell[134503, 4177, 935, 28, 70, "Text",
 CellID->11652],
Cell[135441, 4207, 655, 25, 70, "Text",
 CellID->19175],
Cell[136099, 4234, 340, 11, 70, "Input",
 CellID->25750],
Cell[136442, 4247, 568, 17, 70, "Input",
 CellID->10678],
Cell[137013, 4266, 127, 4, 70, "Text",
 CellID->11455],
Cell[CellGroupData[{
Cell[137165, 4274, 146, 4, 70, "Input",
 CellID->20893],
Cell[137314, 4280, 57915, 1765, 70, 52315, 1669, "GraphicsData", \
"PostScript", "Graphics",
 CellID->10630]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[195290, 6052, 123, 6, 70, "Section",
 CellID->7406],
Cell[195416, 6060, 614, 13, 70, "Text",
 CellID->9531],
Cell[CellGroupData[{
Cell[196055, 6077, 55, 1, 70, "Subsection",
 CellID->10489],
Cell[196113, 6080, 342, 10, 70, "Text",
 CellID->15165],
Cell[CellGroupData[{
Cell[196480, 6094, 183, 3, 70, "IndentedText",
 CellID->4521],
Cell[196666, 6099, 147, 6, 70, "Text",
 CellID->30127],
Cell[196816, 6107, 479, 14, 70, "Input",
 CellID->9964],
Cell[197298, 6123, 423, 13, 70, "Input",
 CellID->440]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[197770, 6142, 64, 1, 70, "Subsection",
 CellID->21113],
Cell[197837, 6145, 484, 11, 70, "Text",
 CellID->30389],
Cell[CellGroupData[{
Cell[198346, 6160, 239, 3, 70, "IndentedText",
 CellID->22710],
Cell[198588, 6165, 265, 10, 70, "Text",
 CellID->20488],
Cell[198856, 6177, 131, 6, 70, "Text",
 CellID->13763],
Cell[198990, 6185, 959, 27, 70, "Input",
 CellID->30320]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[199998, 6218, 53, 1, 70, "Subsection",
 CellID->8188],
Cell[200054, 6221, 531, 17, 70, "Text",
 CellID->23821],
Cell[CellGroupData[{
Cell[200610, 6242, 690, 10, 70, "IndentedText",
 CellID->17264],
Cell[201303, 6254, 854, 28, 70, "Text",
 CellID->6003],
Cell[202160, 6284, 2933, 76, 70, "Input",
 CellID->9754],
Cell[CellGroupData[{
Cell[205118, 6364, 249, 8, 70, "Input",
 CellID->14722],
Cell[205370, 6374, 200, 7, 36, "Output",
 CellID->25316]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[205631, 6388, 55, 1, 70, "Subsection",
 CellID->5854],
Cell[205689, 6391, 473, 9, 70, "Text",
 CellID->6586],
Cell[206165, 6402, 384, 7, 70, "Text",
 CellID->26425],
Cell[206552, 6411, 221, 7, 70, "Text",
 CellID->9524],
Cell[CellGroupData[{
Cell[206798, 6422, 450, 10, 70, "Input",
 CellID->15818],
Cell[207251, 6434, 1829, 50, 105, "Output",
 CellID->27302]
}, Open  ]],
Cell[209095, 6487, 290, 7, 70, "Text",
 CellID->30120],
Cell[CellGroupData[{
Cell[209410, 6498, 265, 4, 70, "IndentedText",
 CellID->32659],
Cell[209678, 6504, 473, 12, 70, "Text",
 CellID->488],
Cell[CellGroupData[{
Cell[210176, 6520, 191, 6, 70, "Input",
 CellID->30682],
Cell[210370, 6528, 337, 10, 36, "Output",
 CellID->18341]
}, Open  ]],
Cell[210722, 6541, 718, 21, 70, "Text",
 CellID->2574],
Cell[211443, 6564, 566, 17, 70, "Input",
 CellID->6500],
Cell[CellGroupData[{
Cell[212034, 6585, 379, 11, 70, "Input",
 CellID->25566],
Cell[212416, 6598, 158, 5, 36, "Output",
 CellID->26222]
}, Open  ]],
Cell[212589, 6606, 151, 6, 70, "Text",
 CellID->5754],
Cell[212743, 6614, 100, 3, 70, "Input",
 CellID->1552],
Cell[212846, 6619, 1511, 41, 70, "Input",
 CellID->850],
Cell[CellGroupData[{
Cell[214382, 6664, 259, 8, 70, "Input",
 CellID->1516],
Cell[214644, 6674, 188, 5, 36, "Output",
 CellID->13226]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[214905, 6687, 64, 1, 70, "Section",
 CellID->23486],
Cell[214972, 6690, 970, 21, 70, "Text",
 CellID->6602],
Cell[215945, 6713, 218, 6, 70, "Text",
 CellID->7737],
Cell[216166, 6721, 66, 1, 70, "MathCaption",
 CellID->28901],
Cell[216235, 6724, 290, 10, 70, "Input",
 CellID->17901],
Cell[CellGroupData[{
Cell[216550, 6738, 131, 4, 70, "Input",
 CellID->22749],
Cell[216684, 6744, 2856, 70, 479, "Output",
 CellID->15967]
}, Open  ]],
Cell[219555, 6817, 215, 6, 70, "Text",
 CellID->30102],
Cell[219773, 6825, 141, 4, 70, "MathCaption",
 CellID->4265],
Cell[219917, 6831, 124, 4, 70, "Input",
 CellID->21881],
Cell[220044, 6837, 178, 6, 70, "Input",
 CellID->31843],
Cell[220225, 6845, 406, 12, 70, "Text",
 CellID->16710],
Cell[220634, 6859, 81, 1, 70, "MathCaption",
 CellID->14508],
Cell[220718, 6862, 514, 16, 70, "Input",
 CellID->26489],
Cell[221235, 6880, 78, 2, 70, "Text",
 CellID->10184],
Cell[221316, 6884, 400, 11, 70, "BulletedText",
 CellID->18121],
Cell[221719, 6897, 213, 8, 70, "BulletedText",
 CellID->10106],
Cell[221935, 6907, 283, 11, 70, "BulletedText",
 CellID->23987],
Cell[CellGroupData[{
Cell[222243, 6922, 156, 5, 70, "BulletedText",
 CellID->31371],
Cell[222402, 6929, 105, 3, 70, "Text",
 CellID->32490],
Cell[222510, 6934, 115, 3, 70, "MathCaption",
 CellID->24972],
Cell[222628, 6939, 361, 11, 70, "Input",
 CellID->10518],
Cell[222992, 6952, 161, 6, 70, "MathCaption",
 CellID->2073],
Cell[223156, 6960, 668, 20, 70, "Input",
 CellID->32353],
Cell[223827, 6982, 344, 11, 70, "MathCaption",
 CellID->1281],
Cell[224174, 6995, 725, 22, 70, "Input",
 CellID->2662],
Cell[224902, 7019, 79, 1, 70, "MathCaption",
 CellID->27996],
Cell[224984, 7022, 169, 6, 70, "Input",
 CellID->28213],
Cell[225156, 7030, 70, 1, 70, "MathCaption",
 CellID->9451],
Cell[225229, 7033, 757, 22, 70, "Input",
 CellID->29115],
Cell[225989, 7057, 64, 1, 70, "MathCaption",
 CellID->8804],
Cell[CellGroupData[{
Cell[226078, 7062, 133, 4, 70, "Input",
 CellID->19785],
Cell[226214, 7068, 1982, 49, 173, "Output",
 CellID->20333]
}, Open  ]],
Cell[228211, 7120, 237, 8, 70, "MathCaption",
 CellID->21564],
Cell[CellGroupData[{
Cell[228473, 7132, 143, 4, 70, "Input",
 CellID->10504],
Cell[228619, 7138, 680, 12, 224, "Output",
 CellID->12837]
}, Open  ]],
Cell[229314, 7153, 75, 1, 70, "MathCaption",
 CellID->11453],
Cell[CellGroupData[{
Cell[229414, 7158, 115, 3, 70, "Input",
 CellID->13784],
Cell[229532, 7163, 172, 6, 36, "Output",
 CellID->16333]
}, Open  ]],
Cell[229719, 7172, 133, 4, 70, "MathCaption",
 CellID->16972],
Cell[CellGroupData[{
Cell[229877, 7180, 168, 5, 70, "Input",
 CellID->26921],
Cell[230048, 7187, 173, 5, 36, "Output",
 CellID->31544]
}, Open  ]],
Cell[230236, 7195, 286, 10, 70, "MathCaption",
 CellID->15370],
Cell[CellGroupData[{
Cell[230547, 7209, 2608, 70, 70, "Input",
 CellID->13257],
Cell[233158, 7281, 1979, 49, 173, "Output",
 CellID->88]
}, Open  ]],
Cell[235152, 7333, 80, 1, 70, "MathCaption",
 CellID->6129],
Cell[CellGroupData[{
Cell[235257, 7338, 102, 3, 70, "Input",
 CellID->20297],
Cell[235362, 7343, 157, 5, 36, "Output",
 CellID->3340]
}, Open  ]],
Cell[235534, 7351, 67, 1, 70, "Text",
 CellID->19923]
}, Open  ]],
Cell[235616, 7355, 1117, 32, 70, "BulletedText",
 CellID->27901],
Cell[CellGroupData[{
Cell[236758, 7391, 267, 7, 70, "BulletedText",
 CellID->15343],
Cell[237028, 7400, 222, 8, 70, "MathCaption",
 CellID->5876],
Cell[237253, 7410, 217, 7, 70, "Input",
 CellID->1731]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[237519, 7423, 64, 1, 70, "Section",
 CellID->27500],
Cell[237586, 7426, 643, 19, 70, "Text",
 CellID->15648],
Cell[238232, 7447, 116, 3, 70, "MathCaption",
 CellID->13613],
Cell[238351, 7452, 212, 7, 70, "Input",
 CellID->253],
Cell[238566, 7461, 288, 6, 70, "MathCaption",
 CellID->20311],
Cell[238857, 7469, 469, 14, 70, "Input",
 CellID->9693],
Cell[239329, 7485, 409, 12, 70, "MathCaption",
 CellID->6332],
Cell[CellGroupData[{
Cell[239763, 7501, 145, 4, 28, "Input",
 CellID->27451],
Cell[239911, 7507, 5647, 97, 394, "Output",
 Evaluatable->False,
 CellID->487792580]
}, Open  ]],
Cell[245573, 7607, 497, 13, 70, "MathCaption",
 CellID->31599],
Cell[CellGroupData[{
Cell[246095, 7624, 103, 3, 70, "Input",
 CellID->216],
Cell[246201, 7629, 234, 7, 36, "Output",
 CellID->23212]
}, Open  ]],
Cell[CellGroupData[{
Cell[246472, 7641, 193, 6, 70, "Input",
 CellID->6834],
Cell[246668, 7649, 270, 8, 36, "Output",
 CellID->3849]
}, Open  ]],
Cell[CellGroupData[{
Cell[246975, 7662, 336, 10, 70, "Input",
 CellID->32252],
Cell[247314, 7674, 286, 8, 36, "Output",
 CellID->20912]
}, Open  ]],
Cell[247615, 7685, 74, 1, 70, "MathCaption",
 CellID->10141],
Cell[CellGroupData[{
Cell[247714, 7690, 679, 21, 70, "Input",
 CellID->23209],
Cell[248396, 7713, 296, 9, 36, "Output",
 CellID->27450]
}, Open  ]],
Cell[248707, 7725, 84, 1, 70, "MathCaption",
 CellID->9180],
Cell[CellGroupData[{
Cell[248816, 7730, 164, 5, 28, "Input",
 CellID->17569],
Cell[248983, 7737, 6310, 107, 768, "Output",
 Evaluatable->False,
 CellID->336237564]
}, Open  ]],
Cell[255308, 7847, 266, 10, 70, "MathCaption",
 CellID->4562],
Cell[CellGroupData[{
Cell[255599, 7861, 762, 23, 65, "Input",
 CellID->23365],
Cell[256364, 7886, 6205, 106, 768, "Output",
 Evaluatable->False,
 CellID->341584345]
}, Open  ]],
Cell[262584, 7995, 246, 8, 70, "MathCaption",
 CellID->12817],
Cell[CellGroupData[{
Cell[262855, 8007, 116, 3, 70, "Input",
 CellID->11011],
Cell[262974, 8012, 171, 6, 36, "Output",
 CellID->763]
}, Open  ]],
Cell[CellGroupData[{
Cell[263182, 8023, 72, 1, 70, "RelatedTutorialsSection",
 CellID->273866680],
Cell[263257, 8026, 151, 3, 70, "RelatedTutorials",
 CellID->1866278227],
Cell[263411, 8031, 158, 3, 70, "RelatedTutorials",
 CellID->1368766954],
Cell[263572, 8036, 151, 3, 70, "RelatedTutorials",
 CellID->296442083],
Cell[263726, 8041, 151, 3, 70, "RelatedTutorials",
 CellID->523248764],
Cell[263880, 8046, 138, 3, 70, "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[264057, 8054, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

