(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13047,        486]
NotebookOptionsPosition[      9035,        360]
NotebookOutlinePosition[     10315,        393]
CellTagsIndexPosition[     10272,        390]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["3D Geometry & Modeling Formats", "GuideTitle",
 CellID->29891],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports import and export of 3D geometry from all standard formats\
\[LongDash]with its symbolic representation of 3D objects allowing immediate \
faithful interchange."
}], "GuideAbstract",
 CellID->329295746],

Cell[CellGroupData[{

Cell["3D Object Geometry Formats", "GuideFunctionsSubsection",
 CellID->21350097],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "PLY 3D geometry format (.ply)"
}], "GuideText",
 CellID->172311107],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"OFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OFF"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"NOFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NOFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D object file formats (.off, .coff, .noff, .cnoff)"
}], "GuideText",
 CellID->71925909],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BYU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BYU"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "BYU 3D geometry format (.byu)"
}], "GuideText",
 CellID->309987293],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"OBJ\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OBJ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Wavefront OBJ format (.obj)"
}], "GuideText",
 CellID->11371316]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D Viewing Formats", "GuideFunctionsSubsection",
 CellID->141419082],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "X3D XML geometry format (.x3d)"
}], "GuideText",
 CellID->545191897],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JVX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JVX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "JavaView format (.jvx)"
}], "GuideText",
 CellID->222359072],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"VRML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/VRML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Virtual Reality Modeling Language format (.vrml)"
}], "GuideText",
 CellID->102769620]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modeling & Rendering Formats", "GuideFunctionsSubsection",
 CellID->280013888],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Maya\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Maya entity files (.ma)"
}], "GuideText",
 CellID->116623581],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"POV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/POV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "POV-Ray ray-tracing object description format (.pov)"
}], "GuideText",
 CellID->9665034],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"LWO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/LWO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "LightWave 3D file format (.lwo)"
}], "GuideText",
 CellID->672908109],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"3DS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/3DS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D Studio format (.3ds)"
}], "GuideText",
 CellID->58520059],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RIB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RIB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Renderman interchange format (.rib)"
}], "GuideText",
 CellID->33895440]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAD-Related Formats", "GuideFunctionsSubsection",
 CellID->268767670],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DXF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DXF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "AutoCAD 2D & 3D formats (.dxf)"
}], "GuideText",
 CellID->7906207],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"STL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/STL"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "stereolithography format (.stl)"
}], "GuideText",
 CellID->846122815],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ZPR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZPR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Z Corp 3D printer format (.zpr)"
}], "GuideText",
 CellID->395686997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Molecular Models Formats \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScientificAndMedicalDataFormats"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->779508119],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XYZ\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XYZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MOL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MOL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->607568814],

Cell["\t", "GuideDelimiterSubsection",
 CellID->25011]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Data Elements", "GuideFunctionsSubsection",
 CellID->1560],

Cell["\<\
\"Graphics3D\" \[LongDash] graphics object that displays the 3D objects\
\>", "GuideText",
 CellID->239598923],

Cell[TextData[{
 "\"GraphicsComplex\"",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " object"
}], "GuideText",
 CellID->615563659],

Cell["\<\
\"VertexData\" \[LongDash] list of vertex coordinates\
\>", "GuideText",
 CellID->326371504],

Cell["\<\
\"VertexColors\" \[LongDash] colors at vertices\
\>", "GuideText",
 CellID->63727325]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->31540],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->76300026],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->310182235]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->13392],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAbout",
 CellID->13210],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->13549],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"3D Geometry & Modeling Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 29, 54.4343006}", "context" -> "", 
    "keywords" -> {
     "polygon mesh", "surface data", "surface graphics", "surface mesh", 
      "surface polygons", "surface triangulation"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica supports import and export of 3D geometry from all standard \
formats--with its symbolic representation of 3D objects allowing immediate \
faithful interchange.", "synonyms" -> {}, "title" -> 
    "3D Geometry & Modeling Formats", "type" -> "Guide", "uri" -> 
    "guide/3DGeometryAndModelingFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->29891],
Cell[690, 28, 279, 7, 70, "GuideAbstract",
 CellID->329295746],
Cell[CellGroupData[{
Cell[994, 39, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->21350097],
Cell[1078, 42, 259, 9, 70, "GuideText",
 CellID->172311107],
Cell[1340, 53, 410, 13, 70, "GuideText",
 CellID->71925909],
Cell[1753, 68, 259, 9, 70, "GuideText",
 CellID->309987293],
Cell[2015, 79, 256, 9, 70, "GuideText",
 CellID->11371316]
}, Open  ]],
Cell[CellGroupData[{
Cell[2308, 93, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->141419082],
Cell[2385, 96, 260, 9, 70, "GuideText",
 CellID->545191897],
Cell[2648, 107, 252, 9, 70, "GuideText",
 CellID->222359072],
Cell[2903, 118, 280, 9, 70, "GuideText",
 CellID->102769620]
}, Open  ]],
Cell[CellGroupData[{
Cell[3220, 132, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->280013888],
Cell[3307, 135, 255, 9, 70, "GuideText",
 CellID->116623581],
Cell[3565, 146, 280, 9, 70, "GuideText",
 CellID->9665034],
Cell[3848, 157, 261, 9, 70, "GuideText",
 CellID->672908109],
Cell[4112, 168, 252, 9, 70, "GuideText",
 CellID->58520059],
Cell[4367, 179, 264, 9, 70, "GuideText",
 CellID->33895440]
}, Open  ]],
Cell[CellGroupData[{
Cell[4668, 193, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->268767670],
Cell[4746, 196, 258, 9, 70, "GuideText",
 CellID->7906207],
Cell[5007, 207, 261, 9, 70, "GuideText",
 CellID->846122815],
Cell[5271, 218, 261, 9, 70, "GuideText",
 CellID->395686997]
}, Open  ]],
Cell[CellGroupData[{
Cell[5569, 232, 245, 6, 70, "GuideFunctionsSubsection",
 CellID->779508119],
Cell[5817, 240, 838, 24, 70, "InlineGuideFunctionListing",
 CellID->607568814],
Cell[6658, 266, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->25011]
}, Open  ]],
Cell[CellGroupData[{
Cell[6749, 272, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->1560],
Cell[6823, 275, 120, 3, 70, "GuideText",
 CellID->239598923],
Cell[6946, 280, 481, 17, 70, "GuideText",
 CellID->615563659],
Cell[7430, 299, 102, 3, 70, "GuideText",
 CellID->326371504],
Cell[7535, 304, 95, 3, 70, "GuideText",
 CellID->63727325]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7679, 313, 58, 1, 70, "GuideTutorialsSection",
 CellID->31540],
Cell[7740, 316, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[7915, 321, 173, 3, 70, "GuideTutorial",
 CellID->76300026],
Cell[8091, 326, 174, 3, 70, "GuideTutorial",
 CellID->310182235]
}, Open  ]],
Cell[CellGroupData[{
Cell[8302, 334, 59, 1, 70, "GuideMoreAboutSection",
 CellID->13392],
Cell[8364, 337, 156, 3, 70, "GuideMoreAbout",
 CellID->13210],
Cell[8523, 342, 148, 3, 70, "GuideMoreAbout",
 CellID->13549],
Cell[8674, 347, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[8835, 352, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],
Cell[9008, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

