(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13900,        445]
NotebookOptionsPosition[      9299,        324]
NotebookOutlinePosition[     11715,        374]
CellTagsIndexPosition[     11672,        371]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Algebraic Numbers", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " symbolic character allows it to provide deep integrated support for \
algebraic numbers. At the core are ",
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " objects, which provide exact implicit representations for arbitrary \
algebraic numbers. Using specially developed algorithms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " efficiently handles ",
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " objects just as it does ordinary explicit representations of numbers."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic representation for the root of a polynomial"
}], "GuideText",
 CellID->415603050],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical approximation to any precision"
}], "GuideText",
 CellID->396793884],

Cell["\t", "GuideDelimiter",
 CellID->543045374],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimalPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the minimal polynomial for which a number is a root"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["IsolatingInterval",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "exact isolating interval for an algebraic number"
}], "GuideText",
 CellID->89104742],

Cell["\t", "GuideDelimiter",
 CellID->75281029],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attempt to reduce to a single ",
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " object"
}], "GuideText",
 CellID->546986740],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to explicit radicals, if possible"
}], "GuideText",
 CellID->20222390],

Cell["\t", "GuideDelimiter",
 CellID->390733069],

Cell[TextData[{
 Cell[TextData[ButtonBox["Algebraics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Algebraics"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the domain of algebraic numbers, for ",
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " etc."
}], "GuideText",
 CellID->95462667],

Cell["\t", "GuideDelimiter",
 CellID->741738416],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an algebraic number that approximates a given number"
}], "GuideText",
 CellID->30371634],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "non-periodic and periodic continued fractions"
}], "GuideText",
 CellID->408000632],

Cell[TextData[{
 Cell[TextData[ButtonBox["QuadraticIrrationalQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuadraticIrrationalQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Convergents",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Convergents"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ContinuedFractionsAndRationalApproximations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->899044904],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Number Theory \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicNumberTheory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->190407418],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "algebraic number represented in a particular field"
}], "GuideText",
 CellID->58965563],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToNumberField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ToNumberField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "express numbers in a particular algebraic number field"
}], "GuideText",
 CellID->200881714]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Real Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RealReduce"]], "GuideTutorial",
 CellID->240653547],

Cell[TextData[ButtonBox["Root Isolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RootIsolation"]], "GuideTutorial",
 CellID->604113289]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAboutSub",
 CellID->45117378],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->223969137],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2111411219],

Cell[TextData[{
 ButtonBox["Demonstrations related to Algebraic Numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22algebraic+numbers%22+content%3AAlgebraicNumber+OR+Algebraics+OR+\
ContinuedFraction+OR+Convergents+OR+FullSimplify+OR+IsolatingInterval+OR+\
MinimalPolynomial+OR+N+OR+QuadraticIrrationalQ+OR+Root+OR+RootApproximant+OR+\
RootReduce+OR+ToNumberField+OR+ToRadicals"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->174216454]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 29, 56.0280914}", "context" -> "", 
    "keywords" -> {
     "algebraic field", "algebraic integer", "algebraic number", 
      "AlgebraicNumber", "algebraic number field", 
      "algebraic number isolating interval", "algebraic rational", 
      "algebraic simplification", "algebraic solutions", 
      "algebraic variables", "approximate by algebraic number", 
      "approximation", "characteristic polynomial", 
      "Collins-Krandick algorithm", "combining radicals", 
      "domain of algebraic numbers", "fraction expansion", 
      "guessing algebraic numbers", "guessing minimal polynomials", 
      "isolating interval", "minimal polynomial", "number field", 
      "number representation", "partial quotients", 
      "polynomial root isolation", "primitive element", 
      "quadratic irrational", "quadratic irrationals", "radical expression", 
      "radical simplification", "rational approximation", "reducing radicals",
       "root", "root approximant", "root isolation", "RootOf", "root reduce", 
      "roots", "roots of equations", "simplifying radicals", "smallest field",
       "smallest form", "square roots", "surds", "to number field"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's symbolic character allows it to provide deep integrated \
support for algebraic numbers. At the core are Root objects, which provide \
exact implicit representations for arbitrary algebraic numbers. Using \
specially developed algorithms, Mathematica efficiently handles Root objects \
just as it does ordinary explicit representations of numbers.", 
    "synonyms" -> {}, "title" -> "Algebraic Numbers", "type" -> "Guide", 
    "uri" -> "guide/AlgebraicNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[681, 28, 730, 19, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1414, 49, 273, 9, 70, "GuideText",
 CellID->415603050],
Cell[1690, 60, 255, 9, 70, "GuideText",
 CellID->396793884],
Cell[1948, 71, 48, 1, 70, "GuideDelimiter",
 CellID->543045374],
Cell[1999, 74, 444, 12, 70, "GuideText",
 CellID->1463276848],
Cell[2446, 88, 439, 12, 70, "GuideText",
 CellID->89104742],
Cell[2888, 102, 47, 1, 70, "GuideDelimiter",
 CellID->75281029],
Cell[2938, 105, 387, 13, 70, "GuideText",
 CellID->546986740],
Cell[3328, 120, 273, 9, 70, "GuideText",
 CellID->20222390],
Cell[3604, 131, 48, 1, 70, "GuideDelimiter",
 CellID->390733069],
Cell[3655, 134, 407, 13, 70, "GuideText",
 CellID->95462667],
Cell[4065, 149, 48, 1, 70, "GuideDelimiter",
 CellID->741738416],
Cell[4116, 152, 444, 12, 70, "GuideText",
 CellID->30371634],
Cell[4563, 166, 292, 9, 70, "GuideText",
 CellID->408000632],
Cell[4858, 177, 959, 24, 70, "InlineGuideFunctionListing",
 CellID->899044904],
Cell[CellGroupData[{
Cell[5842, 205, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->190407418],
Cell[6077, 212, 437, 12, 70, "GuideText",
 CellID->58965563],
Cell[6517, 226, 438, 12, 70, "GuideText",
 CellID->200881714]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7004, 244, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7069, 247, 152, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[7224, 252, 164, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[7391, 257, 152, 3, 70, "GuideTutorial",
 CellID->240653547],
Cell[7546, 262, 146, 3, 70, "GuideTutorial",
 CellID->604113289]
}, Open  ]],
Cell[CellGroupData[{
Cell[7729, 270, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7794, 273, 144, 3, 70, "GuideMoreAboutSub",
 CellID->45117378],
Cell[7941, 278, 187, 5, 70, "GuideMoreAboutSub",
 CellID->223969137],
Cell[8131, 285, 156, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[8290, 290, 155, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[8482, 298, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2111411219],
Cell[8555, 301, 702, 18, 70, "GuideRelatedLinks",
 CellID->174216454]
}, Open  ]],
Cell[9272, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

