(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17570,        559]
NotebookOptionsPosition[     10621,        391]
NotebookOutlinePosition[     14693,        464]
CellTagsIndexPosition[     14650,        461]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Algebraic Transformations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes functions for performing a variety of specific algebraic \
transformations",
 ". ",
 "Some are algorithmically straightforward; others include highly \
sophisticated algorithms, many developed and refined at Wolfram Research."
}], "GuideAbstract",
 CellID->115671057],

Cell[CellGroupData[{

Cell["General Operations", "GuideFunctionsSubsection",
 CellID->392378994],

Cell[TextData[{
 Cell[TextData[ButtonBox["Simplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Simplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply transformations to try to simplify an expression "
}], "GuideText",
 CellID->453991777],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply a full set of simplification transformations"
}], "GuideText",
 CellID->532410913],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attempt to expand in terms of more elementary functions"
}], "GuideText",
 CellID->40320783],

Cell["\t", "GuideDelimiter",
 CellID->145803982],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand powers, assuming positive real variables, etc. "
}], "GuideText",
 CellID->485966802],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand complex functions into real and imaginary parts, etc."
}], "GuideText",
 CellID->71247737],

Cell["\t", "GuideDelimiterSubsection",
 CellID->232948695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Polynomial Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PolynomialFactoring"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->318602588],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out products and powers"
}], "GuideText",
 CellID->382992909],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "factor sums into products and powers"
}], "GuideText",
 CellID->111031839],

Cell[TextData[{
 Cell[TextData[ButtonBox["Collect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Collect"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "collect similar terms together"
}], "GuideText",
 CellID->885040616]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Rational Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RationalFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->462680383],

Cell[TextData[{
 Cell[TextData[ButtonBox["Together",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Together"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " put over a common denominator"
}], "GuideText",
 CellID->486215480],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apart"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "break apart into partial fractions"
}], "GuideText",
 CellID->106573505],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandNumerator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpandAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpandAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cancel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cancel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RationalFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1614811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Trigonometric Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TrigonometricFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->559898932],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigToExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigToExp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExpToTrig",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpToTrig"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert between exponentials and trigonometric functions"
}], "GuideText",
 CellID->722371118],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrigFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigFactor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrigReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigReduce"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10137554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Numbers & Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->601044660],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "try to merge all roots to a single root"
}], "GuideText",
 CellID->205263702],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "try to convert roots to explicit radicals"
}], "GuideText",
 CellID->879928734],

Cell["\t", "GuideDelimiter",
 CellID->16621667],

Cell[TextData[{
 Cell[TextData[ButtonBox["PiecewiseExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out piecewise functions into explicit components"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out Boolean expressions"
}], "GuideText",
 CellID->190664887]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SimplifyingAlgebraicExpressions"]], "GuideTutorial",
 CellID->147268467],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "GuideTutorial",
 CellID->36340209],

Cell[TextData[ButtonBox["Transforming Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformingAlgebraicExpressions"]], "GuideTutorial",
 CellID->278742013]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Domains & Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1305511964],

Cell[TextData[{
 ButtonBox["Demonstrations related to Algebraic Transformations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Apart+\
OR+Cancel+OR+Collect+OR+ComplexExpand+OR+Expand+OR+ExpandAll+OR+\
ExpandNumerator+OR+ExpToTrig+OR+Factor+OR+FullSimplify+OR+FunctionExpand+OR+\
LogicalExpand+OR+PiecewiseExpand+OR+PowerExpand+OR+RootReduce+OR+Simplify+OR+\
Together+OR+ToRadicals+OR+TrigExpand+OR+TrigFactor+OR+TrigReduce+OR+TrigToExp)\
"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->24199499]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Transformations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 29, 57.0437424}", "context" -> "", 
    "keywords" -> {
     "algebraic number", "AlgebraicNumber", "algebraic simplification", 
      "arc trig expansion", "assertions", "assumptions", 
      "Bessel function simplification", "cancel out", 
      "Cantor-Zassenhaus algorithm", "circular functions", 
      "cleaning up expressions", "collecting over common denominators", 
      "collecting terms", "combinatorial explosion", 
      "combinatorial simplification", "combining radicals", 
      "common denominator", "common factors", "complete simplification", 
      "complex expand", "complex exponentials", "complex powers", 
      "compound arguments", "compress expression", "concise form", 
      "conditionals", "conjunctive normal form", "constraints", "conversion", 
      "de Moivre's Theorem", "De Morgan's laws", "de-nesting", "denesting", 
      "denominators", "Euler's formula", "expand all", "expanding", 
      "expanding into polar form", "expanding into real and imaginary parts", 
      "expanding special constants", "expanding special functions", 
      "expanding special sequences", "expand numerator", "expansion", 
      "exponentials", "exponent law", "exponents", "expressions", 
      "exp to trig", "factorial simplification", "factoring", 
      "factoring over extension fields", "flattening", "formulas", 
      "full simplify", "function expand", "gamma function simplification", 
      "greatest common divisor", "grouping terms", "Hensel lifting", 
      "hyperbolic functions", "identities", "index law", "irreducibility", 
      "logarithm expansion", "logarithms", "logical expand", 
      "modular factorization", "multiple angle formulas", "number theory", 
      "numerator", "Pade technique", "partial fractions", "piecewise expand", 
      "polar angles", "polynomial factorization", "polynomial power", 
      "power expand", "powers", "prime elements", "radical expression", 
      "radicals", "radical simplification", "rational function", 
      "rearrange expression", "rearranging polynomials", "reducing radicals", 
      "reduction", "reduction formulas", "reflection formula", 
      "reflection formulas", "relations", "reordering terms", "root", 
      "root reduce", "roots", "roots of polynomial", "shortest form", 
      "simplest forms", "simplification", "simplifying radicals", 
      "smallest form", "special functions", "special function simplification",
       "speed", "square roots", "squash expression", "surd", 
      "switching algebra", "symbolic complex expressions", 
      "symbolic frequency analysis", "theorem proving", "to radicals", 
      "Trager's algorithm", "transformations", "trig expand", "trig factor", 
      "trigonometric expansion", "trigonometric functions", 
      "trigonometric simplification", "trig reduce", "trig to exp", 
      "two-level logic", "UFD", "unique factorization domain", "variables", 
      "Wang's algorithm"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica includes functions for performing a variety of specific \
algebraic transformations. Some are algorithmically straightforward; others \
include highly sophisticated algorithms, many developed and refined at \
Wolfram Research.", "synonyms" -> {}, "title" -> "Algebraic Transformations", 
    "type" -> "Guide", "uri" -> "guide/AlgebraicTransformations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 344, 9, 70, "GuideAbstract",
 CellID->115671057],
Cell[CellGroupData[{
Cell[1058, 41, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->392378994],
Cell[1135, 44, 284, 9, 70, "GuideText",
 CellID->453991777],
Cell[1422, 55, 287, 9, 70, "GuideText",
 CellID->532410913],
Cell[1712, 66, 295, 9, 70, "GuideText",
 CellID->40320783],
Cell[2010, 77, 48, 1, 70, "GuideDelimiter",
 CellID->145803982],
Cell[2061, 80, 289, 9, 70, "GuideText",
 CellID->485966802],
Cell[2353, 91, 293, 8, 70, "GuideText",
 CellID->71247737],
Cell[2649, 101, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->232948695]
}, Open  ]],
Cell[CellGroupData[{
Cell[2744, 107, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->318602588],
Cell[2974, 114, 255, 9, 70, "GuideText",
 CellID->382992909],
Cell[3232, 125, 261, 9, 70, "GuideText",
 CellID->111031839],
Cell[3496, 136, 257, 9, 70, "GuideText",
 CellID->885040616]
}, Open  ]],
Cell[CellGroupData[{
Cell[3790, 150, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->462680383],
Cell[4016, 157, 253, 8, 70, "GuideText",
 CellID->486215480],
Cell[4272, 167, 257, 9, 70, "GuideText",
 CellID->106573505],
Cell[4532, 178, 828, 23, 70, "InlineGuideFunctionListing",
 CellID->1614811]
}, Open  ]],
Cell[CellGroupData[{
Cell[5397, 206, 233, 5, 70, "GuideFunctionsSubsection",
 CellID->559898932],
Cell[5633, 213, 416, 13, 70, "GuideText",
 CellID->722371118],
Cell[6052, 228, 615, 17, 70, "InlineGuideFunctionListing",
 CellID->10137554]
}, Open  ]],
Cell[CellGroupData[{
Cell[6704, 250, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->601044660],
Cell[6942, 258, 272, 9, 70, "GuideText",
 CellID->205263702],
Cell[7217, 269, 274, 9, 70, "GuideText",
 CellID->879928734],
Cell[7494, 280, 47, 1, 70, "GuideDelimiter",
 CellID->16621667],
Cell[7544, 283, 299, 9, 70, "GuideText",
 CellID->1463276848],
Cell[7846, 294, 269, 9, 70, "GuideText",
 CellID->190664887]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8164, 309, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8229, 312, 147, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[8379, 317, 186, 4, 70, "GuideTutorial",
 CellID->147268467],
Cell[8568, 323, 174, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[8745, 328, 197, 4, 70, "GuideTutorial",
 CellID->36340209],
Cell[8945, 334, 188, 4, 70, "GuideTutorial",
 CellID->278742013]
}, Open  ]],
Cell[CellGroupData[{
Cell[9170, 343, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9235, 346, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9395, 351, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9550, 356, 163, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[CellGroupData[{
Cell[9750, 364, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1305511964],
Cell[9823, 367, 756, 19, 70, "GuideRelatedLinks",
 CellID->24199499]
}, Open  ]],
Cell[10594, 389, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

