(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8379,        314]
NotebookOptionsPosition[      5209,        215]
NotebookOutlinePosition[      6462,        247]
CellTagsIndexPosition[      6419,        244]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Audio Formats", "GuideTitle",
 CellID->19750],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports all standard raster audio formats and codecs, with options to \
allow detailed control over encoding and compression. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows conversion between MIDI and its integrated symbolic note-based \
audio representation. "
}], "GuideAbstract",
 CellID->21337],

Cell[CellGroupData[{

Cell["Sampled Audio", "GuideFunctionsSubsection",
 CellID->294654781],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AIFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " AIFF Macintosh sound format (.aif, .aiff)"
}], "GuideText",
 CellID->22197],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AU"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " law encoding Unix Audio Format (.au)"
}], "GuideText",
 CellID->27505],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "FLAC lossless audio codec (.flac)"
}], "GuideText",
 CellID->24897477],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SND\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SND"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SND file format, equivalent to AU (.snd)"
}], "GuideText",
 CellID->10357],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Microsoft WAV format (.wav)"
}], "GuideText",
 CellID->6599],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Wave64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Wave64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Sony Wave64 format (.w64)"
}], "GuideText",
 CellID->383848100]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note-Based Audio", "GuideFunctionsSubsection",
 CellID->165614285],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "MIDI format (.mid)"
}], "GuideText",
 CellID->985],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1898]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common  Elements", "GuideFunctionsSubsection",
 CellID->21447],

Cell["\<\
\"Sound\" \[LongDash] sound object that plays as the sound\
\>", "GuideText",
 CellID->1084],

Cell["\<\
\"Data\" \[LongDash] array of sampled amplitude values\
\>", "GuideText",
 CellID->592],

Cell["\"Rules\" \[LongDash] rules for elements", "GuideText",
 CellID->18725],

Cell["\<\
\"Elements\" \[LongDash] list of all available elements\
\>", "GuideText",
 CellID->340481483],

Cell["\t", "GuideDelimiterSubsection",
 CellID->8996]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "GuideFunctionsSubsection",
 CellID->29855],

Cell[TextData[{
 Cell[TextData[ButtonBox["SampleRate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SampleRate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"AudioEncoding\""
}], "InlineGuideFunctionListing",
 CellID->24828]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->15338],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->76300026]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->29795],

Cell[TextData[ButtonBox["Sound & Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAbout",
 CellID->30037],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Audio Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 6.9971222}", "context" -> "", 
    "keywords" -> {
     "aliasing of sound", "raster audio", "sample rate", "sound formats"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica supports all standard raster audio formats and codecs, with \
options to allow detailed control over encoding and compression. Mathematica \
also allows conversion between MIDI and its integrated symbolic note-based \
audio representation. ", "synonyms" -> {}, "title" -> "Audio Formats", "type" -> 
    "Guide", "uri" -> "guide/AudioFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 51, 1, 70, "GuideTitle",
 CellID->19750],
Cell[673, 28, 387, 10, 70, "GuideAbstract",
 CellID->21337],
Cell[CellGroupData[{
Cell[1085, 42, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->294654781],
Cell[1157, 45, 264, 8, 70, "GuideText",
 CellID->22197],
Cell[1424, 55, 322, 11, 70, "GuideText",
 CellID->27505],
Cell[1749, 68, 264, 9, 70, "GuideText",
 CellID->24897477],
Cell[2016, 79, 261, 8, 70, "GuideText",
 CellID->10357],
Cell[2280, 89, 247, 8, 70, "GuideText",
 CellID->6599],
Cell[2530, 99, 261, 9, 70, "GuideText",
 CellID->383848100]
}, Open  ]],
Cell[CellGroupData[{
Cell[2828, 113, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->165614285],
Cell[2903, 116, 244, 9, 70, "GuideText",
 CellID->985],
Cell[3150, 127, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->1898]
}, Open  ]],
Cell[CellGroupData[{
Cell[3240, 133, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->21447],
Cell[3311, 136, 102, 3, 70, "GuideText",
 CellID->1084],
Cell[3416, 141, 97, 3, 70, "GuideText",
 CellID->592],
Cell[3516, 146, 77, 1, 70, "GuideText",
 CellID->18725],
Cell[3596, 149, 104, 3, 70, "GuideText",
 CellID->340481483],
Cell[3703, 154, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->8996]
}, Open  ]],
Cell[CellGroupData[{
Cell[3793, 160, 59, 1, 70, "GuideFunctionsSubsection",
 CellID->29855],
Cell[3855, 163, 280, 9, 70, "InlineGuideFunctionListing",
 CellID->24828]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4184, 178, 58, 1, 70, "GuideTutorialsSection",
 CellID->15338],
Cell[4245, 181, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[4420, 186, 173, 3, 70, "GuideTutorial",
 CellID->76300026]
}, Open  ]],
Cell[CellGroupData[{
Cell[4630, 194, 59, 1, 70, "GuideMoreAboutSection",
 CellID->29795],
Cell[4692, 197, 153, 3, 70, "GuideMoreAbout",
 CellID->30037],
Cell[4848, 202, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[5009, 207, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],
Cell[5182, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

