(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15349,        464]
NotebookOptionsPosition[     10881,        344]
NotebookOutlinePosition[     13252,        393]
CellTagsIndexPosition[     13209,        390]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Bessel-Related Functions", "GuideTitle",
 CellID->11840],

Cell[TextData[{
 "Using original algorithms developed at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has full coverage of all standard Bessel-related \
functions\[LongDash]evaluating every function to arbitrary precision with \
optimized algorithms for arbitrary complex values of its parameters, as well \
as supporting series and asymptotic expansions with full treatment of Stokes \
sectors, and an extensive web of symbolic transformations and \
simplifications."
}], "GuideAbstract",
 CellID->4966],

Cell[CellGroupData[{

Cell["Bessel Functions", "GuideFunctionsSubsection",
 CellID->16944],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselI",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselK"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->32439]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spherical Bessel Functions", "GuideFunctionsSubsection",
 CellID->180500960],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselY",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselY"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->518259331]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hankel Functions", "GuideFunctionsSubsection",
 CellID->5537],

Cell[TextData[{
 Cell[TextData[ButtonBox["HankelH1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalHankelH1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalHankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->21538]
}, Open  ]],

Cell[CellGroupData[{

Cell["Airy Functions", "GuideFunctionsSubsection",
 CellID->24626],

Cell[TextData[{
 Cell[TextData[ButtonBox["AiryAi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryBi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBiPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryBiPrime"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11323]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kelvin Functions", "GuideFunctionsSubsection",
 CellID->111942679],

Cell[TextData[{
 Cell[TextData[ButtonBox["KelvinBer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinBer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KelvinBei",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinBei"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KelvinKer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinKer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KelvinKei",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinKei"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->335008746]
}, Open  ]],

Cell[CellGroupData[{

Cell["Struve Functions", "GuideFunctionsSubsection",
 CellID->16118],

Cell[TextData[{
 Cell[TextData[ButtonBox["StruveH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StruveH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StruveL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StruveL"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2082]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Zeros", "GuideFunctionsSubsection",
 CellID->133734369],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselJZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselYZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselYZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryAiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryBiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->437022592]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->22929],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31115],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], "GuideMoreAbout",\

 CellID->4639],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "GuideMoreAbout",
 CellID->29658],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->9930],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "GuideMoreAbout",
 CellID->88737588]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1963511447],

Cell[TextData[{
 ButtonBox["Demonstrations related to Bessel-Related Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AiryAi+OR+AiryAiPrime+OR+AiryAiZero+OR+AiryBi+OR+AiryBiPrime+OR+AiryBiZero+OR+\
BesselI+OR+BesselJ+OR+BesselJZero+OR+BesselK+OR+BesselY+OR+BesselYZero+OR+\
HankelH1+OR+HankelH2+OR+KelvinBei+OR+KelvinBer+OR+KelvinKei+OR+KelvinKer+OR+\
SphericalBesselJ+OR+SphericalBesselY+OR+SphericalHankelH1+OR+\
SphericalHankelH2+OR+StruveH+OR+StruveL)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->303324806]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bessel-Related Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 10.8409706}", "context" -> "", 
    "keywords" -> {
     "ai", "airy", "Airy Ai", "Airy Ai prime", "Airy Ai zero", "Airy Bi", 
      "Airy Bi derivative", "Airy Bi prime", "Airy Bi zero", 
      "Airy derivative", "Airy functions", "Bessel equation", 
      "Bessel functions", "Bessel I", "Bessel J", "Bessel J0", "Bessel J1", 
      "Bessel zero", "bi", "cylindrical functions", 
      "Hankel function of the first kind", 
      "Hankel function of the second kind", "Hankel functions", "Hankel H1", 
      "Hankel H2", "j0", "j1", "jn", "Kelvin bei", "Kelvin ber", 
      "Kelvin functions", "Kelvin kei", "Kelvin ker", "Neumann function", 
      "spherical bessel", "spherical Bessel", "spherical Bessel function", 
      "spherical Bessel J", "spherical Bessel Y", "spherical Hankel function",
       "spherical Hankel H1", "spherical Hankel H2", "Struve function", 
      "Struve function H", "Struve function L", "Weber functions", 
      "zero of airy function", "zero of Airy function", 
      "zeros of Bessel functions"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Using original algorithms developed at Wolfram Research, Mathematica has \
full coverage of all standard Bessel-related functions--evaluating every \
function to arbitrary precision with optimized algorithms for arbitrary \
complex values of its parameters, as well as supporting series and asymptotic \
expansions with full treatment of Stokes sectors, and an extensive web of \
symbolic transformations and simplifications.", "synonyms" -> {}, "title" -> 
    "Bessel-Related Functions", "type" -> "Guide", "uri" -> 
    "guide/BesselRelatedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->11840],
Cell[684, 28, 532, 11, 70, "GuideAbstract",
 CellID->4966],
Cell[CellGroupData[{
Cell[1241, 43, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->16944],
Cell[1312, 46, 800, 23, 70, "InlineGuideFunctionListing",
 CellID->32439]
}, Open  ]],
Cell[CellGroupData[{
Cell[2149, 74, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->180500960],
Cell[2234, 77, 718, 17, 70, "InlineGuideFunctionListing",
 CellID->518259331]
}, Open  ]],
Cell[CellGroupData[{
Cell[2989, 99, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->5537],
Cell[3059, 102, 1424, 35, 70, "InlineGuideFunctionListing",
 CellID->21538]
}, Open  ]],
Cell[CellGroupData[{
Cell[4520, 142, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->24626],
Cell[4589, 145, 812, 23, 70, "InlineGuideFunctionListing",
 CellID->11323]
}, Open  ]],
Cell[CellGroupData[{
Cell[5438, 173, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->111942679],
Cell[5513, 176, 1400, 35, 70, "InlineGuideFunctionListing",
 CellID->335008746]
}, Open  ]],
Cell[CellGroupData[{
Cell[6950, 216, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->16118],
Cell[7021, 219, 387, 11, 70, "InlineGuideFunctionListing",
 CellID->2082]
}, Open  ]],
Cell[CellGroupData[{
Cell[7445, 235, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->133734369],
Cell[7518, 238, 1412, 35, 70, "InlineGuideFunctionListing",
 CellID->437022592]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8979, 279, 58, 1, 70, "GuideTutorialsSection",
 CellID->22929],
Cell[9040, 282, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[9225, 290, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31115],
Cell[9287, 293, 163, 4, 70, "GuideMoreAbout",
 CellID->4639],
Cell[9453, 299, 160, 3, 70, "GuideMoreAbout",
 CellID->29658],
Cell[9616, 304, 148, 3, 70, "GuideMoreAboutSub",
 CellID->9930],
Cell[9767, 309, 178, 3, 70, "GuideMoreAbout",
 CellID->88737588]
}, Open  ]],
Cell[CellGroupData[{
Cell[9982, 317, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1963511447],
Cell[10055, 320, 784, 19, 70, "GuideRelatedLinks",
 CellID->303324806]
}, Open  ]],
Cell[10854, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

