(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13790,        458]
NotebookOptionsPosition[      8571,        328]
NotebookOutlinePosition[     11809,        389]
CellTagsIndexPosition[     11766,        386]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Binary Data", "GuideTitle",
 CellID->2306],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides high-performance reading and writing of binary data, to both \
files and pipes. A convenient symbolic format representation makes it \
straightforward to translate published instrumentation or logging \
specifications to a form that can immediately be used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "GuideAbstract",
 CellID->31673],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinaryRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryRead"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read one binary object or block of objects"
}], "GuideText",
 CellID->26924],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "repeatedly read a binary object or block of objects"
}], "GuideText",
 CellID->19072],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinaryWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryWrite"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "write a sequence of binary objects with specified types"
}], "GuideText",
 CellID->6270],

Cell["\t", "GuideDelimiter",
 CellID->5829],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import, export complete binary files"
}], "GuideText",
 CellID->26777],

Cell["\t", "GuideDelimiterSubsection",
 CellID->15573],

Cell[CellGroupData[{

Cell["Binary Types", "GuideFunctionsSubsection",
 CellID->5097],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Bit\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Bit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " individual binary bits (",
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " only)"
}], "GuideText",
 CellID->16512],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Byte\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Byte"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "8-bit unsigned integer"
}], "GuideText",
 CellID->23986],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer8"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Integer16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer16"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 8-, 16-, 24- 32-, 64-, 128-bit signed integers"
}], "GuideText",
 CellID->13290],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "8-, 16-, 24-, 32-, 64-, 128-bit unsigned integers"
}], "GuideText",
 CellID->9161],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Real32\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real32"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Real64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real64"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Real128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE single\[Hyphen], double\[Hyphen], quad-precision real numbers"
}], "GuideText",
 CellID->18636],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Complex64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex64"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Complex128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex128"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Complex256\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex256"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "IEEE complex numbers"
}], "GuideText",
 CellID->22355],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Character8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Character8"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"Character16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Character16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "8- and 16-bit (Unicode) characters"
}], "GuideText",
 CellID->24767],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TerminatedString\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TerminatedString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "null-terminated string"
}], "GuideText",
 CellID->23655],

Cell["\t", "GuideDelimiter",
 CellID->15574],

Cell[TextData[{
 Cell[TextData[ButtonBox["ByteOrdering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ByteOrdering"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " option for byte ordering (+1 for big endian; -1 for little endian)"
}], "GuideText",
 CellID->4031],

Cell[TextData[{
 Cell[TextData[ButtonBox["$ByteOrdering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "native byte ordering on your computer system"
}], "GuideText",
 CellID->12052],

Cell["\t", "GuideDelimiter",
 CellID->27350],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FromCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "character code conversion"
}], "GuideText",
 CellID->1150],

Cell["\t", "GuideDelimiter",
 CellID->371733670],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compress"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Uncompress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Uncompress"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert expressions to and from compressed strings"
}], "GuideText",
 CellID->942428084]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->16941],

Cell[TextData[ButtonBox["Binary files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BinaryFiles"]], "GuideTutorial",
 CellID->21724],

Cell[TextData[ButtonBox["Character Codes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharacterCodes"]], "GuideTutorial",
 CellID->13966]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->3430],

Cell[TextData[ButtonBox["Importing & Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAbout",
 CellID->31107],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "GuideMoreAbout",
 CellID->30191],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAboutSub",
 CellID->11337]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Binary Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 11.4191104}", "context" -> "", 
    "keywords" -> {
     "AIFF format", "animations", "arrays", "atoi", "audio", "AU format", 
      "AutoCAD format", "AVI", "big-endian", "binary read", 
      "binary read list", "binary write", "biomedical image format", 
      "bitmap graphics formats", "bits", "BMP", "byte order", "byte ordering",
       "bytes", "CAD", "capturing images", "\\catcode (TeX)", "\\char (TeX)", 
      "DIF format", "drawing format", "draw programs", "DXF format", 
      "endianness", "excel format", "Excel format", "exporting graphics", 
      "exporting sounds", "external data", "FITS format", 
      "flexible Image Transport System", "foreign data", "GIF", "GIS data", 
      "Harwell-Boeing format", "HDF", "hierarchical Data Format", 
      "image processing", "images", "interchange format", "JFIF", "JPEG", 
      "least significant byte", "lithography", "lithography format", 
      "little-endian", "Lotus 1-2-3 format", "low-level data", 
      "Macintosh PICT", "MAT format", "matrix Market format", 
      "medical imaging", "metafile format", "Metafile format", 
      "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "most significant byte", "MPS", "MTX format", 
      "mu law format", "PBM graphics format", "PCX", "PGM graphics format", 
      "PICT", "pictures", "Pixmap graphics format", "PNG", 
      "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "PPM graphics format", "processing images", 
      "radiology formats", "raster conversion", "rasters", "raw data", 
      "reading binary data", "scalable vector graphics", "SDTS importing", 
      "SND format", "solid object modeling", "sounds", "spreadsheets", 
      "stereo-lithography", "stereolithography format", "STL format", 
      "strings", "SVG", "terrain data", "three-dimensional graphics", "TIFF", 
      "WAV format", "Windows metafile format", "WMF", "writing binary files", 
      "XBitmap format", "X Windows graphics format"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides high-performance reading and writing of binary \
data, to both files and pipes. A convenient symbolic format representation \
makes it straightforward to translate published instrumentation or logging \
specifications to a form that can immediately be used in Mathematica. ", 
    "synonyms" -> {}, "title" -> "Binary Data", "type" -> "Guide", "uri" -> 
    "guide/BinaryData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 48, 1, 70, "GuideTitle",
 CellID->2306],
Cell[670, 28, 431, 11, 70, "GuideAbstract",
 CellID->31673],
Cell[1104, 41, 271, 9, 70, "GuideText",
 CellID->26924],
Cell[1378, 52, 288, 9, 70, "GuideText",
 CellID->19072],
Cell[1669, 63, 285, 9, 70, "GuideText",
 CellID->6270],
Cell[1957, 74, 43, 1, 70, "GuideDelimiter",
 CellID->5829],
Cell[2003, 77, 380, 13, 70, "GuideText",
 CellID->26777],
Cell[2386, 92, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->15573],
Cell[CellGroupData[{
Cell[2465, 97, 63, 1, 70, "GuideFunctionsSubsection",
 CellID->5097],
Cell[2531, 100, 495, 16, 70, "GuideText",
 CellID->16512],
Cell[3029, 118, 250, 9, 70, "GuideText",
 CellID->23986],
Cell[3282, 129, 470, 14, 70, "GuideText",
 CellID->13290],
Cell[3755, 145, 353, 11, 70, "GuideText",
 CellID->9161],
Cell[4111, 158, 563, 16, 70, "GuideText",
 CellID->18636],
Cell[4677, 176, 542, 17, 70, "GuideText",
 CellID->22355],
Cell[5222, 195, 418, 13, 70, "GuideText",
 CellID->24767],
Cell[5643, 210, 274, 9, 70, "GuideText",
 CellID->23655],
Cell[5920, 221, 44, 1, 70, "GuideDelimiter",
 CellID->15574],
Cell[5967, 224, 293, 8, 70, "GuideText",
 CellID->4031],
Cell[6263, 234, 279, 9, 70, "GuideText",
 CellID->12052],
Cell[6545, 245, 44, 1, 70, "GuideDelimiter",
 CellID->27350],
Cell[6592, 248, 408, 13, 70, "GuideText",
 CellID->1150],
Cell[7003, 263, 48, 1, 70, "GuideDelimiter",
 CellID->371733670],
Cell[7054, 266, 410, 13, 70, "GuideText",
 CellID->942428084]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7513, 285, 58, 1, 70, "GuideTutorialsSection",
 CellID->16941],
Cell[7574, 288, 138, 3, 70, "GuideTutorial",
 CellID->21724],
Cell[7715, 293, 144, 3, 70, "GuideTutorial",
 CellID->13966]
}, Open  ]],
Cell[CellGroupData[{
Cell[7896, 301, 58, 1, 70, "GuideMoreAboutSection",
 CellID->3430],
Cell[7957, 304, 160, 3, 70, "GuideMoreAbout",
 CellID->31107],
Cell[8120, 309, 148, 3, 70, "GuideMoreAbout",
 CellID->30191],
Cell[8271, 314, 258, 9, 70, "GuideMoreAboutSub",
 CellID->11337]
}, Open  ]],
Cell[8544, 326, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

