(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11896,        379]
NotebookOptionsPosition[      7774,        269]
NotebookOutlinePosition[      9978,        316]
CellTagsIndexPosition[      9935,        313]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Bitwise Operations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can represent bit vectors of arbitrary length as integers, and uses highly \
optimized algorithms\[LongDash]including several original to Wolfram Research\
\[LongDash]to perform bitwise operations with maximal efficiency on all \
standard computer systems. "
}], "GuideAbstract",
 CellID->425349122],

Cell[CellGroupData[{

Cell["Bitwise Logic Operations", "GuideFunctionsSubsection",
 CellID->271697455],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitOr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitOr"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitNot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitNot"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->156138258]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structural Bitwise Operations", "GuideFunctionsSubsection",
 CellID->438250743],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitShiftLeft",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitShiftLeft"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitShiftRight",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitShiftRight"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->245431178]
}, Open  ]],

Cell[CellGroupData[{

Cell["Single\[Hyphen]Bit Operations", "GuideFunctionsSubsection",
 CellID->1002170524],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitSet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitSet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitClear",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitClear"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitGet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitGet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->596853676],

Cell[TextData[{
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total count of 0 or 1 bits"
}], "GuideText",
 CellID->202155655],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of trailing 0s"
}], "GuideText",
 CellID->640093480],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "arbitrary local bitwise operations"
}], "GuideText",
 CellID->101646568],

Cell["\t", "GuideDelimiter",
 CellID->357867777],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to a list of digits"
}], "GuideText",
 CellID->163085810],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to an integer from a list of digits"
}], "GuideText",
 CellID->32648652]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Importing & Exporting Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1572318359],

Cell[TextData[{
 ButtonBox["Demonstrations related to Bitwise Operations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BitAnd+OR+BitClear+OR+BitGet+OR+BitLength+OR+BitNot+OR+BitOr+OR+BitSet+OR+\
BitShiftLeft+OR+BitShiftRight+OR+BitXor+OR+CellularAutomaton+OR+DigitCount+OR+\
FromDigits+OR+IntegerDigits+OR+IntegerExponent)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->3300584]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bitwise Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 12.2941328}", "context" -> "", 
    "keywords" -> {
     "additive cellular automata", "array automata", "bases", "binary digits",
       "bit and", "bit clear", "bit count", "bit get", "bit length", 
      "bit not", "bit or", "bit set", "bit shift left", "bit shift right", 
      "bit xor", "block maps", "CA", "carry", "cell-automaton", 
      "cell automaton", "cellular automaton", 
      "continuous mappings of the shift", "count of digits", "decimal digits",
       "decode", "digital sums", "digit count", "digits", "digits count", 
      "elementary cellular automata", "from digits", 
      "greatest dividing exponent", "half adder", "Hamming weight", 
      "hexadecimal digits", "mask", "Nim addition", "number conversion", 
      "number reconstruction", "octal digits", "polyautomata", 
      "roman numerals", "rule 30", "rule numbers", "ruler function", 
      "ternary digits", "tesselation automata", 
      "totalistic cellular automata", "unpack", "bit packing", "bitpacking", 
      "bit slicing", "bit vectors", "multispin coding"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica can represent bit vectors of arbitrary length as integers, \
and uses highly optimized algorithms--including several original to Wolfram \
Research--to perform bitwise operations with maximal efficiency on all \
standard computer systems. ", "synonyms" -> {}, "title" -> 
    "Bitwise Operations", "type" -> "Guide", "uri" -> 
    "guide/BitwiseOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 367, 8, 70, "GuideAbstract",
 CellID->425349122],
Cell[CellGroupData[{
Cell[1074, 40, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->271697455],
Cell[1157, 43, 794, 23, 70, "InlineGuideFunctionListing",
 CellID->156138258]
}, Open  ]],
Cell[CellGroupData[{
Cell[1988, 71, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->438250743],
Cell[2076, 74, 1059, 26, 70, "InlineGuideFunctionListing",
 CellID->245431178]
}, Open  ]],
Cell[CellGroupData[{
Cell[3172, 105, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->1002170524],
Cell[3261, 108, 1030, 26, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[4294, 136, 48, 1, 70, "GuideDelimiter",
 CellID->596853676],
Cell[4345, 139, 259, 9, 70, "GuideText",
 CellID->202155655],
Cell[4607, 150, 264, 9, 70, "GuideText",
 CellID->640093480],
Cell[4874, 161, 281, 9, 70, "GuideText",
 CellID->101646568],
Cell[5158, 172, 48, 1, 70, "GuideDelimiter",
 CellID->357867777],
Cell[5209, 175, 266, 9, 70, "GuideText",
 CellID->163085810],
Cell[5478, 186, 275, 9, 70, "GuideText",
 CellID->32648652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5802, 201, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5867, 204, 198, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[6068, 210, 152, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[6257, 218, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6322, 221, 165, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[6490, 226, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6654, 231, 158, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[6815, 236, 165, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[7017, 244, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1572318359],
Cell[7090, 247, 642, 17, 70, "GuideRelatedLinks",
 CellID->3300584]
}, Open  ]],
Cell[7747, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

