(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18216,        564]
NotebookOptionsPosition[     10909,        393]
NotebookOutlinePosition[     15461,        473]
CellTagsIndexPosition[     15418,        470]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Calculus", "GuideTitle",
 CellID->18762],

Cell[TextData[{
 "In calculus even more than other areas, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packs centuries of mathematical development into a small number of \
exceptionally powerful functions. Continually enhanced by new methods being \
discovered at Wolfram Research, the algorithms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " probably now reach almost every integral and differential equation for \
which a closed form can be found",
 ". ",
 " "
}], "GuideAbstract",
 CellID->1655],

Cell[TextData[{
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[PartialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " partial derivatives, of scalar or vector functions"
}], "GuideText",
 CellID->21548],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total derivatives"
}], "GuideText",
 CellID->6483],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic integrals in one or more dimensions"
}], "GuideText",
 CellID->27595],

Cell["\t", "GuideDelimiter",
 CellID->4041],

Cell[TextData[{
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "power series and asymptotic expansions ",
 ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SeriesExpansions"]
}], "GuideText",
 CellID->3602],

Cell[TextData[{
 Cell[TextData[ButtonBox["Limit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Limit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "limits"
}], "GuideText",
 CellID->24350],

Cell["\t", "GuideDelimiter",
 CellID->10291],

Cell[TextData[{
 Cell[TextData[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic solutions to differential equations"
}], "GuideText",
 CellID->30836],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Maximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Maximize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic optimization"
}], "GuideText",
 CellID->9374],

Cell["\t", "GuideDelimiter",
 CellID->11020],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Product",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Product"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic sums and products"
}], "GuideText",
 CellID->4596],

Cell["\t", "GuideDelimiterSubsection",
 CellID->24021],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Integral Transforms \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/IntegralTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->27348],

Cell[TextData[{
 Cell[TextData[ButtonBox["LaplaceTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiracDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiracDelta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/IntegralTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23199],

Cell["\t", "GuideDelimiter",
 CellID->722474752],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Orthogonalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Orthogonalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "normalize, orthogonalize families of functions"
}], "GuideText",
 CellID->55885302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Numerical Calculus \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->92505887],

Cell[TextData[{
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NSum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->252735064]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->19668],

Cell[TextData[ButtonBox["Limits",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Limits"]], "GuideTutorial",
 CellID->24484],

Cell[TextData[ButtonBox["Finding Limits",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingLimits"]], "GuideTutorial",
 CellID->211949030],

Cell[TextData[ButtonBox["Differentiation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Differentiation"]], "GuideTutorial",
 CellID->564024182],

Cell[TextData[ButtonBox["Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Integration"]], "GuideTutorial",
 CellID->8281],

Cell[TextData[ButtonBox["Indefinite Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndefiniteIntegrals"]], "GuideTutorial",
 CellID->710968122],

Cell[TextData[ButtonBox["Integrals That Can and Cannot Be Done",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralsThatCanAndCannotBeDone"]], "GuideTutorial",
 CellID->112748652],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "GuideTutorial",
 CellID->900313505],

Cell[TextData[ButtonBox["Making Power Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingPowerSeriesExpansions"]], "GuideTutorial",\

 CellID->473512939],

Cell[TextData[ButtonBox["Sums and Products",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SumsAndProducts"]], "GuideTutorial",
 CellID->366903719]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->4734],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "GuideMoreAbout",
 CellID->53],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorAnalysis/guide/VectorAnalysisPackage"]], "GuideMoreAbout",
 CellID->78040636],

Cell[TextData[ButtonBox["Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAbout",
 CellID->1999],

Cell[TextData[ButtonBox["Variational Methods Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/guide/VariationalMethodsPackage"]], \
"GuideMoreAboutSub",
 CellID->1319428129],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/guide/NumericalCalculusPackage"]], \
"GuideMoreAboutSub",
 CellID->32053],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "GuideMoreAboutSub",
 CellID->937645937],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1168383378],

Cell[TextData[{
 ButtonBox["Demonstrations related to Calculus",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(D+OR+\
DiracDelta+OR+DSolve+OR+Dt+OR+FourierTransform+OR+Integrate+OR+\
LaplaceTransform+OR+Limit+OR+Maximize+OR+Minimize+OR+NDSolve+OR+NIntegrate+OR+\
NMinimize+OR+Normalize+OR+NSum+OR+Orthogonalize+OR+Product+OR+Series+OR+Sum)"]\
, None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->255063921]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calculus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 12.7941456}", "context" -> "", 
    "keywords" -> {
     "alternating series summation", "analytical solution", "anti-derivative",
       "approximate formulas", "approximation of functions", "approximations",
       "area", "asymptotic expansions", "asymptotic value", 
      "behavior of function", "boundary conditions", "calculus", 
      "Cartesian product cubature", "chasing method", 
      "Clenshaw-Curtis integration", "closed-form solution", 
      "composite quadrature", "constrained optimization", "cost function", 
      "cubature", "d'Alembert test", "delta function", "derivative tensor", 
      "derivatives", "diff", "diffeq", "differentiable", "differential", 
      "differential-algebraic equations", "differentiation", "dirac delta", 
      "directed limit", "Dirichlet series", "distribution", "divergence", 
      "double exponential integration", "Dwight's tables", "epsilon-delta", 
      "Euler-Maclaurin summation", "exact differential", "exact optimization",
       "expansion", "extrema", "extremization", "frequency dimension", 
      "function transform", "Gauss integration", "Gaussian quadrature", 
      "Gauss-Kronrod integration", "gear method", 
      "Gel'fand-Lokutsiyevskii method", "Gelfand-Lokutsiyevskii method", 
      "generalized functions", "Genz-Malik algorithm", "Genz-Malik cubature", 
      "global adaptive integration", "global maximization", 
      "global minimization", "goal functions", "gradients", 
      "Gradshteyn-Ryzhik", "homogeneous differential equations", 
      "hypergeometric sums", "improper functions", "impulse function", 
      "inequalities", "infeasible constraints", "initial conditions", 
      "integer linear programming", "integer programming", 
      "integral operator", "integral transform", "Integrate", "integration", 
      "integration over regions", "inverse Fourier transform", 
      "inverse Laplace transform", "Kronrod points", "Laplace transform", 
      "Las Vegas integration", "Laurent series", "Leibniz's notation", 
      "length of vector", "lim", "limiting functions", "limiting value", 
      "linear differential equations", "Lobatto-Kronrod integration", 
      "Maclaurin series", "maximization", "measures", "mensuration", 
      "method of lines", "minimization", "Monte Carlo integration", 
      "multi-panel quadrature", "multiple integrals", "multiple products", 
      "multivariate derivative", "Newton-Cotes integration", 
      "normalize vector", "numerical integration", "numerical minimization", 
      "numerical solution of differential equations", "numerical summation", 
      "objective functions", "operations research", "optimization", 
      "ordinary differential equations", "partial derivatives", 
      "partial differential equations", "pay-off functions", "phase plots", 
      "piecewise differential equations", "polynomial programming", 
      "power series", "prod", "quadrature", "rate of change", 
      "region integrals", "Series", "series expansions", "singularities", 
      "stationary points", "sums", "surface integrals", 
      "symbolic optimization", "symbolic sums", "Taylor series", 
      "tensor derivative", "total derivatives", "total differential", 
      "trapezoidal integration", "value at discontinuity", 
      "vector derivative", "volume integrals"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In calculus even more than other areas, Mathematica packs centuries of \
mathematical development into a small number of exceptionally powerful \
functions. Continually enhanced by new methods being discovered at Wolfram \
Research, the algorithms in Mathematica probably now reach almost every \
integral and differential equation for which a closed form can be found. ", 
    "synonyms" -> {}, "title" -> "Calculus", "type" -> "Guide", "uri" -> 
    "guide/Calculus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 46, 1, 70, "GuideTitle",
 CellID->18762],
Cell[668, 28, 520, 14, 70, "GuideAbstract",
 CellID->1655],
Cell[1191, 44, 385, 13, 70, "GuideText",
 CellID->21548],
Cell[1579, 59, 229, 9, 70, "GuideText",
 CellID->6483],
Cell[1811, 70, 403, 13, 70, "GuideText",
 CellID->27595],
Cell[2217, 85, 43, 1, 70, "GuideDelimiter",
 CellID->4041],
Cell[2263, 88, 360, 12, 70, "GuideText",
 CellID->3602],
Cell[2626, 102, 225, 9, 70, "GuideText",
 CellID->24350],
Cell[2854, 113, 44, 1, 70, "GuideDelimiter",
 CellID->10291],
Cell[2901, 116, 265, 9, 70, "GuideText",
 CellID->30836],
Cell[3169, 127, 367, 12, 70, "GuideText",
 CellID->9374],
Cell[3539, 141, 44, 1, 70, "GuideDelimiter",
 CellID->11020],
Cell[3586, 144, 365, 13, 70, "GuideText",
 CellID->4596],
Cell[3954, 159, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->24021],
Cell[CellGroupData[{
Cell[4033, 164, 221, 5, 70, "GuideFunctionsSubsection",
 CellID->27348],
Cell[4257, 171, 851, 23, 70, "InlineGuideFunctionListing",
 CellID->23199],
Cell[5111, 196, 48, 1, 70, "GuideDelimiter",
 CellID->722474752],
Cell[5162, 199, 703, 19, 70, "GuideText",
 CellID->55885302]
}, Open  ]],
Cell[CellGroupData[{
Cell[5902, 223, 236, 5, 70, "GuideFunctionsSubsection",
 CellID->92505887],
Cell[6141, 230, 1039, 30, 70, "InlineGuideFunctionListing",
 CellID->252735064]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7229, 266, 58, 1, 70, "GuideTutorialsSection",
 CellID->19668],
Cell[7290, 269, 127, 3, 70, "GuideTutorial",
 CellID->24484],
Cell[7420, 274, 146, 3, 70, "GuideTutorial",
 CellID->211949030],
Cell[7569, 279, 149, 3, 70, "GuideTutorial",
 CellID->564024182],
Cell[7721, 284, 136, 3, 70, "GuideTutorial",
 CellID->8281],
Cell[7860, 289, 158, 3, 70, "GuideTutorial",
 CellID->710968122],
Cell[8021, 294, 190, 4, 70, "GuideTutorial",
 CellID->112748652],
Cell[8214, 300, 142, 3, 70, "GuideTutorial",
 CellID->900313505],
Cell[8359, 305, 178, 4, 70, "GuideTutorial",
 CellID->473512939],
Cell[8540, 311, 151, 3, 70, "GuideTutorial",
 CellID->366903719]
}, Open  ]],
Cell[CellGroupData[{
Cell[8728, 319, 58, 1, 70, "GuideMoreAboutSection",
 CellID->4734],
Cell[8789, 322, 143, 3, 70, "GuideMoreAbout",
 CellID->53],
Cell[8935, 327, 178, 4, 70, "GuideMoreAbout",
 CellID->78040636],
Cell[9116, 333, 156, 3, 70, "GuideMoreAbout",
 CellID->1999],
Cell[9275, 338, 197, 5, 70, "GuideMoreAboutSub",
 CellID->1319428129],
Cell[9475, 345, 189, 5, 70, "GuideMoreAboutSub",
 CellID->32053],
Cell[9667, 352, 255, 5, 70, "GuideMoreAboutSub",
 CellID->937645937],
Cell[9925, 359, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[CellGroupData[{
Cell[10135, 367, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1168383378],
Cell[10208, 370, 659, 18, 70, "GuideRelatedLinks",
 CellID->255063921]
}, Open  ]],
Cell[10882, 391, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

