(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16665,        541]
NotebookOptionsPosition[     12401,        428]
NotebookOutlinePosition[     14641,        474]
CellTagsIndexPosition[     14598,        471]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Calling External Programs", "GuideTitle",
 CellID->29292],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " immediately allows you to call both stand\[Hyphen]alone programs and \
individual functions or methods within running programs. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s architecture allows external functionality to be represented in a \
symbolic form that can immediately be manipulated within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]and that often makes access to external functionality from \
within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " more convenient even than from its own native environment."
}], "GuideAbstract",
 CellID->179498026],

Cell[TextData[{
 Cell[TextData[ButtonBox["Run",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Run"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "run an external command-line program (",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["prog", "TI"]}]], "InlineFormula"],
 " to run as a shell escape)"
}], "GuideText",
 CellID->197638525],

Cell[TextData[{
 Cell[TextData[ButtonBox["RunThrough",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RunThrough"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "feed standard input to an external program, and capture output"
}], "GuideText",
 CellID->207953997],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Splice",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Splice"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FortranForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FortranForm"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->202693632],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"], "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 " ",
 StyleBox[ButtonBox[" \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"], "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->629466972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Install"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "install a ",
 StyleBox["MathLink-",
  FontSlant->"Italic"],
 "installable external program"
}], "GuideText",
 CellID->9567],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkPatterns",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkPatterns"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find functions available in a running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program"
}], "GuideText",
 CellID->22336],

Cell[TextData[{
 Cell[TextData[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "externally prepare a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]installable C or C++ program"
}], "GuideText",
 CellID->224666515],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkLaunch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkLaunch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5019633]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"], "GuideFunctionsSubsection",
  
  FontSlant->"Italic"],
 " ",
 StyleBox[ButtonBox[" \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->269734094],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaNew",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a new Java object in any specified class"
}], "GuideText",
 CellID->425009627],

Cell[TextData[{
 Cell[TextData[ButtonBox["LoadJavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MakeJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JavaShow",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaShow"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->318471685]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/DotNetInterface"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 " ",
 StyleBox[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/DotNetInterface"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->12176040],

Cell[TextData[{
 Cell[TextData[ButtonBox["NETNew",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a new .NET object of any specified type"
}], "GuideText",
 CellID->46610314],

Cell[TextData[{
 Cell[TextData[ButtonBox["LoadNETType",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NETTypeInfo",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MakeNETObject",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NETBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/DotNetInterface"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->652177849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Web Services \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:WebServices/guide/WebServiceOperations"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->303367770],

Cell[TextData[{
 Cell[TextData[ButtonBox["InstallService",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InstallService"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "install web services from a WSDL description"
}], "GuideText",
 CellID->320785531]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18397],

Cell[TextData[ButtonBox["External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExternalPrograms"]], "GuideTutorial",
 CellID->31418],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "GuideTutorial",
 CellID->19897],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["\[Hyphen]Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "GuideTutorial",
 CellID->9988562],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->79147778],

Cell[TextData[{
 ButtonBox["Calling Subsidiary ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
  FontSlant->"Italic"],
 ButtonBox[" Processes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"]
}], "GuideTutorial",
 CellID->91837830]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->25828],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[ButtonBox["General External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "GuideMoreAbout",
 CellID->13851]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calling External Programs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 13.7785458}", "context" -> "", 
    "keywords" -> {
     "add external function", "child processes", "C language", "C programs", 
      "execute external command", "extend functions", "extending Mathematica",
       "external data", "external filter", "external programs", 
      "get data from Mathlink", "information about Mathlink program", 
      "insertion into external files", "install external program", 
      "install service", "launching programs", "link launch", "link patterns",
       "link read", "link write", "Mathlink program usage", 
      "operating system command", "output in external files", "put data", 
      "reading expression from Mathlink", "running external programs", 
      "run through", "send data via Mathlink", "shell command", 
      "shell escape", "slave processes", "starting programs", "subprocess", 
      "subsidiary processes", "write data to Mathlink"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica immediately allows you to call both stand-alone programs and \
individual functions or methods within running programs. Mathematica's \
architecture allows external functionality to be represented in a symbolic \
form that can immediately be manipulated within Mathematica--and that often \
makes access to external functionality from within Mathematica more \
convenient even than from its own native environment.", "synonyms" -> {}, 
    "title" -> "Calling External Programs", "type" -> "Guide", "uri" -> 
    "guide/CallingExternalPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 63, 1, 70, "GuideTitle",
 CellID->29292],
Cell[685, 28, 666, 17, 70, "GuideAbstract",
 CellID->179498026],
Cell[1354, 47, 367, 13, 70, "GuideText",
 CellID->197638525],
Cell[1724, 62, 295, 9, 70, "GuideText",
 CellID->207953997],
Cell[2022, 73, 1008, 29, 70, "InlineGuideFunctionListing",
 CellID->202693632],
Cell[CellGroupData[{
Cell[3055, 106, 355, 10, 70, "GuideFunctionsSubsection",
 CellID->629466972],
Cell[3413, 118, 312, 12, 70, "GuideText",
 CellID->9567],
Cell[3728, 132, 330, 12, 70, "GuideText",
 CellID->22336],
Cell[4061, 146, 340, 12, 70, "GuideText",
 CellID->224666515],
Cell[4404, 160, 816, 23, 70, "InlineGuideFunctionListing",
 CellID->5019633]
}, Open  ]],
Cell[CellGroupData[{
Cell[5257, 188, 375, 12, 70, "GuideFunctionsSubsection",
 CellID->269734094],
Cell[5635, 202, 280, 9, 70, "GuideText",
 CellID->425009627],
Cell[5918, 213, 1076, 29, 70, "InlineGuideFunctionListing",
 CellID->318471685]
}, Open  ]],
Cell[CellGroupData[{
Cell[7031, 247, 384, 12, 70, "GuideFunctionsSubsection",
 CellID->12176040],
Cell[7418, 261, 278, 9, 70, "GuideText",
 CellID->46610314],
Cell[7699, 272, 1086, 29, 70, "InlineGuideFunctionListing",
 CellID->652177849]
}, Open  ]],
Cell[CellGroupData[{
Cell[8822, 306, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->303367770],
Cell[9057, 313, 430, 12, 70, "GuideText",
 CellID->320785531]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9536, 331, 58, 1, 70, "GuideTutorialsSection",
 CellID->18397],
Cell[9597, 334, 148, 3, 70, "GuideTutorial",
 CellID->31418],
Cell[9748, 339, 810, 24, 70, "GuideTutorial",
 CellID->19897],
Cell[10561, 365, 494, 14, 70, "GuideTutorial",
 CellID->9988562],
Cell[11058, 381, 398, 11, 70, "GuideTutorial",
 CellID->79147778],
Cell[11459, 394, 451, 12, 70, "GuideTutorial",
 CellID->91837830]
}, Open  ]],
Cell[CellGroupData[{
Cell[11947, 411, 59, 1, 70, "GuideMoreAboutSection",
 CellID->25828],
Cell[12009, 414, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[12201, 420, 158, 3, 70, "GuideMoreAbout",
 CellID->13851]
}, Open  ]],
Cell[12374, 426, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

