(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21857,        662]
NotebookOptionsPosition[     16350,        527]
NotebookOutlinePosition[     19578,        587]
CellTagsIndexPosition[     19535,        584]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Colors", "GuideTitle",
 CellID->2634],

Cell[TextData[{
 "Combining a new level of programmatic support for symbolic color with \
carefully chosen aesthetic color parametrizations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows a uniquely flexible and compelling approach to color and \
transparency in graphics and all other forms of display. "
}], "GuideAbstract",
 CellID->218612376],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Hue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hue"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["CMYKColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CMYKColor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["GrayLevel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GrayLevel"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " color models"
}], "GuideText",
 CellID->26362],

Cell[TextData[{
 Cell[TextData[ButtonBox["Lighter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Lighter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Darker",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Darker"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make colors lighter, darker"
}], "GuideText",
 CellID->116765339],

Cell[TextData[{
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " blend of colors"
}], "GuideText",
 CellID->18875],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Color Schemes \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ColorSchemes"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->245237945],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "hundreds of color schemes (gradients, named collections, etc.)"
}], "GuideText",
 CellID->46618994],

Cell[TextData[{
 "\"Gradients\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"Indexed\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"Physical\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"Rainbow\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"Temperature\"",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ColorSchemes"]
}], "InlineGuideFunctionListing",
 CellID->2210890]
}, Open  ]],

Cell[CellGroupData[{

Cell["Named Colors", "GuideFunctionsSubsection",
 CellID->399443739],

Cell[TextData[{
 Cell[TextData[ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Green",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Green"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Blue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Blue"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Black",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Black"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["White",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/White"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Gray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cyan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cyan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Magenta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Magenta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Yellow",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Yellow"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Brown",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Brown"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Orange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Orange"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pink"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Purple",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Purple"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4886],

Cell[TextData[{
 Cell[TextData[ButtonBox["LightRed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightRed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightGreen",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightGreen"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightBlue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightBlue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightGray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightGray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightCyan",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightCyan"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightMagenta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightMagenta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightYellow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightYellow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightBrown",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightBrown"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightOrange",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightOrange"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightPink",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightPink"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightPurple",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LightPurple"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->960069197],

Cell["\t", "GuideDelimiter",
 CellID->28433],

Cell[TextData[{
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " opacity level (0 for transparent)"
}], "GuideText",
 CellID->29869],

Cell["\t", "GuideDelimiter",
 CellID->20142],

Cell[TextData[{
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify a color for any object"
}], "GuideText",
 CellID->23844],

Cell["\t", "GuideDelimiter",
 CellID->1416],

Cell[TextData[{
 Cell[TextData[ButtonBox["Glow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Glow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " glow color for 3D graphics"
}], "GuideText",
 CellID->21881],

Cell[TextData[{
 Cell[TextData[ButtonBox["Specularity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Specularity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " shininess color for 3D graphics"
}], "GuideText",
 CellID->31998],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColors",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexColors"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["VertexNormals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexNormals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "data for color interpolation in polygons"
}], "GuideText",
 CellID->10322],

Cell["\t", "GuideDelimiter",
 CellID->18651],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorRules"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rules for determining colors for discrete data"
}], "GuideText",
 CellID->10021],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general function for determining colors from coordinates and values"
}], "GuideText",
 CellID->5699],

Cell["\t", "GuideDelimiterSubsection",
 CellID->639926509]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interactive Color Controls", "GuideFunctionsSubsection",
 CellID->6069105],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorSlider",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorSlider"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->65867445],

Cell["\t", "GuideDelimiter",
 CellID->9486113],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import, export with many color maps, depths, models"
}], "GuideText",
 CellID->64367921]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->10712],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "GuideMoreAboutSub",
 CellID->26869],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "GuideMoreAbout",
 CellID->2510]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1648450876],

Cell[TextData[{
 ButtonBox["Demonstrations related to Colors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22color%22+content%3ABlack+OR+Blend+OR+Blue+OR+Brown+OR+CMYKColor+OR+\
ColorData+OR+ColorFunction+OR+ColorRules+OR+ColorSetter+OR+ColorSlider+OR+\
Cyan+OR+Darker+OR+Export+OR+Glow+OR+Gray+OR+GrayLevel+OR+Green+OR+Hue+OR+\
Import+OR+LightBlue+OR+LightBrown+OR+LightCyan+OR+Lighter+OR+LightGray+OR+\
LightGreen+OR+LightMagenta+OR+LightOrange+OR+LightPink+OR+LightPurple+OR+\
LightRed+OR+LightYellow+OR+Magenta+OR+Opacity+OR+Orange+OR+Pink+OR+Purple+OR+\
Red+OR+RGBColor+OR+Specularity+OR+Style+OR+VertexColors+OR+VertexNormals+OR+\
White+OR+Yellow"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->650576843]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Colors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 25.1225862}", "context" -> "", 
    "keywords" -> {
     "additive color", "alpha channel", "black", "black-and-white display", 
      "blend", "blending colors", "Blinn shading", "blue", "brightness", 
      "choose color", "CMY", "CMYK", "color", "color blends", "color chooser",
       "color control", "color data", "color dialog", "color dithering", 
      "color function", "color gradients", "color interpolation", 
      "color lookup table", "color map", "colormap", "color model", 
      "color output", "color palette", "color picker", "color picking tool", 
      "color rules", "color selection dialog", "color selector", 
      "color setter", "color slider", "color space", "color spectrum", 
      "color swatch", "color wheel", "comma-separated values", 
      "computer-aided design", "continuous shading", "darker", "darkness", 
      "density", "device color", "device color model", "diffuse color", 
      "glow color", "Gouraud shading", "gray level", "grayscale", "HSV", 
      "hue saturation brightness", "image capture", "image processing", 
      "images", "intensity", "Lambertian diffuse lighting", "light blue", 
      "light brown", "light cyan", "light dithering", "lightening colors", 
      "lighter", "light gray", "light green", "light independent color", 
      "lighting", "lighting properties", "light magenta", "light orange", 
      "light pink", "light purple", "light red", "light yellow", 
      "metallic color", "metallic surface", "mixing colors", 
      "monochrome display", "opaque", "perceptive color space", "pigment", 
      "plastic color", "plastic surface", "raster conversion", "Rasters", 
      "RGB", "RGBA", "rgb color", "RGB color model", "shading equation", 
      "shading properties", "shininess", "spectrum", "specular color", 
      "specular exponent", "specular reflection", "spreadsheets", 
      "stereo-lithography", "styles", "subtractive color", 
      "subtractive color model", "surface lighting", "surface normals", 
      "surface reflection", "surface shading", "translucent", "transparent", 
      "vertex colors", "vertex normals"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Combining a new level of programmatic support for symbolic color with \
carefully chosen aesthetic color parametrizations, Mathematica allows a \
uniquely flexible and compelling approach to color and transparency in \
graphics and all other forms of display. ", "synonyms" -> {}, "title" -> 
    "Colors", "type" -> "Guide", "uri" -> "guide/Colors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 43, 1, 70, "GuideTitle",
 CellID->2634],
Cell[665, 28, 361, 8, 70, "GuideAbstract",
 CellID->218612376],
Cell[1029, 38, 607, 20, 70, "GuideText",
 CellID->26362],
Cell[1639, 60, 667, 19, 70, "GuideText",
 CellID->116765339],
Cell[2309, 81, 374, 11, 70, "GuideText",
 CellID->18875],
Cell[CellGroupData[{
Cell[2708, 96, 213, 5, 70, "GuideFunctionsSubsection",
 CellID->245237945],
Cell[2924, 103, 437, 12, 70, "GuideText",
 CellID->46618994],
Cell[3364, 117, 604, 25, 70, "InlineGuideFunctionListing",
 CellID->2210890]
}, Open  ]],
Cell[CellGroupData[{
Cell[4005, 147, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->399443739],
Cell[4076, 150, 2599, 77, 70, "InlineGuideFunctionListing",
 CellID->4886],
Cell[6678, 229, 3905, 98, 70, "InlineGuideFunctionListing",
 CellID->960069197],
Cell[10586, 329, 44, 1, 70, "GuideDelimiter",
 CellID->28433],
Cell[10633, 332, 396, 11, 70, "GuideText",
 CellID->29869],
Cell[11032, 345, 44, 1, 70, "GuideDelimiter",
 CellID->20142],
Cell[11079, 348, 389, 11, 70, "GuideText",
 CellID->23844],
Cell[11471, 361, 43, 1, 70, "GuideDelimiter",
 CellID->1416],
Cell[11517, 364, 383, 11, 70, "GuideText",
 CellID->21881],
Cell[11903, 377, 402, 11, 70, "GuideText",
 CellID->31998],
Cell[12308, 390, 700, 19, 70, "GuideText",
 CellID->10322],
Cell[13011, 411, 44, 1, 70, "GuideDelimiter",
 CellID->18651],
Cell[13058, 414, 270, 8, 70, "GuideText",
 CellID->10021],
Cell[13331, 424, 296, 8, 70, "GuideText",
 CellID->5699],
Cell[13630, 434, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->639926509]
}, Open  ]],
Cell[CellGroupData[{
Cell[13725, 440, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->6069105],
Cell[13808, 443, 552, 14, 70, "InlineGuideFunctionListing",
 CellID->65867445],
Cell[14363, 459, 46, 1, 70, "GuideDelimiter",
 CellID->9486113],
Cell[14412, 462, 398, 13, 70, "GuideText",
 CellID->64367921]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14859, 481, 59, 1, 70, "GuideMoreAboutSection",
 CellID->10712],
Cell[14921, 484, 153, 3, 70, "GuideMoreAboutSub",
 CellID->26869],
Cell[15077, 489, 148, 3, 70, "GuideMoreAbout",
 CellID->2510]
}, Open  ]],
Cell[CellGroupData[{
Cell[15262, 497, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1648450876],
Cell[15335, 500, 973, 22, 70, "GuideRelatedLinks",
 CellID->650576843]
}, Open  ]],
Cell[16323, 525, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

