(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13439,        459]
NotebookOptionsPosition[      8940,        340]
NotebookOutlinePosition[     11432,        390]
CellTagsIndexPosition[     11389,        387]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Complex Numbers", "GuideTitle",
 CellID->16549],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has fundamental support for both explicit complex numbers and symbolic \
complex variables",
 ". ",
 "All applicable mathematical functions support arbitrary precision \
evaluation for complex values of all parameters, and symbolic operations \
automatically treat complex variables with full generality. "
}], "GuideAbstract",
 CellID->15118364],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"], "TI"],
  ButtonBox["+",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"],
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"],
  ButtonBox["\[InvisibleSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"],
  StyleBox[ButtonBox["y",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", 
    RowBox[{"\[ImaginaryI]", " ", "y"}]}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->21718],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ") \[LongDash] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "=", 
    SqrtBox[
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath"],
 " (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " \"imaginary i\", or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]jj\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->3753],

Cell[TextData[{
 Cell[TextData[ButtonBox["Complex",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complex"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert a pair of reals to a complex number"
}], "GuideText",
 CellID->16139],

Cell["\t", "GuideDelimiter",
 CellID->12423],

Cell[TextData[{
 Cell[TextData[ButtonBox["Re",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Re"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " real part"
}], "GuideText",
 CellID->16279],

Cell[TextData[{
 Cell[TextData[ButtonBox["Im",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Im"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " imaginary part"
}], "GuideText",
 CellID->25996],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " absolute value"
}], "GuideText",
 CellID->16687],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arg",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Arg"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " argument (phase angle in radians)"
}], "GuideText",
 CellID->12529],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sign",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sign"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "normalized direction (",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "/", 
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}]}], 
   TraditionalForm]], "InlineMath"],
 ")"
}], "GuideText",
 CellID->35122600],

Cell[TextData[{
 Cell[TextData[ButtonBox["Conjugate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Conjugate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complex conjugate ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "\[Conjugate]"], TraditionalForm]], "InlineMath"],
 " (also entered with superscript ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]co\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->22549],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConjugateTranspose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Hermitian conjugate of a matrix (also entered with ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ct\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->17437],

Cell["\t", "GuideDelimiter",
 CellID->19866],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand symbolic expressions into real and imaginary parts"
}], "GuideText",
 CellID->12949],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand symbolic expressions ignoring branch cuts"
}], "GuideText",
 CellID->193],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpToTrig",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpToTrig"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["TrigToExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigToExp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert between complex exponentials and trig functions"
}], "GuideText",
 CellID->237742427],

Cell["\t", "GuideDelimiter",
 CellID->23195],

Cell[TextData[{
 Cell[TextData[ButtonBox["GaussianIntegers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " option for polynomial and number theory functions"
}], "GuideText",
 CellID->3297],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reduce equations and inequations over complex numbers"
}], "GuideText",
 CellID->28286],

Cell["\t", "GuideDelimiter",
 CellID->115702115],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "random complex number"
}], "GuideText",
 CellID->733590424]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->16282],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "GuideTutorial",
 CellID->12455],

Cell[TextData[ButtonBox["Expressions Involving Complex Variables",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsInvolvingComplexVariables"]], "GuideTutorial",
 CellID->25734]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18114],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "GuideMoreAbout",
 CellID->45837523],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/guide/QuaternionsPackage"]], "GuideMoreAbout",\

 CellID->282235928],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAboutSub",
 CellID->26679]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->607017963],

Cell[TextData[{
 ButtonBox["Demonstrations related to Complex Numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Abs+\
OR+Arg+OR+Complex+OR+ComplexExpand+OR+Conjugate+OR+ConjugateTranspose+OR+\
ExpToTrig+OR+GaussianIntegers+OR+I+OR+Im+OR+PowerExpand+OR+RandomComplex+OR+\
Re+OR+Reduce+OR+Sign+OR+TrigToExp)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->777053117]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 26.8413802}", "context" -> "", 
    "keywords" -> {
     "absolute value", "angle", "arc trig expansion", "arg", "argument", 
      "argument of complex number", "circular functions", "complex conjugate",
       "complex expand", "complex exponentials", "complex number", 
      "complex part", "complex powers", "complex variables", 
      "conjugate transpose", "conversion", "csgn", "domains", 
      "Euler's formula", "expanding into polar form", 
      "expanding into real and imaginary parts", "expansion", "exponentials", 
      "exponents", "exp to trig", "Gaussian integers", "Hermitian conjugate", 
      "Hermitian transpose", "hyperbolic functions", "Im", "imag", 
      "imaginary part", "imaginary unit", "\\Im (TeX)", "logarithm expansion",
       "logarithms", "magnitude of complex number", "phase", "phase-angle", 
      "phase shift", "polar angles", "power expand", "powers", "radicals", 
      "random complex", "random complex number", "Re", "real", "real part", 
      "regions", "\\Re (TeX)", "roots of polynomial", "sgn", "sign", "signum",
       "square roots", "surd", "symbolic complex expressions", 
      "symbolic frequency analysis", "Thue equations", 
      "transcendental equations", "transcendental inequalities", 
      "trigonometric functions", "trig to exp"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has fundamental support for both explicit complex numbers \
and symbolic complex variables. All applicable mathematical functions support \
arbitrary precision evaluation for complex values of all parameters, and \
symbolic operations automatically treat complex variables with full \
generality. ", "synonyms" -> {}, "title" -> "Complex Numbers", "type" -> 
    "Guide", "uri" -> "guide/ComplexNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 53, 1, 70, "GuideTitle",
 CellID->16549],
Cell[675, 28, 414, 10, 70, "GuideAbstract",
 CellID->15118364],
Cell[1092, 40, 691, 26, 70, "GuideText",
 CellID->21718],
Cell[1786, 68, 699, 24, 70, "GuideText",
 CellID->3753],
Cell[2488, 94, 261, 8, 70, "GuideText",
 CellID->16139],
Cell[2752, 104, 44, 1, 70, "GuideDelimiter",
 CellID->12423],
Cell[2799, 107, 217, 8, 70, "GuideText",
 CellID->16279],
Cell[3019, 117, 222, 8, 70, "GuideText",
 CellID->25996],
Cell[3244, 127, 224, 8, 70, "GuideText",
 CellID->16687],
Cell[3471, 137, 243, 8, 70, "GuideText",
 CellID->12529],
Cell[3717, 147, 404, 15, 70, "GuideText",
 CellID->35122600],
Cell[4124, 164, 498, 16, 70, "GuideText",
 CellID->22549],
Cell[4625, 182, 412, 12, 70, "GuideText",
 CellID->17437],
Cell[5040, 196, 44, 1, 70, "GuideDelimiter",
 CellID->19866],
Cell[5087, 199, 287, 8, 70, "GuideText",
 CellID->12949],
Cell[5377, 209, 272, 8, 70, "GuideText",
 CellID->193],
Cell[5652, 219, 410, 12, 70, "GuideText",
 CellID->237742427],
Cell[6065, 233, 44, 1, 70, "GuideDelimiter",
 CellID->23195],
Cell[6112, 236, 284, 8, 70, "GuideText",
 CellID->3297],
Cell[6399, 246, 269, 8, 70, "GuideText",
 CellID->28286],
Cell[6671, 256, 48, 1, 70, "GuideDelimiter",
 CellID->115702115],
Cell[6722, 259, 405, 12, 70, "GuideText",
 CellID->733590424]
}, Open  ]],
Cell[CellGroupData[{
Cell[7164, 276, 58, 1, 70, "GuideTutorialsSection",
 CellID->16282],
Cell[7225, 279, 144, 3, 70, "GuideTutorial",
 CellID->12455],
Cell[7372, 284, 193, 4, 70, "GuideTutorial",
 CellID->25734]
}, Open  ]],
Cell[CellGroupData[{
Cell[7602, 293, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18114],
Cell[7664, 296, 173, 3, 70, "GuideMoreAbout",
 CellID->45837523],
Cell[7840, 301, 168, 4, 70, "GuideMoreAbout",
 CellID->282235928],
Cell[8011, 307, 149, 3, 70, "GuideMoreAboutSub",
 CellID->26679]
}, Open  ]],
Cell[CellGroupData[{
Cell[8197, 315, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->607017963],
Cell[8269, 318, 629, 17, 70, "GuideRelatedLinks",
 CellID->777053117]
}, Open  ]],
Cell[8913, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

