(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11123,        346]
NotebookOptionsPosition[      6612,        236]
NotebookOutlinePosition[      9666,        295]
CellTagsIndexPosition[      9623,        292]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Computational Systems", "GuideTitle",
 CellID->13186],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the tool that has made possible Stephen Wolfram's exploration of the \
computational universe, and the emerging field of Wolfram Science (NKS). \
Whether for modeling, algorithm discovery or basic NKS, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has immediate built-in capabilities for the systematic study of a broad \
range of computational systems."
}], "GuideAbstract",
 CellID->109197940],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general cellular automaton in 1D, 2D, etc."
}], "GuideText",
 CellID->14018],

Cell[TextData[{
 Cell[TextData[ButtonBox["TuringMachine",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TuringMachine"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general Turing machine in 1D, 2D, etc."
}], "GuideText",
 CellID->9905],

Cell["\t", "GuideDelimiter",
 CellID->17958],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"],
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"],
  StyleBox[ButtonBox["rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply a rule"
}], "GuideText",
 CellID->7391],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " iteratively apply a function or evolution rule"
}], "GuideText",
 CellID->10202],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestWhileList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhileList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " iterate while checking for looping or termination"
}], "GuideText",
 CellID->3625],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReplace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplace"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["StringReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplaceList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rewrite, substitution and multiway systems"
}], "GuideText",
 CellID->26477],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " flatten out steps in 2D substitution systems, etc."
}], "GuideText",
 CellID->4414],

Cell["\t", "GuideDelimiter",
 CellID->9314],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "visualize arrays of data"
}], "GuideText",
 CellID->25824],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "visualize networks"
}], "GuideText",
 CellID->29334]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->25874],

Cell[TextData[ButtonBox["Cellular Automata",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CellularAutomata"]], "GuideTutorial",
 CellID->24372]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->11833],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAbout",
 CellID->28070],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->7487],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAboutSub",
 CellID->307192818],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->7518]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1096908358],

Cell[TextData[{
 ButtonBox["Demonstrations related to Computational Systems",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22simple+computational+systems%22+content%3AArrayFlatten+OR+ArrayPlot+OR+\
CellularAutomaton+OR+GraphPlot+OR+ListPlot+OR+NestList+OR+NestWhileList+OR+\
StringReplace+OR+StringReplaceList+OR+TreePlot+OR+TuringMachine"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->70358647]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Computational Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 28.7164282}", "context" -> "", 
    "keywords" -> {
     "additive cellular automata", "array automata", "automata", "block maps",
       "CA", "cell-automaton", "cell automaton", "cellular automaton", 
      "cellular automata", "conditional iteration", 
      "continuous mappings of the shift", "coupled map lattices", 
      "cycle detection", "data driven iteration", "digraph layout", 
      "discrete models", "draw a graph", "dynamic system", 
      "editing of strings", "elementary cellular automata", 
      "functional while operation", "graph drawing", "graph embedding", 
      "graph layout", "graph plot", "graph visualization", 
      "hierarchical graph layout", "iterated functions", 
      "iterated operations", "iteration of unary operators", 
      "iterative arrays", "join block matrices", "join lists", 
      "matrix structure plot", "models", "multiple string replacements", 
      "multiway systems", "network layout", "network visualization", 
      "point plot", "polyautomata", "production rules", "recursive drawing", 
      "replacement of characters", "replacement of substrings", 
      "replace part of string", "ReplaceString", "replace substring", 
      "rewriting of strings", "rule 30", "rule 90", "rule 110", 
      "rule numbers", "semi-Thue system", "sequential substitution systems", 
      "string replace", "string replace list", "string substitution", 
      "substitution in strings", "tesselation automata", "Thue system", 
      "totalistic cellular automata", "translation of strings", "tree plot", 
      "turing machine", "unary operators", "agent-based models", 
      "algorithm discovery", "A New Kind of Science", "discrete systems", 
      "NKS", "search-based programming", "simple programs", 
      "simulation models", "Wolfram Science"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica is the tool that has made possible Stephen Wolfram's \
exploration of the computational universe, and the emerging field of Wolfram \
Science (NKS). Whether for modeling, algorithm discovery or basic NKS, \
Mathematica has immediate built-in capabilities for the systematic study of a \
broad range of computational systems.", "synonyms" -> {}, "title" -> 
    "Computational Systems", "type" -> "Guide", "uri" -> 
    "guide/ComputationalSystemsAndDiscovery"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->13186],
Cell[681, 28, 475, 11, 70, "GuideAbstract",
 CellID->109197940],
Cell[1159, 41, 280, 8, 70, "GuideText",
 CellID->14018],
Cell[1442, 51, 412, 11, 70, "GuideText",
 CellID->9905],
Cell[1857, 64, 44, 1, 70, "GuideDelimiter",
 CellID->17958],
Cell[1904, 67, 434, 16, 70, "GuideText",
 CellID->7391],
Cell[2341, 85, 266, 8, 70, "GuideText",
 CellID->10202],
Cell[2610, 95, 278, 8, 70, "GuideText",
 CellID->3625],
Cell[2891, 105, 417, 12, 70, "GuideText",
 CellID->26477],
Cell[3311, 119, 422, 11, 70, "GuideText",
 CellID->4414],
Cell[3736, 132, 43, 1, 70, "GuideDelimiter",
 CellID->9314],
Cell[3782, 135, 378, 13, 70, "GuideText",
 CellID->25824],
Cell[4163, 150, 662, 19, 70, "GuideText",
 CellID->29334]
}, Open  ]],
Cell[CellGroupData[{
Cell[4862, 174, 58, 1, 70, "GuideTutorialsSection",
 CellID->25874],
Cell[4923, 177, 148, 3, 70, "GuideTutorial",
 CellID->24372]
}, Open  ]],
Cell[CellGroupData[{
Cell[5108, 185, 59, 1, 70, "GuideMoreAboutSection",
 CellID->11833],
Cell[5170, 188, 158, 3, 70, "GuideMoreAbout",
 CellID->28070],
Cell[5331, 193, 151, 3, 70, "GuideMoreAbout",
 CellID->7487],
Cell[5485, 198, 165, 3, 70, "GuideMoreAboutSub",
 CellID->307192818],
Cell[5653, 203, 150, 3, 70, "GuideMoreAboutSub",
 CellID->7518]
}, Open  ]],
Cell[CellGroupData[{
Cell[5840, 211, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1096908358],
Cell[5913, 214, 657, 17, 70, "GuideRelatedLinks",
 CellID->70358647]
}, Open  ]],
Cell[6585, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

