(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16350,        527]
NotebookOptionsPosition[     10769,        388]
NotebookOutlinePosition[     13815,        446]
CellTagsIndexPosition[     13772,        443]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Constructing Lists", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides powerful functions for constructing lists of any size and \
structure."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Range",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Range"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " form a list from a range of numbers or other objects ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "..."}], "}"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make a table of any dimension of values of an expression"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make an array of any dimension by applying a function to successive \
indices"
}], "GuideText",
 CellID->533083998],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "form of a constant array of any dimension"
}], "GuideText",
 CellID->252203126],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Normal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Normal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a list from a sparse array",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    StyleBox["position", "TI"], "\[Rule]", 
    StyleBox["value", "TI"]}]}]], "InlineFormula"],
 " specification"
}], "GuideText",
 CellID->647800946],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tuples",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tuples"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " all possible ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "-tuples from a list"
}], "GuideText",
 CellID->203862462],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subsets",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subsets"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RandomNumberGeneration"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make lists of random elements"
}], "GuideText",
 CellID->22158949],

Cell["\t", "GuideDelimiterSubsection",
 CellID->32660746],

Cell[CellGroupData[{

Cell["Lists from Iteration", "GuideFunctionsSubsection",
 CellID->84375263],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a list by successively iterating a function"
}], "GuideText",
 CellID->491727984],

Cell[TextData[{
 Cell[TextData[ButtonBox["FixedPointList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPointList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NestWhileList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhileList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppendTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppendTo"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->519770828],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sow",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sow"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Reap",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create lists of elements \"sown\" inside programs"
}], "GuideText",
 CellID->285707338],

Cell["\t", "GuideDelimiter",
 CellID->47115942],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make lists from digits in numbers"
}], "GuideText",
 CellID->14779963],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientList"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make lists from polynomials or equations"
}], "GuideText",
 CellID->361183484],

Cell["\t", "GuideDelimiter",
 CellID->5094384],

Cell[TextData[{
 Cell[TextData[ButtonBox["Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Characters"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make a list from the characters in a string"
}], "GuideText",
 CellID->575594002],

Cell[TextData[{
 Cell[TextData[ButtonBox["CharacterRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CharacterRange"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a list of a range of characters (e.g. \"a\" through \"z\")"
}], "GuideText",
 CellID->82006693],

Cell["\t", "GuideDelimiter",
 CellID->132564195],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make a list of possible pattern replacements"
}], "GuideText",
 CellID->220695127],

Cell["\t", "GuideDelimiterSubsection",
 CellID->58197080]
}, Open  ]],

Cell[CellGroupData[{

Cell["Importing Data as Lists", "GuideFunctionsSubsection",
 CellID->161615748],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileNames",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->441247014]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "GuideTutorial",\

 CellID->18761341],

Cell[TextData[ButtonBox["Building Lists from Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BuildingListsFromFunctions"]], "GuideTutorial",
 CellID->188919415],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "GuideTutorial",
 CellID->225333235]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructing Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 30.1227142}", "context" -> "", 
    "keywords" -> {
     "accumulating expressions", "alphabet", "appending", "append to", 
      "arrays", "bits", "character range", "coefficient arrays", 
      "coefficient list", "coefficient of a polynomial", 
      "collecting expressions", "combinations", "comma-separated values", 
      "conditional iteration", "constant array", "conversion", "converting", 
      "CSV format", "data driven iteration", "decimal digits", "digits", 
      "digit sequences", "digits of real numbers", "encapsulated PostScript", 
      "enumerating sublists", "excel format", "explode", "external data", 
      "find in Unix", "find list", "fixed point", "fixed point iteration", 
      "fixed point list", "functional while operation", "function iteration", 
      "generating tuples", "growing lists", "index in APL", 
      "input from data file", "integer digits", "iota in APL", 
      "iterated functions", "iterated operations", 
      "iteration of unary operators", "join lists", "k-subsets", "letters", 
      "levels", "lines of text", "linked lists", "list append", "lists", 
      "MAT format", "matrices", "nary forms", "nest list", "nest while list", 
      "perm", "permutations of lists", "position-value pairs", "powerset", 
      "ranges of characters", "reading arrays from data files", 
      "reading data files", "reading data from external programs", 
      "reading data from files", "reading data from pipes", 
      "reading data from programs", "reading data from spreadsheets", 
      "reading data from streams", "reading matrices from data files", 
      "read list", "real digits", "records", "replace list", 
      "selecting objects with ordering", "selecting sublists", 
      "select randomly", "sequence", "sequences", "set exponential", "span", 
      "sparse array", "sparse matrix", "sparse representation", 
      "sparse vector", "spreadsheets", "sublists", "SymbolicXML", 
      "tab-delimited data", "tables", "tabular data", "tabulation of values", 
      "TSV format", "vectors", "XLS format"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides powerful functions for constructing lists of any \
size and structure.", "synonyms" -> {}, "title" -> "Constructing Lists", 
    "type" -> "Guide", "uri" -> "guide/ConstructingLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 190, 6, 70, "GuideAbstract",
 CellID->2001916300],
Cell[875, 36, 409, 13, 70, "GuideText",
 CellID->203374175],
Cell[1287, 51, 280, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1570, 62, 295, 9, 70, "GuideText",
 CellID->533083998],
Cell[1868, 73, 425, 12, 70, "GuideText",
 CellID->252203126],
Cell[2296, 87, 544, 18, 70, "GuideText",
 CellID->647800946],
Cell[2843, 107, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2894, 110, 314, 11, 70, "GuideText",
 CellID->203862462],
Cell[3211, 123, 603, 17, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[3817, 142, 825, 22, 70, "GuideText",
 CellID->22158949],
Cell[4645, 166, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->32660746],
Cell[CellGroupData[{
Cell[4727, 171, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->84375263],
Cell[4805, 174, 279, 9, 70, "GuideText",
 CellID->491727984],
Cell[5087, 185, 830, 23, 70, "InlineGuideFunctionListing",
 CellID->519770828],
Cell[5920, 210, 382, 12, 70, "GuideText",
 CellID->285707338],
Cell[6305, 224, 47, 1, 70, "GuideDelimiter",
 CellID->47115942],
Cell[6355, 227, 402, 13, 70, "GuideText",
 CellID->14779963],
Cell[6760, 242, 428, 13, 70, "GuideText",
 CellID->361183484],
Cell[7191, 257, 46, 1, 70, "GuideDelimiter",
 CellID->5094384],
Cell[7240, 260, 276, 9, 70, "GuideText",
 CellID->575594002],
Cell[7519, 271, 298, 9, 70, "GuideText",
 CellID->82006693],
Cell[7820, 282, 48, 1, 70, "GuideDelimiter",
 CellID->132564195],
Cell[7871, 285, 279, 9, 70, "GuideText",
 CellID->220695127],
Cell[8153, 296, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->58197080]
}, Open  ]],
Cell[CellGroupData[{
Cell[8247, 302, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->161615748],
Cell[8329, 305, 1030, 29, 70, "InlineGuideFunctionListing",
 CellID->441247014]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9408, 340, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9473, 343, 154, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[9630, 348, 158, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[9791, 353, 176, 4, 70, "GuideTutorial",
 CellID->18761341],
Cell[9970, 359, 174, 3, 70, "GuideTutorial",
 CellID->188919415],
Cell[10147, 364, 157, 3, 70, "GuideTutorial",
 CellID->225333235]
}, Open  ]],
Cell[CellGroupData[{
Cell[10341, 372, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10406, 375, 159, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10568, 380, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[10742, 386, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

