(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8251,        262]
NotebookOptionsPosition[      5019,        177]
NotebookOutlinePosition[      6975,        219]
CellTagsIndexPosition[      6932,        216]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Continued Fractions & Rational Approximations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Continued fractions can be thought of as an alternative to digit sequences \
for representing numbers, based on division rather than multiplication by a \
base. Studied occasionally for at least half a millennium, continued \
fractions have become increasingly important through their applications to \
dynamical systems theory and number theoretical algorithms. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has highly efficient original algorithms for finding large numbers of \
terms in continued fractions, as well as for handling exact continued \
fractions for quadratic irrationals."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "continued fraction expansion"
}], "GuideText",
 CellID->31245],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromContinuedFraction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct exact or inexact numbers from continued fractions"
}], "GuideText",
 CellID->32764],

Cell["\t", "GuideDelimiter",
 CellID->88862492],

Cell[TextData[{
 Cell[TextData[ButtonBox["Convergents",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Convergents"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a list of successive convergents of a continued fraction"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rationalize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationalize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find rational approximations"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->169497285],

Cell[TextData[{
 Cell[TextData[ButtonBox["QuadraticIrrationalQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuadraticIrrationalQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test for a quadratic irrational (repeating continued fraction)"
}], "GuideText",
 CellID->631172880]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Integer and Number Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAboutSub",
 CellID->756476160],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->224700103],

Cell[TextData[{
 ButtonBox["Demonstrations related to Continued Fractions & Rational \
Approximations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ContinuedFraction+OR+Convergents+OR+FromContinuedFraction+OR+\
QuadraticIrrationalQ+OR+Rationalize)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->142545633]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Continued Fractions & Rational Approximations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 31.3571208}", "context" -> "", 
    "keywords" -> {
     "approximation", "continued fraction", "continued fractions", 
      "convergents", "exact numbers", "fraction expansion", 
      "from continued fraction", "infinite fraction", "number representation",
       "partial quotients", "quadratic irrational", "quadratic irrationals", 
      "rational approximation", "recursive fraction", "representation", 
      "surds"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Continued fractions can be thought of as an alternative to digit \
sequences for representing numbers, based on division rather than \
multiplication by a base. Studied occasionally for at least half a \
millennium, continued fractions have become increasingly important through \
their applications to dynamical systems theory and number theoretical \
algorithms. Mathematica has highly efficient original algorithms for finding \
large numbers of terms in continued fractions, as well as for handling exact \
continued fractions for quadratic irrationals.", "synonyms" -> {}, "title" -> 
    "Continued Fractions & Rational Approximations", "type" -> "Guide", "uri" -> 
    "guide/ContinuedFractionsAndRationalApproximations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 87, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[709, 28, 659, 12, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1371, 42, 271, 9, 70, "GuideText",
 CellID->31245],
Cell[1645, 53, 310, 9, 70, "GuideText",
 CellID->32764],
Cell[1958, 64, 47, 1, 70, "GuideDelimiter",
 CellID->88862492],
Cell[2008, 67, 436, 12, 70, "GuideText",
 CellID->203374175],
Cell[2447, 81, 264, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2714, 92, 48, 1, 70, "GuideDelimiter",
 CellID->169497285],
Cell[2765, 95, 460, 12, 70, "GuideText",
 CellID->631172880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3262, 112, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3327, 115, 198, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[3528, 121, 157, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[3722, 129, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3787, 132, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[3943, 137, 145, 3, 70, "GuideMoreAboutSub",
 CellID->756476160],
Cell[4091, 142, 208, 5, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[4336, 152, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->224700103],
Cell[4408, 155, 569, 17, 70, "GuideRelatedLinks",
 CellID->142545633]
}, Open  ]],
Cell[4992, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

