(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19017,        522]
NotebookOptionsPosition[     13476,        387]
NotebookOutlinePosition[     16860,        453]
CellTagsIndexPosition[     16817,        450]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Continuous Statistical Distributions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a general symbolic representation of statistical distributions that \
makes it possible to perform not only numerical but also symbolic operations \
on distributions",
 ". "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Normal and Related Distributions", "GuideFunctionsSubsection",
 CellID->238322343],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogNormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HalfNormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HalfNormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseGaussianDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InverseGaussianDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->275363136]
}, Open  ]],

Cell[CellGroupData[{

Cell["Distributions Associated with Normally Distributed Samples", \
"GuideFunctionsSubsection",
 CellID->141240358],

Cell[TextData[{
 Cell[TextData[ButtonBox["StudentTDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FRatioDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FRatioDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->950518541],

Cell[TextData[{
 Cell[TextData[ButtonBox["NoncentralStudentTDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NoncentralChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NoncentralChiSquareDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NoncentralFRatioDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->1013584830]
}, Open  ]],

Cell[CellGroupData[{

Cell["Piecewise Linear Distributions", "GuideFunctionsSubsection",
 CellID->2655845],

Cell[TextData[{
 Cell[TextData[ButtonBox["UniformDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/UniformDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TriangularDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->386613508]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential-Related Distributions", "GuideFunctionsSubsection",
 CellID->99523200],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExponentialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaplaceDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GammaDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GammaDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->17974124],

Cell[TextData[{
 Cell[TextData[ButtonBox["RayleighDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RayleighDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaxwellDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogisticDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogisticDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->107064667]
}, Open  ]],

Cell[CellGroupData[{

Cell["Power-Law-Related Distributions", "GuideFunctionsSubsection",
 CellID->248219865],

Cell[TextData[{
 Cell[TextData[ButtonBox["BetaDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BetaDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CauchyDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParetoDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->44865490]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extreme Value Distributions", "GuideFunctionsSubsection",
 CellID->366183515],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExtremeValueDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeibullDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GumbelDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->220847656]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Using Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/guide/HypothesisTestingPackage"]], \
"GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"]], \
"GuideMoreAboutSub",
 CellID->1891277696]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1258379695],

Cell[TextData[{
 ButtonBox["Demonstrations related to Continuous Statistical Distributions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BetaDistribution+OR+CauchyDistribution+OR+ChiDistribution+OR+\
ChiSquareDistribution+OR+ExponentialDistribution+OR+ExtremeValueDistribution+\
OR+FRatioDistribution+OR+GammaDistribution+OR+GumbelDistribution+OR+\
HalfNormalDistribution+OR+InverseGaussianDistribution+OR+LaplaceDistribution+\
OR+LogisticDistribution+OR+LogNormalDistribution+OR+MaxwellDistribution+OR+\
NoncentralChiSquareDistribution+OR+NoncentralFRatioDistribution+OR+\
NoncentralStudentTDistribution+OR+NormalDistribution+OR+ParetoDistribution+OR+\
RayleighDistribution+OR+StudentTDistribution+OR+TriangularDistribution+OR+\
UniformDistribution+OR+WeibullDistribution)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->314949685]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Continuous Statistical Distributions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 34.1228166}", "context" -> "", 
    "keywords" -> {
     "beta distribution", "Bradford distribution", "Cauchy distribution", 
      "CDF Cauchy", "chi distribution", "chi squared distribution", 
      "chi square distribution", "distribution of lifetimes", 
      "double exponential distribution", "Erlang distribution", 
      "exponential distribution", "extreme-value distribution", 
      "extreme value distribution", "F distribution", 
      "first passage times in Brownian motion", "Fisher's F distribution", 
      "Fisher-Tippett distribution", "F ratio distribution", 
      "gamma distribution", "Gaussian distribution", "Gaussian integral", 
      "Gauss integral", "Gumbel distribution", "half-normal distribution", 
      "half normal distribution", "inverse Gaussian distribution", 
      "Laplace distribution", "logistic distribution", "lognormal", 
      "log normal distribution", "lognormal distribution", 
      "log\\[Hyphen]Weibull distribution", "Maxwell distribution", 
      "Maxwell-Boltzmann distribution", "mean Cauchy", 
      "minimum extreme value distribution", 
      "noncentral chi-squared distribution", 
      "noncentral chi squared distribution", 
      "noncentral chi-square distribution", 
      "noncentral chi square distribution", "noncentral F distribution", 
      "noncentral Fisher's F distribution", "noncentral F ratio distribution",
       "noncentral ratio distribution", "noncentral student distribution", 
      "noncentral Student's t distribution", 
      "noncentral Student t distribution", "noncentral t distribution", 
      "normal distribution", "Pareto distribution", "PDF Cauchy", 
      "Pearson chi square", "Pearson chi squared", "power law", 
      "power-law distribution", "power law distribution", 
      "ratio distribution", "Rayleigh distribution", 
      "rectangular distribution", "sech squared distribution", 
      "sech square distribution", "standard deviation Cauchy", 
      "standard normal distribution", "student distribution", 
      "symmetric triangular distribution", "t distribution", 
      "triangle distribution", "triangular distribution", 
      "uniform distribution", "waiting time distribution", 
      "Wald distribution", "Weibull distribution"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has a general symbolic representation of statistical \
distributions that makes it possible to perform not only numerical but also \
symbolic operations on distributions. ", "synonyms" -> {}, "title" -> 
    "Continuous Statistical Distributions", "type" -> "Guide", "uri" -> 
    "guide/ContinuousStatisticalDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 78, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[700, 28, 287, 8, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1012, 40, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->238322343],
Cell[1103, 43, 1507, 36, 70, "InlineGuideFunctionListing",
 CellID->275363136]
}, Open  ]],
Cell[CellGroupData[{
Cell[2647, 84, 116, 2, 70, "GuideFunctionsSubsection",
 CellID->141240358],
Cell[2766, 88, 1109, 26, 70, "InlineGuideFunctionListing",
 CellID->950518541],
Cell[3878, 116, 1179, 29, 70, "InlineGuideFunctionListing",
 CellID->1013584830]
}, Open  ]],
Cell[CellGroupData[{
Cell[5094, 150, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->2655845],
Cell[5181, 153, 736, 17, 70, "InlineGuideFunctionListing",
 CellID->386613508]
}, Open  ]],
Cell[CellGroupData[{
Cell[5954, 175, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->99523200],
Cell[6045, 178, 1108, 26, 70, "InlineGuideFunctionListing",
 CellID->17974124],
Cell[7156, 206, 1476, 35, 70, "InlineGuideFunctionListing",
 CellID->107064667]
}, Open  ]],
Cell[CellGroupData[{
Cell[8669, 246, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->248219865],
Cell[8759, 249, 1094, 26, 70, "InlineGuideFunctionListing",
 CellID->44865490]
}, Open  ]],
Cell[CellGroupData[{
Cell[9890, 280, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->366183515],
Cell[9976, 283, 1113, 26, 70, "InlineGuideFunctionListing",
 CellID->220847656]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11138, 315, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11203, 318, 166, 3, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[11406, 326, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11471, 329, 173, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[11647, 334, 174, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[11824, 339, 193, 5, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[12020, 346, 209, 5, 70, "GuideMoreAboutSub",
 CellID->1891277696]
}, Open  ]],
Cell[CellGroupData[{
Cell[12266, 356, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1258379695],
Cell[12339, 359, 1095, 23, 70, "GuideRelatedLinks",
 CellID->314949685]
}, Open  ]],
Cell[13449, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

