(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18388,        599]
NotebookOptionsPosition[     12261,        439]
NotebookOutlinePosition[     15264,        496]
CellTagsIndexPosition[     15221,        493]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Cryptographic Number Theory", "GuideTitle",
 CellID->19801],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s extensive base of state-of-the-art algorithms, efficient handling of \
very long integers, and powerful built-in language make it uniquely suited to \
both research and implementation of cryptographic number theory."
}], "GuideAbstract",
 CellID->22850],

Cell[CellGroupData[{

Cell["Encryption and Decryption", "GuideFunctionsSubsection",
 CellID->75216367],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerMod"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute modular powers of integers"
}], "GuideText",
 CellID->188571608],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerModList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowerModList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute modular inverses, with negative and fractional powers"
}], "GuideText",
 CellID->713281302],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialMod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitOr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitOr"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitSet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitSet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitGet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitGet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->727232915],

Cell["\t", "GuideDelimiterSubsection",
 CellID->296568343]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Generation", "GuideFunctionsSubsection",
 CellID->252305720],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pseudorandom prime"
}], "GuideText",
 CellID->7337726],

Cell[TextData[{
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime"
}], "GuideText",
 CellID->19405],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test for primality"
}], "GuideText",
 CellID->499818377],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimitiveRoot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CarmichaelLambda",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MoebiusMu",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MoebiusMu"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->404442029],

Cell["\t", "GuideDelimiterSubsection",
 CellID->12955077]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cryptanalysis", "GuideFunctionsSubsection",
 CellID->2718049],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "complete or incomplete integer factorization"
}], "GuideText",
 CellID->14442560],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultiplicativeOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute the discrete logarithm"
}], "GuideText",
 CellID->469095634],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerPhi"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Euler totient function"
}], "GuideText",
 CellID->307759250],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve multivariate quadratic polynomials"
}], "GuideText",
 CellID->912433790],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find frequencies of elements in a list"
}], "GuideText",
 CellID->517832567],

Cell["\t", "GuideDelimiterSubsection",
 CellID->14485]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lattice-Oriented Problems", "GuideFunctionsSubsection",
 CellID->677690667],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find short basis vectors in an integer lattice"
}], "GuideText",
 CellID->30910557],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "properties of named lattices"
}], "GuideText",
 CellID->129716878],

Cell["\t", "GuideDelimiterSubsection",
 CellID->193938678]
}, Open  ]],

Cell[CellGroupData[{

Cell["Textual Data", "GuideFunctionsSubsection",
 CellID->163406574],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " compute MD5 and other hash codes"
}], "GuideText",
 CellID->53600181],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FromCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert between strings and character codes"
}], "GuideText",
 CellID->500647514],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1002960865]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Forms of Cryptography", "GuideFunctionsSubsection",
 CellID->178501110],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "efficiently compute general block maps"
}], "GuideText",
 CellID->55973657]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->23216],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->1626]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->8526],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->13357],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "GuideMoreAboutSub",
 CellID->18492087],

Cell[TextData[ButtonBox["General Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->19914],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->1595],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "GuideMoreAbout",
 CellID->29337],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FiniteFields/guide/FiniteFieldsPackage"]], "GuideMoreAboutSub",
 CellID->23869],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->770982185],

Cell[TextData[{
 ButtonBox["Demonstrations related to Cryptographic Number Theory",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22cryptanalysis%22+content%3ABitAnd+OR+BitGet+OR+BitOr+OR+BitSet+OR+BitXor+OR+\
CarmichaelLambda+OR+CellularAutomaton+OR+EulerPhi+OR+FactorInteger+OR+\
FileHash+OR+FromCharacterCode+OR+Hash+OR+JacobiSymbol+OR+LatticeData+OR+\
LatticeReduce+OR+Mod+OR+MoebiusMu+OR+MultiplicativeOrder+OR+PolynomialMod+OR+\
PowerMod+OR+PowerModList+OR+Prime+OR+PrimeQ+OR+PrimitiveRoot+OR+RandomPrime+\
OR+Reduce+OR+Tally+OR+ToCharacterCode"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->186842680]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cryptographic Number Theory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 38.0447920}", "context" -> "", 
    "keywords" -> {
     "aliquant", "bit and", "bit get", "bit or", "bit set", "bit xor", 
      "carry", "checksum", "chinese remainder theorem", 
      "combinatorial algorithms", "complex variables", "congruence", 
      "continuous mappings of the shift", "CRC", 
      "cryptographic hash function", "cyclic indices", "data digest", 
      "data integrity", "decomposition into primes", "digest", 
      "digital fingerprint", "Diophantine equations", "discrete log", 
      "discrete logarithm", "discrete models", "elementary cellular automata",
       "equivalence class counting", "Euler phi", "Euler totient", 
      "factoring", "factor integer", "factors", "file hash", "finite fields", 
      "frequencies", "FromASCII (Version 1 function)", "from character code", 
      "gather", "Gaussian integers", "Groebner basis", "group generator", 
      "group order", "half adder", "hash", "hash code", "hashcode", 
      "hash function", "hashing", "hash value", "ifact", "index function", 
      "integer equations", "integer factoring", "inverses in finite fields", 
      "irem", "isprime", "lattice", "lattice reduce", "mask", "MD2", "MD5", 
      "mobius", "Mobius function", "models", "modp", "mods", 
      "modular equations", "modular inverses", "modular powers", 
      "modular root", "modulo", "Moebius", "Moebius function", "Moebius mu", 
      "mu", "multiplicative order", "multiplicities", "power mod", 
      "power mod list", "powers in finite fields", "primality testing", 
      "prime", "prime factors", "primes", "pseudoprime test", "random number",
       "random prime", "SHA", "SHA1", "SHA2", "SHA-256", "SHA-384", "SHA-512",
       "testing for primality of integers", "testing for prime", "ToASCII", 
      "to character code", "totalistic cellular automata", 
      "totient function"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica's extensive base of state-of-the-art algorithms, efficient \
handling of very long integers, and powerful built-in language make it \
uniquely suited to both research and implementation of cryptographic number \
theory.", "synonyms" -> {}, "title" -> "Cryptographic Number Theory", "type" -> 
    "Guide", "uri" -> "guide/CryptographicNumberTheory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->19801],
Cell[687, 28, 323, 7, 70, "GuideAbstract",
 CellID->22850],
Cell[CellGroupData[{
Cell[1035, 39, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->75216367],
Cell[1118, 42, 263, 9, 70, "GuideText",
 CellID->188571608],
Cell[1384, 53, 443, 12, 70, "GuideText",
 CellID->713281302],
Cell[1830, 67, 1506, 41, 70, "InlineGuideFunctionListing",
 CellID->727232915],
Cell[3339, 110, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->296568343]
}, Open  ]],
Cell[CellGroupData[{
Cell[3434, 116, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->252305720],
Cell[3507, 119, 396, 12, 70, "GuideText",
 CellID->7337726],
Cell[3906, 133, 368, 14, 70, "GuideText",
 CellID->19405],
Cell[4277, 149, 243, 9, 70, "GuideText",
 CellID->499818377],
Cell[4523, 160, 1191, 32, 70, "InlineGuideFunctionListing",
 CellID->404442029],
Cell[5717, 194, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->12955077]
}, Open  ]],
Cell[CellGroupData[{
Cell[5811, 200, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->2718049],
Cell[5881, 203, 282, 9, 70, "GuideText",
 CellID->14442560],
Cell[6166, 214, 281, 9, 70, "GuideText",
 CellID->469095634],
Cell[6450, 225, 251, 9, 70, "GuideText",
 CellID->307759250],
Cell[6704, 236, 265, 9, 70, "GuideText",
 CellID->912433790],
Cell[6972, 247, 406, 12, 70, "GuideText",
 CellID->517832567],
Cell[7381, 261, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->14485]
}, Open  ]],
Cell[CellGroupData[{
Cell[7472, 267, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->677690667],
Cell[7556, 270, 284, 9, 70, "GuideText",
 CellID->30910557],
Cell[7843, 281, 263, 9, 70, "GuideText",
 CellID->129716878],
Cell[8109, 292, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->193938678]
}, Open  ]],
Cell[CellGroupData[{
Cell[8204, 298, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->163406574],
Cell[8275, 301, 519, 15, 70, "GuideText",
 CellID->53600181],
Cell[8797, 318, 426, 12, 70, "GuideText",
 CellID->500647514],
Cell[9226, 332, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1002960865]
}, Open  ]],
Cell[CellGroupData[{
Cell[9322, 338, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->178501110],
Cell[9408, 341, 284, 9, 70, "GuideText",
 CellID->55973657]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9741, 356, 58, 1, 70, "GuideTutorialsSection",
 CellID->23216],
Cell[9802, 359, 193, 4, 70, "GuideTutorial",
 CellID->1626]
}, Open  ]],
Cell[CellGroupData[{
Cell[10032, 368, 58, 1, 70, "GuideMoreAboutSection",
 CellID->8526],
Cell[10093, 371, 163, 3, 70, "GuideMoreAbout",
 CellID->13357],
Cell[10259, 376, 163, 3, 70, "GuideMoreAboutSub",
 CellID->18492087],
Cell[10425, 381, 146, 3, 70, "GuideMoreAbout",
 CellID->19914],
Cell[10574, 386, 145, 3, 70, "GuideMoreAbout",
 CellID->1595],
Cell[10722, 391, 138, 3, 70, "GuideMoreAbout",
 CellID->29337],
Cell[10863, 396, 172, 4, 70, "GuideMoreAboutSub",
 CellID->23869],
Cell[11038, 402, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[11278, 411, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->770982185],
Cell[11350, 414, 869, 20, 70, "GuideRelatedLinks",
 CellID->186842680]
}, Open  ]],
Cell[12234, 437, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

