(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11211,        353]
NotebookOptionsPosition[      6775,        241]
NotebookOutlinePosition[      9255,        290]
CellTagsIndexPosition[      9212,        287]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Curve Fitting & Approximate Functions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are state-of-the-art constrained nonlinear fitting capabilities, \
conveniently accessed with models given directly in symbolic form",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports unique symbolic interpolating functions that can immediately \
be used throughout the system to efficiently represent approximate numerical \
functions. "
}], "GuideAbstract",
 CellID->322241876],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a general nonlinear fit, potentially including parameter constraints"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->333194079],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "linear least-squares fit to a list of symbolic functions"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solution to a least-squares problem in matrix form"
}], "GuideText",
 CellID->16534819],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an interpolation to data in any number of dimensions"
}], "GuideText",
 CellID->636739653],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListInterpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListInterpolation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FunctionInterpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionInterpolation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolatingFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " represent an approximate function to be evaluated repeatedly"
}], "GuideText",
 CellID->365991013],

Cell["\t", "GuideDelimiter",
 CellID->21349859],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolatingPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a symbolic interpolating polynomial"
}], "GuideText",
 CellID->725716747]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Manipulating Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingNumericalData"]], "GuideTutorial",
 CellID->47245040],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->176200997]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAbout",
 CellID->272406596],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "GuideMoreAbout",
 CellID->77088598],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->1764990],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->1798777425],

Cell[TextData[ButtonBox["Splines Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Splines/guide/SplinesPackage"]], "GuideMoreAboutSub",
 CellID->57729256],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"GuideMoreAboutSub",
 CellID->17137],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2128740944],

Cell[TextData[{
 ButtonBox["Demonstrations related to Curve Fitting & Approximate Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
FindFit+OR+Fit+OR+FunctionInterpolation+OR+InterpolatingFunction+OR+\
InterpolatingPolynomial+OR+Interpolation+OR+LeastSquares+OR+ListInterpolation)\
"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->36350880]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Curve Fitting & Approximate Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 42.3105262}", "context" -> "", 
    "keywords" -> {
     "approximate array", "approximate formulas", "approximate functions", 
      "approximation of functions", "arrays", "bezier curve", 
      "bilinear interpolation", "Birkhoff interpolation", "b-spline", 
      "b spline", "chi squared", "cubic spline", "curve fitting", 
      "extrapolation", "find fit", "fits", "fitting curves", 
      "fitting differential equations", "fitting of data", "fitting surfaces",
       "function interpolation", "grid data", "grid interpolation", 
      "Hermite interpolation", "Hermite polynomial interpolation", "interp", 
      "interpolate data", "interpolate equation", "interpolate formula", 
      "interpolate numbers", "interpolate table", "interpolating function", 
      "interpolating polynomial", "Interpolation", "least-squares", 
      "least squares", "least-squares fits", "linear fits", 
      "linear interpolation", "list interpolation", "Newton interpolation", 
      "nonlinear fitting", "piecewise polynomial interpolation", "polynomial",
       "polynomial fit", "polynomial interpolation", "reinterpolation", 
      "resampling", "splines", "testing models", "trend line"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Built into Mathematica are state-of-the-art constrained nonlinear \
fitting capabilities, conveniently accessed with models given directly in \
symbolic form. Mathematica also supports unique symbolic interpolating \
functions that can immediately be used throughout the system to efficiently \
represent approximate numerical functions. ", "synonyms" -> {}, "title" -> 
    "Curve Fitting & Approximate Functions", "type" -> "Guide", "uri" -> 
    "guide/CurveFittingAndApproximateFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 79, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[701, 28, 487, 13, 70, "GuideAbstract",
 CellID->322241876],
Cell[1191, 43, 301, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1495, 54, 48, 1, 70, "GuideDelimiter",
 CellID->333194079],
Cell[1546, 57, 275, 9, 70, "GuideText",
 CellID->203374175],
Cell[1824, 68, 431, 12, 70, "GuideText",
 CellID->16534819],
Cell[2258, 82, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2309, 85, 296, 9, 70, "GuideText",
 CellID->636739653],
Cell[2608, 96, 439, 11, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[3050, 109, 310, 8, 70, "GuideText",
 CellID->365991013],
Cell[3363, 119, 47, 1, 70, "GuideDelimiter",
 CellID->21349859],
Cell[3413, 122, 304, 9, 70, "GuideText",
 CellID->725716747]
}, Open  ]],
Cell[CellGroupData[{
Cell[3754, 136, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3819, 139, 144, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[3966, 144, 198, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[4167, 150, 170, 3, 70, "GuideTutorial",
 CellID->47245040],
Cell[4340, 155, 181, 4, 70, "GuideTutorial",
 CellID->176200997]
}, Open  ]],
Cell[CellGroupData[{
Cell[4558, 164, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4623, 167, 137, 3, 70, "GuideMoreAbout",
 CellID->272406596],
Cell[4763, 172, 171, 3, 70, "GuideMoreAbout",
 CellID->77088598],
Cell[4937, 177, 188, 5, 70, "GuideMoreAboutSub",
 CellID->1764990],
Cell[5128, 184, 200, 5, 70, "GuideMoreAboutSub",
 CellID->1798777425],
Cell[5331, 191, 156, 3, 70, "GuideMoreAboutSub",
 CellID->57729256],
Cell[5490, 196, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[5644, 201, 204, 5, 70, "GuideMoreAboutSub",
 CellID->17137],
Cell[5851, 208, 163, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[6051, 216, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2128740944],
Cell[6124, 219, 609, 17, 70, "GuideRelatedLinks",
 CellID->36350880]
}, Open  ]],
Cell[6748, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

