(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12137,        368]
NotebookOptionsPosition[      8147,        268]
NotebookOutlinePosition[     10545,        317]
CellTagsIndexPosition[     10502,        314]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Exploratory Data Analysis", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " efficiently implements state-of-the-art data classification algorithms, \
allowing you to search for nearest neighbors and do cluster analysis on large \
datasets. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count the number of elements that lie in bins"
}], "GuideText",
 CellID->317656092],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->43530358],

Cell["\t", "GuideDelimiter",
 CellID->401084901],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find clusters in numerical, discrete and string data"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find nearest neighbors in any space of data"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["NearestFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NearestFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DistanceFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DistanceFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->373541804],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Distance Measures \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DistanceAndDissimilarityMeasures"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->320132630],

Cell[TextData[{
 Cell[TextData[ButtonBox["EuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ManhattanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EditDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EditDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->432720441],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list, count elements matching a pattern"
}], "GuideText",
 CellID->303951447],

Cell[TextData[{
 Cell[TextData[ButtonBox["Split",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Split"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "split data into runs"
}], "GuideText",
 CellID->402139527]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "GuideTutorial",\

 CellID->104670830],

Cell[TextData[ButtonBox["Using Nearest",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingNearest"]], "GuideTutorial",
 CellID->398138454]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Data Fitting",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAboutSub",
 CellID->17730359],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/guide/HierarchicalClusteringPackage"]], \
"GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exploratory Data Analysis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 44.4512060}", "context" -> "", 
    "keywords" -> {
     "agglomeration", "aggregating data", "bin counts", "bin lists", 
      "binning", "binning of data", "categorizing data", "category counts", 
      "CDF", "census", "city block distance", "cluster", "cluster analysis", 
      "clustering", "clustering of data", "confidence intervals", "deciles", 
      "density estimation", "distance function", "distinct elements in lists",
       "edit distance", "empirical distribution", 
      "equivalence class counting", "Euclidean distance", "Euclidean norm", 
      "find clusters", "frequencies", "gather", "grid distance", 
      "grouping of data", "histogram", "interquartile range", "inverse CDF", 
      "Levenshtein distance", "Manhattan distance", "Manhattan metric", 
      "mode", "most frequent value", "multiplicities", "nearest function", 
      "number of occurrences", "order statistics", "partitioning of data", 
      "patterns", "percentiles", "quantile", "quartiles", "range counts", 
      "remove duplicates", "run-length encoding", "run length encoding", 
      "statistical mode", "string distance", "string metric", "tally", 
      "taxi cab distance", "taxicab distance", "taxicab metric", 
      "union of sets", "uniq", "unique elements in lists", 
      "Weibull quantile method"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica efficiently implements state-of-the-art data classification \
algorithms, allowing you to search for nearest neighbors and do cluster \
analysis on large datasets. ", "synonyms" -> {}, "title" -> 
    "Exploratory Data Analysis", "type" -> "Guide", "uri" -> 
    "guide/DataClassification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 275, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[967, 37, 421, 12, 70, "GuideText",
 CellID->317656092],
Cell[1391, 51, 1444, 38, 70, "InlineGuideFunctionListing",
 CellID->43530358],
Cell[2838, 91, 48, 1, 70, "GuideDelimiter",
 CellID->401084901],
Cell[2889, 94, 435, 12, 70, "GuideText",
 CellID->1463276848],
Cell[3327, 108, 415, 12, 70, "GuideText",
 CellID->203374175],
Cell[3745, 122, 716, 17, 70, "InlineGuideFunctionListing",
 CellID->373541804],
Cell[CellGroupData[{
Cell[4486, 143, 237, 5, 70, "GuideFunctionsSubsection",
 CellID->320132630],
Cell[4726, 150, 1315, 33, 70, "InlineGuideFunctionListing",
 CellID->432720441],
Cell[6044, 185, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[6095, 188, 351, 12, 70, "GuideText",
 CellID->303951447],
Cell[6449, 202, 243, 9, 70, "GuideText",
 CellID->402139527]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6741, 217, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6806, 220, 180, 4, 70, "GuideTutorial",
 CellID->104670830],
Cell[6989, 226, 144, 3, 70, "GuideTutorial",
 CellID->398138454]
}, Open  ]],
Cell[CellGroupData[{
Cell[7170, 234, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7235, 237, 137, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7375, 242, 169, 4, 70, "GuideMoreAboutSub",
 CellID->17730359],
Cell[7547, 248, 209, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[7759, 255, 163, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7925, 260, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[8120, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

