(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16620,        505]
NotebookOptionsPosition[     10579,        358]
NotebookOutlinePosition[     14079,        422]
CellTagsIndexPosition[     14036,        419]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Integrated Data Sources", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives seamless immediate access to an ever-growing library of carefully \
curated and continually updated data maintained by Wolfram \
Research\[LongDash]all with a unified interface allowing complete \
interoperability and tight integration into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and its computational and data presentation capabilities. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathematical Data \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalData"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->2838695],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalData"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->105894242],

Cell["\t", "GuideDelimiterSubsection",
 CellID->62438884]
}, Open  ]],

Cell[CellGroupData[{

Cell["Physical & Chemical Data", "GuideFunctionsSubsection",
 CellID->445332878],

Cell[TextData[{
 Cell[TextData[ButtonBox["ElementData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ElementData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bulk, atomic, chemical, etc. properties of chemical elements"
}], "GuideText",
 CellID->282183111],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChemicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChemicalData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " structural, reaction and other properties of chemical compounds"
}], "GuideText",
 CellID->214817493],

Cell[TextData[{
 Cell[TextData[ButtonBox["IsotopeData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IsotopeData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " static and decay ",
 "properties of all nuclear isotopes"
}], "GuideText",
 CellID->93364050],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParticleData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParticleData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " properties of stable, unstable and resonance particles"
}], "GuideText",
 CellID->584863432],

Cell[TextData[{
 Cell[TextData[ButtonBox["AstronomicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AstronomicalData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " properties of stars, planets and other objects"
}], "GuideText",
 CellID->189330175],

Cell["\t", "GuideDelimiter",
 CellID->237120944],

Cell[TextData[{
 Cell[TextData[ButtonBox["CountryData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CountryData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " many categories of data about countries, groups, etc."
}], "GuideText",
 CellID->172106582],

Cell[TextData[{
 Cell[TextData[ButtonBox["CityData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CityData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " properties of 250,000+ cities around the world"
}], "GuideText",
 CellID->3916059],

Cell[TextData[{
 Cell[TextData[ButtonBox["FinancialData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FinancialData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " current and historical stock, fund, index, currency, etc. data"
}], "GuideText",
 CellID->4684015],

Cell["\t", "GuideDelimiter",
 CellID->87095979],

Cell[TextData[{
 Cell[TextData[ButtonBox["DictionaryLookup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " use string patterns to look up words in the dictionary"
}], "GuideText",
 CellID->25781825],

Cell[TextData[{
 Cell[TextData[ButtonBox["WordData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WordData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " properties of words and network of relations between them"
}], "GuideText",
 CellID->967288033],

Cell["\t", "GuideDelimiter",
 CellID->431711211],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExampleData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExampleData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " many types of standard test and example data"
}], "GuideText",
 CellID->448272211],

Cell["\t", "GuideDelimiterSubsection",
 CellID->483064801]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Structure", "GuideFunctionsSubsection",
 CellID->263223152],

Cell[TextData[{
 Cell[TextData[ButtonBox["Missing",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Missing"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic representation of missing data"
}], "GuideText",
 CellID->116073768]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "GuideTutorial",
 CellID->134075405]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/guide/UnitsPackage"]], "GuideMoreAbout",
 CellID->574662936],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/guide/PhysicalConstantsPackage"]], \
"GuideMoreAbout",
 CellID->27696735],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/guide/StandardAtmospherePackage"]], \
"GuideMoreAbout",
 CellID->39924716],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/guide/ResonanceAbsorptionLinesPackage"]], \
"GuideMoreAbout",
 CellID->530595695],

Cell[TextData[ButtonBox["World Plotting Package",
 BaseStyle->"Link",
 ButtonData->"paclet:WorldPlot/guide/WorldPlottingPackage"]], "GuideMoreAbout",\

 CellID->172315877],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/guide/GeodesyPackage"]], "GuideMoreAbout",
 CellID->305757027]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1710358994],

Cell[TextData[{
 ButtonBox["Demonstrations related to Integrated Data Sources",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AstronomicalData+OR+ChemicalData+OR+CityData+OR+CountryData+OR+\
DictionaryLookup+OR+ElementData+OR+ExampleData+OR+FinancialData+OR+GraphData+\
OR+IsotopeData+OR+KnotData+OR+LatticeData+OR+Missing+OR+ParticleData+OR+\
PolyhedronData+OR+WordData)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->258951063]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrated Data Sources - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 44.9824696}", "context" -> "", 
    "keywords" -> {
     "alpha decay", "AMEX", "Archimedean polyhedra", "Archimidean polyhedra", 
      "bonds", "chemical compounds", "chemical data", "chemical elements", 
      "chemicals", "chemistry", "city data", "commodities", 
      "computational linguistics", "country data", "currencies", "currency", 
      "data feeds", "data collections", "datafeeds", "demographic data", 
      "dictionary", "dictionary lookup", "dividends", "earnings", "EC-No", 
      "EC number", "economic data", "elementary particles", "element data", 
      "English", "etymology", "example data", "exchange rates", 
      "figure eight", "finance", "financial data", "financial options", 
      "funds", "futures", "geography", "glossary", "grammar", "graph data", 
      "HEP", "high-energy physics", "high-low close", "human language", 
      "hypernym", "hyponym", "International Chemical Identifier", 
      "isotope data", "knot", "knot data", "knot invariants", 
      "knowledge representation", "language", "lattice", "lexicography", 
      "lexicology", "lexicon", "Lie algebras", "Lie groups", "linguistics", 
      "market cap", "market index", "Matrix Market", "MatrixMarket", 
      "molecular weight", "molecules", "mutual funds", "NASD", "NASDAQ", 
      "natural language", "natural language processing", "network data", 
      "neutrons", "NLP", "nuclear data", "nuclear isomers", "nuclei", 
      "nuclide", "NYSE", "particle data", "particle physics", 
      "parts of speech", "PDG", "PEG ratio", "PE ratio", "philology", 
      "phrase structure", "physical chemistry", "Platonic solids", 
      "polyhedron data", "polytopes", "price data", "protons", 
      "radioactivity", "regular polyhedra", "resonance particles", 
      "root lattices", "Rosenfeld tables", "sample data", "Schlaefli symbol", 
      "Schla\"fli symbol", "securities", "security", "semantics", 
      "semantic tagging", "semiology", "semiotics", "sentence structure", 
      "spoken language", "stocks", "subatomic physics", "symbolic AI", 
      "test data", "thesaurus", "trading", "trading volume", "trefoil", 
      "unknot", "USD", "Wenninger model", "word data", "word tagging", 
      "world data", "written language", "Wythoff symbol", ".wdx file"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica gives seamless immediate access to an ever-growing library \
of carefully curated and continually updated data maintained by Wolfram \
Research--all with a unified interface allowing complete interoperability and \
tight integration into Mathematica and its computational and data \
presentation capabilities. ", "synonyms" -> {}, "title" -> 
    "Integrated Data Sources", "type" -> "Guide", "uri" -> 
    "guide/DataCollections"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 471, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1183, 43, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->2838695],
Cell[1405, 50, 1480, 38, 70, "InlineGuideFunctionListing",
 CellID->105894242],
Cell[2888, 90, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->62438884]
}, Open  ]],
Cell[CellGroupData[{
Cell[2982, 96, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->445332878],
Cell[3065, 99, 435, 11, 70, "GuideText",
 CellID->282183111],
Cell[3503, 112, 295, 8, 70, "GuideText",
 CellID->214817493],
Cell[3801, 122, 430, 12, 70, "GuideText",
 CellID->93364050],
Cell[4234, 136, 286, 8, 70, "GuideText",
 CellID->584863432],
Cell[4523, 146, 286, 8, 70, "GuideText",
 CellID->189330175],
Cell[4812, 156, 48, 1, 70, "GuideDelimiter",
 CellID->237120944],
Cell[4863, 159, 428, 11, 70, "GuideText",
 CellID->172106582],
Cell[5294, 172, 413, 11, 70, "GuideText",
 CellID->3916059],
Cell[5710, 185, 294, 8, 70, "GuideText",
 CellID->4684015],
Cell[6007, 195, 47, 1, 70, "GuideDelimiter",
 CellID->87095979],
Cell[6057, 198, 438, 11, 70, "GuideText",
 CellID->25781825],
Cell[6498, 211, 426, 11, 70, "GuideText",
 CellID->967288033],
Cell[6927, 224, 48, 1, 70, "GuideDelimiter",
 CellID->431711211],
Cell[6978, 227, 419, 11, 70, "GuideText",
 CellID->448272211],
Cell[7400, 240, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->483064801]
}, Open  ]],
Cell[CellGroupData[{
Cell[7495, 246, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->263223152],
Cell[7568, 249, 411, 12, 70, "GuideText",
 CellID->116073768]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8028, 267, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8093, 270, 303, 9, 70, "GuideTutorial",
 CellID->134075405]
}, Open  ]],
Cell[CellGroupData[{
Cell[8433, 284, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8498, 287, 154, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[8655, 292, 148, 3, 70, "GuideMoreAbout",
 CellID->574662936],
Cell[8806, 297, 189, 5, 70, "GuideMoreAbout",
 CellID->27696735],
Cell[8998, 304, 192, 5, 70, "GuideMoreAbout",
 CellID->39924716],
Cell[9193, 311, 212, 5, 70, "GuideMoreAbout",
 CellID->530595695],
Cell[9408, 318, 171, 4, 70, "GuideMoreAbout",
 CellID->172315877],
Cell[9582, 324, 154, 3, 70, "GuideMoreAbout",
 CellID->305757027]
}, Open  ]],
Cell[CellGroupData[{
Cell[9773, 332, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1710358994],
Cell[9846, 335, 691, 18, 70, "GuideRelatedLinks",
 CellID->258951063]
}, Open  ]],
Cell[10552, 356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

