(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18875,        541]
NotebookOptionsPosition[     13341,        404]
NotebookOutlinePosition[     16506,        464]
CellTagsIndexPosition[     16463,        461]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Descriptive Statistics", "GuideTitle",
 CellID->15881],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s descriptive statistics functions operate both on explicit data, and on \
symbolic representations of statistical distributions",
 ". ",
 "When operating on explicit data, the functions  routinely handle huge \
datasets\[LongDash]which can contain not only numbers, but also symbolic \
elements representing, for example, parametrized or unknown data. "
}], "GuideAbstract",
 CellID->24884093],

Cell[CellGroupData[{

Cell["Location Measures", "GuideFunctionsSubsection",
 CellID->793011620],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Median",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Median"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootMeanSquare",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrimmedMean",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TrimmedMean"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HarmonicMean",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HarmonicMean"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeometricMean",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GeometricMean"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->7354688]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dispersion Measures", "GuideFunctionsSubsection",
 CellID->213395470],

Cell[TextData[{
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StandardDeviation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StandardDeviation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeanDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MedianDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MedianDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QuartileDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuartileDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InterquartileRange",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InterquartileRange"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->375730191]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shape Measures", "GuideFunctionsSubsection",
 CellID->56228215],

Cell[TextData[{
 Cell[TextData[ButtonBox["Skewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Skewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kurtosis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Kurtosis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QuartileSkewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuartileSkewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->21886089]
}, Open  ]],

Cell[CellGroupData[{

Cell["General Measures", "GuideFunctionsSubsection",
 CellID->324884031],

Cell[TextData[{
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quartiles",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Quartiles"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CentralMoment",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CentralMoment"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->63384984]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Features of Distributions", "GuideFunctionsSubsection",
 CellID->131939498],

Cell[TextData[{
 Cell[TextData[ButtonBox["CDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseCDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InverseCDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CharacteristicFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->757432339],

Cell["\t", "GuideDelimiterSubsection",
 CellID->213236890]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Measures", "GuideFunctionsSubsection",
 CellID->272362762],

Cell[TextData[{
 Cell[TextData[ButtonBox["Covariance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Covariance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Correlation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Correlation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->402194851]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->27611],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->30877],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "GuideTutorial",
 CellID->20424],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "GuideTutorial",
 CellID->634501723],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->32678],

Cell[TextData[ButtonBox["Data Transforms & Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "GuideMoreAbout",
 CellID->1752],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->18443],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "GuideMoreAbout",
 CellID->64505465],

Cell[TextData[ButtonBox["Random Sampling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "GuideMoreAboutSub",
 CellID->12673],

Cell[TextData[ButtonBox["Distance & Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DistanceAndDissimilarityMeasures"]], "GuideMoreAboutSub",
 CellID->10040],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"]], \
"GuideMoreAboutSub",
 CellID->1891277696]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1406969357],

Cell[TextData[{
 ButtonBox["Demonstrations related to Descriptive Statistics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BinCounts+OR+CDF+OR+CentralMoment+OR+CharacteristicFunction+OR+Commonest+OR+\
ExpectedValue+OR+GeometricMean+OR+HarmonicMean+OR+InterquartileRange+OR+\
InverseCDF+OR+Kurtosis+OR+Mean+OR+MeanDeviation+OR+Median+OR+MedianDeviation+\
OR+PDF+OR+Quantile+OR+QuartileDeviation+OR+Quartiles+OR+QuartileSkewness+OR+\
RootMeanSquare+OR+Skewness+OR+StandardDeviation+OR+TrimmedMean+OR+Variance)"],
     None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->502480503]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Descriptive Statistics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 50.5138612}", "context" -> "", 
    "keywords" -> {
     "2nd quartile", "50th percentile", "asymmetry", "average", "avg", 
      "bin counts", "binning", "category counts", "CDF", "central moment", 
      "central value", "cf", "characteristic function", 
      "confidence intervals", "cumulative distribution function", "deciles", 
      "density estimation", "density function", "dispersion", "distribution", 
      "distribution function", "empirical distribution", "expectation", 
      "expected value", "Fisher kurtosis", "Fisher's kurtosis", 
      "geometric mean", "GM", "harmonic mean", "heavy tails", "hinges", 
      "histogram", "HM", "interquartile range", "inverse CDF", 
      "inverse cumulative distribution function", 
      "inverse distribution function", "iqr", "kurtosis", "kurtosis excess", 
      "location", "location statistic", "long tails", "lower quartile", 
      "mass function", "mean", "mean deviation", "mean square residual", 
      "median", "median deviation", "mode", "modified arithmetic mean", 
      "modified mean", "moment generating function", "most frequent value", 
      "order statistics", "percentiles", "prob", 
      "probability density function", "probability distribution", 
      "probability function", "probability mass function", "quantile", 
      "quartile deviation", "quartiles", "quartile skewness", "range counts", 
      "RMS", "robust estimate", "robust estimates", "robust estimation", 
      "robust location estimate", "root-mean-square", "root mean square", 
      "sample moments", "sample standard deviation", "sample variance", 
      "semi-interquartile range", "shape", "shape statistic", "skew", 
      "skewness", "spread", "standard deviation", "standard error", 
      "statistical expectation", "statistical mode", "trimmed mean", 
      "truncated mean", "upper quartile", "VAR", "variance", 
      "Weibull quantile method"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's descriptive statistics functions operate both on explicit \
data, and on symbolic representations of statistical distributions. When \
operating on explicit data, the functions routinely handle huge \
datasets--which can contain not only numbers, but also symbolic elements \
representing, for example, parametrized or unknown data. ", "synonyms" -> {}, 
    "title" -> "Descriptive Statistics", "type" -> "Guide", "uri" -> 
    "guide/DescriptiveStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->15881],
Cell[682, 28, 462, 10, 70, "GuideAbstract",
 CellID->24884093],
Cell[CellGroupData[{
Cell[1169, 42, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->793011620],
Cell[1245, 45, 2185, 56, 70, "InlineGuideFunctionListing",
 CellID->7354688]
}, Open  ]],
Cell[CellGroupData[{
Cell[3467, 106, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->213395470],
Cell[3545, 109, 1888, 47, 70, "InlineGuideFunctionListing",
 CellID->375730191]
}, Open  ]],
Cell[CellGroupData[{
Cell[5470, 161, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->56228215],
Cell[5542, 164, 1054, 26, 70, "InlineGuideFunctionListing",
 CellID->21886089]
}, Open  ]],
Cell[CellGroupData[{
Cell[6633, 195, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->324884031],
Cell[6708, 198, 1260, 32, 70, "InlineGuideFunctionListing",
 CellID->63384984]
}, Open  ]],
Cell[CellGroupData[{
Cell[8005, 235, 90, 1, 70, "GuideFunctionsSubsection",
 CellID->131939498],
Cell[8098, 238, 1767, 44, 70, "InlineGuideFunctionListing",
 CellID->757432339],
Cell[9868, 284, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->213236890]
}, Open  ]],
Cell[CellGroupData[{
Cell[9963, 290, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->272362762],
Cell[10043, 293, 406, 11, 70, "InlineGuideFunctionListing",
 CellID->402194851]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10498, 310, 58, 1, 70, "GuideTutorialsSection",
 CellID->27611],
Cell[10559, 313, 146, 3, 70, "GuideTutorial",
 CellID->30877],
Cell[10708, 318, 158, 3, 70, "GuideTutorial",
 CellID->20424],
Cell[10869, 323, 166, 3, 70, "GuideTutorial",
 CellID->634501723],
Cell[11038, 328, 163, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[11238, 336, 59, 1, 70, "GuideMoreAboutSection",
 CellID->32678],
Cell[11300, 339, 165, 3, 70, "GuideMoreAbout",
 CellID->1752],
Cell[11468, 344, 164, 4, 70, "GuideMoreAbout",
 CellID->18443],
Cell[11635, 350, 165, 3, 70, "GuideMoreAbout",
 CellID->64505465],
Cell[11803, 355, 153, 3, 70, "GuideMoreAboutSub",
 CellID->12673],
Cell[11959, 360, 184, 4, 70, "GuideMoreAboutSub",
 CellID->10040],
Cell[12146, 366, 209, 5, 70, "GuideMoreAboutSub",
 CellID->1891277696]
}, Open  ]],
Cell[CellGroupData[{
Cell[12392, 376, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1406969357],
Cell[12465, 379, 834, 20, 70, "GuideRelatedLinks",
 CellID->502480503]
}, Open  ]],
Cell[13314, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

