(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11706,        373]
NotebookOptionsPosition[      7071,        259]
NotebookOutlinePosition[      9977,        316]
CellTagsIndexPosition[      9934,        313]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Differential Equations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Automatically selecting between hundreds of powerful and in many cases \
original algorithms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides both numerical and symbolic solving of differential equations \
(ODEs, PDEs, DAEs, ...). With",
 StyleBox[" ",
  FontSlant->"Italic"],
 "equations conveniently specified symbolically, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses both its rich set of special functions and its unique symbolic \
interpolating functions to represent solutions in forms that can immediately \
be manipulated or visualized."
}], "GuideAbstract",
 CellID->568540312],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["y",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"], "TI"],
  ButtonBox["'",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"], "TI"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Derivative",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Derivative"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " derivative of a function"
}], "GuideText",
 CellID->130962641],

Cell["\t", "GuideDelimiter",
 CellID->611616336],

Cell[TextData[{
 Cell[TextData[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic solution to differential equations"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->71326001],

Cell[TextData[{
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical solution to differential equations"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolatingFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interpolating function used in solutions"
}], "GuideText",
 CellID->574664301],

Cell[CellGroupData[{

Cell["Options", "GuideFunctionsSubsection",
 CellID->95963629],

Cell[TextData[{
 Cell[TextData[ButtonBox["AccuracyGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrecisionGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WorkingPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell[TextData[{
 Cell[TextData[ButtonBox["Method",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Method"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "select and tune many possible solver algorithms"
}], "GuideText",
 CellID->29577249],

Cell[TextData[{
 Cell[TextData[ButtonBox["StepMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StepMonitor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["EvaluationMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "monitor the progress of a solution"
}], "GuideText",
 CellID->386424673]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "GuideTutorial",
 CellID->142354631],

Cell[TextData[ButtonBox["Numerical Differential Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalDifferentialEquations"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[{
 ButtonBox["Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "GuideTutorial",
 CellID->101336946]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:EquationTrekker/guide/EquationTrekkerPackage"]], "GuideMoreAboutSub",\

 CellID->308654610],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "GuideMoreAbout",
 CellID->230862802],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"GuideMoreAboutSub",
 CellID->22278485],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->131638546]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->440218754],

Cell[TextData[{
 ButtonBox["Demonstrations related to Differential Equations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AccuracyGoal+OR+DSolve+OR+EvaluationMonitor+OR+InterpolatingFunction+OR+\
Method+OR+NDSolve+OR+PrecisionGoal+OR+StepMonitor+OR+WorkingPrecision)"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->77406482]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differential Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 51.8420202}", "context" -> "", 
    "keywords" -> {
     "Abel equation", "Abramov algorithm", "absolute error", "accuracy goal", 
      "accuracy of result", "Adams methods", "adaptive procedure", 
      "Airy's differential equation", "analytical solution", 
      "approximate functions", "BDF methods", "Bernoulli equation", 
      "boundary conditions", "Bronstein algorithm", "BVPs", "chasing method", 
      "closed-form solution", "DAE", "DAEs", "decimal places", "diff", 
      "diffeq", "differential-algebraic equations", "differential equations", 
      "evaluation monitor", "gear method", "Gel'fand-Lokutsiyevskii method", 
      "Gelfand-Lokutsiyevskii method", "Hamilton-Jacobi equations", 
      "homogeneous differential equations", 
      "inhomogeneous differential equations", "initial conditions", 
      "intermediate results", "interpolating function", "Kamke", 
      "Kovacic algorithm", "linear differential equations", "LSODA", 
      "Mellin transform methods", "method of lines", 
      "multivariate differential equations", 
      "nonlinear differential equations", 
      "numerical solution of differential equations", "ODE", 
      "ordinary differential equations", "partial differential equations", 
      "PDE", "phase plots", "piecewise differential equations", 
      "piecewise polynomial interpolation", "precision", "precision goal", 
      "Riccati equations", "Runge-Kutta methods", "singularities", 
      "solving differential equations", "step monitor", "symmetry reduction", 
      "working precision"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Automatically selecting between hundreds of powerful and in many cases \
original algorithms, Mathematica provides both numerical and symbolic solving \
of differential equations (ODEs, PDEs, DAEs, ...). With equations \
conveniently specified symbolically, Mathematica uses both its rich set of \
special functions and its unique symbolic interpolating functions to \
represent solutions in forms that can immediately be manipulated or \
visualized.", "synonyms" -> {}, "title" -> "Differential Equations", "type" -> 
    "Guide", "uri" -> "guide/DifferentialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 635, 16, 70, "GuideAbstract",
 CellID->568540312],
Cell[1324, 46, 741, 27, 70, "GuideText",
 CellID->130962641],
Cell[2068, 75, 48, 1, 70, "GuideDelimiter",
 CellID->611616336],
Cell[2119, 78, 268, 9, 70, "GuideText",
 CellID->203374175],
Cell[2390, 89, 47, 1, 70, "GuideDelimiter",
 CellID->71326001],
Cell[2440, 92, 272, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2715, 103, 295, 9, 70, "GuideText",
 CellID->574664301],
Cell[CellGroupData[{
Cell[3035, 116, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->95963629],
Cell[3100, 119, 637, 17, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[3740, 138, 271, 9, 70, "GuideText",
 CellID->29577249],
Cell[4014, 149, 414, 13, 70, "GuideText",
 CellID->386424673]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4477, 168, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4542, 171, 174, 3, 70, "GuideTutorial",
 CellID->142354631],
Cell[4719, 176, 184, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[4906, 182, 315, 9, 70, "GuideTutorial",
 CellID->1885805579],
Cell[5224, 193, 197, 4, 70, "GuideTutorial",
 CellID->101336946]
}, Open  ]],
Cell[CellGroupData[{
Cell[5458, 202, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5523, 205, 186, 5, 70, "GuideMoreAboutSub",
 CellID->308654610],
Cell[5712, 212, 252, 5, 70, "GuideMoreAbout",
 CellID->230862802],
Cell[5967, 219, 207, 5, 70, "GuideMoreAboutSub",
 CellID->22278485],
Cell[6177, 226, 150, 3, 70, "GuideMoreAbout",
 CellID->131638546]
}, Open  ]],
Cell[CellGroupData[{
Cell[6364, 234, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->440218754],
Cell[6436, 237, 593, 17, 70, "GuideRelatedLinks",
 CellID->77406482]
}, Open  ]],
Cell[7044, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

