(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17766,        560]
NotebookOptionsPosition[     12137,        420]
NotebookOutlinePosition[     15246,        479]
CellTagsIndexPosition[     15203,        476]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Discrete & Integer Data", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Integrated into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system are powerful functions for analyzing large volumes of discrete and \
integer data\[LongDash]often conveniently specified using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s uniquely flexible pattern language. "
}], "GuideAbstract",
 CellID->394800651],

Cell[TextData[{
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "successive differences"
}], "GuideText",
 CellID->3196175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cumulative sums"
}], "GuideText",
 CellID->423208704],

Cell[TextData[{
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Median",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Median"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->464442860],

Cell["\t", "GuideDelimiter",
 CellID->83487088],

Cell[TextData[{
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "unique elements in a single list or between lists"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " tally distinct elements, listing them with their multiplicities"
}], "GuideText",
 CellID->277099145],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count, list elements in a sequence of bins"
}], "GuideText",
 CellID->147297296],

Cell["\t", "GuideDelimiter",
 CellID->185019724],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list elements matching a pattern"
}], "GuideText",
 CellID->303951447],

Cell[TextData[{
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count elements matching a pattern"
}], "GuideText",
 CellID->384466151],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "positions of elements"
}], "GuideText",
 CellID->24321080],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Split",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Split"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complement"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Intersection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Intersection"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->167459621],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["list",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"],
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"],
  StyleBox[ButtonBox["rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " replace elements according to a rule"
}], "GuideText",
 CellID->283726079],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Distance Measures \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DistanceAndDissimilarityMeasures"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->320132630],

Cell[TextData[{
 Cell[TextData[ButtonBox["HammingDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HammingDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatchingDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EditDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EditDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->101714351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathematical Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DiscreteMathematics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->38837007],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HermiteDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DiscreteMathematics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5733929]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting to Other Forms", "GuideFunctionsSubsection",
 CellID->7471605],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayRules"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["position", "TI"], "\[Rule]", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " sparse array form"
}], "GuideText",
 CellID->228317151],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to numbers, polynomials, etc."
}], "GuideText",
 CellID->30040251],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to a string"
}], "GuideText",
 CellID->536101614],

Cell["\t", "GuideDelimiterSubsection",
 CellID->91365990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Visualization \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->749001243],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorRules"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataVisualization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->522253646]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "GuideTutorial",
 CellID->96548103],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Discrete & Integer Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 53.2483062}", "context" -> "", 
    "keywords" -> {
     "2nd quartile", "50th percentile", "absent from list", 
      "aggregating data", "arrange", "array plot", "array rules", 
      "ascending order", "average", "avg", "basis vectors", "bin counts", 
      "bin lists", "binning", "binning of data", "canonical order", 
      "categorizing data", "category counts", "census", "central value", 
      "collation", "color rules", "column sum", "combinatorial algorithms", 
      "combining lists", "compensated summation", 
      "construct string from expression", "convert expression", "criteria", 
      "decreasing order", "density estimation", "descending order", 
      "difference of sets", "disjointness", "distinct elements in lists", 
      "encode", "encoding", "equivalence class counting", "expectation", 
      "expected value", "extended GCD", "frequencies", "from digits", 
      "gather", "grade in APL", "Hermite decomposition", "histogram", 
      "increasing order", "indices", "integer digits", "lattice reduce", 
      "Lenstra-Lenstra-Lovasz algorithm", "levels", "Levenshtein distance", 
      "linear Diophantine equations", "list complement", "lists", 
      "lists ordering", "LLL algorithm", "location", "matching dissimilarity",
       "matrix structure plot", "mean", "median", "merging lists", "mode", 
      "most frequent value", "multiplicities", "number conversion", 
      "number of occurrences", "number reconstruction", "order statistics", 
      "overlap between lists", "point plot", "range counts", "reconstruction",
       "remove duplicates", "row sum", "run-length encoding", 
      "run length encoding", "scatter plot", "search", "sets", 
      "simple matching", "sorting of lists", 
      "specify elements in sparse array", "statistical mode", 
      "subtraction of sets", "sum of array elements", "sum of list", "tally", 
      "textual form of expression", "total of list", "union of sets", "uniq", 
      "unique elements in lists"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Integrated into the Mathematica system are powerful functions for \
analyzing large volumes of discrete and integer data--often conveniently \
specified using Mathematica's uniquely flexible pattern language. ", 
    "synonyms" -> {}, "title" -> "Discrete & Integer Data", "type" -> "Guide",
     "uri" -> "guide/DiscreteAndIntegerData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 362, 10, 70, "GuideAbstract",
 CellID->394800651],
Cell[1052, 40, 400, 12, 70, "GuideText",
 CellID->3196175],
Cell[1455, 54, 393, 12, 70, "GuideText",
 CellID->423208704],
Cell[1851, 68, 941, 26, 70, "InlineGuideFunctionListing",
 CellID->464442860],
Cell[2795, 96, 47, 1, 70, "GuideDelimiter",
 CellID->83487088],
Cell[2845, 99, 272, 9, 70, "GuideText",
 CellID->203374175],
Cell[3120, 110, 426, 11, 70, "GuideText",
 CellID->277099145],
Cell[3549, 123, 690, 19, 70, "GuideText",
 CellID->147297296],
Cell[4242, 144, 48, 1, 70, "GuideDelimiter",
 CellID->185019724],
Cell[4293, 147, 255, 9, 70, "GuideText",
 CellID->303951447],
Cell[4551, 158, 256, 9, 70, "GuideText",
 CellID->384466151],
Cell[4810, 169, 249, 9, 70, "GuideText",
 CellID->24321080],
Cell[5062, 180, 810, 23, 70, "InlineGuideFunctionListing",
 CellID->167459621],
Cell[5875, 205, 463, 16, 70, "GuideText",
 CellID->283726079],
Cell[CellGroupData[{
Cell[6363, 225, 237, 5, 70, "GuideFunctionsSubsection",
 CellID->320132630],
Cell[6603, 232, 1087, 26, 70, "InlineGuideFunctionListing",
 CellID->101714351]
}, Open  ]],
Cell[CellGroupData[{
Cell[7727, 263, 229, 5, 70, "GuideFunctionsSubsection",
 CellID->38837007],
Cell[7959, 270, 789, 20, 70, "InlineGuideFunctionListing",
 CellID->5733929]
}, Open  ]],
Cell[CellGroupData[{
Cell[8785, 295, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->7471605],
Cell[8867, 298, 380, 13, 70, "GuideText",
 CellID->228317151],
Cell[9250, 313, 269, 9, 70, "GuideText",
 CellID->30040251],
Cell[9522, 324, 248, 9, 70, "GuideText",
 CellID->536101614],
Cell[9773, 335, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->91365990]
}, Open  ]],
Cell[CellGroupData[{
Cell[9867, 341, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->749001243],
Cell[10088, 348, 824, 23, 70, "InlineGuideFunctionListing",
 CellID->522253646]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10961, 377, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11026, 380, 151, 3, 70, "GuideTutorial",
 CellID->96548103],
Cell[11180, 385, 198, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[11381, 391, 150, 3, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[11568, 399, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11633, 402, 145, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[11781, 407, 156, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[11940, 412, 155, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[12110, 418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

